package Interfaces
   extends Modelica.Icons.Library;
   annotation (Documentation(info="<html>
 <p>
 This package contains connectors and interfaces (partial models) for
 analog electrical components.
 </p>
 
 <dl>
 <dt>
 <b>Main Authors:</b>
 <dd>
 <a href=\"http://people.eas.iis.fhg.de/Christoph.Clauss/\">Christoph Clau&szlig;</a>
     &lt;<a href=\"mailto:clauss@eas.iis.fhg.de\">clauss@eas.iis.fhg.de</a>&gt;<br>
     <a href=\"http://people.eas.iis.fhg.de/Andre.Schneider/\">Andr&eacute; Schneider</a>
     &lt;<a href=\"mailto:schneider@eas.iis.fhg.de\">schneider@eas.iis.fhg.de</a>&gt;<br>
     Fraunhofer Institute for Integrated Circuits<br>
     Design Automation Department<br>
     Zeunerstra&szlig;e 38<br>
     D-01069 Dresden<br>
 
 <p>
 <dt>
 <b>Version:</b>
 <dd>
 $Id: Interfaces.mo,v 1.10 2003/10/31 11:11:34 SvenErik Exp $<br>
 <p>
 <dt>
 <b>Copyright:</b>
 <dd>
 Copyright &copy; 1998-2002, Modelica Association and Fraunhofer-Gesellschaft.<br>
 <i>The Modelica package is <b>free</b> software; it can be redistributed and/or modified
 under the terms of the <b>Modelica license</b>, see the license conditions
 and the accompanying <b>disclaimer</b> in the documentation of package
 Modelica in file \"Modelica/package.mo\".</i><br>
 <p>
 </dl>
 </HTML>
 "));
   connector Pin "Pin of an electrical component"
      SI.Voltage v "Potential at the pin";
      flow SI.Current i "Current flowing into the pin";
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={0,0,255},fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={0,0,255},fillPattern=FillPattern.Solid),Text(extent={{-100.,-120.},{100.,-220.}},textString="%name",fillColor={0,0,255})}));
   end Pin;
   connector PositivePin "Positive pin of an electric component"
      SI.Voltage v "Potential at the pin";
      flow SI.Current i "Current flowing into the pin";
      annotation (Documentation(info="<html><p>Connectors PositivePin
 and NegativePin are nearly identical.
 The only difference is that the icons are different in order
 to identify more easily the pins of a component. Usually,
 connector PositivePin is used for the positive and
 connector NegativePin for the negative pin of an electrical
 component.</p></html>"),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={0,0,255},fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={0,0,255},fillPattern=FillPattern.Solid),Text(extent={{-100.,-120.},{100.,-220.}},textString="%name",fillColor={0,0,255})}));
   end PositivePin;
   connector NegativePin "Negative pin of an electric component"
      SI.Voltage v "Potential at the pin";
      flow SI.Current i "Current flowing into the pin";
      annotation (Documentation(info="<html><p>Connectors PositivePin
 and NegativePin are nearly identical.
 The only difference is that the icons are different in order
 to identify more easily the pins of a component. Usually,
 connector PositivePin is used for the positive and
 connector NegativePin for the negative pin of an electrical
 component.</p></html>"),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={255,255,255},fillPattern=FillPattern.Solid)}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Rectangle(extent={{-100.,100.},{100.,-100.}},lineColor={0,0,255},fillColor={255,255,255},fillPattern=FillPattern.Solid),Text(extent={{-100.,-120.},{100.,-220.}},textString="%name",fillColor={0,0,255})}));
   end NegativePin;
   partial model TwoPin "Component with one electrical port"
      SI.Voltage v "Voltage drop between the two pins (= p.v - n.v)";
      PositivePin p "Positive pin" annotation (Placement(transformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.)));
      NegativePin n "Negative pin" annotation (Placement(transformation(x=100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=0.,scale=0.1,aspectRatio=1.)));
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Polygon(points={{-120.,3.},{-110.,0.},{-120.,-3.},{-120.,3.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Line(points={{-136.,0.},{-111.,0.}},color={160,160,160}),Text(extent={{-134.,5.},{-117.,20.}},textString="p.i",fillColor={160,160,160}),Line(points={{110.,0.},{135.,0.}},color={160,160,160}),Polygon(points={{120.,3.},{110.,0.},{120.,-3.},{120.,3.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Text(extent={{117.,3.},{134.,18.}},textString="n.i",fillColor={160,160,160})}));
      
   equation
      v = p.v-n.v;
   end TwoPin;
   partial model OnePort "Component with two electrical pins p and n and current i from p to n"
      SI.Voltage v "Voltage drop between the two pins (= p.v - n.v)";
      SI.Current i "Current flowing from pin p to pin n";
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Documentation(info="<HTML>
 <P>
 Superclass of elements which have <b>two</b> electrical pins:
 the positive pin connector <i>p</i>, and the negative pin
 connector <i>n</i>. It is assumed that the current flowing
 into pin p is identical to the current flowing out of pin n.
 This current is provided explicitly as current i.
 </P>
 </HTML>
 "),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{-110.,20.},{-85.,20.}},color={160,160,160}),Polygon(points={{-95.,23.},{-85.,20.},{-95.,17.},{-95.,23.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Line(points={{90.,20.},{115.,20.}},color={160,160,160}),Line(points={{-125.,0.},{-115.,0.}},color={160,160,160}),Line(points={{-120.,-5.},{-120.,5.}},color={160,160,160}),Text(extent={{-110.,25.},{-90.,45.}},textString="i",fillColor={160,160,160}),Polygon(points={{105.,23.},{115.,20.},{105.,17.},{105.,23.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Line(points={{115.,0.},{125.,0.}},color={160,160,160}),Text(extent={{90.,45.},{110.,25.}},textString="i",fillColor={160,160,160})}));
      PositivePin p annotation (Placement(transformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.)));
      NegativePin n annotation (Placement(transformation(x=100.,y=0.,scale=0.1,aspectRatio=1.,flipHorizontal=true),iconTransformation(x=100.,y=0.,scale=0.1,aspectRatio=1.,flipHorizontal=true)));
      
   equation
      v = p.v-n.v;
      0 = p.i+n.i;
      i = p.i;
   end OnePort;
   partial model TwoPort "Component with two electrical ports, including current"
      SI.Voltage v1 "Voltage drop over the left port";
      SI.Voltage v2 "Voltage drop over the right port";
      SI.Current i1 "Current flowing from pos. to neg. pin of the left port";
      SI.Current i2 "Current flowing from pos. to neg. pin of the right port";
      PositivePin p1 "Positive pin of the left port" annotation (Placement(transformation(x=-100.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=50.,scale=0.1,aspectRatio=1.)));
      NegativePin n1 "Negative pin of the left port" annotation (Placement(transformation(x=-100.,y=-50.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=-50.,scale=0.1,aspectRatio=1.)));
      PositivePin p2 "Positive pin of the right port" annotation (Placement(transformation(x=100.,y=50.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=50.,scale=0.1,aspectRatio=1.)));
      NegativePin n2 "Negative pin of the right port" annotation (Placement(transformation(x=100.,y=-50.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=-50.,scale=0.1,aspectRatio=1.)));
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Polygon(points={{-120.,53.},{-110.,50.},{-120.,47.},{-120.,53.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Line(points={{-136.,50.},{-111.,50.}},color={160,160,160}),Polygon(points={{127.,-47.},{137.,-50.},{127.,-53.},{127.,-47.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Line(points={{111.,-50.},{136.,-50.}},color={160,160,160}),Text(extent={{112.,-44.},{128.,-29.}},textString="i2",fillColor={160,160,160}),Text(extent={{118.,52.},{135.,67.}},textString="i2",fillColor={0,0,0},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Polygon(points={{120.,53.},{110.,50.},{120.,47.},{120.,53.}},lineColor={0,0,0},fillColor={160,160,160},pattern=LinePattern.None,fillPattern=FillPattern.HorizontalCylinder),Line(points={{111.,50.},{136.,50.}},color={160,160,160}),Line(points={{-136.,-49.},{-111.,-49.}},color={160,160,160}),Polygon(points={{-126.,-46.},{-136.,-49.},{-126.,-52.},{-126.,-46.}},lineColor={160,160,160},fillColor={160,160,160},fillPattern=FillPattern.Solid),Text(extent={{-127.,-46.},{-110.,-31.}},textString="i1",fillColor={160,160,160}),Text(extent={{-136.,53.},{-119.,68.}},textString="i1",fillColor={160,160,160})}));
      
   equation
      v1 = p1.v-n1.v;
      v2 = p2.v-n2.v;
      0 = p1.i+n1.i;
      0 = p2.i+n2.i;
      i1 = p1.i;
      i2 = p2.i;
   end TwoPort;
   partial model AbsoluteSensor "Base class to measure the absolute value of a pin variable"
      extends Modelica.Icons.RotationalSensor;
      PositivePin p "pin to be measured" annotation (Placement(transformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.)));
      Modelica.Blocks.Interfaces.OutPort outPort(final n=1) annotation (Placement(transformation(x=110.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=110.,y=0.,scale=0.1,aspectRatio=1.)));
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{-70.,0.},{-90.,0.}},color={0,0,0}),Line(points={{70.,0.},{100.,0.}},color={0,0,255}),Text(extent={{-110.,80.},{110.,120.}},textString="%name",fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{-70.,0.},{-90.,0.}},color={0,0,0}),Line(points={{70.,0.},{100.,0.}},color={0,0,255})}));
   end AbsoluteSensor;
   partial model RelativeSensor "Base class to measure a relative variable between two pins"
      extends Modelica.Icons.RotationalSensor;
      PositivePin p "positive pin" annotation (Placement(transformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=-100.,y=0.,scale=0.1,aspectRatio=1.)));
      NegativePin n "negative pin" annotation (Placement(transformation(x=100.,y=0.,scale=0.1,aspectRatio=1.),iconTransformation(x=100.,y=0.,scale=0.1,aspectRatio=1.)));
      Modelica.Blocks.Interfaces.OutPort outPort(final n=1) annotation (Placement(transformation(x=0.,y=-100.,scale=0.1,aspectRatio=1.,rotation=90,flipVertical=true),iconTransformation(x=0.,y=-100.,scale=0.1,aspectRatio=1.,rotation=90,flipVertical=true)));
      annotation (Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{-70.,0.},{-90.,0.}},color={0,0,0}),Line(points={{70.,0.},{90.,0.}},color={0,0,0}),Line(points={{0.,-90.},{0.,-70.}},color={0,0,255}),Text(extent={{-110.,80.},{110.,120.}},textString="%name",fillColor={0,0,255})}),Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Line(points={{-70.,0.},{-90.,0.}},color={0,0,0}),Line(points={{0.,-90.},{0.,-70.}},color={0,0,255}),Line(points={{70.,0.},{90.,0.}},color={0,0,0})}));
   end RelativeSensor;
   partial model VoltageSource "Interface for voltage sources"
      extends OnePort;
      parameter SI.Voltage offset=0 "Voltage offset";
      parameter SI.Time startTime=0 "Time offset";
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{-50.,50.},{50.,-50.}},lineColor={0,0,255},fillColor={255,255,255},fillPattern=FillPattern.Solid),Line(points={{-90.,0.},{-50.,0.}},color={0,0,255}),Line(points={{50.,0.},{90.,0.}},color={0,0,255}),Text(extent={{-100.,-120.},{100.,-80.}},textString="%name=%V",fillColor={0,0,255}),Line(points={{-50.,0.},{50.,0.}},color={0,0,255})}));
      replaceable Modelica.Blocks.Interfaces.SignalSource signalSource(final offset={offset},final startTime={startTime}) annotation (Placement(transformation(x=80.,y=80.,scale=0.1,aspectRatio=1.),iconTransformation(x=80.,y=80.,scale=0.1,aspectRatio=1.)));
      
   equation
      v = signalSource.outPort.signal[1];
   end VoltageSource;
   partial model CurrentSource "Interface for current sources"
      extends OnePort;
      parameter SI.Current offset=0 "Current offset";
      parameter SI.Time startTime=0 "Time offset";
      annotation (Diagram(coordinateSystem(extent={{-100.,-100.},{100.,100.}})),Icon(coordinateSystem(extent={{-100.,-100.},{100.,100.}}),graphics={Ellipse(extent={{-50.,50.},{50.,-50.}},lineColor={0,0,255},fillColor={255,255,255},fillPattern=FillPattern.Solid),Line(points={{-90.,0.},{-50.,0.}},color={0,0,255}),Line(points={{50.,0.},{90.,0.}},color={0,0,255}),Line(points={{0.,-50.},{0.,50.}},color={0,0,255}),Text(extent={{-100.,-120.},{100.,-80.}},textString="%name=%I",fillColor={0,0,255})}));
      replaceable Modelica.Blocks.Interfaces.SignalSource signalSource(final offset={offset},final startTime={startTime}) annotation (Placement(transformation(x=79.5,y=80.,scale=0.105,aspectRatio=0.9523809523809523),iconTransformation(x=79.5,y=80.,scale=0.105,aspectRatio=0.9523809523809523)));
      
   equation
      i = signalSource.outPort.signal[1];
   end CurrentSource;
end Interfaces;