List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Demonstration of Access Control", "Title"], Cell[TextData[List["\nMembers of a Modelica class can have two levels of visibility: ", StyleBox["public", Rule[FontFamily, "Courier"]], " or ", StyleBox["protected", Rule[FontFamily, "Courier"]], ". The default is ", StyleBox["public", Rule[FontFamily, "Courier"]], " if nothing else is specified. Publically declared variables can be  can be read or updated by any code with access to that class. Variables that are declared protected can be reched only by code inside the class as well as code in classes that inherit this class. However, only code inside the class is allowed access to the same instance of a protected variable. You can read more about ", ButtonBox["Private and Protected Elements", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Inheritance"], "ProtectedElements.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], "."]], "Text"], Cell[CellGroupData[List[Cell["AccessDemo", "Section"], Cell[TextData[List["The variables ", StyleBox["a, x, z ", Rule[FontFamily, "Courier"]], "and ", StyleBox["u3", Rule[FontFamily, "Courier"]], " is public and ", StyleBox["w, u ", Rule[FontFamily, "Courier"]], "and ", StyleBox["u2", Rule[FontFamily, "Courier"]], " are protected in the ", StyleBox["AccessDemo", Rule[FontFamily, "Courier"]], " class"]], "Text"], Cell[TextData[List["class AccessDemo \t\t\t\"Illustration of access prefixes\"\n  \t\t\tparameter Real a = 2;\n  ", StyleBox["public", Rule[FontColor, RGBColor[0, 0, 1]]], " \tReal x, z;\n  \t\t\tparameter Real y;\n  protected\n  \t\t\tparameter Real w, u;\n  \t\t\tReal u2;\n  ", StyleBox["public", Rule[FontColor, RGBColor[0, 0, 1]]], " \tReal u3;\nequation\t\n ", StyleBox[" x  = 2;\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since code inside the class", StyleBox["\n  z  = 5;\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since code inside the class", StyleBox["\n  u2 = 5;\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since code inside the class", StyleBox["\n  u3 = 8;  \t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since code inside the class", "\nend AccessDemo;  \t\t\t\t\t\t"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of AccessDemo", "Section"], Cell["simulate( AccessDemo );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AccessDemo\\) : 2004-2-2 14:30:3.0085742 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"u3\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["A", "Section"], Cell[TextData[List["In ", StyleBox["A", Rule[FontFamily, "Courier"]], " an illegal modification is done, since ", StyleBox["w", Rule[FontFamily, "Courier"]], " is protected it can not be modified if ", StyleBox["AccessDemo", Rule[FontFamily, "Courier"]], " is not inherited."]], "Text"], Cell[TextData[List["class A\n  ", StyleBox["AccessDemo ad(a = 2, y = 7, w = 7); ", Rule[FontColor, RGBColor[1, 0, 0]]], "// Illegal, since AccessDemo is not inherited", "\nend A;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of AccessDemo, A and B", "Section"], Cell[TextData[List["Here we can see that if we try to simulate class ", StyleBox["A", Rule[FontFamily, "Courier"]], " with the erroneous modification\"w = 7\" we get a warning for trying to modify a protected variable."]], "Text"], Cell["simulate( A );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(A\\) : 2004-2-2 14:30:8.8992746 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\(ad . a\\), HoldForm], \\*TagBox[\\(ad . u3\\), HoldForm], \\*TagBox[\\(ad . x\\), HoldForm], \\*TagBox[\\(ad . y\\), HoldForm], \\*TagBox[\\(ad . z\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell["getLog();", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\nWarning: Modifier for protected component w. This is not legal Modelica.\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 90\\\\n  Context: A.ad.w\\\\nOriginal declaration of w:\\\\n  File: c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo, line 101\\\\n  Context: AccessDemo.w\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"A\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 2\\\\n  Variables: 8\\\\n    Constants: 0\\\\n    Parameters: 4 (4 scalars)\\\\n    Unknowns: 4 (4 scalars)\\\\n    Differentiated variables: 0\\\\n  Equations: 4\\\\n    Nontrivial : 0\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 4 scalars\\\\n  Free parameters: 4 scalars\\\\n  Parameter depending: 0\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nWarning: The following parameter has no default value\\\\n  ad.u\\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"]], Open]], Cell[CellGroupData[List[Cell["B", "Section"], Cell[TextData[List["In the class B ", StyleBox["AccessDemo", Rule[FontFamily, "Courier"]], " is inherited, then it is legal to change the value u", StyleBox["2", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class B\n  extends AccessDemo;\n  Real p, q;\nequation\n ", StyleBox[" u2 = p;\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since AccessDemo is inherited", StyleBox["\n  u3 = q;  \t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Legal, since u3 is public", "\nend B;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of B", "Section"], Cell["simulate( B );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(B\\) : 2004-2-2 14:30:15.6024854 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"p\\\", HoldForm], \\*TagBox[\\\"q\\\", HoldForm], \\*TagBox[\\\"u3\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[879, 907]], Rule[WindowMargins, List[List[84, Automatic], List[0, Automatic]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]