List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Assert", "Title"], Cell[TextData[List["\nThe ", StyleBox["assert", Rule[FontFamily, "Courier"]], " statement provides a convenient means for specifying checks on model validity within a model. The ", StyleBox["assert", Rule[FontFamily, "Courier"]], " expression in an assert statement should normally evaluate to true. When the assertion evaluates to false, the message in the second argument will be displayed to the user and the simulation will stop. The class ", StyleBox["AssertTest", Rule[FontFamily, "Courier"]], " contains an example of the use of ", StyleBox["assert", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["class AssertTest\n  parameter Real lowlimit;\n  parameter Real highlimit;\n  Real x = 5;\nalgorithm\n  assert(x >= lowlimit and x <= highlimit, \"Variable x out of limit\");  \nend AssertTest;", "ModelicaInput"], Cell["", "Text"], Cell["class Test1\n  AssertTest assertTsest(lowlimit = 4, highlimit = 8);\nend Test1;", "ModelicaInput"], Cell["", "Text"], Cell["class Test2\n  AssertTest assertTsest(lowlimit = 6, highlimit = 20);\nend Test2;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Test1 and Test2 ", "Section"], Cell["simulate( Test1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Test1\\) : 2004-1-30 14:50:58.1300336 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\(assertTsest . highlimit\\), HoldForm], \\*TagBox[\\(assertTsest . lowlimit\\), HoldForm], \\*TagBox[\\(assertTsest . x\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["In the simulation of ", StyleBox["Test2", Rule[FontFamily, "Courier"]], " we see that an error occurs and by looking in the file dslog.txt we see that the assertion fails and returns the message \"Variable x out of limit\"."]], "Text"], Cell["simulate( Test2, stopTime=10 );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "smmd"]], RowBox[List[":", " "]], "\"Simulate failed to simulate \\!\\(Test2\\).\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"Test2\\\\\\\")\\\\nTranslation started\\\\n  \\\\nSTATISTICS\\\\n  \\\\nOriginal Model\\\\n  Number of components: 2\\\\n  Variables: 3\\\\n    Constants: 0\\\\n    Parameters: 2 (2 scalars)\\\\n    Unknowns: 1 (1 scalars)\\\\n    Differentiated variables: 0\\\\n  Equations: 2\\\\n    Nontrivial : 1\\\\n\\\\n   \\\\nTranslated Model\\\\n  Constants: 1 scalars\\\\n  Free parameters: 2 scalars\\\\n  Parameter depending: 0\\\\n  Inputs: 0\\\\n  Outputs: 0\\\\n  Continuous time states: 0\\\\n  Time-varying variables: 0\\\\n  Alias variables: 0\\\\n  Number of mixed real/discrete systems of equations: 0\\\\n  Sizes of linear systems of equations: { }\\\\n  Sizes after manipulation of the linear systems: { }\\\\n  Sizes of nonlinear systems of equations: { }\\\\n  Sizes after manipulation of the nonlinear systems: { }\\\\n  Number of numerical Jacobians: 0\\\\n   \\\\nFinished\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowSimulationLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Log-file of program .\\\\\\\\dymosim\\\\n(generated: Fri Jan 30 14:51:08 2004)\\\\n\\\\ndymosim started (dymosim version 4.6, Dec 21, 2001)\\\\n... \\\\\\\"dsin.txt\\\\\\\" loading (dymosim input file)\\\\nAssertion failed: assertTsest.x >= assertTsest.lowlimit and assertTsest.x <= assertTsest.highlimit\\\\nThe following error was detected at time: 0\\\\nVariable x out of limit\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[822, 907]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]