List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Exercise 5", "Title"], Cell[CellGroupData[List[Cell["reinit", "Section"], Cell[TextData[List["Write a model ", StyleBox["BilliardBalls", Rule[FontFamily, "Courier"]], ", with two billiard balls that is rolling from opposite directions and bounces into each other. "]], "Text"], Cell["", "ModelicaInput"], Cell[CellGroupData[List[Cell["Tip", "Subsection"], Cell[TextData[List[StyleBox["reinit(x, value)", Rule[FontFamily, "Courier"]], " is the sam thing as ", StyleBox["x := value", Rule[FontFamily, "Courier"]], ", but ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " reinitializes the value of x at a specific time and the equations still holds."]], "Text"]], Closed]], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell[CellGroupData[List[Cell["BilliardBalls", "Subsubsection"], Cell["model BilliardBalls\n  parameter Real c = 0.9;\t\t\t\t// Elasticity constant of balls\n  Real position1(start = 1);\t\t\t// Position of ball 1\n  Real position2(start = 10);\t\t\t// Position of ball 2\n  Real velocity1(start = 10);  \t\t\t// Velocity of ball 1\n  Real velocity2(start = -15);\t\t\t// Velocity of ball 2\nequation\n  der(position1) = velocity1;\n  der(position2) = velocity2;\n  der(velocity1) = 0;\n  der(velocity2) = 0;\nalgorithm\n  when position1 >= position2 then\n    reinit(velocity1, -c*velocity1);\n    reinit(velocity2, -c*velocity2);    \n  end when;  \nend BilliardBalls;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Simulation of BilliardBalls", "Subsubsection"], Cell["simulate( BilliardBalls );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(BilliardBalls\\) : 2004-1-30 14:59:10.0554037 : \\!\\({0.`, 1.`}\\) : 505 data points : 2 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"position1\\\", HoldForm], \\*TagBox[\\\"position2\\\", HoldForm], \\*TagBox[\\\"velocity1\\\", HoldForm], \\*TagBox[\\\"velocity2\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"position1\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"position2\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"velocity1\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"velocity2\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( { velocity1, velocity2, position1, position2 } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.324507 0.0206528 [\n[.21429 .31201 -9 -9 ]\n[.21429 .31201 9 0 ]\n[.40476 .31201 -9 -9 ]\n[.40476 .31201 9 0 ]\n[.59524 .31201 -9 -9 ]\n[.59524 .31201 9 0 ]\n[.78571 .31201 -9 -9 ]\n[.78571 .31201 9 0 ]\n[.97619 .31201 -3 -9 ]\n[.97619 .31201 3 0 ]\n[1.025 .32451 0 -6.28125 ]\n[1.025 .32451 10 6.28125 ]\n[.01131 .01472 -18 -4.5 ]\n[.01131 .01472 0 4.5 ]\n[.01131 .11798 -18 -4.5 ]\n[.01131 .11798 0 4.5 ]\n[.01131 .22124 -12 -4.5 ]\n[.01131 .22124 0 4.5 ]\n[.01131 .42777 -6 -4.5 ]\n[.01131 .42777 0 4.5 ]\n[.01131 .53103 -12 -4.5 ]\n[.01131 .53103 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .32451 m\n.21429 .33076 L\ns\n[(0.2)] .21429 .31201 0 1 Mshowa\n.40476 .32451 m\n.40476 .33076 L\ns\n[(0.4)] .40476 .31201 0 1 Mshowa\n.59524 .32451 m\n.59524 .33076 L\ns\n[(0.6)] .59524 .31201 0 1 Mshowa\n.78571 .32451 m\n.78571 .33076 L\ns\n[(0.8)] .78571 .31201 0 1 Mshowa\n.97619 .32451 m\n.97619 .33076 L\ns\n[(1)] .97619 .31201 0 1 Mshowa\n.125 Mabswid\n.07143 .32451 m\n.07143 .32826 L\ns\n.11905 .32451 m\n.11905 .32826 L\ns\n.16667 .32451 m\n.16667 .32826 L\ns\n.2619 .32451 m\n.2619 .32826 L\ns\n.30952 .32451 m\n.30952 .32826 L\ns\n.35714 .32451 m\n.35714 .32826 L\ns\n.45238 .32451 m\n.45238 .32826 L\ns\n.5 .32451 m\n.5 .32826 L\ns\n.54762 .32451 m\n.54762 .32826 L\ns\n.64286 .32451 m\n.64286 .32826 L\ns\n.69048 .32451 m\n.69048 .32826 L\ns\n.7381 .32451 m\n.7381 .32826 L\ns\n.83333 .32451 m\n.83333 .32826 L\ns\n.88095 .32451 m\n.88095 .32826 L\ns\n.92857 .32451 m\n.92857 .32826 L\ns\n.25 Mabswid\n0 .32451 m\n1 .32451 L\ns\ngsave\n1.025 .32451 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01472 m\n.03006 .01472 L\ns\n[(-15)] .01131 .01472 1 0 Mshowa\n.02381 .11798 m\n.03006 .11798 L\ns\n[(-10)] .01131 .11798 1 0 Mshowa\n.02381 .22124 m\n.03006 .22124 L\ns\n[(-5)] .01131 .22124 1 0 Mshowa\n.02381 .42777 m\n.03006 .42777 L\ns\n[(5)] .01131 .42777 1 0 Mshowa\n.02381 .53103 m\n.03006 .53103 L\ns\n[(10)] .01131 .53103 1 0 Mshowa\n.125 Mabswid\n.02381 .03537 m\n.02756 .03537 L\ns\n.02381 .05602 m\n.02756 .05602 L\ns\n.02381 .07667 m\n.02756 .07667 L\ns\n.02381 .09733 m\n.02756 .09733 L\ns\n.02381 .13863 m\n.02756 .13863 L\ns\n.02381 .15928 m\n.02756 .15928 L\ns\n.02381 .17994 m\n.02756 .17994 L\ns\n.02381 .20059 m\n.02756 .20059 L\ns\n.02381 .2419 m\n.02756 .2419 L\ns\n.02381 .26255 m\n.02756 .26255 L\ns\n.02381 .2832 m\n.02756 .2832 L\ns\n.02381 .30385 m\n.02756 .30385 L\ns\n.02381 .34516 m\n.02756 .34516 L\ns\n.02381 .36581 m\n.02756 .36581 L\ns\n.02381 .38646 m\n.02756 .38646 L\ns\n.02381 .40712 m\n.02756 .40712 L\ns\n.02381 .44842 m\n.02756 .44842 L\ns\n.02381 .46908 m\n.02756 .46908 L\ns\n.02381 .48973 m\n.02756 .48973 L\ns\n.02381 .51038 m\n.02756 .51038 L\ns\n.02381 .55169 m\n.02756 .55169 L\ns\n.02381 .57234 m\n.02756 .57234 L\ns\n.02381 .59299 m\n.02756 .59299 L\ns\n.02381 .61365 m\n.02756 .61365 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .53103 m\n.02571 .53103 L\n.02762 .53103 L\n.02952 .53103 L\n.03143 .53103 L\n.03333 .53103 L\n.03524 .53103 L\n.03714 .53103 L\n.03905 .53103 L\n.04095 .53103 L\n.04286 .53103 L\n.04476 .53103 L\n.04667 .53103 L\n.04857 .53103 L\n.05048 .53103 L\n.05238 .53103 L\n.05429 .53103 L\n.05619 .53103 L\n.0581 .53103 L\n.06 .53103 L\n.0619 .53103 L\n.06381 .53103 L\n.06571 .53103 L\n.06762 .53103 L\n.06952 .53103 L\n.07143 .53103 L\n.07333 .53103 L\n.07524 .53103 L\n.07714 .53103 L\n.07905 .53103 L\n.08095 .53103 L\n.08286 .53103 L\n.08476 .53103 L\n.08667 .53103 L\n.08857 .53103 L\n.09048 .53103 L\n.09238 .53103 L\n.09429 .53103 L\n.09619 .53103 L\n.0981 .53103 L\n.1 .53103 L\n.1019 .53103 L\n.10381 .53103 L\n.10571 .53103 L\n.10762 .53103 L\n.10952 .53103 L\n.11143 .53103 L\n.11333 .53103 L\n.11524 .53103 L\n.11714 .53103 L\nMistroke\n.11905 .53103 L\n.12095 .53103 L\n.12286 .53103 L\n.12476 .53103 L\n.12667 .53103 L\n.12857 .53103 L\n.13048 .53103 L\n.13238 .53103 L\n.13429 .53103 L\n.13619 .53103 L\n.1381 .53103 L\n.14 .53103 L\n.1419 .53103 L\n.14381 .53103 L\n.14571 .53103 L\n.14762 .53103 L\n.14952 .53103 L\n.15143 .53103 L\n.15333 .53103 L\n.15524 .53103 L\n.15714 .53103 L\n.15905 .53103 L\n.16095 .53103 L\n.16286 .53103 L\n.16476 .53103 L\n.16667 .53103 L\n.16857 .53103 L\n.17048 .53103 L\n.17238 .53103 L\n.17429 .53103 L\n.17619 .53103 L\n.1781 .53103 L\n.18 .53103 L\n.1819 .53103 L\n.18381 .53103 L\n.18571 .53103 L\n.18762 .53103 L\n.18952 .53103 L\n.19143 .53103 L\n.19333 .53103 L\n.19524 .53103 L\n.19714 .53103 L\n.19905 .53103 L\n.20095 .53103 L\n.20286 .53103 L\n.20476 .53103 L\n.20667 .53103 L\n.20857 .53103 L\n.21048 .53103 L\n.21238 .53103 L\nMistroke\n.21429 .53103 L\n.21619 .53103 L\n.2181 .53103 L\n.22 .53103 L\n.2219 .53103 L\n.22381 .53103 L\n.22571 .53103 L\n.22762 .53103 L\n.22952 .53103 L\n.23143 .53103 L\n.23333 .53103 L\n.23524 .53103 L\n.23714 .53103 L\n.23905 .53103 L\n.24095 .53103 L\n.24286 .53103 L\n.24476 .53103 L\n.24667 .53103 L\n.24857 .53103 L\n.25048 .53103 L\n.25238 .53103 L\n.25429 .53103 L\n.25619 .53103 L\n.2581 .53103 L\n.26 .53103 L\n.2619 .53103 L\n.26381 .53103 L\n.26571 .53103 L\n.26762 .53103 L\n.26952 .53103 L\n.27143 .53103 L\n.27333 .53103 L\n.27524 .53103 L\n.27714 .53103 L\n.27905 .53103 L\n.28095 .53103 L\n.28286 .53103 L\n.28476 .53103 L\n.28667 .53103 L\n.28857 .53103 L\n.29048 .53103 L\n.29238 .53103 L\n.29429 .53103 L\n.29619 .53103 L\n.2981 .53103 L\n.3 .53103 L\n.3019 .53103 L\n.30381 .53103 L\n.30571 .53103 L\n.30762 .53103 L\nMistroke\n.30952 .53103 L\n.31143 .53103 L\n.31333 .53103 L\n.31524 .53103 L\n.31714 .53103 L\n.31905 .53103 L\n.32095 .53103 L\n.32286 .53103 L\n.32476 .53103 L\n.32667 .53103 L\n.32857 .53103 L\n.33048 .53103 L\n.33238 .53103 L\n.33429 .53103 L\n.33619 .53103 L\n.3381 .53103 L\n.34 .53103 L\n.3419 .53103 L\n.34381 .53103 L\n.34571 .53103 L\n.34762 .53103 L\n.34952 .53103 L\n.35143 .53103 L\n.35333 .53103 L\n.35524 .53103 L\n.35714 .53103 L\n.35905 .53103 L\n.36095 .53103 L\n.36286 .53103 L\n.36476 .53103 L\n.36667 .53103 L\n.36667 .53103 L\n.36667 .13863 L\n.36667 .13863 L\n.36857 .13863 L\n.37048 .13863 L\n.37238 .13863 L\n.37429 .13863 L\n.37619 .13863 L\n.3781 .13863 L\n.38 .13863 L\n.3819 .13863 L\n.38381 .13863 L\n.38571 .13863 L\n.38762 .13863 L\n.38952 .13863 L\n.39143 .13863 L\n.39333 .13863 L\n.39524 .13863 L\n.39714 .13863 L\nMistroke\n.39905 .13863 L\n.40095 .13863 L\n.40286 .13863 L\n.40476 .13863 L\n.40667 .13863 L\n.40857 .13863 L\n.41048 .13863 L\n.41238 .13863 L\n.41429 .13863 L\n.41619 .13863 L\n.4181 .13863 L\n.42 .13863 L\n.4219 .13863 L\n.42381 .13863 L\n.42571 .13863 L\n.42762 .13863 L\n.42952 .13863 L\n.43143 .13863 L\n.43333 .13863 L\n.43524 .13863 L\n.43714 .13863 L\n.43905 .13863 L\n.44095 .13863 L\n.44286 .13863 L\n.44476 .13863 L\n.44667 .13863 L\n.44857 .13863 L\n.45048 .13863 L\n.45238 .13863 L\n.45429 .13863 L\n.45619 .13863 L\n.4581 .13863 L\n.46 .13863 L\n.4619 .13863 L\n.46381 .13863 L\n.46571 .13863 L\n.46762 .13863 L\n.46952 .13863 L\n.47143 .13863 L\n.47333 .13863 L\n.47524 .13863 L\n.47714 .13863 L\n.47905 .13863 L\n.48095 .13863 L\n.48286 .13863 L\n.48476 .13863 L\n.48667 .13863 L\n.48857 .13863 L\n.49048 .13863 L\n.49238 .13863 L\nMistroke\n.49429 .13863 L\n.49619 .13863 L\n.4981 .13863 L\n.5 .13863 L\n.5019 .13863 L\n.50381 .13863 L\n.50571 .13863 L\n.50762 .13863 L\n.50952 .13863 L\n.51143 .13863 L\n.51333 .13863 L\n.51524 .13863 L\n.51714 .13863 L\n.51905 .13863 L\n.52095 .13863 L\n.52286 .13863 L\n.52476 .13863 L\n.52667 .13863 L\n.52857 .13863 L\n.53048 .13863 L\n.53238 .13863 L\n.53429 .13863 L\n.53619 .13863 L\n.5381 .13863 L\n.54 .13863 L\n.5419 .13863 L\n.54381 .13863 L\n.54571 .13863 L\n.54762 .13863 L\n.54952 .13863 L\n.55143 .13863 L\n.55333 .13863 L\n.55524 .13863 L\n.55714 .13863 L\n.55905 .13863 L\n.56095 .13863 L\n.56286 .13863 L\n.56476 .13863 L\n.56667 .13863 L\n.56857 .13863 L\n.57048 .13863 L\n.57238 .13863 L\n.57429 .13863 L\n.57619 .13863 L\n.5781 .13863 L\n.58 .13863 L\n.5819 .13863 L\n.58381 .13863 L\n.58571 .13863 L\n.58762 .13863 L\nMistroke\n.58952 .13863 L\n.59143 .13863 L\n.59333 .13863 L\n.59524 .13863 L\n.59714 .13863 L\n.59905 .13863 L\n.60095 .13863 L\n.60286 .13863 L\n.60476 .13863 L\n.60667 .13863 L\n.60857 .13863 L\n.61048 .13863 L\n.61238 .13863 L\n.61429 .13863 L\n.61619 .13863 L\n.6181 .13863 L\n.62 .13863 L\n.6219 .13863 L\n.62381 .13863 L\n.62571 .13863 L\n.62762 .13863 L\n.62952 .13863 L\n.63143 .13863 L\n.63333 .13863 L\n.63524 .13863 L\n.63714 .13863 L\n.63905 .13863 L\n.64095 .13863 L\n.64286 .13863 L\n.64476 .13863 L\n.64667 .13863 L\n.64857 .13863 L\n.65048 .13863 L\n.65238 .13863 L\n.65429 .13863 L\n.65619 .13863 L\n.6581 .13863 L\n.66 .13863 L\n.6619 .13863 L\n.66381 .13863 L\n.66571 .13863 L\n.66762 .13863 L\n.66952 .13863 L\n.67143 .13863 L\n.67333 .13863 L\n.67524 .13863 L\n.67714 .13863 L\n.67905 .13863 L\n.68095 .13863 L\n.68286 .13863 L\nMistroke\n.68476 .13863 L\n.68667 .13863 L\n.68857 .13863 L\n.69048 .13863 L\n.69238 .13863 L\n.69429 .13863 L\n.69619 .13863 L\n.6981 .13863 L\n.7 .13863 L\n.7019 .13863 L\n.70381 .13863 L\n.70571 .13863 L\n.70762 .13863 L\n.70952 .13863 L\n.71143 .13863 L\n.71333 .13863 L\n.71524 .13863 L\n.71714 .13863 L\n.71905 .13863 L\n.72095 .13863 L\n.72286 .13863 L\n.72476 .13863 L\n.72667 .13863 L\n.72857 .13863 L\n.73048 .13863 L\n.73238 .13863 L\n.73429 .13863 L\n.73619 .13863 L\n.7381 .13863 L\n.74 .13863 L\n.7419 .13863 L\n.74381 .13863 L\n.74571 .13863 L\n.74762 .13863 L\n.74952 .13863 L\n.75143 .13863 L\n.75333 .13863 L\n.75524 .13863 L\n.75714 .13863 L\n.75905 .13863 L\n.76095 .13863 L\n.76286 .13863 L\n.76476 .13863 L\n.76667 .13863 L\n.76857 .13863 L\n.77048 .13863 L\n.77238 .13863 L\n.77429 .13863 L\n.77619 .13863 L\n.7781 .13863 L\nMistroke\n.78 .13863 L\n.7819 .13863 L\n.78381 .13863 L\n.78571 .13863 L\n.78762 .13863 L\n.78952 .13863 L\n.79143 .13863 L\n.79333 .13863 L\n.79524 .13863 L\n.79714 .13863 L\n.79905 .13863 L\n.80095 .13863 L\n.80286 .13863 L\n.80476 .13863 L\n.80667 .13863 L\n.80857 .13863 L\n.81048 .13863 L\n.81238 .13863 L\n.81429 .13863 L\n.81619 .13863 L\n.8181 .13863 L\n.82 .13863 L\n.8219 .13863 L\n.82381 .13863 L\n.82571 .13863 L\n.82762 .13863 L\n.82952 .13863 L\n.83143 .13863 L\n.83333 .13863 L\n.83524 .13863 L\n.83714 .13863 L\n.83905 .13863 L\n.84095 .13863 L\n.84286 .13863 L\n.84476 .13863 L\n.84667 .13863 L\n.84857 .13863 L\n.85048 .13863 L\n.85238 .13863 L\n.85429 .13863 L\n.85619 .13863 L\n.8581 .13863 L\n.86 .13863 L\n.8619 .13863 L\n.86381 .13863 L\n.86571 .13863 L\n.86762 .13863 L\n.86952 .13863 L\n.87143 .13863 L\n.87333 .13863 L\nMistroke\n.87524 .13863 L\n.87714 .13863 L\n.87905 .13863 L\n.88095 .13863 L\n.88286 .13863 L\n.88476 .13863 L\n.88667 .13863 L\n.88857 .13863 L\n.89048 .13863 L\n.89238 .13863 L\n.89429 .13863 L\n.89619 .13863 L\n.8981 .13863 L\n.9 .13863 L\n.9019 .13863 L\n.90381 .13863 L\n.90571 .13863 L\n.90762 .13863 L\n.90952 .13863 L\n.91143 .13863 L\n.91333 .13863 L\n.91524 .13863 L\n.91714 .13863 L\n.91905 .13863 L\n.92095 .13863 L\n.92286 .13863 L\n.92476 .13863 L\n.92667 .13863 L\n.92857 .13863 L\n.93048 .13863 L\n.93238 .13863 L\n.93429 .13863 L\n.93619 .13863 L\n.9381 .13863 L\n.94 .13863 L\n.9419 .13863 L\n.94381 .13863 L\n.94571 .13863 L\n.94762 .13863 L\n.94952 .13863 L\n.95143 .13863 L\n.95333 .13863 L\n.95524 .13863 L\n.95714 .13863 L\n.95905 .13863 L\n.96095 .13863 L\n.96286 .13863 L\n.96476 .13863 L\n.96667 .13863 L\n.96857 .13863 L\nMistroke\n.97048 .13863 L\n.97238 .13863 L\n.97429 .13863 L\n.97619 .13863 L\nMfstroke\n0 .5 0 r\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36667 .01472 L\n.36667 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\nMistroke\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\nMistroke\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\nMistroke\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\nMistroke\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\nMistroke\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\nMistroke\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\nMistroke\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n1 0 0 r\n.02381 .34516 m\n.02571 .34557 L\n.02762 .34599 L\n.02952 .3464 L\n.03143 .34681 L\n.03333 .34722 L\n.03524 .34764 L\n.03714 .34805 L\n.03905 .34846 L\n.04095 .34888 L\n.04286 .34929 L\n.04476 .3497 L\n.04667 .35012 L\n.04857 .35053 L\n.05048 .35094 L\n.05238 .35136 L\n.05429 .35177 L\n.05619 .35218 L\n.0581 .35259 L\n.06 .35301 L\n.0619 .35342 L\n.06381 .35383 L\n.06571 .35425 L\n.06762 .35466 L\n.06952 .35507 L\n.07143 .35549 L\n.07333 .3559 L\n.07524 .35631 L\n.07714 .35672 L\n.07905 .35714 L\n.08095 .35755 L\n.08286 .35796 L\n.08476 .35838 L\n.08667 .35879 L\n.08857 .3592 L\n.09048 .35962 L\n.09238 .36003 L\n.09429 .36044 L\n.09619 .36086 L\n.0981 .36127 L\n.1 .36168 L\n.1019 .36209 L\n.10381 .36251 L\n.10571 .36292 L\n.10762 .36333 L\n.10952 .36375 L\n.11143 .36416 L\n.11333 .36457 L\n.11524 .36499 L\n.11714 .3654 L\nMistroke\n.11905 .36581 L\n.12095 .36623 L\n.12286 .36664 L\n.12476 .36705 L\n.12667 .36746 L\n.12857 .36788 L\n.13048 .36829 L\n.13238 .3687 L\n.13429 .36912 L\n.13619 .36953 L\n.1381 .36994 L\n.14 .37036 L\n.1419 .37077 L\n.14381 .37118 L\n.14571 .37159 L\n.14762 .37201 L\n.14952 .37242 L\n.15143 .37283 L\n.15333 .37325 L\n.15524 .37366 L\n.15714 .37407 L\n.15905 .37449 L\n.16095 .3749 L\n.16286 .37531 L\n.16476 .37573 L\n.16667 .37614 L\n.16857 .37655 L\n.17048 .37696 L\n.17238 .37738 L\n.17429 .37779 L\n.17619 .3782 L\n.1781 .37862 L\n.18 .37903 L\n.1819 .37944 L\n.18381 .37986 L\n.18571 .38027 L\n.18762 .38068 L\n.18952 .3811 L\n.19143 .38151 L\n.19333 .38192 L\n.19524 .38233 L\n.19714 .38275 L\n.19905 .38316 L\n.20095 .38357 L\n.20286 .38399 L\n.20476 .3844 L\n.20667 .38481 L\n.20857 .38523 L\n.21048 .38564 L\n.21238 .38605 L\nMistroke\n.21429 .38646 L\n.21619 .38688 L\n.2181 .38729 L\n.22 .3877 L\n.2219 .38812 L\n.22381 .38853 L\n.22571 .38894 L\n.22762 .38936 L\n.22952 .38977 L\n.23143 .39018 L\n.23333 .3906 L\n.23524 .39101 L\n.23714 .39142 L\n.23905 .39183 L\n.24095 .39225 L\n.24286 .39266 L\n.24476 .39307 L\n.24667 .39349 L\n.24857 .3939 L\n.25048 .39431 L\n.25238 .39473 L\n.25429 .39514 L\n.25619 .39555 L\n.2581 .39597 L\n.26 .39638 L\n.2619 .39679 L\n.26381 .3972 L\n.26571 .39762 L\n.26762 .39803 L\n.26952 .39844 L\n.27143 .39886 L\n.27333 .39927 L\n.27524 .39968 L\n.27714 .4001 L\n.27905 .40051 L\n.28095 .40092 L\n.28286 .40133 L\n.28476 .40175 L\n.28667 .40216 L\n.28857 .40257 L\n.29048 .40299 L\n.29238 .4034 L\n.29429 .40381 L\n.29619 .40423 L\n.2981 .40464 L\n.3 .40505 L\n.3019 .40547 L\n.30381 .40588 L\n.30571 .40629 L\n.30762 .4067 L\nMistroke\n.30952 .40712 L\n.31143 .40753 L\n.31333 .40794 L\n.31524 .40836 L\n.31714 .40877 L\n.31905 .40918 L\n.32095 .4096 L\n.32286 .41001 L\n.32476 .41042 L\n.32667 .41084 L\n.32857 .41125 L\n.33048 .41166 L\n.33238 .41207 L\n.33429 .41249 L\n.33619 .4129 L\n.3381 .41331 L\n.34 .41373 L\n.3419 .41414 L\n.34381 .41455 L\n.34571 .41497 L\n.34762 .41538 L\n.34952 .41579 L\n.35143 .4162 L\n.35333 .41662 L\n.35524 .41703 L\n.35714 .41744 L\n.35905 .41786 L\n.36095 .41827 L\n.36286 .41868 L\n.36476 .4191 L\n.36667 .41951 L\n.36667 .41951 L\n.36667 .41951 L\n.36667 .41951 L\n.36857 .41914 L\n.37048 .41877 L\n.37238 .41839 L\n.37429 .41802 L\n.37619 .41765 L\n.3781 .41728 L\n.38 .41691 L\n.3819 .41654 L\n.38381 .41616 L\n.38571 .41579 L\n.38762 .41542 L\n.38952 .41505 L\n.39143 .41468 L\n.39333 .4143 L\n.39524 .41393 L\n.39714 .41356 L\nMistroke\n.39905 .41319 L\n.40095 .41282 L\n.40286 .41245 L\n.40476 .41207 L\n.40667 .4117 L\n.40857 .41133 L\n.41048 .41096 L\n.41238 .41059 L\n.41429 .41022 L\n.41619 .40984 L\n.4181 .40947 L\n.42 .4091 L\n.4219 .40873 L\n.42381 .40836 L\n.42571 .40799 L\n.42762 .40761 L\n.42952 .40724 L\n.43143 .40687 L\n.43333 .4065 L\n.43524 .40613 L\n.43714 .40575 L\n.43905 .40538 L\n.44095 .40501 L\n.44286 .40464 L\n.44476 .40427 L\n.44667 .4039 L\n.44857 .40352 L\n.45048 .40315 L\n.45238 .40278 L\n.45429 .40241 L\n.45619 .40204 L\n.4581 .40167 L\n.46 .40129 L\n.4619 .40092 L\n.46381 .40055 L\n.46571 .40018 L\n.46762 .39981 L\n.46952 .39943 L\n.47143 .39906 L\n.47333 .39869 L\n.47524 .39832 L\n.47714 .39795 L\n.47905 .39758 L\n.48095 .3972 L\n.48286 .39683 L\n.48476 .39646 L\n.48667 .39609 L\n.48857 .39572 L\n.49048 .39535 L\n.49238 .39497 L\nMistroke\n.49429 .3946 L\n.49619 .39423 L\n.4981 .39386 L\n.5 .39349 L\n.5019 .39312 L\n.50381 .39274 L\n.50571 .39237 L\n.50762 .392 L\n.50952 .39163 L\n.51143 .39126 L\n.51333 .39088 L\n.51524 .39051 L\n.51714 .39014 L\n.51905 .38977 L\n.52095 .3894 L\n.52286 .38903 L\n.52476 .38865 L\n.52667 .38828 L\n.52857 .38791 L\n.53048 .38754 L\n.53238 .38717 L\n.53429 .3868 L\n.53619 .38642 L\n.5381 .38605 L\n.54 .38568 L\n.5419 .38531 L\n.54381 .38494 L\n.54571 .38456 L\n.54762 .38419 L\n.54952 .38382 L\n.55143 .38345 L\n.55333 .38308 L\n.55524 .38271 L\n.55714 .38233 L\n.55905 .38196 L\n.56095 .38159 L\n.56286 .38122 L\n.56476 .38085 L\n.56667 .38048 L\n.56857 .3801 L\n.57048 .37973 L\n.57238 .37936 L\n.57429 .37899 L\n.57619 .37862 L\n.5781 .37825 L\n.58 .37787 L\n.5819 .3775 L\n.58381 .37713 L\n.58571 .37676 L\n.58762 .37639 L\nMistroke\n.58952 .37601 L\n.59143 .37564 L\n.59333 .37527 L\n.59524 .3749 L\n.59714 .37453 L\n.59905 .37416 L\n.60095 .37378 L\n.60286 .37341 L\n.60476 .37304 L\n.60667 .37267 L\n.60857 .3723 L\n.61048 .37193 L\n.61238 .37155 L\n.61429 .37118 L\n.61619 .37081 L\n.6181 .37044 L\n.62 .37007 L\n.6219 .36969 L\n.62381 .36932 L\n.62571 .36895 L\n.62762 .36858 L\n.62952 .36821 L\n.63143 .36784 L\n.63333 .36746 L\n.63524 .36709 L\n.63714 .36672 L\n.63905 .36635 L\n.64095 .36598 L\n.64286 .36561 L\n.64476 .36523 L\n.64667 .36486 L\n.64857 .36449 L\n.65048 .36412 L\n.65238 .36375 L\n.65429 .36338 L\n.65619 .363 L\n.6581 .36263 L\n.66 .36226 L\n.6619 .36189 L\n.66381 .36152 L\n.66571 .36114 L\n.66762 .36077 L\n.66952 .3604 L\n.67143 .36003 L\n.67333 .35966 L\n.67524 .35929 L\n.67714 .35891 L\n.67905 .35854 L\n.68095 .35817 L\n.68286 .3578 L\nMistroke\n.68476 .35743 L\n.68667 .35706 L\n.68857 .35668 L\n.69048 .35631 L\n.69238 .35594 L\n.69429 .35557 L\n.69619 .3552 L\n.6981 .35482 L\n.7 .35445 L\n.7019 .35408 L\n.70381 .35371 L\n.70571 .35334 L\n.70762 .35297 L\n.70952 .35259 L\n.71143 .35222 L\n.71333 .35185 L\n.71524 .35148 L\n.71714 .35111 L\n.71905 .35074 L\n.72095 .35036 L\n.72286 .34999 L\n.72476 .34962 L\n.72667 .34925 L\n.72857 .34888 L\n.73048 .34851 L\n.73238 .34813 L\n.73429 .34776 L\n.73619 .34739 L\n.7381 .34702 L\n.74 .34665 L\n.7419 .34627 L\n.74381 .3459 L\n.74571 .34553 L\n.74762 .34516 L\n.74952 .34479 L\n.75143 .34442 L\n.75333 .34404 L\n.75524 .34367 L\n.75714 .3433 L\n.75905 .34293 L\n.76095 .34256 L\n.76286 .34219 L\n.76476 .34181 L\n.76667 .34144 L\n.76857 .34107 L\n.77048 .3407 L\n.77238 .34033 L\n.77429 .33995 L\n.77619 .33958 L\n.7781 .33921 L\nMistroke\n.78 .33884 L\n.7819 .33847 L\n.78381 .3381 L\n.78571 .33772 L\n.78762 .33735 L\n.78952 .33698 L\n.79143 .33661 L\n.79333 .33624 L\n.79524 .33587 L\n.79714 .33549 L\n.79905 .33512 L\n.80095 .33475 L\n.80286 .33438 L\n.80476 .33401 L\n.80667 .33364 L\n.80857 .33326 L\n.81048 .33289 L\n.81238 .33252 L\n.81429 .33215 L\n.81619 .33178 L\n.8181 .3314 L\n.82 .33103 L\n.8219 .33066 L\n.82381 .33029 L\n.82571 .32992 L\n.82762 .32955 L\n.82952 .32917 L\n.83143 .3288 L\n.83333 .32843 L\n.83524 .32806 L\n.83714 .32769 L\n.83905 .32732 L\n.84095 .32694 L\n.84286 .32657 L\n.84476 .3262 L\n.84667 .32583 L\n.84857 .32546 L\n.85048 .32508 L\n.85238 .32471 L\n.85429 .32434 L\n.85619 .32397 L\n.8581 .3236 L\n.86 .32323 L\n.8619 .32285 L\n.86381 .32248 L\n.86571 .32211 L\n.86762 .32174 L\n.86952 .32137 L\n.87143 .321 L\n.87333 .32062 L\nMistroke\n.87524 .32025 L\n.87714 .31988 L\n.87905 .31951 L\n.88095 .31914 L\n.88286 .31877 L\n.88476 .31839 L\n.88667 .31802 L\n.88857 .31765 L\n.89048 .31728 L\n.89238 .31691 L\n.89429 .31653 L\n.89619 .31616 L\n.8981 .31579 L\n.9 .31542 L\n.9019 .31505 L\n.90381 .31468 L\n.90571 .3143 L\n.90762 .31393 L\n.90952 .31356 L\n.91143 .31319 L\n.91333 .31282 L\n.91524 .31245 L\n.91714 .31207 L\n.91905 .3117 L\n.92095 .31133 L\n.92286 .31096 L\n.92476 .31059 L\n.92667 .31021 L\n.92857 .30984 L\n.93048 .30947 L\n.93238 .3091 L\n.93429 .30873 L\n.93619 .30836 L\n.9381 .30798 L\n.94 .30761 L\n.9419 .30724 L\n.94381 .30687 L\n.94571 .3065 L\n.94762 .30613 L\n.94952 .30575 L\n.95143 .30538 L\n.95333 .30501 L\n.95524 .30464 L\n.95714 .30427 L\n.95905 .3039 L\n.96095 .30352 L\n.96286 .30315 L\n.96476 .30278 L\n.96667 .30241 L\n.96857 .30204 L\nMistroke\n.97048 .30166 L\n.97238 .30129 L\n.97429 .30092 L\n.97619 .30055 L\nMfstroke\n0 .75 .75 r\n.02381 .53103 m\n.02571 .53041 L\n.02762 .5298 L\n.02952 .52918 L\n.03143 .52856 L\n.03333 .52794 L\n.03524 .52732 L\n.03714 .5267 L\n.03905 .52608 L\n.04095 .52546 L\n.04286 .52484 L\n.04476 .52422 L\n.04667 .5236 L\n.04857 .52298 L\n.05048 .52236 L\n.05238 .52174 L\n.05429 .52112 L\n.05619 .5205 L\n.0581 .51988 L\n.06 .51926 L\n.0619 .51864 L\n.06381 .51802 L\n.06571 .5174 L\n.06762 .51678 L\n.06952 .51616 L\n.07143 .51554 L\n.07333 .51493 L\n.07524 .51431 L\n.07714 .51369 L\n.07905 .51307 L\n.08095 .51245 L\n.08286 .51183 L\n.08476 .51121 L\n.08667 .51059 L\n.08857 .50997 L\n.09048 .50935 L\n.09238 .50873 L\n.09429 .50811 L\n.09619 .50749 L\n.0981 .50687 L\n.1 .50625 L\n.1019 .50563 L\n.10381 .50501 L\n.10571 .50439 L\n.10762 .50377 L\n.10952 .50315 L\n.11143 .50253 L\n.11333 .50191 L\n.11524 .50129 L\n.11714 .50067 L\nMistroke\n.11905 .50006 L\n.12095 .49944 L\n.12286 .49882 L\n.12476 .4982 L\n.12667 .49758 L\n.12857 .49696 L\n.13048 .49634 L\n.13238 .49572 L\n.13429 .4951 L\n.13619 .49448 L\n.1381 .49386 L\n.14 .49324 L\n.1419 .49262 L\n.14381 .492 L\n.14571 .49138 L\n.14762 .49076 L\n.14952 .49014 L\n.15143 .48952 L\n.15333 .4889 L\n.15524 .48828 L\n.15714 .48766 L\n.15905 .48704 L\n.16095 .48642 L\n.16286 .4858 L\n.16476 .48519 L\n.16667 .48457 L\n.16857 .48395 L\n.17048 .48333 L\n.17238 .48271 L\n.17429 .48209 L\n.17619 .48147 L\n.1781 .48085 L\n.18 .48023 L\n.1819 .47961 L\n.18381 .47899 L\n.18571 .47837 L\n.18762 .47775 L\n.18952 .47713 L\n.19143 .47651 L\n.19333 .47589 L\n.19524 .47527 L\n.19714 .47465 L\n.19905 .47403 L\n.20095 .47341 L\n.20286 .47279 L\n.20476 .47217 L\n.20667 .47155 L\n.20857 .47093 L\n.21048 .47032 L\n.21238 .4697 L\nMistroke\n.21429 .46908 L\n.21619 .46846 L\n.2181 .46784 L\n.22 .46722 L\n.2219 .4666 L\n.22381 .46598 L\n.22571 .46536 L\n.22762 .46474 L\n.22952 .46412 L\n.23143 .4635 L\n.23333 .46288 L\n.23524 .46226 L\n.23714 .46164 L\n.23905 .46102 L\n.24095 .4604 L\n.24286 .45978 L\n.24476 .45916 L\n.24667 .45854 L\n.24857 .45792 L\n.25048 .4573 L\n.25238 .45668 L\n.25429 .45606 L\n.25619 .45545 L\n.2581 .45483 L\n.26 .45421 L\n.2619 .45359 L\n.26381 .45297 L\n.26571 .45235 L\n.26762 .45173 L\n.26952 .45111 L\n.27143 .45049 L\n.27333 .44987 L\n.27524 .44925 L\n.27714 .44863 L\n.27905 .44801 L\n.28095 .44739 L\n.28286 .44677 L\n.28476 .44615 L\n.28667 .44553 L\n.28857 .44491 L\n.29048 .44429 L\n.29238 .44367 L\n.29429 .44305 L\n.29619 .44243 L\n.2981 .44181 L\n.3 .44119 L\n.3019 .44058 L\n.30381 .43996 L\n.30571 .43934 L\n.30762 .43872 L\nMistroke\n.30952 .4381 L\n.31143 .43748 L\n.31333 .43686 L\n.31524 .43624 L\n.31714 .43562 L\n.31905 .435 L\n.32095 .43438 L\n.32286 .43376 L\n.32476 .43314 L\n.32667 .43252 L\n.32857 .4319 L\n.33048 .43128 L\n.33238 .43066 L\n.33429 .43004 L\n.33619 .42942 L\n.3381 .4288 L\n.34 .42818 L\n.3419 .42756 L\n.34381 .42694 L\n.34571 .42632 L\n.34762 .42571 L\n.34952 .42509 L\n.35143 .42447 L\n.35333 .42385 L\n.35524 .42323 L\n.35714 .42261 L\n.35905 .42199 L\n.36095 .42137 L\n.36286 .42075 L\n.36476 .42013 L\n.36667 .41951 L\n.36667 .41951 L\n.36667 .41951 L\n.36667 .41951 L\n.36857 .42007 L\n.37048 .42062 L\n.37238 .42118 L\n.37429 .42174 L\n.37619 .4223 L\n.3781 .42286 L\n.38 .42341 L\n.3819 .42397 L\n.38381 .42453 L\n.38571 .42509 L\n.38762 .42564 L\n.38952 .4262 L\n.39143 .42676 L\n.39333 .42732 L\n.39524 .42787 L\n.39714 .42843 L\nMistroke\n.39905 .42899 L\n.40095 .42955 L\n.40286 .4301 L\n.40476 .43066 L\n.40667 .43122 L\n.40857 .43178 L\n.41048 .43233 L\n.41238 .43289 L\n.41429 .43345 L\n.41619 .43401 L\n.4181 .43457 L\n.42 .43512 L\n.4219 .43568 L\n.42381 .43624 L\n.42571 .4368 L\n.42762 .43735 L\n.42952 .43791 L\n.43143 .43847 L\n.43333 .43903 L\n.43524 .43958 L\n.43714 .44014 L\n.43905 .4407 L\n.44095 .44126 L\n.44286 .44181 L\n.44476 .44237 L\n.44667 .44293 L\n.44857 .44349 L\n.45048 .44404 L\n.45238 .4446 L\n.45429 .44516 L\n.45619 .44572 L\n.4581 .44628 L\n.46 .44683 L\n.4619 .44739 L\n.46381 .44795 L\n.46571 .44851 L\n.46762 .44906 L\n.46952 .44962 L\n.47143 .45018 L\n.47333 .45074 L\n.47524 .45129 L\n.47714 .45185 L\n.47905 .45241 L\n.48095 .45297 L\n.48286 .45352 L\n.48476 .45408 L\n.48667 .45464 L\n.48857 .4552 L\n.49048 .45575 L\n.49238 .45631 L\nMistroke\n.49429 .45687 L\n.49619 .45743 L\n.4981 .45799 L\n.5 .45854 L\n.5019 .4591 L\n.50381 .45966 L\n.50571 .46022 L\n.50762 .46077 L\n.50952 .46133 L\n.51143 .46189 L\n.51333 .46245 L\n.51524 .463 L\n.51714 .46356 L\n.51905 .46412 L\n.52095 .46468 L\n.52286 .46523 L\n.52476 .46579 L\n.52667 .46635 L\n.52857 .46691 L\n.53048 .46747 L\n.53238 .46802 L\n.53429 .46858 L\n.53619 .46914 L\n.5381 .4697 L\n.54 .47025 L\n.5419 .47081 L\n.54381 .47137 L\n.54571 .47193 L\n.54762 .47248 L\n.54952 .47304 L\n.55143 .4736 L\n.55333 .47416 L\n.55524 .47471 L\n.55714 .47527 L\n.55905 .47583 L\n.56095 .47639 L\n.56286 .47694 L\n.56476 .4775 L\n.56667 .47806 L\n.56857 .47862 L\n.57048 .47918 L\n.57238 .47973 L\n.57429 .48029 L\n.57619 .48085 L\n.5781 .48141 L\n.58 .48196 L\n.5819 .48252 L\n.58381 .48308 L\n.58571 .48364 L\n.58762 .48419 L\nMistroke\n.58952 .48475 L\n.59143 .48531 L\n.59333 .48587 L\n.59524 .48642 L\n.59714 .48698 L\n.59905 .48754 L\n.60095 .4881 L\n.60286 .48865 L\n.60476 .48921 L\n.60667 .48977 L\n.60857 .49033 L\n.61048 .49089 L\n.61238 .49144 L\n.61429 .492 L\n.61619 .49256 L\n.6181 .49312 L\n.62 .49367 L\n.6219 .49423 L\n.62381 .49479 L\n.62571 .49535 L\n.62762 .4959 L\n.62952 .49646 L\n.63143 .49702 L\n.63333 .49758 L\n.63524 .49813 L\n.63714 .49869 L\n.63905 .49925 L\n.64095 .49981 L\n.64286 .50036 L\n.64476 .50092 L\n.64667 .50148 L\n.64857 .50204 L\n.65048 .5026 L\n.65238 .50315 L\n.65429 .50371 L\n.65619 .50427 L\n.6581 .50483 L\n.66 .50538 L\n.6619 .50594 L\n.66381 .5065 L\n.66571 .50706 L\n.66762 .50761 L\n.66952 .50817 L\n.67143 .50873 L\n.67333 .50929 L\n.67524 .50984 L\n.67714 .5104 L\n.67905 .51096 L\n.68095 .51152 L\n.68286 .51207 L\nMistroke\n.68476 .51263 L\n.68667 .51319 L\n.68857 .51375 L\n.69048 .51431 L\n.69238 .51486 L\n.69429 .51542 L\n.69619 .51598 L\n.6981 .51654 L\n.7 .51709 L\n.7019 .51765 L\n.70381 .51821 L\n.70571 .51877 L\n.70762 .51932 L\n.70952 .51988 L\n.71143 .52044 L\n.71333 .521 L\n.71524 .52155 L\n.71714 .52211 L\n.71905 .52267 L\n.72095 .52323 L\n.72286 .52379 L\n.72476 .52434 L\n.72667 .5249 L\n.72857 .52546 L\n.73048 .52602 L\n.73238 .52657 L\n.73429 .52713 L\n.73619 .52769 L\n.7381 .52825 L\n.74 .5288 L\n.7419 .52936 L\n.74381 .52992 L\n.74571 .53048 L\n.74762 .53103 L\n.74952 .53159 L\n.75143 .53215 L\n.75333 .53271 L\n.75524 .53326 L\n.75714 .53382 L\n.75905 .53438 L\n.76095 .53494 L\n.76286 .5355 L\n.76476 .53605 L\n.76667 .53661 L\n.76857 .53717 L\n.77048 .53773 L\n.77238 .53828 L\n.77429 .53884 L\n.77619 .5394 L\n.7781 .53996 L\nMistroke\n.78 .54051 L\n.7819 .54107 L\n.78381 .54163 L\n.78571 .54219 L\n.78762 .54274 L\n.78952 .5433 L\n.79143 .54386 L\n.79333 .54442 L\n.79524 .54497 L\n.79714 .54553 L\n.79905 .54609 L\n.80095 .54665 L\n.80286 .54721 L\n.80476 .54776 L\n.80667 .54832 L\n.80857 .54888 L\n.81048 .54944 L\n.81238 .54999 L\n.81429 .55055 L\n.81619 .55111 L\n.8181 .55167 L\n.82 .55222 L\n.8219 .55278 L\n.82381 .55334 L\n.82571 .5539 L\n.82762 .55445 L\n.82952 .55501 L\n.83143 .55557 L\n.83333 .55613 L\n.83524 .55668 L\n.83714 .55724 L\n.83905 .5578 L\n.84095 .55836 L\n.84286 .55892 L\n.84476 .55947 L\n.84667 .56003 L\n.84857 .56059 L\n.85048 .56115 L\n.85238 .5617 L\n.85429 .56226 L\n.85619 .56282 L\n.8581 .56338 L\n.86 .56393 L\n.8619 .56449 L\n.86381 .56505 L\n.86571 .56561 L\n.86762 .56616 L\n.86952 .56672 L\n.87143 .56728 L\n.87333 .56784 L\nMistroke\n.87524 .5684 L\n.87714 .56895 L\n.87905 .56951 L\n.88095 .57007 L\n.88286 .57063 L\n.88476 .57118 L\n.88667 .57174 L\n.88857 .5723 L\n.89048 .57286 L\n.89238 .57341 L\n.89429 .57397 L\n.89619 .57453 L\n.8981 .57509 L\n.9 .57564 L\n.9019 .5762 L\n.90381 .57676 L\n.90571 .57732 L\n.90762 .57787 L\n.90952 .57843 L\n.91143 .57899 L\n.91333 .57955 L\n.91524 .58011 L\n.91714 .58066 L\n.91905 .58122 L\n.92095 .58178 L\n.92286 .58234 L\n.92476 .58289 L\n.92667 .58345 L\n.92857 .58401 L\n.93048 .58457 L\n.93238 .58512 L\n.93429 .58568 L\n.93619 .58624 L\n.9381 .5868 L\n.94 .58735 L\n.9419 .58791 L\n.94381 .58847 L\n.94571 .58903 L\n.94762 .58958 L\n.94952 .59014 L\n.95143 .5907 L\n.95333 .59126 L\n.95524 .59182 L\n.95714 .59237 L\n.95905 .59293 L\n.96095 .59349 L\n.96286 .59405 L\n.96476 .5946 L\n.96667 .59516 L\n.96857 .59572 L\nMistroke\n.97048 .59628 L\n.97238 .59683 L\n.97429 .59739 L\n.97619 .59795 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00619835 0.0619835 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.011157 0.0721271 0.0731405 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .75 .75 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .04215 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(position2) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.0830579 0.0721271 0.145041 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .11405 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(position1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.154959 0.0721271 0.216942 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .18595 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(velocity2) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.22686 0.0721271 0.288843 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00748 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .25785 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(velocity1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000>0=WIf@D000000P3IfMT2000000D0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00403IfMT01@000000fMWI0=WIf@3IfMT000000080\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000@0=WIf@030000\n003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMUD001o0;00fMWI00080=WIf@@00000103I\nfMT00`000000fMWI0=WIf@020=WIf@8000001@3IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003I\nfMT0fMWI0:l0fMWI000@0=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0103IfMT0\n0`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000?0=WIf@800000103IfMT30000\n00@0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000\nfMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI\n00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WI\nf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WI\nf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o\n003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0\nfMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI\n0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L\n0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03\n001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0\n[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000>0=WIf@D000000P3IfMT20000\n00D0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00403IfMT01@000000\nfMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1?0=WI\nf@03001o003IfMT0fMWI0:l0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`00\n0000fMWI0=WIf@020=WIf@800000D03IfMT00`00O`00fMWI0=WIf@2_0=WIf@00203IfMT4000000@0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WI\nf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00403IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI\n0:l0fMWI000?0=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00\nfMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI\n000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00000o`000?l0TP000?lM0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI\n04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00\nfMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI\n000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WI\nf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3I\nfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703I\nfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0\nfMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00\nO`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0\nfMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?\n0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WI\nf@3IfMT0[`3IfMT001D0fMWI0P0000050=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3I\nfMT0[`3IfMT001@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1?0=WIf@03\n001o003IfMT0fMWI0:l0fMWI000G0=WIf@030000003IfMT0fMWI0080fMWI0P00001@0=WIf@03001o\n003IfMT0fMWI0:l0fMWI000>0=WIf@@000000`3IfMT2000000D0fMWI00<000000=WIf@3IfMT0C`3I\nfMT00`00O`00fMWI0=WIf@2_0=WIf@005@3IfMT00`000000fMWI0=WIf@040=WIf@030000003IfMT0\nfMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001D0fMWI0`0000040=WIf@030000003IfMT0fMWI\n04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00\nfMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI\n000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@1?0=WI\nf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3I\nfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2_0=WIf@00703I\nfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0:l0fMWI000L0=WIf@030000003IfMT0\nfMWI04l0fMWI00<007l00=WIf@3IfMT0[`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00\nO`00fMWI0=WIf@2_0=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@800000103IfMT2000000<0\nfMWI1000000L0=WIf@03001o003IfMT0fMWI00800000103IfMT2000000D0fMWI0`00000N0=WIf@80\n0000103IfMT2000000<0fMWI0`00000P0=WIf@800000103IfMT2000000@0fMWI0P00000U0=WIf@D0\n00006`3IfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@0000080=WIf@03\n0000003IfMT0fMWI01d0fMWI00<007l00=WIf@0000000P3IfMT00`000000fMWI0=WIf@090=WIf@03\n0000003IfMT0fMWI01`0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N\n0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI\n0=WIf@0K0=WIf@00703IfMT00`000000fMWI0=WIf@0S0=WIf@040000003IfMT0fMWI000000T0fMWI\n00<000000=WIf@3IfMT0703IfMT00`00O`00fMWI000000020=WIf@030000003IfMT0fMWI00H0fMWI\n1@00000M0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000002H0fMWI00<000000=WIf@3IfMT06`3I\nfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003I\nfMT0fMWI01/0fMWI00<007l00=WIf@0000000P3IfMT00`000000fMWI0=WIf@060=WIf@040000003I\nfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT00000203IfMT3000001l0fMWI00@000000=WIf@3I\nfMT000002@3IfMT2000002L0fMWI00<000000=WIf@3IfMT06`3IfMT001`0fMWI00<000000=WIf@3I\nfMT08`3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001`0fMWI00<007l0\n0=WIf@0000000P3IfMT00`000000fMWI0=WIf@070=WIf@030000003IfMT0000001h0fMWI00@00000\n0=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI\n00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00703IfMT00`000000fMWI\n0=WIf@0T0=WIf@8000002P3IfMT2000001d0fMWI00<007l00=WIf@3IfMT00P00000;0=WIf@800000\n7`3IfMT2000000X0fMWI0`00000O0=WIf@8000002P3IfMT2000002D0fMWI0`3o000M0=WIf@00703I\nfMT00`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI08X0fMWI1P3o000O0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI08D0fMWI1@3o000U0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI0800fMWI1@3o000Z0=WIf@00703IfMT00`000000\nfMWI0=WIf@1?0=WIf@03001o003IfMT0fMWI07/0fMWI1@3o000P0=WIf@8000003@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@1e0=WIf@H0o`00903IfMT010000000fMWI\n0=WIf@00000<0=WIf@005P3IfMUH00000003001o000000000000070000001P3o000Q000000P0fMWI\n00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI001o\n00090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@050=WIf@H0o`002@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003IfMT0fMWI04l0fMWI00<007l0\n0=WIf@3IfMT0IP3IfMT60?l003<0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@1Q0=WIf@D0o`00B@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C`3IfMT00`00O`00fMWI0=WIf@1L0=WIf@D0o`00CP3IfMT001`0fMWI0`3o001?0=WIf@03001o\n003IfMT0fMWI05L0fMWI1@3o001C0=WIf@00703IfMT00`000000fMWI0?l000040?l004/0fMWI00<0\n07l00=WIf@3IfMT0DP3IfMT50?l005P0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI1@3o0016\n0=WIf@03001o003IfMT0fMWI04d0fMWI1@3o001M0=WIf@00703IfMT00`000000fMWI0=WIf@080=WI\nf@H0o`00@@3IfMT00`00O`00fMWI0=WIf@170=WIf@H0o`00HP3IfMT001`0fMWI00<000000=WIf@3I\nfMT03@3IfMT50?l003d0fMWI00<007l00=WIf@3IfMT0@P3IfMT60?l006L0fMWI000L0=WIf@030000\n003IfMT0fMWI0180fMWI1@3o000h0=WIf@03001o003IfMT0fMWI03d0fMWI1P3o001/0=WIf@00703I\nfMT00`000000fMWI0=WIf@0F0=WIf@D0o`00=03IfMT00`00O`00fMWI0=WIf@0h0=WIf@D0o`00LP3I\nfMT001`0fMWI00<000000=WIf@3IfMT06`3IfMT50?l002l0fMWI00<007l00=WIf@3IfMT0<`3IfMT5\n0?l007L0fMWI000L0=WIf@030000003IfMT0fMWI0200fMWI1@3o000Z0=WIf@03001o003IfMT0fMWI\n02h0fMWI1@3o001l0=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@D0o`009P3IfMT00`00O`00\nfMWI0=WIf@0Y0=WIf@D0o`00P@3IfMT001`0fMWI00<000000=WIf@3IfMT0:@3IfMT50?l00240fMWI\n00<007l00=WIf@3IfMT0903IfMT50?l008H0fMWI000L0=WIf@030000003IfMT0fMWI02d0fMWI1P3o\n000L0=WIf@03001o003IfMT0fMWI01l0fMWI1@3o002;0=WIf@00703IfMT00`000000fMWI0=WIf@0b\n0=WIf@H0o`005`3IfMT00`00O`00fMWI0=WIf@0I0=WIf@H0o`00T03IfMT001`0fMWI00<000000=WI\nf@3IfMT0=`3IfMT50?l001<0fMWI00<007l00=WIf@3IfMT0503IfMT60?l009D0fMWI000L0=WIf@03\n0000003IfMT0fMWI03`0fMWI1@3o000>0=WIf@03001o003IfMT0fMWI00l0fMWI1@3o002K0=WIf@00\n703IfMT00`000000fMWI0=WIf@100=WIf@D0o`002P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@D0o`00\nX03IfMT001`0fMWI00<000000=WIf@3IfMT0A@3IfMT50?l000D0fMWI00<007l00=WIf@3IfMT01@3I\nfMT50?l00:D0fMWI000L0=WIf@030000003IfMT0fMWI04T0fMWI1P3o00000`00O`000;no0=WIf@05\n0?l00:X0fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@1>0=WIf@@00;no[`3IfMT001@0\nfMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1;0=WIf@<00;no00@0fMWI001o\n003IfMT0fMWI0`00_kn/0=WIf@005`3IfMT00`000000fMWI0=WIf@020=WIf@800000B@3IfMT3002o\n_`@0fMWI00<007l00=WIf@3IfMT00`3IfMT4002o_jP0fMWI000E0=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@140=WIf@@00;no1`3IfMT00`00O`00fMWI0=WIf@070=WIf@<00;noY@3IfMT001D0fMWI\n00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@120=WIf@<00;no2P3IfMT00`00O`00fMWI\n0=WIf@0:0=WIf@@00;noX@3IfMT001D0fMWI0`0000040=WIf@030000003IfMT0fMWI03h0fMWI1000\n_kl=0=WIf@03001o003IfMT0fMWI00d0fMWI1000_knN0=WIf@00703IfMT00`000000fMWI0=WIf@0k\n0=WIf@@00;no403IfMT00`00O`00fMWI0=WIf@0A0=WIf@@00;noVP3IfMT001`0fMWI00<000000=WI\nf@3IfMT0>03IfMT4002o_a<0fMWI00<007l00=WIf@3IfMT0503IfMT4002o_iL0fMWI000L0=WIf@03\n0000003IfMT0fMWI03D0fMWI1000_klF0=WIf@03001o003IfMT0fMWI01P0fMWI0`00_knD0=WIf@00\n703IfMT00`000000fMWI0=WIf@0b0=WIf@@00;no6@3IfMT00`00O`00fMWI0=WIf@0K0=WIf@@00;no\nT03IfMT001`0fMWI00<000000=WIf@3IfMT0;`3IfMT3002o_ad0fMWI00<007l00=WIf@3IfMT07`3I\nfMT3002o_hd0fMWI000L0=WIf@030000003IfMT0fMWI02`0fMWI1000_klO0=WIf@03001o003IfMT0\nfMWI0280fMWI1000_kn90=WIf@00703IfMT00`000000fMWI0=WIf@0Y0=WIf@<00;no8`3IfMT00`00\nO`00fMWI0=WIf@0U0=WIf@@00;noQP3IfMT001`0fMWI00<000000=WIf@3IfMT09P3IfMT3002o_bH0\nfMWI00<007l00=WIf@3IfMT0:@3IfMT4002o_h80fMWI000L0=WIf@030000003IfMT0fMWI02<0fMWI\n0`00_klY0=WIf@03001o003IfMT0fMWI02`0fMWI1000_kmo0=WIf@00703IfMT00`000000fMWI0=WI\nf@0P0=WIf@<00;no;03IfMT00`00O`00fMWI0=WIf@0`0=WIf@<00;noO03IfMT001`0fMWI00<00000\n0=WIf@3IfMT07@3IfMT3002o_bl0fMWI00<007l00=WIf@3IfMT0<`3IfMT4002o_gP0fMWI000L0=WI\nf@030000003IfMT0fMWI01X0fMWI0`00_klb0=WIf@03001o003IfMT0fMWI03H0fMWI1000_kme0=WI\nf@00703IfMT00`000000fMWI0=WIf@0F0=WIf@@00;no=@3IfMT00`00O`00fMWI0=WIf@0j0=WIf@@0\n0;noL@3IfMT001`0fMWI00<000000=WIf@3IfMT04`3IfMT4002o_cP0fMWI00<007l00=WIf@3IfMT0\n?@3IfMT4002o_fh0fMWI000L0=WIf@030000003IfMT0fMWI0100fMWI1000_klk0=WIf@03001o003I\nfMT0fMWI0440fMWI0`00_km[0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@@00;no?P3IfMT0\n0`00O`00fMWI0=WIf@140=WIf@@00;noI`3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT4002o\n_d40fMWI00<007l00=WIf@3IfMT0A`3IfMT4002o_f@0fMWI000L0=WIf@030000003IfMT0fMWI00L0\nfMWI0`00_km50=WIf@03001o003IfMT0fMWI04/0fMWI1000_kmP0=WIf@00703IfMT00`000000fMWI\n0=WIf@040=WIf@@00;noA`3IfMT00`00O`00fMWI0=WIf@1>0=WIf@@00;noG@3IfMT000h0fMWI1@00\n00020=WIf@8000001@3IfMT010000000fMWI0=WIf@3IfMT3002o_d/0fMWI00<007l00=WIf@3IfMT0\nDP3IfMT4002o_eT0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI\n0=WIf@020=WIf@0400000000_kl00;no002o_dh0fMWI00<007l00000o`3IfMT0E@3IfMT4002o_eH0\nfMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@03\n002o_`000?l0003o04l0003o00<007l00=WIf@3IfMT0F03IfMT4002o_e<0fMWI000@0=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI04l0\nfMWI00<007l00=WIf@3IfMT0G03IfMT4002o_dl0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI04l0fMWI00<007l00=WIf@3I\nfMT0G`3IfMT4002o_d`0fMWI000?0=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0\nC`3IfMT00`00O`00fMWI0=WIf@1S0=WIf@@00;noB03IfMT001`0fMWI00<000000=WIf@3IfMT0C`3I\nfMT00`00O`00fMWI0=WIf@1V0=WIf@@00;noA@3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT0\n0`00O`00fMWI0=WIf@1Z0=WIf@@00;no@@3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00\nO`00fMWI0=WIf@1]0=WIf@@00;no?P3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00\nfMWI0=WIf@1`0=WIf@@00;no>`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI\n0=WIf@1d0=WIf@@00;no=`3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WI\nf@1g0=WIf@@00;no=03IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@1k\n0=WIf@@00;no<03IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@1n0=WI\nf@@00;no;@3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@210=WIf@D0\n0;no:@3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@250=WIf@@00;no\n9P3IfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@280=WIf@@00;no8`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2<0=WIf@@00;no7`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C`3IfMT00`00O`00fMWI0=WIf@2?0=WIf@<00;no7@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C`3IfMVE001o01d0fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00240fMWI0`00000f0=WIf@800000203IfMT20000\n0;X0fMWI000R0=WIf@030000003IfMT0fMWI03D0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@2h0=WIf@008P3IfMT3000000@0fMWI0P0000030=WIf@<00000103IfMT3000000<0fMWI\n0P0000040=WIf@<000000`3IfMT200000080fMWI0P0000020=WIf@80000000<0fMWI000000000000\n0P0000040=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0;P0fMWI\n000F0=WIf@P00;no103IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000D0\nfMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WI\nf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3I\nfMT010000000fMWI0=WIf@0000070=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000\nfMWI0=WIf@3IfMT000000;X0fMWI000R0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WI\nf@3IfMT000000P3IfMT3000000D0fMWI00D000000=WIf@3IfMT0fMWI000000070=WIf@050000003I\nfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003IfMT0fMWI0=WI\nf@0000001P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT0\n0240fMWI100000040=WIf@8000000`3IfMT4000000<0fMWI0P0000020=WIf@D000000`3IfMT20000\n00@0fMWI0P0000020=WIf@@000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n00D000000`3IfMT00`000000fMWI0=WIf@2h0=WIf@00>P3IfMT00`000000fMWI0=WIf@0E0=WIf@04\n0000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0\nfMWI0;P0fMWI000f0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT03P3IfMT20000\n00D0fMWI0P0000080=WIf@800000^P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00240fMWI0`00\n000f0=WIf@800000203IfMT200000;X0fMWI000R0=WIf@030000003IfMT0fMWI03D0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@2h0=WIf@008P3IfMT3000000@0fMWI0P0000030=WI\nf@<00000103IfMT3000000<0fMWI0P0000040=WIf@<000000`3IfMT200000080fMWI0P0000020=WI\nf@80000000<0fMWI0000000000000`0000030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WI\nf@030000003IfMT0fMWI0;P0fMWI000F0=WIf@P0o`00103IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000000D0fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3I\nfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI00<0\nfMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000^P3IfMT0\n0280fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WIf@<000001@3I\nfMT01@000000fMWI0=WIf@3IfMT0000000L0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@04\n0000003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@030=WI\nf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2h0=WIf@008@3IfMT40000\n00@0fMWI0P0000030=WIf@@000000`3IfMT200000080fMWI1@0000030=WIf@800000103IfMT20000\n0080fMWI100000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WI\nf@030000003IfMT0fMWI0;P0fMWI000j0=WIf@030000003IfMT0fMWI01L0fMWI00<000000=WIf@3I\nfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT003H0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@0>0=WIf@8000001@3IfMT2000000P0\nfMWI0P00002j0=WIf@00o`3IfMTQ0=WIf@00C03IfMT2000000`0fMWI0P0000080=WIf@800000^P3I\nfMT004d0fMWI00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0\nfMWI0;P0fMWI000S0=WIf@800000103IfMT300000080fMWI0`0000040=WIf@800000103IfMT30000\n00<0fMWI0`0000030=WIf@8000001@3IfMT010000000fMWI0=WIf@3IfMT4000000@0fMWI00<00000\n0=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI0P0000030=WI\nf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@000002\n0=WIf@030000003IfMT0fMWI00D0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@070000003I\nfMT0fMWI0=WIf@000000fMWI000000020=WIf@030000003IfMT0fMWI00D0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000^P3IfMT001H0fMWI2000O`040=WI\nf@040000003IfMT0fMWI00000080fMWI100000030=WIf@030000003IfMT0fMWI0080fMWI00@00000\n0=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@000000\n1@3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3I\nfMT0fMWI000000060=WIf@030000003IfMT0fMWI0;P0fMWI000Q0=WIf@8000000P3IfMT200000080\nfMWI0P0000040=WIf@030000003IfMT0fMWI00<0fMWI0P0000040=WIf@<000000`3IfMT200000080\nfMWI1@0000001@3IfMT00000000000000000fMWI008000000`3IfMT00`000000fMWI0=WIf@030=WI\nf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@2h0=WIf@00;`3IfMT00`000000\nfMWI0=WIf@0D0=WIf@030000003IfMT0fMWI00T0fMWI00@000000=WIf@3IfMT00000103IfMT01@00\n0000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT002h0fMWI0P00000B0=WI\nf@030000003IfMT0fMWI00h0fMWI0P0000050=WIf@800000203IfMT200000;X0fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI001<0=WIf@800000303IfMT2000000P0fMWI0P00002j0=WIf@00C@3IfMT0\n0`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0^03IfMT0\n02<0fMWI0P0000040=WIf@<000000P3IfMT3000000@0fMWI0P0000040=WIf@<000000`3IfMT30000\n00<0fMWI0P0000050=WIf@040000003IfMT0fMWI0=WIf@D000000`3IfMT00`000000fMWI0=WIf@02\n0=WIf@800000103IfMT00`000000fMWI0=WIf@2h0=WIf@008`3IfMT2000000<0fMWI00<000000=WI\nf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI00000080fMWI00<00000\n0=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00L000000=WIf@3IfMT0fMWI\n0000003IfMT0000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00D000000=WIf@3IfMT0fMWI0000002j0=WIf@005P3IfMT80000o`@0fMWI00@000000=WI\nf@3IfMT000000P3IfMT4000000<0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@00\n00020=WIf@030000003IfMT0fMWI00D0fMWI00D000000=WIf@3IfMT0fMWI000000050=WIf@040000\n003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT00000\n00H0fMWI00<000000=WIf@3IfMT0^03IfMT00240fMWI0P0000020=WIf@8000000P3IfMT2000000@0\nfMWI00<000000=WIf@3IfMT00`3IfMT2000000@0fMWI0`0000030=WIf@8000000P3IfMT500000005\n0=WIf@00000000000000003IfMT00P0000030=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WI\nf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;P0fMWI000_0=WIf@030000003IfMT0fMWI01@0\nfMWI00<000000=WIf@3IfMT02`3IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WI\nf@0000001P3IfMT00`000000fMWI0=WIf@2h0=WIf@00;P3IfMT200000180fMWI00<000000=WIf@3I\nfMT03P3IfMT2000000D0fMWI0P0000080=WIf@800000^P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3I\nfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, -18.7732`, 0.00434554`, 0.20039`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -19.874`, 0.119891`, 0.11823`]], Rule[List[List[22.125`, 30.4375`], List[44.4375`, 36]], List[-6.32337`, -41.632`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[34.625`, 26.1875`]], List[-6.32337`, -43.9929`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.8125`, 16.375`]], List[-6.32337`, -46.3538`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[15, 6.5625`]], List[-6.32337`, -48.7148`, 0.240604`, 0.240604`]]]]]], Closed]]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[780, 893]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 1]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]