List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Iteration Using for-Statements", "Title"], Cell[CellGroupData[List[Cell["SumZ", "Section"], Cell[TextData[List["The ", StyleBox["for", Rule[FontFamily, "Courier"]], "-statement is a convenient way of expressing iteration. This fits well when you know how to express the range of values over which the iteration -variable should iterate. The class ", StyleBox["SumZ ", Rule[FontFamily, "Courier"]], "contains a very simple ", StyleBox["for", Rule[FontFamily, "Courier"]], "-loop summing the five elements of the vector z.\n"]], "Text"], Cell[TextData[List["class SumZ\n  parameter Integer n = 5;\n  parameter Real[n] z := {10, 20, 30, 40, 50};\n  Real sum(start = 0);\nalgorithm\n  sum := 0;\n  ", StyleBox["for i in 1:n loop\n    sum := sum + z[i];\n  end for;    ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend SumZ;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of SumZ", "Section"], Cell["simulate( SumZ );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(SumZ\\) : 2004-1-30 14:40:5.8604450 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\\"sum\\\", HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["Simulation of SumZ and HideVariable", "Section"], Cell[TextData[List["Since the scope of the iteration variable is the body of the ", StyleBox["for", Rule[FontFamily, "Courier"]], "-statement, it may hide other variables with the same name, like the constant k in ", StyleBox["HideVariable", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["class HideVariable\n  constant \tInteger k = 4;\n  Real \t\tz[k + 1];\nalgorithm\n  ", StyleBox["for k in 1:k+1 loop", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// The iteration variable k gets values 1, 2, 3, 4, 5\n    ", StyleBox["z[k] := k;\n  end for;  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend HideVariable;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of HideVariable", "Section"], Cell["simulate( HideVariable );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(HideVariable\\) : 2004-1-30 14:40:16.2195548 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[896, 892]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]