List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["if-Statements", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The semantics of an ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement is:"]], "Text"], Cell[TextData[List["if the condition after the keyword if evaluates to true, the statements after ", StyleBox["then", Rule[FontFamily, "Courier"]], " are executed."]], "Itemize"], Cell[TextData[List["Otherwise if there are one or more ", StyleBox["elseif", Rule[FontFamily, "Courier"]], "-parts there conditions are evaluated in order; the first that evaluates to true causes the corresponding statements to be executed."]], "Itemize"], Cell[TextData[List["Otherwise, if present, the statements in the ", StyleBox["else", Rule[FontFamily, "Courier"]], "-part are executed."]], "Itemize"]], Open]], Cell[CellGroupData[List[Cell["SumVector", "Section"], Cell[TextData[List["In the class SumVector there is an exmple of an ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement which performs a combined summation and computation on a vector v."]], "Text"], Cell[TextData[List["class SumVector\n  Real sum;\n  parameter Real v[5] = {100, 200, -300, 400, 500};\n  parameter Integer n = size(v, 1);\nalgorithm\n  sum := 0;\n  for i in 1:n loop\n    ", StyleBox["if v[i] > 0 then\n      sum := sum + v[i];\n    elseif v[i] > -1 then\n      sum := sum + v[i] - 1;\n    else\n      sum := sum - v[i];      \n    end if;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end for;\nend SumVector;      "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of SumVector", "Section"], Cell[TextData[List["After we have simulated ", StyleBox["SumVector", Rule[FontFamily, "Courier"]], " we see that the sum of the absolute value of the elements in the vecor is 1500."]], "Text"], Cell["simulate( SumVector );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(SumVector\\) : 2004-1-30 14:44:51.2761438 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\\"sum\\\", HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["sum", "[", "0", "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Assignments within if-Statements", "Section"], Cell[TextData[List["There are a special feature regarding assignment statements inside ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statements", ". Modelica guarantees that all the outputs of an algorithm section always have well-defined values, and that an algorithm section does ", StyleBox["not", Rule[FontSlant, "Italic"]], " have memory of previous invocations. This is achieved by ", StyleBox["initializing", Rule[FontSlant, "Italic"]], " all ", StyleBox["conditionally assigned variables", Rule[FontSlant, "Italic"]], " to their start-values whenever the algorithm is invoked. "]], "Text"], Cell[CellGroupData[List[Cell["CondAssign", "Subsection"], Cell[TextData[List["The algorithm section in the class ", StyleBox["CondAssign", Rule[FontFamily, "Courier"]], " below automatically assigns the start values 35 and 45 to the variables ", StyleBox["x", Rule[FontFamily, "Courier"]], " and ", StyleBox["y", Rule[FontFamily, "Courier"]], " respectively when entering the algorithm section since these variables are conditionally assigned within the algorithm section. This means that the condition ", StyleBox["x>5 ", Rule[FontFamily, "Courier"]], "becomes ", StyleBox["35>5", Rule[FontFamily, "Courier"]], " which is always true. On the other hand, the variable z is not given its start value when entering the algorithm section since it is not conditionally assigned; it is actually an input to the algorithm section.\n"]], "Text"], Cell[TextData[List["class CondAssign\n  Real x(start = 35);\n  Real y(start = 45);\n  parameter Real z := 0;\nalgorithm\n  if x > 5 then \n   ", StyleBox[" x := 400;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\n  end if;  \n  if z > 10 then \n   ", StyleBox[" y := 500;  \t", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end if;\t\nend CondAssign;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of CondAssign", "Subsection"], Cell["simulate( CondAssign );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(CondAssign\\) : 2004-1-30 14:45:1.8384410 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["CondAssign", "Subsection"], Cell["The function CondAssignFunc below behaves similarily. Here the local variables x and y are automatically assigned the default initial values 35 and 45 on entry to the algorithm section that comprises its function body.\n", "Text"], Cell[TextData[List["function CondAssignFunc\n  input Real z;\n  output Real x := 35;\n  output Real y := 45;\nalgorithm\n  if x > 5 then\n    ", StyleBox["x := 400;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end if;\n  if z > 10 then\n   ", StyleBox[" y := 500;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end if;\nend CondAssignFunc;          "]], "ModelicaInput"], Cell["", "Text"], Cell["class CondAssignFuncCall\n  Real a, b;\nequation\n  (a, b) = CondAssignFunc(z = 5);\nend CondAssignFuncCall;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of CondAssignFuncCall", "Subsection"], Cell["simulate( CondAssignFuncCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(CondAssignFuncCall\\) : 2004-1-30 14:45:11.9944960 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"b\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["a", "[", "0", "]"]], ",", " ", RowBox[List["b", "[", "0", "]"]]]], "}"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[928, 889]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]