List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Functions with Multiple Results", "Title"], Cell["\nThere is a special form of assignment statement that is only used when the right-hand side contains a call to a function with multiple results. The left-hand side contains a parenthesized, comma-separated list of variables receiving the results from the function call. A function with n results needs n receiving variables on the left-hand side. \n", "Text"], Cell["function f\n  input Real x;\n  input Real y;\n  output Real r1;\n  output Real r2;\n  output Real r3;\nalgorithm\n  r1 := x;\n  r2 := y;\n  r3 := x*y;\nend f;    ", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["model fCall\n  Real x[3];\n  Real a, b, c;\nequation\n  ", StyleBox["(a, b, c) = f(1.0, 2.0);\n  (x[1], x[2], x[3]) = f(3.0, 4.0);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend fCall;  "]], "ModelicaInput"], Cell[CellGroupData[List[Cell["MakeAlive on f", "Section"], Cell[TextData[List["When running MakeAlive on the function we can call ", StyleBox["f", Rule[FontFamily, "Courier"]], " with some input values and see what outputs it returns."]], "Text"], Cell[BoxData[RowBox[List["MakeAlive", "[", "f", "]"]]], "Input"], Cell[BoxData[RowBox[List["f", "[", RowBox[List["2.5", ",", " ", "3"]], "]"]]], "Input"], Cell[BoxData[RowBox[List["f", "[", RowBox[List["3", ",", " ", "4"]], "]"]]], "Input"], Cell[BoxData[RowBox[List["f", "[", RowBox[List["1.0", ",", " ", "2.0"]], "]"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["Simulation of fCall", "Section"], Cell[TextData[List["We simulate ", StyleBox["fCall", Rule[FontFamily, "Courier"]], " in the interval from 0 to 1, then we can look at the values of the variables."]], "Text"], Cell["simulate( fCall );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(fCall\\) : 2004-1-30 14:36:19.3345424 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"b\\\", HoldForm], \\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["a", "[", "0", "]"]], ",", " ", RowBox[List["b", "[", "0", "]"]], ",", " ", RowBox[List["c", "[", "0", "]"]]]], "}"]]], "Input"], Cell["plot( {x,y,z} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -0.573889 0.294302 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .16187 -18 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .30902 -6 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .16187 m\n.03006 .16187 L\ns\n[(2.5)] .01131 .16187 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(3)] .01131 .30902 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(3.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(4)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.5 Mabswid\n.02381 .60332 m\n.06244 .60332 L\n.10458 .60332 L\n.14415 .60332 L\n.18221 .60332 L\n.22272 .60332 L\n.26171 .60332 L\n.30316 .60332 L\n.34309 .60332 L\n.3815 .60332 L\n.42237 .60332 L\n.46172 .60332 L\n.49955 .60332 L\n.53984 .60332 L\n.57861 .60332 L\n.61984 .60332 L\n.65954 .60332 L\n.69774 .60332 L\n.73838 .60332 L\n.77751 .60332 L\n.81909 .60332 L\n.85916 .60332 L\n.89771 .60332 L\n.93871 .60332 L\n.97619 .60332 L\ns\n0 .5 0 r\n.02381 .01472 m\n.06244 .01472 L\n.10458 .01472 L\n.14415 .01472 L\n.18221 .01472 L\n.22272 .01472 L\n.26171 .01472 L\n.30316 .01472 L\n.34309 .01472 L\n.3815 .01472 L\n.42237 .01472 L\n.46172 .01472 L\n.49955 .01472 L\n.53984 .01472 L\n.57861 .01472 L\n.61984 .01472 L\n.65954 .01472 L\n.69774 .01472 L\n.73838 .01472 L\n.77751 .01472 L\n.81909 .01472 L\n.85916 .01472 L\n.89771 .01472 L\n.93871 .01472 L\n.97619 .01472 L\ns\n1 0 0 r\n.02381 .30902 m\n.06244 .30902 L\n.10458 .30902 L\n.14415 .30902 L\n.18221 .30902 L\n.22272 .30902 L\n.26171 .30902 L\n.30316 .30902 L\n.34309 .30902 L\n.3815 .30902 L\n.42237 .30902 L\n.46172 .30902 L\n.49955 .30902 L\n.53984 .30902 L\n.57861 .30902 L\n.61984 .30902 L\n.65954 .30902 L\n.69774 .30902 L\n.73838 .30902 L\n.77751 .30902 L\n.81909 .30902 L\n.85916 .30902 L\n.89771 .30902 L\n.93871 .30902 L\n.97619 .30902 L\ns\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.00815217 0.0815217 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0146739 0.0721271 0.0961957 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.309017 0.294302 [\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n1 0 0 r\n.5 Mabswid\n[ ] 0 setdash\n.02381 .30902 m\n.97619 .30902 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .05543 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(z) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.109239 0.0721271 0.190761 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.309017 0.294302 [\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.5 Mabswid\n[ ] 0 setdash\n.02381 .30902 m\n.97619 .30902 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.203804 0.0721271 0.285326 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.309017 0.294302 [\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.5 Mabswid\n[ ] 0 setdash\n.02381 .30902 m\n.97619 .30902 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .24457 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(x) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00@`3IfMT2000000@0fMWI0P0000030=WIf@@000007`3IfMT2000000@0fMWI0P0000050=WI\nf@<000007P3IfMT2000000@0fMWI0P0000030=WIf@<00000803IfMT2000000@0fMWI0P0000040=WI\nf@8000009@3IfMT5000001/0fMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WI\nf@3IfMT07`3IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI01`0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI000000P0\nfMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@P3IfMT010000000\nfMWI0=WIf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3IfMT00000203IfMT5\n000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000\n003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WI\nf@00@P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI000000P0fMWI\n0`00000O0=WIf@040000003IfMT0fMWI000000T0fMWI0P00000W0=WIf@030000003IfMT0fMWI01/0\nfMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT01000\n0000fMWI0=WIf@0000090=WIf@030000003IfMT0000001h0fMWI00@000000=WIf@3IfMT000002@3I\nfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0\n00009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@`3IfMT2000000X0fMWI0P00000P0=WIf@800000\n2`3IfMT2000001l0fMWI0P00000:0=WIf@<000007`3IfMT2000000X0fMWI0P00000V0=WIf@800000\n7@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?80fMWI\n0P00000=0=WIf@005P3IfMT600000>L007l01@0000080=WIf@040000003IfMT0fMWI000000`0fMWI\n000L0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WI\nf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@0;0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000003IfMT0fMWI02/0fMWI00<00000\n0=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0fMWI00<00000\n0=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT001`0fMWI00<000000=WI\nf@3IfMT0l@3IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT4000000<0fMWI0P0000040=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI00080=WIf@030000003IfMT0fMWI00T0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI00090=WIf@030000\n003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00P3IfMT200000?l0fMWI0`3IfMT000X0fMWI00<0\n00000=WIf@3IfMT0203IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@002@3IfMT2000000X0fMWI0`0000040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3I\nfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703I\nfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT2\n0=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIfNL0o`007@3IfMT001L0fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000D0=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0\no`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0\nfMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000\nfMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WI\nf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00\n703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0\no`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0\nfMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000\nfMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WI\nf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00\n703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WI\nf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0\no`3IfMT20=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000:0=WIf@030000003IfMT0fMWI00X0fMWI00<0\n00000=WIf@3IfMT00P3IfMT200000?l0fMWI0`3IfMT000/0fMWI00<000000=WIf@3IfMT01`3IfMT2\n000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00203IfMT010000000fMWI0=WIf@000009\n0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@002@3IfMT20000\n00X0fMWI0`0000040=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003I\nfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`00\n0000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI\n0P3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o\n0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001H0fMWI0`0000030=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT001L0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000D0=WIf@D000000`3IfMWW0000oad0fMWI000D0=WIf@040000003IfMT0\nfMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@005@3IfMT00`000000fMWI00000004\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001H0fMWI0P0000040=WIf@030000003IfMT0fMWI\n0?l0fMWI0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002X0fMWI0P000008\n0=WIf@800000jP3IfMT002X0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3X0=WI\nf@008P3IfMT4000000@0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3I\nfMT0j03IfMT001H0fMWI203o00050=WIf@030000003IfMT0000000@0fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000jP3IfMT00280fMWI00<000000=WIf@00\n00001@3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0j03IfMT00280\nfMWI100000040=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3X0=WIf@00\n:P3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0j03IfMT002X0fMWI\n0P0000080=WIf@800000jP3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00280fMWI0P0000060=WIf@800000203IfMT200000>X0fMWI000S0=WIf@030000003I\nfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3X0=WIf@00903IfMT0\n0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0\nfMWI0>P0fMWI000S0=WIf@030000003IfMT0000000@0fMWI00D000000=WIf@3IfMT0fMWI00000002\n0=WIf@050000003IfMT0fMWI0=WIf@000000jP3IfMT001H0fMWI2000O`040=WIf@040000003IfMT0\nfMWI000000@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0fMWI\n000Q0=WIf@<0000000<0fMWI0000000000000`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<0\n00000=WIf@3IfMT0j03IfMT002X0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003I\nfMT0fMWI0>P0fMWI000Z0=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000Z0=WIf@800000203IfMT20000\n0>X0fMWI000Z0=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0j03IfMT00240fMWI\n0P0000000`3IfMT00000000000040=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000\n003IfMT0fMWI0>P0fMWI000R0=WIf@030000003IfMT0000000D0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@050000003IfMT0fMWI0=WIf@000000jP3IfMT001H0fMWI20000?l50=WIf@030000\n003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0>P0\nfMWI000Q0=WIf@80000000<0fMWI000000000000103IfMT00`000000fMWI0=WIf@05000000<0fMWI\n00<000000=WIf@3IfMT0j03IfMT002X0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000\n003IfMT0fMWI0>P0fMWI000Z0=WIf@800000203IfMT200000>X0fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, 1.68898`, 0.00434554`, 0.0140625`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -15.1348`, 0.119891`, 0.0898941`]], Rule[List[List[22.125`, 30.4375`], List[43.9375`, 32.875`]], List[-2.81977`, -71.471`, 0.126317`, 0.40877`]], Rule[List[List[22.125`, 30.4375`], List[31.0625`, 19.9375`]], List[-2.81977`, -76.7467`, 0.126317`, 0.40877`]], Rule[List[List[22.125`, 30.4375`], List[18.1875`, 7.0625`]], List[-2.81977`, -82.0096`, 0.126317`, 0.40877`]]]]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[887, 907]], Rule[WindowMargins, List[List[38, Automatic], List[0, Automatic]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]