List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Reinit", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " operator occurs both as a kind of statement and in the form of an equation with the same syntax. The ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " operator is used to make a discontinuous change in the value of a continuous variable at a specific time event. The ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " operator can only be applied to variables the have had the ", StyleBox["der", Rule[FontFamily, "Courier"]], " operator applied to them. The effect of the operator is to stop simulation time, make a change to the value of one or more continuous variables and then resume the simulation. The first argument to ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " is the variable whose value should change and the second argument is the value it should change to. The ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " operator can only be used within a ", StyleBox["when", Rule[FontFamily, "Courier"]], " clause because it is meant to represent an abrupt change, which is the difference between ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " and a statement or equation. "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Bouncing Ball", "Section"], Cell[TextData[List["model BouncingBall \t\t\t\t\t\t\"The bouncing ball model with an algorithm\"\n  constant Real g = 9.81;\t\t\t\t// Gravitational acceleration\n  parameter Real c = 0.9;\t\t\t\t// Elasticity constant of ball\n  Real height(start = 1);\t\t\t\t// height above ground of the ball center\n  Real velocity(start = 10);\t\t\t// Velocity of the ball\nequation\n  der(height) = velocity;\n  der(velocity) = -g;\nalgorithm  \n  when height <= 0 then \n   ", StyleBox[" reinit(velocity, -c*velocity);", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end when;\nend BouncingBall;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Bouncing Ball Simulation", "Section"], Cell["simulate( BouncingBall, stopTime=20 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(BouncingBall\\) : 2004-1-30 14:49:16.6782072 : \\!\\({0.`, 20.`}\\) : 586 data points : 22 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"g\\\", HoldForm], \\*TagBox[\\\"height\\\", HoldForm], \\*TagBox[\\\"velocity\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"height\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\\"velocity\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( { height, velocity } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.047619 0.322189 0.028113 [\n[.2619 .30969 -3 -9 ]\n[.2619 .30969 3 0 ]\n[.5 .30969 -6 -9 ]\n[.5 .30969 6 0 ]\n[.7381 .30969 -6 -9 ]\n[.7381 .30969 6 0 ]\n[.97619 .30969 -6 -9 ]\n[.97619 .30969 6 0 ]\n[1.025 .32219 0 -6.28125 ]\n[1.025 .32219 10 6.28125 ]\n[.01131 .04106 -18 -4.5 ]\n[.01131 .04106 0 4.5 ]\n[.01131 .18162 -12 -4.5 ]\n[.01131 .18162 0 4.5 ]\n[.01131 .46275 -6 -4.5 ]\n[.01131 .46275 0 4.5 ]\n[.01131 .60332 -12 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.2619 .32219 m\n.2619 .32844 L\ns\n[(5)] .2619 .30969 0 1 Mshowa\n.5 .32219 m\n.5 .32844 L\ns\n[(10)] .5 .30969 0 1 Mshowa\n.7381 .32219 m\n.7381 .32844 L\ns\n[(15)] .7381 .30969 0 1 Mshowa\n.97619 .32219 m\n.97619 .32844 L\ns\n[(20)] .97619 .30969 0 1 Mshowa\n.125 Mabswid\n.07143 .32219 m\n.07143 .32594 L\ns\n.11905 .32219 m\n.11905 .32594 L\ns\n.16667 .32219 m\n.16667 .32594 L\ns\n.21429 .32219 m\n.21429 .32594 L\ns\n.30952 .32219 m\n.30952 .32594 L\ns\n.35714 .32219 m\n.35714 .32594 L\ns\n.40476 .32219 m\n.40476 .32594 L\ns\n.45238 .32219 m\n.45238 .32594 L\ns\n.54762 .32219 m\n.54762 .32594 L\ns\n.59524 .32219 m\n.59524 .32594 L\ns\n.64286 .32219 m\n.64286 .32594 L\ns\n.69048 .32219 m\n.69048 .32594 L\ns\n.78571 .32219 m\n.78571 .32594 L\ns\n.83333 .32219 m\n.83333 .32594 L\ns\n.88095 .32219 m\n.88095 .32594 L\ns\n.92857 .32219 m\n.92857 .32594 L\ns\n.25 Mabswid\n0 .32219 m\n1 .32219 L\ns\ngsave\n1.025 .32219 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .04106 m\n.03006 .04106 L\ns\n[(-10)] .01131 .04106 1 0 Mshowa\n.02381 .18162 m\n.03006 .18162 L\ns\n[(-5)] .01131 .18162 1 0 Mshowa\n.02381 .46275 m\n.03006 .46275 L\ns\n[(5)] .01131 .46275 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(10)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .06917 m\n.02756 .06917 L\ns\n.02381 .09729 m\n.02756 .09729 L\ns\n.02381 .1254 m\n.02756 .1254 L\ns\n.02381 .15351 m\n.02756 .15351 L\ns\n.02381 .20974 m\n.02756 .20974 L\ns\n.02381 .23785 m\n.02756 .23785 L\ns\n.02381 .26596 m\n.02756 .26596 L\ns\n.02381 .29408 m\n.02756 .29408 L\ns\n.02381 .3503 m\n.02756 .3503 L\ns\n.02381 .37842 m\n.02756 .37842 L\ns\n.02381 .40653 m\n.02756 .40653 L\ns\n.02381 .43464 m\n.02756 .43464 L\ns\n.02381 .49087 m\n.02756 .49087 L\ns\n.02381 .51898 m\n.02756 .51898 L\ns\n.02381 .54709 m\n.02756 .54709 L\ns\n.02381 .57521 m\n.02756 .57521 L\ns\n.02381 .01295 m\n.02756 .01295 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .3503 m\n.02571 .36133 L\n.02762 .37191 L\n.02952 .38205 L\n.03143 .39175 L\n.03333 .40101 L\n.03524 .40983 L\n.03714 .41821 L\n.03905 .42614 L\n.04095 .43364 L\n.04286 .44069 L\n.04476 .4473 L\n.04667 .45347 L\n.04857 .4592 L\n.05048 .46449 L\n.05238 .46934 L\n.05429 .47374 L\n.05619 .47771 L\n.0581 .48123 L\n.06 .48431 L\n.0619 .48695 L\n.06381 .48915 L\n.06571 .49091 L\n.06762 .49223 L\n.06952 .4931 L\n.07143 .49354 L\n.07333 .49353 L\n.07524 .49308 L\n.07714 .49219 L\n.07905 .49086 L\n.08095 .48909 L\n.08286 .48688 L\n.08476 .48422 L\n.08667 .48113 L\n.08857 .47759 L\n.09048 .47361 L\n.09238 .46919 L\n.09429 .46433 L\n.09619 .45903 L\n.0981 .45329 L\n.1 .4471 L\n.1019 .44047 L\n.10381 .43341 L\n.10571 .4259 L\n.10762 .41795 L\n.10952 .40956 L\n.11143 .40073 L\n.11333 .39145 L\n.11524 .38174 L\n.11714 .37158 L\nMistroke\n.11905 .36099 L\n.12095 .34995 L\n.12286 .33847 L\n.12476 .32655 L\n.12544 .32219 L\n.12544 .32219 L\n.12544 .32219 L\n.12544 .32219 L\n.12667 .32922 L\n.12857 .33979 L\n.13048 .34991 L\n.13238 .35959 L\n.13429 .36883 L\n.13619 .37763 L\n.1381 .38599 L\n.14 .39391 L\n.1419 .40138 L\n.14381 .40842 L\n.14571 .41501 L\n.14762 .42116 L\n.14952 .42687 L\n.15143 .43214 L\n.15333 .43697 L\n.15524 .44136 L\n.15714 .4453 L\n.15905 .44881 L\n.16095 .45187 L\n.16286 .45449 L\n.16476 .45667 L\n.16667 .45841 L\n.16857 .45971 L\n.17048 .46056 L\n.17238 .46098 L\n.17429 .46095 L\n.17619 .46049 L\n.1781 .45958 L\n.18 .45823 L\n.1819 .45644 L\n.18381 .45421 L\n.18571 .45153 L\n.18762 .44842 L\n.18952 .44486 L\n.19143 .44087 L\n.19333 .43643 L\n.19524 .43155 L\n.19714 .42623 L\n.19905 .42046 L\n.20095 .41426 L\n.20286 .40762 L\n.20476 .40053 L\nMistroke\n.20667 .393 L\n.20857 .38503 L\n.21048 .37663 L\n.21238 .36777 L\n.21429 .35848 L\n.21619 .34875 L\n.2181 .33857 L\n.22 .32796 L\n.221 .32219 L\n.221 .32219 L\n.221 .32219 L\n.221 .32219 L\n.2219 .32686 L\n.22381 .33639 L\n.22571 .34548 L\n.22762 .35413 L\n.22952 .36234 L\n.23143 .37011 L\n.23333 .37743 L\n.23524 .38432 L\n.23714 .39076 L\n.23905 .39676 L\n.24095 .40233 L\n.24286 .40745 L\n.24476 .41212 L\n.24667 .41636 L\n.24857 .42016 L\n.25048 .42351 L\n.25238 .42643 L\n.25429 .4289 L\n.25619 .43093 L\n.2581 .43252 L\n.26 .43367 L\n.2619 .43438 L\n.26381 .43464 L\n.26571 .43447 L\n.26762 .43385 L\n.26952 .43279 L\n.27143 .43129 L\n.27333 .42935 L\n.27524 .42697 L\n.27714 .42415 L\n.27905 .42089 L\n.28095 .41718 L\n.28286 .41304 L\n.28476 .40845 L\n.28667 .40342 L\n.28857 .39795 L\n.29048 .39204 L\n.29238 .38568 L\nMistroke\n.29429 .37889 L\n.29619 .37165 L\n.2981 .36398 L\n.3 .35586 L\n.3019 .3473 L\n.30381 .3383 L\n.30571 .32886 L\n.30701 .32219 L\n.30701 .32219 L\n.30701 .32219 L\n.30701 .32219 L\n.30762 .32504 L\n.30952 .33364 L\n.31143 .3418 L\n.31333 .34953 L\n.31524 .35681 L\n.31714 .36365 L\n.31905 .37004 L\n.32095 .376 L\n.32286 .38151 L\n.32476 .38659 L\n.32667 .39122 L\n.32857 .39541 L\n.33048 .39916 L\n.33238 .40247 L\n.33429 .40534 L\n.33619 .40777 L\n.3381 .40975 L\n.34 .41129 L\n.3419 .4124 L\n.34381 .41306 L\n.34571 .41328 L\n.34762 .41306 L\n.34952 .41239 L\n.35143 .41129 L\n.35333 .40975 L\n.35524 .40776 L\n.35714 .40533 L\n.35905 .40246 L\n.36095 .39915 L\n.36286 .3954 L\n.36476 .39121 L\n.36667 .38658 L\n.36857 .3815 L\n.37048 .37598 L\n.37238 .37003 L\n.37429 .36363 L\n.37619 .35679 L\n.3781 .34951 L\n.38 .34178 L\nMistroke\n.3819 .33362 L\n.38381 .32501 L\n.38441 .32219 L\n.38441 .32219 L\n.38441 .32219 L\n.38441 .32219 L\n.38571 .32759 L\n.38762 .33514 L\n.38952 .34225 L\n.39143 .34891 L\n.39333 .35514 L\n.39524 .36092 L\n.39714 .36626 L\n.39905 .37116 L\n.40095 .37562 L\n.40286 .37964 L\n.40476 .38321 L\n.40667 .38635 L\n.40857 .38904 L\n.41048 .39129 L\n.41238 .3931 L\n.41429 .39447 L\n.41619 .3954 L\n.4181 .39589 L\n.42 .39594 L\n.4219 .39554 L\n.42381 .39471 L\n.42571 .39343 L\n.42762 .39171 L\n.42952 .38955 L\n.43143 .38695 L\n.43333 .3839 L\n.43524 .38042 L\n.43714 .3765 L\n.43905 .37213 L\n.44095 .36732 L\n.44286 .36207 L\n.44476 .35638 L\n.44667 .35025 L\n.44857 .34368 L\n.45048 .33666 L\n.45238 .32921 L\n.45408 .32219 L\n.45408 .32219 L\n.45408 .32219 L\n.45408 .32219 L\n.45429 .32297 L\n.45619 .32997 L\n.4581 .33652 L\n.46 .34263 L\nMistroke\n.4619 .3483 L\n.46381 .35353 L\n.46571 .35832 L\n.46762 .36266 L\n.46952 .36657 L\n.47143 .37003 L\n.47333 .37306 L\n.47524 .37564 L\n.47714 .37778 L\n.47905 .37948 L\n.48095 .38073 L\n.48286 .38155 L\n.48476 .38193 L\n.48667 .38186 L\n.48857 .38135 L\n.49048 .3804 L\n.49238 .37901 L\n.49429 .37718 L\n.49619 .37491 L\n.4981 .3722 L\n.5 .36904 L\n.5019 .36544 L\n.50381 .36141 L\n.50571 .35693 L\n.50762 .35201 L\n.50952 .34665 L\n.51143 .34084 L\n.51333 .3346 L\n.51524 .32792 L\n.51678 .32219 L\n.51678 .32219 L\n.51678 .32219 L\n.51678 .32219 L\n.51714 .32343 L\n.51905 .32967 L\n.52095 .33545 L\n.52286 .3408 L\n.52476 .34571 L\n.52667 .35018 L\n.52857 .3542 L\n.53048 .35778 L\n.53238 .36093 L\n.53429 .36363 L\n.53619 .36589 L\n.5381 .36771 L\n.54 .36908 L\n.5419 .37002 L\n.54381 .37051 L\n.54571 .37057 L\n.54762 .37018 L\nMistroke\n.54952 .36935 L\n.55143 .36808 L\n.55333 .36637 L\n.55524 .36421 L\n.55714 .36162 L\n.55905 .35858 L\n.56095 .35511 L\n.56286 .35119 L\n.56476 .34683 L\n.56667 .34203 L\n.56857 .33679 L\n.57048 .3311 L\n.57238 .32498 L\n.57321 .32219 L\n.57321 .32219 L\n.57321 .32219 L\n.57321 .32219 L\n.57429 .32545 L\n.57619 .33086 L\n.5781 .33583 L\n.58 .34036 L\n.5819 .34445 L\n.58381 .3481 L\n.58571 .3513 L\n.58762 .35407 L\n.58952 .35639 L\n.59143 .35827 L\n.59333 .35971 L\n.59524 .36071 L\n.59714 .36127 L\n.59905 .36139 L\n.60095 .36106 L\n.60286 .3603 L\n.60476 .35909 L\n.60667 .35744 L\n.60857 .35535 L\n.61048 .35282 L\n.61238 .34985 L\n.61429 .34644 L\n.61619 .34258 L\n.6181 .33829 L\n.62 .33355 L\n.6219 .32837 L\n.62381 .32275 L\n.62399 .32219 L\n.62399 .32219 L\n.62399 .32219 L\n.62399 .32219 L\n.62571 .3268 L\n.62762 .33147 L\nMistroke\n.62952 .3357 L\n.63143 .3395 L\n.63333 .34285 L\n.63524 .34576 L\n.63714 .34823 L\n.63905 .35025 L\n.64095 .35184 L\n.64286 .35298 L\n.64476 .35369 L\n.64667 .35395 L\n.64857 .35377 L\n.65048 .35315 L\n.65238 .35209 L\n.65429 .35058 L\n.65619 .34864 L\n.6581 .34625 L\n.66 .34343 L\n.6619 .34016 L\n.66381 .33645 L\n.66571 .3323 L\n.66762 .32771 L\n.66952 .32267 L\n.6697 .32219 L\n.6697 .32219 L\n.6697 .32219 L\n.6697 .32219 L\n.67143 .32633 L\n.67333 .33048 L\n.67524 .33418 L\n.67714 .33744 L\n.67905 .34026 L\n.68095 .34264 L\n.68286 .34458 L\n.68476 .34607 L\n.68667 .34713 L\n.68857 .34774 L\n.69048 .34791 L\n.69238 .34764 L\n.69429 .34693 L\n.69619 .34578 L\n.6981 .34419 L\n.7 .34215 L\n.7019 .33968 L\n.70381 .33676 L\n.70571 .33341 L\n.70762 .32961 L\n.70952 .32537 L\n.71084 .32219 L\n.71084 .32219 L\n.71084 .32219 L\nMistroke\n.71084 .32219 L\n.71143 .3235 L\n.71333 .32743 L\n.71524 .33092 L\n.71714 .33397 L\n.71905 .33658 L\n.72095 .33874 L\n.72286 .34047 L\n.72476 .34175 L\n.72667 .34259 L\n.72857 .34299 L\n.73048 .34295 L\n.73238 .34247 L\n.73429 .34154 L\n.73619 .34018 L\n.7381 .33837 L\n.74 .33613 L\n.7419 .33344 L\n.74381 .33031 L\n.74571 .32674 L\n.74762 .32272 L\n.74786 .32219 L\n.74786 .32219 L\n.74786 .32219 L\n.74786 .32219 L\n.74952 .3254 L\n.75143 .32865 L\n.75333 .33146 L\n.75524 .33383 L\n.75714 .33576 L\n.75905 .33725 L\n.76095 .33829 L\n.76286 .3389 L\n.76476 .33906 L\n.76667 .33879 L\n.76857 .33807 L\n.77048 .33691 L\n.77238 .33531 L\n.77429 .33327 L\n.77619 .33078 L\n.7781 .32786 L\n.78 .32449 L\n.78118 .32219 L\n.78118 .32219 L\n.78118 .32219 L\n.78118 .32219 L\n.7819 .32348 L\n.78381 .32657 L\n.78571 .32921 L\n.78762 .33141 L\nMistroke\n.78952 .33317 L\n.79143 .33449 L\n.79333 .33537 L\n.79524 .33581 L\n.79714 .3358 L\n.79905 .33536 L\n.80095 .33447 L\n.80286 .33314 L\n.80476 .33137 L\n.80667 .32916 L\n.80857 .32651 L\n.81048 .32342 L\n.81117 .32219 L\n.81117 .32219 L\n.81117 .32219 L\n.81117 .32219 L\n.81238 .32409 L\n.81429 .32672 L\n.81619 .3289 L\n.8181 .33064 L\n.82 .33194 L\n.8219 .3328 L\n.82381 .33322 L\n.82571 .3332 L\n.82762 .33273 L\n.82952 .33183 L\n.83143 .33048 L\n.83333 .32869 L\n.83524 .32646 L\n.83714 .32379 L\n.83816 .32219 L\n.83816 .32219 L\n.83816 .32219 L\n.83816 .32219 L\n.83905 .32346 L\n.84095 .32584 L\n.84286 .32779 L\n.84476 .32929 L\n.84667 .33036 L\n.84857 .33098 L\n.85048 .33116 L\n.85238 .3309 L\n.85429 .33019 L\n.85619 .32905 L\n.8581 .32747 L\n.86 .32544 L\n.8619 .32297 L\n.86245 .32219 L\n.86245 .32219 L\n.86245 .32219 L\nMistroke\n.86245 .32219 L\n.86381 .32389 L\n.86571 .32588 L\n.86762 .32744 L\n.86952 .32855 L\n.87143 .32922 L\n.87333 .32945 L\n.87524 .32924 L\n.87714 .32859 L\n.87905 .3275 L\n.88095 .32597 L\n.88286 .32399 L\n.88431 .32219 L\n.88431 .32219 L\n.88431 .32219 L\n.88431 .32219 L\n.88476 .32272 L\n.88667 .32467 L\n.88857 .32618 L\n.89048 .32726 L\n.89238 .32789 L\n.89429 .32807 L\n.89619 .32782 L\n.8981 .32713 L\n.9 .32599 L\n.9019 .32441 L\n.90381 .3224 L\n.90398 .32219 L\n.90398 .32219 L\n.90398 .32219 L\n.90398 .32219 L\n.90571 .32387 L\n.90762 .3253 L\n.90952 .32629 L\n.91143 .32684 L\n.91333 .32694 L\n.91524 .32661 L\n.91714 .32583 L\n.91905 .32461 L\n.92095 .32295 L\n.92169 .32219 L\n.92169 .32219 L\n.92169 .32219 L\n.92169 .32219 L\n.92286 .32324 L\n.92476 .32459 L\n.92667 .32551 L\n.92857 .32598 L\n.93048 .32601 L\n.93238 .3256 L\nMistroke\n.93429 .32475 L\n.93619 .32346 L\n.93763 .32219 L\n.93763 .32219 L\n.93763 .32219 L\n.93763 .32219 L\n.9381 .32258 L\n.94 .32392 L\n.9419 .32481 L\n.94381 .32526 L\n.94571 .32527 L\n.94762 .32483 L\n.94952 .32396 L\n.95143 .32265 L\n.95197 .32219 L\n.95197 .32219 L\n.95197 .32219 L\n.95197 .32219 L\n.95333 .32314 L\n.95524 .3241 L\n.95714 .32462 L\n.95905 .3247 L\n.96095 .32433 L\n.96286 .32353 L\n.96476 .32228 L\n.96488 .32219 L\n.96488 .32219 L\n.96488 .32219 L\n.96488 .32219 L\n.96667 .32326 L\n.96857 .32397 L\n.97048 .32424 L\n.97238 .32407 L\n.97429 .32346 L\n.97619 .3224 L\nMfstroke\n0 .5 0 r\n.02381 .60332 m\n.02571 .59229 L\n.02762 .58126 L\n.02952 .57022 L\n.03143 .55919 L\n.03333 .54816 L\n.03524 .53713 L\n.03714 .5261 L\n.03905 .51507 L\n.04095 .50404 L\n.04286 .493 L\n.04476 .48197 L\n.04667 .47094 L\n.04857 .45991 L\n.05048 .44888 L\n.05238 .43785 L\n.05429 .42681 L\n.05619 .41578 L\n.0581 .40475 L\n.06 .39372 L\n.0619 .38269 L\n.06381 .37166 L\n.06571 .36063 L\n.06762 .34959 L\n.06952 .33856 L\n.07143 .32753 L\n.07333 .3165 L\n.07524 .30547 L\n.07714 .29444 L\n.07905 .2834 L\n.08095 .27237 L\n.08286 .26134 L\n.08476 .25031 L\n.08667 .23928 L\n.08857 .22825 L\n.09048 .21722 L\n.09238 .20618 L\n.09429 .19515 L\n.09619 .18412 L\n.0981 .17309 L\n.1 .16206 L\n.1019 .15103 L\n.10381 .13999 L\n.10571 .12896 L\n.10762 .11793 L\n.10952 .1069 L\n.11143 .09587 L\n.11333 .08484 L\n.11524 .07381 L\n.11714 .06277 L\nMistroke\n.11905 .05174 L\n.12095 .04071 L\n.12286 .02968 L\n.12476 .01865 L\n.12544 .01472 L\n.12544 .59892 L\n.12544 .59892 L\n.12544 .59892 L\n.12667 .59182 L\n.12857 .58079 L\n.13048 .56975 L\n.13238 .55872 L\n.13429 .54769 L\n.13619 .53666 L\n.1381 .52563 L\n.14 .5146 L\n.1419 .50356 L\n.14381 .49253 L\n.14571 .4815 L\n.14762 .47047 L\n.14952 .45944 L\n.15143 .44841 L\n.15333 .43738 L\n.15524 .42634 L\n.15714 .41531 L\n.15905 .40428 L\n.16095 .39325 L\n.16286 .38222 L\n.16476 .37119 L\n.16667 .36016 L\n.16857 .34912 L\n.17048 .33809 L\n.17238 .32706 L\n.17429 .31603 L\n.17619 .305 L\n.1781 .29397 L\n.18 .28293 L\n.1819 .2719 L\n.18381 .26087 L\n.18571 .24984 L\n.18762 .23881 L\n.18952 .22778 L\n.19143 .21675 L\n.19333 .20571 L\n.19524 .19468 L\n.19714 .18365 L\n.19905 .17262 L\n.20095 .16159 L\n.20286 .15056 L\n.20476 .13952 L\nMistroke\n.20667 .12849 L\n.20857 .11746 L\n.21048 .10643 L\n.21238 .0954 L\n.21429 .08437 L\n.21619 .07334 L\n.2181 .0623 L\n.22 .05127 L\n.221 .04546 L\n.221 .57124 L\n.221 .57124 L\n.221 .57124 L\n.2219 .56602 L\n.22381 .55499 L\n.22571 .54396 L\n.22762 .53293 L\n.22952 .5219 L\n.23143 .51086 L\n.23333 .49983 L\n.23524 .4888 L\n.23714 .47777 L\n.23905 .46674 L\n.24095 .45571 L\n.24286 .44467 L\n.24476 .43364 L\n.24667 .42261 L\n.24857 .41158 L\n.25048 .40055 L\n.25238 .38952 L\n.25429 .37849 L\n.25619 .36745 L\n.2581 .35642 L\n.26 .34539 L\n.2619 .33436 L\n.26381 .32333 L\n.26571 .3123 L\n.26762 .30126 L\n.26952 .29023 L\n.27143 .2792 L\n.27333 .26817 L\n.27524 .25714 L\n.27714 .24611 L\n.27905 .23508 L\n.28095 .22404 L\n.28286 .21301 L\n.28476 .20198 L\n.28667 .19095 L\n.28857 .17992 L\n.29048 .16889 L\n.29238 .15786 L\nMistroke\n.29429 .14682 L\n.29619 .13579 L\n.2981 .12476 L\n.3 .11373 L\n.3019 .1027 L\n.30381 .09167 L\n.30571 .08063 L\n.30701 .07314 L\n.30701 .54634 L\n.30701 .54634 L\n.30701 .54634 L\n.30762 .54281 L\n.30952 .53177 L\n.31143 .52074 L\n.31333 .50971 L\n.31524 .49868 L\n.31714 .48765 L\n.31905 .47662 L\n.32095 .46558 L\n.32286 .45455 L\n.32476 .44352 L\n.32667 .43249 L\n.32857 .42146 L\n.33048 .41043 L\n.33238 .3994 L\n.33429 .38836 L\n.33619 .37733 L\n.3381 .3663 L\n.34 .35527 L\n.3419 .34424 L\n.34381 .33321 L\n.34571 .32217 L\n.34762 .31114 L\n.34952 .30011 L\n.35143 .28908 L\n.35333 .27805 L\n.35524 .26702 L\n.35714 .25599 L\n.35905 .24495 L\n.36095 .23392 L\n.36286 .22289 L\n.36476 .21186 L\n.36667 .20083 L\n.36857 .1898 L\n.37048 .17877 L\n.37238 .16773 L\n.37429 .1567 L\n.37619 .14567 L\n.3781 .13464 L\n.38 .12361 L\nMistroke\n.3819 .11258 L\n.38381 .10154 L\n.38441 .09804 L\n.38441 .52392 L\n.38441 .52392 L\n.38441 .52392 L\n.38571 .5164 L\n.38762 .50536 L\n.38952 .49433 L\n.39143 .4833 L\n.39333 .47227 L\n.39524 .46124 L\n.39714 .45021 L\n.39905 .43917 L\n.40095 .42814 L\n.40286 .41711 L\n.40476 .40608 L\n.40667 .39505 L\n.40857 .38402 L\n.41048 .37299 L\n.41238 .36195 L\n.41429 .35092 L\n.41619 .33989 L\n.4181 .32886 L\n.42 .31783 L\n.4219 .3068 L\n.42381 .29576 L\n.42571 .28473 L\n.42762 .2737 L\n.42952 .26267 L\n.43143 .25164 L\n.43333 .24061 L\n.43524 .22958 L\n.43714 .21854 L\n.43905 .20751 L\n.44095 .19648 L\n.44286 .18545 L\n.44476 .17442 L\n.44667 .16339 L\n.44857 .15235 L\n.45048 .14132 L\n.45238 .13029 L\n.45408 .12046 L\n.45408 .50375 L\n.45408 .50375 L\n.45408 .50375 L\n.45429 .50255 L\n.45619 .49152 L\n.4581 .48049 L\n.46 .46946 L\nMistroke\n.4619 .45843 L\n.46381 .4474 L\n.46571 .43637 L\n.46762 .42533 L\n.46952 .4143 L\n.47143 .40327 L\n.47333 .39224 L\n.47524 .38121 L\n.47714 .37018 L\n.47905 .35914 L\n.48095 .34811 L\n.48286 .33708 L\n.48476 .32605 L\n.48667 .31502 L\n.48857 .30399 L\n.49048 .29296 L\n.49238 .28192 L\n.49429 .27089 L\n.49619 .25986 L\n.4981 .24883 L\n.5 .2378 L\n.5019 .22677 L\n.50381 .21573 L\n.50571 .2047 L\n.50762 .19367 L\n.50952 .18264 L\n.51143 .17161 L\n.51333 .16058 L\n.51524 .14955 L\n.51678 .14063 L\n.51678 .48559 L\n.51678 .48559 L\n.51678 .48559 L\n.51714 .48348 L\n.51905 .47245 L\n.52095 .46142 L\n.52286 .45038 L\n.52476 .43935 L\n.52667 .42832 L\n.52857 .41729 L\n.53048 .40626 L\n.53238 .39523 L\n.53429 .38419 L\n.53619 .37316 L\n.5381 .36213 L\n.54 .3511 L\n.5419 .34007 L\n.54381 .32904 L\n.54571 .31801 L\n.54762 .30697 L\nMistroke\n.54952 .29594 L\n.55143 .28491 L\n.55333 .27388 L\n.55524 .26285 L\n.55714 .25182 L\n.55905 .24079 L\n.56095 .22975 L\n.56286 .21872 L\n.56476 .20769 L\n.56667 .19666 L\n.56857 .18563 L\n.57048 .1746 L\n.57238 .16356 L\n.57321 .15878 L\n.57321 .46925 L\n.57321 .46925 L\n.57321 .46925 L\n.57429 .463 L\n.57619 .45197 L\n.5781 .44094 L\n.58 .42991 L\n.5819 .41888 L\n.58381 .40784 L\n.58571 .39681 L\n.58762 .38578 L\n.58952 .37475 L\n.59143 .36372 L\n.59333 .35269 L\n.59524 .34165 L\n.59714 .33062 L\n.59905 .31959 L\n.60095 .30856 L\n.60286 .29753 L\n.60476 .2865 L\n.60667 .27547 L\n.60857 .26443 L\n.61048 .2534 L\n.61238 .24237 L\n.61429 .23134 L\n.61619 .22031 L\n.6181 .20928 L\n.62 .19824 L\n.6219 .18721 L\n.62381 .17618 L\n.62399 .17513 L\n.62399 .45455 L\n.62399 .45455 L\n.62399 .45455 L\n.62571 .44457 L\n.62762 .43354 L\nMistroke\n.62952 .42251 L\n.63143 .41148 L\n.63333 .40045 L\n.63524 .38941 L\n.63714 .37838 L\n.63905 .36735 L\n.64095 .35632 L\n.64286 .34529 L\n.64476 .33426 L\n.64667 .32322 L\n.64857 .31219 L\n.65048 .30116 L\n.65238 .29013 L\n.65429 .2791 L\n.65619 .26807 L\n.6581 .25704 L\n.66 .246 L\n.6619 .23497 L\n.66381 .22394 L\n.66571 .21291 L\n.66762 .20188 L\n.66952 .19085 L\n.6697 .18983 L\n.6697 .44131 L\n.6697 .44131 L\n.6697 .44131 L\n.67143 .43129 L\n.67333 .42026 L\n.67524 .40923 L\n.67714 .3982 L\n.67905 .38717 L\n.68095 .37614 L\n.68286 .3651 L\n.68476 .35407 L\n.68667 .34304 L\n.68857 .33201 L\n.69048 .32098 L\n.69238 .30995 L\n.69429 .29892 L\n.69619 .28788 L\n.6981 .27685 L\n.7 .26582 L\n.7019 .25479 L\n.70381 .24376 L\n.70571 .23273 L\n.70762 .22169 L\n.70952 .21066 L\n.71084 .20307 L\n.71084 .4294 L\n.71084 .4294 L\nMistroke\n.71084 .4294 L\n.71143 .42596 L\n.71333 .41493 L\n.71524 .4039 L\n.71714 .39287 L\n.71905 .38184 L\n.72095 .37081 L\n.72286 .35977 L\n.72476 .34874 L\n.72667 .33771 L\n.72857 .32668 L\n.73048 .31565 L\n.73238 .30462 L\n.73429 .29358 L\n.73619 .28255 L\n.7381 .27152 L\n.74 .26049 L\n.7419 .24946 L\n.74381 .23843 L\n.74571 .2274 L\n.74762 .21636 L\n.74786 .21498 L\n.74786 .41868 L\n.74786 .41868 L\n.74786 .41868 L\n.74952 .40903 L\n.75143 .398 L\n.75333 .38697 L\n.75524 .37594 L\n.75714 .3649 L\n.75905 .35387 L\n.76095 .34284 L\n.76286 .33181 L\n.76476 .32078 L\n.76667 .30975 L\n.76857 .29872 L\n.77048 .28768 L\n.77238 .27665 L\n.77429 .26562 L\n.77619 .25459 L\n.7781 .24356 L\n.78 .23253 L\n.78118 .2257 L\n.78118 .40903 L\n.78118 .40903 L\n.78118 .40903 L\n.7819 .40482 L\n.78381 .39379 L\n.78571 .38276 L\n.78762 .37173 L\nMistroke\n.78952 .3607 L\n.79143 .34967 L\n.79333 .33863 L\n.79524 .3276 L\n.79714 .31657 L\n.79905 .30554 L\n.80095 .29451 L\n.80286 .28348 L\n.80476 .27244 L\n.80667 .26141 L\n.80857 .25038 L\n.81048 .23935 L\n.81117 .23535 L\n.81117 .40035 L\n.81117 .40035 L\n.81117 .40035 L\n.81238 .39331 L\n.81429 .38228 L\n.81619 .37125 L\n.8181 .36022 L\n.82 .34919 L\n.8219 .33816 L\n.82381 .32713 L\n.82571 .31609 L\n.82762 .30506 L\n.82952 .29403 L\n.83143 .283 L\n.83333 .27197 L\n.83524 .26094 L\n.83714 .2499 L\n.83816 .24403 L\n.83816 .39253 L\n.83816 .39253 L\n.83816 .39253 L\n.83905 .38737 L\n.84095 .37634 L\n.84286 .36531 L\n.84476 .35427 L\n.84667 .34324 L\n.84857 .33221 L\n.85048 .32118 L\n.85238 .31015 L\n.85429 .29912 L\n.85619 .28809 L\n.8581 .27705 L\n.86 .26602 L\n.8619 .25499 L\n.86245 .25185 L\n.86245 .3855 L\n.86245 .3855 L\nMistroke\n.86245 .3855 L\n.86381 .37761 L\n.86571 .36657 L\n.86762 .35554 L\n.86952 .34451 L\n.87143 .33348 L\n.87333 .32245 L\n.87524 .31142 L\n.87714 .30038 L\n.87905 .28935 L\n.88095 .27832 L\n.88286 .26729 L\n.88431 .25888 L\n.88431 .37916 L\n.88431 .37916 L\n.88431 .37916 L\n.88476 .37654 L\n.88667 .36551 L\n.88857 .35448 L\n.89048 .34345 L\n.89238 .33241 L\n.89429 .32138 L\n.89619 .31035 L\n.8981 .29932 L\n.9 .28829 L\n.9019 .27726 L\n.90381 .26623 L\n.90398 .26521 L\n.90398 .37347 L\n.90398 .37347 L\n.90398 .37347 L\n.90571 .36345 L\n.90762 .35242 L\n.90952 .34138 L\n.91143 .33035 L\n.91333 .31932 L\n.91524 .30829 L\n.91714 .29726 L\n.91905 .28623 L\n.92095 .27519 L\n.92169 .27091 L\n.92169 .36834 L\n.92169 .36834 L\n.92169 .36834 L\n.92286 .36159 L\n.92476 .35056 L\n.92667 .33953 L\n.92857 .3285 L\n.93048 .31747 L\n.93238 .30643 L\nMistroke\n.93429 .2954 L\n.93619 .28437 L\n.93763 .27604 L\n.93763 .36372 L\n.93763 .36372 L\n.93763 .36372 L\n.9381 .36102 L\n.94 .34999 L\n.9419 .33896 L\n.94381 .32793 L\n.94571 .3169 L\n.94762 .30587 L\n.94952 .29484 L\n.95143 .2838 L\n.95197 .28065 L\n.95197 .35957 L\n.95197 .35957 L\n.95197 .35957 L\n.95333 .35169 L\n.95524 .34066 L\n.95714 .32963 L\n.95905 .31859 L\n.96095 .30756 L\n.96286 .29653 L\n.96476 .2855 L\n.96488 .28481 L\n.96488 .35583 L\n.96488 .35583 L\n.96488 .35583 L\n.96667 .34549 L\n.96857 .33446 L\n.97048 .32343 L\n.97238 .3124 L\n.97429 .30137 L\n.97619 .29034 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(velocity) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(@) show\n117.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n123.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(height) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@0E0=WIf@03001o\n003IfMT0fMWI0>T0fMWI000L0=WIf@030000003IfMT0fMWI01D0fMWI00<007l00=WIf@3IfMT0j@3I\nfMT001`0fMWI00<000000=WIf@3IfMT05@3IfMT00`00O`00fMWI0=WIf@3Y0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0D0=WIf@8007l0j`3IfMT000h0fMWI1@0000020=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@0D0=WIf@8007l0j`3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0503IfMT2001o0>/0fMWI000@0=WIf@050000\n003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@8000005@3IfMT2001o0>/0\nfMWI00080=WIf@@00000103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@0D0=WIf@8007l0j`3IfMT00100fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0503IfMT2001o01H0\nfMWI00<007l00=WIf@3IfMT0dP3IfMT000l0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@0D0=WIf@8007l05P3IfMT00`00O`00fMWI0=WIf@3B0=WIf@00703IfMT00`000000fMWI0=WI\nf@0D0=WIf@8007l05P3IfMT00`00O`00fMWI0=WIf@3B0=WIf@00703IfMT00`000000fMWI0=WIf@0C\n0=WIf@03001o003IfMT007l001D0fMWI0P00O`3D0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WI\nf@03001o003IfMT007l001D0fMWI0P00O`3D0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@03\n001o003IfMT007l001D0fMWI0P00O`3D0=WIf@00703IfMT00`000000fMWI0=WIf@0C0=WIf@03001o\n003IfMT007l001D0fMWI0P00O`0D0=WIf@03001o003IfMT0fMWI0;d0fMWI000L0=WIf@030000003I\nfMT0fMWI01<0fMWI00<007l00=WIf@00O`005@3IfMT2001o01@0fMWI00<007l00=WIf@3IfMT0_@3I\nfMT001`0fMWI00<000000=WIf@3IfMT04P3IfMT01000O`00fMWI0=WIf@00O`0E0=WIf@8007l0503I\nfMT00`00O`00fMWI0=WIf@2m0=WIf@00703IfMT00`000000fMWI0=WIf@0B0=WIf@04001o003IfMT0\nfMWI001o01D0fMWI0P00O`0D0=WIf@03001o003IfMT0fMWI0;d0fMWI000L0=WIf@030000003IfMT0\nfMWI0180fMWI00@007l00=WIf@3IfMT007l05@3IfMT2001o01<0fMWI0P00O`2o0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0B0=WIf@04001o003IfMT0fMWI001o01@0fMWI00<007l00=WIf@00O`004`3I\nfMT2001o0;l0fMWI000L0=WIf@030000003IfMT0fMWI0180fMWI00@007l00=WIf@3IfMT007l0503I\nfMT00`00O`00fMWI001o000C0=WIf@8007l04P3IfMT00`00O`00fMWI0=WIf@2Z0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0A0=WIf@05001o003IfMT0fMWI0=WIf@00O`00503IfMT00`00O`00fMWI001o\n000C0=WIf@8007l04P3IfMT00`00O`00fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@0A\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`00503IfMT00`00O`00fMWI001o000C0=WIf@8007l04P3I\nfMT00`00O`00fMWI0=WIf@2Z0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@05001o003IfMT0\nfMWI0=WIf@00O`00503IfMT00`00O`00fMWI001o000B0=WIf@03001o003IfMT007l00140fMWI0P00\nO`2/0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@05001o003IfMT0fMWI0=WIf@00O`004`3I\nfMT01000O`00fMWI0=WIf@00O`0B0=WIf@03001o003IfMT007l00140fMWI0P00O`2/0=WIf@00703I\nfMT00`000000fMWI0=WIf@0A0=WIf@05001o003IfMT0fMWI0=WIf@00O`004`3IfMT01000O`00fMWI\n0=WIf@00O`0B0=WIf@03001o003IfMT007l00140fMWI0P00O`2/0=WIf@00703IfMT00`000000fMWI\n0=WIf@0A0=WIf@05001o003IfMT0fMWI0=WIf@00O`004`3IfMT01000O`00fMWI0=WIf@00O`0B0=WI\nf@03001o003IfMT007l00140fMWI0P00O`0?0=WIf@03001o003IfMT0fMWI09X0fMWI000L0=WIf@03\n0000003IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0A0=WIf@04\n001o003IfMT0fMWI001o0180fMWI00<007l00=WIf@00O`004@3IfMT2001o00l0fMWI00<007l00=WI\nf@3IfMT0VP3IfMT001`0fMWI00<000000=WIf@3IfMT0403IfMT00`00O`00fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI0140fMWI00@007l00=WIf@3IfMT007l04@3IfMT01000O`00fMWI0=WIf@00O`0@\n0=WIf@03001o003IfMT007l000l0fMWI00<007l00=WIf@3IfMT0VP3IfMT001`0fMWI00<000000=WI\nf@3IfMT0403IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI0100fMWI00D007l00=WI\nf@3IfMT0fMWI001o000A0=WIf@04001o003IfMT0fMWI001o0100fMWI00<007l00=WIf@00O`003`3I\nfMT00`00O`00fMWI0=WIf@2J0=WIf@00703IfMT00`000000fMWI0=WIf@0@0=WIf@03001o003IfMT0\nfMWI0080fMWI00<007l00=WIf@3IfMT0403IfMT01@00O`00fMWI0=WIf@3IfMT007l00140fMWI00@0\n07l00=WIf@3IfMT007l0403IfMT00`00O`00fMWI001o000?0=WIf@03001o003IfMT0fMWI09X0fMWI\n000L0=WIf@030000003IfMT0fMWI0100fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@0@0=WIf@05001o003IfMT0fMWI0=WIf@00O`004@3IfMT01000O`00fMWI0=WIf@00O`0@0=WIf@03\n001o003IfMT007l000l0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@2:0=WIf@00\n703IfMT00`000000fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0\n403IfMT01@00O`00fMWI0=WIf@3IfMT007l00140fMWI00@007l00=WIf@3IfMT007l0403IfMT00`00\nO`00fMWI001o000>0=WIf@8007l03P3IfMT2001o08`0fMWI000L0=WIf@030000003IfMT0fMWI00l0\nfMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0@0=WIf@05001o003IfMT0fMWI0=WI\nf@00O`004@3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@04001o003IfMT0fMWI001o00h0fMWI0P00\nO`0>0=WIf@8007l0S03IfMT001`0fMWI00<000000=WIf@3IfMT03`3IfMT00`00O`00fMWI0=WIf@03\n0=WIf@03001o003IfMT0fMWI0100fMWI00D007l00=WIf@3IfMT0fMWI001o000@0=WIf@05001o003I\nfMT0fMWI0=WIf@00O`003`3IfMT01000O`00fMWI0=WIf@00O`0>0=WIf@8007l03P3IfMT2001o08`0\nfMWI000L0=WIf@030000003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI\n0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT03P3IfMT01@00O`00fMWI\n0=WIf@3IfMT007l000l0fMWI00@007l00=WIf@3IfMT007l03P3IfMT2001o00h0fMWI0P00O`0<0=WI\nf@03001o003IfMT0fMWI07d0fMWI000L0=WIf@030000003IfMT0fMWI00l0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT03P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000l0fMWI00@007l00=WIf@3IfMT007l03P3IfMT2\n001o00h0fMWI0P00O`0<0=WIf@03001o003IfMT0fMWI07d0fMWI000L0=WIf@030000003IfMT0fMWI\n00h0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI\n0080fMWI00<007l00=WIf@3IfMT03P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000l0fMWI00@007l0\n0=WIf@3IfMT007l03P3IfMT2001o00d0fMWI00<007l00=WIf@00O`00303IfMT00`00O`00fMWI0=WI\nf@1m0=WIf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WIf@04\n0=WIf@03001o003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0>\n0=WIf@05001o003IfMT0fMWI0=WIf@00O`003`3IfMT01000O`00fMWI0=WIf@00O`0=0=WIf@03001o\n003IfMT007l000d0fMWI00<007l00=WIf@00O`00303IfMT00`00O`00fMWI0=WIf@1m0=WIf@00503I\nfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00h0fMWI00<007l00=WIf@3IfMT0\n103IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n3@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00`0fMWI00D007l00=WIf@3IfMT0\nfMWI001o000=0=WIf@03001o003IfMT007l000d0fMWI00<007l00=WIf@00O`00303IfMT00`00O`00\nfMWI0=WIf@090=WIf@8007l0LP3IfMT001L0fMWI00<000000=WIf@3IfMT00P3IfMT2000000l0fMWI\n00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI\n00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00`0fMWI\n00D007l00=WIf@3IfMT0fMWI001o000=0=WIf@03001o003IfMT007l000d0fMWI00<007l00=WIf@00\nO`002`3IfMT2001o00/0fMWI0P00O`1b0=WIf@003P3IfMT4000000<0fMWI0P0000050=WIf@030000\n003IfMT0fMWI00h0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0>0=WIf@03001o\n003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00`0fMWI00D007l00=WIf@3IfMT0fMWI001o000=0=WIf@03001o003IfMT007l000d0\nfMWI00<007l00=WIf@00O`002`3IfMT2001o00/0fMWI0P00O`1b0=WIf@005@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI00h0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI\n0=WIf@0>0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI\n0=WIf@020=WIf@03001o003IfMT0fMWI00`0fMWI00D007l00=WIf@3IfMT0fMWI001o000=0=WIf@03\n001o003IfMT007l000`0fMWI00@007l00=WIf@3IfMT007l02`3IfMT2001o00/0fMWI0P00O`0:0=WI\nf@03001o003IfMT0fMWI06D0fMWI000E0=WIf@<00000103IfMT00`000000fMWI0=WIf@0>0=WIf@03\n001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03P3IfMT00`00O`00fMWI0=WIf@030=WIf@03\n001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@05\n001o003IfMT0fMWI0=WIf@00O`00303IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@04001o003IfMT0\nfMWI001o00/0fMWI0P00O`0;0=WIf@8007l02P3IfMT00`00O`00fMWI0=WIf@1U0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0>0=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03P3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT00P3IfMT0\n0`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02P3IfMT0\n1000O`00fMWI0=WIf@00O`0<0=WIf@04001o003IfMT0fMWI001o00/0fMWI0P00O`0;0=WIf@8007l0\n2@3IfMT2001o06L0fMWI000L0=WIf@030000003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT01@3I\nfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT03@3I\nfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT00P3I\nfMT00`00O`00fMWI0=WIf@0:0=WIf@04001o003IfMT0fMWI001o00`0fMWI00@007l00=WIf@3IfMT0\n07l02`3IfMT2001o00/0fMWI0P00O`090=WIf@8007l0I`3IfMT001`0fMWI00<000000=WIf@3IfMT0\n3@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0\n103IfMT00`00O`00fMWI0=WIf@0=0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n2`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00X0fMWI00@007l00=WIf@3IfMT0\n07l0303IfMT01000O`00fMWI0=WIf@00O`0:0=WIf@03001o003IfMT007l000X0fMWI00<007l00=WI\nf@00O`002@3IfMT2001o00T0fMWI00<007l00=WIf@3IfMT0F`3IfMT001`0fMWI00<000000=WIf@3I\nfMT03@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3I\nfMT0103IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3I\nfMT02`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00X0fMWI00@007l00=WIf@3I\nfMT007l0303IfMT01000O`00fMWI0=WIf@00O`0:0=WIf@03001o003IfMT007l000X0fMWI00<007l0\n0=WIf@00O`002@3IfMT2001o00P0fMWI0P00O`1M0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WI\nf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@040=WI\nf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0;0=WI\nf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT0\n07l000`0fMWI00@007l00=WIf@3IfMT007l02P3IfMT00`00O`00fMWI001o000:0=WIf@03001o003I\nfMT007l000T0fMWI0P00O`080=WIf@8007l0G@3IfMT001`0fMWI00<000000=WIf@3IfMT03@3IfMT0\n0`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02P3IfMT0\n0`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00T0fMWI00D007l00=WIf@3IfMT0fMWI001o\n000<0=WIf@04001o003IfMT0fMWI001o00X0fMWI00<007l00=WIf@00O`002P3IfMT00`00O`00fMWI\n001o00090=WIf@8007l0203IfMT2001o00L0fMWI00<007l00=WIf@3IfMT0D`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00d0fMWI00<0\n07l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00<0fMWI00<0\n07l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00T0fMWI00D0\n07l00=WIf@3IfMT0fMWI001o000;0=WIf@05001o003IfMT0fMWI0=WIf@00O`002P3IfMT00`00O`00\nfMWI001o000:0=WIf@03001o003IfMT007l000P0fMWI00<007l00=WIf@00O`00203IfMT2001o00L0\nfMWI00<007l00=WIf@3IfMT0D`3IfMT001`0fMWI00<000000=WIf@3IfMT0303IfMT00`00O`00fMWI\n0=WIf@060=WIf@03001o003IfMT0fMWI00d0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI\n0=WIf@0<0=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI\n0=WIf@030=WIf@03001o003IfMT0fMWI00T0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@05\n001o003IfMT0fMWI0=WIf@00O`002@3IfMT01000O`00fMWI0=WIf@00O`090=WIf@04001o003IfMT0\nfMWI001o00P0fMWI00<007l00=WIf@00O`00203IfMT2001o00L0fMWI00<007l00=WIf@3IfMT01P3I\nfMT00`00O`00fMWI0=WIf@1:0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WIf@03001o003IfMT0\nfMWI00H0fMWI00<007l00=WIf@3IfMT03@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0\nfMWI00/0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0\nfMWI00<0fMWI00<007l00=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000/0fMWI00D0\n07l00=WIf@3IfMT0fMWI001o00090=WIf@04001o003IfMT0fMWI001o00T0fMWI00@007l00=WIf@3I\nfMT007l0203IfMT00`00O`00fMWI001o00070=WIf@03001o003IfMT007l000L0fMWI00<007l00=WI\nf@3IfMT01@3IfMT2001o04`0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<007l00=WIf@3I\nfMT01P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3I\nfMT02`3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`00O`00fMWI0=WIf@090=WIf@05001o003IfMT0fMWI0=WIf@00O`002`3IfMT01@00\nO`00fMWI0=WIf@3IfMT007l000T0fMWI00@007l00=WIf@3IfMT007l02@3IfMT01000O`00fMWI0=WI\nf@00O`080=WIf@03001o003IfMT007l000L0fMWI00<007l00=WIf@00O`001P3IfMT2001o00L0fMWI\n0P00O`060=WIf@03001o003IfMT0fMWI04<0fMWI000L0=WIf@030000003IfMT0fMWI00`0fMWI00<0\n07l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00D0fMWI00<0\n07l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00X0fMWI00<0\n07l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI00<0\n07l00=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000T0fMWI00@007l00=WIf@3IfMT0\n07l02@3IfMT01000O`00fMWI0=WIf@00O`080=WIf@03001o003IfMT007l000L0fMWI00<007l00=WI\nf@00O`001P3IfMT2001o00L0fMWI0P00O`060=WIf@03001o003IfMT0fMWI04<0fMWI000L0=WIf@03\n0000003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0<0=WIf@03\n001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@080=WIf@03\n001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02@3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n00T0fMWI00@007l00=WIf@3IfMT007l02@3IfMT01000O`00fMWI0=WIf@00O`070=WIf@04001o003I\nfMT0fMWI001o00L0fMWI00<007l00=WIf@00O`001P3IfMT2001o00L0fMWI0P00O`060=WIf@03001o\n003IfMT0fMWI04<0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01`3I\nfMT00`00O`00fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02`3I\nfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT00`3I\nfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0203I\nfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00H0fMWI00D007l00=WIf@3IfMT0fMWI\n001o00090=WIf@04001o003IfMT0fMWI001o00L0fMWI00@007l00=WIf@3IfMT007l01`3IfMT00`00\nO`00fMWI001o00060=WIf@8007l01`3IfMT2001o00D0fMWI0P00O`050=WIf@03001o003IfMT0fMWI\n03d0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00\nfMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02`3IfMT00`00O`00\nfMWI0=WIf@040=WIf@03001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00\nfMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00\nfMWI0=WIf@020=WIf@03001o003IfMT0fMWI00H0fMWI00D007l00=WIf@3IfMT0fMWI001o00080=WI\nf@05001o003IfMT0fMWI0=WIf@00O`001`3IfMT01000O`00fMWI0=WIf@00O`060=WIf@04001o003I\nfMT0fMWI001o00H0fMWI0P00O`060=WIf@03001o003IfMT007l000D0fMWI0P00O`050=WIf@03001o\n003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0=`3IfMT001`0fMWI00<000000=WIf@3IfMT02`3I\nfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00`0fMWI00<007l00=WIf@3IfMT01@3I\nfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3I\nfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT00P3I\nfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01P3I\nfMT01@00O`00fMWI0=WIf@3IfMT007l000P0fMWI00D007l00=WIf@3IfMT0fMWI001o00070=WIf@04\n001o003IfMT0fMWI001o00H0fMWI00@007l00=WIf@3IfMT007l01P3IfMT2001o00H0fMWI00<007l0\n0=WIf@00O`001@3IfMT2001o00D0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@0g\n0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WI\nf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WI\nf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WI\nf@3IfMT0203IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WI\nf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@060=WIf@05001o003IfMT0fMWI0=WIf@00O`00203IfMT0\n1@00O`00fMWI0=WIf@3IfMT007l000L0fMWI00@007l00=WIf@3IfMT007l01P3IfMT01000O`00fMWI\n0=WIf@00O`060=WIf@8007l01P3IfMT00`00O`00fMWI001o00050=WIf@8007l01@3IfMT00`00O`00\nfMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0<P3IfMT001`0fMWI\n00<000000=WIf@3IfMT02`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00/0fMWI\n00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00D0fMWI\n00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00P0fMWI\n00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI0080fMWI\n00<007l00=WIf@3IfMT01P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000P0fMWI00D007l00=WIf@3I\nfMT0fMWI001o00060=WIf@05001o003IfMT0fMWI0=WIf@00O`001P3IfMT01000O`00fMWI0=WIf@00\nO`060=WIf@8007l01P3IfMT00`00O`00fMWI001o00050=WIf@8007l01@3IfMT00`00O`00fMWI0=WI\nf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0<P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00/0fMWI00<007l0\n0=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03001o003IfMT0fMWI00D0fMWI00<007l0\n0=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00P0fMWI00<007l0\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00<0fMWI00<007l0\n0=WIf@3IfMT01P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000P0fMWI00D007l00=WIf@3IfMT0fMWI\n001o00060=WIf@05001o003IfMT0fMWI0=WIf@00O`001P3IfMT01000O`00fMWI0=WIf@00O`050=WI\nf@03001o003IfMT007l000H0fMWI00<007l00=WIf@00O`00103IfMT00`00O`00fMWI001o00040=WI\nf@8007l01@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WI\nf@3IfMT0;@3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@080=WIf@03\n001o003IfMT0fMWI00/0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@0:0=WIf@03\n001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@070=WIf@03\n001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@040=WIf@05\n001o003IfMT0fMWI0=WIf@00O`001@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000D0fMWI00<007l0\n0=WIf@00O`001@3IfMT01000O`00fMWI0=WIf@00O`040=WIf@03001o003IfMT007l000@0fMWI0P00\nO`050=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00P3IfMT01@00O`00fMWI0=WI\nf@3IfMT007l002/0fMWI000L0=WIf@030000003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT0203I\nfMT00`00O`00fMWI0=WIf@0;0=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT01P3I\nfMT2000000030=WIf@00O`00fMWI00L0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WI\nf@050=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WI\nf@040=WIf@<0000000@007l00000003IfMT0fMWI0P0000000`00O`00fMWI0=WIf@050=WIf@03001o\n003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00@0fMWI00D007l00=WIf@3IfMT0fMWI001o00050=WIf@05001o003IfMT0fMWI0=WI\nf@00O`001@0000001000O`00fMWI001o000000040=WIf@04001o003IfMT0fMWI001o00@0fMWI00<0\n07l00=WIf@00O`00103IfMT2001o00@0fMWI0P00O`040=WIf@03001o003IfMT0fMWI0080fMWI00D0\n07l00=WIf@3IfMT0fMWI001o00030=WIf@03001o003IfMT0fMWI0080fMWI100000030=WIf@800000\n6P3IfMT001`0fMWI00<000000=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003I\nfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@050=WIf@050000003I\nfMT0fMWI00000000O`00203IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00D0fMWI\n00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00H0fMWI\n00D00000001o003IfMT0fMWI000000020=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3I\nfMT00P3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3I\nfMT0103IfMT01@00O`00fMWI0=WIf@3IfMT007l000D0fMWI00D007l00=WIf@3IfMT0fMWI001o0002\n0=WIf@080000003IfMT0fMWI001o0000000007l00=WIf@0000030=WIf@04001o003IfMT0fMWI001o\n00@0fMWI00<007l00=WIf@00O`00103IfMT2001o00@0fMWI0P00O`040=WIf@03001o003IfMT0fMWI\n0080fMWI00D007l00=WIf@3IfMT0fMWI001o00030=WIf@06001o003IfMT0fMWI0=WIf@00O`000000\n1@3IfMT010000000fMWI0=WIf@00000I0=WIf@00703IfMT00`000000fMWI0=WIf@0:0=WIf@03001o\n003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o\n003IfMT0fMWI00P0fMWI00<00000001o003IfMT01`3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o\n003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o\n003IfMT0fMWI00H0fMWI00D00000001o003IfMT0fMWI000000020=WIf@03001o003IfMT0fMWI00D0\nfMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI0080\nfMWI00<007l00=WIf@3IfMT0103IfMT01@00O`00fMWI0=WIf@3IfMT007l000D0fMWI00D007l00=WI\nf@3IfMT0fMWI001o00020=WIf@080000003IfMT0fMWI001o003IfMT007l00=WIf@0000030=WIf@04\n001o003IfMT0fMWI001o00@0fMWI00<007l00=WIf@00O`00103IfMT2001o00@0fMWI0P00O`030=WI\nf@8007l00`3IfMT2001o00<0fMWI00D007l00=WIf@3IfMT0fMWI001o00030=WIf@04001o003IfMT0\n0000001o00<0fMWI00@000000=WIf@3IfMT000006@3IfMT001`0fMWI00<000000=WIf@3IfMT02P3I\nfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WIf@3IfMT01`3I\nfMT00`00O`00fMWI0=WIf@060=WIf@80000000<0fMWI001o003IfMT01`3IfMT00`00O`00fMWI0=WI\nf@080=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WI\nf@030=WIf@03001o003IfMT0fMWI00H0fMWI00D007l00=WIf@3IfMT0fMWI000000020=WIf@03001o\n003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o\n003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o\n003IfMT0fMWI00<0fMWI00D007l00=WIf@3IfMT0fMWI001o00020=WIf@070000003IfMT0fMWI001o\n003IfMT007l0000000040=WIf@04001o003IfMT0fMWI001o00@0fMWI00<007l00=WIf@00O`00103I\nfMT2001o00@0fMWI0P00O`030=WIf@8007l00`3IfMT2001o00<0fMWI00D007l00=WIf@3IfMT0fMWI\n001o00030=WIf@04001o003IfMT0fMWI001o00<0fMWI00@000000=WIf@3IfMT000006@3IfMT001`0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00X0\nfMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@060=WIf@040000003IfMT0fMWI001o\n00P0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI\n00H0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@060=WIf@05001o003IfMT0fMWI\n0=WIf@0000000P3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI0080fMWI00<007l0\n0=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<007l0\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@030=WIf@05001o003IfMT0fMWI0=WIf@00O`000P3I\nfMT00`000000fMWI001o00020=WIf@03001o003IfMT0fMWI00<0fMWI00@007l00=WIf@3IfMT007l0\n0`3IfMT01000O`00fMWI0=WIf@00O`030=WIf@03001o003IfMT007l000@0fMWI0P00O`030=WIf@80\n07l00`3IfMT2001o0080fMWI0P00O`030=WIf@03001o003IfMT0fMWI008007l000L00000001o0000\nO`0000000=WIf@00O`0000000080fMWI00<000000=WIf@3IfMT05`3IfMT001`0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00X0fMWI00<007l00=WI\nf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@060=WIf@80000000<007l00=WIf@3IfMT01`3IfMT00`00\nO`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00\nO`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00D0fMWI00<00000001o003IfMT00`3IfMT20000\n0003001o003IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@040=WI\nf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WI\nf@03001o003IfMT0fMWI00<0fMWI00H007l00=WIf@3IfMT0fMWI001o003IfMT2000000050=WIf@00\nO`00fMWI0=WIf@00O`000P0000020=WIf@05001o003IfMT0fMWI0=WIf@00O`000`3IfMT01000O`00\nfMWI0=WIf@00O`030=WIf@03001o003IfMT007l000<0fMWI00<007l00=WIf@00O`000`3IfMT2001o\n00<0fMWI0P00O`020=WIf@8007l00`3IfMT00`00O`00fMWI0=WIf@02001o00050=WIf@00O`0007l0\n0=WIf@00O`000P3IfMT2000001X0fMWI000L0=WIf@030000003IfMT0fMWI00T0fMWI00<007l00=WI\nf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WI\nf@3IfMT0203IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WI\nf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00@0fMWI00<007l00=WI\nf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00=WI\nf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WI\nf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00D007l00=WI\nf@3IfMT0fMWI001o00040=WIf@04001o003IfMT0fMWI001o00@0fMWI00D007l00=WIf@3IfMT0fMWI\n001o00030=WIf@04001o003IfMT0fMWI001o00<0fMWI00<007l00=WIf@00O`000`3IfMT00`00O`00\nfMWI001o00030=WIf@8007l00`3IfMT2001o0080fMWI0P00O`030=WIf@03001o003IfMT0fMWI0080\n07l000D0fMWI001o0000O`00fMWI001o000N0=WIf@00703IfMT00`000000fMWI0=WIf@090=WIf@03\n001o003IfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@080=WIf@03\n001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@070=WIf@03\n001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00H0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03\n001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00P3IfMT01000O`00fMWI0=WIf@00O`040=WI\nf@05001o003IfMT0fMWI0=WIf@00O`000`3IfMT01000O`00fMWI0=WIf@00O`030=WIf@03001o003I\nfMT007l000<0fMWI00<007l00=WIf@00O`000`3IfMT2001o00<0fMWI0P00O`020=WIf@8007l00P3I\nfMT2001o0080fMWI0P00O`001@3IfMT007l0001o003IfMT007l001h0fMWI000L0=WIf@030000003I\nfMT0fMWI00T0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@090=WIf@03001o003I\nfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003I\nfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003I\nfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@04001o003I\nfMT0fMWI001o00@0fMWI00D007l00=WIf@3IfMT0fMWI001o00030=WIf@04001o003IfMT0fMWI001o\n00<0fMWI00<007l00=WIf@00O`000`3IfMT00`00O`00fMWI001o00020=WIf@03001o003IfMT007l0\n0080fMWI00<007l00=WIf@00O`000P3IfMT2001o0080fMWI0P00O`020=WIf@8007l000D0fMWI001o\n0000O`00fMWI001o000N0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03001o003IfMT0fMWI\n00X0fMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI\n00P0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@070=WIf@03001o003IfMT0fMWI\n00H0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI\n00D0fMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI\n00<0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI\n0080fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI\n0080fMWI00D007l00=WIf@3IfMT0fMWI001o00030=WIf@03001o003IfMT0fMWI0080fMWI00D007l0\n0=WIf@3IfMT0fMWI001o00020=WIf@05001o003IfMT0fMWI0=WIf@00O`000P3IfMT01000O`00fMWI\n0=WIf@00O`030=WIf@03001o003IfMT007l00080fMWI00<007l00=WIf@00O`000P3IfMT00`00O`00\nfMWI001o00020=WIf@8007l00P3IfMT2001o00050=WIf@00O`00fMWI001o003IfMT00P00O`000`3I\nfMT007l00=WIf@0M0=WIf@00703IfMT00`000000fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00X0\nfMWI00<007l00=WIf@3IfMT02@3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00P0\nfMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@060=WIf@03001o003IfMT0fMWI00L0\nfMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI00D0\nfMWI00<007l00=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI00<0\nfMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080\nfMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI0080\nfMWI00D007l00=WIf@3IfMT0fMWI001o00030=WIf@03001o003IfMT0fMWI0080fMWI00D007l00=WI\nf@3IfMT0fMWI001o00020=WIf@05001o003IfMT0fMWI0=WIf@00O`000P3IfMT01000O`00fMWI0=WI\nf@00O`020=WIf@04001o003IfMT0fMWI001o0080fMWI00<007l00=WIf@00O`000P3IfMT01`00O`00\nfMWI001o003IfMT007l00=WIf@00O`000P3IfMT2001o00050=WIf@00O`00fMWI001o003IfMT00P00\nO`000`3IfMT007l00=WIf@0>0=WIf@8000003@3IfMT001H0fMWI4@0000000`00O`0000000000000:\n00000003001o00000?l0000000T0000000<007l0000000000000200000000`00O`00003o00000008\n00000003001o00000000000000L0000000<007l00000000000001P0000000`00O`00000000000007\n00000003001o00000000000000D0000000<007l00000000000001@0000000`00O`00003o00000005\n00000003001o00000000000000D0000000<007l0000000000000100000000`00O`00000000000003\n00000003001o00000?l0000000@0000000<007l00000000000000`0000000`00O`00000000000002\n00000003001o00000000000000<0000000<007l00000000000000P0000000`00O`00000000000002\n00000005001o00000000000000000000O`000`0000000`00O`00003o0000000200000005001o0000\n0000000000000000O`000P0000001@00O`00000000000000000007l00080000000L007l000000000\n000007l00000o`00000007l000800000014007l00000o`00000007l000000000O`00003o00000000\nO`000000001o00000?l007l000000000O`00003o00000002001o00050000o`00O`000000001o0000\n00000`00O`000`000000003o00000004000000P0fMWI00@000000=WIf@3IfMT00000303IfMT001`0\nfMWI00<000000=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@090=WIf@0300000000O`00fMWI00P0\nfMWI00<00000001o003IfMT02@3IfMT00`00000007l00=WIf@080=WIf@0300000000O`00fMWI00P0\nfMWI00<007l00000003IfMT01P3IfMT01000O`00fMWI0=WIf@0000060=WIf@03001o003IfMT0fMWI\n0080fMWI00@000000=WIf@3IfMT007l01`3IfMT00`00O`00003o0=WIf@050=WIf@05001o003IfMT0\nfMWI0=WIf@0000000P3IfMT00`000?l007l00=WIf@040=WIf@03001o00000000fMWI00@0fMWI00<0\n07l00000o`3IfMT00`3IfMT00`00O`00fMWI0=WIf@030=WIf@030000o`00O`00fMWI0080fMWI00<0\n0000001o003IfMT0103IfMT00`00O`00fMWI0=WIf@020=WIf@06001o003IfMT0fMWI0=WIf@000?l0\n07l00`3IfMT01P00O`00fMWI0000003IfMT007l00000o`<0fMWI00P007l00=WIf@3IfMT0003o001o\n00000000fMWI001o0080fMWI00/0003o001o003IfMT0fMWI001o003IfMT00000001o00000?l0fMWI\n001o00020=WIf@0F001o00000?l0fMWI001o003IfMT007l00000o`3IfMT007l00000o`00O`00003o\n001o00000?l007l00000o`00O`00003o001o00000?l007l00000o`8007l000D0003o001o0000O`00\n003o0000000=0=WIf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI\n00<007l00=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00T0fMWI\n00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI00H0fMWI\n00<007l00=WIf@3IfMT01P3IfMT00`000?l007l00=WIf@060=WIf@03001o003IfMT0fMWI00D0fMWI\n00<007l00000o`3IfMT01@3IfMT01@00O`00fMWI0=WIf@3IfMT000000080fMWI00<0003o001o003I\nfMT0103IfMT00`00O`00fMWI0=WIf@040=WIf@03001o00000?l0fMWI00<0fMWI00<007l00=WIf@3I\nfMT00`3IfMT00`000?l007l00=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<0003o001o003I\nfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@030000o`00O`00fMWI0080fMWI00H007l00=WIf@00\n0000003o001o00000?l20=WIf@09001o003IfMT0fMWI0=WIf@000?l007l00000o`3IfMT007l00080\nfMWI00P0003o001o00000?l0fMWI001o003IfMT0003o001o0080003o00H007l00000o`000?l007l0\n0000o`00O`020000o`03001o003IfMT007l00080003o00`007l00=WIf@00O`00fMWI001o003IfMT0\n07l00=WIf@00O`00fMWI001o003IfMT2001o00050=WIf@00O`0007l00=WIf@000000303IfMT50000\n00`0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT02@3IfMT00`000?l0\n07l00=WIf@090=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o003IfMT0203IfMT00`00O`00\nfMWI0=WIf@070=WIf@030000o`00O`00003o00L0fMWI00<007l00=WIf@3IfMT01P3IfMT00`000?l0\n07l00=WIf@060=WIf@03001o003IfMT0fMWI00D0fMWI00<007l00000o`3IfMT0103IfMT00`00O`00\nfMWI0=WIf@050=WIf@030000o`00O`00fMWI00@0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00\n003o0=WIf@030=WIf@03001o003IfMT0fMWI00<0fMWI00<0003o001o003IfMT00`3IfMT00`00O`00\nfMWI0=WIf@020=WIf@030000o`00O`00003o0080fMWI00X007l00=WIf@3IfMT0fMWI0000o`3IfMT0\n07l00000o`3IfMT007l00`3IfMT01P000?l007l00=WIf@000?l0fMWI001o0080fMWI00H0003o0=WI\nf@00O`00003o001o003IfMT20000o`040=WIf@00O`00fMWI001o0080003o00X0fMWI001o003IfMT0\nfMWI001o00000?l0fMWI001o003IfMT007l00P3IfMT00`00O`00fMWI001o00020=WIf@08001o003I\nfMT007l00=WIf@00O`00fMWI001o003IfMT2001o0080fMWI0P00O`000`3IfMT007l0001o000?0=WI\nf@030000003IfMT0fMWI00d0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<007l00=WIf@3I\nfMT02@3IfMT00`000?l007l00000o`090=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o0000\n0?l0203IfMT00`00O`00fMWI0=WIf@070=WIf@030000o`00O`00003o00L0fMWI00<007l00=WIf@3I\nfMT01P3IfMT00`000?l007l00=WIf@050=WIf@03001o003IfMT0fMWI00H0fMWI00<007l00000o`3I\nfMT0103IfMT00`00O`00fMWI0=WIf@040=WIf@040000o`3IfMT007l00000o`@0fMWI00<007l00=WI\nf@3IfMT00`3IfMT00`000?l007l00000o`040=WIf@03001o003IfMT0fMWI0080fMWI00@0003o0=WI\nf@00O`00003o0`3IfMT02000O`00fMWI0=WIf@3IfMT0003o0=WIf@00O`00003o0P3IfMT02P00O`00\nfMWI0=WIf@3IfMT0003o0=WIf@00O`00fMWI0000o`00O`020=WIf@80003o00D007l00=WIf@3IfMT0\n003o001o00020000o`80fMWI00<007l00=WIf@00O`000P000?l20=WIf@03001o003IfMT007l000<0\nfMWI00@007l00=WIf@3IfMT007l00P3IfMT00`00O`00fMWI001o00020=WIf@03001o003IfMT007l0\n0080fMWI00P007l00=WIf@00O`00fMWI001o003IfMT007l00=WIf@8007l00P3IfMT2001o00030=WI\nf@00O`0007l001l0fMWI000L0=WIf@030000003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT02@3I\nfMT00`000?l007l00000o`090=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o00000?l0203I\nfMT00`00O`00fMWI0=WIf@070=WIf@030000o`00O`00003o00H0fMWI00<007l00=WIf@3IfMT01`3I\nfMT00`000?l007l00000o`050=WIf@03001o003IfMT0fMWI00D0fMWI00@0003o001o003IfMT0003o\n103IfMT00`00O`00fMWI0=WIf@040=WIf@040000o`3IfMT007l00000o`@0fMWI00<007l00=WIf@3I\nfMT00`3IfMT010000?l007l00=WIf@000?l30=WIf@03001o003IfMT0fMWI0080fMWI00<0003o0=WI\nf@00O`000P000?l00`3IfMT007l00=WIf@030=WIf@070000o`3IfMT007l00=WIf@000?l0fMWI001o\n00020=WIf@070000o`3IfMT0fMWI001o003IfMT0003o001o00030000o`030=WIf@00O`00fMWI0080\nfMWI00<007l00000o`3IfMT00P3IfMT00`00O`00fMWI001o00040=WIf@03001o003IfMT007l000<0\nfMWI00<007l00=WIf@00O`000`3IfMT00`00O`00fMWI001o00020=WIf@03001o003IfMT007l00080\nfMWI00P007l00=WIf@00O`00fMWI001o003IfMT007l00=WIf@8007l00P3IfMT2001o00030=WIf@00\nO`00fMWI01l0fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT02P3IfMT0\n0`000?l007l00000o`090=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o00000?l0203IfMT0\n0`00O`00fMWI0=WIf@070=WIf@030000o`00O`00003o00H0fMWI00<007l00=WIf@3IfMT01P3IfMT0\n10000?l0fMWI001o00000?l50=WIf@03001o003IfMT0fMWI00D0fMWI00@0003o001o003IfMT0003o\n103IfMT00`00O`00fMWI0=WIf@040=WIf@050000o`3IfMT007l00=WIf@000?l00P3IfMT00`00O`00\nfMWI0=WIf@030=WIf@050000o`3IfMT007l00=WIf@000?l00`3IfMT01@00O`00fMWI0=WIf@3IfMT0\n003o0080fMWI00D007l00=WIf@000?l0fMWI001o00030=WIf@040000o`3IfMT0fMWI001o0080fMWI\n00@0003o001o003IfMT0003o0`3IfMT01000O`00fMWI0=WIf@00O`040=WIf@05001o003IfMT0fMWI\n0=WIf@00O`00103IfMT00`00O`00fMWI001o00040=WIf@03001o003IfMT007l000<0fMWI00<007l0\n0=WIf@00O`000`3IfMT00`00O`00fMWI001o00020=WIf@03001o003IfMT007l00080fMWI00@007l0\n0=WIf@00O`00fMWI0P00O`020=WIf@8007l00P3IfMT2001o00030=WIf@00O`00fMWI01l0fMWI000L\n0=WIf@030000o`3IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT02P3IfMT00`000?l007l00000o`09\n0=WIf@03001o003IfMT0fMWI00P0fMWI00<0003o001o00000?l0203IfMT00`00O`00fMWI0=WIf@07\n0=WIf@030000o`00O`00003o00H0fMWI00<007l00=WIf@3IfMT01P3IfMT010000?l0fMWI001o0000\n0?l50=WIf@03001o003IfMT0fMWI00D0fMWI00@0003o001o003IfMT0003o103IfMT00`00O`00fMWI\n0=WIf@030=WIf@060000o`3IfMT0fMWI001o003IfMT0003o0P3IfMT00`00O`00fMWI0=WIf@030=WI\nf@030000o`3IfMT007l00080fMWI00<0003o0=WIf@00O`00103IfMT010000?l0fMWI0=WIf@00O`02\n0=WIf@050000o`00O`00fMWI0=WIf@000?l00`3IfMT01000O`00fMWI0=WIf@00O`020000o`@0fMWI\n00@007l00=WIf@3IfMT007l0103IfMT01000O`00fMWI0=WIf@00O`050=WIf@03001o003IfMT007l0\n00@0fMWI00<007l00=WIf@00O`000`3IfMT00`00O`00fMWI001o00030=WIf@8007l00`3IfMT2001o\n00<0fMWI0P00O`020=WIf@8007l00P3IfMT2001o0080fMWI00@007l00=WIf@3IfMT007l0803IfMT0\n01`0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@0:0=WIf@030000o`00O`00003o\n00T0fMWI00<007l00=WIf@3IfMT0203IfMT010000?l007l00=WIf@000?l60=WIf@03001o003IfMT0\nfMWI00L0fMWI00@0003o0=WIf@00O`00003o1P3IfMT00`00O`00fMWI0=WIf@060=WIf@050000o`3I\nfMT007l00=WIf@000?l0103IfMT00`00O`00fMWI0=WIf@040=WIf@030000o`3IfMT007l00080fMWI\n00D0003o0=WIf@3IfMT0fMWI001o00050=WIf@060000o`3IfMT0fMWI001o003IfMT0003o0P3IfMT0\n0`00O`00fMWI0=WIf@020=WIf@040000o`3IfMT0fMWI001o00<0fMWI00<0003o001o003IfMT00P3I\nfMT01@000?l0fMWI0=WIf@3IfMT007l000<0fMWI00<007l00000o`000?l0103IfMT01000O`00fMWI\n0=WIf@00O`060=WIf@04001o003IfMT0fMWI001o00@0fMWI00@007l00=WIf@3IfMT007l01@3IfMT0\n0`00O`00fMWI001o00040=WIf@03001o003IfMT007l000<0fMWI00<007l00=WIf@00O`000`3IfMT2\n001o00<0fMWI0P00O`030=WIf@8007l00P3IfMT2001o0080fMWI0P00O`020=WIf@04001o003IfMT0\nfMWI001o0200fMWI000L0=WIf@030000o`3IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT02P3IfMT0\n10000?l007l00=WIf@000?l70=WIf@03001o003IfMT0fMWI00T0fMWI00@0003o001o003IfMT0003o\n1P3IfMT00`00O`00fMWI0=WIf@070=WIf@050000o`3IfMT007l00=WIf@000?l01@3IfMT00`00O`00\nfMWI0=WIf@060=WIf@050000o`3IfMT007l00=WIf@000?l00`3IfMT00`00O`00fMWI0=WIf@050=WI\nf@030000o`3IfMT007l00080fMWI00D0003o0=WIf@3IfMT0fMWI001o00050=WIf@040000o`3IfMT0\nfMWI001o0080fMWI00<0003o0=WIf@00O`00103IfMT010000?l0fMWI0=WIf@00O`030=WIf@050000\no`00O`00fMWI0=WIf@000?l0103IfMT01@00O`00fMWI0=WIf@3IfMT007l000H0fMWI00@007l00=WI\nf@3IfMT007l01P3IfMT00`00O`00fMWI001o00050=WIf@04001o003IfMT0fMWI001o00D0fMWI00<0\n07l00=WIf@00O`00103IfMT2001o00@0fMWI00<007l00=WIf@00O`000`3IfMT2001o00<0fMWI0P00\nO`030=WIf@8007l00P3IfMT2001o0080fMWI00D007l00=WIf@3IfMT0fMWI001o00020=WIf@03001o\n003IfMT0fMWI01h0fMWI000L0=WIf@030000o`3IfMT0fMWI00L0fMWI00<007l00=WIf@3IfMT02P3I\nfMT010000?l007l00=WIf@000?l70=WIf@03001o003IfMT0fMWI00P0fMWI00D0003o0=WIf@00O`00\nfMWI0000o`060=WIf@03001o003IfMT0fMWI00L0fMWI00D0003o0=WIf@00O`00fMWI0000o`040=WI\nf@03001o003IfMT0fMWI00H0fMWI00H0003o0=WIf@3IfMT007l00=WIf@000?l30=WIf@03001o003I\nfMT0fMWI00D0fMWI00<0003o0=WIf@00O`000`3IfMT010000?l0fMWI0=WIf@00O`050=WIf@040000\no`3IfMT0fMWI001o0080fMWI0P000?l01@00O`00fMWI0=WIf@3IfMT0003o00<0fMWI00<007l00=WI\nf@3IfMT00P3IfMT00`00O`00003o0000o`050=WIf@04001o003IfMT0fMWI001o00L0fMWI00@007l0\n0=WIf@3IfMT007l01P3IfMT00`00O`00fMWI001o00050=WIf@04001o003IfMT0fMWI001o00D0fMWI\n00<007l00=WIf@00O`00103IfMT2001o00@0fMWI0P00O`040=WIf@8007l00`3IfMT2001o00<0fMWI\n0P00O`020=WIf@8007l00P3IfMT2001o02H0fMWI000L0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0\n07l00=WIf@3IfMT02P3IfMT01@000?l0fMWI001o003IfMT0003o00L0fMWI00<007l00=WIf@3IfMT0\n203IfMT01@000?l0fMWI001o003IfMT0003o00H0fMWI00<007l00=WIf@3IfMT01`3IfMT01@000?l0\nfMWI001o003IfMT0003o00@0fMWI00<007l00=WIf@3IfMT01P3IfMT010000?l0fMWI0=WIf@00O`02\n0=WIf@040000o`3IfMT0fMWI001o00H0fMWI00@0003o0=WIf@3IfMT007l00`3IfMT00`000?l0fMWI\n001o00050=WIf@050000o`3IfMT0fMWI0=WIf@00O`000`3IfMT010000?l007l00=WIf@3IfMT20000\no`<0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@050=WIf@04001o003IfMT0fMWI\n001o00L0fMWI00@007l00=WIf@3IfMT007l01P3IfMT00`00O`00fMWI001o00050=WIf@04001o003I\nfMT0fMWI001o00D0fMWI0P00O`050=WIf@8007l0103IfMT2001o00@0fMWI0P00O`030=WIf@8007l0\n0`3IfMT2001o0080fMWI0P00O`0Z0=WIf@00703IfMT00`000?l0fMWI0=WIf@060=WIf@03001o003I\nfMT0fMWI00X0fMWI00D0003o0=WIf@00O`00fMWI0000o`070=WIf@03001o003IfMT0fMWI00P0fMWI\n00<0003o0=WIf@00O`000P3IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI00H0fMWI\n00@0003o0=WIf@3IfMT007l00P3IfMT01@000?l0fMWI0=WIf@3IfMT007l000P0fMWI00@0003o0=WI\nf@3IfMT007l00P3IfMT010000?l0fMWI0=WIf@00O`060=WIf@040000o`3IfMT0fMWI001o00@0fMWI\n00<0003o001o003IfMT0103IfMT01@000?l0fMWI0=WIf@3IfMT007l000<0fMWI00<007l00000o`00\n0?l00P000?l40=WIf@05001o003IfMT0fMWI0=WIf@00O`00203IfMT01000O`00fMWI0=WIf@00O`07\n0=WIf@03001o003IfMT007l000L0fMWI00<007l00=WIf@00O`001@3IfMT00`00O`00fMWI001o0006\n0=WIf@8007l01@3IfMT2001o00@0fMWI0P00O`040=WIf@8007l00`3IfMT2001o00<0fMWI0P00O`02\n0=WIf@03001o003IfMT0fMWI02T0fMWI000L0=WIf@030000o`3IfMT0fMWI00H0fMWI00<007l00=WI\nf@3IfMT02P3IfMT01@000?l0fMWI001o003IfMT0003o00L0fMWI00<007l00=WIf@3IfMT0203IfMT0\n0`000?l0fMWI001o00020=WIf@030000o`3IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT01`3IfMT0\n10000?l0fMWI0=WIf@00O`020=WIf@050000o`3IfMT0fMWI0=WIf@00O`001`3IfMT01@000?l0fMWI\n0=WIf@3IfMT007l000<0fMWI00<0003o0=WIf@00O`001@3IfMT01@000?l0fMWI0=WIf@3IfMT007l0\n00@0fMWI00<0003o001o003IfMT00`3IfMT00`000?l0fMWI0=WIf@020=WIf@05001o003IfMT0fMWI\n0=WIf@00O`00203IfMT01@00O`00fMWI0=WIf@3IfMT007l000P0fMWI00@007l00=WIf@3IfMT007l0\n1`3IfMT00`00O`00fMWI001o00070=WIf@03001o003IfMT007l000D0fMWI00<007l00=WIf@00O`00\n1P3IfMT2001o00D0fMWI0P00O`040=WIf@8007l0103IfMT00`00O`00fMWI0=WIf@020=WIf@8007l0\n0`3IfMT00`00O`00fMWI0=WIf@0]0=WIf@00703IfMT00`000000003o0=WIf@060=WIf@03001o003I\nfMT0fMWI00X0fMWI00<0003o0=WIf@00O`000P3IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI00T0fMWI00<0003o0=WIf@00O`000P3IfMT00`000?l0fMWI0=WIf@020=WIf@03001o003I\nfMT0fMWI00L0fMWI00@0003o0=WIf@3IfMT007l00P3IfMT01@000?l0fMWI0=WIf@3IfMT007l000L0\nfMWI00D0003o0=WIf@3IfMT0fMWI001o00030=WIf@030000o`00O`00fMWI00D0fMWI00D0003o0=WI\nf@3IfMT0fMWI001o00050=WIf@03001o00000?l0fMWI0080003o1@3IfMT01@00O`00fMWI0=WIf@3I\nfMT007l000P0fMWI00D007l00=WIf@3IfMT0fMWI001o00080=WIf@04001o003IfMT0fMWI001o00L0\nfMWI00<007l00=WIf@00O`001`3IfMT00`00O`00fMWI001o00050=WIf@03001o003IfMT007l000H0\nfMWI0P00O`050=WIf@8007l0103IfMT2001o00@0fMWI00<007l00=WIf@3IfMT00P3IfMT2001o03<0\nfMWI000L0=WIf@03000000000?l0fMWI00H0fMWI00<007l00=WIf@3IfMT02P3IfMT00`000?l0fMWI\n001o00020=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0203IfMT010000?l0fMWI\n0=WIf@00O`030=WIf@050000o`3IfMT0fMWI0=WIf@00O`00203IfMT01@000?l0fMWI0=WIf@3IfMT0\n07l000<0fMWI00@0003o0=WIf@3IfMT007l01`3IfMT01@000?l0fMWI0=WIf@3IfMT007l000@0fMWI\n00<007l00=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI\n00@007l00000o`000?l0003o1P3IfMT01@00O`00fMWI0=WIf@3IfMT007l000P0fMWI00D007l00=WI\nf@3IfMT0fMWI001o00080=WIf@04001o003IfMT0fMWI001o00L0fMWI00<007l00=WIf@00O`001`3I\nfMT00`00O`00fMWI001o00050=WIf@03001o003IfMT007l000H0fMWI0P00O`050=WIf@8007l0103I\nfMT2001o00@0fMWI0P00O`0h0=WIf@00703IfMT00`000000003o0=WIf@060=WIf@03001o003IfMT0\nfMWI00T0fMWI00@0003o0=WIf@3IfMT007l00P3IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003I\nfMT0fMWI00P0fMWI00@0003o0=WIf@3IfMT007l00`3IfMT01@000?l0fMWI0=WIf@3IfMT007l000P0\nfMWI00D0003o0=WIf@3IfMT0fMWI001o00030=WIf@040000o`3IfMT0fMWI001o00H0fMWI00<0003o\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00<0003o\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00D007l0\n0=WIf@3IfMT0fMWI001o00080=WIf@05001o003IfMT0fMWI0=WIf@00O`00203IfMT00`00O`00fMWI\n001o00080=WIf@03001o003IfMT007l000L0fMWI00<007l00=WIf@00O`001@3IfMT00`00O`00fMWI\n001o00060=WIf@8007l01@3IfMT2001o00@0fMWI0P00O`040=WIf@03001o003IfMT0fMWI03L0fMWI\n000L0=WIf@03000000000?l0fMWI00D0fMWI00<007l00=WIf@3IfMT02P3IfMT010000?l0fMWI0=WI\nf@00O`020=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0203IfMT010000?l0fMWI\n0=WIf@00O`030=WIf@050000o`3IfMT0fMWI0=WIf@00O`00203IfMT01@000?l0fMWI0=WIf@3IfMT0\n07l000@0fMWI00<0003o0=WIf@00O`001P3IfMT00`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0\nfMWI0080fMWI00<007l00000o`3IfMT00P3IfMT20000o`@0fMWI00<007l00=WIf@3IfMT00P3IfMT0\n0`00O`00fMWI0=WIf@080=WIf@04001o003IfMT0fMWI001o00T0fMWI00@007l00=WIf@3IfMT007l0\n2@3IfMT00`00O`00fMWI001o00080=WIf@03001o003IfMT007l000L0fMWI0P00O`060=WIf@03001o\n003IfMT007l000H0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@8007l0\n?P3IfMT001`0fMWI00<000000000o`3IfMT01@3IfMT00`00O`00fMWI0=WIf@0:0=WIf@040000o`3I\nfMT0fMWI001o00<0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@080=WIf@040000\no`3IfMT0fMWI001o00@0fMWI00<0003o0=WIf@00O`00203IfMT00`000?l0fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI0080fMWI00<0003o001o003IfMT01@3IfMT00`000?l0fMWI0=WIf@030=WIf@03\n001o003IfMT0fMWI0080fMWI00<007l00000o`000?l00`000?l50=WIf@03001o003IfMT0fMWI0080\nfMWI00<007l00=WIf@3IfMT0203IfMT01000O`00fMWI0=WIf@00O`090=WIf@04001o003IfMT0fMWI\n001o00T0fMWI00<007l00=WIf@00O`00203IfMT2001o00P0fMWI0P00O`060=WIf@8007l01`3IfMT0\n0`00O`00fMWI0=WIf@040=WIf@03001o003IfMT0fMWI04<0fMWI000L0=WIf@030000003IfMT0003o\n00D0fMWI00<007l00=WIf@3IfMT02P3IfMT010000?l0fMWI0=WIf@00O`030=WIf@050000o`3IfMT0\nfMWI0=WIf@00O`002P3IfMT01@000?l0fMWI0=WIf@3IfMT007l000@0fMWI00<0003o0=WIf@00O`00\n203IfMT00`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0\n103IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n203IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00P0fMWI00@007l00=WIf@3IfMT0\n07l02@3IfMT01000O`00fMWI0=WIf@00O`090=WIf@03001o003IfMT007l000P0fMWI0P00O`080=WI\nf@8007l01P3IfMT2001o00L0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@130=WI\nf@00703IfMT00`000000fMWI0000o`050=WIf@03001o003IfMT0fMWI00X0fMWI00@0003o0=WIf@3I\nfMT007l00`3IfMT01@000?l0fMWI0=WIf@3IfMT007l000X0fMWI00D0003o0=WIf@3IfMT0fMWI001o\n00040=WIf@030000o`3IfMT007l000P0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@030=WIf@03001o003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WI\nf@020=WIf@03001o003IfMT0fMWI00P0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@080=WIf@04001o003IfMT0fMWI001o00T0fMWI00@007l00=WIf@3IfMT007l02@3IfMT00`00O`00\nfMWI001o00080=WIf@8007l0203IfMT2001o00H0fMWI0P00O`070=WIf@03001o003IfMT0fMWI04X0\nfMWI000L0=WIf@030000003IfMT0003o00D0fMWI00<007l00=WIf@3IfMT02@3IfMT01@000?l0fMWI\n0=WIf@3IfMT007l000@0fMWI00@0003o0=WIf@3IfMT007l02P3IfMT01@000?l0fMWI0=WIf@3IfMT0\n07l000@0fMWI00<0003o0=WIf@00O`00203IfMT00`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0\nfMWI00<0fMWI00<007l00000o`3IfMT00`3IfMT00`000?l0fMWI0=WIf@040=WIf@03001o003IfMT0\nfMWI0080fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0\nfMWI00P0fMWI00@007l00=WIf@3IfMT007l02@3IfMT01000O`00fMWI0=WIf@00O`090=WIf@8007l0\n2@3IfMT2001o00P0fMWI0P00O`060=WIf@8007l01`3IfMT00`00O`00fMWI0=WIf@1:0=WIf@00703I\nfMT00`000000fMWI0000o`040=WIf@03001o003IfMT0fMWI00X0fMWI00D0003o0=WIf@3IfMT0fMWI\n001o00040=WIf@040000o`3IfMT0fMWI001o00T0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00O`00\nfMWI0=WIf@030=WIf@030000o`00O`00fMWI00H0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@030=WIf@03001o00000?l0003o00<0003o1`3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n00/0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@03001o003IfMT007l000X0fMWI00@007l0\n0=WIf@3IfMT007l02@3IfMT2001o00T0fMWI0P00O`080=WIf@03001o003IfMT0fMWI00D0fMWI0P00\nO`1D0=WIf@00703IfMT00`000000fMWI0000o`040=WIf@03001o003IfMT0fMWI00X0fMWI00D0003o\n0=WIf@3IfMT0fMWI001o00040=WIf@040000o`3IfMT0fMWI001o00T0fMWI00<0003o0=WIf@3IfMT0\n0P3IfMT00`00O`00fMWI0=WIf@030=WIf@030000o`00O`00fMWI00H0fMWI00<0003o0=WIf@3IfMT0\n0`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00/0fMWI00D007l00=WIf@3IfMT0\nfMWI001o000;0=WIf@05001o003IfMT0fMWI0=WIf@00O`002`3IfMT00`00O`00fMWI001o000:0=WI\nf@03001o003IfMT007l000X0fMWI0P00O`090=WIf@03001o003IfMT0fMWI00L0fMWI00<007l00=WI\nf@3IfMT01@3IfMT2001o05@0fMWI000L0=WIf@040000003IfMT0fMWI0000o`<0fMWI00<007l00=WI\nf@3IfMT02P3IfMT01@000?l0fMWI0=WIf@3IfMT007l000@0fMWI00@0003o0=WIf@3IfMT007l02@3I\nfMT00`000?l0fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00<0fMWI00<007l00000o`3IfMT01@3I\nfMT00`000?l0fMWI0=WIf@040=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02`3I\nfMT01@00O`00fMWI0=WIf@3IfMT007l000/0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@03\n001o003IfMT007l000X0fMWI00<007l00=WIf@00O`002P3IfMT2001o00T0fMWI00<007l00=WIf@3I\nfMT01`3IfMT00`00O`00fMWI0=WIf@050=WIf@03001o003IfMT0fMWI05<0fMWI000L0=WIf@040000\n003IfMT0fMWI0000o`<0fMWI00<007l00=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@020=WIf@03\n001o003IfMT0fMWI0080fMWI00<0003o0=WIf@00O`002@3IfMT00`000?l0fMWI0=WIf@030=WIf@03\n001o003IfMT0fMWI00<0fMWI00<007l00000o`3IfMT01@3IfMT00`000?l0fMWI0=WIf@040=WIf@03\n001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT02`3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n00/0fMWI00D007l00=WIf@3IfMT0fMWI001o000;0=WIf@03001o003IfMT007l000X0fMWI00<007l0\n0=WIf@00O`002P3IfMT2001o00T0fMWI00<007l00=WIf@3IfMT01`3IfMT00`00O`00fMWI0=WIf@1K\n0=WIf@00703IfMT010000000fMWI0=WIf@000?l30=WIf@03001o003IfMT0fMWI00T0fMWI00<0003o\n0=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@030=WIf@030000o`00O`00fMWI00P0fMWI00<0003o\n0=WIf@3IfMT00`3IfMT00`00O`00fMWI0=WIf@030=WIf@03001o003IfMT0003o00@0fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00/0fMWI00D007l0\n0=WIf@3IfMT0fMWI001o000;0=WIf@05001o003IfMT0fMWI0=WIf@00O`002`3IfMT00`00O`00fMWI\n001o000:0=WIf@03001o003IfMT007l000X0fMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI\n0=WIf@070=WIf@03001o003IfMT0fMWI05/0fMWI000L0=WIf@070000003IfMT0fMWI0=WIf@000?l0\nfMWI001o000<0=WIf@030000o`3IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT00`3IfMT00`000?l0\n07l00=WIf@080=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00\nfMWI0=WIf@040000o`P0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@05\n001o003IfMT0fMWI0=WIf@00O`002`3IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@03001o003IfMT0\n07l000X0fMWI00<007l00=WIf@00O`002P3IfMT00`00O`00fMWI0=WIf@080=WIf@03001o003IfMT0\nfMWI06D0fMWI000L0=WIf@070000003IfMT0fMWI0=WIf@000?l0fMWI001o000;0=WIf@030000o`3I\nfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@060=WIf@030000o`3I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00`3IfMT01000O`00fMWI0=WIf@3IfMT20000o`T0fMWI\n00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0;0=WIf@04001o003IfMT0fMWI001o00`0\nfMWI00@007l00=WIf@3IfMT007l0303IfMT00`00O`00fMWI001o000:0=WIf@8007l02`3IfMT00`00\nO`00fMWI0=WIf@080=WIf@03001o003IfMT0fMWI06D0fMWI000L0=WIf@070000003IfMT0fMWI0=WI\nf@000?l0fMWI001o000;0=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT0103IfMT0\n0`00O`00fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00P3IfMT0\n0`00O`00fMWI0=WIf@0=0=WIf@05001o003IfMT0fMWI0=WIf@00O`003P3IfMT01000O`00fMWI0=WI\nf@00O`0<0=WIf@04001o003IfMT0fMWI001o00`0fMWI00<007l00=WIf@00O`002P3IfMT2001o00/0\nfMWI00<007l00=WIf@3IfMT0203IfMT00`00O`00fMWI0=WIf@1U0=WIf@00703IfMT01`000000fMWI\n0=WIf@3IfMT0003o0=WIf@00O`002`3IfMT00`000?l0fMWI0=WIf@030=WIf@03001o003IfMT0fMWI\n00<0fMWI00<007l00=WIf@000?l01`3IfMT00`000?l0fMWI0=WIf@040=WIf@03001o003IfMT0fMWI\n0080fMWI00<007l00=WIf@3IfMT03@3IfMT01@00O`00fMWI0=WIf@3IfMT007l000h0fMWI00@007l0\n0=WIf@3IfMT007l0303IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@8007l02`3IfMT2001o00/0fMWI\n00<007l00=WIf@3IfMT0L03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l007l00=WI\nf@0:0=WIf@030000o`3IfMT0fMWI00<0fMWI00<007l00=WIf@3IfMT00`3IfMT00`00O`00fMWI0000\no`060=WIf@030000o`3IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WI\nf@0=0=WIf@05001o003IfMT0fMWI0=WIf@00O`003P3IfMT01000O`00fMWI0=WIf@00O`0<0=WIf@04\n001o003IfMT0fMWI001o00`0fMWI0P00O`0;0=WIf@8007l02`3IfMT00`00O`00fMWI0=WIf@1`0=WI\nf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l007l00=WIf@090=WIf@03\n0000o`3IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00`3IfMT01000O`00fMWI0=WIf@000?l40=WI\nf@80003o1`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00d0fMWI00D007l00=WI\nf@3IfMT0fMWI001o000>0=WIf@04001o003IfMT0fMWI001o00`0fMWI00<007l00=WIf@00O`003@3I\nfMT2001o00/0fMWI0P00O`0;0=WIf@03001o003IfMT0fMWI0700fMWI000D0=WIf@040000003IfMT0\nfMWI000000@0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l007l00=WIf@090=WIf@030000o`3I\nfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT00`3IfMT01@00O`00fMWI0=WIf@3IfMT0003o0080fMWI\n0P000?l80=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT03@3IfMT01@00O`00fMWI\n0=WIf@3IfMT007l000h0fMWI00<007l00=WIf@00O`003@3IfMT00`00O`00fMWI001o000=0=WIf@80\n07l02`3IfMT2001o07h0fMWI000G0=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@03001o\n003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0103IfMT00`00O`00fMWI0=WIf@030=WIf@03001o\n003IfMT0fMWI0080fMWI0`000?l90=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n3@3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@03001o003IfMT007l000d0fMWI00<007l00=WIf@00\nO`003@3IfMT2001o00/0fMWI0P00O`1n0=WIf@005@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0\n0P3IfMT00`00O`00003o0=WIf@090=WIf@030000o`3IfMT0fMWI00@0fMWI00<007l00=WIf@3IfMT0\n0P3IfMT00`00O`00fMWI0=WIf@0?0=WIf@03001o003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n3@3IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@03001o003IfMT007l000d0fMWI00<007l00=WIf@00\nO`003@3IfMT2001o00/0fMWI00<007l00=WIf@3IfMT0O@3IfMT001D0fMWI00<000000=WIf@3IfMT0\n103IfMT00`000000fMWI0=WIf@020=WIf@03001o00000?l0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n1@3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI00<007l00=WIf@3IfMT0\n0P3IfMT00`00O`00fMWI0=WIf@0=0=WIf@04001o003IfMT0fMWI001o00l0fMWI00<007l00=WIf@00\nO`003@3IfMT00`00O`00fMWI001o000=0=WIf@03001o003IfMT0fMWI00X0fMWI0P00O`1n0=WIf@00\n5@3IfMT3000000@0fMWI00<000000=WIf@3IfMT00P3IfMT00`00O`00fMWI0000o`080=WIf@030000\no`3IfMT0fMWI00D0fMWI00<007l00=WIf@3IfMT00P3IfMT00`00O`00fMWI0=WIf@0?0=WIf@05001o\n003IfMT0fMWI0=WIf@00O`00403IfMT01000O`00fMWI0=WIf@00O`0?0=WIf@03001o003IfMT007l0\n00d0fMWI00<007l00=WIf@00O`003@3IfMT00`00O`00fMWI0=WIf@2:0=WIf@00703IfMT00`000000\nfMWI0=WIf@020=WIf@03001o003IfMT0003o00L0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00O`00\nfMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI00D007l00=WIf@3IfMT0fMWI001o000@0=WI\nf@04001o003IfMT0fMWI001o00l0fMWI0P00O`0>0=WIf@8007l03P3IfMT00`00O`00fMWI0=WIf@2:\n0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@04001o003IfMT0fMWI0000o`H0fMWI00<0003o\n0=WIf@3IfMT01P3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI00D007l0\n0=WIf@3IfMT0fMWI001o000@0=WIf@03001o003IfMT007l00100fMWI0P00O`0>0=WIf@8007l03P3I\nfMT00`00O`00fMWI0=WIf@2:0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@03001o003IfMT0\nfMWI0080003o103IfMT00`000?l0fMWI0=WIf@070=WIf@03001o003IfMT0fMWI0080fMWI00<007l0\n0=WIf@3IfMT03`3IfMT01@00O`00fMWI0=WIf@3IfMT007l00100fMWI00<007l00=WIf@00O`00403I\nfMT2001o00h0fMWI0P00O`0>0=WIf@03001o003IfMT0fMWI08X0fMWI000L0=WIf@050000003IfMT0\nfMWI0=WIf@00O`00103IfMT20000o`80fMWI00<0003o0=WIf@3IfMT0203IfMT00`00O`00fMWI0=WI\nf@020=WIf@03001o003IfMT0fMWI00l0fMWI00D007l00=WIf@3IfMT0fMWI001o000@0=WIf@03001o\n003IfMT007l00100fMWI0P00O`0>0=WIf@8007l0V`3IfMT001`0fMWI00D000000=WIf@3IfMT0fMWI\n001o00050=WIf@<0003o2`3IfMT00`00O`00fMWI0=WIf@020=WIf@03001o003IfMT0fMWI00l0fMWI\n00@007l00=WIf@3IfMT007l04@3IfMT00`00O`00fMWI001o000@0=WIf@8007l03P3IfMT2001o09/0\nfMWI000L0=WIf@050000003IfMT0fMWI0=WIf@00O`004`3IfMT01@00O`00fMWI0=WIf@3IfMT007l0\n0180fMWI00@007l00=WIf@3IfMT007l04@3IfMT00`00O`00fMWI001o000@0=WIf@8007l03P3IfMT2\n001o09/0fMWI000L0=WIf@050000003IfMT0fMWI0=WIf@00O`004`3IfMT01@00O`00fMWI0=WIf@3I\nfMT007l00180fMWI00@007l00=WIf@3IfMT007l04@3IfMT00`00O`00fMWI001o000@0=WIf@03001o\n003IfMT0fMWI00d0fMWI0P00O`2K0=WIf@00703IfMT01@000000fMWI0=WIf@3IfMT007l001<0fMWI\n00D007l00=WIf@3IfMT0fMWI001o000B0=WIf@04001o003IfMT0fMWI001o0140fMWI0P00O`0A0=WI\nf@03001o003IfMT0fMWI0:X0fMWI000L0=WIf@040000003IfMT0fMWI001o01@0fMWI00D007l00=WI\nf@3IfMT0fMWI001o000B0=WIf@04001o003IfMT0fMWI001o0140fMWI0P00O`0A0=WIf@03001o003I\nfMT0fMWI0:X0fMWI000L0=WIf@040000003IfMT0fMWI001o01@0fMWI00D007l00=WIf@3IfMT0fMWI\n001o000B0=WIf@04001o003IfMT0fMWI001o0140fMWI0P00O`0A0=WIf@03001o003IfMT0fMWI0:X0\nfMWI000L0=WIf@040000003IfMT0fMWI001o01@0fMWI00D007l00=WIf@3IfMT0fMWI001o000B0=WI\nf@03001o003IfMT007l00180fMWI0P00O`0A0=WIf@03001o003IfMT0fMWI0:X0fMWI000L0=WIf@04\n0000003IfMT0fMWI001o01@0fMWI00@007l00=WIf@3IfMT007l04`3IfMT00`00O`00fMWI001o000B\n0=WIf@8007l04@3IfMT00`00O`00fMWI0=WIf@2Z0=WIf@00703IfMT010000000fMWI0=WIf@00O`0D\n0=WIf@04001o003IfMT0fMWI001o01<0fMWI00<007l00=WIf@00O`004P3IfMT2001o0;h0fMWI000L\n0=WIf@030000003IfMT007l001D0fMWI00@007l00=WIf@3IfMT007l04`3IfMT00`00O`00fMWI001o\n000B0=WIf@8007l0_P3IfMT001`0fMWI00<000000=WIf@00O`005@3IfMT01000O`00fMWI0=WIf@00\nO`0C0=WIf@03001o003IfMT007l00180fMWI0P00O`2n0=WIf@00703IfMT00`000000fMWI001o000E\n0=WIf@04001o003IfMT0fMWI001o01<0fMWI0P00O`0C0=WIf@03001o003IfMT0fMWI0;d0fMWI000L\n0=WIf@030000003IfMT007l001D0fMWI00<007l00=WIf@00O`00503IfMT2001o01<0fMWI00<007l0\n0=WIf@3IfMT0_@3IfMT001`0fMWI00<000000=WIf@00O`005@3IfMT00`00O`00fMWI001o000D0=WI\nf@8007l04`3IfMT00`00O`00fMWI0=WIf@2m0=WIf@00703IfMT00`000000fMWI001o000E0=WIf@03\n001o003IfMT007l001@0fMWI0P00O`3C0=WIf@00703IfMT00`00000007l00=WIf@0E0=WIf@03001o\n003IfMT007l001@0fMWI0P00O`3C0=WIf@00703IfMT00`00000007l00=WIf@0E0=WIf@03001o003I\nfMT007l001@0fMWI00<007l00=WIf@3IfMT0dP3IfMT001`0fMWI00<00000001o003IfMT05@3IfMT2\n001o01D0fMWI00<007l00=WIf@3IfMT0dP3IfMT001`0fMWI00<00000001o003IfMT05@3IfMT2001o\n01D0fMWI0P00O`3C0=WIf@00703IfMT00`00000007l00=WIf@0E0=WIf@8007l05@3IfMT00`00O`00\nfMWI0=WIf@3B0=WIf@00703IfMT00`00O`00fMWI0=WIf@0E0=WIf@8007l0jP3IfMT001`0fMWI00<0\n07l00=WIf@3IfMT05@3IfMT2001o0>X0fMWI000L0=WIf@03001o003IfMT0fMWI01D0fMWI0P00O`3Z\n0=WIf@00703IfMT00`00O`00fMWI0=WIf@0E0=WIf@03001o003IfMT0fMWI0>T0fMWI000>0=WIf@D0\n00000P3IfMT2000000D0fMWI00<007l00=WIf@3IfMT05@3IfMT00`00O`00fMWI0=WIf@3Y0=WIf@00\n403IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`00O`00\nfMWI0=WIf@0E0=WIf@8007l0jP3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI0080fMWI00<007l00000003IfMT0o`3IfMT20=WIf@00403IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@80\nfMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@03\n0000003IfMT0fMWI0?l0fMWI0P3IfMT000l0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT004`0fMWI0P000006\n0=WIf@800000203IfMT200000<00fMWI001=0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WI\nf@3IfMT0203IfMT00`000000fMWI0=WIf@2n0=WIf@008`3IfMT2000000@0fMWI0`0000020=WIf@<0\n0000103IfMT2000000@0fMWI0`0000030=WIf@<000000`3IfMT2000000D0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@2n0=WIf@00\n8`3IfMT2000000<0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@020=WIf@040000\n003IfMT0fMWI00000080fMWI00<000000=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT00000\n0080fMWI00L000000=WIf@3IfMT0fMWI0000003IfMT0000000@0fMWI00D000000=WIf@3IfMT0fMWI\n000000020=WIf@050000003IfMT0fMWI0=WIf@000000`03IfMT001H0fMWI2000O`040=WIf@040000\n003IfMT0fMWI00000080fMWI100000030=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3I\nfMT000000P3IfMT00`000000fMWI0=WIf@050=WIf@050000003IfMT0fMWI0=WIf@0000001@3IfMT0\n10000000fMWI0=WIf@0000040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI\n0=WIf@2n0=WIf@008@3IfMT200000080fMWI0P0000020=WIf@800000103IfMT00`000000fMWI0=WI\nf@030=WIf@800000103IfMT3000000<0fMWI0P0000020=WIf@D0000000D0fMWI0000000000000000\n0=WIf@02000000<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;h0fMWI\n000_0=WIf@030000003IfMT0fMWI01@0fMWI00<000000=WIf@3IfMT02`3IfMT01@000000fMWI0=WI\nf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0_P3IfMT002h0fMWI0P00000B0=WIf@030000003I\nfMT0fMWI00l0fMWI0P0000080=WIf@800000`03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT003@0fMWI0`00000A0=WI\nf@800000203IfMT200000<`0fMWI000g0=WIf@030000003IfMT0fMWI00h0fMWI00<000000=WIf@3I\nfMT0203IfMT00`000000fMWI0=WIf@3:0=WIf@008@3IfMT3000000030=WIf@00000000000080fMWI\n0`0000030=WIf@<000000`3IfMT3000000050=WIf@00000000000000003IfMT00P0000020=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3:0=WIf@00\n5P3IfMT80000o`@0fMWI00@000000=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@050=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0\nfMWI00000080fMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00D000000=WIf@3IfMT0fMWI0000003<0=WIf@008P3IfMT010000000fMWI0=WIf@0000020=WIf@@0\n0000103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT0\n10000000fMWI0=WIf@0000070=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI\n0=WIf@3:0=WIf@008P3IfMT3000000@0fMWI0P0000040=WIf@800000103IfMT4000000040=WIf@00\n0000000000000080fMWI1@0000040=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI\n0=WIf@3:0=WIf@008P3IfMT00`000000fMWI0=WIf@0E0=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0\nbP3IfMT00240fMWI0P00000=0=WIf@030000003IfMT0fMWI00H0fMWI0P00000=0=WIf@800000203I\nfMT200000<`0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-2.43537`, -13.57`, 0.0869108`, 0.147213`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Bouncing Ball Error", "Section"], Cell[TextData[List["If the assignment ", StyleBox["velocity := -c*velocity", Rule[FontFamily, "Courier"]], " is used instead of ", StyleBox["reinit(velocity, -c*velocity)", Rule[FontFamily, "Courier"]], " an overdeterminated system of equations are created."]], "Text"], Cell[TextData[List["model BouncingBallError \t\t\t\t\"The bouncing ball model with an algorithm\"\n  constant Real g = 9.81;\t\t\t\t// Gravitational acceleration\n  parameter Real c = 0.9;\t\t\t\t// Elasticity constant of ball\n  Real height(start = 1);\t\t\t\t// height above ground of the ball center\n  Real velocity(start = 10);\t\t\t// Velocity of the ball\nequation\n  der(height) = velocity;\n  der(velocity) = -g;\nalgorithm  \n  when height <= 0 then \n    ", StyleBox["velocity := -c*velocity;", Rule[FontColor, RGBColor[1, 0, 0]]], "\n  end when;\nend BouncingBallError;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Bouncing Ball Error ", "Section"], Cell["When we try to simulate the erroneous Bouncing Ball model we get a complaint for having to many equations.", "Text"], Cell["simulate( BouncingBallError, stopTime=20 );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "trsmd"]], RowBox[List[":", " "]], "\"Simulate failed to translate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\n- savelog\\\\n- translateModel(\\\\\\\"BouncingBallError\\\\\\\")\\\\nTranslation started\\\\nError: Model is singular:\\\\n  The number of non-trivial (scalar) equations is 3.\\\\n  The number of (scalar) variables is 2.\\\\n  Additional equations: \\\\n    algorithm \\\\n      when height <= 0 then\\\\n        velocity :=  -c*velocity;\\\\n      end when;\\\\n\\\\nTranslation aborted.\\\\n\\\\nTranslation aborted.\\\\n\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Open]], Cell[CellGroupData[List[Cell["FilterBlock1", "Section"], Cell[TextData[List["Another example of how to use ", StyleBox["reinit", Rule[FontFamily, "Courier"]], " is the self initializing block class ", StyleBox["FilterBlock1", Rule[FontFamily, "Courier"]], ", which when ", StyleBox["initial()", Rule[FontFamily, "Courier"]], " becomes true defines ", StyleBox["x", Rule[FontFamily, "Courier"]], " to be ", StyleBox["u", Rule[FontFamily, "Courier"]], ". This causes ", StyleBox["der(x)", Rule[FontFamily, "Courier"]], " to initially be zero according to its defining equation. "]], "Text"], Cell[TextData[List["block FilterBlock1\t\t\t\t\t\"First order filter block\"\n  parameter Real T = 1\t\t\t\t\"Time constant\";\n  parameter Real k = 1\t\t\t\t\"Gain\";\n  input  Real u = 1;\n  output Real y;\nprotected\n  Real x;\t\t\nequation\n  der(x) = (u - x)/T;\n  y = k*x;\nalgorithm\n  when initial() then \n    ", StyleBox["reinit(x, u);\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// if x is u since der(x) = (u - x)/T\t\t\t\t\t\n  end when;\nend FilterBlock1;    "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["FilterBlock Simulation", "Section"], Cell["simulate( FilterBlock1, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FilterBlock1\\) : 2004-1-30 14:49:39.0997952 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 3 variables>\\n\\!\\({\\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\\"T\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[852, 924]], Rule[WindowMargins, List[List[156, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]