List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Algorithm Sections", "Title"], Cell[TextData[List["\nAlgorithm sections can also be called algorithm equations, since an algorithm section externally is treated as a group of equations involving one or more variables, and can appear among equation sections. An algorithm section is terminated by the appearance of one of the five keywords ", StyleBox["equation, public, protected, algorithm", Rule[FontFamily, "Courier"]], " or ", StyleBox["end", Rule[FontFamily, "Courier"]], ". An algorithm section embedded among equation sections can appear as below, where the example algorithm section contains three assignment statements.\n"]], "Text"], Cell[TextData[List["model AlgorithmSection\n  Real x, z, u;\n  parameter Real w = 3,y = 2;\n  Real x1, x2, x3;\nequation\n  x = y*2;\n  z = w;\n", StyleBox["algorithm\n  x1 := z  + x;  \n  x2 := y  - 5;\n  x3 := x2 + y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  u = x1 + x2;  \nend AlgorithmSection;"]], "ModelicaInput"], Cell[TextData[List["\nNote that the code in the algorithm section uses the value of certain variables from outside the algorithm section. The variables are also called ", StyleBox["inputs", Rule[FontFamily, "Courier"]], " to the algorithm section (in this example ", StyleBox["x, y", Rule[FontFamily, "Courier"]], ", and ", StyleBox["z", Rule[FontFamily, "Courier"]], "). Analogously, variables assigned values by the algorithm define the outputs of the algorithm (in this example ", StyleBox["x1", Rule[FontFamily, "Courier"]], " and ", StyleBox["x2", Rule[FontFamily, "Courier"]], "). This makes the semantics of an algorithm section quite similar to a ", StyleBox["function", Rule[FontFamily, "Courier"]], " with the algorithm ", Cell[BoxData[FormBox["sec", TraditionalForm]]], "tion as its body, and with ", StyleBox["input", Rule[FontFamily, "Courier"]], " and ", StyleBox["output", Rule[FontFamily, "Courier"]], " formal parameters corresponding to inputs and outputs as described above. "]], "Text"], Cell[CellGroupData[List[Cell["Simulation of AlgorithmSection", "Section"], Cell["simulate( AlgorithmSection );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AlgorithmSection\\) : 2004-1-30 14:35:0.7261736 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"u\\\", HoldForm], \\*TagBox[\\\"w\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"x1\\\", HoldForm], \\*TagBox[\\\"x2\\\", HoldForm], \\*TagBox[\\\"x3\\\", HoldForm], \\*TagBox[\\\"y\\\", HoldForm], \\*TagBox[\\\"z\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[777, 907]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]