List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["when-Statements", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List[StyleBox["When-statements ", Rule[FontSlant, "Italic"]], "are used to express actions (statements) that are only executed at ", ButtonBox["events", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[]], "DrModelica.nb", Rule[CharacterEncoding, "WindowsANSI"]], "Ch.13-eventhybrid"]], Rule[ButtonStyle, "Hyperlink"]], ", e.g. at discontinuities or when certain conditions become true. The executed statements", StyleBox[" ", Rule[FontSlant, "Italic"]], "contain ", StyleBox["discrete-time", Rule[FontSlant, "Italic"]], " expressions since they are computed only at event instants, even expressions that otherwise would be classified as continuous-time. \n\n", "When-statements are generally used to either reinitialize a continuous variable using the reinit operator or to change the value of a discrete variable. When-statements are closely related to when-equations, the obvious difference between them is that ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements are statements containing other statements and can only be used in algorithm sections whereas ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations are equations which are only allowed in equation sections. "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["WhenStat", "Section"], Cell[TextData[List["The when-statement below are executed at the event instant when the Boolean expression", StyleBox[" x > 2", Rule[FontFamily, "Courier"]], " becomes true. We should note that this is different from an ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement with the same condition which executes its body each time when invoked provided that the condition of the ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement is true. This difference is easier to understand if we consider the definition of ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements in terms of ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statements and the edge operator in the section below.\n"]], "Text"], Cell[TextData[List["class WhenStat\n  Real x(start=1);\n  Real y1;\n  parameter Real y2 = 5;\n  Real y3;\nalgorithm\n  ", StyleBox["when x > 2 then\n    y1 := sin(x);\n    y3 := 2*x + pre(y1) + y2;\n  end when;\nequation\n  der(x) = 2*x;  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend WhenStat;    "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenStat", "Section"], Cell["simulate( WhenStat );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenStat\\) : 2004-1-30 14:47:49.0074544 : \\!\\({0.`, 1.`}\\) : 504 data points : 2 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y1\\\", HoldForm], \\*TagBox[\\\"y2\\\", HoldForm], \\*TagBox[\\\"y3\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y1 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.0147151 0.647317 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14418 -18 -4.5 ]\n[.01131 .14418 0 4.5 ]\n[.01131 .27364 -18 -4.5 ]\n[.01131 .27364 0 4.5 ]\n[.01131 .40311 -18 -4.5 ]\n[.01131 .40311 0 4.5 ]\n[.01131 .53257 -18 -4.5 ]\n[.01131 .53257 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14418 m\n.03006 .14418 L\ns\n[(0.2)] .01131 .14418 1 0 Mshowa\n.02381 .27364 m\n.03006 .27364 L\ns\n[(0.4)] .01131 .27364 1 0 Mshowa\n.02381 .40311 m\n.03006 .40311 L\ns\n[(0.6)] .01131 .40311 1 0 Mshowa\n.02381 .53257 m\n.03006 .53257 L\ns\n[(0.8)] .01131 .53257 1 0 Mshowa\n.125 Mabswid\n.02381 .04708 m\n.02756 .04708 L\ns\n.02381 .07945 m\n.02756 .07945 L\ns\n.02381 .11181 m\n.02756 .11181 L\ns\n.02381 .17654 m\n.02756 .17654 L\ns\n.02381 .20891 m\n.02756 .20891 L\ns\n.02381 .24128 m\n.02756 .24128 L\ns\n.02381 .30601 m\n.02756 .30601 L\ns\n.02381 .33837 m\n.02756 .33837 L\ns\n.02381 .37074 m\n.02756 .37074 L\ns\n.02381 .43547 m\n.02756 .43547 L\ns\n.02381 .46784 m\n.02756 .46784 L\ns\n.02381 .5002 m\n.02756 .5002 L\ns\n.02381 .56493 m\n.02756 .56493 L\ns\n.02381 .5973 m\n.02756 .5973 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\nMistroke\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00@`3IfMT2000000@0fMWI0P0000030=WIf@@000007`3IfMT2000000@0\nfMWI0P0000050=WIf@<000007P3IfMT2000000@0fMWI0P0000030=WIf@<00000803IfMT2000000@0\nfMWI0P0000040=WIf@8000009@3IfMT5000001/0fMWI00120=WIf@040000003IfMT0fMWI000000P0\nfMWI00<000000=WIf@3IfMT07`3IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI\n01`0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003I\nfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00\n@P3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3I\nfMT00000203IfMT5000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00\n000N0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000\nfMWI0=WIf@0K0=WIf@00@P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01d0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0\nfMWI000000P0fMWI0`00000O0=WIf@040000003IfMT0fMWI000000T0fMWI0P00000W0=WIf@030000\n003IfMT0fMWI01/0fMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0\n00007P3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000001h0fMWI00@000000=WI\nf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@`3IfMT2000000X0fMWI0P00\n000P0=WIf@8000002`3IfMT2000001l0fMWI0P00000:0=WIf@<000007`3IfMT2000000X0fMWI0P00\n000V0=WIf@8000007@3IfMT00?l0fMWI8@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?80fMWI\n0P00000=0=WIf@00703IfMT00`000000fMWI0=WIf@3a0=WIf@040000003IfMT0fMWI000000`0fMWI\n000F0=WIf@H00000D0000?nL000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l000000=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0:80fMWI00<000000=WI\nf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@800000103IfMT2000000<0fMWI\n100000040=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI\n0=WIf@040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WI\nf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000X0fMWI\n0P0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<\n0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000@0fMWI0P0000050=WIf@<000000`3I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0\nfMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI1@0000030=WIf@800000C@3I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000/0fMWI0P0000040=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WI\nf@800000103IfMT2000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@000004\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@<000001@3IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<0\n00000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI0009\n0=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0\nfMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@03\n0000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0\n/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@800000103IfMT20000\n00@0fMWI0P0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT0\n10000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@8000002P3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0\nfMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WI\nf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3I\nfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80\nfMWI000L0=WIf@030000003IfMT0fMWI04`0fMWIV0000?lM0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000R0=WIf@800000303IfMT2000000P0\nfMWI0P00003T0=WIf@008`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT0hP3IfMT002@0fMWI00@000000=WIf@3IfMT0fMWI1@0000030=WIf@030000\n003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>80fMWI000S0=WIf@030000003I\nfMT0000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00D000000=WIf@3IfMT0fMWI0000003T0=WIf@005P3IfMT80000o`@0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@3R0=WIf@008@3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0hP3IfMT002X0fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3I\nfMT0hP3IfMT002T0fMWI0P0000050=WIf@800000203IfMT200000>@0fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, -0.144427`, 0.00434554`, 0.00639348`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( y3 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.0147151 0.0654004 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14552 -6 -4.5 ]\n[.01131 .14552 0 4.5 ]\n[.01131 .27632 -6 -4.5 ]\n[.01131 .27632 0 4.5 ]\n[.01131 .40712 -6 -4.5 ]\n[.01131 .40712 0 4.5 ]\n[.01131 .53792 -6 -4.5 ]\n[.01131 .53792 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14552 m\n.03006 .14552 L\ns\n[(2)] .01131 .14552 1 0 Mshowa\n.02381 .27632 m\n.03006 .27632 L\ns\n[(4)] .01131 .27632 1 0 Mshowa\n.02381 .40712 m\n.03006 .40712 L\ns\n[(6)] .01131 .40712 1 0 Mshowa\n.02381 .53792 m\n.03006 .53792 L\ns\n[(8)] .01131 .53792 1 0 Mshowa\n.125 Mabswid\n.02381 .04742 m\n.02756 .04742 L\ns\n.02381 .08012 m\n.02756 .08012 L\ns\n.02381 .11282 m\n.02756 .11282 L\ns\n.02381 .17822 m\n.02756 .17822 L\ns\n.02381 .21092 m\n.02756 .21092 L\ns\n.02381 .24362 m\n.02756 .24362 L\ns\n.02381 .30902 m\n.02756 .30902 L\ns\n.02381 .34172 m\n.02756 .34172 L\ns\n.02381 .37442 m\n.02756 .37442 L\ns\n.02381 .43982 m\n.02756 .43982 L\ns\n.02381 .47252 m\n.02756 .47252 L\ns\n.02381 .50522 m\n.02756 .50522 L\ns\n.02381 .57062 m\n.02756 .57062 L\ns\n.02381 .60332 m\n.02756 .60332 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\nMistroke\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y3) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00>@3IfMT2000000@0fMWI0P0000030=WIf@@00000\n8@3IfMT2000000@0fMWI0P0000050=WIf@<000008@3IfMT2000000@0fMWI0P0000030=WIf@<00000\n8P3IfMT2000000@0fMWI0P0000040=WIf@8000009`3IfMT5000001`0fMWI000h0=WIf@040000003I\nfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT08@3IfMT010000000fMWI0=WIf@00000;0=WIf@03\n0000003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000P\n0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI\n0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI0200fMWI\n00@000000=WIf@3IfMT00000203IfMT500000200fMWI00@000000=WIf@3IfMT00000203IfMT01000\n0000fMWI0=WIf@00000P0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000Q0=WI\nf@040000003IfMT0fMWI000000P0fMWI0`00000Q0=WIf@040000003IfMT0fMWI000000T0fMWI0P00\n000Y0=WIf@030000003IfMT0fMWI01`0fMWI000h0=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT00000803IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT000000240\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0P0=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>@3IfMT2\n000000X0fMWI0P00000R0=WIf@8000002`3IfMT200000280fMWI0P00000:0=WIf@<000008@3IfMT2\n000000X0fMWI0P00000X0=WIf@8000007P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00100fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@\n0=WIf@030000003IfMT0fMWI0?h0fMWI0P00000=0=WIf@002P3IfMT6000005@0003oY00000080=WI\nf@040000003IfMT0fMWI000000`0fMWI000@0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0000\n003IfMT02P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00d0fMWI000@0=WIf@03\n0000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0803IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WIf@0]0=WIf@03\n0000003IfMT0fMWI00/0fMWI1@00000<0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0:X0fMWI00<000000=WIf@3IfMT03@3IfMT00100fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3I\nfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`00\n0000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3I\nfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403I\nfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT0\n0`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI\n0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI\n00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WI\nf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o\n0=WIf@3IfMT0^P3IfMT000P0fMWI100000040=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT000P0fMWI00<000000=WIf@3IfMT01@3IfMT00`000000fMWI0=WIf@1@0=WIf@03\n0000o`3IfMT0fMWI0;X0fMWI00090=WIf@030000003IfMT0fMWI00@0fMWI0P00001A0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000003I\nfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000T0fMWI0P0000050=WIf@030000003IfMT0\nfMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`00\n0?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WI\nf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000\n003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3I\nfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`00\n0000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3I\nfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002P3I\nfMT3000000<0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002`3IfMT0\n0`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT0\n00P0fMWI1@0000030=WIf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@00203IfMT010000000\nfMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000T0\nfMWI00<000000=WIf@000000103IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000:0=WIf@800000103IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3I\nfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003I\nfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT0\n0`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI\n0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI\n00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WI\nf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o\n0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@03\n0000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0\nD03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3I\nfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT0\n0100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000\nfMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WI\nf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@03\n0000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0\n^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@<000001@3IfMT00`00\n0000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00203IfMT010000000\nfMWI0=WIf@0000040=WIf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@00203IfMT3000000D0\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002@3IfMT00`000000fMWI\n0=WIf@040=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000T0fMWI0`00\n00040=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3I\nfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403I\nfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT0\n0`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI\n0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI\n00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WI\nf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o\n0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WI\nf@00403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0\nD03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3I\nfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT0\n0100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000\nfMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@03\n0000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0\n^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI\n0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0500\nfMWI00<0003o0=WIf@3IfMT0^P3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@040000003IfMT0fMWI000000@0\nfMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI00090=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@040000003IfMT0fMWI000000@0fMWI\n00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002@3IfMT2000000D0fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00\n403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0\n003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j\n0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@03\n0000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIfIl0003o\n7P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o\n0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00280fMWI\n0P00000<0=WIf@800000203IfMT200000>@0fMWI000S0=WIf@030000003IfMT0fMWI00X0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@3R0=WIf@00903IfMT00`000000fMWI0=WIf@02\n0=WIf@8000001@3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3R\n0=WIf@008`3IfMT00`000000fMWI000000020=WIf@040000003IfMT0fMWI000000@0fMWI00D00000\n0=WIf@3IfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000i03IfMT001H0fMWI2000\n0?l40=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI\n0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0hP3IfMT00240fMWI0`0000000`3IfMT00000\n000000040=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000\n003IfMT0fMWI0>80fMWI000X0=WIf@040000003IfMT0fMWI000000@0fMWI00D000000=WIf@3IfMT0\nfMWI000000060=WIf@030000003IfMT0fMWI0>80fMWI000Y0=WIf@8000001@3IfMT2000000P0fMWI\n0P00003T0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0669834`, -1.15178`, 0.00414258`, 0.0603256`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["WhenStat2", "Section"], Cell[TextData[List["If we use a ", StyleBox["Boolean", Rule[FontFamily, "Courier"]], " vector expression containing three elements as the ", StyleBox["conditions", Rule[FontSlant, "Italic"]], ", then the two statements will be executed at event instants when at least one of the three conditions:", StyleBox[" x > 2", Rule[FontFamily, "Courier"]], ", ", StyleBox["sample(0, 2)", Rule[FontFamily, "Courier"]], " or ", StyleBox["x < 5", Rule[FontFamily, "Courier"]], " becomes ", StyleBox["true", Rule[FontFamily, "Courier"]], ". Typically each condition in the vector generates its own event instants.\n"]], "Text"], Cell[TextData[List["class WhenStat2\n  Real x(start = 1);\n  Real y1;\n  parameter Real y2 = 5;\n  Real y3;\nalgorithm\n  ", StyleBox["when {x > 2, sample(0, 2), x < 5} then\n    y1 := sin(x);\n    y3 := 2*x + y1 + y2;\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n", StyleBox["equation\n  der(x) = 2*x; ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend WhenStat2;    "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenStat2", "Section"], Cell["simulate( WhenStat2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenStat2\\) : 2004-1-30 14:47:59.5698192 : \\!\\({0.`, 1.`}\\) : 506 data points : 3 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y1\\\", HoldForm], \\*TagBox[\\\"y2\\\", HoldForm], \\*TagBox[\\\"y3\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y1 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -7.28764 8.67809 [\n[.21429 .51014 -9 -9 ]\n[.21429 .51014 9 0 ]\n[.40476 .51014 -9 -9 ]\n[.40476 .51014 9 0 ]\n[.59524 .51014 -9 -9 ]\n[.59524 .51014 9 0 ]\n[.78571 .51014 -9 -9 ]\n[.78571 .51014 9 0 ]\n[.97619 .51014 -3 -9 ]\n[.97619 .51014 3 0 ]\n[1.025 .52264 0 -6.28125 ]\n[1.025 .52264 10 6.28125 ]\n[.01131 .00195 -24 -4.5 ]\n[.01131 .00195 0 4.5 ]\n[.01131 .08873 -24 -4.5 ]\n[.01131 .08873 0 4.5 ]\n[.01131 .17551 -24 -4.5 ]\n[.01131 .17551 0 4.5 ]\n[.01131 .26229 -24 -4.5 ]\n[.01131 .26229 0 4.5 ]\n[.01131 .34907 -24 -4.5 ]\n[.01131 .34907 0 4.5 ]\n[.01131 .43585 -24 -4.5 ]\n[.01131 .43585 0 4.5 ]\n[.01131 .60942 -24 -4.5 ]\n[.01131 .60942 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .52264 m\n.21429 .52889 L\ns\n[(0.2)] .21429 .51014 0 1 Mshowa\n.40476 .52264 m\n.40476 .52889 L\ns\n[(0.4)] .40476 .51014 0 1 Mshowa\n.59524 .52264 m\n.59524 .52889 L\ns\n[(0.6)] .59524 .51014 0 1 Mshowa\n.78571 .52264 m\n.78571 .52889 L\ns\n[(0.8)] .78571 .51014 0 1 Mshowa\n.97619 .52264 m\n.97619 .52889 L\ns\n[(1)] .97619 .51014 0 1 Mshowa\n.125 Mabswid\n.07143 .52264 m\n.07143 .52639 L\ns\n.11905 .52264 m\n.11905 .52639 L\ns\n.16667 .52264 m\n.16667 .52639 L\ns\n.2619 .52264 m\n.2619 .52639 L\ns\n.30952 .52264 m\n.30952 .52639 L\ns\n.35714 .52264 m\n.35714 .52639 L\ns\n.45238 .52264 m\n.45238 .52639 L\ns\n.5 .52264 m\n.5 .52639 L\ns\n.54762 .52264 m\n.54762 .52639 L\ns\n.64286 .52264 m\n.64286 .52639 L\ns\n.69048 .52264 m\n.69048 .52639 L\ns\n.7381 .52264 m\n.7381 .52639 L\ns\n.83333 .52264 m\n.83333 .52639 L\ns\n.88095 .52264 m\n.88095 .52639 L\ns\n.92857 .52264 m\n.92857 .52639 L\ns\n.25 Mabswid\n0 .52264 m\n1 .52264 L\ns\ngsave\n1.025 .52264 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .00195 m\n.03006 .00195 L\ns\n[(0.84)] .01131 .00195 1 0 Mshowa\n.02381 .08873 m\n.03006 .08873 L\ns\n[(0.85)] .01131 .08873 1 0 Mshowa\n.02381 .17551 m\n.03006 .17551 L\ns\n[(0.86)] .01131 .17551 1 0 Mshowa\n.02381 .26229 m\n.03006 .26229 L\ns\n[(0.87)] .01131 .26229 1 0 Mshowa\n.02381 .34907 m\n.03006 .34907 L\ns\n[(0.88)] .01131 .34907 1 0 Mshowa\n.02381 .43585 m\n.03006 .43585 L\ns\n[(0.89)] .01131 .43585 1 0 Mshowa\n.02381 .60942 m\n.03006 .60942 L\ns\n[(0.91)] .01131 .60942 1 0 Mshowa\n.125 Mabswid\n.02381 .01931 m\n.02756 .01931 L\ns\n.02381 .03666 m\n.02756 .03666 L\ns\n.02381 .05402 m\n.02756 .05402 L\ns\n.02381 .07137 m\n.02756 .07137 L\ns\n.02381 .10609 m\n.02756 .10609 L\ns\n.02381 .12344 m\n.02756 .12344 L\ns\n.02381 .1408 m\n.02756 .1408 L\ns\n.02381 .15816 m\n.02756 .15816 L\ns\n.02381 .19287 m\n.02756 .19287 L\ns\n.02381 .21022 m\n.02756 .21022 L\ns\n.02381 .22758 m\n.02756 .22758 L\ns\n.02381 .24494 m\n.02756 .24494 L\ns\n.02381 .27965 m\n.02756 .27965 L\ns\n.02381 .297 m\n.02756 .297 L\ns\n.02381 .31436 m\n.02756 .31436 L\ns\n.02381 .33172 m\n.02756 .33172 L\ns\n.02381 .36643 m\n.02756 .36643 L\ns\n.02381 .38379 m\n.02756 .38379 L\ns\n.02381 .40114 m\n.02756 .40114 L\ns\n.02381 .4185 m\n.02756 .4185 L\ns\n.02381 .45321 m\n.02756 .45321 L\ns\n.02381 .47057 m\n.02756 .47057 L\ns\n.02381 .48792 m\n.02756 .48792 L\ns\n.02381 .50528 m\n.02756 .50528 L\ns\n.02381 .53999 m\n.02756 .53999 L\ns\n.02381 .55735 m\n.02756 .55735 L\ns\n.02381 .5747 m\n.02756 .5747 L\ns\n.02381 .59206 m\n.02756 .59206 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.78982 .60332 L\n.78982 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\nMistroke\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\nMistroke\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@002@3IfMT2000000@0fMWI0P0000040=WIf@8000001@3IfMT300000?l0fMWI0P3IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000050=WIf@030000003IfMT0\nfMWI0?l0fMWI0@3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00\n00020=WIf@D000000P3IfMT300000?`0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI0P00\n00030=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0o03IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0000000<0\nfMWI00<000000=WIf@3IfMT0o03IfMT000T0fMWI0P00000:0=WIf@8000001@3IfMT2000000<0fMWI\nC`000?n`0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<00000\n0=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WI\nf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3I\nfMT0[P3IfMT00240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003I\nfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT0\n0`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI\n0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI\n0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0\n003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^\n0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3I\nfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000\no`3IfMT0fMWI0:h0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000040=WIf@800000103I\nfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI00080=WIf@040000003IfMT0\nfMWI000000P0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000030=WIf@03\n0000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@0000050=WIf@040000003IfMT0fMWI0=WIf@<00000B`3IfMT0\n0`000?l0fMWI0=WIf@2^0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@800000103IfMT2\n000000@0fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@00203IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT00`3I\nfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI00090=WIf@8000002P3IfMT2\n000000@0fMWI0`0000030=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT0\n0240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0\nfMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI\n0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q\n0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WI\nf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3I\nfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3I\nfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT0\n0`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI\n0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI\n0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0\n003o0=WIf@3IfMT0[P3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000<0fMWI0`000004\n0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI\n00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@00203IfMT010000000fMWI0=WI\nf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT30000\n04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT20000\n00<0fMWI0`0000040=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0\nfMWI00<0fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@002@3IfMT20000\n00X0fMWI0P0000040=WIf@<000000`3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI\n0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI\n0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0\n003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^\n0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3I\nfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000\no`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3I\nfMT00240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI\n04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0\nfMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI\n000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;\n0=WIf@030000o`3IfMT0fMWI0:h0fMWI00090=WIf@800000103IfMT2000000@0fMWI0P0000050=WI\nf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WI\nf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<00000\n0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI00080=WI\nf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@020=WIf@<00000B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@00203IfMT010000000fMWI0=WIf@00\n00090=WIf@8000001P3IfMT01@000000fMWI0=WIf@3IfMT0000004d0fMWI00<0003o0=WIf@3IfMT0\n[P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@04\n0000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WI\nf@002@3IfMT2000000X0fMWI0P0000030=WIf@@000000`3IfMT00`000000fMWI0=WIf@1;0=WIf@03\n0000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0\n[P3IfMT00240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0\nfMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`00\n0?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0\nfMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WI\nf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o\n0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WI\nf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0\nB`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3I\nfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT0\n0240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0\nfMWI00<0003o0=WIf@3IfMT0[P3IfMT000T0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI\n0P0000040=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0000\n00<0fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@00203IfMT010000000\nfMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3I\nfMT3000004/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3I\nfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3I\nfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000020=WIf@040000\n003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@00\n2@3IfMT2000000X0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@1;0=WIf@030000\no`3IfMT0fMWI0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI\n04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0\nfMWI0=WIf@2^0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;\n0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WI\nf@3IfMT0[P3IfMT00240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000\n003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3I\nfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0\nfMWI0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000\nfMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI00090=WIf@800000103IfMT2000000@0fMWI\n0P0000030=WIf@<00000103IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI\n00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@<000000`3IfMT30000\n04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT20000\n00<0fMWI00@000000=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0\nfMWI0:h0fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000000P3I\nfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0\n[P3IfMT000T0fMWI0P00000:0=WIf@800000103IfMT3000000<0fMWI00<000000=WIf@3IfMT0B`3I\nfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT0\n0240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000\nfMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI\n00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WI\nf@2^0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WI\nf@3IfMT08`3IfMT2000000@0fMWI0P0000030=WIf@@000006@3IfMT00`000?l0fMWI0=WIf@020=WI\nf@800000103IfMT2000000D0fMWI0`00000M0=WIf@800000103IfMT2000000<0fMWI0`00000O0=WI\nf@800000103IfMT2000000@0fMWI0P00000T0=WIf@D000006`3IfMT00240fMWI00<000000=WIf@3I\nfMT08P3IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI01X0fMWI00D0003o0=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT06`3IfMT0\n10000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@00000U0=WIf@030000003IfMT0fMWI01/0fMWI000Q0=WIf@03\n0000003IfMT0fMWI0280fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0I0=WI\nf@050000o`3IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@060=WIf@D00000703IfMT0\n10000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001d0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@00000U0=WIf@030000003IfMT0fMWI01/0fMWI000Q0=WIf@80\n00008`3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01P0fMWI00D0003o0=WI\nf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI00H0fMWI00@000000=WIf@3IfMT000007@3I\nfMT010000000fMWI0=WIf@0000080=WIf@<000007P3IfMT010000000fMWI0=WIf@0000090=WIf@80\n00009P3IfMT00`000000fMWI0=WIf@0K0=WIf@008@3IfMT00`000000fMWI0=WIf@0R0=WIf@040000\n003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000006@3IfMT01@000?l0fMWI0=WIf@3IfMT0\n00000080fMWI00<000000=WIf@3IfMT01`3IfMT00`000000fMWI0000000M0=WIf@040000003IfMT0\nfMWI000000T0fMWI00<000000=WIf@3IfMT07@3IfMT010000000fMWI0=WIf@0000080=WIf@040000\n003IfMT0fMWI000002D0fMWI00<000000=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT0\n8`3IfMT2000000X0fMWI0P00000J0=WIf@030000o`3IfMT0fMWI0080fMWI0P00000;0=WIf@800000\n7P3IfMT2000000X0fMWI0`00000N0=WIf@8000002P3IfMT2000002D0fMWI0P00000M0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@800000C03IfMT0\n0`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI\n0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0W`3IfMT2000000d0\nfMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0WP3IfMT010000000fMWI\n0=WIf@00000<0=WIf@00703IfMUC000000030000o`000000000009L000001`3IfMT00`000000fMWI\n0=WIf@0=0=WIf@008@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@070=WIf@030000o`000000fMWI00T0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT02P3IfMT5000000`0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o\n0=WIf@3IfMT0WP3IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WI\nf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003I\nfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT0B`3IfMT0\n0`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT2000004`0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240\nfMWI00<000000=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI\n0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WIf@030000003IfMT0fMWI04/0fMWI00<0\n003o0=WIf@3IfMT0[P3IfMT00240fMWI0P00001<0=WIf@030000o`3IfMT0fMWI0:h0fMWI000Q0=WI\nf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3I\nfMT0B`3IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT00`000000fMWI0=WIf@1;0=WIf@030000\no`3IfMT0fMWI0:h0fMWI000Q0=WIf@800000C03IfMT00`000?l0fMWI0=WIf@2^0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI0:h0fMWI00090=WIf@800000103IfMT20000\n00<0fMWI0`0000030=WIf@D000000P3IfMT00`000000fMWI0=WIf@1;0=WIf@030000o`3IfMT0fMWI\n06@0fMWI00<0003o0=WIf@3IfMT0A`3IfMT000P0fMWI00@000000=WIf@3IfMT000002P3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0B`3IfMVD0000\noad0fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI0`0000040=WIf@030000003IfMT0fMWI\n0080fMWI0`00003l0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI\n000000@0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3l0=WIf@00203IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00P3I\nfMT00`000000fMWI0=WIf@3l0=WIf@002@3IfMT2000000X0fMWI0`0000030=WIf@800000o`3IfMT4\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@008P3IfMT2\n000000`0fMWI0P0000080=WIf@800000i03IfMT002<0fMWI00<000000=WIf@3IfMT02P3IfMT00`00\n0000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>80fMWI000T0=WIf@040000003IfMT0fMWI0=WI\nf@D000000`3IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3R0=WI\nf@008`3IfMT00`000000fMWI000000040=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3I\nfMT0fMWI000000020=WIf@050000003IfMT0fMWI0=WIf@000000i03IfMT001H0fMWI20000?l40=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3I\nfMT0000000H0fMWI00<000000=WIf@3IfMT0hP3IfMT00240fMWI0`0000000`3IfMT0000000000003\n0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0\nfMWI0>80fMWI000Z0=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI00000006\n0=WIf@030000003IfMT0fMWI0>80fMWI000Y0=WIf@8000001@3IfMT2000000P0fMWI0P00003T0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.151224`, 0.83126`, 0.00445466`, 0.000488879`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( y3 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -2.21735 0.284649 [\n[.21429 .04734 -9 -9 ]\n[.21429 .04734 9 0 ]\n[.40476 .04734 -9 -9 ]\n[.40476 .04734 9 0 ]\n[.59524 .04734 -9 -9 ]\n[.59524 .04734 9 0 ]\n[.78571 .04734 -9 -9 ]\n[.78571 .04734 9 0 ]\n[.97619 .04734 -3 -9 ]\n[.97619 .04734 3 0 ]\n[1.025 .05984 0 -6.28125 ]\n[1.025 .05984 10 6.28125 ]\n[.01131 .20216 -18 -4.5 ]\n[.01131 .20216 0 4.5 ]\n[.01131 .34449 -6 -4.5 ]\n[.01131 .34449 0 4.5 ]\n[.01131 .48681 -18 -4.5 ]\n[.01131 .48681 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .05984 m\n.21429 .06609 L\ns\n[(0.2)] .21429 .04734 0 1 Mshowa\n.40476 .05984 m\n.40476 .06609 L\ns\n[(0.4)] .40476 .04734 0 1 Mshowa\n.59524 .05984 m\n.59524 .06609 L\ns\n[(0.6)] .59524 .04734 0 1 Mshowa\n.78571 .05984 m\n.78571 .06609 L\ns\n[(0.8)] .78571 .04734 0 1 Mshowa\n.97619 .05984 m\n.97619 .06609 L\ns\n[(1)] .97619 .04734 0 1 Mshowa\n.125 Mabswid\n.07143 .05984 m\n.07143 .06359 L\ns\n.11905 .05984 m\n.11905 .06359 L\ns\n.16667 .05984 m\n.16667 .06359 L\ns\n.2619 .05984 m\n.2619 .06359 L\ns\n.30952 .05984 m\n.30952 .06359 L\ns\n.35714 .05984 m\n.35714 .06359 L\ns\n.45238 .05984 m\n.45238 .06359 L\ns\n.5 .05984 m\n.5 .06359 L\ns\n.54762 .05984 m\n.54762 .06359 L\ns\n.64286 .05984 m\n.64286 .06359 L\ns\n.69048 .05984 m\n.69048 .06359 L\ns\n.7381 .05984 m\n.7381 .06359 L\ns\n.83333 .05984 m\n.83333 .06359 L\ns\n.88095 .05984 m\n.88095 .06359 L\ns\n.92857 .05984 m\n.92857 .06359 L\ns\n.25 Mabswid\n0 .05984 m\n1 .05984 L\ns\ngsave\n1.025 .05984 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .20216 m\n.03006 .20216 L\ns\n[(8.5)] .01131 .20216 1 0 Mshowa\n.02381 .34449 m\n.03006 .34449 L\ns\n[(9)] .01131 .34449 1 0 Mshowa\n.02381 .48681 m\n.03006 .48681 L\ns\n[(9.5)] .01131 .48681 1 0 Mshowa\n.125 Mabswid\n.02381 .0883 m\n.02756 .0883 L\ns\n.02381 .11677 m\n.02756 .11677 L\ns\n.02381 .14523 m\n.02756 .14523 L\ns\n.02381 .1737 m\n.02756 .1737 L\ns\n.02381 .23063 m\n.02756 .23063 L\ns\n.02381 .25909 m\n.02756 .25909 L\ns\n.02381 .28756 m\n.02756 .28756 L\ns\n.02381 .31602 m\n.02756 .31602 L\ns\n.02381 .37295 m\n.02756 .37295 L\ns\n.02381 .40142 m\n.02756 .40142 L\ns\n.02381 .42988 m\n.02756 .42988 L\ns\n.02381 .45835 m\n.02756 .45835 L\ns\n.02381 .03138 m\n.02756 .03138 L\ns\n.02381 .00291 m\n.02756 .00291 L\ns\n.02381 .51528 m\n.02756 .51528 L\ns\n.02381 .54374 m\n.02756 .54374 L\ns\n.02381 .57221 m\n.02756 .57221 L\ns\n.02381 .60067 m\n.02756 .60067 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.78982 .60332 L\n.78982 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\nMistroke\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\nMistroke\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y3) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@0T0=WIf@800000\n103IfMT2000000<0fMWI1000000O0=WIf@800000103IfMT2000000D0fMWI0`00000N0=WIf@800000\n103IfMT2000000<0fMWI0`00000P0=WIf@800000103IfMT2000000@0fMWI0P00000U0=WIf@D00000\n6`3IfMT001`0fMWID0000?l40=WIf@040000003IfMT0fMWI000000/0fMWI00<000000=WIf@3IfMT0\n703IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@00000V0=WIf@030000003IfMT0fMWI01/0fMWI000L\n0=WIf@030000003IfMT0fMWI02<0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WI\nf@0I0=WIf@030000o`3IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000203IfMT5000001d0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0S0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0603I\nfMT00`000?l0fMWI0=WIf@020=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0\n00007P3IfMT010000000fMWI0=WIf@0000080=WIf@<000007`3IfMT010000000fMWI0=WIf@000009\n0=WIf@8000009`3IfMT00`000000fMWI0=WIf@0K0=WIf@00703IfMT00`000000fMWI0=WIf@0S0=WI\nf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000006@3IfMT00`000?l0fMWI0=WI\nf@020=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@0000007P3IfMT010000000fMWI\n0=WIf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3IfMT00000203IfMT01000\n0000fMWI0=WIf@00000V0=WIf@030000003IfMT0fMWI01/0fMWI000L0=WIf@030000003IfMT0fMWI\n02@0fMWI0P00000:0=WIf@8000006P3IfMT00`000?l0fMWI0=WIf@030=WIf@8000002`3IfMT20000\n01l0fMWI0P00000:0=WIf@<000007`3IfMT2000000X0fMWI0P00000V0=WIf@8000007@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0:<0fMWI0P00000=0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0:80fMWI00@000000=WIf@3I\nfMT00000303IfMT001H0fMWIE@0000000`000?l000000000002J000000P0fMWI00<000000=WIf@3I\nfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0N0=WIf@030000\no`3IfMT0fMWI00X0fMWI00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000\n003IfMT0fMWI02/0fMWI00<000000=WIf@3IfMT02P3IfMT5000000`0fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0XP3IfMT00`000000fMWI0=WIf@0=0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0\nfMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WI\nf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3I\nfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80\nfMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<\n0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000T0fMWI0P0000040=WIf@800000103I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@00000;0=WIf@030000\n003IfMT0fMWI0080fMWI0P00001=0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@8000002P3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000X0fMWI0`0000040=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80\nfMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<\n0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00503IfMT3000000D0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@005P3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001D0fMWI0`0000040=WIf@800000C@3IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00503IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001@0fMWI00@000000=WIf@3IfMT00000103IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000E0=WIf@<00000103IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0\nfMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@03\n0000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0\n/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0\nfMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WI\nf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3I\nfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00203IfMT3000000@0fMWI0P0000040=WIf@8000001@3IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000:0=WIf@030000003IfMT0fMWI00L0fMWI\n00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80\nfMWI00090=WIf@<000002`3IfMT00`000000fMWI0=WIf@020=WIf@800000C@3IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI\n00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n00090=WIf@<000002@3IfMT3000000@0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0\nfMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@03\n0000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0\n/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0\nfMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WI\nf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3I\nfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@1W0=WIf@030000\no`3IfMT0fMWI04P0fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWIV0000?lM0=WIf@00703IfMT0\n0`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008P3IfMT2000000`0fMWI0P0000080=WIf@800000i03IfMT002<0fMWI\n00<000000=WIf@3IfMT02P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>80fMWI\n000T0=WIf@030000003IfMT0fMWI0080fMWI0P0000050=WIf@030000003IfMT0fMWI0080fMWI0P00\n00040=WIf@030000003IfMT0fMWI0>80fMWI000S0=WIf@030000003IfMT000000080fMWI00@00000\n0=WIf@3IfMT00000103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0\nfMWI0000003T0=WIf@005P3IfMT80000o`@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000\nfMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R0=WI\nf@008@3IfMT3000000030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000\nfMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0hP3IfMT002P0fMWI00@000000=WIf@3IfMT0\n0000103IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0hP3IfMT002T0\nfMWI0P0000050=WIf@800000203IfMT200000>@0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000\n"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, 7.57455`, 0.00434554`, 0.0145393`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["WhenStat", "Section"], Cell[TextData[List["The order between the statements in the body of the ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statement is of cuorce significant. If you would put the assignment to ", StyleBox["y3", Rule[FontFamily, "Courier"]], " before the assignment of ", StyleBox["y1", Rule[FontFamily, "Courier"]], " you would get a different result and thus a different model behavior.\n"]], "Text"], Cell[TextData[List["class WhenStat3\n  Real x(start = 1);\n  Real y1;\n  Real y2;\n  Real y3;\n  \nalgorithm\n  ", StyleBox["when x > 2 then\n    y1 := sin(x);\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \nequation \n  y2 = sin(y1);\n  \nalgorithm\n ", StyleBox[" when x > 2 then\n    y3 := 2*x + pre(y1) + y2;  \n  end when;  \n  \nequation\n  der(x) = 2*x; \n  ", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend WhenStat3;    "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenStat3", "Section"], Cell["simulate( WhenStat3 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenStat3\\) : 2004-1-30 14:48:10.3353064 : \\!\\({0.`, 1.`}\\) : 504 data points : 2 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"x\\\", HoldForm], \\*TagBox[\\\"y1\\\", HoldForm], \\*TagBox[\\\"y2\\\", HoldForm], \\*TagBox[\\\"y3\\\", HoldForm], \\*TagBox[SuperscriptBox[\\\"x\\\", \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( y1 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.0147151 0.647317 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .14418 -18 -4.5 ]\n[.01131 .14418 0 4.5 ]\n[.01131 .27364 -18 -4.5 ]\n[.01131 .27364 0 4.5 ]\n[.01131 .40311 -18 -4.5 ]\n[.01131 .40311 0 4.5 ]\n[.01131 .53257 -18 -4.5 ]\n[.01131 .53257 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .14418 m\n.03006 .14418 L\ns\n[(0.2)] .01131 .14418 1 0 Mshowa\n.02381 .27364 m\n.03006 .27364 L\ns\n[(0.4)] .01131 .27364 1 0 Mshowa\n.02381 .40311 m\n.03006 .40311 L\ns\n[(0.6)] .01131 .40311 1 0 Mshowa\n.02381 .53257 m\n.03006 .53257 L\ns\n[(0.8)] .01131 .53257 1 0 Mshowa\n.125 Mabswid\n.02381 .04708 m\n.02756 .04708 L\ns\n.02381 .07945 m\n.02756 .07945 L\ns\n.02381 .11181 m\n.02756 .11181 L\ns\n.02381 .17654 m\n.02756 .17654 L\ns\n.02381 .20891 m\n.02756 .20891 L\ns\n.02381 .24128 m\n.02756 .24128 L\ns\n.02381 .30601 m\n.02756 .30601 L\ns\n.02381 .33837 m\n.02756 .33837 L\ns\n.02381 .37074 m\n.02756 .37074 L\ns\n.02381 .43547 m\n.02756 .43547 L\ns\n.02381 .46784 m\n.02756 .46784 L\ns\n.02381 .5002 m\n.02756 .5002 L\ns\n.02381 .56493 m\n.02756 .56493 L\ns\n.02381 .5973 m\n.02756 .5973 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\nMistroke\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00@`3IfMT2000000@0fMWI0P0000030=WIf@@000007`3IfMT2000000@0\nfMWI0P0000050=WIf@<000007P3IfMT2000000@0fMWI0P0000030=WIf@<00000803IfMT2000000@0\nfMWI0P0000040=WIf@8000009@3IfMT5000001/0fMWI00120=WIf@040000003IfMT0fMWI000000P0\nfMWI00<000000=WIf@3IfMT07`3IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI\n01`0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003I\nfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00\n@P3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI01h0fMWI00@000000=WIf@3I\nfMT00000203IfMT5000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00\n000N0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000009P3IfMT00`000000\nfMWI0=WIf@0K0=WIf@00@P3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01d0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0\nfMWI000000P0fMWI0`00000O0=WIf@040000003IfMT0fMWI000000T0fMWI0P00000W0=WIf@030000\n003IfMT0fMWI01/0fMWI00120=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0\n00007P3IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000001h0fMWI00@000000=WI\nf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT000009P3IfMT00`000000fMWI0=WIf@0K0=WIf@00@`3IfMT2000000X0fMWI0P00\n000P0=WIf@8000002`3IfMT2000001l0fMWI0P00000:0=WIf@<000007`3IfMT2000000X0fMWI0P00\n000V0=WIf@8000007@3IfMT00?l0fMWI8@3IfMT001`0fMWI00<000000=WIf@3IfMT0o`3IfMT20=WI\nf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?80fMWI\n0P00000=0=WIf@00703IfMT00`000000fMWI0=WIf@3a0=WIf@040000003IfMT0fMWI000000`0fMWI\n000F0=WIf@H00000D0000?nL000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l000000=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<00000\n0=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<00000\n0=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0fMWI1@00000<\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0:80fMWI00<000000=WI\nf@3IfMT03@3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@800000103IfMT2000000<0fMWI\n100000040=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@0\n00000=WIf@3IfMT00000203IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI\n0=WIf@040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WI\nf@00000:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000@0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000X0fMWI\n0P0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<\n0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00\n703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000@0fMWI0P0000050=WIf@<000000`3I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0\nfMWI000000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI1@0000030=WIf@800000C@3I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203I\nfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@002@3IfMT2000000/0fMWI0P0000040=WIf@030000003I\nfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT0\n0`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI\n0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o\n0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WI\nf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000\n003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0\nfMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0\nfMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI\n0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WI\nf@800000103IfMT2000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WI\nf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@000004\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00203IfMT010000000fMWI0=WIf@0000080=WIf@<000001@3IfMT00`000000fMWI0=WI\nf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000T0fMWI00<0\n00000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI0009\n0=WIf@8000002P3IfMT3000000@0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b\n0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@03\n0000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0\nC03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI\n00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WI\nf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WI\nf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3I\nfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000\no`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0\nfMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI\n0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L\n0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@03\n0000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0\n/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@800000103IfMT20000\n00@0fMWI0P0000050=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0\nfMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT000P0fMWI00@000000=WIf@3IfMT00000203IfMT0\n10000000fMWI0=WIf@0000040=WIf@800000C@3IfMT00`000?l0fMWI0=WIf@2b0=WIf@00203IfMT0\n10000000fMWI0=WIf@0000090=WIf@8000001@3IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3I\nfMT0fMWI0;80fMWI00080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n103IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI00090=WIf@8000002P3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI\n04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0\nfMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI\n000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WI\nf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0fMWI04`0fMWI00<0003o0=WIf@3I\nfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`000?l0fMWI0=WIf@2b0=WIf@00703I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80fMWI000L0=WIf@030000003IfMT0\nfMWI04`0fMWI00<0003o0=WIf@3IfMT0/P3IfMT001`0fMWI00<000000=WIf@3IfMT0C03IfMT00`00\n0?l0fMWI0=WIf@2b0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0;80\nfMWI000L0=WIf@030000003IfMT0fMWI04`0fMWIV0000?lM0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000R0=WIf@800000303IfMT2000000P0\nfMWI0P00003T0=WIf@008`3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT0hP3IfMT002@0fMWI00@000000=WIf@3IfMT0fMWI1@0000030=WIf@030000\n003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0fMWI0>80fMWI000S0=WIf@030000003I\nfMT0000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00D000000=WIf@3IfMT0fMWI0000003T0=WIf@005P3IfMT80000o`@0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@3R0=WIf@008@3IfMT3000000030=WIf@000000000000<0fMWI00<000000=WIf@3I\nfMT00`3IfMT00`000000fMWI0=WIf@05000000<0fMWI00<000000=WIf@3IfMT0hP3IfMT002X0fMWI\n00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3I\nfMT0hP3IfMT002T0fMWI0P0000050=WIf@800000203IfMT200000>@0fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, -0.144427`, 0.00434554`, 0.00639348`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell["plot( y3 );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.0147151 0.122906 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .13762 -6 -4.5 ]\n[.01131 .13762 0 4.5 ]\n[.01131 .26053 -6 -4.5 ]\n[.01131 .26053 0 4.5 ]\n[.01131 .38343 -6 -4.5 ]\n[.01131 .38343 0 4.5 ]\n[.01131 .50634 -6 -4.5 ]\n[.01131 .50634 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .13762 m\n.03006 .13762 L\ns\n[(1)] .01131 .13762 1 0 Mshowa\n.02381 .26053 m\n.03006 .26053 L\ns\n[(2)] .01131 .26053 1 0 Mshowa\n.02381 .38343 m\n.03006 .38343 L\ns\n[(3)] .01131 .38343 1 0 Mshowa\n.02381 .50634 m\n.03006 .50634 L\ns\n[(4)] .01131 .50634 1 0 Mshowa\n.125 Mabswid\n.02381 .0393 m\n.02756 .0393 L\ns\n.02381 .06388 m\n.02756 .06388 L\ns\n.02381 .08846 m\n.02756 .08846 L\ns\n.02381 .11304 m\n.02756 .11304 L\ns\n.02381 .1622 m\n.02756 .1622 L\ns\n.02381 .18678 m\n.02756 .18678 L\ns\n.02381 .21136 m\n.02756 .21136 L\ns\n.02381 .23595 m\n.02756 .23595 L\ns\n.02381 .28511 m\n.02756 .28511 L\ns\n.02381 .30969 m\n.02756 .30969 L\ns\n.02381 .33427 m\n.02756 .33427 L\ns\n.02381 .35885 m\n.02756 .35885 L\ns\n.02381 .40801 m\n.02756 .40801 L\ns\n.02381 .43259 m\n.02756 .43259 L\ns\n.02381 .45718 m\n.02756 .45718 L\ns\n.02381 .48176 m\n.02756 .48176 L\ns\n.02381 .53092 m\n.02756 .53092 L\ns\n.02381 .5555 m\n.02756 .5555 L\ns\n.02381 .58008 m\n.02756 .58008 L\ns\n.02381 .60466 m\n.02756 .60466 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35366 .01472 L\n.35366 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\nMistroke\n.40095 .60332 L\n.40286 .60332 L\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\nMistroke\n.49619 .60332 L\n.4981 .60332 L\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\nMistroke\n.59143 .60332 L\n.59333 .60332 L\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\nMistroke\n.68667 .60332 L\n.68857 .60332 L\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\nMistroke\n.7819 .60332 L\n.78381 .60332 L\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\nMistroke\n.87714 .60332 L\n.87905 .60332 L\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\nMistroke\n.97238 .60332 L\n.97429 .60332 L\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(y3) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n75.000 12.813 moveto\n(@) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n87.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00>@3IfMT2000000@0fMWI0P0000030=WIf@@00000\n8@3IfMT2000000@0fMWI0P0000050=WIf@<000008@3IfMT2000000@0fMWI0P0000030=WIf@<00000\n8P3IfMT2000000@0fMWI0P0000040=WIf@8000009`3IfMT5000001`0fMWI000h0=WIf@040000003I\nfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT08@3IfMT010000000fMWI0=WIf@00000;0=WIf@03\n0000003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000P\n0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI\n0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI0200fMWI\n00@000000=WIf@3IfMT00000203IfMT500000200fMWI00@000000=WIf@3IfMT00000203IfMT01000\n0000fMWI0=WIf@00000P0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000Q0=WI\nf@040000003IfMT0fMWI000000P0fMWI0`00000Q0=WIf@040000003IfMT0fMWI000000T0fMWI0P00\n000Y0=WIf@030000003IfMT0fMWI01`0fMWI000h0=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT00000803IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT000000240\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0P0=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>@3IfMT2\n000000X0fMWI0P00000R0=WIf@8000002`3IfMT200000280fMWI0P00000:0=WIf@<000008@3IfMT2\n000000X0fMWI0P00000X0=WIf@8000007P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00100fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@\n0=WIf@030000003IfMT0fMWI0?h0fMWI0P00000=0=WIf@002P3IfMT6000005@0003oY00000080=WI\nf@040000003IfMT0fMWI000000`0fMWI000@0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0000\n003IfMT02P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WI\nf@3IfMT02@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00d0fMWI000@0=WIf@03\n0000003IfMT0fMWI02d0fMWI00<000000=WIf@3IfMT0803IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000003IfMT0fMWI02h0fMWI00<000000=WIf@3IfMT0;@3IfMT00`000000fMWI0=WIf@0]0=WIf@03\n0000003IfMT0fMWI00/0fMWI1@00000<0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0:X0fMWI00<000000=WIf@3IfMT03@3IfMT00100fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT200000540fMWI00<0003o0=WIf@3IfMT0\n^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI\n0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00\n403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003I\nfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@D000000`3IfMT00`000000fMWI0=WI\nf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000:0=WIf@030000003IfMT0fMWI00<0fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WI\nf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@03\n0000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000X0fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00090=WIf@8000001@3I\nfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0\nfMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`00\n0?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WI\nf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o\n0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WI\nf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000\n003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3I\nfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT0\n0100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000\nfMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI\n00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WI\nf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@03\n0000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0\n^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`00\n0?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@@00000103IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@030000003IfMT0fMWI00D0fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002@3IfMT00`000000fMWI0=WIf@040=WIf@800000\nD@3IfMT00`000?l0fMWI0=WIf@2j0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000P0fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00090=WIf@8000001@3IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI\n0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00\n403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0\n003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3I\nfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`00\n0000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<00000\n0=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002@3IfMT2000000D0fMWI00<000000=WI\nf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000X0fMWI00<000000=WIf@3I\nfMT00`3IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT000/0fMWI00<000000=WIf@3IfMT0\n0P3IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002@3I\nfMT2000000D0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI\n0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00\n403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@800000D@3IfMT00`000?l0fMWI0=WI\nf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3I\nfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT20000\n0540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0\nfMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI\n000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000X0fMWI0`000003\n0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT000/0fMWI00<000000=WI\nf@3IfMT00P3IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00080=WIf@D0\n00000`3IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT000P0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI00090=WIf@030000\n003IfMT0000000@0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@002P3I\nfMT2000000@0fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT0\n0`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI\n0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0\nfMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<0\n00000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@\n0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WI\nf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00\n403IfMT200000540fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3IfMT0D03I\nfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000o`3IfMT0\nfMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100\nfMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI\n0=WIf@1@0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0\n003o0=WIf@3IfMT0^P3IfMT00100fMWI0P00001A0=WIf@030000o`3IfMT0fMWI0;X0fMWI000@0=WI\nf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3IfMT00100fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT00`000000fMWI0=WIf@1@0=WIf@030000\no`3IfMT0fMWI0;X0fMWI000@0=WIf@030000003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0^P3I\nfMT00100fMWI00<000000=WIf@3IfMT0D03IfMT00`000?l0fMWI0=WIf@2j0=WIf@00403IfMT20000\n0540fMWIW`000?lN0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000\n003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@008P3IfMT2000000`0fMWI0P0000080=WIf@800000i03IfMT002<0fMWI00<000000=WIf@3I\nfMT02P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>80fMWI000T0=WIf@030000\n003IfMT0fMWI0080fMWI0P0000050=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000\n003IfMT0fMWI0>80fMWI000S0=WIf@030000003IfMT000000080fMWI00@000000=WIf@3IfMT00000\n103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000003T0=WI\nf@005P3IfMT80000o`@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@030=WI\nf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3R0=WIf@008@3IfMT30000\n00030=WIf@000000000000@0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@050000\n00<0fMWI00<000000=WIf@3IfMT0hP3IfMT002P0fMWI00@000000=WIf@3IfMT00000103IfMT01@00\n0000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0hP3IfMT002T0fMWI0P0000050=WI\nf@800000203IfMT200000>@0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o\n0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0669834`, -0.612881`, 0.00414258`, 0.0321003`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]]], Open]], Cell[CellGroupData[List[Cell["Defining when-Statements by if-Statements", "Section"], Cell[TextData[List["A ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statement can be defined as a combination of the following:"]], "Text"], Cell[TextData[List["An ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement"]], "Itemize"], Cell["Boolean variables with appropriate start values", "Itemize"], Cell[TextData[List["Calls to the edge operator in the conditional expressions of the ", StyleBox["if", Rule[FontFamily, "Courier"]], "-statement"]], "Itemize"]], Open]], Cell[CellGroupData[List[Cell["Avoiding Multiple-Definition Conflicts for when-Statements", "Section"], Cell[TextData[List["Two ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements in different algorithm sections or two ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations may not define the same variable. Without this rule a conflict between the assignment will  occur if both conditions would become true at the same time instant.\n"]], "Text"], Cell[TextData[List["model DoubleWhenConflict\n  Boolean close;\t\t\t\t\t// Erroneous model: close defined by two equations\n  parameter Real x = 5;\nalgorithm\n  when x >= 5 then\n   ", StyleBox[" close := true;", Rule[FontColor, RGBColor[1, 0, 0]]], "\n  end when;\n\nalgorithm  \n  when x <= 5 then\n   ", StyleBox[" close := false;", Rule[FontColor, RGBColor[1, 0, 0]]], "\n  end when;\nend DoubleWhenConflict;      "]], "ModelicaInput"], Cell[CellGroupData[List[Cell["DoubleWhenSequential", "Subsection"], Cell[TextData[List["One possible way to resolve the conflict would be to put both ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements within the same algorithm section, as in the ", StyleBox["DoubleWhenSequential", Rule[FontFamily, "Courier"]], " model below. The sequential execution semantics of algorithm sections allow several assignments to the same variable. If there are several ", StyleBox["when", Rule[FontFamily, "Courier"]], "-statements with assignments active at the same time instant, they will be executed in sequential order and the result of the last assignment will prevail.\n\nHowever, this method is not recommended since the modeling style is less clear than the alternative method presented in the next section. Another disadvantage is the nondeclarative style of using ", StyleBox["when", Rule[FontFamily, "Courier"]], "-constructs by relying on multiple sequential assignments.\n"]], "Text"], Cell[TextData[List["model ", StyleBox["DoubleWhenSequential", Rule[FontFamily, "Courier"]], "\n  Boolean close;\t\t\t\t\t// Possible conflicting definitions resolved by\n  parameter Real time = 2;\t\t\t// sequential assignments in an algorithm section\nalgorithm\t\t\t\t\t\t\t\n ", StyleBox[" when time <= 2 then\n    close := true;\n  end when;\n\n  when time <= 2 then\n    close := false;\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ", StyleBox["DoubleWhenSequential", Rule[FontFamily, "Courier"]], ";      "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of DoubleWhenSequential", "Subsection"], Cell[TextData[List["simulate( ", StyleBox["DoubleWhenSequential", Rule[FontFamily, "Courier"]], " );"]], "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(DoubleWhenSequential\\) : 2004-1-30 14:48:20.8976712 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"close\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"Error\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["WhenPriority", "Subsection"], Cell[TextData[List["\nA more explicit and therefore better way to resolve the conflict would be to give one of the two event handlers higher priority, which is possible using the ", StyleBox["elsewhen", Rule[FontFamily, "Courier"]], " construct. Here it is well defined what happens if both conditions become true at the same time instant since the first condition (", StyleBox["x >= 5", Rule[FontFamily, "Courier"]], ") has higher priority than the second condition (", StyleBox["x <= 5", Rule[FontFamily, "Courier"]], ").\n"]], "Text"], Cell[TextData[List["model WhenPriority\n  Boolean close;\t\t\n  parameter Real x = 5;\nalgorithm\n  ", StyleBox["when x >= 5 then\n    close := true;\n  elsewhen x <= 5 then\n    close := false;\n  end when;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend WhenPriority;      "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WhenPriority", "Subsection"], Cell["simulate( WhenPriority );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WhenPriority\\) : 2004-1-30 14:48:31.5069104 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 4 variables>\\n\\!\\({\\*TagBox[\\\"close\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[896, 924]], Rule[WindowMargins, List[List[11, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]