List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Iteration Using while-Statements", "Title"], Cell[TextData[List["\nWhen using the for-loop for iteration you must be able to express the range of values over which the iteration variable should iterate in a ", StyleBox["closed", Rule[FontSlant, "Italic"]], " form such as an iteration expression. For cases where this is not feasible there is also a while-loop iteration construct in Modelica where the termination condition is just a Boolean expression and the range of iteration values need not be expressed in closed form as an expression. You need to declare the iteration variable separately, as well as handling the increment or decrement of this variable yourself. \n\nThe example class ", StyleBox["SumSeries", Rule[FontFamily, "Courier"]], " shows the while-loop construct used for summing a serries of exponential terms until the loop condition is violated (the terms become smaller than eps). In this case it would be quite impractical to use a for-loop. \n"]], "Text"], Cell[TextData[List["class SumSeries\n  parameter Real eps = 1.E-6;\n  Integer i;\n  Real sum;\n  Real delta;\nalgorithm\n  i := 1;\n  delta := exp(-0.01 * i);\n  ", StyleBox["while delta >= eps loop\n    sum := sum + delta;\n    i := i + 1;\n    delta := exp(-0.01 * i);\n  end while;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend SumSeries;    "]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of SumSeries", "Section"], Cell["simulate( SumSeries );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(SumSeries\\) : 2004-1-30 14:45:26.0098519 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"\[Delta]\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"eps\\\", HoldForm], \\*TagBox[\\\"i\\\", HoldForm], \\*TagBox[\\\"sum\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["{", RowBox[List[RowBox[List["sum", "[", "0", "]"]], ",", " ", RowBox[List["delta", "[", "0", "]"]]]], "}"]]], "Input"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[882, 924]], Rule[WindowMargins, List[List[159, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]