List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Function Annotations", "Title"], Cell[TextData[List["\nTwo rather special annotations are defined for functions. These are the function ", StyleBox["derivative", Rule[FontFamily, "Courier"]], " annotation and the ", StyleBox["arrayLayout", Rule[FontFamily, "Courier"]], " annotation. The function derivative annotation allows you to explicitly specify the computation of the derivatives of a function to any order, e.g. in order to gain performance and/or numerical accuracy. The external function annotation ", StyleBox["arrayLayout", Rule[FontFamily, "Courier"]], " can be used to explicitly give the layout of arrays"]], "Text"], Cell[CellGroupData[List[Cell["Function Derivative Annotations ", "Section"], Cell[TextData[List[StyleBox["function h0       \t\t\t\t\t// exp(x(t)+i1)\n  ", Rule[FontFamily, "Courier New"]], StyleBox["annotation(derivative=h1);", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\n  input  Integer i1;\n  input  Real    x;\n  input  Boolean linear;  \t\t\t// not used\n  output Real    y;\n algorithm\n  y := exp(x)+i1;\nend h0;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["function h1       \t\t\t\t\t// (d/dt)(exp(x(t))\n  annotation(derivative(order=2)=h2);\n  input  Integer i1;\n  input  Real    x;\n  input  Boolean linear;\n  input  Real    der_x;\n  output Real    der_y;\nalgorithm\n  der_y := exp(x)*der_x;\nend h1;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["function h2       \t\t\t\t\t// (d/dt)(exp(x(t)*der_x(t))\n  input  Integer i1;\n  input  Real    x;\n  input  Boolean linear;\n  input  Real    der_x;\n  input  Real    der_2_x;\n  output Real    der_2_y;\nalgorithm\n  der_2_y := exp(x)*der_x*der_x + exp(x)*der_2_x;\nend h1;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on h0, h1 and h2", "Section"], Cell[TextData[List["Since functions generated from MakeAlive functions need numerical values the ", StyleBox["exp", Rule[FontSlant, "Italic"]], " function in Modelica needs to be transformed to the equivalent ", StyleBox["Exp", Rule[FontSlant, "Italic"]], " function in ", StyleBox["Mathematica", Rule[FontSlant, "Italic"]], ". This is done by the pattern \"/.exp->Exp\", which means that all occurances of \"exp\" are replaced with \"Exp\". The \"//N\" transforms the expression to a numerical value and \"//First\" removes the array expression."]], "Text"], Cell[BoxData[RowBox[List["MakeAlive", "[", "h0", "]"]]], "Input"], Cell[BoxData[RowBox[List["fn0", "=", RowBox[List[RowBox[List[RowBox[List[RowBox[List["h0", "[", RowBox[List["2", ",", " ", "5", ",", "True"]], "]"]], "/.", RowBox[List["exp", "\[Rule]", "Exp"]]]], "//", "N"]], "//", "First"]]]]], "Input"], Cell[BoxData[RowBox[List["MakeAlive", "[", "h1", "]"]]], "Input"], Cell[BoxData[RowBox[List["fn1", "=", RowBox[List[RowBox[List[RowBox[List["h1", "[", RowBox[List["2", ",", " ", "5", ",", "True", ",", "fn0"]], "]"]], "/.", RowBox[List["exp", "\[Rule]", "Exp"]]]], "//", "First"]]]]], "Input"], Cell[BoxData[RowBox[List["MakeAlive", "[", "h2", "]"]]], "Input"], Cell[BoxData[RowBox[List["fn2", "=", RowBox[List[RowBox[List[RowBox[List["h2", "[", RowBox[List["2", ",", " ", "5", ",", "True", ",", "fn0", ",", "fn1"]], "]"]], "/.", RowBox[List["exp", "\[Rule]", "Exp"]]]], "//", "First"]]]]], "Input"], Cell[BoxData["xRange"], "Input"], Cell["The below expression makes a plot of the h0 function from x=4 to x=6:", "Text"], Cell[BoxData[RowBox[List[RowBox[List["ListPlot", "[", RowBox[List[RowBox[List["Transpose", "@", RowBox[List["{", RowBox[List[RowBox[List["Table", "[", RowBox[List["x", ",", RowBox[List["{", RowBox[List["x", ",", "4", ",", "6", ",", "0.1"]], "}"]]]], "]"]], ",", RowBox[List[RowBox[List["Table", "[", RowBox[List[RowBox[List[RowBox[List["h0", "[", RowBox[List["2", ",", "x", ",", "True"]], "]"]], "/.", RowBox[List["exp", "\[Rule]", "Exp"]]]], ",", " ", RowBox[List["{", RowBox[List["x", ",", "4", ",", "6", ",", "0.1"]], "}"]]]], "]"]], "//", "Flatten"]]]], "}"]]]], ",", RowBox[List["PlotJoined", "\[Rule]", "True"]]]], "]"]], ";"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["External Function Annotations", "Section"], Cell[TextData[List["Regarding specific annotations only for external function declarations there is an optional ", StyleBox["arrayLayout", Rule[FontFamily, "Courier New"]], " annotation, which can be either ", StyleBox["\"rowMajor\"", Rule[FontFamily, "Courier New"]], " or ", StyleBox["\"columnMajor\"", Rule[FontFamily, "Courier New"]], ". This annotation causes additional information to be passed to the compiler when necessary. It is only needed when the array storage layout deviates from the default for the external language. This is the case for the function ", StyleBox["joinThreeVectors2", Rule[FontFamily, "Courier"]], " below where the C function uses column-major array representation which is different from the default row-major layout that normally is used for C.\n"]], "Text"], Cell[TextData[List[StyleBox["function joinThreeVectors2  \t\t\"External C function with column-major arrays\"\n  input  Real v1[:],v2[:],v3[:];\n  output Real vres[size(v1,1)+size(v2,1)+size(v3,1)];\n external \"C\" join3vec(v1,v2,v3,vres,size(v1,1),size(v2,1),size(v3,1));\n         ", Rule[FontFamily, "Courier New"]], StyleBox["annotation(arrayLayout = \"columnMajor\");", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend joinThreeVectors2;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[912, 905]], Rule[WindowMargins, List[List[68, Automatic], List[Automatic, -40]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]