List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Graphical Annotations", "Title"], Cell[CellGroupData[List[Cell["Graphical Representation of Resistor ", "Section"], Cell[TextData[List["The example below shows the use of graphical attributes in the form of annotations to define the different parts of the ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " icon."]], "Text"], Cell[CellGroupData[List[Cell["Electrical units", "Subsection"], Cell["type Voltage \t\t\t\t= ElectricPotential;\ntype Current \t\t\t\t= ElectricCurrent;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Subsection"], Cell["connector Pin \t\t\t\t\t\"Pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend Pin;  \t\t\t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Resistor", "Subsection"], Cell[TextData[List["model Resistor\n  Pin p annotation(extent = [-110, -10, -90, 10], style(fillPattern = 1));\n  Pin n annotation(extent = [110, -10, 90, 10]);\n  parameter Real R\t\t\t\t\"Resistance in [Ohm]\";\nequation\n  R*p.i = p.v - n.v;\n  n.i = p.i;\npublic \n ", StyleBox[" annotation(Icon(\n    Rectangle(extent = [-70, -30, 70, 30], style(fillPattern = 1)),\n    Text(extent =[-100, 55; 100, 110], string = \"%name = %R\"),\n    Line(points = [-90, 0; -70, 0]),\n    Line(points = [70, 0; 90, 0])\n    ));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Resistor;        "]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Graphical Annotation Attributes", "Section"], Cell["There are a number of predefined graphical annotation attributes, which can be divided into basic attributes; built-in attributes to classes, instances, and connections; and attributes that are graphical elements to specify the appearance of class icons.", "Text"], Cell[CellGroupData[List[Cell["Basic Attributes", "Subsection"], Cell[TextData[List["The basic attribute classes are ", StyleBox["Point", Rule[FontFamily, "Courier"]], ", ", StyleBox["Extent", Rule[FontFamily, "Courier"]], ", and ", StyleBox["Style", Rule[FontFamily, "Courier"]], " with the corresponding attributes p", StyleBox["oint", Rule[FontFamily, "Courier"]], ", ", StyleBox["extent", Rule[FontFamily, "Courier"]], ", and ", StyleBox["style", Rule[FontFamily, "Courier"]], ". "]], "Text"], Cell["type Point = Real[2];\t\t// {x, y}", "ModelicaInput"], Cell["", "Text"], Cell["type Extent = Real[2, 2];\t// [x1, y1; x2, y2]", "ModelicaInput"], Cell["", "Text"], Cell["record Style\n  Integer color[3], fillColor[3];\t\t\t\t\t\t// RGB\n  Integer pattern, fillPattern, thickness, gradient,\t// ?Explanations ?\n  \t\t\tsmooth, arrow, textStyle;\n  String font;\t\t\t\nend Style;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Built-in Attributes to Classes, Instances and Connections", "Subsection"], Cell[TextData[List["\nThe annotation elements ", StyleBox["CoordinateSystem", Rule[FontFamily, "Courier"]], ", ", StyleBox["Placement", Rule[FontFamily, "Courier"]], ", and ", StyleBox["Route", Rule[FontFamily, "Courier"]], " below are by default associated with classes, instances, and connection equations respectively. This means that these elements including their attributes exist even if they are not mentioned explicitly in the annotations of these entities. The ", StyleBox["Route", Rule[FontFamily, "Courier"]], " annotation element also has alternative names such as ", StyleBox["Line", Rule[FontFamily, "Courier"]], " and ", StyleBox["Polygon", Rule[FontFamily, "Courier"]], " defined in the next section. \n"]], "Text"], Cell["record CoordinateSystem\t\t\t// Attribute to class\n  Extent extent;\n  Point grid;\n  Point size;\nend CoordinateSystem;", "ModelicaInput"], Cell["", "Text"], Cell["record Placement\t\t\t\t// Attribute for components\n  Extent extent;\n  Real rotation;\nend Placement;", "ModelicaInput"], Cell["", "Text"], Cell["record Route\t\t\t\t\t// Attribute for connect equations\n  Point points[:];\n  Style style;\n  String label;\nend Route;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Definitions of Graphical Elements", "Subsection"], Cell[TextData[List["The following predefined graphical elements are used as graphical annotation elements including annotation attributes when defining the appearance of class icons. The ", StyleBox["Line", Rule[FontFamily, "Courier"]], " graphical element can also be used for connection lines.", StyleBox["\n", Rule[FontWeight, "Bold"]]]], "Text"], Cell[TextData[StyleBox["record Line = Route;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["record Polygon = Route;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell["", "Text"], Cell["record GraphicItem\n  Extent extent;\n  Style style;\nend GraphicItem;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["record Rectangle = GraphicItem;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["record Ellipse = GraphicItem;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"], Cell["", "Text"], Cell["record Text\n  extends GraphicItem;\n  String string;\nend Text;", "ModelicaInput"], Cell["", "Text"], Cell["record BitMap\n  extends GraphicItem;\n  String URL;\t\t\t\t// Name of Bitmap file\nend BitMap;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Choices Annotations for Variables and Enumerations Types", "Subsection"], Cell[TextData[List["The choices annotation is applicable to both replaceable and nonreplaceable elements. For example, consider the following Integer type called ", StyleBox["KindOfController", Rule[FontFamily, "Courier"]], " used to represent a choice of controller in the modeling process. This choice is made from the following enumeration of three recommended alternatives:\n"]], "Text"], Cell[TextData[List[StyleBox["type KindOfController = Integer(min = 1,max = 3)\n  ", Rule[FontFamily, "Courier New"]], StyleBox[" annotation(choices(\n                choice = 1 \"P\",\n                choice = 2 \"PI\",\n", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["                choice = 3 \"PID\"));", Rule[FontColor, RGBColor[0, 0, 1]]]]], "ModelicaInput"], Cell[TextData[List["\nAssume that ", StyleBox["KindOfController", Rule[FontFamily, "Courier"]], " is used in a model A as below:\n"]], "Text"], Cell[TextData[List[StyleBox["model A\n  parameter KindOfController x;\n", Rule[FontFamily, "Courier New"]], "end A;"]], "ModelicaInput"], Cell[TextData[List["\nIf you interactively choose the third alternative from the menu this corresponds to giving the default value 3 for the instantiated variable ", StyleBox["x", Rule[FontFamily, "Courier"]], " in the following code for an instance ", StyleBox["a2", Rule[FontFamily, "Courier"]], " of the model ", StyleBox["A", Rule[FontFamily, "Courier"]], ":\n"]], "Text"], Cell["class AInst\nA a2(x=3 \"PID\");\nend AInst;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Choices Annotations for Replaceable Model Elements", "Subsection"], Cell["The choices annotation can also be used to generate menus with redeclaration alternatives for replaceable models. For example, consider the following replaceable model with a choices annotation:", "Text"]], Open]], Cell[CellGroupData[List[Cell["Resistor", "Subsection"], Cell["model Resistor\n  Pin p annotation(extent = [-110, -10, -90, 10], style(fillPattern = 1));\n  Pin n annotation(extent = [110, -10, 90, 10]);\n  parameter Real R\t\t\t\t\"Resistance in [Ohm]\";\nequation\n  R*p.i = p.v - n.v;\n  n.i = p.i;\npublic \n  annotation(Icon(\n    Rectangle(extent = [-70, -30, 70, 30], style(fillPattern = 1)),\n    Text(extent =[-100, 55; 100, 110], string = \"%name = %R\"),\n    Line(points = [-90, 0; -70, 0]),\n    Line(points = [70, 0; 90, 0])\n    ));\nend Resistor;        ", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["MyResistor", "Subsection"], Cell[TextData[List["class ResistorAnnotation\nreplaceable model MyResistor = Resistor\n ", StyleBox[" annotation(choices(\n  \t\tchoice(redeclare model MyResistor = lib2.Resistor \"Resistor 1\"),\n  \t\tchoice(redeclare model MyResistor = lib2.Resistor2 \"Resistor 2\")));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ResistorAnnotation;  \t\t"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MyCircuit", "Subsection"], Cell[TextData[List["If the user would choose the first alternative, the following code might be produced if ", StyleBox["MyResistor", Rule[FontFamily, "Courier"]], " is part of the class ", StyleBox["MyCircuit", Rule[FontFamily, "Courier"]], " and the chosen name of the instantiated component is ", StyleBox["x", Rule[FontFamily, "Courier"]], ":"]], "Text"], Cell["model MyCircuit\n\n  model MyResistorModel\n    extends Electrical.Interfaces.ResistorModel;\n      // declarations and equations\n  end MyResistorModel;\n  \n  encapsulated package MyComponents =\n  \t\tElectrical.Components (redeclare model ResistorModel = MyResistorModel);\n  \n  MyComponents.Transformer tr1;\n  MyComponents.Transducer td2;\n  \n  // ...\n  \nend MyCircuit;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[StyleBox["class MyCircuitInst\n  MyCircuit x(redeclare model MyResistor = lib2.Resistor);\nend MyCircuitInst;", Rule[FontFamily, "Courier New"]]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Additional Examples of Replaceable Class Declarations", "Subsection"], Cell["Additional examples of replaceable class declarations with redeclaration choices are shown below. In the first example you can choose between a resistor and a capacitor as choices of components with two pins, and in the second example a friction function is implemented as a constant, a table, or defined as an exponentiation function depending on your choice.\n", "Text"], Cell[TextData[List[StyleBox["class NewResistor\nreplaceable Resistor Load(R=2) \n  extends TwoPin;\n  ", Rule[FontFamily, "Courier New"]], StyleBox["annotation(choices(\n          choice(redeclare lib2.Resistor Load(a={2}) \"Resistor\"),\n          choice(redeclare Capacitor Load(L=3)       \"Capacitor\"))); ", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend NewResistor;    ", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class NewFrictionFunction\n  replaceable FrictionFunction a(func = exp)\n  extends TwoPin;\n ", StyleBox[" annotation(choices(\n  \t\t\tchoice(redeclare ConstantFriction a(c = 1)\t\t\"Friction Constant\"),\n  \t\t\tchoice(redeclare TableFriction a(table = \"...\")\t\t\"Friction-table\"),  \n  \t\t\tchoice(redeclare FunctionFriction a(func = exp)\t\t\"Friction-exp\") \n  \t\t\t));\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend NewFrictionFunction;"]], "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 941]]], Rule[WindowSize, List[857, 907]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]