List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Annotation Syntax and Placement", "Title"], Cell[CellGroupData[List[Cell["Annotation Choice", "Section"], Cell[TextData[List["Annotation elements can also be structured as redeclarations. Here is an example of a level-three nested ", StyleBox["choices", Rule[FontFamily, "Courier"]], " redeclaration annotation using short class definitions in the redeclarations:\n"]], "Text"], Cell[TextData[List["class AnnotationChoice\n", StyleBox["annotation(choices(\n\t\t\tchoice(redeclare model MyResistor = lib2.Resistor(a = {2})),\n\t\t\tchoice(redeclare model MyResistor = lib2.Resistor2)));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend AnnotationChoice;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Class Annotations", "Section"], Cell[TextData[List["The ", StyleBox["Resistor2", Rule[FontFamily, "Courier"]], " example below illustrates that annotation elements can occur anywhere among the list of elements in a class. The ", StyleBox["public", Rule[FontFamily, "Courier"]], " keyword is used to end the ", StyleBox["equation", Rule[FontFamily, "Courier"]], " section before starting the annotation, otherwise the annotation becomes associated with the equation section:"]], "Text"], Cell[CellGroupData[List[Cell["Electrical units", "Subsection"], Cell["type Voltage \t\t\t\t= ElectricPotential;\ntype Current \t\t\t\t= ElectricCurrent;", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Subsection"], Cell["connector Pin \t\t\t\t\t\"Pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend Pin;  \t\t\t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Resistor2", "Subsection"], Cell[TextData[List["model Resistor2\n  Pin p, n;\n  parameter Real R\t\t\t\t\"Resistance in [Ohm]\";\nequation\n  R*p.i = p.v - n.v;\n  n.i = p.i;\npublic \n  ", StyleBox["annotation(Icon(\n    Rectangle(extent = [-70, -30, 70, 30], style(fillPattern = 1))\n    ));", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Resistor2;        "]], "ModelicaInput"], Cell[TextData[List["\nClass annotations for classes defined by short class definitions are placed at the end of the declaration. For example, the ", StyleBox["Icon", Rule[FontFamily, "Courier"]], " annotation is placed at the end of the ", StyleBox["Velocity", Rule[FontFamily, "Courier"]], " declaration below, after the optional string comment:\n"]], "Text"], Cell[TextData[List[StyleBox["type Velocity = Real[3](unit=\"m/s\") \"a comment\"  \n  annotation", Rule[FontFamily, "Courier New"]], StyleBox["(Icon(\n  \t", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["Rectangle(extent = [-70, -30, 70, 30], style(fillPattern = 1))", Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["));", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]]]], "ModelicaInput"], Cell[TextData[List["\n", StyleBox["Annotations", Rule[FontFamily, "Courier"]], " can also be used to attach documentation information to a package:"]], "Text"], Cell[TextData[List[StyleBox["package Modelica\n ", Rule[FontFamily, "Courier New"]], StyleBox[" annotation(Documentation(info = \" \"));", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\n", Rule[FontFamily, "Courier New"]], "end Modelica;"]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Variable Annotations", "Section"], Cell["A variable annotation associates information with a declared variable. Such an annotation is placed at the end of the variable declaration after the optional string comment. ", "Text"], Cell[CellGroupData[List[Cell["Electrical Connectors", "Subsection"], Cell["connector Pin \t\t\t\t\t\"Pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend Pin;  \t\t\t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Variable Annotation Example", "Subsection"], Cell[TextData[List[StyleBox["class P\nPin p  ", Rule[FontFamily, "Courier New"]], StyleBox["annotation(extent=[-110, -10; -90, 10]);", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend P;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Import Annotations", "Section"], Cell[TextData[List["As for variable annotations, ", StyleBox["import annotations", Rule[FontSlant, "Italic"]], " are placed in the end of the ", StyleBox["import", Rule[FontFamily, "Courier"]], " statement after the optional string comment, e.g.:"]], "Text"], Cell[TextData[List[StyleBox["class I\n", Rule[FontFamily, "Courier New"]], StyleBox["import", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox[" Modelica.Mechanics.Rotational  \"Rotational import\" ", Rule[FontFamily, "Courier New"]], StyleBox["annotation();", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend I;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Equation Annotations", "Section"], Cell[TextData[List["The most common form of ", StyleBox["equation annotation", Rule[FontSlant, "Italic"]], " is annotations to connection equations. It is natural to associate graphical attributes such as lines with a certain position, length, and color to such equations. Notice thar the declaration is placed at the end, after the optional comment, as in Variable and Import Annotations. \n"]], "Text"], Cell[TextData[List[StyleBox["class C\nequation\n  connect(p1.n, p2.p) \"comment\";\n  ", Rule[FontFamily, "Courier New"]], StyleBox["annotation(Line(points = [-90, 0; -70, 0]));", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend C;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Statement and Algorithm Annotations", "Section"], Cell[TextData[List["Statements can also be annotated, even though the need is less obvious than for connection equations. As for equations, ", StyleBox["statement annotations", Rule[FontSlant, "Italic"]], " are placed at the end of the statement after the optional string comment, e.g.:\n"]], "Text"], Cell[TextData[List[StyleBox["class S\nalgorithm\nname := x+2*y   \"comment\"  ", Rule[FontFamily, "Courier New"]], StyleBox["annotation( );", Rule[FontFamily, "Courier New"], Rule[FontColor, RGBColor[0, 0, 1]]], StyleBox["\nend S;", Rule[FontFamily, "Courier New"]]]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[878, 925]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]