List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Units and Quantities", "Title"], Cell[TextData[List["\nWhat is the meaning of unit and quantity? \nWell, ", StyleBox["quantity", Rule[FontSlant, "Italic"]], ", also called ", StyleBox["dimension", Rule[FontSlant, "Italic"]], ", is ", StyleBox["what", Rule[FontSlant, "Italic"]], " you measure, i.e. any measurable extent or magnitude such as length, mass, time, etc. A ", StyleBox["unit", Rule[FontSlant, "Italic"]], " is a \[OpenCurlyDoubleQuote]yardstick\[CloseCurlyDoubleQuote] by which you ", StyleBox["express", Rule[FontSlant, "Italic"]], " your measurements. For example, a measurement of the length quantity can be expressed as a number of meter units."]], "Text"], Cell[CellGroupData[List[Cell["Quantity, Unit, and displayUnit in Modelica", "Section"], Cell["The Modelica notions of quantity and unit with a concrete representation as string attributes to the Real predefined class, are seen below. \n", "Text"], Cell[TextData[List["type Real\n  parameter String ", StyleBox["quantity", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t= \"\";\n  parameter String ", StyleBox["unit", Rule[FontColor, RGBColor[0, 0, 1]]], " \t\t= \"\";\n  parameter String displayUnit \t= \"\";\nend Real;    "]], "ModelicaInput"], Cell[TextData[List["\nBelow are examples of definitions and uses of types corresponding to some physical quantities. Remember that the ", StyleBox["final", Rule[FontFamily, "Courier"]], " prefix on ", StyleBox["quantity", Rule[FontFamily, "Courier"]], " and ", StyleBox["unit", Rule[FontFamily, "Courier"]], " means that these attributes cannot be changed by further modification of the types ", StyleBox["Force", Rule[FontFamily, "Courier"]], " and ", StyleBox["Angle", Rule[FontFamily, "Courier"]], ".\n\n\nDefinintion of quantity types:"]], "Text"], Cell[TextData[List["type Force = Real(final ", StyleBox["quantity = \"Force\"", Rule[FontColor, RGBColor[0, 0, 1]]], ", final unit = \"N\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type Angle = Real(", StyleBox["final quantity = \"Angle\", final unit = \"rad\",", Rule[FontColor, RGBColor[0, 0, 1]]], "\n\t\t\t\t\t\t\t\t\t\tdisplayUnit\t\t= \"deg\");"]], "ModelicaInput"], Cell["\nUse of the quantity types", "Text"], Cell["class QuantityTypes\n  Force  f1;\n  Force  f2(displayUnit=\"kp\");\n  Angle  alpha;\n  Angle  beta(displayUnit=\"rad\");\nend QuantityTypes;", "ModelicaInput"], Cell["\nThe quantity attribute can be used as a grouping mechanism in interactive Modelica environments. The quantity name is needed because it is in general not possible to determine just from the unit whether two different units belong to the same physical quantity. For example, consider the following two types:\n", "Text"], Cell[TextData[List["type Energy = Real(", StyleBox["final quantity = \"Energy\", final unit = \"J\")", Rule[FontColor, RGBColor[0, 0, 1]]], ";"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type Torque = Real", StyleBox["(final quantity = \"MomentOfForce\", final unit = \"N.m\")", Rule[FontColor, RGBColor[0, 0, 1]]], ";"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Modelica.SIunits", "Section"], Cell["\nThe Modelica standard library package Modelica.SIunits contains predefined quantity and connector types in the form shown in the above examples. This library contains approximately 450 predefined types comprising the complete set of ISO SI standard units, which is quite helpful when defining the interfaces of a model. Some additional examples from this library are shown below:\n", "Text"], Cell["type ElectricCurrent   = Real(final quantity=\"ElectricCurrent\",\n                              final unit= \"A\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current           = ElectricCurrent;", "ModelicaInput"], Cell["", "Text"], Cell["type Resistance        = Real(final quantity=\"Resistance\", \n                              final unit=\"Ohm\", min=0);", "ModelicaInput"], Cell["", "Text"], Cell["type Inductance        = Real(final quantity=\"Inductance\", \n                              final unit=\"H\", min=0);", "ModelicaInput"], Cell["", "Text"], Cell["type Time     = Real(final quantity=\"Time\",   final unit=\"s\" );\n", "ModelicaInput"], Cell["", "Text"], Cell["type Length   = Real(final quantity=\"Length\", final unit=\"m\" );\n", "ModelicaInput"], Cell["", "Text"], Cell["type Position = Real(final quantity=\"Length\", final unit=\"m\");\n", "ModelicaInput"], Cell["", "Text"], Cell["type AngularVelocity     = Real(final quantity=\"AngularVelocity\",\n                                final unit=\"rad/s\",\n                                displayUnit=\"rev/min\");", "ModelicaInput"], Cell["", "Text"], Cell["type AngularAcceleration = Real(final quantity=\"AngularAcceleration\",\n                                final unit=\"rad/s2\");", "ModelicaInput"], Cell["", "Text"], Cell["type MomentOfInertia     = Real(final quantity=\"MomentOfInertia\",\n                                final unit=\"kg.m2\");", "ModelicaInput"]], Closed]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 941]]], Rule[WindowSize, List[825, 907]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]