List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["A 3D Double Pendulum", "Title"], Cell[TextData[List["\nIn this section an idealized model of a double pendulum is considered. This pendulum consists of two boxes linked by a hinge. The upper box is lined by a hinge to a non-movable platform, i.e. an inertial system. Both the boxes can move in the XY plane. The corresponding kinematic outline consists of two revolute joints, one frame translation and one inertial system. \n\nThe motion of dynamic system cannot be defined just by its kinematic outline, since an outline does not contain mass objects yet. The class ", StyleBox["Body", Rule[FontFamily, "Courier"]], " represents mechanical objects with mass. This class has a connector ", StyleBox["frame_a", Rule[FontFamily, "Courier"]], " as well as the parameters ", StyleBox["m", Rule[FontFamily, "Courier"]], " (mass of the body), ", StyleBox["rCM[3]", Rule[FontFamily, "Courier"]], " (position of center of mass with respect to frame a) and ", StyleBox["I[3, 3]", Rule[FontFamily, "Courier"]], " (inertia tensor with respect to the position of the center of the mass; it's defined by 6 numbers since it's symmetric).\n\nIn the double pendulum example two bodies can be added to the kinematic outline. \nSince the description of class ", StyleBox["Body", Rule[FontFamily, "Courier"]], " contains the distance between its frame A and its center of mass, such objects can be directly connected to connector ", StyleBox["frame_b", Rule[FontFamily, "Courier"]], " of the revolute joints ", StyleBox["Revolute1", Rule[FontFamily, "Courier"]], " and ", StyleBox["Revolute2.\n", Rule[FontFamily, "Courier"]]]], "Text"], Cell["class doublePendulumNoGeometry \n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  parameter Real         L1 = 1   \"length of 1st arm\";\n  parameter Real         L2 = 1.3 \"length of 2nd arm\";\n  parameter Real         M = 1.0  \"mass\";\n  Parts.InertialSystem   inertialSystem1;\n  Joints.Revolute        revolute2;\n  Joints.Revolute        revolute1;\n  Parts.Body             body1(rCM = {L1/2, 0, 0}, m = M);\n  Parts.FrameTranslation frameTranslation1(r = {L1, 0, 0});\n  Parts.Body             body2(rCM = {L2/2, 0, 0}, m = M);\nequation \n  connect(inertialSystem1.frame_b,   revolute1.frame_a);\n  connect(revolute1.frame_b,         body1.frame_a);\n  connect(revolute1.frame_b,         frameTranslation1.frame_a);\n  connect(frameTranslation1.frame_b, revolute2.frame_a);\n  connect(revolute2.frame_b,         body2.frame_a);\nend doublePendulumNoGeometry;", "ModelicaInput"], Cell[CellGroupData[List[Cell["A Double Pendulum Consisting of two Cylinders", "Section"], Cell["In this example the pendulum consists of two cylinders. The textual representation of Modelica model is following: ", "Text"], Cell["class doublePendulum\n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  parameter Real          L1 = 1   \"length of 1st arm\";\n  parameter Real          L2 = 1.3 \"length of 2nd arm\";\n  Parts.InertialSystem    inertialSystem1;\n  Joints.Revolute         revolute1;\n  Parts.CylinderBody      cylinderBody1(r = {L1, 0, 0});\n  Joints.Revolute         revolute2;\n  Parts.CylinderBody      cylinderBody2(r = {L2, 0, 0}, Material = {1, 1, 0, 0.5});\nequation \n  connect(inertialSystem1.frame_b, revolute1.frame_a);\n  connect(revolute1.frame_b,       cylinderBody1.frame_a);\n  connect(cylinderBody1.frame_b,   revolute2.frame_a);\n  connect(revolute2.frame_b,       cylinderBody2.frame_a);\nend doublePendulum;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of DoublePendulum", "Section"], Cell["simulate( doublePendulum );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(doublePendulum\\) : 2004-2-3 13:16:21.9700849 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 811 variables>\\nVariables of range 100 and depth Infinity listed: \\!\\({\\*TagBox[\\(\\(\\(cylinderBody1 . Axis\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . Axis\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . Axis\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . a\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . a\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . a\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . f\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . f\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . f\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . r0\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . r0\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . r0\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . t\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . t\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . t\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . v\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . v\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . v\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . w\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . w\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . w\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . z\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . z\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . frame\[UnderBracket]a . z\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . \[ImaginaryI]\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(cylinderBody1 . body . m\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . rCM\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . rCM\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . body . rCM\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . extra\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . Extra\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . Form\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . Height\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . Length\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . LengthDirection\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . LengthDirection\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . LengthDirection\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . material\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Material\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Material\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Material\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Material\\)\\) \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nHeight\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nHeight\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nHeight\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nLength\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nLength\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nLength\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nWidth\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nWidth\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . nWidth\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r0\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r0\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r0\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . r\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rvisobj\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rvisobj\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rvisobj\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rxvisobj\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rxvisobj\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . rxvisobj\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . ryvisobj\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . ryvisobj\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . ryvisobj\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . S\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(cylinderBody1 . box . shape\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . size\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . size\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . size\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Sshape\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Sshape\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Sshape\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(cylinderBody1 . box . Sshape\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["plot( cylinderBody1.body.frame_a.a[1] );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.603319 0.0600004 [\n[.21429 .59082 -9 -9 ]\n[.21429 .59082 9 0 ]\n[.40476 .59082 -9 -9 ]\n[.40476 .59082 9 0 ]\n[.59524 .59082 -9 -9 ]\n[.59524 .59082 9 0 ]\n[.78571 .59082 -9 -9 ]\n[.78571 .59082 9 0 ]\n[.97619 .59082 -3 -9 ]\n[.97619 .59082 3 0 ]\n[1.025 .60332 0 -6.28125 ]\n[1.025 .60332 10 6.28125 ]\n[.01131 .00331 -18 -4.5 ]\n[.01131 .00331 0 4.5 ]\n[.01131 .12332 -12 -4.5 ]\n[.01131 .12332 0 4.5 ]\n[.01131 .24332 -12 -4.5 ]\n[.01131 .24332 0 4.5 ]\n[.01131 .36332 -12 -4.5 ]\n[.01131 .36332 0 4.5 ]\n[.01131 .48332 -12 -4.5 ]\n[.01131 .48332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .60332 m\n.21429 .60957 L\ns\n[(0.2)] .21429 .59082 0 1 Mshowa\n.40476 .60332 m\n.40476 .60957 L\ns\n[(0.4)] .40476 .59082 0 1 Mshowa\n.59524 .60332 m\n.59524 .60957 L\ns\n[(0.6)] .59524 .59082 0 1 Mshowa\n.78571 .60332 m\n.78571 .60957 L\ns\n[(0.8)] .78571 .59082 0 1 Mshowa\n.97619 .60332 m\n.97619 .60957 L\ns\n[(1)] .97619 .59082 0 1 Mshowa\n.125 Mabswid\n.07143 .60332 m\n.07143 .60707 L\ns\n.11905 .60332 m\n.11905 .60707 L\ns\n.16667 .60332 m\n.16667 .60707 L\ns\n.2619 .60332 m\n.2619 .60707 L\ns\n.30952 .60332 m\n.30952 .60707 L\ns\n.35714 .60332 m\n.35714 .60707 L\ns\n.45238 .60332 m\n.45238 .60707 L\ns\n.5 .60332 m\n.5 .60707 L\ns\n.54762 .60332 m\n.54762 .60707 L\ns\n.64286 .60332 m\n.64286 .60707 L\ns\n.69048 .60332 m\n.69048 .60707 L\ns\n.7381 .60332 m\n.7381 .60707 L\ns\n.83333 .60332 m\n.83333 .60707 L\ns\n.88095 .60332 m\n.88095 .60707 L\ns\n.92857 .60332 m\n.92857 .60707 L\ns\n.25 Mabswid\n0 .60332 m\n1 .60332 L\ns\ngsave\n1.025 .60332 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .00331 m\n.03006 .00331 L\ns\n[(-10)] .01131 .00331 1 0 Mshowa\n.02381 .12332 m\n.03006 .12332 L\ns\n[(-8)] .01131 .12332 1 0 Mshowa\n.02381 .24332 m\n.03006 .24332 L\ns\n[(-6)] .01131 .24332 1 0 Mshowa\n.02381 .36332 m\n.03006 .36332 L\ns\n[(-4)] .01131 .36332 1 0 Mshowa\n.02381 .48332 m\n.03006 .48332 L\ns\n[(-2)] .01131 .48332 1 0 Mshowa\n.125 Mabswid\n.02381 .03332 m\n.02756 .03332 L\ns\n.02381 .06332 m\n.02756 .06332 L\ns\n.02381 .09332 m\n.02756 .09332 L\ns\n.02381 .15332 m\n.02756 .15332 L\ns\n.02381 .18332 m\n.02756 .18332 L\ns\n.02381 .21332 m\n.02756 .21332 L\ns\n.02381 .27332 m\n.02756 .27332 L\ns\n.02381 .30332 m\n.02756 .30332 L\ns\n.02381 .33332 m\n.02756 .33332 L\ns\n.02381 .39332 m\n.02756 .39332 L\ns\n.02381 .42332 m\n.02756 .42332 L\ns\n.02381 .45332 m\n.02756 .45332 L\ns\n.02381 .51332 m\n.02756 .51332 L\ns\n.02381 .54332 m\n.02756 .54332 L\ns\n.02381 .57332 m\n.02756 .57332 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02571 .6033 L\n.02762 .60326 L\n.02952 .60319 L\n.03143 .60309 L\n.03333 .60296 L\n.03524 .6028 L\n.03714 .60261 L\n.03905 .6024 L\n.04095 .60215 L\n.04286 .60188 L\n.04476 .60158 L\n.04667 .60125 L\n.04857 .60089 L\n.05048 .6005 L\n.05238 .60008 L\n.05429 .59963 L\n.05619 .59916 L\n.0581 .59865 L\n.06 .59812 L\n.0619 .59756 L\n.06381 .59697 L\n.06571 .59635 L\n.06762 .5957 L\n.06952 .59503 L\n.07143 .59432 L\n.07333 .59359 L\n.07524 .59283 L\n.07714 .59203 L\n.07905 .59121 L\n.08095 .59037 L\n.08286 .58949 L\n.08476 .58858 L\n.08667 .58765 L\n.08857 .58669 L\n.09048 .58569 L\n.09238 .58467 L\n.09429 .58363 L\n.09619 .58255 L\n.0981 .58144 L\n.1 .58031 L\n.1019 .57915 L\n.10381 .57796 L\n.10571 .57674 L\n.10762 .57549 L\n.10952 .57421 L\n.11143 .57291 L\n.11333 .57158 L\n.11524 .57022 L\n.11714 .56883 L\nMistroke\n.11905 .56741 L\n.12095 .56597 L\n.12286 .5645 L\n.12476 .563 L\n.12667 .56147 L\n.12857 .55992 L\n.13048 .55834 L\n.13238 .55673 L\n.13429 .55509 L\n.13619 .55343 L\n.1381 .55174 L\n.14 .55002 L\n.1419 .54827 L\n.14381 .5465 L\n.14571 .54471 L\n.14762 .54288 L\n.14952 .54103 L\n.15143 .53916 L\n.15333 .53725 L\n.15524 .53533 L\n.15714 .53337 L\n.15905 .53139 L\n.16095 .52939 L\n.16286 .52736 L\n.16476 .5253 L\n.16667 .52323 L\n.16857 .52112 L\n.17048 .51899 L\n.17238 .51684 L\n.17429 .51467 L\n.17619 .51247 L\n.1781 .51024 L\n.18 .508 L\n.1819 .50573 L\n.18381 .50344 L\n.18571 .50113 L\n.18762 .49879 L\n.18952 .49643 L\n.19143 .49405 L\n.19333 .49165 L\n.19524 .48923 L\n.19714 .48679 L\n.19905 .48432 L\n.20095 .48184 L\n.20286 .47934 L\n.20476 .47681 L\n.20667 .47427 L\n.20857 .47171 L\n.21048 .46913 L\n.21238 .46653 L\nMistroke\n.21429 .46392 L\n.21619 .46128 L\n.2181 .45863 L\n.22 .45597 L\n.2219 .45328 L\n.22381 .45058 L\n.22571 .44787 L\n.22762 .44514 L\n.22952 .44239 L\n.23143 .43963 L\n.23333 .43686 L\n.23524 .43407 L\n.23714 .43127 L\n.23905 .42845 L\n.24095 .42562 L\n.24286 .42278 L\n.24476 .41993 L\n.24667 .41707 L\n.24857 .41419 L\n.25048 .41131 L\n.25238 .40841 L\n.25429 .40551 L\n.25619 .40259 L\n.2581 .39967 L\n.26 .39673 L\n.2619 .39379 L\n.26381 .39084 L\n.26571 .38789 L\n.26762 .38492 L\n.26952 .38195 L\n.27143 .37897 L\n.27333 .37599 L\n.27524 .373 L\n.27714 .37001 L\n.27905 .36701 L\n.28095 .36401 L\n.28286 .361 L\n.28476 .35799 L\n.28667 .35498 L\n.28857 .35196 L\n.29048 .34894 L\n.29238 .34592 L\n.29429 .3429 L\n.29619 .33988 L\n.2981 .33685 L\n.3 .33383 L\n.3019 .33081 L\n.30381 .32778 L\n.30571 .32476 L\n.30762 .32174 L\nMistroke\n.30952 .31872 L\n.31143 .3157 L\n.31333 .31268 L\n.31524 .30967 L\n.31714 .30666 L\n.31905 .30365 L\n.32095 .30065 L\n.32286 .29765 L\n.32476 .29466 L\n.32667 .29167 L\n.32857 .28869 L\n.33048 .28571 L\n.33238 .28274 L\n.33429 .27977 L\n.33619 .27681 L\n.3381 .27386 L\n.34 .27092 L\n.3419 .26798 L\n.34381 .26506 L\n.34571 .26214 L\n.34762 .25923 L\n.34952 .25633 L\n.35143 .25344 L\n.35333 .25056 L\n.35524 .24769 L\n.35714 .24483 L\n.35905 .24198 L\n.36095 .23914 L\n.36286 .23632 L\n.36476 .2335 L\n.36667 .2307 L\n.36857 .22791 L\n.37048 .22514 L\n.37238 .22238 L\n.37429 .21963 L\n.37619 .2169 L\n.3781 .21418 L\n.38 .21147 L\n.3819 .20878 L\n.38381 .20611 L\n.38571 .20345 L\n.38762 .20081 L\n.38952 .19818 L\n.39143 .19557 L\n.39333 .19298 L\n.39524 .1904 L\n.39714 .18784 L\n.39905 .1853 L\n.40095 .18278 L\n.40286 .18027 L\nMistroke\n.40476 .17779 L\n.40667 .17532 L\n.40857 .17287 L\n.41048 .17044 L\n.41238 .16803 L\n.41429 .16564 L\n.41619 .16327 L\n.4181 .16092 L\n.42 .15859 L\n.4219 .15629 L\n.42381 .154 L\n.42571 .15173 L\n.42762 .14949 L\n.42952 .14726 L\n.43143 .14506 L\n.43333 .14288 L\n.43524 .14072 L\n.43714 .13859 L\n.43905 .13647 L\n.44095 .13438 L\n.44286 .13232 L\n.44476 .13027 L\n.44667 .12825 L\n.44857 .12625 L\n.45048 .12428 L\n.45238 .12233 L\n.45429 .1204 L\n.45619 .1185 L\n.4581 .11662 L\n.46 .11476 L\n.4619 .11293 L\n.46381 .11112 L\n.46571 .10934 L\n.46762 .10758 L\n.46952 .10585 L\n.47143 .10414 L\n.47333 .10246 L\n.47524 .1008 L\n.47714 .09916 L\n.47905 .09755 L\n.48095 .09596 L\n.48286 .0944 L\n.48476 .09286 L\n.48667 .09135 L\n.48857 .08987 L\n.49048 .0884 L\n.49238 .08696 L\n.49429 .08555 L\n.49619 .08416 L\n.4981 .0828 L\nMistroke\n.5 .08146 L\n.5019 .08014 L\n.50381 .07885 L\n.50571 .07759 L\n.50762 .07635 L\n.50952 .07513 L\n.51143 .07394 L\n.51333 .07277 L\n.51524 .07162 L\n.51714 .0705 L\n.51905 .0694 L\n.52095 .06833 L\n.52286 .06727 L\n.52476 .06625 L\n.52667 .06524 L\n.52857 .06426 L\n.53048 .0633 L\n.53238 .06236 L\n.53429 .06145 L\n.53619 .06056 L\n.5381 .05969 L\n.54 .05884 L\n.5419 .05802 L\n.54381 .05721 L\n.54571 .05643 L\n.54762 .05567 L\n.54952 .05493 L\n.55143 .05421 L\n.55333 .05351 L\n.55524 .05283 L\n.55714 .05217 L\n.55905 .05153 L\n.56095 .05091 L\n.56286 .05031 L\n.56476 .04973 L\n.56667 .04916 L\n.56857 .04862 L\n.57048 .04809 L\n.57238 .04759 L\n.57429 .04709 L\n.57619 .04662 L\n.5781 .04616 L\n.58 .04572 L\n.5819 .0453 L\n.58381 .04489 L\n.58571 .0445 L\n.58762 .04412 L\n.58952 .04376 L\n.59143 .04341 L\n.59333 .04308 L\nMistroke\n.59524 .04276 L\n.59714 .04245 L\n.59905 .04215 L\n.60095 .04187 L\n.60286 .0416 L\n.60476 .04134 L\n.60667 .04109 L\n.60857 .04084 L\n.61048 .04061 L\n.61238 .04039 L\n.61429 .04017 L\n.61619 .03996 L\n.6181 .03976 L\n.62 .03956 L\n.6219 .03937 L\n.62381 .03918 L\n.62571 .039 L\n.62762 .03882 L\n.62952 .03864 L\n.63143 .03846 L\n.63333 .03828 L\n.63524 .0381 L\n.63714 .03791 L\n.63905 .03773 L\n.64095 .03754 L\n.64286 .03735 L\n.64476 .03716 L\n.64667 .03696 L\n.64857 .03675 L\n.65048 .03654 L\n.65238 .03632 L\n.65429 .03609 L\n.65619 .03586 L\n.6581 .03562 L\n.66 .03536 L\n.6619 .0351 L\n.66381 .03484 L\n.66571 .03456 L\n.66762 .03427 L\n.66952 .03397 L\n.67143 .03366 L\n.67333 .03334 L\n.67524 .03301 L\n.67714 .03268 L\n.67905 .03233 L\n.68095 .03197 L\n.68286 .03161 L\n.68476 .03123 L\n.68667 .03085 L\n.68857 .03046 L\nMistroke\n.69048 .03006 L\n.69238 .02965 L\n.69429 .02924 L\n.69619 .02882 L\n.6981 .02839 L\n.7 .02796 L\n.7019 .02752 L\n.70381 .02708 L\n.70571 .02663 L\n.70762 .02619 L\n.70952 .02574 L\n.71143 .02528 L\n.71333 .02483 L\n.71524 .02438 L\n.71714 .02392 L\n.71905 .02347 L\n.72095 .02302 L\n.72286 .02258 L\n.72476 .02214 L\n.72667 .0217 L\n.72857 .02127 L\n.73048 .02084 L\n.73238 .02042 L\n.73429 .02001 L\n.73619 .01961 L\n.7381 .01921 L\n.74 .01883 L\n.7419 .01846 L\n.74381 .0181 L\n.74571 .01775 L\n.74762 .01742 L\n.74952 .0171 L\n.75143 .0168 L\n.75333 .01652 L\n.75524 .01625 L\n.75714 .016 L\n.75905 .01577 L\n.76095 .01556 L\n.76286 .01537 L\n.76476 .01521 L\n.76667 .01506 L\n.76857 .01494 L\n.77048 .01485 L\n.77238 .01478 L\n.77429 .01473 L\n.77619 .01472 L\n.7781 .01473 L\n.78 .01477 L\n.7819 .01484 L\n.78381 .01494 L\nMistroke\n.78571 .01507 L\n.78762 .01523 L\n.78952 .01543 L\n.79143 .01566 L\n.79333 .01592 L\n.79524 .01623 L\n.79714 .01656 L\n.79905 .01694 L\n.80095 .01735 L\n.80286 .0178 L\n.80476 .01829 L\n.80667 .01881 L\n.80857 .01938 L\n.81048 .01999 L\n.81238 .02065 L\n.81429 .02134 L\n.81619 .02208 L\n.8181 .02287 L\n.82 .02369 L\n.8219 .02457 L\n.82381 .02549 L\n.82571 .02645 L\n.82762 .02747 L\n.82952 .02853 L\n.83143 .02964 L\n.83333 .0308 L\n.83524 .03201 L\n.83714 .03327 L\n.83905 .03458 L\n.84095 .03594 L\n.84286 .03736 L\n.84476 .03882 L\n.84667 .04034 L\n.84857 .04192 L\n.85048 .04354 L\n.85238 .04522 L\n.85429 .04696 L\n.85619 .04875 L\n.8581 .0506 L\n.86 .0525 L\n.8619 .05446 L\n.86381 .05647 L\n.86571 .05855 L\n.86762 .06068 L\n.86952 .06286 L\n.87143 .06511 L\n.87333 .06741 L\n.87524 .06977 L\n.87714 .07219 L\n.87905 .07466 L\nMistroke\n.88095 .0772 L\n.88286 .07979 L\n.88476 .08245 L\n.88667 .08516 L\n.88857 .08793 L\n.89048 .09075 L\n.89238 .09364 L\n.89429 .09658 L\n.89619 .09958 L\n.8981 .10264 L\n.9 .10575 L\n.9019 .10892 L\n.90381 .11215 L\n.90571 .11543 L\n.90762 .11876 L\n.90952 .12215 L\n.91143 .12559 L\n.91333 .12909 L\n.91524 .13264 L\n.91714 .13623 L\n.91905 .13988 L\n.92095 .14357 L\n.92286 .14731 L\n.92476 .1511 L\n.92667 .15493 L\n.92857 .15881 L\n.93048 .16273 L\n.93238 .16669 L\n.93429 .17068 L\n.93619 .17472 L\n.9381 .17879 L\n.94 .18289 L\n.9419 .18703 L\n.94381 .19119 L\n.94571 .19539 L\n.94762 .19961 L\n.94952 .20386 L\n.95143 .20813 L\n.95333 .21242 L\n.95524 .21673 L\n.95714 .22106 L\n.95905 .2254 L\n.96095 .22976 L\n.96286 .23413 L\n.96476 .23851 L\n.96667 .2429 L\n.96857 .2473 L\n.97048 .2517 L\n.97238 .25611 L\n.97429 .26051 L\nMistroke\n.97619 .26492 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n/MISOfy\n{\n    /newfontname exch def\n    /oldfontname exch def\n\n    oldfontname findfont\n    dup length dict begin\n        {1 index /FID ne {def} {pop pop} ifelse} forall\n        /Encoding WindowsANSIEncoding def\n        currentdict\n    end\n\n    newfontname exch definefont pop\n} def\n\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n%%BeginResource: font Courier-MISO\n%%BeginFont: Courier-MISO\n/Courier /Courier-MISO MISOfy\n%%EndFont\n%%EndResource\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(cylinderBody1) show\n141.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n147.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(body) show\n171.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n177.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(frame) show\n%%IncludeResource: font Mathematica4Mono\n%%IncludeFont: Mathematica4Mono\n/Mathematica4Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(\\200) show\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(a) show\n221.375 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n227.375 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(a) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n233.375 12.813 moveto\n(P) show\n239.375 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n245.375 12.813 moveto\n(T) show\n251.375 12.813 moveto\n(@) show\n257.375 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n263.375 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@003P3IfMT500000080fMWI0P00\n003o0=WIf@X0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@3o0=WIf@L0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WI\nf@020=WIf@800000o`3IfMT30=WIf@00203IfMT4000000@0fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o`3IfMT20=WIf@00403IfMT0\n1@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000?0=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT0[@3IfMT;\n0000odT0fMWI000L0=WIf@030000003IfMT0fMWI0:P0fMWI1P000?l90=WIf@D0003oA@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0Y03IfMT40000oa<0fMWI0`000?m30=WIf@00703IfMT00`000000fMWI\n0=WIf@2O0=WIf@D0003o6P3IfMT20000od40fMWI000L0=WIf@030000003IfMT0fMWI09X0fMWI1P00\n0?lP0=WIf@80003o?`3IfMT001`0fMWI00<000000=WIf@3IfMT0T`3IfMT80000obH0fMWI0P000?ln\n0=WIf@00703IfMT00`000000fMWI0=WIf@290=WIf@/0003o;P3IfMT20000ocd0fMWI000L0=WIf@03\n0000003IfMT0fMWI08<0fMWI1`000?lj0=WIf@80003o>`3IfMT001`0fMWI00<000000=WIf@3IfMT0\nP03IfMT40000od40fMWI0P000?lj0=WIf@00703IfMT00`000000fMWI0=WIf@1l0=WIf@@0003oAP3I\nfMT20000ocT0fMWI000L0=WIf@030000003IfMT0fMWI07X0fMWI0`000?m:0=WIf@030000o`3IfMT0\nfMWI03L0fMWI000L0=WIf@030000003IfMT0fMWI07P0fMWI0`000?m=0=WIf@030000o`3IfMT0fMWI\n03H0fMWI000L0=WIf@030000003IfMT0fMWI07H0fMWI0P000?mA0=WIf@030000o`3IfMT0fMWI03D0\nfMWI000L0=WIf@030000003IfMT0fMWI07@0fMWI0`000?mC0=WIf@030000o`3IfMT0fMWI03@0fMWI\n000L0=WIf@030000003IfMT0fMWI0780fMWI0`000?mF0=WIf@030000o`3IfMT0fMWI03<0fMWI000L\n0=WIf@030000003IfMT0fMWI0740fMWI0P000?mH0=WIf@80003o=03IfMT001`0fMWI00<000000=WI\nf@3IfMT0L03IfMT20000oeX0fMWI0P000?lc0=WIf@00703IfMT00`000000fMWI0=WIf@1^0=WIf@80\n003oG@3IfMT00`000?l0fMWI0=WIf@0a0=WIf@00703IfMT00`000000fMWI0=WIf@1]0=WIf@80003o\nGP3IfMT20000oc80fMWI000L0=WIf@030000003IfMT0fMWI06/0fMWI0P000?mQ0=WIf@030000o`3I\nfMT0fMWI0300fMWI000L0=WIf@030000003IfMT0fMWI06X0fMWI0P000?mS0=WIf@030000o`3IfMT0\nfMWI02l0fMWI000L0=WIf@030000003IfMT0fMWI06T0fMWI0P000?mT0=WIf@80003o<03IfMT001`0\nfMWI00<000000=WIf@3IfMT0J03IfMT20000ofH0fMWI00<0003o0=WIf@3IfMT0;P3IfMT001`0fMWI\n00<000000=WIf@3IfMT0I`3IfMT20000ofP0fMWI00<0003o0=WIf@3IfMT0;@3IfMT001D0fMWI0P00\n00050=WIf@030000003IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0J03IfMT20000obh0fMWI000D\n0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0I@3IfMT00`000?l0fMWI0=WI\nf@1Z0=WIf@030000o`3IfMT0fMWI02`0fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI0P00\n001U0=WIf@80003oK@3IfMT00`000?l0fMWI0=WIf@0[0=WIf@003P3IfMT4000000<0fMWI0P000005\n0=WIf@030000003IfMT0fMWI06<0fMWI0P000?m^0=WIf@030000o`3IfMT0fMWI02/0fMWI000D0=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0HP3IfMT20000ofl0fMWI00<0003o\n0=WIf@3IfMT0:`3IfMT001D0fMWI0P0000050=WIf@030000003IfMT0fMWI0640fMWI0P000?ma0=WI\nf@030000o`3IfMT0fMWI02X0fMWI000L0=WIf@030000003IfMT0fMWI0600fMWI0P000?mc0=WIf@03\n0000o`3IfMT0fMWI02T0fMWI000L0=WIf@030000003IfMT0fMWI05l0fMWI0P000?md0=WIf@030000\no`3IfMT0fMWI02T0fMWI000L0=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT0M03I\nfMT00`000?l0fMWI0=WIf@0X0=WIf@00703IfMT00`000000fMWI0=WIf@1N0=WIf@030000o`3IfMT0\nfMWI07D0fMWI00<0003o0=WIf@3IfMT0:03IfMT001`0fMWI00<000000=WIf@3IfMT0G@3IfMT00`00\n0?l0fMWI0=WIf@1g0=WIf@030000o`3IfMT0fMWI02L0fMWI000L0=WIf@030000003IfMT0fMWI05`0\nfMWI00<0003o0=WIf@3IfMT0N03IfMT00`000?l0fMWI0=WIf@0W0=WIf@00703IfMT00`000000fMWI\n0=WIf@1K0=WIf@030000o`3IfMT0fMWI07X0fMWI00<0003o0=WIf@3IfMT09P3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0FP3IfMT20000og`0fMWI00<0003o0=WIf@3IfMT09P3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0F@3IfMT20000ogh0fMWI00<0003o0=WIf@3IfMT09@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@1m0=WIf@030000o`3IfMT0fMWI02D0fMWI000L0=WIf@03\n0000003IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT0OP3IfMT00`000?l0fMWI0=WIf@0U0=WIf@00\n703IfMT00`000000fMWI0=WIf@1G0=WIf@80003oP@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@00703I\nfMT00`000000fMWI0=WIf@1G0=WIf@030000o`3IfMT0fMWI0800fMWI00<0003o0=WIf@3IfMT0903I\nfMT001`0fMWI00<000000=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@220=WIf@030000o`3IfMT0\nfMWI02<0fMWI000L0=WIf@030000003IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0P`3IfMT00`00\n0?l0fMWI0=WIf@0S0=WIf@00703IfMT00`000000fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI08D0\nfMWI00<0003o0=WIf@3IfMT08P3IfMT001`0fMWI00<000000=WIf@3IfMT0E03IfMT00`000?l0fMWI\n0=WIf@250=WIf@030000o`3IfMT0fMWI0280fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0\n003o0=WIf@3IfMT0Q`3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@00703IfMT00`000000fMWI0=WIf@1B\n0=WIf@80003oR@3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@00703IfMT00`000000fMWI0=WIf@1B0=WI\nf@030000o`3IfMT0fMWI08T0fMWI00<0003o0=WIf@3IfMT0803IfMT001`0fMWI00<000000=WIf@3I\nfMT0D@3IfMT00`000?l0fMWI0=WIf@2:0=WIf@030000o`3IfMT0fMWI0200fMWI000L0=WIf@030000\n003IfMT0fMWI0500fMWI00<0003o0=WIf@3IfMT0S03IfMT00`000?l0fMWI0=WIf@0O0=WIf@00703I\nfMT00`000000fMWI0=WIf@1?0=WIf@80003oSP3IfMT00`000?l0fMWI0=WIf@0O0=WIf@00503IfMT3\n000000D0fMWI00<000000=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@2=0=WIf@030000o`3IfMT0\nfMWI01l0fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0CP3IfMT0\n0`000?l0fMWI0=WIf@2?0=WIf@030000o`3IfMT0fMWI01h0fMWI000D0=WIf@040000003IfMT0fMWI\n000000@0fMWI0P00001?0=WIf@030000o`3IfMT0fMWI08l0fMWI00<0003o0=WIf@3IfMT07P3IfMT0\n00h0fMWI100000020=WIf@<000001@3IfMT00`000000fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI\n0940fMWI00<0003o0=WIf@3IfMT07@3IfMT001D0fMWI00<000000=WIf@3IfMT0103IfMT00`000000\nfMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0980fMWI00<0003o0=WIf@3IfMT07@3IfMT001D0fMWI\n0`0000040=WIf@030000003IfMT0fMWI04/0fMWI0P000?nE0=WIf@030000o`3IfMT0fMWI01`0fMWI\n000L0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0U03IfMT00`000?l0fMWI0=WI\nf@0L0=WIf@00703IfMT00`000000fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI09D0fMWI00<0003o\n0=WIf@3IfMT0703IfMT001`0fMWI00<000000=WIf@3IfMT0B@3IfMT20000oiP0fMWI00<0003o0=WI\nf@3IfMT06`3IfMT001`0fMWI00<000000=WIf@3IfMT0B@3IfMT00`000?l0fMWI0=WIf@2e0=WIf@00\n703IfMT00`000000fMWI0=WIf@180=WIf@030000o`3IfMT0fMWI0;H0fMWI000L0=WIf@030000003I\nfMT0fMWI04P0fMWI00<0003o0=WIf@3IfMT0]P3IfMT001`0fMWI00<000000=WIf@3IfMT0A`3IfMT0\n0`000?l0fMWI0=WIf@2g0=WIf@00703IfMT00`000000fMWI0=WIf@160=WIf@80003o^@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0AP3IfMT00`000?l0fMWI0=WIf@2h0=WIf@00703IfMT00`000000fMWI\n0=WIf@150=WIf@030000o`3IfMT0fMWI0;T0fMWI000L0=WIf@030000003IfMT0fMWI04@0fMWI00<0\n003o0=WIf@3IfMT0^P3IfMT001`0fMWI00<000000=WIf@3IfMT0A03IfMT00`000?l0fMWI0=WIf@2j\n0=WIf@00703IfMT00`000000fMWI0=WIf@130=WIf@030000o`3IfMT0fMWI0;/0fMWI000L0=WIf@03\n0000003IfMT0fMWI0480fMWI00<0003o0=WIf@3IfMT0_03IfMT001`0fMWI00<000000=WIf@3IfMT0\n@P3IfMT00`000?l0fMWI0=WIf@2l0=WIf@00703IfMT00`000000fMWI0=WIf@110=WIf@80003o_P3I\nfMT001`0fMWI00<000000=WIf@3IfMT0@@3IfMT00`000?l0fMWI0=WIf@2m0=WIf@00703IfMT00`00\n0000fMWI0=WIf@100=WIf@030000o`3IfMT0fMWI0;h0fMWI000L0=WIf@030000003IfMT0fMWI03l0\nfMWI00<0003o0=WIf@3IfMT0_`3IfMT001`0fMWI00<000000=WIf@3IfMT0?`3IfMT00`000?l0fMWI\n0=WIf@2o0=WIf@00703IfMT00`000000fMWI0=WIf@0n0=WIf@030000o`3IfMT0fMWI0<00fMWI000L\n0=WIf@030000003IfMT0fMWI03d0fMWI00<0003o0=WIf@3IfMT0`@3IfMT001`0fMWI00<000000=WI\nf@3IfMT0?@3IfMT00`000?l0fMWI0=WIf@310=WIf@005P3IfMT3000000<0fMWI00<000000=WIf@3I\nfMT0?03IfMT00`000?l0fMWI0=WIf@320=WIf@005`3IfMT00`000000fMWI0=WIf@020=WIf@030000\n003IfMT0fMWI03`0fMWI00<0003o0=WIf@3IfMT0`P3IfMT001@0fMWI1@0000030=WIf@800000?03I\nfMT00`000?l0fMWI0=WIf@330=WIf@003P3IfMT400000080fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@0j0=WIf@030000o`3IfMT0fMWI0<@0fMWI000E0=WIf@030000003IfMT0\n000000@0fMWI00<000000=WIf@3IfMT0>P3IfMT00`000?l0fMWI0=WIf@340=WIf@005P3IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0>@3IfMT00`000?l0fMWI0=WIf@350=WIf@00703IfMT00`000000\nfMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI0<H0fMWI000L0=WIf@030000003IfMT0fMWI03P0fMWI\n00<0003o0=WIf@3IfMT0aP3IfMT001`0fMWI00<000000=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WI\nf@370=WIf@00703IfMT00`000000fMWI0=WIf@0g0=WIf@030000o`3IfMT0fMWI0<L0fMWI000L0=WI\nf@030000003IfMT0fMWI03H0fMWI00<0003o0=WIf@3IfMT0b03IfMT001`0fMWI00<000000=WIf@3I\nfMT0=@3IfMT00`000?l0fMWI0=WIf@390=WIf@00703IfMT00`000000fMWI0=WIf@0e0=WIf@030000\no`3IfMT0fMWI0<T0fMWI000L0=WIf@030000003IfMT0fMWI03@0fMWI00<0003o0=WIf@3IfMT0bP3I\nfMT001`0fMWI00<000000=WIf@3IfMT0<`3IfMT00`000?l0fMWI0=WIf@3;0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0b0=WIf@80003oc@3IfMT001`0fMWI00<000000=WIf@3IfMT0<P3IfMT00`000?l0\nfMWI0=WIf@3<0=WIf@00703IfMT00`000000fMWI0=WIf@0a0=WIf@030000o`3IfMT0fMWI0<d0fMWI\n000L0=WIf@030000003IfMT0fMWI0340fMWI00<0003o0=WIf@3IfMT0c@3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@3>0=WIf@00703IfMT00`000000fMWI0=WIf@0_0=WI\nf@030000o`3IfMT0fMWI0<l0fMWI000L0=WIf@030000003IfMT0fMWI02h0fMWI0P000?oA0=WIf@00\n703IfMT00`000000fMWI0=WIf@0^0=WIf@030000o`3IfMT0fMWI0=00fMWI000L0=WIf@030000003I\nfMT0fMWI02d0fMWI00<0003o0=WIf@3IfMT0d@3IfMT001`0fMWI00<000000=WIf@3IfMT0;03IfMT0\n0`000?l0fMWI0=WIf@3B0=WIf@00703IfMT00`000000fMWI0=WIf@0[0=WIf@80003oe03IfMT001`0\nfMWI00<000000=WIf@3IfMT0:`3IfMT00`000?l0fMWI0=WIf@3C0=WIf@00703IfMT00`000000fMWI\n0=WIf@0Z0=WIf@80003oe@3IfMT001`0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000?l0fMWI0=WI\nf@3D0=WIf@00503IfMT4000000@0fMWI00<000000=WIf@3IfMT0:@3IfMT00`000?l0fMWI0=WIf@3E\n0=WIf@00503IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI02P0fMWI00<0003o0=WI\nf@3IfMT0eP3IfMT001D0fMWI00<000000=WIf@3IfMT0103IfMT2000002P0fMWI00<0003o0=WIf@3I\nfMT0e`3IfMT000h0fMWI100000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0\n9P3IfMT20000omT0fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0\n9@3IfMT20000omX0fMWI000E0=WIf@8000001@3IfMT00`000000fMWI0=WIf@0U0=WIf@030000o`3I\nfMT0fMWI0=T0fMWI000L0=WIf@030000003IfMT0fMWI02@0fMWI00<0003o0=WIf@3IfMT0fP3IfMT0\n01`0fMWI00<000000=WIf@3IfMT08`3IfMT20000om`0fMWI000L0=WIf@030000003IfMT0fMWI0280\nfMWI0P000?oM0=WIf@00703IfMT00`000000fMWI0=WIf@0Q0=WIf@80003ogP3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0803IfMT20000oml0fMWI000L0=WIf@030000003IfMT0fMWI0200fMWI00<0003o\n0=WIf@3IfMT0gP3IfMT001`0fMWI00<000000=WIf@3IfMT07`3IfMT00`000?l0fMWI0=WIf@3O0=WI\nf@00703IfMT00`000000fMWI0=WIf@0N0=WIf@030000o`3IfMT0fMWI0>00fMWI000L0=WIf@030000\n003IfMT0fMWI01d0fMWI00<0003o0=WIf@3IfMT0h@3IfMT001`0fMWI00<000000=WIf@3IfMT0703I\nfMT00`000?l0fMWI0=WIf@3R0=WIf@00703IfMT00`000000fMWI0=WIf@0K0=WIf@030000o`3IfMT0\nfMWI0><0fMWI000L0=WIf@030000003IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0i03IfMT001`0\nfMWI00<000000=WIf@3IfMT06@3IfMT20000onH0fMWI000L0=WIf@030000003IfMT0fMWI01P0fMWI\n00<0003o0=WIf@3IfMT0iP3IfMT001`0fMWI00<000000=WIf@3IfMT05P3IfMT20000o``0fMWI0P00\n00040=WIf@8000000`3IfMT4000001l0fMWI0P0000040=WIf@8000001@3IfMT3000001h0fMWI0P00\n00040=WIf@8000000`3IfMT300000200fMWI0P0000040=WIf@800000103IfMT2000002D0fMWI1@00\n000K0=WIf@00703IfMT00`000000fMWI0=WIf@0E0=WIf@80003o303IfMT010000000fMWI0=WIf@00\n00080=WIf@030000003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT000002`3IfMT00`000000fMWI\n0=WIf@0L0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000002H0fMWI00<000000=WIf@3IfMT06`3I\nfMT001`0fMWI00<000000=WIf@3IfMT0503IfMT20000o`d0fMWI00@000000=WIf@3IfMT000002@3I\nfMT00`000000fMWI0=WIf@0N0=WIf@040000003IfMT0fMWI000000P0fMWI1@00000M0=WIf@040000\n003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT010000000fMWI0=WIf@000008\n0=WIf@040000003IfMT0fMWI000002H0fMWI00<000000=WIf@3IfMT06`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT20000o`h0fMWI00@000000=WIf@3IfMT000002P3IfMT00`000000fMWI0=WI\nf@0M0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007P3IfMT010000000\nfMWI0=WIf@0000080=WIf@<000007`3IfMT010000000fMWI0=WIf@0000090=WIf@8000009`3IfMT0\n0`000000fMWI0=WIf@0K0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@80003o403IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001h0fMWI00@000000=WIf@3IfMT00000\n2@3IfMT00`000000fMWI0000000N0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3I\nfMT07P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000002H0fMWI00<00000\n0=WIf@3IfMT06`3IfMT001`0fMWI00<000000=WIf@3IfMT03`3IfMT30000oa80fMWI0P00000:0=WI\nf@800000803IfMT2000000/0fMWI0P00000O0=WIf@8000002P3IfMT3000001l0fMWI0P00000:0=WI\nf@8000009P3IfMT2000001d0fMWI000L0=WIf@030000003IfMT0fMWI00h0fMWI0P000?oa0=WIf@00\n703IfMT00`000000fMWI0=WIf@0<0=WIf@<0003olP3IfMT001`0fMWI00<000000=WIf@3IfMT02P3I\nfMT30000oo@0fMWI000L0=WIf@030000003IfMT0fMWI00L0fMWI0`000?og0=WIf@00703IfMT00`00\n0000fMWI0=WIf@040=WIf@@0003ojP3IfMT2000000d0fMWI000F0=WIf@H000001`000?oU000000P0\nfMWI00@000000=WIf@3IfMT00000303IfMT001`0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000\nfMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@090=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI\n00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI02/0fMWI\n00<000000=WIf@3IfMT0:`3IfMT00`000000fMWI0=WIf@0[0=WIf@030000003IfMT0fMWI00X0fMWI\n1@00000<0=WIf@00703IfMT00`000000fMWI0=WIf@3a0=WIf@030000003IfMT0fMWI00d0fMWI000L\n0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT002P0fMWI0P00000j0=WIf@8000008P3IfMT2000009H0fMWI000Y0=WIf@030000003IfMT0\nfMWI03T0fMWI00<000000=WIf@3IfMT08@3IfMT00`000000fMWI0=WIf@2D0=WIf@008`3IfMT30000\n00@0fMWI00@000000=WIf@3IfMT0fMWI0`0000040=WIf@<0000000<0fMWI0000000000000P3IfMT2\n00000080fMWI100000020=WIf@<000000P3IfMT4000000030=WIf@000000000000800000103IfMT2\n000000@0fMWI100000030=WIf@040000003IfMT0fMWI0=WIf@D000000P3IfMT200000080fMWI1000\n00040=WIf@800000103IfMT4000000<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000<0fMWI1000\n00020=WIf@<00000P`3IfMT00280fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI00000003\n0=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000001P3IfMT00`000000fMWI0=WIf@020=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00\n00030=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WI\nf@0000020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT00`00\n0000fMWI000000090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0PP3IfMT001H0\nfMWI20000?l40=WIf@030000003IfMT0fMWI00<0fMWI00@000000=WIf@3IfMT000000`3IfMT00`00\n0000fMWI0=WIf@040=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@00\n00020=WIf@030000003IfMT0fMWI00@000000`3IfMT00`000000fMWI0=WIf@020=WIf@040000003I\nfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@0000020=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@00\n00020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000\nfMWI0=WIf@0000090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT0PP3IfMT002<0\nfMWI0`0000001@3IfMT00000000000000000fMWI008000000P3IfMT00`000000fMWI0=WIf@030=WI\nf@8000000P3IfMT4000000@0fMWI0`0000030=WIf@8000000`3IfMT400000080fMWI0`0000040=WI\nf@800000103IfMT3000000050=WIf@00000000000000003IfMT00P0000030=WIf@030000003IfMT0\nfMWI00L0fMWI0`0000040=WIf@800000103IfMT3000000050=WIf@00000000000000003IfMT00P00\n00070=WIf@@000000P3IfMT3000008<0fMWI000_0=WIf@030000003IfMT0fMWI0140fMWI00<00000\n0=WIf@3IfMT0303IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI00P0fMWI00<0\n00000=WIf@3IfMT01`3IfMT00`000000fMWI0=WIf@0<0=WIf@030000003IfMT0fMWI00d0fMWI00<0\n00000=WIf@3IfMT0R03IfMT002h0fMWI0P0000060=WIf@030000003IfMT0fMWI00T0fMWI0P00000=\n0=WIf@@000002`3IfMT2000000T0fMWI0P0000080=WIf@8000003@3IfMT200000100fMWI0P000028\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, -11.1098`, 0.00434554`, 0.0689763`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[818, 915]], Rule[WindowMargins, List[List[0, Automatic], List[4, Automatic]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]