List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Interfacing to Non-Mechanical Model Components", "Title"], Cell[TextData[List["\nWhen a multidomain model in Modelica is designed, the mechanical part of the model physically interacts with some other parts of the model. The mechanical part should usually be connected with the part describing the drive train, which is in turn connected to the part describing the energy source, e.g. electrical circuit. There are standard Modelica libraries for all these components. \n\nHowever, sometimes the attention is focused on an isolated mechanical part of the model. In this case the reference positions as well as forces and torques acting on the model can be specified directly. \n\nThere exist three major ways to set up an interface between the mechanical part of Modelica model and other parts. These ways correspond to three connector types: ", StyleBox["Multiboby.Interfaces.Frame, Rotational.Interfaces.Flange", Rule[FontFamily, "Courier"]], " and ", StyleBox["Translational.Interfaces.Flange", Rule[FontFamily, "Courier"]], ". "]], "Text"], Cell[CellGroupData[List[Cell["Using Multibody.Interfaces.Frame", "Section"], Cell[TextData[List["Any object with connector of type ", StyleBox["Frame_a", Rule[FontFamily, "Courier"]], " or ", StyleBox["Frame_b", Rule[FontFamily, "Courier"]], " can be connected to a model of external force or torque. This external force (or torque) will be applied to the corresponding point on the relevant body. The example below includes a force acting on the end of the pendulum in direction of the local Y-axis (perpendicular to the pendulum bar). When force is attached to the pendulum it does not oscillate;  it rotates instead.\n"]], "Text"], Cell["class ExtForcePendulum\n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import ModelicaAdditions.MultiBody.Forces;\n  import Modelica.Blocks.Sources;\n  Parts.InertialSystem  inertialSystem1;\n  Joints.Revolute       revolute1;\n  Parts.CylinderBody    cylinderBody1(r = {1, 0, 0});\n  Forces.ExtForce       extForce1;\n  Sources.Constant      constant1(k = {0, 1190, 0});\nequation \n  connect(inertialSystem1.frame_b, revolute1.frame_a);\n  connect(revolute1.frame_b,       cylinderBody1.frame_a);\n  connect(cylinderBody1.frame_b,   extForce1.frame_b);\n  connect(constant1.outPort,       extForce1.inPort);\nend ExtForcePendulum;", "ModelicaInput"], Cell[TextData[List["\nSometimes it is necessary to specify external force in global coordinates. One connect statement should be replaced by equation (see below). The input signal ", StyleBox["ExtForce", Rule[FontFamily, "Courier"]], " object is adjusted according to the orientation matrix ", StyleBox["S", Rule[FontFamily, "Courier"]], " of the ", StyleBox["ExtForce", Rule[FontFamily, "Courier"]], " frame. When such constant force (in direction of vector {1,1,0} in the global coordinate system) is applied to the pendulum, it oscillates near the equilibrium point.\n"]], "Text"], Cell[TextData[List["class ExtGlobalForcePendulum\n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import ModelicaAdditions.MultiBody.Forces;\n  import Modelica.Blocks.Sources;\n  Parts.InertialSystem  inertialSystem1;\n  Joints.Revolute       revolute1; \n  Parts.CylinderBody    cylinderBody1(r = {1, 0, 0});\n  Forces.ExtForce       extForce1;\n  Sources.Constant      constant1(k = {5000, 5000, 0});\nequation \n  connect(inertialSystem1.frame_b, revolute1.frame_a);\n  connect(revolute1.frame_b,       cylinderBody1.frame_a);\n  connect(cylinderBody1.frame_b,   extForce1.frame_b);\n  ", StyleBox["transpose(extForce1.frame_b.S) * constant1.outPort.signal = extForce.inPort.signal;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ExtGlobalForcePendulum;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Using Rotational.Interfaces.Flange", "Section"], Cell[TextData[List["The ", StyleBox["Rotational", Rule[FontFamily, "Courier"]], " library describes varius elements for one-dimensional rotational motion. These elements can be attached to the Revolute joint from ", StyleBox["MultiBody", Rule[FontFamily, "Courier"]], " library. A torque, spring, damper or any other component can be attached to the flanges of the revolute joint. The example below illustrates a one-dimensional spring and damper (from ", StyleBox["Rotational", Rule[FontFamily, "Courier"]], " library) attached to the revolute joint of a simple pendulum.\n"]], "Text"], Cell["class PendulumWithDamper \n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import ModelicaAdditions.MultiBody.Forces;\n  import Modelica.Blocks.Sources;\n  import Modelica.Mechanics.Rotational;\n  Parts.InertialSystem     inertialSystem1;\n  Parts.CylinderBody       cylinderBody1(r = {1, 0, 0});\n  Joints.Revolute          revolute1;\n  Rotational.SpringDamper  springDamper1(c = 500, phi_rel0 = 1, d = 500);\nequation \n  connect(inertialSystem1.frame_b, revolute1.frame_a);\n  connect(springDamper1.flange_a,  revolute1.bearing);\n  connect(springDamper1.flange_b,  revolute1.axis);\n  connect(revolute1.frame_b,       cylinderBody1.frame_a);\nend PendulumWithDamper;", "ModelicaInput"], Cell[TextData[List["\nOften it is necessary to move the joint to the desired position. This can be done by ", StyleBox["Rotational.Position", Rule[FontFamily, "Courier"]], " component. The angle is given by a signal that come from a ", StyleBox["Block", Rule[FontFamily, "Courier"]], " library element.The example below illustrates a ", StyleBox["Step", Rule[FontFamily, "Courier"]], " block attached to such component.\n"]], "Text"], Cell[TextData[List["class PendulumWithPosition \n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import Modelica.Blocks.Sources;\n  import Modelica.Mechanics.Rotational;\n  Parts.InertialSystem  inertialSystem1;\n  Parts.CylinderBody    cylinderBody1(r = {1, 0, 0});\n  Joints.Revolute       revolute1;\n  Sources.Step          step1(startTime = {0.5});\n  ", StyleBox["Rotational.Position position1(f_crit = 5);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  connect(revolute1.frame_b, cylinderBody1.frame_a);\n  connect(springDamper1.flange_a, revolute1.bearing);\n  connect(springDamper1.flange_b, revolute1.axis);\n", StyleBox["  connect(revolute1.frame_b, cylinderBody1.frame_a);\n", Rule[FontColor, RGBColor[0, 0, 1]]], "end PendulumWithPosition;"]], "ModelicaInput"], Cell[TextData[List["\nIn class Position the reference angle is filtered and the second derivative of the filtered curve is used to compute the reference acceleration of the flange. Angular position of the joint is computed from this acceleration. For filtering, a second order Bessel filter is used. The critical frequency (also called cut-off frequency) of the filter is defined via parameter ", StyleBox["f_crit", Rule[FontFamily, "Courier"]], " in [Hz]. This value should be selected in such a way that it is higher as the essential low frequencies in the signal.\n\nAnother way to steer a joint is to set up a ", StyleBox["Proportional Derivative (PD) controller", Rule[FontSlant, "Italic"]], ". Instead of computing angular position, the PD controller creates an active torque, which acts on the joint. It behaves like a motor; parameters ", StyleBox["k", Rule[FontFamily, "Courier"]], " and ", StyleBox["d", Rule[FontFamily, "Courier"]], " can be tuned in order to adjust the reaction speed and power.\n"]], "Text"], Cell["class SimpleRotationalController \n  \"Input signal acting as reference value for angle, \n   gives external torque on a flange\"\n  import Modelica.Blocks;\n  import Modelica.Mechanics.Rotational;\n  parameter Real             k = 1;\n  parameter Real             d = 1;\n  Blocks.Interfaces.InPort        inPort(final n = 1);\n  Rotational.Interfaces.Flange_b  flange_b;\nequation \n  flange_b.tau = k * (flange_b.phi - inPort.signal[1]) + \n                 d * der(flange_b.phi);\nend SimpleRotationalController;", "ModelicaInput"], Cell["", "Text"], Cell["class PendulumWithSteering \n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import Modelica.Blocks.Sources;\n  Parts.InertialSystem       inertialSystem1;\n  Parts.CylinderBody         cylinderBody1(r = {1, 0, 0});\n  Joints.Revolute            revolute1;\n  Sources.Step               step1(startTime = {0.5});\n  SimpleRotationalController ctrl(k = 5000, d = 500);\nequation \n  connect(revolute1.frame_b,       cylinderBody1.frame_a);\n  connect(step1.outPort,           ctrl.inPort);\n  connect(ctrl.flange_b,           revolute1.axis);\n  connect(inertialSystem1.frame_b, revolute1.frame_a);\nend PendulumWithSteering;", "ModelicaInput"], Cell[TextData[List["\nThe Translational library describes various elements for one-dimensional translational motion. These elements can be attached to the ", StyleBox["Prismatic", Rule[FontFamily, "Courier"]], " joint from ", StyleBox["MultiBody", Rule[FontFamily, "Courier"]], " library.A force, spring, damper or any other component can be attached to the flanges of the prismatic joint. Below a ", StyleBox["Position", Rule[FontFamily, "Courier"]], " component is attached to prismatic joint, and steers the position of the first body according to the signal from the ", StyleBox["Step", Rule[FontFamily, "Courier"]], " block. In addition a free flying body is attached to the first body. It is connected by a 3D spring and damper to the first one. The example demonstrates how ", StyleBox["FreeMotion", Rule[FontFamily, "Courier"]], " class is used.\n"]], "Text"], Cell["class PrismaticPosition\n  import ModelicaAdditions.MultiBody.Parts;\n  import ModelicaAdditions.MultiBody.Joints;\n  import ModelicaAdditions.MultiBody.Forces;\n  import Modelica.Blocks.Sources;\n  import Modelica.Mechanics.Translational;\n  Parts.InertialSystem   inertialSystem1;\n  Parts.CylinderBody     cylinderBody1;\n  Joints.Prismatic       prismatic1;\n  Forces.SpringDamperPar springDamperPar1(c = 10000, s0 = 0.3,  d = 500);\n  Joints.FreeMotion      freeMotion1;\n  Parts.CylinderBody     cylinderBody2;\n  Translational.Position position1;\n  Sources.Step           step1(startTime = {0.5});\nequation \n  connect(prismatic1.frame_b,       cylinderBody1.frame_a);\n  connect(prismatic1.frame_a,       inertialSystem1.frame_b);\n  connect(springDamperPar1.frame_a, cylinderBody1.frame_b);\n  connect(cylinderBody1.frame_b,    freeMotion1.frame_a);\n  connect(freeMotion1.frame_b,      cylinderBody2.frame_a);\n  connect(springDamperPar1.frame_b, cylinderBody2.frame_a);\n  connect(position1.flange_b,       prismatic1.axis);\n  connect(step1.outPort,            position1.inPort);\nend PrismaticPosition;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[807, 862]], Rule[WindowMargins, List[List[10, Automatic], List[Automatic, 5]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]