List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Pressure Dynamics in 1D Ducts - Solving Wave Equations by Discretized PDEs", "Title"], Cell["\nCurrently Modelica cannot handle partial differential equations directly since there is only the notion of differentiation with respect to time built into the language. However, in many cases derivatives with respect to other variables such as for example spatial dimensions can be handled by simple discretizations schemes represented using the array capabilities in Modelica. Here we will give an example of how the one dimensional wave equation can be represented in Modelica and how MathModelica can be used for simulation and display of the results, as well as representing the result as a 2D interpolating function.", "Text"], Cell[CellGroupData[List[Cell["WaveEquationSample Model", "Section"], Cell["model WaveEquationSample\n  import Modelica.SIunits;\n  parameter SIunits.Length  \tL = 10 \t\"Length of duct\";\n  parameter Integer         \tn = 30 \t\"Number of sections\";\n  parameter SIunits.Length   \tdL = L/n \t\"Section length\";\n  parameter SIunits.Velocity \tc = 1;\n  SIunits.Pressure[n]  \t\t\tp(start = initialPressure(n));\n  Real[n]              \t\t\tdp(start = fill(0,n));\nequation\n  p[1] = exp(-(-L/2)^2);\n  p[n] = exp(-(L/2)^2);\n  dp = der(p);\n  for i in 2:n-1 loop\n    der(dp[i]) = c^2 * (p[i+1] - 2 * p[i] + p[i-1]) / dL^2;\n  end for;\nend WaveEquationSample;", "ModelicaInput"], Cell[TextData[List["Here we are using a Modelica function ", StyleBox["initialPressure", Rule[FontFamily, "Courier"]], " (defined further below) to specify the initial value of the pressure along the duct. \nAssume that we would like an initial pressure profile in the duct of the form ", Cell[BoxData[FormBox[SuperscriptBox["\[ExponentialE]", RowBox[List["-", SuperscriptBox["x", "2"]]]], TraditionalForm]]], ", depicted in Figure 1 below by the following plot command:"]], "Text"], Cell[BoxData[RowBox[List[RowBox[List[StyleBox["Plot", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox["[", Rule[FormatType, StandardForm], Rule[FontSize, 11]], RowBox[List[SuperscriptBox[StyleBox["\[ExponentialE]", Rule[FormatType, StandardForm], Rule[FontSize, 11]], RowBox[List["-", SuperscriptBox["x", "2"]]]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[RowBox[List["{", RowBox[List["x", ",", " ", RowBox[List["-", "5"]], ",", " ", "5"]], "}"]], Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[RowBox[List["PlotRange", "->", "All"]], Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox["]", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox[";", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]]], "Input"], Cell[BoxData[RowBox[List["The", " ", "initial", " ", "pressure", " ", "profile", " ", "of", " ", "the", " ", "duct"]]], "NumberedFigure"], Cell[TextData[List["The function ", StyleBox["initialPressure", Rule[FontFamily, "Courier"]], " returns the initial pressure profile function in discretized form as an array."]], "Text"], Cell["function initialPressure\n  input Integer n;\n  output Real p[n];\nprotected\n  parameter Modelica.SIunits.Length L = 10;\nalgorithm\n  for i in 1:n loop\n    p[i] := exp(-(-L/2 + (i - 1) / (n - 1) * L)^2);\n  end for;\nend initialPressure;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of WaveEquationSample", "Section"], Cell[TextData[List["We simulate the ", StyleBox["WaveEquationSample", Rule[FontFamily, "Courier"]], " model..."]], "Text"], Cell["simulate( WaveEquationSample, stopTime=10 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(WaveEquationSample\\) : 2004-2-2 16:15:39.7113854 : \\!\\({0.`, 10.`}\\) : 502 data points : 1 events : 122 variables>\\nVariables of range 100 and depth Infinity listed: \\!\\({\\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"dL\\\", HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(11\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(12\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(13\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(14\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(15\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(16\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(17\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(18\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(19\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(20\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(21\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(22\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(23\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(24\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(25\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(26\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(27\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(28\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(29\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(30\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(dp \[LeftDoubleBracket] \\(\\(9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"L\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(11\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(12\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(13\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(14\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(15\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(16\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(17\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(18\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(19\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(20\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(21\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(22\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(23\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(24\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(25\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(26\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(27\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(28\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(29\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(30\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p \[LeftDoubleBracket] \\(\\(9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(11\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(12\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(13\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(14\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(15\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(16\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(17\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(18\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(19\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(20\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(21\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(22\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(23\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(24\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(25\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(26\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(27\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(28\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(29\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(7\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(8\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(dp \[LeftDoubleBracket] \\(\\(9\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(11\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(12\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(13\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(14\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(15\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\(p \[LeftDoubleBracket] \\(\\(16\\)\\) \[RightDoubleBracket]\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell[TextData[List["The simulation result, i.e. the array ", StyleBox["p", Rule[FontFamily, "Courier"]], ", shows how the pressure evolves at equidistant positions in the duct as functions of time. This is represented by the array ", StyleBox["p", Rule[FontFamily, "Courier"]], " of 1D interpolation functions of time, that are packed into a Mathematica 2D interpolation function and plotted using the following two commands:"]], "Text"], Cell[BoxData[RowBox[List[RowBox[List[StyleBox["intp", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["=", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], RowBox[List[StyleBox["Interpolation", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["[", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], RowBox[List[StyleBox["Flatten", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["[", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], RowBox[List[RowBox[List[StyleBox["Table", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["[", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], RowBox[List[StyleBox[RowBox[List["{", RowBox[List[RowBox[List[RowBox[List["-", "5."]], " ", "+", " ", RowBox[List["(", RowBox[List[RowBox[List["(", RowBox[List["k", " ", "-", " ", "1"]], ")"]], "/", "29"]], ")"]], "*", "10"]], ",", " ", "t", ",", " ", RowBox[List[RowBox[List["p", "[", RowBox[List["[", "k", "]"]], "]"]], "[", "t", "]"]]]], "}"]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["\n", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["      ", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[RowBox[List["{", RowBox[List["k", ",", " ", "1", ",", " ", "30"]], "}"]], Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[RowBox[List["{", RowBox[List["t", ",", " ", "0", ",", " ", "10", ",", " ", "0.2"]], "}"]], Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox["]", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox["1", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox["]", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox["]", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]]]], StyleBox[";", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]]], "Input"], Cell["", "Text"], Cell[BoxData[RowBox[List[RowBox[List[StyleBox["Plot3D", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["[", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], RowBox[List[StyleBox[RowBox[List["intp", "[", RowBox[List["x", ",", "t"]], "]"]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[RowBox[List["{", RowBox[List["x", ",", RowBox[List["-", "5"]], ",", "5"]], "}"]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[RowBox[List["{", RowBox[List["t", ",", "0", ",", "10"]], "}"]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[RowBox[List["PlotPoints", "->", "30"]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[" ", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[RowBox[List["PlotRange", "->", RowBox[List["{", RowBox[List[RowBox[List["-", "1"]], ",", "1"]], "}"]]]], Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox[",", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["\n", Rule[FormatType, StandardForm], Rule[FontFamily, "Courier New"], Rule[FontSize, 10.5`]], StyleBox["    ", Rule[FormatType, StandardForm], Rule[FontSize, 11]], StyleBox[RowBox[List["AxesLabel", "->", RowBox[List["{", RowBox[List["\"x\"", ",", "\"t\"", ",", "\"p(x,t)\""]], "}"]]]], Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox["]", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]], StyleBox[";", Rule[FormatType, StandardForm], Rule[FontSize, 11]]]]], "Input"], Cell[BoxData[RowBox[List["A", " ", "3", "D", " ", "plot", " ", "of", " ", "the", " ", "pressure", " ", "distribution", " ", "in", " ", "the", " ", RowBox[List["duct", "."]]]]], "NumberedFigure"], Cell["\nLet us also plot the wave as a function of position x for a fixed point in time (t = 1.2) to observe the pressure distribution in more detail:", "Text"], Cell[BoxData[StyleBox[RowBox[List[RowBox[List["Plot", "[", RowBox[List[RowBox[List["intp", "[", RowBox[List["x", ",", "1.2"]], "]"]], ",", " ", RowBox[List["{", RowBox[List["x", ",", " ", RowBox[List["-", "5"]], ",", " ", "5"]], "}"]]]], "]"]], ";"]], Rule[FormatType, StandardForm], Rule[FontSize, 11]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["The", " ", "wave", " ", "as", " ", "a", " ", "function", " ", "of", " ", "position", " ", "at", " ", "time"]], " ", "=", " ", RowBox[List["1.2", "."]]]]], "NumberedFigure"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[791, 892]], Rule[WindowMargins, List[List[42, Automatic], List[Automatic, -25]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]