List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Arithmetic Array Operators", "Title"], Cell["\nArithmetic operators on arrays and certain combinations of arrays and scalars are available through the standard arithmetic operators addition (+), subtraction (-), division (/), multiplication as well as through the exponentiation (^) operator. ", "Text"], Cell[CellGroupData[List[Cell["Addition and Subtraction", "Section"], Cell["Strangely enough, elementwise operations for the combination of an array and a scalar operand are defined for multiplication and division but not for addition and subtraction.", "Text"], Cell[TextData[List["class AddSub\n  ", StyleBox["Real Add1 = {1, 2, 3} + 1;\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t// Not allowed! \n  ", StyleBox["Real Add2 = {1, 2, 3} + {1, 2};\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Not allowed, different array sizes!\n  Real Add3[2, 2] = {{1, 1}, {2, 2}} + {{1, 2}, {3, 4}};\t// Result: {{2, 3}, {5, 6}}\n  Real Sub1[3] = {1, 2, 3} - {1, 2, 0};\t\t\t\t\t\t// Result: {0, 0, 3}\nend AddSub;  "]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AddSub", "Subsection"], Cell["simulate( AddSub );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\nError: The dimensionalities of the parts\\\\n({1, 2, 3})   +   (1)\\\\nare 1 and 0, but they must be equal.\\\\nFound in equation equation\\\\nAdd1 = {1, 2, 3}+1;\\\\n\\\\nError: Type inconsistent definition equation\\\\nAdd1 = {1, 2, 3}+1;\\\\n\\\\nDeclared in class AddSub, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 2.\\\\nError: The dimensionalities of the parts\\\\n(Add2)   =   ({1, 2, 3}+{1, 2})\\\\nare 0 and 1, but they must be equal.\\\\n\\\\nError: Type inconsistent definition equation\\\\nAdd2 = {1, 2, 3}+{1, 2};\\\\n\\\\nDeclared in class AddSub, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 3.\\\\nBasic type inconsistencies detected\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Division", "Section"], Cell[TextData[List["class Div\n  Real Div1[1, 3], Div2, Div3;\nequation\n  Div1 = {2, 4, 6} / 2;\t\t\t\t\t\t\t\t\t// Result: {1, 2, 3}\n", StyleBox["  Div2 = 6 / {1, 2, 3};\t\t\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t// Not allowed!", StyleBox["\n  Div3 = {1, 2, 3} / {1, 2, 2};\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t// Not allowed!", "\nend Div;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Div", "Subsection"], Cell["simulate( Div );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\nError: The dimensionalities of the parts\\\\n(Div1)   =   (0.5*{2, 4, 6})\\\\nare 2 and 1, but they must be equal.\\\\nEquation found in class Div, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 5.\\\\n\\\\nError: The dimensionality of the denominator of \\\\n(6)   /   ({1, 2, 3})\\\\nis \\\\nThe denominator must be scalar.\\\\nFound in equation Div2 = 6/{1, 2, 3};\\\\n in class Div, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 6.\\\\n\\\\nError: The dimensionality of the denominator of \\\\n({1, 2, 3})   /   ({1, 2, 2})\\\\nis \\\\nThe denominator must be scalar.\\\\nFound in equation Div3 = {1, 2, 3}/{1, 2, 2};\\\\n in class Div, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo at line 7.\\\\n\\\\nBasic type inconsistencies detected\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Multiplication", "Section"], Cell["The array multiplication operator is only defined for vectors and matrices and has several different definitions depending on the type of its arguments. If both operands are vectors then array multiplication means scalar product, otherwise, if the operands are vectors or matrices then it means matrix multiplication. If one of the operands is a scalar, then the multiplication operation is defined as elementwise multiplication, which however is not available when both operands are arrays despite the fact that analogous elementwise operations are defined for addition and subtraction. The reason is that we have already used the multiplication notation (*) for the more common operation of matrix multiplication.\n", "Text"], Cell["class Multiplication\n  Real m1[3] = {1, 2, 3} * 2;\t\t\t\t\t\t\t\t\t// Elementwise mult: {2, 4, 6}; \n  Real m2[3] = 3 * {1, 2, 3};\t\t\t\t\t\t\t\t\t// Elementwise mult: {3, 6, 9};\n  Real m3 = {1, 2, 3} * {1, 2, 2};\t\t\t\t\t\t\t\t// Scalar product: \t 11;\n  Real m4[2] = {{1, 2}, {3, 4}} * {1, 2};\t\t\t\t\t\t// Matrix mult: \t {5, 11};\n  Real m5[1] = {1, 2, 3} * {{1}, {2}, {10}};\t\t\t\t\t// Matrix mult: \t {35};\n  Real m6[1] = {1, 2, 3} * [1; 2; 10];\t\t\t\t\t\t\t// Matrix mult:\t\t {35};\n  Real m7[2, 2] = {{1, 2}, {3, 4}} * {{1, 2}, {2, 1}};\t\t\t// Matrix mult: \t{{5, 4}, {11, 10}};\n  Real m8[2, 2] = [1, 2; 3, 4] * [1, 2; 2, 1];\t\t\t\t\t// Matrix mult: \t {{5, 4}, {11, 10}};\nend Multiplication;  ", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Multiplication", "Subsection"], Cell["simulate( Multiplication );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Multiplication\\) : 2004-1-30 13:44:8.0795922 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 21 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m2 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m2 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m2 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"m3\\\", HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m5 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m6 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m7 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m7 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m7 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m7 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m8 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m8 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m8 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m8 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Exponentiation", "Section"], Cell["Array exponentiation is the same as repeated matrix multiplication and is therefore only defined when the first operand is a square matrix and the second operand is a non-negative integer.", "Text"], Cell["class Exp\n  Real e1[2, 2];\n  Real e2[2, 2];\nequation\n  e1 = {{1, 2}, {1, 2}}\t\t^ 0;\t\t\t\t\t\t\t// Result: {{1, 0}, {0, 1}}\n  e2 = [1, 2; 1, 2]\t\t\t^ 2;\t\t\t\t\t\t\t// Result: {{3, 6}, {3, 6}}\nend Exp;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Multiplication", "Subsection"], Cell["simulate( Exp );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Exp\\) : 2004-1-30 13:44:36.2356620 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 10 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(e1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(e2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[861, 767]], Rule[WindowMargins, List[List[18, Automatic], List[Automatic, 23]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]