List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Built-in Array Functions", "Title"], Cell[CellGroupData[List[Cell["Array Dimension and Size Functions", "Section"], Cell[TextData[List["The following examples illustrate built-in functions that return the number of dimensions of an array (", StyleBox["ndims(A)", Rule[FontFamily, "Courier"]], "), the sizes of its dimensions (", StyleBox["size(A, i)", Rule[FontFamily, "Courier"]], "), or the size of a specific dimension (", StyleBox["size(A)", Rule[FontFamily, "Courier"]], ")."]], "Text"], Cell["class DimSize\n  Real dim = ndims(x);\t\t\t\t\t\t\t\t\t\t// Returns 3\n  Real dimsize = size(x, 1);\t\t\t\t\t\t\t\t// Returns 4\n  Real specsize[3] = size(x);\t\t\t\t\t\t\t\t// Returns the vector {4, 1, 6}\n  Real[4, 1, 6] x = fill(1, 4, 1, 6);\nequation  \n  size(2*x + x) = size(x);\t\t\t\t\t\t\t\t\t// This equation holds\nend DimSize;  ", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of DimSize", "Subsection"], Cell["simulate( DimSize );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(DimSize\\) : 2004-1-30 13:46:56.2167846 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 31 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"dim\\\", HoldForm], \\*TagBox[\\\"dimsize\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(specsize \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(specsize \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(specsize \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(1, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(2, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(3, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(x \[LeftDoubleBracket] \\(\\(4, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["x", "\[LeftDoubleBracket]", RowBox[List["4", ",", "1", ",", "4"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Dimensionality Conversion Functions", "Section"], Cell["The following conversion functions convert scalars, vectors, and arrays to scalars or matrices by adding or removing 1-sized dimensions.", "Text"], Cell["class DimConvert\n  Real[3] \t\t\tv1 = {1.0, 2.0, 3.0};\t\n  Real[3, 1]\t\tm1 = matrix(v1);\t\t\t\t\t\t// m1 contains {{1.0}, {2.0}, {3.0}}\n  Real[3]\t\t\tv2 = vector(m1);\t\t\t\t\t\t// v2 contains {1.0, 2.0, 3.0}\n  \n  Real[1, 1, 1] \tm2 = {{{4}}};\n  Real \t\t\t\ts1 = scalar(m2);\t\t\t\t\t\t// s1 contains 4.0\n  Real[2, 2, 1]\t\tm3 = {{{1.0}, {2.0}}, {{3.0}, {4.0}}};\t\n  Real[2, 2]\t\tm4 = matrix(m3);\t\t\t\t\t\t// m4 contains {{1.0, 2.0}, {3.0, 4.0}}\nend DimConvert;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of DimConvert", "Subsection"], Cell["simulate( DimConvert );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(DimConvert\\) : 2004-1-30 13:47:14.7004498 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 21 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m1 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m2 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m3 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m3 \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m3 \[LeftDoubleBracket] \\(\\(2, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m3 \[LeftDoubleBracket] \\(\\(2, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(m4 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"s1\\\", HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["m1", "\[LeftDoubleBracket]", RowBox[List["3", ",", "1"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Specialized Constructor Functions", "Section"], Cell["An array constructor function constructs and returns an array computed from its arguments. Most of the constuctor functions in the table below construct an array by filling in vaulues according to a certain pattern. ", "Text"], Cell["class ConstructFunc\n  Real z[2, 3]\t \t\t= zeros(2, 3);\t\t\t\t// Constructs the matrix {{0, 0, 0}, {0, 0, 0}}\n  Real o[3] \t\t\t= ones(3);\t\t\t\t\t// Constructs the vector {1, 1, 1}\n  Real f[2, 2]\t\t\t= fill(2.1, 2, 2);\t\t\t// Constructs the matrix {{2.1, 2.1}, {2.1, 2.1}}\n  Boolean check[3, 4]\t= fill(true, 3, 4);\t\t\t// Fills a Boolean matrix\n  Real id[3, 3]\t\t\t= identity(3);\t\t\t\t// Creates the matrix {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}\n  Real di[3, 3] \t\t= diagonal({1, 2, 3});\t\t// Creates the matrix {{1, 0, 0}, {0, 2, 0}, {0, 0, 3}}\n  Real ls[5] \t\t\t= linspace(0.0, 8.0, 5);\t// Computes the vector {0.0, 2.0, 4.0, 6.0, 8.0}\nend ConstructFunc;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ConstructFunc", "Subsection"], Cell["simulate( ConstructFunc );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ConstructFunc\\) : 2004-1-30 13:47:35.9183850 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 50 variables>\\n\\!\\({\\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(check \[LeftDoubleBracket] \\(\\(3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(di \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(id \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(ls \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(ls \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(ls \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(ls \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(ls \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(o \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(o \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(o \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(z \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["di", "\[LeftDoubleBracket]", RowBox[List["3", ",", "2"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Reduction Functions", "Section"], Cell["An array reduction function \"reduces\" an array to a scalar value, i.e. computes a scalar value from the array.", "Text"], Cell["class Reduce\n  Real minimum, maximum, summ, prod;\nequation\n  minimum = min({1, -1, 7});\t\t\t\t\t\t\t// Gives the vaule -1\n  maximum = max([1, 2, 3; 4, 5, 6]);\t\t\t\t\t// Gives the value 6\n  summ \t  = sum({{1, 2, 3}, {4, 5, 6}});\t\t\t\t// Gives the value 21\n  prod \t  = product({3.14, 2, 2});\t\t\t\t\t\t// Gives the value 12.56\nend Reduce;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Reduce", "Subsection"], Cell["simulate( Reduce );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Reduce\\) : 2004-1-30 13:48:10.4483090 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 6 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"maximum\\\", HoldForm], \\*TagBox[\\\"minimum\\\", HoldForm], \\*TagBox[\\\"prod\\\", HoldForm], \\*TagBox[\\\"summ\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List["summ", "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Matrix and Vector Algebra Functions", "Section"], Cell["The following set of functions are rather common in matrix and vector algebra, but are not associated with any Modelica operator symbol. ", "Text"], Cell["class AlgebraFunc\n  Real transp1[2, 2] \t= transpose([1, 2; 3, 4]);\t\t\t // Gives [1, 2; 3, 4] of type Integer[2, 2]  \n  Real transp2[2, 2, 1] = transpose({{{1},{2}},{{3},{4}}}); \n  \t\t\t\t\t\t\t\t\t\t\t\t\t\t // Gives {{{1},{2}},{{3},{4}}} of type Integer[2, 2, 1]\n  Real out[2, 2] \t\t = outerProduct({2, 1}, {3, 2});\t // Gives {{6, 4}, {3, 2}} \n  Real symm[2, 2]\t     = symmetric({{1, 2}, {3, 1}});\t     // Gives {{1, 2}, {2, 1}} \n  Real c[3]\t\t\t\t = cross({1, 0, 0}, {0, 1, 0});\t     // Gives {0, 0, 1}\n  Real s[3, 3]\t\t\t = skew({1, 2, 3});\t\t\t\t\t // Gives {{0, -3, 2}, {3, 0, -1}, {-2, 1, 0}};\nend AlgebraFunc;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AlgebraFunc", "Subsection"], Cell["simulate( AlgebraFunc );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AlgebraFunc\\) : 2004-1-30 13:48:25.1821182 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 30 variables>\\n\\!\\({\\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(out \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(out \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(out \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(out \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(symm \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(symm \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(symm \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(symm \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp2 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp2 \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp2 \[LeftDoubleBracket] \\(\\(2, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(transp2 \[LeftDoubleBracket] \\(\\(2, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["transp2", "\[LeftDoubleBracket]", RowBox[List["2", ",", "1", ",", "1"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[954, 894]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]