List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Array Concatenation and Construction", "Title"], Cell[TextData[List["\nGeneral array concatenation can be done through the array concatenation operator ", StyleBox["cat(k, A, B, C, ...)", Rule[FontFamily, "Courier"]], " that concatenates the arrays A, B, C, .... along the k:th dimension. Concatenating along the first dimension is to concate rows and the second dimension is to concatenate colums."]], "Text"], Cell[CellGroupData[List[Cell["Class Concat", "Section"], Cell[TextData[List["class Concat\n  Real[5] c1 ", StyleBox["= cat(1, {1, 2}, {10, 12, 13});\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Result: {1, 2, 10, 12, 13}\n  Real[2, 3] c2", StyleBox[" = cat(2, {{1, 2}, {3, 4}}, {{10}, {11}});\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Result: {{1, 2, 10}, {3, 4, 11}}\nend Concat;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Concat", "Subsection"], Cell["simulate( Concat );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Concat\\) : 2004-1-30 13:34:0.5799222 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 13 variables>\\n\\!\\({\\*TagBox[\\(c1 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c1 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c1 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c1 \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c1 \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c2 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["c1", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["More Concatenation", "Section"], Cell["A matrix can be constructed from scalar expressions by separating rows by semicolon and columns by comma.  The previous example of concatenation along the second dimension can be expressed like this:", "Text"], Cell[TextData[List["class Concat2\n  Real[2, 3] c3 ", StyleBox["= cat(2, [1, 2; 3, 4], [10; 11]);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Same result: {{1, 2, 10}, {3, 4, 11}}\nend Concat2;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Concat2", "Subsection"], Cell["simulate( Concat2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Concat2\\) : 2004-1-30 13:34:22.1113100 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c3 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["c3", "\[LeftDoubleBracket]", RowBox[List["1", ",", "3"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Type Rules for Concatenation", "Section"], Cell[TextData[List["The arrays that is concatenated must have the same number of dimensions. ", "The concatenation dimension k must exist", ". A", "rrays must have identical dimension sizes with the exception of the size of dimension k, which is called ", StyleBox["Size matching. ", Rule[FontSlant, "Italic"]], "Argument arrays must have e", "quivalent maximally expanded element types. The element type of the result array is the element type of the maximally expanded type of the arguments. These rules make it possible to mix integers and real numbers as in the example below:", "\n"]], "Text"], Cell[TextData[List["class Concat3\n  Real[2, 3] r1  ", StyleBox["= cat(1, {{1.0, 2.0, 3}}, {{4, 5, 6}});", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  Real[2, 6] r2 ", StyleBox[" = cat(2, r1, r1);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend Concat3;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Concat3", "Subsection"], Cell["simulate( Concat3 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Concat3\\) : 2004-1-30 13:34:47.2989712 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 20 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r1 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r2 \[LeftDoubleBracket] \\(\\(2, 6\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["r2", "\[LeftDoubleBracket]", RowBox[List["1", ",", "3"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Concatenating Larger Arrays", "Section"], Cell[TextData[List["class Concat4\n  Real[1, 1, 1] A = {{{1}}};\n  Real[1, 1, 2] B = {{{2, 3}}};\n  Real[1, 1, 3] C = {{{4, 5, 6}}};\n  Real[1, 1, 6] R ", StyleBox["= cat(3, A, B, C);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Result value: {{{1, 2, 3, 4, 5, 6}}};\nend Concat4;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Concat4", "Subsection"], Cell["simulate( Concat4 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Concat4\\) : 2004-1-30 13:34:53.3927602 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 14 variables>\\n\\!\\({\\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(C \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(C \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(C \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(R \[LeftDoubleBracket] \\(\\(1, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["C", "\[LeftDoubleBracket]", RowBox[List["1", ",", "1", ",", "2"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[895, 924]], Rule[WindowMargins, List[List[14, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]