List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Using Array Concatenation and Slices", "Title"], Cell["\nThe following usage examples show a few common programming situations where both array concatenation and array slices are involved, and how to do this correctly in order to avoid certain mistakes. ", "Text"], Cell[CellGroupData[List[Cell["Appending an Element to Vectors and Row/Column Matrices", "Section"], Cell["The first equations set XA1, XA2, XA3 and XA4 equal to row matrics and XB1, XB2 equal to column matrices respectively, created by appending an additional element to row/column matrices PA and PB.", "Text"], Cell[TextData[List["class AppendElement\n  Real[1, 3] \t\tPA = [1, 2, 3];\t\t\t\t// A row matrix value\n  Real[3, 1] \t\tPB = [1; 2; 3];\t\t\t\t// A column matrix value\n  Real[3] \t\t\tq  = {1, 2, 3};\t\t\t\t// A vector value\n  \n  Real[1, 4] \t\tXA1, XA2, XA3, XA4;\t\t\t// Row matrix variables\n  Real[4, 1] \t\tXB1, XB2;\t\t\t\t\t// Column matrix variables\n  Real[4]\t\t\ty;\t\t\t\t\t\t\t// Vector variable\n  \nequation\n  XA1 = [PA, 4];\t\t\t\t\t\t\t\t// Append OK, since 4 is promoted to {{4}}\n  XA2 = cat(2, PA, {{4}});\t\t\t\t\t\t// Append OK, same as above but not promoted\n\n  XB1 = [PB; 4];\t\t\t\t\t\t\t\t// Append OK, result is {{1}, {2}, {3}, {4}}\n  XB2 = cat(1, PB, {{2}});\t\t\t\t\t\t// Append OK, same result\n  \n  y   = cat(1, q, {4});\t\t\t\t\t\t\t// Vector append OK, result is {1, 2, 3, 4}", StyleBox["\n", Rule[FontColor, RGBColor[1, 0, 0]]], "  \n  XA3 = [-1, zeros(1, 2), 1];\t\t\t\t\t// Append OK, result is {{-1, 0, 0, 1}}\n  XA4 = cat(2, {{-1}}, zeros(1, 2), {{1}} );\t// Append OK, result is {{-1, 0, 0, 1}}\n\nend AppendElement;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AppendElement", "Subsection"], Cell["simulate( AppendElement );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AppendElement\\) : 2004-2-4 10:58:5.7478177 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 39 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(PA \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(PA \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(PA \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(PB \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(PB \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(PB \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(q \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(q \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(q \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA1 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA1 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA2 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA3 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA3 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA3 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA3 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA4 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA4 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA4 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XA4 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB1 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB1 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB2 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(XB2 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[CellGroupData[List[Cell[BoxData[RowBox[List[RowBox[List["y", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData["3.`"], "Output"]], Open]]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Composing a Blocked Matrix Board from Submatrices", "Section"], Cell["The following example shows three very similar ways of constructing a blocked matrix from submatrices. The first two variants follow the rule of always making sure that returned array slices as arguments to the special purpose concatenation operators are matrices. The third variant breaks this rule, since two of the array slices return vectors, causing an error. ", "Text"], Cell[CellGroupData[List[Cell["BlockMatrix", "Subsection"], Cell[TextData[List["class BlockMatrix\n ", StyleBox[" Real[3, 3]\tP = [1, 2, 3; \n  \t\t\t\t\t 4, 5, 6; \n  \t\t\t\t\t 7, 8, 9];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// A 3x3 matrix value\n  ", StyleBox["Real[6, 6]\tQ;\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Q consists of four 3x3 matrix blocks to be defined\n\t\t\t\t\t\t\t\t\t\t\t\t// by P apart from sign\t\t\t\t\t\t\t\t\t\t\nequation\n  ", StyleBox["Q[1:3, 1:3] = P;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Upper left block\n  ", StyleBox["Q[1:3, 4:6] = [Q[1:3, 1:2], -Q[1:3, {3}]];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Upper right block\n  ", StyleBox["Q[4:6, 1:3] = [Q[1:2, 1:3], -Q[{3}, 1:3]];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Lower left block\n ", StyleBox[" Q[4:6, 4:6] = P;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Lower right block\nend BlockMatrix;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["BlockMatrix2", "Subsection"], Cell[TextData[List["class BlockMatrix2\n  Real[3, 3]\tP = [1, 2, 3; \n  \t\t\t\t\t 4, 5, 6; \n  \t\t\t\t\t 7, 8, 9];\t\t\t\t\n  Real[6, 6]\tQ;\t\t\t\t\t\t\t\t\nequation\n  ", StyleBox["Q[1:3, 1:3] = P;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Upper left block\n  ", StyleBox["Q[1:3, 4:6] = [Q[1:3, 1:2], -Q[1:3, 3:3]];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Upper right block\n  ", StyleBox["Q[4:6, 1:3] = [Q[1:2, 1:3], -Q[3:3, 1:3]];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// Lower left block\n ", StyleBox[" Q[4:6, 4:6] = P;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Lower right block\nend BlockMatrix2;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["BlockMatrix3", "Subsection"], Cell[TextData[List["class BlockMatrix3\n  Real[3, 3]\tP = [1, 2, 3; \n  \t\t\t\t \t 4, 5, 6; \n  \t\t\t\t \t 7, 8, 9];\t\t\t\t\n  Real[6, 6]\tQ;\t\t\t\t\t\t\t\t\t\nequation\n  ", StyleBox["Q[1:3, 1:3] = P;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t// OK!\n ", StyleBox[" Q[1:3, 4:6] = [Q[1:3, 1:2], -Q[1:3, 3]];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// OK, correct promotion\n", StyleBox["  Q[4:6, 1:3] = [Q[1:2, 1:3], -Q[3, 1:3]];\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// ERROR!\n  ", StyleBox["Q[4:6, 4:6] = P;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// OK!\nend BlockMatrix3;"]], "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Cyclic Permutation of Matrix Rows or Columns", "Section"], Cell["Cyclic permutation can be achieved by a combination of concatenation operations and array slices or just array slices using a permutation vector.", "Text"], Cell[TextData[List["class CyclicPerm\n  Real[1, 3] WO = [1, 2, 3];\t\t\t\t\t// Row matrix\n  Real[2, 3] XO = [1, 2, 3; 4, 5, 6];\t\t\t// Matrix with two rows\n  \n  Real[1, 3] W;\t\t\t\t\t\t\t\t\t// Permuted row matrix\n  Real[2, 3] X;\t\t\t\t\t\t\t\t\t// Permuted matrix with two rows\n  \n  Integer[3] p = {2, 3, 1};\t\t\t\t\t\t// Permutation vector\n  \nalgorithm\n  W := [[2, 3], 1];\t\t\t\t\t\t\t\t// OK, result: [2, 3, 1] = {{2, 3, 1}}\n  W := [{{2, 3}}, {{1}}];\t\t\t\t\t\t// OK, same result: {{2, 3, 1}}\n  \n  W := [WO[{1}, 2:3], WO[{1}, {1}]];\t\t\t// OK, result: {{2, 3, 1}}\n  W := [WO[1:1, 2:3], WO[1:1, 1:1]];\t\t\t// OK, same result: {{2, 3, 1}}\n  \n  W := WO[:, p];\t\t\t\t\t\t\t\t// OK, same result: {{2, 3, 1}}\n\n  W := cat(2, WO[1:1, 2:3], WO[1:1, 1:1]);\t\t// OK, same result: {{2, 3, 1}}\n", StyleBox["  W := [WO[1, 2:3], WO[1, 1]];\t\t\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// Error, since WO[1, 2:3] is a vector\n\n  X := [XO[:, 2:3], XO[:, {1}]];\t\t\t\t// OK, X becomes [2, 3, 1; 5, 6, 4]\n  X := XO[:, p];\t\t\t\t\t\t\t\t// OK, X becomes [2, 3, 1; 5, 6, 4]\n  \n  X[{1}, :] := [XO[{1}, 2:3], XO[{1}, {1}]];\t// OK, X becomes [2, 3, 1; 5, 6, 4]\n ", StyleBox[" X[1, :] := [XO[1, 2:3], XO[1, 1]];\t\t\t", Rule[FontColor, RGBColor[1, 0, 0]]], "// ERROR, incompatible dimensions\nend CyclicPerm;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of CyclicPerm", "Subsection"], Cell["simulate( CyclicPerm );", "ModelicaInput"], Cell[BoxData[RowBox[List[RowBox[List["Simulate", "::", "insmd"]], RowBox[List[":", " "]], "\"Simulate failed to instantiate model.\""]]], "Message"], Cell[BoxData[RowBox[List[RowBox[List["ShowLog", "::", "shlg"]], RowBox[List[":", " "]], "\"\\!\\(\\\"Instantiation started\\\\n\\\\nLogged connection equations:\\\\n  0 default connections generated.\\\\nError: The dimensionalities of the parts\\\\n(X[1, :])   =   ([XO[1, 2:3], XO[1, 1]])\\\\nare 1 and 2, but they must be equal.\\\\nEquation found in class CyclicPerm, c:\\\\\\\\cvsroot\\\\\\\\mathmo~1\\\\\\\\workdir\\\\\\\\model.mo\\\\n   at line 19.\\\\n\\\\nBasic type inconsistencies detected\\\\nTranslation aborted.\\\\n- savelog\\\\n\\\"\\).\""]]], "Message"], Cell[BoxData["$Failed"], "Output"]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[912, 912]], Rule[WindowMargins, List[List[4, Automatic], List[Automatic, -2]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]