List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["General Array Construction", "Title"], Cell[TextData[List["\nAn array constructor is just a function accepting scalar or array arguments and returning an array result. The array constructor function ", StyleBox["array(A,B,C,...)", Rule[FontFamily, "Courier"]], ", with short hand notation ", StyleBox["{A, B, C, ...}", Rule[FontFamily, "Courier"]], ", constructs an array from its arguments according to certain rules.\n"]], "Text"], Cell[CellGroupData[List[Cell["Constructing Arrays", "Section"], Cell["type Angle = Real(unit=\"rad\");\t\t\t\t\t// The type Angle is a subtype of Real  ", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class ArrayConstruction\n  ", StyleBox["Integer[3] \ta = {1, 2, 3};", Rule[FontColor, RGBColor[0, 0, 1]]], " \t\t\t\t\t\t// A 3-vector of type Integer[3]\n  ", StyleBox["Real[3]\t\tb = array(1.0, 2.0, 3);\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// A 3-vector of type Real[3]\n\n  ", StyleBox["Integer[2,3] c = {{11, 12, 13}, {21, 22, 23}}; ", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// A 2x3 matrix of type Integer[2,3] \n  ", StyleBox["Real[1,1,3]  d ={{{1.0, 2.0, 3.0}}}; \t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// A 1x1x3 array of type Real[1,1,3]\n\n  ", StyleBox["Real[3] v = array(1, 2, 3.0);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// The vector v is equal to {1.,2.,3.}\n\n  ", StyleBox["parameter Angle alpha = 2.0;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// The expanded type of alpha is Real\n  ", StyleBox["Real[3] f = array(alpha, 2, 3.0);\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// A 3-vector of type Real[3] \n  ", StyleBox["Angle[3] A = {1.0, alpha, 4}; ", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// The expanded type of A is Real[3]\nend ArrayConstruction;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ArrayConstruction", "Subsection"], Cell["simulate( ArrayConstruction );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ArrayConstruction\\) : 2004-1-30 13:29:15.9670452 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 27 variables>\\n\\!\\({\\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[Alpha]\\\", HoldForm], \\*TagBox[\\(b \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(b \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(b \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(c \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(d \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(d \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(d \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(f \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["d", "\[LeftDoubleBracket]", RowBox[List["1", ",", "1", ",", "1"]], "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Range Vector Construction", "Section"], Cell["A range vector is a vector containing a range of numeric values increasing or decreasing by a fixed increment or decrement value for each additional element. For example, {1, 2, 3} is an Integer range vector starting at 1 and increasing by 1 for each element.\n", "Text"], Cell[TextData[List["class Range\n  ", StyleBox["Real v1[5] \t\t\t= 2.7 : 6.8;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// v1 is {2.7, 3.7, 4.7, 5.7, 6.7}\n  ", StyleBox["Real v2[5] \t\t\t= {2.7, 3.7, 4.7, 5.7, 6.7};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// v2 is equal to v1\n  \n  ", StyleBox["Integer v3[3] \t\t= 3 : 5;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// v3 is {3, 4, 5}\t\n  ", StyleBox["Integer v4empty[0] \t= 3 : 2;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// v4empty is an empty Integer vector \n  \n  ", StyleBox["Real v5[4] \t\t\t= 1.0 : 2 : 8;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// v5 is {1.0, 3.0, 5.0, 7.0}\n  ", StyleBox["Integer v6[5] \t\t= 1 : -1 : -3;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// v6 is {1, 0, -1, -2, -3}\n  ", StyleBox["Real[0] v7none;\t\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// v7 none is an empty Real vector \nend Range;  "]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Range", "Subsection"], Cell["simulate( Range );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Range\\) : 2004-1-30 13:29:26.3265528 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 24 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v1 \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v2 \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v3 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v3 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v3 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v5 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v5 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v5 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v5 \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v6 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v6 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v6 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v6 \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(v6 \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["v3", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[903, 924]], Rule[WindowMargins, List[List[4, Automatic], List[Automatic, -2]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]