List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Array Declarations", "Title"], Cell[CellGroupData[List[Cell["Declaring Arrays in one way", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["\nAn array variable can be declared by appending dimensions within square brackets after a type name or after a variable name.", "Text"], Cell[TextData[List["class ArrayDim\n  parameter Integer n = 1, m = 4, k = 5;\n  ", StyleBox["Real[3]\t\t positionvector = {1, 2, 3};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// 3-dimensional position vector\n  ", StyleBox["Real[3,3]\t\t identitymatrix = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// transformation matrix\n  ", StyleBox["Integer[n,m,k] arr3d = fill(1,n,m,k);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t\t// A 3-dimensional array\n  ", StyleBox["Boolean[2]\t truthvalues \t= {false, true};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// A boolean vector\n  ", StyleBox["Voltage[10]\t voltvector = fill(10, 10);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// A vector of voltage values\nend ArrayDim;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ArrayDim", "Subsection"], Cell["simulate( ArrayDim );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ArrayDim\\) : 2004-1-30 13:23:30.0506144 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 49 variables>\\n\\!\\({\\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\\"m\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(truthvalues \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(truthvalues \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(9\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["voltvector", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Declaring Arrays in another way", "Section"], Cell["The same declarations can be expressed as:", "Text"], Cell[TextData[List["class ArrayDim2\n  parameter Integer n = 1, m = 4, k = 5;\n  ", StyleBox["Real\t\t\tpositionvector[3] \t= {1, 2, 3};\t\t\t\t\t\n  Real\t\t\tidentitymatrix[3,3] = {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}};\t\t\n  Integer\t\tarr3d[n,m,k] = fill(1,n,m,k);\t\t\t\t\t\t\t\t\t\t\t\t\t\n  Boolean\t\ttruthvalues[2] \t\t= {false, true};\t\t\t\t\t\t\t\n  Voltage\t\tvoltvector[10] = fill(10, 10);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t\t\t\t\nend ArrayDim2;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ArrayDim", "Subsection"], Cell["simulate( ArrayDim2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ArrayDim2\\) : 2004-1-30 13:23:39.3941850 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 49 variables>\\n\\!\\({\\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(arr3d \[LeftDoubleBracket] \\(\\(1, 4, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(identitymatrix \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"k\\\", HoldForm], \\*TagBox[\\\"m\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(positionvector \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(truthvalues \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(truthvalues \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(voltvector \[LeftDoubleBracket] \\(\\(9\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["voltvector", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Declaring Row Matrices and Column Matrices", "Section"], Cell["Column matrices and row matrices can be declared as below:", "Text"], Cell[TextData[List["class ColRowMatrix\n  parameter Integer n = 3;\n  ", StyleBox["Real[n, 1] colmat = fill(1, n, 1);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Column matrix\n ", StyleBox[" Real[1, n] rowmat = fill(1, 1, n);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Row matrix\nend ColRowMatrix;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ArrayDim", "Subsection"], Cell["simulate( ColRowMatrix );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ColRowMatrix\\) : 2004-1-30 13:23:45.4878180 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 9 variables>\\n\\!\\({\\*TagBox[\\(colmat \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(colmat \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(colmat \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(rowmat \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(rowmat \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(rowmat \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["colmat", "\[LeftDoubleBracket]", RowBox[List["3", ",", "1"]], "\[RightDoubleBracket]"]], "[", "1", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Declaring Empty Arrays", "Section"], Cell[TextData[List["It is also allowed to declare empty arrays. An ", ButtonBox["Empty Array", RuleDelayed[ButtonData, List["Empty.nb", None]], Rule[ButtonStyle, "Hyperlink"]], " has at least one dimension of size 0 and contains no array elements."]], "Text"], Cell[TextData[List["class Empty\n  ", StyleBox["Real[0, 3]\tM;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// An empty matrix M\n  ", StyleBox["Integer\t\tx[0];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// An empty vector x\nend Empty;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[885, 924]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]