List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Empty Arrays", "Title"], Cell["\nEmpty arrays can function as a kind of null element for certain general operations such as concatenation operations or general formulations of certain kinds of equation systems. An empty array can not be constructed by { } or [ ]. Instead an empty array is created using some other constructor from which the type can be deduced, or explicilty declared as a variable. Array variables of unspecified size can be set equal to or assigned empty array values.\n", "Text"], Cell[CellGroupData[List[Cell["Empty Arrays", "Section"], Cell["class Empty\n  Real f[0] = fill(1., 0);\t\t\t\t\t\t\t// An empty vector of type Real[0] since 1. is Real\n  Real x[0];\t\t\t\t\t\t\t\t\t\t// An empty vector variable x of type Real[0]\n  \n  Real[0, 3] A;\t\t\t\t\t\t\t\t\t\t// An empty matrix variable A\n  Real B[5, 0], C[0, 0];  \t\t\t\t\t\t\t// Empty matrices B and C\n  \n  Real A[:, :]\t\t\t= fill(0.0, 0, 1);\t\t\t// A Real 0 x 1 matrix \n  Boolean B[:, :, :] \t= fill (false, 0, 1, 0);\t// A Boolean 0 x 1 x 0 array\nend Empty;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Empty", "Subsection"], Cell["simulate( Empty );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Empty\\) : 2004-1-30 13:49:49.7882442 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 2 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Adding Empty Arrays", "Section"], Cell[TextData[List["class AddEmpty\n  Real[3, 0] A, B;\n  Real[0, 0] C;", StyleBox["\t\n  ", Rule[FontColor, RGBColor[1, 0, 0]]], "Real ab[3, 0] = ", StyleBox["A + B;\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Fine, the result is an empty matrix of type Real[3, 0]\n  //", StyleBox["Real ac = A + C;", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t\t\t\t// Error, incompatible types Real[3, 0] and Real[0, 0]\t\t\t\nend AddEmpty;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AddEmpty", "Subsection"], Cell["simulate( AddEmpty );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(AddEmpty\\) : 2004-1-30 13:50:1.4752954 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 2 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Using Empty Arrays", "Section"], Cell[TextData[List["The ", StyleBox["ABCDsystem", Rule[FontFamily, "Courier"]], " model below shows how the equation section will shrink to ", StyleBox["y = D*u", Rule[FontFamily, "Courier"]], " when some variables are empty arrays."]], "Text"], Cell[TextData[List["model ABCDsystem\n  parameter Integer n = 0;\n  Real u[5] = {15, 4, 3, 9, 11};\n  Real x[n];\n  Real y[3];\n  Real A[n, n], B[n, 5], C[3, n];\n  Real D[3, 5] = fill(1, 3, 5);\nequation\n  ", StyleBox["der(x) = A*x + B*u;\t\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// This will disappear since x is empty ", StyleBox["\n  y = C*x + D*u;\t\t\t\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Which is: y = D*u\nend ABCDsystem;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of AddEmpty", "Subsection"], Cell["simulate( ABCDsystem );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ABCDsystem\\) : 2004-1-30 13:50:19.0058722 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 26 variables>\\n\\!\\({\\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(D \[LeftDoubleBracket] \\(\\(3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"n\\\", HoldForm], \\*TagBox[\\(u \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(u \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(u \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(u \[LeftDoubleBracket] \\(\\(4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(u \[LeftDoubleBracket] \\(\\(5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(y \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["D", "\[LeftDoubleBracket]", RowBox[List["2", ",", " ", "2"]], "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["y", "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"], Cell[BoxData[RowBox[List[RowBox[List["u", "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[914, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]