List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Exercise 1", "Title"], Cell[CellGroupData[List[Cell["Question", "Section"], Cell["Which are the type rules for concatenation?", "Text"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell[TextData[List["The arrays that is concatenated must have the same number of dimensions.\nThe concatenation dimension k, that you use, must exist.\nArrays must have identical dimension sizes with the exception of the size of dimension k", StyleBox["\n", Rule[FontSlant, "Italic"]], "Argument arrays must have equivalent maximally expanded element types, where the element type of the result array is the element type of the maximally expanded type of the arguments."]], "Text"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Considering Array Concatenation", "Section"], Cell["What will be the result of the arrays below?", "Text"], Cell["class ArrayConcatenation\n  Real[2, 3] array1 = cat(2, [22, 34; 66, 78], [15; 52]);\n  Real[2, 3] array2 = cat(2, {{22, 34}, {66, 78}}, {{15}, {52}});\n  \n  Real[2, 2] array3 = cat(1, {{11, 12}}, {{13, 14}});\n  Real[3, 2] array4 = cat(1, {{7, 2}, {5, 42}}, {{24, 74}});\n  Real[3, 2] array5 = cat(1, [7, 2; 5, 42], [24, 74]);\n\n  Real[4, 2] array6 = cat(1, {{1, 2}, {11, 12}}, {{13, 14}, {3, 4}});\t\n  Real[2,4] array7 = cat(2, {{1, 2}, {72, 51}}, {{35, 73}, {12, 23}});\nend ArrayConcatenation;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell[CellGroupData[List[Cell["array1", "Subsubsection"], Cell["array1 has the result {{22, 34, 15}, {66, 78, 52}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array2", "Subsubsection"], Cell["array2 has the result {{22, 34, 15}, {66, 78, 52}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array3", "Subsubsection"], Cell["array3 has the result {{11, 12}, {13, 14}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array4", "Subsubsection"], Cell["array4 has the result {{7, 2}, {5, 42}, {24, 74}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array5", "Subsubsection"], Cell["array5 has the result {{7, 2}, {5, 42}, {24, 74}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array6", "Subsubsection"], Cell["array6 has the result {{1, 2}, {11, 12}, {13, 14}, {3, 4}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["array7", "Subsubsection"], Cell["array7 has the result {{1, 2, 35, 73}, {72, 51, 12, 23}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["Simulation of ArrayConcatenation", "Subsubsection"], Cell["simulate( ArrayConcatenation );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ArrayConcatenation\\) : 2004-2-4 10:54:33.4706435 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 46 variables>\\n\\!\\({\\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array1 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array2 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array3 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array3 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array3 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array3 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array4 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array5 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array6 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(array7 \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Closed]]], Closed]]], Open]], Cell[CellGroupData[List[Cell[TextData[List["Using ", StyleBox["cat", Rule[FontFamily, "Courier"], Rule[FontWeight, "Bold"]]]], "Section"], Cell[TextData[List["Now it is your turn to concatenate arrays using ", StyleBox["cat", Rule[FontFamily, "Courier"]], ":\n\nConcatenate two 1x2-arrays along the first dimension.\nConcatenate the arrays you just concatenated, but along the second dimension.\nConcatenate one 2x3-array with a 2x1-array along the second dimension.\nConcatenate two 2x2-arrays along the first dimension.\n\nWhat are the results of the array concatenations?\n"]], "Text"], Cell["class MyArrayConcat\n  \nend MyArrayConcat;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["These are examples of how you could concatenate the arrays in the exercise.", "Text"], Cell["class MyArrayConcat\n  Real[2, 2] myArray1 = cat(1, {{1, 2}}, {{11, 12}});\n  Real[1, 4] myArray2 = cat(2, {{1, 2}}, {{11, 12}});\n  \n  Real[2, 4] myArray3 = cat(2, [21, 32, 43; 66, 77, 55], [12; 24]);\n  Real[4, 2] myArray4 = cat(1, [10, 40; 55, 78], [20, 50; 31, 22]);\nend MyArrayConcat;", "ModelicaInput"], Cell[CellGroupData[List[Cell["myArray1", "Subsubsection"], Cell["myArray1 has the result {{1, 2}, {11, 12}}", "Text"]], Open]], Cell[CellGroupData[List[Cell["myArray2", "Subsubsection"], Cell["myArray2 has the result {{1, 2, 11, 12}}", "Text"]], Open]], Cell[CellGroupData[List[Cell["myArray3", "Subsubsection"], Cell["myArray3 has the result {{21, 32, 43, 12}, {66, 77, 55, 24}}", "Text"]], Open]], Cell[CellGroupData[List[Cell["myArray4", "Subsubsection"], Cell["myArray4 has the result {{10, 40}, {55, 78}, {20, 50}, {31, 22}}", "Text"]], Open]], Cell[CellGroupData[List[Cell["Simulation of", "Subsubsection"], Cell["simulate( MyArrayConcat );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MyArrayConcat\\) : 2004-2-4 10:54:39.9705187 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 26 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(myArray1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray2 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray3 \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(myArray4 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Closed]]], Closed]]], Open]], Cell[CellGroupData[List[Cell["More Dimensions", "Section"], Cell[TextData[List["The last thing you should do now is to concatenate three arrays with higher dimension. ", "\n\nSo, the arrays you should concatenate are of size 1x2x1, 1x2x2 and 1x2x3 and they should be concatenated along the first dimension. Do the concatenation in the class ", StyleBox["MoreConcat", Rule[FontFamily, "Courier"]], " below.\n\nWhat is the result after the concatenations?\n"]], "Text"], Cell["class MoreConcat\n  \nend MoreConcat;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Answer", "Subsection"], Cell["This is an example of how you could concatenate the arrays in the exercise.", "Text"], Cell["class MoreConcat\n  Real[1, 2, 1] a1 = {{{1}, {2}}};\n  Real[1, 2, 2] a2 = {{{3, 4}, {5, 6}}};\n  Real[1, 2, 3] a3 = {{{7, 8, 9}, {10, 11, 12}}};\n  Real[1, 2, 6] aReady;\nequation\n  aReady = cat(3, a1, a2, a3);\nend MoreConcat;", "ModelicaInput"], Cell[CellGroupData[List[Cell["aReady", "Subsubsection"], Cell["aReady has the result {{1, 3, 4, 7, 8, 9}, {2, 5, 6, 10, 11, 12}}", "Text"]], Closed]], Cell[CellGroupData[List[Cell["Simulation of MoreConcat", "Subsubsection"], Cell["simulate( MoreConcat );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MoreConcat\\) : 2004-2-4 10:54:46.6735150 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 26 variables>\\n\\!\\({\\*TagBox[\\(a1 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a1 \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a2 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a2 \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a2 \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a2 \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(a3 \[LeftDoubleBracket] \\(\\(1, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(aReady \[LeftDoubleBracket] \\(\\(1, 2, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"]], Closed]]], Closed]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[785, 924]], Rule[WindowMargins, List[List[8, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]