List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Flexible Array Sizes", "Title"], Cell[TextData[List["\nThe possibility to declare arrays with unspecified dimension sizes is quite important in order to design flexible models that can adapt to different problem sizes.  An unspecified dimension size is stated by using a colon (:) instead of the usual integer expression for dimension size. ", StyleBox["The unspecified dimension sizes will eventually be determined when the array variable is bound to some value.", Rule[FontSlant, "Italic"]]]], "Text"], Cell[CellGroupData[List[Cell["Unspecified Arrays", "Section"], Cell[TextData[List["class Unspecified\n  ", StyleBox["Real[:, :]\t\ty;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// A matrix with two unknown dimension sizes\n  ", StyleBox["Real[:, 3]\t\ty2;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t// A matrix where the number of columns is known\n  ", StyleBox["Real\t\t\t\tM[:, size(M, 1)];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t// A square matrix of unknown size\nend Unspecified;"]], "ModelicaInput"], Cell["\nLet's specify the array sizes", "Text"], Cell["class Specify\n  Unspecified unspec(y = fill(1, 3, 5), \n  \t\t\t \t\t y2 = fill(1, 5, 3), \n  \t\t\t\t     M = fill(1, 2, 2)); \nend Specify;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Unspecified", "Subsection"], Cell["simulate( Specify );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Specify\\) : 2004-1-30 13:24:51.9084177 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 36 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(\\(\\(unspec . M\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . M\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . M\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . M\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y2\\)\\) \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspec . y\\)\\) \[LeftDoubleBracket] \\(\\(3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["unspec", ".", "y2"]], "\[LeftDoubleBracket]", RowBox[List["5", ",", "3"]], "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["More on unspecified arrays", "Section"], Cell["Several arrays with unknown sizes can of course be declared in the same declaration:", "Text"], Cell[TextData[List["class UnspecArr\n  ", StyleBox["Real[:]\t\t\tv1, v2;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t// Vectors v1 and v2 have unknown sizes\nend UnspecArr;"]], "ModelicaInput"], Cell[TextData[List["\nThe actual size of ", StyleBox["v1", Rule[FontFamily, "Courier"]], " and ", StyleBox["v2", Rule[FontFamily, "Courier"]], " need not be the same even though they are part of the same declaration, since the above declaration is equivalent to two separate declarations."]], "Text"], Cell[TextData[List["class UnspecArr2\n  ", StyleBox["Real[:]\t\t\tv1; \n  Real[:]\t\t\tv2;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend UnspecArr2;"]], "ModelicaInput"], Cell["\nLet's specify the array sizes", "Text"], Cell["class Specify2\n  UnspecArr unspecarr(v1 = {3, 7, 12}, \n  \t\t\t \t\t   v2 = {2, 92}); \nend Specify;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Specify2", "Subsection"], Cell["simulate( Specify2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Specify2\\) : 2004-1-30 13:24:58.0020507 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 7 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(\\(\\(unspecarr . v1\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspecarr . v1\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspecarr . v1\\)\\) \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspecarr . v2\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(unspecarr . v2\\)\\) \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List[RowBox[List["unspecarr", ".", "v1"]], "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[831, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]