List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Array Indexing", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The indexing operator ....[....] takes two or more operands, where the first operand is the array to be indexed and the rest of the operands are index expressions. It is used to access array elements for retrieval of their values or for updating these values. In class ArrayInde\n\n", StyleBox["arrayname[indexexpr1, indexexpr2, ......];", Rule[FontSlant, "Italic"]], " "]], "Text"], Cell[CellGroupData[List[Cell["ArrayIndex Class", "Subsection"], Cell[TextData[List["class ArrayIndex\n  ", StyleBox["Real[2, 2] A = {{2, 3}, {4, 5}};", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// Definition of array A\n  Real A_Retrieval ", StyleBox["= A[2, 2];\t\t\t\t", Rule[FontColor, RGBColor[0, 0, 1]]], "// Retrieves the array element value 5\n  Real B[2, 2];\n  Real c;\nalgorithm\n  B := fill(1,2,2);\t\t\t\t\t\t\t// B will have the values {{1, 1}, {1, 1}}", StyleBox["\n  B[2, 1] := 8;\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Assignment to the array element B[2, 1]\n  c := A[1, 1];\nend ArrayIndex;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of ArrayIndex", "Subsection"], Cell[TextData[List["Here we simulate the class ", StyleBox["ArrayIndex", Rule[FontFamily, "Courier"]], " above."]], "Text"], Cell["simulate( ArrayIndex );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ArrayIndex\\) : 2004-1-30 13:37:46.0501152 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 12 variables>\\n\\!\\({\\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(A \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"A\[UnderBracket]Retrieval\\\", HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(B \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm]}\\)\""], "Output"], Cell[TextData[List["We see that ", StyleBox["B[2, 1]", Rule[FontFamily, "Courier"]], " now has the value 8."]], "Text"], Cell["plot( { c, B[2,1] } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 -0.181486 0.0981006 [\n[.21429 .00222 -9 -9 ]\n[.21429 .00222 9 0 ]\n[.40476 .00222 -9 -9 ]\n[.40476 .00222 9 0 ]\n[.59524 .00222 -9 -9 ]\n[.59524 .00222 9 0 ]\n[.78571 .00222 -9 -9 ]\n[.78571 .00222 9 0 ]\n[.97619 .00222 -3 -9 ]\n[.97619 .00222 3 0 ]\n[1.025 .01472 0 -6.28125 ]\n[1.025 .01472 10 6.28125 ]\n[.01131 .11282 -6 -4.5 ]\n[.01131 .11282 0 4.5 ]\n[.01131 .21092 -6 -4.5 ]\n[.01131 .21092 0 4.5 ]\n[.01131 .30902 -6 -4.5 ]\n[.01131 .30902 0 4.5 ]\n[.01131 .40712 -6 -4.5 ]\n[.01131 .40712 0 4.5 ]\n[.01131 .50522 -6 -4.5 ]\n[.01131 .50522 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .01472 m\n.21429 .02097 L\ns\n[(0.2)] .21429 .00222 0 1 Mshowa\n.40476 .01472 m\n.40476 .02097 L\ns\n[(0.4)] .40476 .00222 0 1 Mshowa\n.59524 .01472 m\n.59524 .02097 L\ns\n[(0.6)] .59524 .00222 0 1 Mshowa\n.78571 .01472 m\n.78571 .02097 L\ns\n[(0.8)] .78571 .00222 0 1 Mshowa\n.97619 .01472 m\n.97619 .02097 L\ns\n[(1)] .97619 .00222 0 1 Mshowa\n.125 Mabswid\n.07143 .01472 m\n.07143 .01847 L\ns\n.11905 .01472 m\n.11905 .01847 L\ns\n.16667 .01472 m\n.16667 .01847 L\ns\n.2619 .01472 m\n.2619 .01847 L\ns\n.30952 .01472 m\n.30952 .01847 L\ns\n.35714 .01472 m\n.35714 .01847 L\ns\n.45238 .01472 m\n.45238 .01847 L\ns\n.5 .01472 m\n.5 .01847 L\ns\n.54762 .01472 m\n.54762 .01847 L\ns\n.64286 .01472 m\n.64286 .01847 L\ns\n.69048 .01472 m\n.69048 .01847 L\ns\n.7381 .01472 m\n.7381 .01847 L\ns\n.83333 .01472 m\n.83333 .01847 L\ns\n.88095 .01472 m\n.88095 .01847 L\ns\n.92857 .01472 m\n.92857 .01847 L\ns\n.25 Mabswid\n0 .01472 m\n1 .01472 L\ns\ngsave\n1.025 .01472 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .11282 m\n.03006 .11282 L\ns\n[(3)] .01131 .11282 1 0 Mshowa\n.02381 .21092 m\n.03006 .21092 L\ns\n[(4)] .01131 .21092 1 0 Mshowa\n.02381 .30902 m\n.03006 .30902 L\ns\n[(5)] .01131 .30902 1 0 Mshowa\n.02381 .40712 m\n.03006 .40712 L\ns\n[(6)] .01131 .40712 1 0 Mshowa\n.02381 .50522 m\n.03006 .50522 L\ns\n[(7)] .01131 .50522 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(8)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .03434 m\n.02756 .03434 L\ns\n.02381 .05396 m\n.02756 .05396 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .0932 m\n.02756 .0932 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .15206 m\n.02756 .15206 L\ns\n.02381 .17168 m\n.02756 .17168 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .23054 m\n.02756 .23054 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .26978 m\n.02756 .26978 L\ns\n.02381 .2894 m\n.02756 .2894 L\ns\n.02381 .32864 m\n.02756 .32864 L\ns\n.02381 .34826 m\n.02756 .34826 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .3875 m\n.02756 .3875 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .44636 m\n.02756 .44636 L\ns\n.02381 .46598 m\n.02756 .46598 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .52484 m\n.02756 .52484 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .56408 m\n.02756 .56408 L\ns\n.02381 .5837 m\n.02756 .5837 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .01472 m\n.02571 .01472 L\n.02762 .01472 L\n.02952 .01472 L\n.03143 .01472 L\n.03333 .01472 L\n.03524 .01472 L\n.03714 .01472 L\n.03905 .01472 L\n.04095 .01472 L\n.04286 .01472 L\n.04476 .01472 L\n.04667 .01472 L\n.04857 .01472 L\n.05048 .01472 L\n.05238 .01472 L\n.05429 .01472 L\n.05619 .01472 L\n.0581 .01472 L\n.06 .01472 L\n.0619 .01472 L\n.06381 .01472 L\n.06571 .01472 L\n.06762 .01472 L\n.06952 .01472 L\n.07143 .01472 L\n.07333 .01472 L\n.07524 .01472 L\n.07714 .01472 L\n.07905 .01472 L\n.08095 .01472 L\n.08286 .01472 L\n.08476 .01472 L\n.08667 .01472 L\n.08857 .01472 L\n.09048 .01472 L\n.09238 .01472 L\n.09429 .01472 L\n.09619 .01472 L\n.0981 .01472 L\n.1 .01472 L\n.1019 .01472 L\n.10381 .01472 L\n.10571 .01472 L\n.10762 .01472 L\n.10952 .01472 L\n.11143 .01472 L\n.11333 .01472 L\n.11524 .01472 L\n.11714 .01472 L\nMistroke\n.11905 .01472 L\n.12095 .01472 L\n.12286 .01472 L\n.12476 .01472 L\n.12667 .01472 L\n.12857 .01472 L\n.13048 .01472 L\n.13238 .01472 L\n.13429 .01472 L\n.13619 .01472 L\n.1381 .01472 L\n.14 .01472 L\n.1419 .01472 L\n.14381 .01472 L\n.14571 .01472 L\n.14762 .01472 L\n.14952 .01472 L\n.15143 .01472 L\n.15333 .01472 L\n.15524 .01472 L\n.15714 .01472 L\n.15905 .01472 L\n.16095 .01472 L\n.16286 .01472 L\n.16476 .01472 L\n.16667 .01472 L\n.16857 .01472 L\n.17048 .01472 L\n.17238 .01472 L\n.17429 .01472 L\n.17619 .01472 L\n.1781 .01472 L\n.18 .01472 L\n.1819 .01472 L\n.18381 .01472 L\n.18571 .01472 L\n.18762 .01472 L\n.18952 .01472 L\n.19143 .01472 L\n.19333 .01472 L\n.19524 .01472 L\n.19714 .01472 L\n.19905 .01472 L\n.20095 .01472 L\n.20286 .01472 L\n.20476 .01472 L\n.20667 .01472 L\n.20857 .01472 L\n.21048 .01472 L\n.21238 .01472 L\nMistroke\n.21429 .01472 L\n.21619 .01472 L\n.2181 .01472 L\n.22 .01472 L\n.2219 .01472 L\n.22381 .01472 L\n.22571 .01472 L\n.22762 .01472 L\n.22952 .01472 L\n.23143 .01472 L\n.23333 .01472 L\n.23524 .01472 L\n.23714 .01472 L\n.23905 .01472 L\n.24095 .01472 L\n.24286 .01472 L\n.24476 .01472 L\n.24667 .01472 L\n.24857 .01472 L\n.25048 .01472 L\n.25238 .01472 L\n.25429 .01472 L\n.25619 .01472 L\n.2581 .01472 L\n.26 .01472 L\n.2619 .01472 L\n.26381 .01472 L\n.26571 .01472 L\n.26762 .01472 L\n.26952 .01472 L\n.27143 .01472 L\n.27333 .01472 L\n.27524 .01472 L\n.27714 .01472 L\n.27905 .01472 L\n.28095 .01472 L\n.28286 .01472 L\n.28476 .01472 L\n.28667 .01472 L\n.28857 .01472 L\n.29048 .01472 L\n.29238 .01472 L\n.29429 .01472 L\n.29619 .01472 L\n.2981 .01472 L\n.3 .01472 L\n.3019 .01472 L\n.30381 .01472 L\n.30571 .01472 L\n.30762 .01472 L\nMistroke\n.30952 .01472 L\n.31143 .01472 L\n.31333 .01472 L\n.31524 .01472 L\n.31714 .01472 L\n.31905 .01472 L\n.32095 .01472 L\n.32286 .01472 L\n.32476 .01472 L\n.32667 .01472 L\n.32857 .01472 L\n.33048 .01472 L\n.33238 .01472 L\n.33429 .01472 L\n.33619 .01472 L\n.3381 .01472 L\n.34 .01472 L\n.3419 .01472 L\n.34381 .01472 L\n.34571 .01472 L\n.34762 .01472 L\n.34952 .01472 L\n.35143 .01472 L\n.35333 .01472 L\n.35524 .01472 L\n.35714 .01472 L\n.35905 .01472 L\n.36095 .01472 L\n.36286 .01472 L\n.36476 .01472 L\n.36667 .01472 L\n.36857 .01472 L\n.37048 .01472 L\n.37238 .01472 L\n.37429 .01472 L\n.37619 .01472 L\n.3781 .01472 L\n.38 .01472 L\n.3819 .01472 L\n.38381 .01472 L\n.38571 .01472 L\n.38762 .01472 L\n.38952 .01472 L\n.39143 .01472 L\n.39333 .01472 L\n.39524 .01472 L\n.39714 .01472 L\n.39905 .01472 L\n.40095 .01472 L\n.40286 .01472 L\nMistroke\n.40476 .01472 L\n.40667 .01472 L\n.40857 .01472 L\n.41048 .01472 L\n.41238 .01472 L\n.41429 .01472 L\n.41619 .01472 L\n.4181 .01472 L\n.42 .01472 L\n.4219 .01472 L\n.42381 .01472 L\n.42571 .01472 L\n.42762 .01472 L\n.42952 .01472 L\n.43143 .01472 L\n.43333 .01472 L\n.43524 .01472 L\n.43714 .01472 L\n.43905 .01472 L\n.44095 .01472 L\n.44286 .01472 L\n.44476 .01472 L\n.44667 .01472 L\n.44857 .01472 L\n.45048 .01472 L\n.45238 .01472 L\n.45429 .01472 L\n.45619 .01472 L\n.4581 .01472 L\n.46 .01472 L\n.4619 .01472 L\n.46381 .01472 L\n.46571 .01472 L\n.46762 .01472 L\n.46952 .01472 L\n.47143 .01472 L\n.47333 .01472 L\n.47524 .01472 L\n.47714 .01472 L\n.47905 .01472 L\n.48095 .01472 L\n.48286 .01472 L\n.48476 .01472 L\n.48667 .01472 L\n.48857 .01472 L\n.49048 .01472 L\n.49238 .01472 L\n.49429 .01472 L\n.49619 .01472 L\n.4981 .01472 L\nMistroke\n.5 .01472 L\n.5019 .01472 L\n.50381 .01472 L\n.50571 .01472 L\n.50762 .01472 L\n.50952 .01472 L\n.51143 .01472 L\n.51333 .01472 L\n.51524 .01472 L\n.51714 .01472 L\n.51905 .01472 L\n.52095 .01472 L\n.52286 .01472 L\n.52476 .01472 L\n.52667 .01472 L\n.52857 .01472 L\n.53048 .01472 L\n.53238 .01472 L\n.53429 .01472 L\n.53619 .01472 L\n.5381 .01472 L\n.54 .01472 L\n.5419 .01472 L\n.54381 .01472 L\n.54571 .01472 L\n.54762 .01472 L\n.54952 .01472 L\n.55143 .01472 L\n.55333 .01472 L\n.55524 .01472 L\n.55714 .01472 L\n.55905 .01472 L\n.56095 .01472 L\n.56286 .01472 L\n.56476 .01472 L\n.56667 .01472 L\n.56857 .01472 L\n.57048 .01472 L\n.57238 .01472 L\n.57429 .01472 L\n.57619 .01472 L\n.5781 .01472 L\n.58 .01472 L\n.5819 .01472 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .01472 L\n.58952 .01472 L\n.59143 .01472 L\n.59333 .01472 L\nMistroke\n.59524 .01472 L\n.59714 .01472 L\n.59905 .01472 L\n.60095 .01472 L\n.60286 .01472 L\n.60476 .01472 L\n.60667 .01472 L\n.60857 .01472 L\n.61048 .01472 L\n.61238 .01472 L\n.61429 .01472 L\n.61619 .01472 L\n.6181 .01472 L\n.62 .01472 L\n.6219 .01472 L\n.62381 .01472 L\n.62571 .01472 L\n.62762 .01472 L\n.62952 .01472 L\n.63143 .01472 L\n.63333 .01472 L\n.63524 .01472 L\n.63714 .01472 L\n.63905 .01472 L\n.64095 .01472 L\n.64286 .01472 L\n.64476 .01472 L\n.64667 .01472 L\n.64857 .01472 L\n.65048 .01472 L\n.65238 .01472 L\n.65429 .01472 L\n.65619 .01472 L\n.6581 .01472 L\n.66 .01472 L\n.6619 .01472 L\n.66381 .01472 L\n.66571 .01472 L\n.66762 .01472 L\n.66952 .01472 L\n.67143 .01472 L\n.67333 .01472 L\n.67524 .01472 L\n.67714 .01472 L\n.67905 .01472 L\n.68095 .01472 L\n.68286 .01472 L\n.68476 .01472 L\n.68667 .01472 L\n.68857 .01472 L\nMistroke\n.69048 .01472 L\n.69238 .01472 L\n.69429 .01472 L\n.69619 .01472 L\n.6981 .01472 L\n.7 .01472 L\n.7019 .01472 L\n.70381 .01472 L\n.70571 .01472 L\n.70762 .01472 L\n.70952 .01472 L\n.71143 .01472 L\n.71333 .01472 L\n.71524 .01472 L\n.71714 .01472 L\n.71905 .01472 L\n.72095 .01472 L\n.72286 .01472 L\n.72476 .01472 L\n.72667 .01472 L\n.72857 .01472 L\n.73048 .01472 L\n.73238 .01472 L\n.73429 .01472 L\n.73619 .01472 L\n.7381 .01472 L\n.74 .01472 L\n.7419 .01472 L\n.74381 .01472 L\n.74571 .01472 L\n.74762 .01472 L\n.74952 .01472 L\n.75143 .01472 L\n.75333 .01472 L\n.75524 .01472 L\n.75714 .01472 L\n.75905 .01472 L\n.76095 .01472 L\n.76286 .01472 L\n.76476 .01472 L\n.76667 .01472 L\n.76857 .01472 L\n.77048 .01472 L\n.77238 .01472 L\n.77429 .01472 L\n.77619 .01472 L\n.7781 .01472 L\n.78 .01472 L\n.7819 .01472 L\n.78381 .01472 L\nMistroke\n.78571 .01472 L\n.78762 .01472 L\n.78952 .01472 L\n.79143 .01472 L\n.79333 .01472 L\n.79524 .01472 L\n.79714 .01472 L\n.79905 .01472 L\n.80095 .01472 L\n.80286 .01472 L\n.80476 .01472 L\n.80667 .01472 L\n.80857 .01472 L\n.81048 .01472 L\n.81238 .01472 L\n.81429 .01472 L\n.81619 .01472 L\n.8181 .01472 L\n.82 .01472 L\n.8219 .01472 L\n.82381 .01472 L\n.82571 .01472 L\n.82762 .01472 L\n.82952 .01472 L\n.83143 .01472 L\n.83333 .01472 L\n.83524 .01472 L\n.83714 .01472 L\n.83905 .01472 L\n.84095 .01472 L\n.84286 .01472 L\n.84476 .01472 L\n.84667 .01472 L\n.84857 .01472 L\n.85048 .01472 L\n.85238 .01472 L\n.85429 .01472 L\n.85619 .01472 L\n.8581 .01472 L\n.86 .01472 L\n.8619 .01472 L\n.86381 .01472 L\n.86571 .01472 L\n.86762 .01472 L\n.86952 .01472 L\n.87143 .01472 L\n.87333 .01472 L\n.87524 .01472 L\n.87714 .01472 L\n.87905 .01472 L\nMistroke\n.88095 .01472 L\n.88286 .01472 L\n.88476 .01472 L\n.88667 .01472 L\n.88857 .01472 L\n.89048 .01472 L\n.89238 .01472 L\n.89429 .01472 L\n.89619 .01472 L\n.8981 .01472 L\n.9 .01472 L\n.9019 .01472 L\n.90381 .01472 L\n.90571 .01472 L\n.90762 .01472 L\n.90952 .01472 L\n.91143 .01472 L\n.91333 .01472 L\n.91524 .01472 L\n.91714 .01472 L\n.91905 .01472 L\n.92095 .01472 L\n.92286 .01472 L\n.92476 .01472 L\n.92667 .01472 L\n.92857 .01472 L\n.93048 .01472 L\n.93238 .01472 L\n.93429 .01472 L\n.93619 .01472 L\n.9381 .01472 L\n.94 .01472 L\n.9419 .01472 L\n.94381 .01472 L\n.94571 .01472 L\n.94762 .01472 L\n.94952 .01472 L\n.95143 .01472 L\n.95333 .01472 L\n.95524 .01472 L\n.95714 .01472 L\n.95905 .01472 L\n.96095 .01472 L\n.96286 .01472 L\n.96476 .01472 L\n.96667 .01472 L\n.96857 .01472 L\n.97048 .01472 L\n.97238 .01472 L\n.97429 .01472 L\nMistroke\n.97619 .01472 L\nMfstroke\n0 .5 0 r\n.02381 .60332 m\n.02571 .60332 L\n.02762 .60332 L\n.02952 .60332 L\n.03143 .60332 L\n.03333 .60332 L\n.03524 .60332 L\n.03714 .60332 L\n.03905 .60332 L\n.04095 .60332 L\n.04286 .60332 L\n.04476 .60332 L\n.04667 .60332 L\n.04857 .60332 L\n.05048 .60332 L\n.05238 .60332 L\n.05429 .60332 L\n.05619 .60332 L\n.0581 .60332 L\n.06 .60332 L\n.0619 .60332 L\n.06381 .60332 L\n.06571 .60332 L\n.06762 .60332 L\n.06952 .60332 L\n.07143 .60332 L\n.07333 .60332 L\n.07524 .60332 L\n.07714 .60332 L\n.07905 .60332 L\n.08095 .60332 L\n.08286 .60332 L\n.08476 .60332 L\n.08667 .60332 L\n.08857 .60332 L\n.09048 .60332 L\n.09238 .60332 L\n.09429 .60332 L\n.09619 .60332 L\n.0981 .60332 L\n.1 .60332 L\n.1019 .60332 L\n.10381 .60332 L\n.10571 .60332 L\n.10762 .60332 L\n.10952 .60332 L\n.11143 .60332 L\n.11333 .60332 L\n.11524 .60332 L\n.11714 .60332 L\nMistroke\n.11905 .60332 L\n.12095 .60332 L\n.12286 .60332 L\n.12476 .60332 L\n.12667 .60332 L\n.12857 .60332 L\n.13048 .60332 L\n.13238 .60332 L\n.13429 .60332 L\n.13619 .60332 L\n.1381 .60332 L\n.14 .60332 L\n.1419 .60332 L\n.14381 .60332 L\n.14571 .60332 L\n.14762 .60332 L\n.14952 .60332 L\n.15143 .60332 L\n.15333 .60332 L\n.15524 .60332 L\n.15714 .60332 L\n.15905 .60332 L\n.16095 .60332 L\n.16286 .60332 L\n.16476 .60332 L\n.16667 .60332 L\n.16857 .60332 L\n.17048 .60332 L\n.17238 .60332 L\n.17429 .60332 L\n.17619 .60332 L\n.1781 .60332 L\n.18 .60332 L\n.1819 .60332 L\n.18381 .60332 L\n.18571 .60332 L\n.18762 .60332 L\n.18952 .60332 L\n.19143 .60332 L\n.19333 .60332 L\n.19524 .60332 L\n.19714 .60332 L\n.19905 .60332 L\n.20095 .60332 L\n.20286 .60332 L\n.20476 .60332 L\n.20667 .60332 L\n.20857 .60332 L\n.21048 .60332 L\n.21238 .60332 L\nMistroke\n.21429 .60332 L\n.21619 .60332 L\n.2181 .60332 L\n.22 .60332 L\n.2219 .60332 L\n.22381 .60332 L\n.22571 .60332 L\n.22762 .60332 L\n.22952 .60332 L\n.23143 .60332 L\n.23333 .60332 L\n.23524 .60332 L\n.23714 .60332 L\n.23905 .60332 L\n.24095 .60332 L\n.24286 .60332 L\n.24476 .60332 L\n.24667 .60332 L\n.24857 .60332 L\n.25048 .60332 L\n.25238 .60332 L\n.25429 .60332 L\n.25619 .60332 L\n.2581 .60332 L\n.26 .60332 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60332 L\n.26762 .60332 L\n.26952 .60332 L\n.27143 .60332 L\n.27333 .60332 L\n.27524 .60332 L\n.27714 .60332 L\n.27905 .60332 L\n.28095 .60332 L\n.28286 .60332 L\n.28476 .60332 L\n.28667 .60332 L\n.28857 .60332 L\n.29048 .60332 L\n.29238 .60332 L\n.29429 .60332 L\n.29619 .60332 L\n.2981 .60332 L\n.3 .60332 L\n.3019 .60332 L\n.30381 .60332 L\n.30571 .60332 L\n.30762 .60332 L\nMistroke\n.30952 .60332 L\n.31143 .60332 L\n.31333 .60332 L\n.31524 .60332 L\n.31714 .60332 L\n.31905 .60332 L\n.32095 .60332 L\n.32286 .60332 L\n.32476 .60332 L\n.32667 .60332 L\n.32857 .60332 L\n.33048 .60332 L\n.33238 .60332 L\n.33429 .60332 L\n.33619 .60332 L\n.3381 .60332 L\n.34 .60332 L\n.3419 .60332 L\n.34381 .60332 L\n.34571 .60332 L\n.34762 .60332 L\n.34952 .60332 L\n.35143 .60332 L\n.35333 .60332 L\n.35524 .60332 L\n.35714 .60332 L\n.35905 .60332 L\n.36095 .60332 L\n.36286 .60332 L\n.36476 .60332 L\n.36667 .60332 L\n.36857 .60332 L\n.37048 .60332 L\n.37238 .60332 L\n.37429 .60332 L\n.37619 .60332 L\n.3781 .60332 L\n.38 .60332 L\n.3819 .60332 L\n.38381 .60332 L\n.38571 .60332 L\n.38762 .60332 L\n.38952 .60332 L\n.39143 .60332 L\n.39333 .60332 L\n.39524 .60332 L\n.39714 .60332 L\n.39905 .60332 L\n.40095 .60332 L\n.40286 .60332 L\nMistroke\n.40476 .60332 L\n.40667 .60332 L\n.40857 .60332 L\n.41048 .60332 L\n.41238 .60332 L\n.41429 .60332 L\n.41619 .60332 L\n.4181 .60332 L\n.42 .60332 L\n.4219 .60332 L\n.42381 .60332 L\n.42571 .60332 L\n.42762 .60332 L\n.42952 .60332 L\n.43143 .60332 L\n.43333 .60332 L\n.43524 .60332 L\n.43714 .60332 L\n.43905 .60332 L\n.44095 .60332 L\n.44286 .60332 L\n.44476 .60332 L\n.44667 .60332 L\n.44857 .60332 L\n.45048 .60332 L\n.45238 .60332 L\n.45429 .60332 L\n.45619 .60332 L\n.4581 .60332 L\n.46 .60332 L\n.4619 .60332 L\n.46381 .60332 L\n.46571 .60332 L\n.46762 .60332 L\n.46952 .60332 L\n.47143 .60332 L\n.47333 .60332 L\n.47524 .60332 L\n.47714 .60332 L\n.47905 .60332 L\n.48095 .60332 L\n.48286 .60332 L\n.48476 .60332 L\n.48667 .60332 L\n.48857 .60332 L\n.49048 .60332 L\n.49238 .60332 L\n.49429 .60332 L\n.49619 .60332 L\n.4981 .60332 L\nMistroke\n.5 .60332 L\n.5019 .60332 L\n.50381 .60332 L\n.50571 .60332 L\n.50762 .60332 L\n.50952 .60332 L\n.51143 .60332 L\n.51333 .60332 L\n.51524 .60332 L\n.51714 .60332 L\n.51905 .60332 L\n.52095 .60332 L\n.52286 .60332 L\n.52476 .60332 L\n.52667 .60332 L\n.52857 .60332 L\n.53048 .60332 L\n.53238 .60332 L\n.53429 .60332 L\n.53619 .60332 L\n.5381 .60332 L\n.54 .60332 L\n.5419 .60332 L\n.54381 .60332 L\n.54571 .60332 L\n.54762 .60332 L\n.54952 .60332 L\n.55143 .60332 L\n.55333 .60332 L\n.55524 .60332 L\n.55714 .60332 L\n.55905 .60332 L\n.56095 .60332 L\n.56286 .60332 L\n.56476 .60332 L\n.56667 .60332 L\n.56857 .60332 L\n.57048 .60332 L\n.57238 .60332 L\n.57429 .60332 L\n.57619 .60332 L\n.5781 .60332 L\n.58 .60332 L\n.5819 .60332 L\n.58381 .60332 L\n.58571 .60332 L\n.58762 .60332 L\n.58952 .60332 L\n.59143 .60332 L\n.59333 .60332 L\nMistroke\n.59524 .60332 L\n.59714 .60332 L\n.59905 .60332 L\n.60095 .60332 L\n.60286 .60332 L\n.60476 .60332 L\n.60667 .60332 L\n.60857 .60332 L\n.61048 .60332 L\n.61238 .60332 L\n.61429 .60332 L\n.61619 .60332 L\n.6181 .60332 L\n.62 .60332 L\n.6219 .60332 L\n.62381 .60332 L\n.62571 .60332 L\n.62762 .60332 L\n.62952 .60332 L\n.63143 .60332 L\n.63333 .60332 L\n.63524 .60332 L\n.63714 .60332 L\n.63905 .60332 L\n.64095 .60332 L\n.64286 .60332 L\n.64476 .60332 L\n.64667 .60332 L\n.64857 .60332 L\n.65048 .60332 L\n.65238 .60332 L\n.65429 .60332 L\n.65619 .60332 L\n.6581 .60332 L\n.66 .60332 L\n.6619 .60332 L\n.66381 .60332 L\n.66571 .60332 L\n.66762 .60332 L\n.66952 .60332 L\n.67143 .60332 L\n.67333 .60332 L\n.67524 .60332 L\n.67714 .60332 L\n.67905 .60332 L\n.68095 .60332 L\n.68286 .60332 L\n.68476 .60332 L\n.68667 .60332 L\n.68857 .60332 L\nMistroke\n.69048 .60332 L\n.69238 .60332 L\n.69429 .60332 L\n.69619 .60332 L\n.6981 .60332 L\n.7 .60332 L\n.7019 .60332 L\n.70381 .60332 L\n.70571 .60332 L\n.70762 .60332 L\n.70952 .60332 L\n.71143 .60332 L\n.71333 .60332 L\n.71524 .60332 L\n.71714 .60332 L\n.71905 .60332 L\n.72095 .60332 L\n.72286 .60332 L\n.72476 .60332 L\n.72667 .60332 L\n.72857 .60332 L\n.73048 .60332 L\n.73238 .60332 L\n.73429 .60332 L\n.73619 .60332 L\n.7381 .60332 L\n.74 .60332 L\n.7419 .60332 L\n.74381 .60332 L\n.74571 .60332 L\n.74762 .60332 L\n.74952 .60332 L\n.75143 .60332 L\n.75333 .60332 L\n.75524 .60332 L\n.75714 .60332 L\n.75905 .60332 L\n.76095 .60332 L\n.76286 .60332 L\n.76476 .60332 L\n.76667 .60332 L\n.76857 .60332 L\n.77048 .60332 L\n.77238 .60332 L\n.77429 .60332 L\n.77619 .60332 L\n.7781 .60332 L\n.78 .60332 L\n.7819 .60332 L\n.78381 .60332 L\nMistroke\n.78571 .60332 L\n.78762 .60332 L\n.78952 .60332 L\n.79143 .60332 L\n.79333 .60332 L\n.79524 .60332 L\n.79714 .60332 L\n.79905 .60332 L\n.80095 .60332 L\n.80286 .60332 L\n.80476 .60332 L\n.80667 .60332 L\n.80857 .60332 L\n.81048 .60332 L\n.81238 .60332 L\n.81429 .60332 L\n.81619 .60332 L\n.8181 .60332 L\n.82 .60332 L\n.8219 .60332 L\n.82381 .60332 L\n.82571 .60332 L\n.82762 .60332 L\n.82952 .60332 L\n.83143 .60332 L\n.83333 .60332 L\n.83524 .60332 L\n.83714 .60332 L\n.83905 .60332 L\n.84095 .60332 L\n.84286 .60332 L\n.84476 .60332 L\n.84667 .60332 L\n.84857 .60332 L\n.85048 .60332 L\n.85238 .60332 L\n.85429 .60332 L\n.85619 .60332 L\n.8581 .60332 L\n.86 .60332 L\n.8619 .60332 L\n.86381 .60332 L\n.86571 .60332 L\n.86762 .60332 L\n.86952 .60332 L\n.87143 .60332 L\n.87333 .60332 L\n.87524 .60332 L\n.87714 .60332 L\n.87905 .60332 L\nMistroke\n.88095 .60332 L\n.88286 .60332 L\n.88476 .60332 L\n.88667 .60332 L\n.88857 .60332 L\n.89048 .60332 L\n.89238 .60332 L\n.89429 .60332 L\n.89619 .60332 L\n.8981 .60332 L\n.9 .60332 L\n.9019 .60332 L\n.90381 .60332 L\n.90571 .60332 L\n.90762 .60332 L\n.90952 .60332 L\n.91143 .60332 L\n.91333 .60332 L\n.91524 .60332 L\n.91714 .60332 L\n.91905 .60332 L\n.92095 .60332 L\n.92286 .60332 L\n.92476 .60332 L\n.92667 .60332 L\n.92857 .60332 L\n.93048 .60332 L\n.93238 .60332 L\n.93429 .60332 L\n.93619 .60332 L\n.9381 .60332 L\n.94 .60332 L\n.9419 .60332 L\n.94381 .60332 L\n.94571 .60332 L\n.94762 .60332 L\n.94952 .60332 L\n.95143 .60332 L\n.95333 .60332 L\n.95524 .60332 L\n.95714 .60332 L\n.95905 .60332 L\n.96095 .60332 L\n.96286 .60332 L\n.96476 .60332 L\n.96667 .60332 L\n.96857 .60332 L\n.97048 .60332 L\n.97238 .60332 L\n.97429 .60332 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n/MISOfy\n{\n    /newfontname exch def\n    /oldfontname exch def\n\n    oldfontname findfont\n    dup length dict begin\n        {1 index /FID ne {def} {pop pop} ifelse} forall\n        /Encoding WindowsANSIEncoding def\n        currentdict\n    end\n\n    newfontname exch definefont pop\n} def\n\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n%%BeginResource: font Courier-MISO\n%%BeginFont: Courier-MISO\n/Courier /Courier-MISO MISOfy\n%%EndFont\n%%EndResource\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(B) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(P) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(2) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(,) show\n90.563 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(1) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n96.563 12.813 moveto\n(T) show\n102.563 12.813 moveto\n(@) show\n108.563 12.813 moveto\n%%IncludeResource: font Courier-MISO\n%%IncludeFont: Courier-MISO\n/Courier-MISO findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n114.563 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(c) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n69.000 12.813 moveto\n(@) show\n75.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n81.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00>@3IfMT2000000@0fMWI0P0000030=WIf@@00000\n8@3IfMT2000000@0fMWI0P0000050=WIf@<000008@3IfMT2000000@0fMWI0P0000030=WIf@<00000\n8P3IfMT2000000@0fMWI0P0000040=WIf@8000009`3IfMT5000001`0fMWI000h0=WIf@040000003I\nfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT08@3IfMT010000000fMWI0=WIf@00000;0=WIf@03\n0000003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000P\n0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI\n0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT0fMWI0200fMWI\n00@000000=WIf@3IfMT00000203IfMT500000200fMWI00@000000=WIf@3IfMT00000203IfMT01000\n0000fMWI0=WIf@00000P0=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT00000\n:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>03IfMT010000000fMWI0=WIf@00000:0=WIf@030000\n003IfMT0fMWI01l0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000Q0=WI\nf@040000003IfMT0fMWI000000P0fMWI0`00000Q0=WIf@040000003IfMT0fMWI000000T0fMWI0P00\n000Y0=WIf@030000003IfMT0fMWI01`0fMWI000h0=WIf@040000003IfMT0fMWI000000P0fMWI00@0\n00000=WIf@3IfMT00000803IfMT010000000fMWI0=WIf@0000090=WIf@030000003IfMT000000240\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0P0=WIf@040000003IfMT0fMWI\n000000P0fMWI00@000000=WIf@3IfMT00000:03IfMT00`000000fMWI0=WIf@0L0=WIf@00>@3IfMT2\n000000X0fMWI0P00000R0=WIf@8000002`3IfMT200000280fMWI0P00000:0=WIf@<000008@3IfMT2\n000000X0fMWI0P00000X0=WIf@8000007P3IfMT00?l0fMWI8@3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?h0fMWI0P00000=0=WIf@00403IfMT00`000000fMWI0=WIf@3m0=WIf@040000003IfMT0\nfMWI000000`0fMWI000:0=WIf@H00000lP000?l6000000P0fMWI00<000000=WIf@3IfMT03@3IfMT0\n0100fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00X0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00T0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI\n00/0fMWI1@00000<0=WIf@00403IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI02d0\nfMWI00<000000=WIf@3IfMT0;P3IfMT00`000000fMWI0=WIf@0]0=WIf@030000003IfMT0fMWI02d0\nfMWI00<000000=WIf@3IfMT0303IfMT00`000000fMWI0=WIf@0=0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o\n0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o\n0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003I\nfMT0fMWI0?l0fMWI3P3IfMT00100fMWI0P00003o0=WIf@l0fMWI000@0=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002@3IfMT2000000D0fMWI\n00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000\n003IfMT0fMWI0?l0fMWI3P3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT200000?l0fMWI3`3I\nfMT000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WI\nf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002@3IfMT20000\n00D0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@\n0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WI\nf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403I\nfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT0\n0100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@\n0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WI\nf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403I\nfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT0\n00X0fMWI0`0000030=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000/0fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@D000000`3IfMT200000?l0fMWI\n3`3IfMT000P0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n00090=WIf@030000003IfMT0000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002P3IfMT2\n000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WI\nf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>\n0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00\n403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I\nfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WI\nf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>\n0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00\n403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I\nfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000;0=WIf@030000003IfMT0fMWI\n0080fMWI0P00003o0=WIf@l0fMWI00090=WIf@8000001@3IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI00090=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002@3I\nfMT3000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o\n0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3I\nfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WI\nf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI\n3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT0\n0100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0\nfMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3I\nfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WI\nf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@<000001@3IfMT00`000000fMWI\n0=WIf@3o0=WIf@h0fMWI00080=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0\no`3IfMT>0=WIf@00203IfMT010000000fMWI0=WIf@0000040=WIf@800000o`3IfMT?0=WIf@00203I\nfMT3000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002@3IfMT00`000000fMWI0=WIf@04\n0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000T0fMWI0`0000040=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI\n3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o\n0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3I\nfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI\n0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI\n3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o\n0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3I\nfMT0o`3IfMT>0=WIf@00403IfMT200000?l0fMWI3`3IfMT00100fMWI00<000000=WIf@3IfMT0o`3I\nfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000:0=WIf@030000003IfMT0fMWI\n00<0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@002P3IfMT00`000000fMWI0=WIf@030=WIf@03\n0000003IfMT0fMWI0?l0fMWI3P3IfMT000X0fMWI00<000000=WIf@3IfMT00`3IfMT200000?l0fMWI\n3`3IfMT000/0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI0008\n0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00203IfMT4\n000000@0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WI\nf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>\n0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00\n403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I\nfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WI\nf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI\n000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0o`3IfMT>\n0=WIf@00403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@800000o`3IfMT?0=WIf@00\n403IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI000@0=WIf@030000003IfMT0fMWI0?l0fMWI3P3I\nfMT000T0fMWI0P0000050=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000P0fMWI00@000000=WI\nf@3IfMT00000103IfMT00`000000fMWI0=WIf@3o0=WIf@h0fMWI00080=WIf@040000003IfMT0fMWI\n000000@0fMWIlP00O`0N0=WIf@002@3IfMT2000000D0fMWI00<000000=WIf@3IfMT0o`3IfMT>0=WI\nf@00203IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT000T0\nfMWI0P0000050=WIf@030000003IfMT0fMWI0?l0fMWI3P3IfMT00100fMWI00<000000=WIf@3IfMT0\no`3IfMT>0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00:@3IfMT4000001H0fMWI100000050=WI\nf@800000203IfMT200000<P0fMWI000Y0=WIf@030000003IfMT0000000T0fMWI00<000000=WIf@3I\nfMT0303IfMT00`000000fMWI000000050=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3I\nfMT0aP3IfMT00240fMWI100000040=WIf@030000003IfMT000000080fMWI100000030=WIf@030000\n003IfMT0fMWI00H0fMWI1@000000103IfMT000000=WIf@0000050=WIf@030000003IfMT0fMWI0080\nfMWI0P0000040=WIf@030000003IfMT0fMWI0<H0fMWI000R0=WIf@040000003IfMT0fMWI000000<0\nfMWI00<000000=WIf@0000000P3IfMT00`000000fMWI0=WIf@050=WIf@030000003IfMT0fMWI00L0\nfMWI00L000000=WIf@3IfMT0fMWI0000003IfMT0000000D0fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@050000003IfMT0fMWI0=WIf@000000b03IfMT001H0fMWI2000O`040=WIf@040000003I\nfMT0fMWI000000<0fMWI00<000000=WIf@0000000`3IfMT00`000000fMWI0=WIf@0>0=WIf@070000\n003IfMT0fMWI0=WIf@000000fMWI000000050=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT0\n0`000000fMWI0=WIf@360=WIf@008P3IfMT3000000@0fMWI00<000000=WIf@000000103IfMT00`00\n0000fMWI0=WIf@0=0=WIf@070000003IfMT0fMWI0=WIf@000000fMWI000000050=WIf@030000003I\nfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@360=WIf@008P3IfMT010000000fMWI0=WIf@00\n00030=WIf@030000003IfMT000000080fMWI00@000000=WIf@3IfMT000003P3IfMT01`000000fMWI\n0=WIf@3IfMT000000=WIf@0000001@3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<00000\n0=WIf@3IfMT0aP3IfMT00240fMWI100000040=WIf@@000000P3IfMT2000000h0fMWI0P0000020=WI\nf@@000001@3IfMT2000000P0fMWI0P0000380=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3I\nfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00:P3IfMT2000000P0fMWI\n0P00003Z0=WIf@00:P3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0>P0fMWI000S\n0=WIf@<00000103IfMT00`000000fMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3X\n0=WIf@005P3IfMT80000o`@0fMWI00<000000=WIf@3IfMT01@3IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00D000000=WIf@3IfMT0fMWI0000003Z0=WIf@008P3IfMT00`000000fMWI0=WIf@05\n0=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@008`3IfMT3\n000000@0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0>P0fMWI000Z0=WI\nf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3X0=WIf@00:P3IfMT20000\n00P0fMWI0P00003Z0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0669834`, 1.24766`, 0.00414258`, 0.0402171`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]]], Open]]], Open]], Cell[CellGroupData[List[Cell["Indexing with Scalar Index Expressions ", "Section"], Cell[TextData[List["Array indexing using scalar integer index expressions is usually used to retrieve or update single array elements. The value of the index expression for the i:th dimension of an array ", StyleBox["X", Rule[FontFamily, "Courier"]], " must be within the bounds of the size of that dimension, i.e. ", StyleBox["1 <= index value <= size(X, i)", Rule[FontFamily, "Courier"]], ". Since multi-dimensional arrays are defined as arrays of arrays in Modelica, it is also possible to access sub-arrays using simple scalar indexing. For example, the array B can also be regarded as a one-dimensional array of vectors.\n"]], "Text"], Cell[TextData[List["class ScalarIndex\n  Real[2, 2] B \t\t= {{1, 2}, {4, 5}};\n  Real[2] \t v \t\t= {10, 11};\n  Real[4, 2] M;\n  \n  ", StyleBox["Real B_Ret1 = B[1, 2];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// Retrieves the value 2\n  //", StyleBox["Real B_Ret2[2] = B[2];\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Retrieves B[2] giving {4, 5}\n  \n  ", StyleBox["Real v_Ret1  = v[2];\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t// Retrieves the value 11\n  // ", StyleBox["Real v_Ret2  = v[4];\t", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Error, index out of range!\n  \nalgorithm\n  M[4] := fill(5, 4, 2);\n  ", StyleBox["M[4] := v;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Updates M to become \n  \t\t\t\t\t\t\t\t\t// {{5, 5}, {5, 5}, {5, 5}, {10, 11}}\nend ScalarIndex;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Accessing Array Slices with Index Vectors ", "Section"], Cell[TextData[List["When at least one of the index expressions in an array indexing operation is a vector expression, a subsection (slice) of the array is accessed rather than a single element. Such an index vector must be a vector of integer values, where each value must be within the size bounds for the particular array dimension. An index vector can be constructed in any way but it is often convenient to use the colon operator to construct a range vector of index values. A single colon without operands used as an index expression at a dimension k of an array of ", StyleBox["X", Rule[FontFamily, "Courier"]], " denotes all indices of that dimension and is equivalent to the index vector ", StyleBox["1:size(X, k)", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["class ArraySlice\n  Real x1 \t = X[2, 1];\t\t\t\t// Retrieves the value 3\n  Real x2[3] = X[:, 1];\t\t\t\t// Gets the first column of X as the vector {1, 3, 8}\n  Real x3[2] = X[2, :];\t\t\t\t// Gets the second row of X as the vector {3, 4}\n  Real x4[2] = X[2, 1:2];\t\t\t// Same as above, i.e. {3, 4}\n  Real x5[2] = X[2, {1, 2}];\t\t// Same as above, i.e. {3, 4}\n  Real x6[1] = X[2, {2}];\t\t\t// Half of the above vector, i.e. {4}\n  Real x7[3, 1] = X[:, 1:1];\t\t// Gets the first column of X as \n  \t\t\t\t\t\t\t\t\t// column matrix {{1}, {3}, {8}}\n  Real x8[1, 2] = X[{2}, :];\t\t// Gets the second row of X as the row matrix {{3, 4}}\n  Real x9[2, 2] = X[{2, 3}, {1, 2}];\t// Extract submatrix given {{3, 4}, {8, 9}}\n  \n  Real w1[3] = w[2:4];\t\t\t\t// Get the 2:nd through 4:th elements as {16, 17, 18}\n  Real w2[2] = w[{1, 3}];\t\t\t// Get the 1:st and 3:rd elements as {15, 17}\n  Real w3[2] = w[1:2:4];\t\t\t// Get the 1:st to 4:th step 2 elements as {15, 17}\n  \n  Real X[3, 2] = {{1, 2}, {3, 4}, {8, 9}};\n  Real w[4]    = {15, 16, 17, 18};\n  Real[4] y = fill(1, 4);\t\nalgorithm\n   w[3:4] := {1, 2};\t\t\t\t\t// Assignment causing w to become {15, 16, 1, 2}\nend ArraySlice;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Array Field Slices of Record Arrays ", "Section"], Cell[TextData[List["If ", StyleBox["A", Rule[FontFamily, "Courier"]], " is an array of records and m is a field of that record type, the expression ", StyleBox["A.m", Rule[FontFamily, "Courier"]], " is interpreted as an array field slice operation of that record array. It returns the array of fields: ", StyleBox["{A[1].m, A[2]m, A[3].m, ...}", Rule[FontFamily, "Courier"]], ". For example, given a record ", StyleBox["Person", Rule[FontFamily, "Courier"]], " with three fields: ", StyleBox["name", Rule[FontFamily, "Courier"]], ", ", StyleBox["age", Rule[FontFamily, "Courier"]], " and ", StyleBox["children", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[CellGroupData[List[Cell["Record Person, Function mkperson and Class p", "Subsection"], Cell["record Person\n  String \t\t\tname;\n  Integer \t\t\tage;\n  String[2]\t\t\tchildren;\nend Person;  ", "ModelicaInput"], Cell[TextData[List["\nWe have defined a record constructor function: ", StyleBox["mkperson(name, age, children)", Rule[FontFamily, "Courier"]], " in Modelica returning a Person record, which is used to define the contents of a small array ", StyleBox["persons", Rule[FontFamily, "Courier"]], " consisting of ", StyleBox["Person", Rule[FontFamily, "Courier"]], " records. "]], "Text"], Cell["function mkperson\n  input String \t\tname;\n  input Integer \tage;\n  input String[2]\tchildren;\n  output Person p;\nalgorithm\n  p.name \t\t\t:= name;\n  p.age \t\t\t:= age;\n  p.children \t\t:= children;\nend mkperson;    ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on mkperson", "Subsection"], Cell[BoxData[RowBox[List["MakeAlive", "[", "mkperson", "]"]]], "Input"], Cell[BoxData[RowBox[List["mkperson", "[", RowBox[List["\"John\"", ",", "35", ",", RowBox[List["{", RowBox[List["\"Carl\"", ",", "\"Eva\""]], "}"]]]], "]"]]], "Input"], Cell[BoxData[RowBox[List["mkperson", "[", RowBox[List[RowBox[List["name", "->", "\"John\""]], ",", RowBox[List["age", "\[Rule]", "35"]], ",", RowBox[List["children", "\[Rule]", RowBox[List["{", RowBox[List["\"Carl\"", ",", "\"Eva\""]], "}"]]]]]], "]"]]], "Input"], Cell[BoxData[RowBox[List["??", "mkperson"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["Classes PersonList and getPerson", "Subsection"], Cell["class PersonList\n  Person[3] persons = {mkperson(\"John\", 35, {\"Carl\", \"Eva\"} ),\n    \t\t\t\t  mkperson(\"Karin\", 40, {\"Anders\", \"Dan\"} ),\n   \t\t\t\t\t  mkperson(\"Lisa\", 37, {\"John\", \"Daniel\"} )\n    \t\t};\nend PersonList;", "ModelicaInput"], Cell[TextData[List["\nThe field slices ", StyleBox["persons.name,", Rule[FontFamily, "Courier"]], " ", StyleBox["persons.age and persons.children ", Rule[FontFamily, "Courier"]], " give the following results:\n"]], "Text"], Cell["class getPerson\n  PersonList pList;\n  String name[3];\n  Integer age[3];\n  String[3, 2] children;\nequation  \n  name \t\t= pList.persons.name; \t\t\t\t\t// Returns: {\"John\", \"Karin\", \"Lisa\"}\n  age \t\t= pList.persons.age;\t\t\t\t\t// Returns: {35, 40, 37}\n  children \t= pList.persons.children;\t\t\t\t// Returns: {{\"Carl\", \"Eva\"}, \n  \t\t\t\t\t\t\t\t\t\t\t\t\t//\t\t\t {\"Anders\", \"Dan\"}, \n  \t\t\t\t\t\t\t\t\t\t\t\t\t//\t\t\t {\"John\", \"Daniel\"}}\nend getPerson;  ", "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[832, 889]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]