List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Application of Scalar Functions to Arrays", "Title"], Cell[TextData[List["\nIt is possible to apply a function to array values if an obvious generalization to element-wise application of the function is possible. Modelica functions with one scalar return value can be applied to arrays element-wise, e.g. if ", StyleBox["v", Rule[FontFamily, "Courier"]], " is a vector of reals, then ", StyleBox["sin(v)", Rule[FontFamily, "Courier"]], " is a vector where each element is the result of applying the function ", StyleBox["sin", Rule[FontFamily, "Courier"]], " to the corresponding element in ", StyleBox["v", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[CellGroupData[List[Cell["One Return Value", "Section"], Cell["class OneReturnValue\n  Real a = 1, b = 0, c = 1;\n  Real s1[3] = sin({a, b, c});\t\t// Vector argument, result: {sin(a), sin(b), sin(c)}\n  Real s2[2, 2] = sin([1, 2; 3, 4]);\n  \t\t\t\t\t\t\t\t\t// Matrix argument, result: [sin(1), sin(2); sin(3), sin(4)]\nend OneReturnValue;  ", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of Multiplication", "Subsection"], Cell["simulate( OneReturnValue );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(OneReturnValue\\) : 2004-1-30 13:49:14.7427150 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 12 variables>\\n\\!\\({\\*TagBox[\\\"a\\\", HoldForm], \\*TagBox[\\\"b\\\", HoldForm], \\*TagBox[\\\"c\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(s1 \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s1 \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s1 \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(s2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["s1", "\[LeftDoubleBracket]", "3", "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Closed]]], Open]], Cell[CellGroupData[List[Cell["Returning More Values", "Section"], Cell[TextData[List["Functions with more than one argument can be generalized to element-wise application. If more than one argument is generalized to an array, all of the arguments have to be of the same size, and they are traversed in parallel. This is the case in the axample with the function ", StyleBox["atan2(x, y)", Rule[FontFamily, "Courier"]], " below. The function: ", StyleBox["atan2Add(w, x, y) = w + atan2(x, y)", Rule[FontFamily, "Courier"]], "adds a value w to each application of ", StyleBox["atan2", Rule[FontFamily, "Courier"]], ".\n"]], "Text", Rule[TextAlignment, Left]], Cell[TextData[List["class SeveralArguments\n  Real a = 1, b = 0, c = 1, d = 0, e = 1, f = 0;\n  Real at[3] ", StyleBox["= atan2({a, b, c}, {d, e, f});", Rule[FontColor, RGBColor[0, 0, 1]]], "\t   // Result: {atan2(a, d), atan2(b, e), atan2(c, f)}  \n  Real atAdd[2]", StyleBox[" = atan2Add(2, {a, b}, {d, e}); ", Rule[FontColor, RGBColor[0, 0, 1]]], "// Result: {2 + atan2(a, d), 2 + atan2(b, e)}\nend SeveralArguments;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["SumVec", "Section"], Cell[TextData[List["Formal function parameters that are generalized to higher dimension arrays need not necessarily be scalars. For example, the function:\n\n", StyleBox["\t\t\t\t\t\t\tatan2SumVec(v1, v2) = atan2(sum(v1), sum(v2))\n\t\t\t\t\t\t\t\n", Rule[FontFamily, "Courier"]], "used below has two formal parameters ", StyleBox["v1", Rule[FontFamily, "Courier"]], " and ", StyleBox["v2", Rule[FontFamily, "Courier"]], " of type ", StyleBox["Real[:]", Rule[FontFamily, "Courier"]], " computing ", StyleBox["atan2", Rule[FontFamily, "Courier"]], " on the sums of the argument vectors. Applying this function on a matrix which is a vector of vectors gives a result which is a vector. Calling this function with two matrices M1 and M2 as arguments gives the following result:\t\n\t\t\t"]], "Text"], Cell["class SumVec\n  Real[3] v1 = {1, 2, 3};\n  Real[3] v2 = {6, 4, 5};\n  Real[3] v3 = {3, 7, 6};\n  Real[3] v4 = {1, 3, 8};\n  Real[2, 3] M1 = {v1, v2};\n  Real[2, 3] M2 = {v3, v4};\n  \n  Real sv1[2] = atan2SumVec(M1, M2);\t\t\t\t\t\n  \t// atan2SumVec({v1, v2}, {v3, v4}) <=> {atan2(sum(v1), sum(v2)), atan2(sum(v3), sum(v4))}\n  \t\n  Real sv2[2] = atan2SumVec({{1, 2}, {3, 4}}, {{6, 7}, {8, 9}});\n  \t// {atan2(sum({1, 2}), sum({3, 4})), atan2(sum({6, 7}), sum({8, 9}))} \n  \t// <=> {atan2(3, 7), atan2(13, 17) }\nend SumVec;", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[961, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]