List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Array Types and Type Checking", "Title"], Cell[CellGroupData[List[Cell["ColorPixel", "Section"], Cell[TextData[List["It is possible to declare user-defined array types analogously to other user-defined types. For example, a ", StyleBox["ColorPixel", Rule[FontFamily, "Courier"]], " can be defined as a three-element vector representing the three base colors, and a variable image declared as a matrix of such pixels.\n\nThe expanded type of an array is the multidimensional array which is constructed by taking the first dimensions from the variable declaration and subsequent dimensions from the maximally expanded array element type of the declaration. Note that we are not using ColorPixel[512, 512] as in the book, because of the incredible amount of variables it would imply.\n"]], "Text"], Cell["type ColorPixel = Real[3];", "ModelicaInput"], Cell["", "Text"], Cell["class ColorPixelInst\n  ColorPixel[10, 10] image = fill(10, 10, 10, 3);\nend ColorPixelInst;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of ColorPixelInst", "Subsection"], Cell["simulate( ColorPixelInst );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ColorPixelInst\\) : 2004-1-30 13:25:59.1415018 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 302 variables>\\nVariables of range 100 and depth Infinity listed: \\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(10, 9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(1, 9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(2, 9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(image \[LeftDoubleBracket] \\(\\(3, 2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell[BoxData[RowBox[List[RowBox[List["image", "\[LeftDoubleBracket]", RowBox[List["1", ",", "6", ",", "3"]], "\[RightDoubleBracket]"]], "[", "0", "]"]]], "Input"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Voltage and Current", "Section"], Cell[TextData[List["Consider the definition of the notion of the expanded type in the example below. The user-defined types ", StyleBox["Voltage", Rule[FontFamily, "Courier"]], " and ", StyleBox["Current", Rule[FontFamily, "Courier"]], " are defined using type definitions."]], "Text"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Pin", "Section"], Cell[TextData[List[StyleBox["Pin", Rule[FontFamily, "Courier"]], " is defined through the declaration of a connector. The type of ", StyleBox["v", Rule[FontFamily, "Courier"]], " and ", StyleBox["i", Rule[FontFamily, "Courier"]], " is ", StyleBox["Voltage", Rule[FontFamily, "Courier"]], " and the expanded type of ", StyleBox["v", Rule[FontFamily, "Courier"]], " and ", StyleBox["i", Rule[FontFamily, "Courier"]], " is ", StyleBox["Real", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["connector Pin \n  Voltage v;\t\t\t\t\t\t\t\n  flow Current i;\t\t\nend Pin;", "ModelicaInput"], Cell["", "Text"], Cell["This is not allowed in the current version of Modelica, so the simulation of this example won't work.", "Text"], Cell["type MultiPin = Pin[5];", "ModelicaInput"], Cell[TextData[List["\nThe type of p is ", StyleBox["MultiPin[4]", Rule[FontFamily, "Courier"]], ", expanded type is ", StyleBox["Pin[4, 5]", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class MPInst\n  MultiPin[4] p;\t\t\t\nend MPInst;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Point", "Section"], Cell[TextData[List["The array variables ", StyleBox["p1", Rule[FontFamily, "Courier"]], " and ", StyleBox["p2", Rule[FontFamily, "Courier"]], " have identical expanded types of ", StyleBox["Real[10,3]", Rule[FontFamily, "Courier"]], " which makes the two equations in ", StyleBox["PointSum", Rule[FontFamily, "Courier"]], " correct."]], "Text"], Cell["type Point = Real[3];", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class PointInst\n  Point[10] \t\tp1 = fill(8, 10, 3);\n  Real[10, 3] \t\tp2 = fill(16, 10, 3);\n  ", StyleBox["Real r[3] = p1[2, :];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Equivalent to r[3] = p1[2]\n//equation  \n  //p2", StyleBox["[5, :] = p1[2, :] + p1[4, :];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Equivalent to p2[5] = p1[2] + p2[4]\nend PointInst;  "]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["class PointSum\t\n ", StyleBox[" extends PointInst(p2[5, :] = p1[2, :] + p1[4, :]);\n  Real r[3] = p1[2, :];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t// Equivalent to r[3] = p1[2]\n//equation\t\n  //", StyleBox["p2[5] = p1[2] + p2[4];", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Equivalent to p2[5, :] = p1[2, :] + p2[4, :]\nend PointSum;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of PointSum", "Subsection"], Cell["simulate( PointInst );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PointInst\\) : 2004-1-30 13:29:55.4050500 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 65 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["simulate( PointSum );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(PointSum\\) : 2004-1-30 13:26:24.3285182 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 65 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p1 \[LeftDoubleBracket] \\(\\(9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(p2 \[LeftDoubleBracket] \\(\\(9, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(r \[LeftDoubleBracket] \\(\\(3\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[884, 822]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 31]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]