List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Creating Instances", "Title"], Cell[TextData[List["\nA class decleration creates a type name which makes it possible to declare variables of that type, also known as an instance of the class. First we declare the class ", StyleBox["Point", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class Point\t\t\t\t\t\t\t\t\"Point in a three-dimensional space\"\n  public\n    parameter Real x;\n    parameter Real y;\n    parameter Real z;\nend Point;    ", "ModelicaInput"], Cell[TextData[List["\nTo create new instances the \"new\" keyword is not used as is common in object-oriented programming languages, since it does not exist in Modelica. In ", StyleBox["MyPoints", Rule[FontFamily, "Courier"]], " three instances of ", StyleBox["Point", Rule[FontFamily, "Courier"]], " are created."]], "Text"], Cell["class MyPoints\n  Point point1(x = 1, y = 2, z = 3);\n  Point point2;\n  Point point3;\nend MyPoints;", "ModelicaInput"], Cell[TextData[List["\n", StyleBox["MyPointsInst", Rule[FontFamily, "Courier"]], " creates three new ", StyleBox["Points", Rule[FontFamily, "Courier"]], " by instantiating ", StyleBox["MyPoints", Rule[FontFamily, "Courier"]], ". There are two different ways to give the variables initial values when creating the instance as shown in ", StyleBox["MyPointsInst", Rule[FontFamily, "Courier"]], " and ", StyleBox["MyPointsInst2", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["class MyPointsInst\n  MyPoints pts(point1(x= 1, y = 2, z = 3));\nend MyPointsInst;", "ModelicaInput"], Cell["", "Text"], Cell["class MyPointsInst2\n  MyPoints pts(point1.x = 1, point1.y = 2, point1.z = 3);\nend MyPointsInst2;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of MyPoints", "Section"], Cell["simulate( MyPoints );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MyPoints\\) : 2004-2-4 11:2:6.8681881 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 11 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(point1 . x\\), HoldForm], \\*TagBox[\\(point1 . y\\), HoldForm], \\*TagBox[\\(point1 . z\\), HoldForm], \\*TagBox[\\(point2 . x\\), HoldForm], \\*TagBox[\\(point2 . y\\), HoldForm], \\*TagBox[\\(point2 . z\\), HoldForm], \\*TagBox[\\(point3 . x\\), HoldForm], \\*TagBox[\\(point3 . y\\), HoldForm], \\*TagBox[\\(point3 . z\\), HoldForm]}\\)\""], "Output"], Cell["simulate( MyPointsInst );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(MyPointsInst\\) : 2004-2-4 11:2:13.1649422 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 11 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(pts . point1 . x\\), HoldForm], \\*TagBox[\\(pts . point1 . y\\), HoldForm], \\*TagBox[\\(pts . point1 . z\\), HoldForm], \\*TagBox[\\(pts . point2 . x\\), HoldForm], \\*TagBox[\\(pts . point2 . y\\), HoldForm], \\*TagBox[\\(pts . point2 . z\\), HoldForm], \\*TagBox[\\(pts . point3 . x\\), HoldForm], \\*TagBox[\\(pts . point3 . y\\), HoldForm], \\*TagBox[\\(pts . point3 . z\\), HoldForm]}\\)\""], "Output"]], Closed]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[851, 924]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]