List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Local Classes ", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["In Modelica it is possible to define ", StyleBox["local", Rule[FontFamily, "Courier"]], " classes nested inside a class, like ", StyleBox["Lpin", Rule[FontFamily, "Courier"]], " in ", StyleBox["C1", Rule[FontFamily, "Courier"]], " below. "]], "Text"], Cell[TextData[List["class C1\n  ", StyleBox["class Lpin\t\t\t\t\t\t\t// Local class\n    Real p;\n  end Lpin;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  ", StyleBox["class Voltage = Real(unit=\"kV\");\t\t// Local class", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  Voltage v1 = 5, v2 = 1;\n  Lpin pn(p = 2);\nend C1;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of C1", "Section"], Cell["simulate( C1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(C1\\) : 2004-1-30 10:1:10.3611139 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(pn . p\\), HoldForm], \\*TagBox[\\\"v1\\\", HoldForm], \\*TagBox[\\\"v2\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["Classes That Contain Local Classes", "Section"], Cell[TextData[List["Local classes are considered as elements of the type of the class within which they are declared. The \"", StyleBox["field name", Rule[FontSlant, "Italic"]], "\" of such a local class is the class name, and the type is the type representation of the local class as a set of pairs according to our general type representation.\n"]], "Text"], Cell[TextData[List["class Main\n  constant Real x = 3.14;\t\t\t\t// field x\n  \n ", StyleBox[" class LocalClass1", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Local class\n    ", StyleBox["Integer x;\n  equation\n    x = 2;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t// Refers to local x inside LocalClass1\n  ", StyleBox["end LocalClass1;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  ", StyleBox["class LocalClass2", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t// Local class\n    ", StyleBox["Real y;\n  equation\n    x = y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t\t\t\t\t\t\t// Refers to x in Main\n  ", StyleBox["end LocalClass2;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  LocalClass1 L1x;\t\t\t\t\t\t// field L1x, instance of LocalClass1\n  LocalClass2 L2x;\t\t\t\t\t\t// field L2x, instance of LocalClass2\n \nend Main;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Main", "Section"], Cell["simulate( Main );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Main\\) : 2004-1-30 10:1:44.0787849 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 5 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(L1x . x\\), HoldForm], \\*TagBox[\\(L2x . y\\), HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"]], Open]], Cell[CellGroupData[List[Cell["Alternative to Local Classes", "Section"], Cell[TextData[List["The local classes ", StyleBox["LocalClass1", Rule[FontFamily, "Courier"]], " and ", StyleBox["LocalClass2", Rule[FontFamily, "Courier"]], " could be moved outside the class ", StyleBox["Main", Rule[FontFamily, "Courier"]], " with some changes of names. "]], "Text"], Cell["class Main_LocalClass1\t\t\t\t\t// Hypothetical LocalClass1 outside Main\n  Integer x;\nequation\n  x = 2;\t\t\t\t\t\t\t\t// Refers to local x inside Main_LocalClass1\nend Main_LocalClass1;", "ModelicaInput"], Cell["", "Text"], Cell["class Main_LocalClass2\t\t\t\t// Hypothetical LocalClass2 outside Main\n  Real y;\n  Main main;\nequation\n  main.x = y;\t\t\t\t\t\t// Refers to x in the main instance of Main\nend Main_LocalClass2;", "ModelicaInput"], Cell["", "Text"], Cell["class Main2\t\t\t\t\t\t\t// Hypothetical Main referrring to outside LocalClass1 and LocalClass2\n  Real x;\t\t\t\t\t\t\t// field x  \n  Main_LocalClass1 L1x;\t\t\t\t// field L1x, instance of Main_LocalClass1\n  Main_LocalClass2 L2x;\t\t\t\t// field L2x, instance of Main_LocalClass2\nequation\n  x = 3.14;\nend Main2;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Main2", "Section"], Cell["simulate( Main2 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Main2\\) : 2004-1-30 10:1:53.4222359 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(L1x . x\\), HoldForm], \\*TagBox[\\(L2x . main . L1x . x\\), HoldForm], \\*TagBox[\\(L2x . main . L2x . y\\), HoldForm], \\*TagBox[\\(L2x . main . x\\), HoldForm], \\*TagBox[\\(L2x . y\\), HoldForm], \\*TagBox[\\\"x\\\", HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[922, 903]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]