List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Partial Classes Describe Common Properties", "Title"], Cell[CellGroupData[List[Cell["Types from Modelica.SIunits", "Section"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Section"], Cell["connector Pin\n  Voltage v;\n  flow Current i;\nend Pin;  ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Components", "Section"], Cell[CellGroupData[List[Cell["TwoPin", "Subsection"], Cell[TextData[List["The class prefix ", StyleBox["partial", Rule[FontFamily, "Courier"]], " is used to indicate that a class is incomplete such that it cannot be instatiated. The class ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], " can be used to define our own ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], ", ", StyleBox["Capacitor", Rule[FontFamily, "Courier"]], ", ", StyleBox["Inductor", Rule[FontFamily, "Courier"]], ", Voltage source AC and Ground classes.\n"]], "Text"], Cell["partial class TwoPin\t\t\t\t\"Superclass of elements with two electrical pins\"\n  Pin p, n;\n  Voltage v;\n  Current i;\nequation\n  v = p.v - n.v;\n  p.i + n.i = 0;\n  i = p.i;\nend TwoPin;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Resistor", "Subsection"], Cell["class Resistor \t\t\t\t\t\t\"Ideal electrical Resistor\"\n  extends TwoPin;\n  parameter Real R(unit = \"Ohm\") \t\"Resistance\";\nequation\n  R*i = v;\nend Resistor;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Capacitor", "Subsection"], Cell["class Capacitor \t\t\t\t\t\"Ideal electrical Capacitor\"\n  extends TwoPin;\n  parameter Real C(unit = \"F\") \t\t\"Capacitance\";\nequation\n  C*der(v) = i;\nend Capacitor;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Inductor", "Subsection"], Cell["class Inductor \t\t\t\t\t\t\"Ideal electrical Inductor\"\n  extends TwoPin;\n  parameter Real L(unit = \"H\") \t\t\"Inductance\";\nequation\n  v = L*der(i);\nend Inductor;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["VsourceAC", "Subsection"], Cell["class VsourceAC \t\t\t\t\t\"Sin-wave voltage source\"\n  extends TwoPin;\n  parameter Voltage VA\t\t\t= 220 \"Amplitude\";\n  parameter Real f(unit = \"Hz\") = 50 \"Frequency\";\n  constant Real PI\t\t\t\t= 3.141592653589793;\n  input    Voltage u;\nequation\n  v = u;\n  u = VA*sin(2*PI*f*time);\nend VsourceAC;  ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Ground", "Subsection"], Cell["class Ground \n  Pin p;\nequation\n  p.v = 0;\nend Ground;", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["SimpleCircuit", "Section"], Cell["Based on these classes we can declare the Simple Circuit Model: ", "Text"], Cell["class SimpleCircuit\n  Resistor \t\tR1(R = 10);\n  Capacitor \tC(C = 0.01);\n  Resistor \t\tR2(R = 100);\n  Inductor \t\tL(L = 0.1);\n  VsourceAC \tAC(f = 1);\n  Ground \t\tG;\nequation\n  connect(AC.p, R1.p);\t\t\t// 1, Capacitor circuit\n  connect(R1.n, C.p);\t\t\t//    Wire 2\n  connect(C.n, AC.n);\t\t\t// \t  Wire 3\n  connect(R1.p, R2.p);\t\t\t// 2, Inductor circuit\n  connect(R2.n, L.p);\t\t\t//    Wire 5\n  connect(L.n, C.n);\t\t\t// \t  Wire 6\n  connect(AC.n, G.p);\t\t\t// 7, Ground\nend SimpleCiruit;    ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["SimpleCircuit Simulation", "Section"], Cell["simulate( SimpleCircuit );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(SimpleCircuit\\) : 2004-2-2 13:11:40.2943786 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 42 variables>\\n\\!\\({\\*TagBox[\\(AC . f\\), HoldForm], \\*TagBox[\\(AC . i\\), HoldForm], \\*TagBox[\\(AC . n . i\\), HoldForm], \\*TagBox[\\(AC . n . v\\), HoldForm], \\*TagBox[\\(AC . p . i\\), HoldForm], \\*TagBox[\\(AC . PI\\), HoldForm], \\*TagBox[\\(AC . p . v\\), HoldForm], \\*TagBox[\\(AC . u\\), HoldForm], \\*TagBox[\\(AC . v\\), HoldForm], \\*TagBox[\\(AC . VA\\), HoldForm], \\*TagBox[\\(C . C\\), HoldForm], \\*TagBox[\\(C . i\\), HoldForm], \\*TagBox[\\(C . n . i\\), HoldForm], \\*TagBox[\\(C . n . v\\), HoldForm], \\*TagBox[\\(C . p . i\\), HoldForm], \\*TagBox[\\(C . p . v\\), HoldForm], \\*TagBox[\\(C . v\\), HoldForm], \\*TagBox[\\(G . p . i\\), HoldForm], \\*TagBox[\\(G . p . v\\), HoldForm], \\*TagBox[\\(L . i\\), HoldForm], \\*TagBox[\\(L . L\\), HoldForm], \\*TagBox[\\(L . n . i\\), HoldForm], \\*TagBox[\\(L . n . v\\), HoldForm], \\*TagBox[\\(L . p . i\\), HoldForm], \\*TagBox[\\(L . p . v\\), HoldForm], \\*TagBox[\\(L . v\\), HoldForm], \\*TagBox[\\(R1 . i\\), HoldForm], \\*TagBox[\\(R1 . n . i\\), HoldForm], \\*TagBox[\\(R1 . n . v\\), HoldForm], \\*TagBox[\\(R1 . p . i\\), HoldForm], \\*TagBox[\\(R1 . p . v\\), HoldForm], \\*TagBox[\\(R1 . R\\), HoldForm], \\*TagBox[\\(R1 . v\\), HoldForm], \\*TagBox[\\(R2 . i\\), HoldForm], \\*TagBox[\\(R2 . n . i\\), HoldForm], \\*TagBox[\\(R2 . n . v\\), HoldForm], \\*TagBox[\\(R2 . p . i\\), HoldForm], \\*TagBox[\\(R2 . p . v\\), HoldForm], \\*TagBox[\\(R2 . R\\), HoldForm], \\*TagBox[\\(R2 . v\\), HoldForm], \\*TagBox[SuperscriptBox[\\((C . v)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((L . i)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( {R1.v, R2.v } );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.309017 0.00133779 [\n[.21429 .29652 -9 -9 ]\n[.21429 .29652 9 0 ]\n[.40476 .29652 -9 -9 ]\n[.40476 .29652 9 0 ]\n[.59524 .29652 -9 -9 ]\n[.59524 .29652 9 0 ]\n[.78571 .29652 -9 -9 ]\n[.78571 .29652 9 0 ]\n[.97619 .29652 -3 -9 ]\n[.97619 .29652 3 0 ]\n[1.025 .30902 0 -6.28125 ]\n[1.025 .30902 10 6.28125 ]\n[.01131 .04146 -24 -4.5 ]\n[.01131 .04146 0 4.5 ]\n[.01131 .17524 -24 -4.5 ]\n[.01131 .17524 0 4.5 ]\n[.01131 .4428 -18 -4.5 ]\n[.01131 .4428 0 4.5 ]\n[.01131 .57657 -18 -4.5 ]\n[.01131 .57657 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30902 m\n.21429 .31527 L\ns\n[(0.2)] .21429 .29652 0 1 Mshowa\n.40476 .30902 m\n.40476 .31527 L\ns\n[(0.4)] .40476 .29652 0 1 Mshowa\n.59524 .30902 m\n.59524 .31527 L\ns\n[(0.6)] .59524 .29652 0 1 Mshowa\n.78571 .30902 m\n.78571 .31527 L\ns\n[(0.8)] .78571 .29652 0 1 Mshowa\n.97619 .30902 m\n.97619 .31527 L\ns\n[(1)] .97619 .29652 0 1 Mshowa\n.125 Mabswid\n.07143 .30902 m\n.07143 .31277 L\ns\n.11905 .30902 m\n.11905 .31277 L\ns\n.16667 .30902 m\n.16667 .31277 L\ns\n.2619 .30902 m\n.2619 .31277 L\ns\n.30952 .30902 m\n.30952 .31277 L\ns\n.35714 .30902 m\n.35714 .31277 L\ns\n.45238 .30902 m\n.45238 .31277 L\ns\n.5 .30902 m\n.5 .31277 L\ns\n.54762 .30902 m\n.54762 .31277 L\ns\n.64286 .30902 m\n.64286 .31277 L\ns\n.69048 .30902 m\n.69048 .31277 L\ns\n.7381 .30902 m\n.7381 .31277 L\ns\n.83333 .30902 m\n.83333 .31277 L\ns\n.88095 .30902 m\n.88095 .31277 L\ns\n.92857 .30902 m\n.92857 .31277 L\ns\n.25 Mabswid\n0 .30902 m\n1 .30902 L\ns\ngsave\n1.025 .30902 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .04146 m\n.03006 .04146 L\ns\n[(-200)] .01131 .04146 1 0 Mshowa\n.02381 .17524 m\n.03006 .17524 L\ns\n[(-100)] .01131 .17524 1 0 Mshowa\n.02381 .4428 m\n.03006 .4428 L\ns\n[(100)] .01131 .4428 1 0 Mshowa\n.02381 .57657 m\n.03006 .57657 L\ns\n[(200)] .01131 .57657 1 0 Mshowa\n.125 Mabswid\n.02381 .06821 m\n.02756 .06821 L\ns\n.02381 .09497 m\n.02756 .09497 L\ns\n.02381 .12173 m\n.02756 .12173 L\ns\n.02381 .14848 m\n.02756 .14848 L\ns\n.02381 .20199 m\n.02756 .20199 L\ns\n.02381 .22875 m\n.02756 .22875 L\ns\n.02381 .25551 m\n.02756 .25551 L\ns\n.02381 .28226 m\n.02756 .28226 L\ns\n.02381 .33577 m\n.02756 .33577 L\ns\n.02381 .36253 m\n.02756 .36253 L\ns\n.02381 .38928 m\n.02756 .38928 L\ns\n.02381 .41604 m\n.02756 .41604 L\ns\n.02381 .46955 m\n.02756 .46955 L\ns\n.02381 .49631 m\n.02756 .49631 L\ns\n.02381 .52306 m\n.02756 .52306 L\ns\n.02381 .54982 m\n.02756 .54982 L\ns\n.02381 .0147 m\n.02756 .0147 L\ns\n.02381 .60333 m\n.02756 .60333 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .30902 m\n.02571 .31268 L\n.02762 .31627 L\n.02952 .31978 L\n.03143 .32323 L\n.03333 .3266 L\n.03524 .32991 L\n.03714 .33314 L\n.03905 .33631 L\n.04095 .33941 L\n.04286 .34245 L\n.04476 .34541 L\n.04667 .34832 L\n.04857 .35115 L\n.05048 .35393 L\n.05238 .35664 L\n.05429 .35929 L\n.05619 .36188 L\n.0581 .3644 L\n.06 .36687 L\n.0619 .36928 L\n.06381 .37163 L\n.06571 .37391 L\n.06762 .37615 L\n.06952 .37832 L\n.07143 .38044 L\n.07333 .3825 L\n.07524 .3845 L\n.07714 .38645 L\n.07905 .38835 L\n.08095 .39019 L\n.08286 .39198 L\n.08476 .39372 L\n.08667 .3954 L\n.08857 .39703 L\n.09048 .39861 L\n.09238 .40014 L\n.09429 .40162 L\n.09619 .40305 L\n.0981 .40443 L\n.1 .40576 L\n.1019 .40704 L\n.10381 .40827 L\n.10571 .40946 L\n.10762 .4106 L\n.10952 .41169 L\n.11143 .41274 L\n.11333 .41374 L\n.11524 .41469 L\n.11714 .4156 L\nMistroke\n.11905 .41647 L\n.12095 .41729 L\n.12286 .41807 L\n.12476 .4188 L\n.12667 .41949 L\n.12857 .42014 L\n.13048 .42075 L\n.13238 .42131 L\n.13429 .42184 L\n.13619 .42232 L\n.1381 .42276 L\n.14 .42316 L\n.1419 .42352 L\n.14381 .42384 L\n.14571 .42413 L\n.14762 .42437 L\n.14952 .42458 L\n.15143 .42474 L\n.15333 .42487 L\n.15524 .42497 L\n.15714 .42502 L\n.15905 .42504 L\n.16095 .42502 L\n.16286 .42497 L\n.16476 .42488 L\n.16667 .42476 L\n.16857 .4246 L\n.17048 .42441 L\n.17238 .42418 L\n.17429 .42392 L\n.17619 .42363 L\n.1781 .4233 L\n.18 .42294 L\n.1819 .42255 L\n.18381 .42213 L\n.18571 .42167 L\n.18762 .42118 L\n.18952 .42066 L\n.19143 .42012 L\n.19333 .41954 L\n.19524 .41893 L\n.19714 .41829 L\n.19905 .41762 L\n.20095 .41693 L\n.20286 .4162 L\n.20476 .41545 L\n.20667 .41467 L\n.20857 .41386 L\n.21048 .41302 L\n.21238 .41216 L\nMistroke\n.21429 .41127 L\n.21619 .41036 L\n.2181 .40941 L\n.22 .40845 L\n.2219 .40746 L\n.22381 .40644 L\n.22571 .4054 L\n.22762 .40433 L\n.22952 .40325 L\n.23143 .40213 L\n.23333 .401 L\n.23524 .39984 L\n.23714 .39866 L\n.23905 .39746 L\n.24095 .39623 L\n.24286 .39499 L\n.24476 .39372 L\n.24667 .39243 L\n.24857 .39113 L\n.25048 .3898 L\n.25238 .38845 L\n.25429 .38709 L\n.25619 .3857 L\n.2581 .3843 L\n.26 .38288 L\n.2619 .38144 L\n.26381 .37998 L\n.26571 .3785 L\n.26762 .37701 L\n.26952 .37551 L\n.27143 .37398 L\n.27333 .37244 L\n.27524 .37089 L\n.27714 .36932 L\n.27905 .36773 L\n.28095 .36613 L\n.28286 .36452 L\n.28476 .36289 L\n.28667 .36125 L\n.28857 .3596 L\n.29048 .35794 L\n.29238 .35626 L\n.29429 .35457 L\n.29619 .35287 L\n.2981 .35116 L\n.3 .34943 L\n.3019 .3477 L\n.30381 .34596 L\n.30571 .3442 L\n.30762 .34244 L\nMistroke\n.30952 .34067 L\n.31143 .33889 L\n.31333 .3371 L\n.31524 .3353 L\n.31714 .3335 L\n.31905 .33169 L\n.32095 .32987 L\n.32286 .32805 L\n.32476 .32621 L\n.32667 .32438 L\n.32857 .32253 L\n.33048 .32069 L\n.33238 .31883 L\n.33429 .31698 L\n.33619 .31512 L\n.3381 .31325 L\n.34 .31138 L\n.3419 .30951 L\n.34381 .30764 L\n.34571 .30576 L\n.34762 .30389 L\n.34952 .30201 L\n.35143 .30012 L\n.35333 .29824 L\n.35524 .29636 L\n.35714 .29448 L\n.35905 .29259 L\n.36095 .29071 L\n.36286 .28883 L\n.36476 .28695 L\n.36667 .28507 L\n.36857 .28319 L\n.37048 .28132 L\n.37238 .27944 L\n.37429 .27757 L\n.37619 .27571 L\n.3781 .27384 L\n.38 .27198 L\n.3819 .27013 L\n.38381 .26828 L\n.38571 .26643 L\n.38762 .26459 L\n.38952 .26275 L\n.39143 .26092 L\n.39333 .2591 L\n.39524 .25728 L\n.39714 .25547 L\n.39905 .25366 L\n.40095 .25187 L\n.40286 .25008 L\nMistroke\n.40476 .24829 L\n.40667 .24652 L\n.40857 .24476 L\n.41048 .243 L\n.41238 .24125 L\n.41429 .23952 L\n.41619 .23779 L\n.4181 .23607 L\n.42 .23436 L\n.4219 .23267 L\n.42381 .23098 L\n.42571 .22931 L\n.42762 .22764 L\n.42952 .22599 L\n.43143 .22435 L\n.43333 .22273 L\n.43524 .22111 L\n.43714 .21951 L\n.43905 .21792 L\n.44095 .21635 L\n.44286 .21479 L\n.44476 .21324 L\n.44667 .21171 L\n.44857 .21019 L\n.45048 .20869 L\n.45238 .2072 L\n.45429 .20572 L\n.45619 .20427 L\n.4581 .20282 L\n.46 .2014 L\n.4619 .19999 L\n.46381 .1986 L\n.46571 .19722 L\n.46762 .19586 L\n.46952 .19452 L\n.47143 .19319 L\n.47333 .19188 L\n.47524 .19059 L\n.47714 .18932 L\n.47905 .18807 L\n.48095 .18683 L\n.48286 .18562 L\n.48476 .18442 L\n.48667 .18324 L\n.48857 .18208 L\n.49048 .18095 L\n.49238 .17983 L\n.49429 .17873 L\n.49619 .17765 L\n.4981 .17659 L\nMistroke\n.5 .17555 L\n.5019 .17453 L\n.50381 .17353 L\n.50571 .17255 L\n.50762 .1716 L\n.50952 .17066 L\n.51143 .16975 L\n.51333 .16886 L\n.51524 .16799 L\n.51714 .16714 L\n.51905 .16631 L\n.52095 .16551 L\n.52286 .16473 L\n.52476 .16397 L\n.52667 .16323 L\n.52857 .16252 L\n.53048 .16183 L\n.53238 .16116 L\n.53429 .16051 L\n.53619 .15989 L\n.5381 .15929 L\n.54 .15871 L\n.5419 .15816 L\n.54381 .15763 L\n.54571 .15713 L\n.54762 .15665 L\n.54952 .15619 L\n.55143 .15575 L\n.55333 .15534 L\n.55524 .15496 L\n.55714 .15459 L\n.55905 .15426 L\n.56095 .15394 L\n.56286 .15365 L\n.56476 .15339 L\n.56667 .15315 L\n.56857 .15293 L\n.57048 .15274 L\n.57238 .15257 L\n.57429 .15243 L\n.57619 .15231 L\n.5781 .15221 L\n.58 .15214 L\n.5819 .1521 L\n.58381 .15208 L\n.58571 .15208 L\n.58762 .15211 L\n.58952 .15216 L\n.59143 .15224 L\n.59333 .15234 L\nMistroke\n.59524 .15247 L\n.59714 .15262 L\n.59905 .15279 L\n.60095 .15299 L\n.60286 .15322 L\n.60476 .15347 L\n.60667 .15374 L\n.60857 .15404 L\n.61048 .15436 L\n.61238 .15471 L\n.61429 .15508 L\n.61619 .15547 L\n.6181 .15589 L\n.62 .15634 L\n.6219 .1568 L\n.62381 .15729 L\n.62571 .15781 L\n.62762 .15835 L\n.62952 .15891 L\n.63143 .15949 L\n.63333 .1601 L\n.63524 .16074 L\n.63714 .16139 L\n.63905 .16207 L\n.64095 .16277 L\n.64286 .1635 L\n.64476 .16425 L\n.64667 .16502 L\n.64857 .16581 L\n.65048 .16663 L\n.65238 .16746 L\n.65429 .16832 L\n.65619 .16921 L\n.6581 .17011 L\n.66 .17104 L\n.6619 .17199 L\n.66381 .17296 L\n.66571 .17395 L\n.66762 .17496 L\n.66952 .17599 L\n.67143 .17705 L\n.67333 .17812 L\n.67524 .17922 L\n.67714 .18033 L\n.67905 .18147 L\n.68095 .18263 L\n.68286 .1838 L\n.68476 .185 L\n.68667 .18621 L\n.68857 .18745 L\nMistroke\n.69048 .1887 L\n.69238 .18997 L\n.69429 .19127 L\n.69619 .19258 L\n.6981 .1939 L\n.7 .19525 L\n.7019 .19661 L\n.70381 .198 L\n.70571 .1994 L\n.70762 .20081 L\n.70952 .20225 L\n.71143 .2037 L\n.71333 .20517 L\n.71524 .20665 L\n.71714 .20815 L\n.71905 .20966 L\n.72095 .2112 L\n.72286 .21274 L\n.72476 .2143 L\n.72667 .21588 L\n.72857 .21747 L\n.73048 .21908 L\n.73238 .2207 L\n.73429 .22233 L\n.73619 .22398 L\n.7381 .22564 L\n.74 .22731 L\n.7419 .229 L\n.74381 .2307 L\n.74571 .23241 L\n.74762 .23413 L\n.74952 .23587 L\n.75143 .23762 L\n.75333 .23938 L\n.75524 .24115 L\n.75714 .24293 L\n.75905 .24472 L\n.76095 .24652 L\n.76286 .24833 L\n.76476 .25015 L\n.76667 .25198 L\n.76857 .25381 L\n.77048 .25566 L\n.77238 .25752 L\n.77429 .25938 L\n.77619 .26125 L\n.7781 .26313 L\n.78 .26501 L\n.7819 .26691 L\n.78381 .26881 L\nMistroke\n.78571 .27071 L\n.78762 .27262 L\n.78952 .27454 L\n.79143 .27647 L\n.79333 .27839 L\n.79524 .28033 L\n.79714 .28226 L\n.79905 .2842 L\n.80095 .28615 L\n.80286 .2881 L\n.80476 .29005 L\n.80667 .29201 L\n.80857 .29396 L\n.81048 .29593 L\n.81238 .29789 L\n.81429 .29985 L\n.81619 .30182 L\n.8181 .30378 L\n.82 .30575 L\n.8219 .30772 L\n.82381 .30969 L\n.82571 .31166 L\n.82762 .31362 L\n.82952 .31559 L\n.83143 .31756 L\n.83333 .31952 L\n.83524 .32148 L\n.83714 .32344 L\n.83905 .3254 L\n.84095 .32736 L\n.84286 .32931 L\n.84476 .33126 L\n.84667 .33321 L\n.84857 .33515 L\n.85048 .33709 L\n.85238 .33902 L\n.85429 .34095 L\n.85619 .34287 L\n.8581 .34479 L\n.86 .34671 L\n.8619 .34861 L\n.86381 .35051 L\n.86571 .35241 L\n.86762 .3543 L\n.86952 .35618 L\n.87143 .35805 L\n.87333 .35991 L\n.87524 .36177 L\n.87714 .36362 L\n.87905 .36546 L\nMistroke\n.88095 .36729 L\n.88286 .36911 L\n.88476 .37092 L\n.88667 .37273 L\n.88857 .37452 L\n.89048 .3763 L\n.89238 .37807 L\n.89429 .37983 L\n.89619 .38158 L\n.8981 .38332 L\n.9 .38505 L\n.9019 .38676 L\n.90381 .38846 L\n.90571 .39015 L\n.90762 .39183 L\n.90952 .39349 L\n.91143 .39514 L\n.91333 .39678 L\n.91524 .3984 L\n.91714 .40001 L\n.91905 .4016 L\n.92095 .40318 L\n.92286 .40475 L\n.92476 .4063 L\n.92667 .40783 L\n.92857 .40935 L\n.93048 .41085 L\n.93238 .41234 L\n.93429 .41381 L\n.93619 .41526 L\n.9381 .4167 L\n.94 .41812 L\n.9419 .41952 L\n.94381 .42091 L\n.94571 .42227 L\n.94762 .42362 L\n.94952 .42496 L\n.95143 .42627 L\n.95333 .42756 L\n.95524 .42884 L\n.95714 .4301 L\n.95905 .43133 L\n.96095 .43255 L\n.96286 .43375 L\n.96476 .43493 L\n.96667 .43609 L\n.96857 .43723 L\n.97048 .43835 L\n.97238 .43945 L\n.97429 .44053 L\nMistroke\n.97619 .44158 L\nMfstroke\n0 .5 0 r\n.02381 .30902 m\n.02571 .31111 L\n.02762 .3146 L\n.02952 .31827 L\n.03143 .32196 L\n.03333 .32565 L\n.03524 .32934 L\n.03714 .33303 L\n.03905 .33671 L\n.04095 .34039 L\n.04286 .34407 L\n.04476 .34774 L\n.04667 .3514 L\n.04857 .35506 L\n.05048 .35871 L\n.05238 .36235 L\n.05429 .36598 L\n.05619 .3696 L\n.0581 .37322 L\n.06 .37682 L\n.0619 .38042 L\n.06381 .384 L\n.06571 .38757 L\n.06762 .39113 L\n.06952 .39467 L\n.07143 .3982 L\n.07333 .40172 L\n.07524 .40522 L\n.07714 .40871 L\n.07905 .41218 L\n.08095 .41564 L\n.08286 .41908 L\n.08476 .4225 L\n.08667 .4259 L\n.08857 .42929 L\n.09048 .43265 L\n.09238 .436 L\n.09429 .43932 L\n.09619 .44263 L\n.0981 .44591 L\n.1 .44918 L\n.1019 .45242 L\n.10381 .45564 L\n.10571 .45883 L\n.10762 .462 L\n.10952 .46515 L\n.11143 .46827 L\n.11333 .47137 L\n.11524 .47444 L\n.11714 .47749 L\nMistroke\n.11905 .48051 L\n.12095 .4835 L\n.12286 .48646 L\n.12476 .4894 L\n.12667 .49231 L\n.12857 .49519 L\n.13048 .49804 L\n.13238 .50086 L\n.13429 .50365 L\n.13619 .50641 L\n.1381 .50913 L\n.14 .51183 L\n.1419 .51449 L\n.14381 .51712 L\n.14571 .51972 L\n.14762 .52229 L\n.14952 .52482 L\n.15143 .52732 L\n.15333 .52978 L\n.15524 .53221 L\n.15714 .5346 L\n.15905 .53696 L\n.16095 .53928 L\n.16286 .54157 L\n.16476 .54381 L\n.16667 .54603 L\n.16857 .5482 L\n.17048 .55034 L\n.17238 .55243 L\n.17429 .55449 L\n.17619 .55651 L\n.1781 .5585 L\n.18 .56044 L\n.1819 .56234 L\n.18381 .5642 L\n.18571 .56603 L\n.18762 .56781 L\n.18952 .56955 L\n.19143 .57125 L\n.19333 .57291 L\n.19524 .57452 L\n.19714 .5761 L\n.19905 .57763 L\n.20095 .57912 L\n.20286 .58057 L\n.20476 .58197 L\n.20667 .58333 L\n.20857 .58465 L\n.21048 .58593 L\n.21238 .58716 L\nMistroke\n.21429 .58834 L\n.21619 .58949 L\n.2181 .59058 L\n.22 .59164 L\n.2219 .59265 L\n.22381 .59361 L\n.22571 .59453 L\n.22762 .59541 L\n.22952 .59624 L\n.23143 .59702 L\n.23333 .59776 L\n.23524 .59845 L\n.23714 .5991 L\n.23905 .5997 L\n.24095 .60026 L\n.24286 .60077 L\n.24476 .60123 L\n.24667 .60165 L\n.24857 .60202 L\n.25048 .60234 L\n.25238 .60262 L\n.25429 .60285 L\n.25619 .60304 L\n.2581 .60318 L\n.26 .60327 L\n.2619 .60332 L\n.26381 .60332 L\n.26571 .60327 L\n.26762 .60318 L\n.26952 .60304 L\n.27143 .60285 L\n.27333 .60262 L\n.27524 .60234 L\n.27714 .60202 L\n.27905 .60165 L\n.28095 .60123 L\n.28286 .60077 L\n.28476 .60026 L\n.28667 .5997 L\n.28857 .5991 L\n.29048 .59845 L\n.29238 .59776 L\n.29429 .59702 L\n.29619 .59624 L\n.2981 .59541 L\n.3 .59453 L\n.3019 .59361 L\n.30381 .59265 L\n.30571 .59164 L\n.30762 .59058 L\nMistroke\n.30952 .58949 L\n.31143 .58834 L\n.31333 .58716 L\n.31524 .58593 L\n.31714 .58465 L\n.31905 .58333 L\n.32095 .58197 L\n.32286 .58057 L\n.32476 .57912 L\n.32667 .57763 L\n.32857 .5761 L\n.33048 .57452 L\n.33238 .57291 L\n.33429 .57125 L\n.33619 .56955 L\n.3381 .56781 L\n.34 .56602 L\n.3419 .5642 L\n.34381 .56234 L\n.34571 .56044 L\n.34762 .55849 L\n.34952 .55651 L\n.35143 .55449 L\n.35333 .55243 L\n.35524 .55034 L\n.35714 .5482 L\n.35905 .54603 L\n.36095 .54381 L\n.36286 .54157 L\n.36476 .53928 L\n.36667 .53696 L\n.36857 .5346 L\n.37048 .53221 L\n.37238 .52978 L\n.37429 .52732 L\n.37619 .52482 L\n.3781 .52229 L\n.38 .51972 L\n.3819 .51712 L\n.38381 .51449 L\n.38571 .51183 L\n.38762 .50913 L\n.38952 .5064 L\n.39143 .50365 L\n.39333 .50086 L\n.39524 .49804 L\n.39714 .49519 L\n.39905 .49231 L\n.40095 .4894 L\n.40286 .48646 L\nMistroke\n.40476 .4835 L\n.40667 .48051 L\n.40857 .47749 L\n.41048 .47444 L\n.41238 .47137 L\n.41429 .46827 L\n.41619 .46515 L\n.4181 .462 L\n.42 .45883 L\n.4219 .45564 L\n.42381 .45242 L\n.42571 .44918 L\n.42762 .44591 L\n.42952 .44263 L\n.43143 .43932 L\n.43333 .436 L\n.43524 .43265 L\n.43714 .42929 L\n.43905 .4259 L\n.44095 .4225 L\n.44286 .41908 L\n.44476 .41564 L\n.44667 .41218 L\n.44857 .40871 L\n.45048 .40522 L\n.45238 .40172 L\n.45429 .3982 L\n.45619 .39467 L\n.4581 .39113 L\n.46 .38757 L\n.4619 .384 L\n.46381 .38042 L\n.46571 .37682 L\n.46762 .37322 L\n.46952 .3696 L\n.47143 .36598 L\n.47333 .36235 L\n.47524 .35871 L\n.47714 .35506 L\n.47905 .3514 L\n.48095 .34774 L\n.48286 .34407 L\n.48476 .34039 L\n.48667 .33671 L\n.48857 .33303 L\n.49048 .32934 L\n.49238 .32565 L\n.49429 .32196 L\n.49619 .31826 L\n.4981 .31456 L\nMistroke\n.5 .31087 L\n.5019 .30717 L\n.50381 .30347 L\n.50571 .29977 L\n.50762 .29608 L\n.50952 .29238 L\n.51143 .28869 L\n.51333 .285 L\n.51524 .28132 L\n.51714 .27764 L\n.51905 .27397 L\n.52095 .2703 L\n.52286 .26663 L\n.52476 .26298 L\n.52667 .25933 L\n.52857 .25569 L\n.53048 .25205 L\n.53238 .24843 L\n.53429 .24482 L\n.53619 .24121 L\n.5381 .23762 L\n.54 .23404 L\n.5419 .23047 L\n.54381 .22691 L\n.54571 .22336 L\n.54762 .21983 L\n.54952 .21631 L\n.55143 .21281 L\n.55333 .20932 L\n.55524 .20585 L\n.55714 .2024 L\n.55905 .19896 L\n.56095 .19554 L\n.56286 .19213 L\n.56476 .18875 L\n.56667 .18538 L\n.56857 .18204 L\n.57048 .17871 L\n.57238 .1754 L\n.57429 .17212 L\n.57619 .16886 L\n.5781 .16562 L\n.58 .1624 L\n.5819 .1592 L\n.58381 .15603 L\n.58571 .15288 L\n.58762 .14976 L\n.58952 .14666 L\n.59143 .14359 L\n.59333 .14055 L\nMistroke\n.59524 .13753 L\n.59714 .13453 L\n.59905 .13157 L\n.60095 .12863 L\n.60286 .12573 L\n.60476 .12285 L\n.60667 .12 L\n.60857 .11718 L\n.61048 .11439 L\n.61238 .11163 L\n.61429 .1089 L\n.61619 .10621 L\n.6181 .10354 L\n.62 .10091 L\n.6219 .09831 L\n.62381 .09575 L\n.62571 .09321 L\n.62762 .09072 L\n.62952 .08825 L\n.63143 .08582 L\n.63333 .08343 L\n.63524 .08107 L\n.63714 .07875 L\n.63905 .07647 L\n.64095 .07422 L\n.64286 .07201 L\n.64476 .06983 L\n.64667 .0677 L\n.64857 .0656 L\n.65048 .06354 L\n.65238 .06152 L\n.65429 .05954 L\n.65619 .0576 L\n.6581 .05569 L\n.66 .05383 L\n.6619 .05201 L\n.66381 .05023 L\n.66571 .04849 L\n.66762 .04679 L\n.66952 .04513 L\n.67143 .04351 L\n.67333 .04194 L\n.67524 .0404 L\n.67714 .03891 L\n.67905 .03747 L\n.68095 .03606 L\n.68286 .0347 L\n.68476 .03338 L\n.68667 .03211 L\n.68857 .03088 L\nMistroke\n.69048 .02969 L\n.69238 .02855 L\n.69429 .02745 L\n.69619 .02639 L\n.6981 .02539 L\n.7 .02442 L\n.7019 .0235 L\n.70381 .02263 L\n.70571 .0218 L\n.70762 .02101 L\n.70952 .02027 L\n.71143 .01958 L\n.71333 .01893 L\n.71524 .01833 L\n.71714 .01778 L\n.71905 .01727 L\n.72095 .0168 L\n.72286 .01639 L\n.72476 .01602 L\n.72667 .01569 L\n.72857 .01541 L\n.73048 .01518 L\n.73238 .01499 L\n.73429 .01485 L\n.73619 .01476 L\n.7381 .01472 L\n.74 .01472 L\n.7419 .01476 L\n.74381 .01485 L\n.74571 .01499 L\n.74762 .01518 L\n.74952 .01541 L\n.75143 .01569 L\n.75333 .01602 L\n.75524 .01639 L\n.75714 .0168 L\n.75905 .01727 L\n.76095 .01778 L\n.76286 .01833 L\n.76476 .01893 L\n.76667 .01958 L\n.76857 .02027 L\n.77048 .02101 L\n.77238 .0218 L\n.77429 .02263 L\n.77619 .0235 L\n.7781 .02442 L\n.78 .02539 L\n.7819 .0264 L\n.78381 .02745 L\nMistroke\n.78571 .02855 L\n.78762 .02969 L\n.78952 .03088 L\n.79143 .03211 L\n.79333 .03338 L\n.79524 .0347 L\n.79714 .03606 L\n.79905 .03747 L\n.80095 .03891 L\n.80286 .0404 L\n.80476 .04194 L\n.80667 .04351 L\n.80857 .04513 L\n.81048 .04679 L\n.81238 .04849 L\n.81429 .05023 L\n.81619 .05201 L\n.8181 .05383 L\n.82 .05569 L\n.8219 .0576 L\n.82381 .05954 L\n.82571 .06152 L\n.82762 .06354 L\n.82952 .0656 L\n.83143 .0677 L\n.83333 .06983 L\n.83524 .07201 L\n.83714 .07422 L\n.83905 .07647 L\n.84095 .07875 L\n.84286 .08108 L\n.84476 .08343 L\n.84667 .08583 L\n.84857 .08825 L\n.85048 .09072 L\n.85238 .09321 L\n.85429 .09575 L\n.85619 .09831 L\n.8581 .10091 L\n.86 .10354 L\n.8619 .10621 L\n.86381 .1089 L\n.86571 .11163 L\n.86762 .11439 L\n.86952 .11718 L\n.87143 .12 L\n.87333 .12285 L\n.87524 .12573 L\n.87714 .12863 L\n.87905 .13157 L\nMistroke\n.88095 .13453 L\n.88286 .13753 L\n.88476 .14055 L\n.88667 .14359 L\n.88857 .14666 L\n.89048 .14976 L\n.89238 .15288 L\n.89429 .15603 L\n.89619 .1592 L\n.8981 .1624 L\n.9 .16562 L\n.9019 .16886 L\n.90381 .17212 L\n.90571 .1754 L\n.90762 .17871 L\n.90952 .18204 L\n.91143 .18538 L\n.91333 .18875 L\n.91524 .19213 L\n.91714 .19554 L\n.91905 .19896 L\n.92095 .2024 L\n.92286 .20585 L\n.92476 .20932 L\n.92667 .21281 L\n.92857 .21631 L\n.93048 .21983 L\n.93238 .22336 L\n.93429 .22691 L\n.93619 .23047 L\n.9381 .23404 L\n.94 .23762 L\n.9419 .24121 L\n.94381 .24482 L\n.94571 .24843 L\n.94762 .25205 L\n.94952 .25569 L\n.95143 .25933 L\n.95333 .26298 L\n.95524 .26663 L\n.95714 .2703 L\n.95905 .27397 L\n.96095 .27764 L\n.96286 .28132 L\n.96476 .285 L\n.96667 .28869 L\n.96857 .29238 L\n.97048 .29608 L\n.97238 .29977 L\n.97429 .30347 L\nMistroke\n.97619 .30717 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(R2) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(v) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n93.000 12.813 moveto\n(L) show\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(R1) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(v) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n93.000 12.813 moveto\n(L) show\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT00`000000fMWI\n0=WIf@3l0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@008@3IfMT200000:D0fMWI1@00O`1C\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2P0=WIf@D007l0103IfMT5001o04h0fMWI000Q0=WIf@03\n0000003IfMT0fMWI09d0fMWI0`00O`0=0=WIf@<007l0C03IfMT00240fMWI00<000000=WIf@3IfMT0\nV`3IfMT3001o0140fMWI0`00O`1:0=WIf@008@3IfMT00`000000fMWI0=WIf@2J0=WIf@8007l05@3I\nfMT2001o04T0fMWI000>0=WIf@@000000`3IfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0\nfMWI09P0fMWI0P00O`0I0=WIf@8007l0A`3IfMT000h0fMWI00<000000=WIf@3IfMT00`3IfMT01000\n0000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0U`3I\nfMT2001o01/0fMWI0P00O`160=WIf@003`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0\nfMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT3000009H0fMWI0P00O`0N0=WIf@03001o\n003IfMT0fMWI04<0fMWI00080=WIf@@00000103IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI\n00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0000009L0fMWI0P00O`0O0=WI\nf@8007l0A03IfMT000h0fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0U03IfMT00`00O`00fMWI0=WI\nf@0Q0=WIf@03001o003IfMT0fMWI0440fMWI000?0=WIf@800000103IfMT2000000@0fMWI0P000004\n0=WIf@030000003IfMT0fMWI09<0fMWI00<007l00=WIf@3IfMT08`3IfMT2001o0440fMWI000Q0=WI\nf@030000003IfMT0fMWI0980fMWI00<007l00=WIf@3IfMT09@3IfMT00`00O`00fMWI0=WIf@0o0=WI\nf@008@3IfMT00`000000fMWI0=WIf@2A0=WIf@03001o003IfMT0fMWI02L0fMWI00<007l00=WIf@3I\nfMT0?P3IfMT00240fMWI0P00002A0=WIf@03001o003IfMT0fMWI02T0fMWI00<007l00=WIf@3IfMT0\n?@3IfMT00240fMWI00<000000=WIf@3IfMT0S`3IfMT00`00O`00fMWI0=WIf@0[0=WIf@03001o003I\nfMT0fMWI03`0fMWI000Q0=WIf@030000003IfMT0fMWI08h0fMWI00<007l00=WIf@3IfMT0;@3IfMT0\n0`00O`00fMWI0=WIf@0k0=WIf@008@3IfMT00`000000fMWI0=WIf@2>0=WIf@03001o003IfMT0fMWI\n02h0fMWI00<007l00=WIf@3IfMT0>P3IfMT00240fMWI00<000000=WIf@3IfMT0S@3IfMT00`00O`00\nfMWI0=WIf@0_0=WIf@03001o003IfMT0fMWI03X0fMWI000Q0=WIf@030000003IfMT0fMWI08`0fMWI\n00<007l00=WIf@3IfMT0<@3IfMT00`00O`00fMWI0=WIf@0i0=WIf@008@3IfMT2000008`0fMWI00<0\n07l00=WIf@3IfMT0<`3IfMT00`00O`00fMWI0=WIf@0h0=WIf@008@3IfMT00`000000fMWI0=WIf@2:\n0=WIf@03001o003IfMT0fMWI03D0fMWI00<007l00=WIf@3IfMT0=`3IfMT00240fMWI00<000000=WI\nf@3IfMT0RP3IfMT00`00O`00fMWI0=WIf@0e0=WIf@8007l0>03IfMT00240fMWI00<000000=WIf@3I\nfMT0R@3IfMT00`00O`00fMWI0=WIf@0g0=WIf@03001o003IfMT0fMWI03H0fMWI000Q0=WIf@030000\n003IfMT0fMWI08P0fMWI0P00O`0i0=WIf@8007l0=`3IfMT00240fMWI00<000000=WIf@3IfMT0Q`3I\nfMT2001o03/0fMWI0P00O`0f0=WIf@008@3IfMT00`000000fMWI0=WIf@270=WIf@03001o003IfMT0\nfMWI03/0fMWI00<007l00=WIf@3IfMT0=03IfMT00240fMWI0P0000270=WIf@03001o003IfMT0fMWI\n03d0fMWI00<007l00=WIf@3IfMT0<`3IfMT00240fMWI00<000000=WIf@3IfMT0Q@3IfMT2001o03l0\nfMWI0P00O`0d0=WIf@008@3IfMT00`000000fMWI0=WIf@250=WIf@03001o003IfMT0fMWI03l0fMWI\n00<007l00=WIf@3IfMT0<P3IfMT00240fMWI00<000000=WIf@3IfMT0Q03IfMT2001o0440fMWI0P00\nO`0c0=WIf@008@3IfMT00`000000fMWI0=WIf@240=WIf@03001o003IfMT0fMWI0440fMWI00<007l0\n0=WIf@3IfMT0<@3IfMT00240fMWI00<000000=WIf@3IfMT0P`3IfMT00`00O`00fMWI0=WIf@130=WI\nf@03001o003IfMT0fMWI0300fMWI000Q0=WIf@800000P`3IfMT00`00O`00fMWI0=WIf@150=WIf@03\n001o003IfMT0fMWI02l0fMWI000Q0=WIf@030000003IfMT0fMWI07X0fMWI20000?l00`00O`00003o\n0000o`050000od00fMWI00<007l00=WIf@3IfMT0;`3IfMT00240fMWI00<000000=WIf@3IfMT0M`3I\nfMT40000o`H0fMWI00<007l00=WIf@3IfMT01@3IfMT50000ocd0fMWI00<007l00=WIf@3IfMT0;P3I\nfMT00240fMWI00<000000=WIf@3IfMT0M03IfMT30000o`X0fMWI00<007l00=WIf@3IfMT02@3IfMT3\n0000oc`0fMWI00<007l00=WIf@3IfMT0;@3IfMT000h0fMWI1@0000020=WIf@800000103IfMT20000\n00@0fMWI00<000000=WIf@3IfMT0L@3IfMT40000o`/0fMWI00<007l00=WIf@3IfMT03@3IfMT30000\nocT0fMWI00<007l00=WIf@3IfMT0;@3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000001a0=WIf@<0003o3@3I\nfMT2001o0140fMWI0`000?lg0=WIf@8007l0;P3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT0fMWI0`00001^0=WIf@80\n003o3`3IfMT00`00O`00fMWI0=WIf@0B0=WIf@<0003o=P3IfMT00`00O`00fMWI0=WIf@0/0=WIf@00\n203IfMT4000000@0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI0000\n0080fMWI00D000000=WIf@3IfMT0fMWI0000001^0=WIf@80003o403IfMT00`00O`00fMWI0=WIf@0E\n0=WIf@80003o=P3IfMT00`00O`00fMWI0=WIf@0[0=WIf@00403IfMT01@000000fMWI0=WIf@3IfMT0\n00000080fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT0000006`0fMWI\n0P000?lB0=WIf@03001o003IfMT0fMWI01L0fMWI0P000?ld0=WIf@03001o003IfMT0fMWI02/0fMWI\n000?0=WIf@800000103IfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0fMWI06T0fMWI0P00\n0?lB0=WIf@03001o003IfMT0fMWI01X0fMWI0P000?lc0=WIf@03001o003IfMT0fMWI02X0fMWI000Q\n0=WIf@030000003IfMT0fMWI06L0fMWI0P000?lD0=WIf@03001o003IfMT0fMWI01/0fMWI0P000?lc\n0=WIf@03001o003IfMT0fMWI02T0fMWI000Q0=WIf@030000003IfMT0fMWI06H0fMWI0P000?lD0=WI\nf@03001o003IfMT0fMWI01d0fMWI0P000?lb0=WIf@03001o003IfMT0fMWI02T0fMWI000Q0=WIf@80\n0000I@3IfMT20000oaH0fMWI00<007l00=WIf@3IfMT07`3IfMT20000oc00fMWI00<007l00=WIf@3I\nfMT0:@3IfMT00240fMWI00<000000=WIf@3IfMT0H`3IfMT20000oaH0fMWI00<007l00=WIf@3IfMT0\n8@3IfMT20000oc00fMWI00<007l00=WIf@3IfMT0:03IfMT00240fMWI00<000000=WIf@3IfMT0HP3I\nfMT00`000?l0fMWI0=WIf@0E0=WIf@03001o003IfMT0fMWI02<0fMWI0P000?l`0=WIf@03001o003I\nfMT0fMWI02L0fMWI000Q0=WIf@030000003IfMT0fMWI0640fMWI00<0003o0=WIf@3IfMT05P3IfMT0\n0`00O`00fMWI0=WIf@0U0=WIf@80003o;P3IfMT00`00O`00fMWI0=WIf@0W0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@1O0=WIf@80003o603IfMT00`00O`00fMWI0=WIf@0W0=WIf@80003o;P3IfMT00`00\nO`00fMWI0=WIf@0V0=WIf@008@3IfMT00`000000fMWI0=WIf@1N0=WIf@80003o6@3IfMT00`00O`00\nfMWI0=WIf@0X0=WIf@80003o;@3IfMT00`00O`00fMWI0=WIf@0V0=WIf@008@3IfMT00`000000fMWI\n0=WIf@1M0=WIf@80003o6@3IfMT00`00O`00fMWI0=WIf@0Z0=WIf@80003o;@3IfMT00`00O`00fMWI\n0=WIf@0U0=WIf@008@3IfMT2000005d0fMWI0P000?lJ0=WIf@03001o003IfMT0fMWI02`0fMWI00<0\n003o0=WIf@3IfMT0:`3IfMT00`00O`00fMWI0=WIf@0T0=WIf@008@3IfMT00`000000fMWI0=WIf@1K\n0=WIf@030000o`3IfMT0fMWI01T0fMWI00<007l00=WIf@3IfMT0;P3IfMT20000ob/0fMWI00<007l0\n0=WIf@3IfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0F@3IfMT20000oa`0fMWI00<007l00=WI\nf@3IfMT0;`3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@03001o003IfMT0fMWI02@0fMWI000Q0=WIf@03\n0000003IfMT0fMWI05T0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`00O`00fMWI0=WIf@0a0=WIf@03\n0000o`3IfMT0fMWI02T0fMWI00<007l00=WIf@3IfMT08`3IfMT00240fMWI00<000000=WIf@3IfMT0\nE`3IfMT20000oa`0fMWI0P00O`0d0=WIf@80003o:@3IfMT2001o02@0fMWI000Q0=WIf@030000003I\nfMT0fMWI05H0fMWI0P000?lM0=WIf@03001o003IfMT0fMWI03@0fMWI0P000?lY0=WIf@03001o003I\nfMT0fMWI0280fMWI000Q0=WIf@800000EP3IfMT20000oad0fMWI00<007l00=WIf@3IfMT0=P3IfMT0\n0`000?l0fMWI0=WIf@0X0=WIf@03001o003IfMT0fMWI0240fMWI000Q0=WIf@030000003IfMT0fMWI\n05@0fMWI0P000?lN0=WIf@03001o003IfMT0fMWI03L0fMWI0P000?lX0=WIf@03001o003IfMT0fMWI\n0240fMWI000Q0=WIf@030000003IfMT0fMWI02<0fMWI0P0000040=WIf@8000000`3IfMT4000001h0\nfMWI0P000000103IfMT0003o0000o`3IfMT2000000D0fMWI0`00000D0=WIf@03001o003IfMT0fMWI\n00H0fMWI0P0000040=WIf@8000000`3IfMT3000001l0fMWI0P0000030=WIf@80003o00<000000=WI\nf@3IfMT00P3IfMT200000240fMWI00<007l00=WIf@3IfMT01@00000K0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0R0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT07P3IfMT00`00\n0000fMWI0=WIf@020000o`X0fMWI00<000000=WIf@3IfMT04P3IfMT00`00O`00fMWI0=WIf@060=WI\nf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007@3IfMT010000000fMWI0=WI\nf@0000030=WIf@80003o0`3IfMT010000000fMWI0=WIf@00000P0=WIf@03001o003IfMT0fMWI0080\nfMWI00<000000=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT08P3IfMT010000000fMWI\n0=WIf@0000090=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WIf@000?l0003o203IfMT50000\n0180fMWI0P00O`080=WIf@040000003IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT000007@3I\nfMT010000000fMWI0=WIf@0000040=WIf@050000o`3IfMT0fMWI0=WIf@0000000P3IfMT00`000000\nfMWI0=WIf@0N0=WIf@8007l00`3IfMT00`000000fMWI0=WIf@0K0=WIf@008@3IfMT00`000000fMWI\n0=WIf@0R0=WIf@040000003IfMT0fMWI000000X0fMWI00<000000=WIf@3IfMT0703IfMT010000000\n003o0000o`0000080=WIf@040000003IfMT0fMWI000001<0fMWI00<007l00=WIf@3IfMT01`3IfMT0\n10000000fMWI0=WIf@0000080=WIf@<000007P3IfMT010000000fMWI0=WIf@0000050=WIf@80003o\n0P3IfMT200000280fMWI00D007l00=WIf@3IfMT0fMWI0000000M0=WIf@008@3IfMT2000002<0fMWI\n00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000M0=WIf@80003o00<0fMWI0000\n003IfMT0203IfMT00`000000fMWI0000000B0=WIf@03001o003IfMT0fMWI00P0fMWI00@000000=WI\nf@3IfMT000002@3IfMT00`000000fMWI0=WIf@0M0=WIf@040000003IfMT0fMWI000000H0fMWI0P00\n0?l010000000fMWI0=WIf@00000R0=WIf@04001o003IfMT0fMWI000001d0fMWI000Q0=WIf@030000\n003IfMT0fMWI02<0fMWI0P00000:0=WIf@8000007@3IfMT20000o`8000002`3IfMT200000180fMWI\n00<007l00=WIf@3IfMT02@3IfMT2000000X0fMWI0`00000N0=WIf@800000203IfMT20000o`800000\n8`3IfMT01000O`00fMWI00000000000M0=WIf@008@3IfMT00`000000fMWI0=WIf@1=0=WIf@80003o\n8@3IfMT00`00O`00fMWI0=WIf@120=WIf@80003o9@3IfMT00`00O`00fMWI0=WIf@0M0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI0240fMWI00<007l00=WIf@3IfMT0@`3I\nfMT00`000?l0fMWI0=WIf@0S0=WIf@03001o003IfMT0fMWI01d0fMWI000Q0=WIf@030000003IfMT0\nfMWI04/0fMWI0P000?lR0=WIf@03001o003IfMT0fMWI04D0fMWI00<0003o0=WIf@3IfMT08`3IfMT0\n0`00O`00fMWI0=WIf@0L0=WIf@008@3IfMT00`000000fMWI0=WIf@1:0=WIf@80003o8`3IfMT00`00\nO`00fMWI0=WIf@160=WIf@80003o8`3IfMT00`00O`00fMWI0=WIf@0=0=WIf@8000003@3IfMT00240\nfMWI00<000000=WIf@3IfMT0B@3IfMT20000ob<0fMWI00<007l00=WIf@3IfMT0B03IfMT20000ob<0\nfMWI00<007l00=WIf@3IfMT02`3IfMT010000000fMWI0=WIf@00000<0=WIf@00703IfMT500000080\n07l0B@0000000`000?l000000000000S00000003001o00000000000004T0000000<0003o00000000\n0000:00000070=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@0300000000O`00fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00<0fMWI\n0P000?l30=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@080=WIf@03001o00000000fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@080=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0000003IfMT02@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02P3IfMT5000000`0fMWI\n000Q0=WIf@030000003IfMT007l004H0fMWI0P000?lU0=WIf@03001o003IfMT0fMWI04`0fMWI00<0\n003o0=WIf@3IfMT0;@3IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000fMWI001o0015\n0=WIf@030000o`3IfMT0fMWI02@0fMWI00<007l00=WIf@3IfMT0CP3IfMT00`000?l0fMWI0=WIf@0l\n0=WIf@008@3IfMT010000000fMWI0=WIf@00O`130=WIf@030000o`3IfMT0fMWI02D0fMWI00<007l0\n0=WIf@3IfMT0C`3IfMT00`000?l0fMWI0=WIf@0k0=WIf@008@3IfMT00`000000fMWI0=WIf@02001o\n0440fMWI00<0003o0=WIf@3IfMT09@3IfMT00`00O`00fMWI0=WIf@1A0=WIf@030000o`3IfMT0fMWI\n03X0fMWI000Q0=WIf@8000000P3IfMT00`00O`00fMWI0=WIf@0n0=WIf@030000o`3IfMT0fMWI02H0\nfMWI00<007l00=WIf@3IfMT0DP3IfMT00`000?l0fMWI0=WIf@0i0=WIf@008@3IfMT01@000000fMWI\n0=WIf@3IfMT007l003l0fMWI00<0003o0=WIf@3IfMT09P3IfMT00`00O`00fMWI0=WIf@1D0=WIf@03\n0000o`3IfMT0fMWI03P0fMWI000Q0=WIf@030000003IfMT0fMWI0080fMWI00<007l00=WIf@3IfMT0\n>P3IfMT20000obT0fMWI00<007l00=WIf@3IfMT0E@3IfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3I\nfMT00`000000fMWI0=WIf@020=WIf@03001o00000?l0fMWI03X0fMWI00<0003o0=WIf@3IfMT09`3I\nfMT00`00O`00fMWI0=WIf@1G0=WIf@030000o`3IfMT0fMWI03H0fMWI000Q0=WIf@030000003IfMT0\nfMWI00<0fMWI00<007l00000o`3IfMT0=`3IfMT20000obX0fMWI00<007l00=WIf@3IfMT0F03IfMT0\n0`000?l0fMWI0=WIf@0e0=WIf@008@3IfMT00`000000fMWI0=WIf@030=WIf@8007l0=`3IfMT20000\nobX0fMWI00<007l00=WIf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@0d0=WIf@008@3IfMT2000000D0\nfMWI00<007l00000o`3IfMT0=03IfMT20000obX0fMWI00<007l00=WIf@3IfMT0G03IfMT00`000?l0\nfMWI0=WIf@0c0=WIf@008@3IfMT00`000000fMWI0=WIf@050=WIf@03001o00000?l0fMWI0380fMWI\n0P000?l[0=WIf@03001o003IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<0\n00000=WIf@3IfMT01@3IfMT00`00O`00003o0000o`0a0=WIf@80003o;03IfMT00`00O`00fMWI0=WI\nf@1N0=WIf@030000o`3IfMT0fMWI0340fMWI000Q0=WIf@030000003IfMT0fMWI00H0fMWI00<007l0\n0000o`3IfMT0;P3IfMT20000obd0fMWI00<007l00=WIf@3IfMT0H03IfMT00`000?l0fMWI0=WIf@0`\n0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@03001o003IfMT0003o02d0fMWI0P000?l^0=WI\nf@03001o003IfMT0fMWI0640fMWI0P000?l`0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@80\n07l000<0fMWI0000o`3IfMT0:P3IfMT20000obh0fMWI00<007l00=WIf@3IfMT0H`3IfMT20000obl0\nfMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI00@007l00=WIf@3IfMT0003o:03IfMT20000obl0\nfMWI00<007l00=WIf@3IfMT0I@3IfMT20000obh0fMWI000Q0=WIf@8000002@3IfMT01000O`00fMWI\n0=WIf@000?lV0=WIf@80003o<03IfMT00`00O`00fMWI0=WIf@1V0=WIf@80003o;@3IfMT00240fMWI\n00<000000=WIf@3IfMT0203IfMT01000O`00fMWI0=WIf@3IfMT20000ob<0fMWI0P000?l`0=WIf@03\n001o003IfMT0fMWI06P0fMWI0P000?l/0=WIf@008@3IfMT00`000000fMWI0=WIf@090=WIf@04001o\n003IfMT0fMWI0=WIf@80003o803IfMT20000oc80fMWI00<007l00=WIf@3IfMT0JP3IfMT00`000?l0\nfMWI0=WIf@0Y0=WIf@008@3IfMT00`000000fMWI0=WIf@090=WIf@8007l00`3IfMT20000oad0fMWI\n0P000?lc0=WIf@03001o003IfMT0fMWI06/0fMWI0P000?lZ0=WIf@008@3IfMT00`000000fMWI0=WI\nf@0:0=WIf@03001o003IfMT0fMWI0080fMWI0`000?lI0=WIf@<0003o=03IfMT00`00O`00fMWI0=WI\nf@1]0=WIf@80003o:03IfMT00240fMWI00<000000=WIf@3IfMT02P3IfMT00`00O`00fMWI0=WIf@04\n0=WIf@<0003o5@3IfMT30000ocD0fMWI00<007l00=WIf@3IfMT0K`3IfMT20000obL0fMWI000Q0=WI\nf@800000303IfMT00`00O`00fMWI0=WIf@050=WIf@<0003o403IfMT40000ocL0fMWI00<007l00=WI\nf@3IfMT0L@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@008@3IfMT00`000000fMWI0=WIf@0;0=WIf@80\n07l0203IfMT40000o`X0fMWI10000?li0=WIf@03001o003IfMT0fMWI07<0fMWI0P000?lT0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0<0=WIf@03001o003IfMT0fMWI00T0fMWI2`000?ll0=WIf@03001o\n003IfMT0fMWI07D0fMWI0P000?lS0=WIf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@03001o003I\nfMT0fMWI04l0fMWI00<007l00=WIf@3IfMT0M`3IfMT00`000?l0fMWI0=WIf@0P0=WIf@003P3IfMT5\n00000080fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@0=0=WIf@03001o003IfMT0\nfMWI04h0fMWI00<007l00=WIf@3IfMT0N@3IfMT20000ob00fMWI000@0=WIf@050000003IfMT0fMWI\n0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003IfMT0fMWI0=WIf@000000\n403IfMT00`00O`00fMWI0=WIf@1=0=WIf@03001o003IfMT0fMWI07/0fMWI0P000?lN0=WIf@00403I\nfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000\nfMWI0=WIf@3IfMT3000000l0fMWI00<007l00=WIf@3IfMT0B`3IfMT00`00O`00fMWI0=WIf@1m0=WI\nf@80003o7@3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI\n00000080fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@03001o003IfMT0fMWI04/0fMWI00<0\n07l00=WIf@3IfMT0W03IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003I\nfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000000A0=WIf@03001o003IfMT0fMWI04X0\nfMWI00<007l00=WIf@3IfMT0W@3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI\n00<000000=WIf@3IfMT0403IfMT00`00O`00fMWI0=WIf@180=WIf@8007l0W`3IfMT00240fMWI00<0\n00000=WIf@3IfMT04@3IfMT00`00O`00fMWI0=WIf@170=WIf@03001o003IfMT0fMWI09h0fMWI000Q\n0=WIf@030000003IfMT0fMWI0140fMWI00<007l00=WIf@3IfMT0AP3IfMT00`00O`00fMWI0=WIf@2O\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0B0=WIf@03001o003IfMT0fMWI04@0fMWI0P00O`2Q0=WI\nf@008@3IfMT2000001@0fMWI00<007l00=WIf@3IfMT0@`3IfMT00`00O`00fMWI0=WIf@2P0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0C0=WIf@03001o003IfMT0fMWI0480fMWI0P00O`2R0=WIf@008@3I\nfMT00`000000fMWI0=WIf@0D0=WIf@03001o003IfMT0fMWI0440fMWI00<007l00=WIf@3IfMT0X@3I\nfMT00240fMWI00<000000=WIf@3IfMT0503IfMT00`00O`00fMWI0=WIf@100=WIf@03001o003IfMT0\nfMWI0:80fMWI000Q0=WIf@030000003IfMT0fMWI01D0fMWI00<007l00=WIf@3IfMT0?P3IfMT2001o\n0:@0fMWI000Q0=WIf@030000003IfMT0fMWI01H0fMWI00<007l00=WIf@3IfMT0?@3IfMT00`00O`00\nfMWI0=WIf@2S0=WIf@008@3IfMT2000001L0fMWI0P00O`0m0=WIf@03001o003IfMT0fMWI0:@0fMWI\n000Q0=WIf@030000003IfMT0fMWI01L0fMWI00<007l00=WIf@3IfMT0>`3IfMT00`00O`00fMWI0=WI\nf@2T0=WIf@008@3IfMT00`000000fMWI0=WIf@0G0=WIf@8007l0>`3IfMT00`00O`00fMWI0=WIf@2U\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0H0=WIf@03001o003IfMT0fMWI03P0fMWI00<007l00=WI\nf@3IfMT0YP3IfMT00240fMWI00<000000=WIf@3IfMT06@3IfMT00`00O`00fMWI0=WIf@0f0=WIf@80\n07l0Z03IfMT00240fMWI00<000000=WIf@3IfMT06P3IfMT00`00O`00fMWI0=WIf@0d0=WIf@8007l0\nZ@3IfMT00240fMWI0P00000L0=WIf@03001o003IfMT0fMWI03<0fMWI00<007l00=WIf@3IfMT0Z03I\nfMT00240fMWI00<000000=WIf@3IfMT06`3IfMT2001o03<0fMWI0P00O`2Z0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0L0=WIf@03001o003IfMT0fMWI0300fMWI0P00O`2[0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0M0=WIf@03001o003IfMT0fMWI02h0fMWI0P00O`2/0=WIf@008@3IfMT00`000000fMWI\n0=WIf@0N0=WIf@03001o003IfMT0fMWI02d0fMWI00<007l00=WIf@3IfMT0Z`3IfMT00240fMWI00<0\n00000=WIf@3IfMT07P3IfMT2001o02d0fMWI00<007l00=WIf@3IfMT0[03IfMT00240fMWI0P00000P\n0=WIf@8007l0:`3IfMT00`00O`00fMWI0=WIf@2]0=WIf@008@3IfMT00`000000fMWI0=WIf@0P0=WI\nf@03001o003IfMT0fMWI02P0fMWI0P00O`2_0=WIf@008@3IfMT00`000000fMWI0=WIf@0Q0=WIf@03\n001o003IfMT0fMWI02H0fMWI0P00O`2`0=WIf@008@3IfMT00`000000fMWI0=WIf@0R0=WIf@8007l0\n9@3IfMT2001o0;40fMWI000Q0=WIf@030000003IfMT0fMWI02<0fMWI0P00O`0S0=WIf@03001o003I\nfMT0fMWI0;40fMWI000>0=WIf@@000000`3IfMT2000000@0fMWI0P0000040=WIf@030000003IfMT0\nfMWI02@0fMWI0P00O`0Q0=WIf@8007l0/`3IfMT000h0fMWI00<000000=WIf@3IfMT00`3IfMT01000\n0000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT09@3I\nfMT2001o01l0fMWI0P00O`2d0=WIf@003`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0\nfMWI00000080fMWI00@000000=WIf@3IfMT000000`3IfMT3000002H0fMWI0P00O`0L0=WIf@8007l0\n]P3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0fMWI00000080\nfMWI00D000000=WIf@3IfMT0fMWI0000000Z0=WIf@8007l06@3IfMT2001o0;L0fMWI000>0=WIf@04\n0000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@00\n00030=WIf@030000003IfMT0fMWI02T0fMWI0P00O`0G0=WIf@8007l0^03IfMT000l0fMWI0P000004\n0=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0:P3IfMT3001o01<0fMWI0P00O`2j\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0/0=WIf@<007l03`3IfMT2001o0;`0fMWI000Q0=WIf@03\n0000003IfMT0fMWI02h0fMWI1000O`090=WIf@<007l0_P3IfMT00240fMWI0P00000c0=WIf@T007l0\n`@3IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT0\n0240fMWI00<000000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT002D0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI0=WIf@050=WIf@800000203I\nfMT200000<`0fMWI000T0=WIf@030000003IfMT0fMWI01X0fMWI00<000000=WIf@3IfMT0103IfMT0\n0`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0<X0fMWI000S0=WIf@040000003IfMT0fMWI\n0=WIf@<000000P3IfMT00`000000fMWI00000003000000<0fMWI0P0000040=WIf@8000001@3IfMT0\n0`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P0000040=WIf@030000003IfMT0\nfMWI0<X0fMWI000S0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT000000P3IfMT0\n0`000000fMWI0=WIf@0:0=WIf@8000001@3IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000<`0fMWI000F0=WIf@P007l01@3I\nfMT00`000000fMWI0=WIf@020=WIf@<00000103IfMT00`000000fMWI0=WIf@080=WIf@040000003I\nfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0\nfMWI00<000000=WIf@3IfMT0bP3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT010000000fMWI\n0=WIf@0000040=WIf@030000003IfMT0fMWI00H0fMWI0P0000020=WIf@8000000`3IfMT00`000000\nfMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000fMWI0=WIf@3:0=WIf@00\n903IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT00`00\n0000fMWI0=WIf@0=0=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3IfMT0fMWI00000006\n0=WIf@030000003IfMT0fMWI0<X0fMWI000U0=WIf@030000003IfMT0000000<00000103IfMT20000\n00l0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00003<0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\n9@3IfMT00`000000fMWI0=WIf@0H0=WIf@030000003IfMT0fMWI00D0fMWI0P0000080=WIf@800000\nc03IfMT002@0fMWI00<000000=WIf@3IfMT06P3IfMT00`000000fMWI0=WIf@040=WIf@030000003I\nfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0bP3IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI0`00\n00020=WIf@030000003IfMT0000000@000000P3IfMT2000000@0fMWI0P0000050=WIf@030000003I\nfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0bP3I\nfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000103I\nfMT00`000000fMWI0=WIf@080=WIf@8000001@3IfMT00`000000fMWI0=WIf@030=WIf@050000003I\nfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WIf@3IfMT000000<`0fMWI000S0=WIf@030000\n003IfMT0fMWI0080fMWI0`0000050=WIf@030000003IfMT0fMWI00L0fMWI00@000000=WIf@3IfMT0\n0000103IfMT00`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`00\n0000fMWI0=WIf@3:0=WIf@008`3IfMT00`000000fMWI0=WIf@020=WIf@040000003IfMT0fMWI0000\n00@0fMWI00<000000=WIf@3IfMT01P3IfMT200000080fMWI0P0000030=WIf@030000003IfMT0fMWI\n00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0<X0fMWI000T0=WIf@05\n0000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI\n00h0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<00000\n0=WIf@3IfMT0bP3IfMT002D0fMWI00<000000=WIf@0000000`0000040=WIf@8000003`3IfMT00`00\n0000fMWI0=WIf@050=WIf@800000203IfMT200000<`0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI\n0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.151224`, -283.734`, 0.00445466`, 3.1713`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell["", "NumberedFigure"], Cell["plot( {R1.i,R2.i} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.333793 0.0271988 [\n[.21429 .32129 -9 -9 ]\n[.21429 .32129 9 0 ]\n[.40476 .32129 -9 -9 ]\n[.40476 .32129 9 0 ]\n[.59524 .32129 -9 -9 ]\n[.59524 .32129 9 0 ]\n[.78571 .32129 -9 -9 ]\n[.78571 .32129 9 0 ]\n[.97619 .32129 -3 -9 ]\n[.97619 .32129 3 0 ]\n[1.025 .33379 0 -6.28125 ]\n[1.025 .33379 10 6.28125 ]\n[.01131 .06181 -18 -4.5 ]\n[.01131 .06181 0 4.5 ]\n[.01131 .1978 -12 -4.5 ]\n[.01131 .1978 0 4.5 ]\n[.01131 .46979 -6 -4.5 ]\n[.01131 .46979 0 4.5 ]\n[.01131 .60578 -12 -4.5 ]\n[.01131 .60578 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .33379 m\n.21429 .34004 L\ns\n[(0.2)] .21429 .32129 0 1 Mshowa\n.40476 .33379 m\n.40476 .34004 L\ns\n[(0.4)] .40476 .32129 0 1 Mshowa\n.59524 .33379 m\n.59524 .34004 L\ns\n[(0.6)] .59524 .32129 0 1 Mshowa\n.78571 .33379 m\n.78571 .34004 L\ns\n[(0.8)] .78571 .32129 0 1 Mshowa\n.97619 .33379 m\n.97619 .34004 L\ns\n[(1)] .97619 .32129 0 1 Mshowa\n.125 Mabswid\n.07143 .33379 m\n.07143 .33754 L\ns\n.11905 .33379 m\n.11905 .33754 L\ns\n.16667 .33379 m\n.16667 .33754 L\ns\n.2619 .33379 m\n.2619 .33754 L\ns\n.30952 .33379 m\n.30952 .33754 L\ns\n.35714 .33379 m\n.35714 .33754 L\ns\n.45238 .33379 m\n.45238 .33754 L\ns\n.5 .33379 m\n.5 .33754 L\ns\n.54762 .33379 m\n.54762 .33754 L\ns\n.64286 .33379 m\n.64286 .33754 L\ns\n.69048 .33379 m\n.69048 .33754 L\ns\n.7381 .33379 m\n.7381 .33754 L\ns\n.83333 .33379 m\n.83333 .33754 L\ns\n.88095 .33379 m\n.88095 .33754 L\ns\n.92857 .33379 m\n.92857 .33754 L\ns\n.25 Mabswid\n0 .33379 m\n1 .33379 L\ns\ngsave\n1.025 .33379 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .06181 m\n.03006 .06181 L\ns\n[(-10)] .01131 .06181 1 0 Mshowa\n.02381 .1978 m\n.03006 .1978 L\ns\n[(-5)] .01131 .1978 1 0 Mshowa\n.02381 .46979 m\n.03006 .46979 L\ns\n[(5)] .01131 .46979 1 0 Mshowa\n.02381 .60578 m\n.03006 .60578 L\ns\n[(10)] .01131 .60578 1 0 Mshowa\n.125 Mabswid\n.02381 .089 m\n.02756 .089 L\ns\n.02381 .1162 m\n.02756 .1162 L\ns\n.02381 .1434 m\n.02756 .1434 L\ns\n.02381 .1706 m\n.02756 .1706 L\ns\n.02381 .225 m\n.02756 .225 L\ns\n.02381 .2522 m\n.02756 .2522 L\ns\n.02381 .2794 m\n.02756 .2794 L\ns\n.02381 .30659 m\n.02756 .30659 L\ns\n.02381 .36099 m\n.02756 .36099 L\ns\n.02381 .38819 m\n.02756 .38819 L\ns\n.02381 .41539 m\n.02756 .41539 L\ns\n.02381 .44259 m\n.02756 .44259 L\ns\n.02381 .49699 m\n.02756 .49699 L\ns\n.02381 .52419 m\n.02756 .52419 L\ns\n.02381 .55138 m\n.02756 .55138 L\ns\n.02381 .57858 m\n.02756 .57858 L\ns\n.02381 .03461 m\n.02756 .03461 L\ns\n.02381 .00741 m\n.02756 .00741 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .33379 m\n.02571 .34124 L\n.02762 .34853 L\n.02952 .35568 L\n.03143 .36269 L\n.03333 .36955 L\n.03524 .37627 L\n.03714 .38285 L\n.03905 .38929 L\n.04095 .39559 L\n.04286 .40176 L\n.04476 .40779 L\n.04667 .41369 L\n.04857 .41946 L\n.05048 .4251 L\n.05238 .43062 L\n.05429 .436 L\n.05619 .44127 L\n.0581 .4464 L\n.06 .45142 L\n.0619 .45631 L\n.06381 .46108 L\n.06571 .46574 L\n.06762 .47027 L\n.06952 .47469 L\n.07143 .479 L\n.07333 .48319 L\n.07524 .48727 L\n.07714 .49123 L\n.07905 .49509 L\n.08095 .49883 L\n.08286 .50247 L\n.08476 .506 L\n.08667 .50942 L\n.08857 .51274 L\n.09048 .51595 L\n.09238 .51906 L\n.09429 .52207 L\n.09619 .52497 L\n.0981 .52778 L\n.1 .53048 L\n.1019 .53309 L\n.10381 .5356 L\n.10571 .53801 L\n.10762 .54032 L\n.10952 .54255 L\n.11143 .54467 L\n.11333 .54671 L\n.11524 .54865 L\n.11714 .5505 L\nMistroke\n.11905 .55226 L\n.12095 .55393 L\n.12286 .55551 L\n.12476 .557 L\n.12667 .5584 L\n.12857 .55972 L\n.13048 .56096 L\n.13238 .5621 L\n.13429 .56317 L\n.13619 .56415 L\n.1381 .56504 L\n.14 .56586 L\n.1419 .5666 L\n.14381 .56725 L\n.14571 .56782 L\n.14762 .56832 L\n.14952 .56874 L\n.15143 .56908 L\n.15333 .56934 L\n.15524 .56953 L\n.15714 .56965 L\n.15905 .56968 L\n.16095 .56965 L\n.16286 .56954 L\n.16476 .56936 L\n.16667 .56911 L\n.16857 .56879 L\n.17048 .5684 L\n.17238 .56794 L\n.17429 .56741 L\n.17619 .56681 L\n.1781 .56615 L\n.18 .56541 L\n.1819 .56462 L\n.18381 .56376 L\n.18571 .56283 L\n.18762 .56184 L\n.18952 .56079 L\n.19143 .55967 L\n.19333 .5585 L\n.19524 .55726 L\n.19714 .55596 L\n.19905 .5546 L\n.20095 .55319 L\n.20286 .55171 L\n.20476 .55018 L\n.20667 .54859 L\n.20857 .54695 L\n.21048 .54525 L\n.21238 .5435 L\nMistroke\n.21429 .54169 L\n.21619 .53983 L\n.2181 .53791 L\n.22 .53595 L\n.2219 .53393 L\n.22381 .53187 L\n.22571 .52975 L\n.22762 .52758 L\n.22952 .52537 L\n.23143 .52311 L\n.23333 .5208 L\n.23524 .51845 L\n.23714 .51605 L\n.23905 .5136 L\n.24095 .51111 L\n.24286 .50858 L\n.24476 .50601 L\n.24667 .50339 L\n.24857 .50073 L\n.25048 .49803 L\n.25238 .49529 L\n.25429 .49252 L\n.25619 .4897 L\n.2581 .48685 L\n.26 .48396 L\n.2619 .48103 L\n.26381 .47807 L\n.26571 .47507 L\n.26762 .47204 L\n.26952 .46897 L\n.27143 .46587 L\n.27333 .46274 L\n.27524 .45958 L\n.27714 .45639 L\n.27905 .45317 L\n.28095 .44992 L\n.28286 .44664 L\n.28476 .44333 L\n.28667 .44 L\n.28857 .43664 L\n.29048 .43325 L\n.29238 .42984 L\n.29429 .42641 L\n.29619 .42295 L\n.2981 .41947 L\n.3 .41596 L\n.3019 .41244 L\n.30381 .4089 L\n.30571 .40533 L\n.30762 .40175 L\nMistroke\n.30952 .39815 L\n.31143 .39453 L\n.31333 .39089 L\n.31524 .38724 L\n.31714 .38357 L\n.31905 .37989 L\n.32095 .37619 L\n.32286 .37248 L\n.32476 .36876 L\n.32667 .36502 L\n.32857 .36128 L\n.33048 .35752 L\n.33238 .35375 L\n.33429 .34998 L\n.33619 .3462 L\n.3381 .34241 L\n.34 .33861 L\n.3419 .3348 L\n.34381 .33099 L\n.34571 .32718 L\n.34762 .32336 L\n.34952 .31954 L\n.35143 .31571 L\n.35333 .31189 L\n.35524 .30806 L\n.35714 .30423 L\n.35905 .3004 L\n.36095 .29658 L\n.36286 .29275 L\n.36476 .28893 L\n.36667 .28511 L\n.36857 .28129 L\n.37048 .27748 L\n.37238 .27367 L\n.37429 .26987 L\n.37619 .26607 L\n.3781 .26228 L\n.38 .2585 L\n.3819 .25473 L\n.38381 .25096 L\n.38571 .24721 L\n.38762 .24346 L\n.38952 .23973 L\n.39143 .23601 L\n.39333 .2323 L\n.39524 .2286 L\n.39714 .22492 L\n.39905 .22125 L\n.40095 .2176 L\n.40286 .21396 L\nMistroke\n.40476 .21034 L\n.40667 .20673 L\n.40857 .20314 L\n.41048 .19957 L\n.41238 .19602 L\n.41429 .19249 L\n.41619 .18898 L\n.4181 .18548 L\n.42 .18201 L\n.4219 .17856 L\n.42381 .17514 L\n.42571 .17173 L\n.42762 .16835 L\n.42952 .16499 L\n.43143 .16166 L\n.43333 .15836 L\n.43524 .15507 L\n.43714 .15182 L\n.43905 .14859 L\n.44095 .14539 L\n.44286 .14221 L\n.44476 .13907 L\n.44667 .13595 L\n.44857 .13287 L\n.45048 .12981 L\n.45238 .12678 L\n.45429 .12379 L\n.45619 .12082 L\n.4581 .11789 L\n.46 .11499 L\n.4619 .11213 L\n.46381 .10929 L\n.46571 .1065 L\n.46762 .10373 L\n.46952 .101 L\n.47143 .09831 L\n.47333 .09565 L\n.47524 .09303 L\n.47714 .09044 L\n.47905 .08789 L\n.48095 .08538 L\n.48286 .08291 L\n.48476 .08048 L\n.48667 .07808 L\n.48857 .07573 L\n.49048 .07341 L\n.49238 .07113 L\n.49429 .0689 L\n.49619 .0667 L\n.4981 .06455 L\nMistroke\n.5 .06243 L\n.5019 .06036 L\n.50381 .05833 L\n.50571 .05635 L\n.50762 .0544 L\n.50952 .0525 L\n.51143 .05065 L\n.51333 .04883 L\n.51524 .04707 L\n.51714 .04534 L\n.51905 .04366 L\n.52095 .04203 L\n.52286 .04044 L\n.52476 .03889 L\n.52667 .0374 L\n.52857 .03594 L\n.53048 .03454 L\n.53238 .03318 L\n.53429 .03187 L\n.53619 .0306 L\n.5381 .02938 L\n.54 .02821 L\n.5419 .02709 L\n.54381 .02601 L\n.54571 .02498 L\n.54762 .02401 L\n.54952 .02307 L\n.55143 .02219 L\n.55333 .02136 L\n.55524 .02057 L\n.55714 .01984 L\n.55905 .01915 L\n.56095 .01851 L\n.56286 .01792 L\n.56476 .01738 L\n.56667 .01689 L\n.56857 .01645 L\n.57048 .01606 L\n.57238 .01572 L\n.57429 .01543 L\n.57619 .01518 L\n.5781 .01499 L\n.58 .01485 L\n.5819 .01476 L\n.58381 .01472 L\n.58571 .01472 L\n.58762 .01478 L\n.58952 .01489 L\n.59143 .01505 L\n.59333 .01525 L\nMistroke\n.59524 .01551 L\n.59714 .01582 L\n.59905 .01618 L\n.60095 .01658 L\n.60286 .01704 L\n.60476 .01755 L\n.60667 .0181 L\n.60857 .01871 L\n.61048 .01936 L\n.61238 .02007 L\n.61429 .02082 L\n.61619 .02162 L\n.6181 .02247 L\n.62 .02338 L\n.6219 .02432 L\n.62381 .02532 L\n.62571 .02637 L\n.62762 .02746 L\n.62952 .02861 L\n.63143 .0298 L\n.63333 .03103 L\n.63524 .03232 L\n.63714 .03365 L\n.63905 .03503 L\n.64095 .03646 L\n.64286 .03794 L\n.64476 .03946 L\n.64667 .04102 L\n.64857 .04264 L\n.65048 .04429 L\n.65238 .046 L\n.65429 .04775 L\n.65619 .04954 L\n.6581 .05138 L\n.66 .05326 L\n.6619 .05519 L\n.66381 .05716 L\n.66571 .05918 L\n.66762 .06124 L\n.66952 .06334 L\n.67143 .06548 L\n.67333 .06767 L\n.67524 .06989 L\n.67714 .07216 L\n.67905 .07447 L\n.68095 .07682 L\n.68286 .07922 L\n.68476 .08165 L\n.68667 .08412 L\n.68857 .08663 L\nMistroke\n.69048 .08918 L\n.69238 .09177 L\n.69429 .09439 L\n.69619 .09705 L\n.6981 .09976 L\n.7 .10249 L\n.7019 .10527 L\n.70381 .10808 L\n.70571 .11092 L\n.70762 .1138 L\n.70952 .11672 L\n.71143 .11967 L\n.71333 .12265 L\n.71524 .12567 L\n.71714 .12872 L\n.71905 .1318 L\n.72095 .13491 L\n.72286 .13806 L\n.72476 .14123 L\n.72667 .14444 L\n.72857 .14767 L\n.73048 .15094 L\n.73238 .15423 L\n.73429 .15755 L\n.73619 .1609 L\n.7381 .16428 L\n.74 .16768 L\n.7419 .17111 L\n.74381 .17456 L\n.74571 .17804 L\n.74762 .18155 L\n.74952 .18508 L\n.75143 .18863 L\n.75333 .19221 L\n.75524 .1958 L\n.75714 .19942 L\n.75905 .20306 L\n.76095 .20672 L\n.76286 .2104 L\n.76476 .2141 L\n.76667 .21782 L\n.76857 .22156 L\n.77048 .22531 L\n.77238 .22909 L\n.77429 .23287 L\n.77619 .23668 L\n.7781 .2405 L\n.78 .24433 L\n.7819 .24818 L\n.78381 .25204 L\nMistroke\n.78571 .25592 L\n.78762 .2598 L\n.78952 .2637 L\n.79143 .26761 L\n.79333 .27153 L\n.79524 .27546 L\n.79714 .2794 L\n.79905 .28335 L\n.80095 .2873 L\n.80286 .29127 L\n.80476 .29523 L\n.80667 .29921 L\n.80857 .30319 L\n.81048 .30718 L\n.81238 .31117 L\n.81429 .31516 L\n.81619 .31916 L\n.8181 .32315 L\n.82 .32715 L\n.8219 .33116 L\n.82381 .33516 L\n.82571 .33916 L\n.82762 .34316 L\n.82952 .34716 L\n.83143 .35115 L\n.83333 .35515 L\n.83524 .35914 L\n.83714 .36312 L\n.83905 .36711 L\n.84095 .37108 L\n.84286 .37505 L\n.84476 .37902 L\n.84667 .38297 L\n.84857 .38692 L\n.85048 .39087 L\n.85238 .3948 L\n.85429 .39872 L\n.85619 .40263 L\n.8581 .40653 L\n.86 .41042 L\n.8619 .4143 L\n.86381 .41816 L\n.86571 .42201 L\n.86762 .42585 L\n.86952 .42967 L\n.87143 .43348 L\n.87333 .43727 L\n.87524 .44105 L\n.87714 .44481 L\n.87905 .44855 L\nMistroke\n.88095 .45227 L\n.88286 .45597 L\n.88476 .45966 L\n.88667 .46332 L\n.88857 .46697 L\n.89048 .47059 L\n.89238 .47419 L\n.89429 .47777 L\n.89619 .48133 L\n.8981 .48486 L\n.9 .48837 L\n.9019 .49186 L\n.90381 .49532 L\n.90571 .49875 L\n.90762 .50216 L\n.90952 .50554 L\n.91143 .5089 L\n.91333 .51222 L\n.91524 .51552 L\n.91714 .51879 L\n.91905 .52203 L\n.92095 .52524 L\n.92286 .52842 L\n.92476 .53157 L\n.92667 .53469 L\n.92857 .53778 L\n.93048 .54084 L\n.93238 .54386 L\n.93429 .54685 L\n.93619 .5498 L\n.9381 .55272 L\n.94 .55561 L\n.9419 .55846 L\n.94381 .56128 L\n.94571 .56406 L\n.94762 .5668 L\n.94952 .56951 L\n.95143 .57218 L\n.95333 .57481 L\n.95524 .57741 L\n.95714 .57996 L\n.95905 .58248 L\n.96095 .58496 L\n.96286 .5874 L\n.96476 .58979 L\n.96667 .59215 L\n.96857 .59447 L\n.97048 .59674 L\n.97238 .59898 L\n.97429 .60117 L\nMistroke\n.97619 .60332 L\nMfstroke\n0 .5 0 r\n.02381 .33379 m\n.02571 .33422 L\n.02762 .33493 L\n.02952 .33567 L\n.03143 .33642 L\n.03333 .33718 L\n.03524 .33793 L\n.03714 .33868 L\n.03905 .33942 L\n.04095 .34017 L\n.04286 .34092 L\n.04476 .34167 L\n.04667 .34241 L\n.04857 .34315 L\n.05048 .3439 L\n.05238 .34464 L\n.05429 .34537 L\n.05619 .34611 L\n.0581 .34685 L\n.06 .34758 L\n.0619 .34831 L\n.06381 .34904 L\n.06571 .34976 L\n.06762 .35049 L\n.06952 .35121 L\n.07143 .35193 L\n.07333 .35264 L\n.07524 .35335 L\n.07714 .35406 L\n.07905 .35477 L\n.08095 .35547 L\n.08286 .35617 L\n.08476 .35687 L\n.08667 .35756 L\n.08857 .35825 L\n.09048 .35893 L\n.09238 .35961 L\n.09429 .36029 L\n.09619 .36096 L\n.0981 .36163 L\n.1 .36229 L\n.1019 .36295 L\n.10381 .3636 L\n.10571 .36425 L\n.10762 .3649 L\n.10952 .36554 L\n.11143 .36617 L\n.11333 .3668 L\n.11524 .36743 L\n.11714 .36805 L\nMistroke\n.11905 .36866 L\n.12095 .36927 L\n.12286 .36987 L\n.12476 .37047 L\n.12667 .37106 L\n.12857 .37164 L\n.13048 .37222 L\n.13238 .3728 L\n.13429 .37336 L\n.13619 .37392 L\n.1381 .37448 L\n.14 .37503 L\n.1419 .37557 L\n.14381 .3761 L\n.14571 .37663 L\n.14762 .37715 L\n.14952 .37767 L\n.15143 .37818 L\n.15333 .37868 L\n.15524 .37917 L\n.15714 .37966 L\n.15905 .38014 L\n.16095 .38061 L\n.16286 .38107 L\n.16476 .38153 L\n.16667 .38198 L\n.16857 .38242 L\n.17048 .38286 L\n.17238 .38328 L\n.17429 .3837 L\n.17619 .38411 L\n.1781 .38452 L\n.18 .38491 L\n.1819 .3853 L\n.18381 .38568 L\n.18571 .38605 L\n.18762 .38641 L\n.18952 .38676 L\n.19143 .38711 L\n.19333 .38745 L\n.19524 .38777 L\n.19714 .38809 L\n.19905 .38841 L\n.20095 .38871 L\n.20286 .389 L\n.20476 .38929 L\n.20667 .38957 L\n.20857 .38983 L\n.21048 .39009 L\n.21238 .39034 L\nMistroke\n.21429 .39058 L\n.21619 .39082 L\n.2181 .39104 L\n.22 .39125 L\n.2219 .39146 L\n.22381 .39166 L\n.22571 .39184 L\n.22762 .39202 L\n.22952 .39219 L\n.23143 .39235 L\n.23333 .3925 L\n.23524 .39264 L\n.23714 .39277 L\n.23905 .39289 L\n.24095 .39301 L\n.24286 .39311 L\n.24476 .3932 L\n.24667 .39329 L\n.24857 .39336 L\n.25048 .39343 L\n.25238 .39349 L\n.25429 .39353 L\n.25619 .39357 L\n.2581 .3936 L\n.26 .39362 L\n.2619 .39363 L\n.26381 .39363 L\n.26571 .39362 L\n.26762 .3936 L\n.26952 .39357 L\n.27143 .39353 L\n.27333 .39349 L\n.27524 .39343 L\n.27714 .39336 L\n.27905 .39329 L\n.28095 .3932 L\n.28286 .39311 L\n.28476 .39301 L\n.28667 .39289 L\n.28857 .39277 L\n.29048 .39264 L\n.29238 .3925 L\n.29429 .39235 L\n.29619 .39219 L\n.2981 .39202 L\n.3 .39184 L\n.3019 .39166 L\n.30381 .39146 L\n.30571 .39125 L\n.30762 .39104 L\nMistroke\n.30952 .39082 L\n.31143 .39058 L\n.31333 .39034 L\n.31524 .39009 L\n.31714 .38983 L\n.31905 .38957 L\n.32095 .38929 L\n.32286 .389 L\n.32476 .38871 L\n.32667 .38841 L\n.32857 .38809 L\n.33048 .38777 L\n.33238 .38745 L\n.33429 .38711 L\n.33619 .38676 L\n.3381 .38641 L\n.34 .38605 L\n.3419 .38568 L\n.34381 .3853 L\n.34571 .38491 L\n.34762 .38452 L\n.34952 .38411 L\n.35143 .3837 L\n.35333 .38328 L\n.35524 .38286 L\n.35714 .38242 L\n.35905 .38198 L\n.36095 .38153 L\n.36286 .38107 L\n.36476 .38061 L\n.36667 .38014 L\n.36857 .37966 L\n.37048 .37917 L\n.37238 .37868 L\n.37429 .37818 L\n.37619 .37767 L\n.3781 .37715 L\n.38 .37663 L\n.3819 .3761 L\n.38381 .37557 L\n.38571 .37503 L\n.38762 .37448 L\n.38952 .37392 L\n.39143 .37336 L\n.39333 .3728 L\n.39524 .37222 L\n.39714 .37164 L\n.39905 .37106 L\n.40095 .37047 L\n.40286 .36987 L\nMistroke\n.40476 .36927 L\n.40667 .36866 L\n.40857 .36805 L\n.41048 .36743 L\n.41238 .3668 L\n.41429 .36617 L\n.41619 .36554 L\n.4181 .3649 L\n.42 .36425 L\n.4219 .3636 L\n.42381 .36295 L\n.42571 .36229 L\n.42762 .36163 L\n.42952 .36096 L\n.43143 .36029 L\n.43333 .35961 L\n.43524 .35893 L\n.43714 .35825 L\n.43905 .35756 L\n.44095 .35687 L\n.44286 .35617 L\n.44476 .35547 L\n.44667 .35477 L\n.44857 .35406 L\n.45048 .35335 L\n.45238 .35264 L\n.45429 .35193 L\n.45619 .35121 L\n.4581 .35049 L\n.46 .34976 L\n.4619 .34904 L\n.46381 .34831 L\n.46571 .34758 L\n.46762 .34685 L\n.46952 .34611 L\n.47143 .34537 L\n.47333 .34464 L\n.47524 .3439 L\n.47714 .34315 L\n.47905 .34241 L\n.48095 .34167 L\n.48286 .34092 L\n.48476 .34017 L\n.48667 .33942 L\n.48857 .33868 L\n.49048 .33793 L\n.49238 .33718 L\n.49429 .33642 L\n.49619 .33567 L\n.4981 .33492 L\nMistroke\n.5 .33417 L\n.5019 .33342 L\n.50381 .33267 L\n.50571 .33191 L\n.50762 .33116 L\n.50952 .33041 L\n.51143 .32966 L\n.51333 .32891 L\n.51524 .32816 L\n.51714 .32741 L\n.51905 .32667 L\n.52095 .32592 L\n.52286 .32518 L\n.52476 .32443 L\n.52667 .32369 L\n.52857 .32295 L\n.53048 .32221 L\n.53238 .32148 L\n.53429 .32074 L\n.53619 .32001 L\n.5381 .31928 L\n.54 .31855 L\n.5419 .31782 L\n.54381 .3171 L\n.54571 .31638 L\n.54762 .31566 L\n.54952 .31495 L\n.55143 .31423 L\n.55333 .31352 L\n.55524 .31282 L\n.55714 .31212 L\n.55905 .31142 L\n.56095 .31072 L\n.56286 .31003 L\n.56476 .30934 L\n.56667 .30866 L\n.56857 .30798 L\n.57048 .3073 L\n.57238 .30663 L\n.57429 .30596 L\n.57619 .3053 L\n.5781 .30464 L\n.58 .30398 L\n.5819 .30333 L\n.58381 .30269 L\n.58571 .30205 L\n.58762 .30141 L\n.58952 .30079 L\n.59143 .30016 L\n.59333 .29954 L\nMistroke\n.59524 .29893 L\n.59714 .29832 L\n.59905 .29772 L\n.60095 .29712 L\n.60286 .29653 L\n.60476 .29594 L\n.60667 .29536 L\n.60857 .29479 L\n.61048 .29422 L\n.61238 .29366 L\n.61429 .29311 L\n.61619 .29256 L\n.6181 .29202 L\n.62 .29148 L\n.6219 .29095 L\n.62381 .29043 L\n.62571 .28992 L\n.62762 .28941 L\n.62952 .28891 L\n.63143 .28842 L\n.63333 .28793 L\n.63524 .28745 L\n.63714 .28698 L\n.63905 .28651 L\n.64095 .28606 L\n.64286 .28561 L\n.64476 .28516 L\n.64667 .28473 L\n.64857 .2843 L\n.65048 .28389 L\n.65238 .28347 L\n.65429 .28307 L\n.65619 .28268 L\n.6581 .28229 L\n.66 .28191 L\n.6619 .28154 L\n.66381 .28118 L\n.66571 .28082 L\n.66762 .28048 L\n.66952 .28014 L\n.67143 .27981 L\n.67333 .27949 L\n.67524 .27918 L\n.67714 .27888 L\n.67905 .27858 L\n.68095 .2783 L\n.68286 .27802 L\n.68476 .27775 L\n.68667 .27749 L\n.68857 .27724 L\nMistroke\n.69048 .277 L\n.69238 .27677 L\n.69429 .27655 L\n.69619 .27633 L\n.6981 .27613 L\n.7 .27593 L\n.7019 .27574 L\n.70381 .27557 L\n.70571 .2754 L\n.70762 .27524 L\n.70952 .27509 L\n.71143 .27495 L\n.71333 .27482 L\n.71524 .27469 L\n.71714 .27458 L\n.71905 .27448 L\n.72095 .27438 L\n.72286 .2743 L\n.72476 .27422 L\n.72667 .27416 L\n.72857 .2741 L\n.73048 .27405 L\n.73238 .27402 L\n.73429 .27399 L\n.73619 .27397 L\n.7381 .27396 L\n.74 .27396 L\n.7419 .27397 L\n.74381 .27399 L\n.74571 .27402 L\n.74762 .27405 L\n.74952 .2741 L\n.75143 .27416 L\n.75333 .27422 L\n.75524 .2743 L\n.75714 .27438 L\n.75905 .27448 L\n.76095 .27458 L\n.76286 .27469 L\n.76476 .27482 L\n.76667 .27495 L\n.76857 .27509 L\n.77048 .27524 L\n.77238 .2754 L\n.77429 .27557 L\n.77619 .27574 L\n.7781 .27593 L\n.78 .27613 L\n.7819 .27633 L\n.78381 .27655 L\nMistroke\n.78571 .27677 L\n.78762 .277 L\n.78952 .27724 L\n.79143 .27749 L\n.79333 .27775 L\n.79524 .27802 L\n.79714 .2783 L\n.79905 .27858 L\n.80095 .27888 L\n.80286 .27918 L\n.80476 .27949 L\n.80667 .27981 L\n.80857 .28014 L\n.81048 .28048 L\n.81238 .28082 L\n.81429 .28118 L\n.81619 .28154 L\n.8181 .28191 L\n.82 .28229 L\n.8219 .28268 L\n.82381 .28307 L\n.82571 .28347 L\n.82762 .28389 L\n.82952 .2843 L\n.83143 .28473 L\n.83333 .28516 L\n.83524 .28561 L\n.83714 .28606 L\n.83905 .28651 L\n.84095 .28698 L\n.84286 .28745 L\n.84476 .28793 L\n.84667 .28842 L\n.84857 .28891 L\n.85048 .28941 L\n.85238 .28992 L\n.85429 .29043 L\n.85619 .29095 L\n.8581 .29148 L\n.86 .29202 L\n.8619 .29256 L\n.86381 .29311 L\n.86571 .29366 L\n.86762 .29422 L\n.86952 .29479 L\n.87143 .29536 L\n.87333 .29594 L\n.87524 .29653 L\n.87714 .29712 L\n.87905 .29772 L\nMistroke\n.88095 .29832 L\n.88286 .29893 L\n.88476 .29954 L\n.88667 .30016 L\n.88857 .30079 L\n.89048 .30141 L\n.89238 .30205 L\n.89429 .30269 L\n.89619 .30333 L\n.8981 .30398 L\n.9 .30464 L\n.9019 .3053 L\n.90381 .30596 L\n.90571 .30663 L\n.90762 .3073 L\n.90952 .30798 L\n.91143 .30866 L\n.91333 .30934 L\n.91524 .31003 L\n.91714 .31072 L\n.91905 .31142 L\n.92095 .31212 L\n.92286 .31282 L\n.92476 .31352 L\n.92667 .31423 L\n.92857 .31495 L\n.93048 .31566 L\n.93238 .31638 L\n.93429 .3171 L\n.93619 .31782 L\n.9381 .31855 L\n.94 .31928 L\n.9419 .32001 L\n.94381 .32074 L\n.94571 .32148 L\n.94762 .32221 L\n.94952 .32295 L\n.95143 .32369 L\n.95333 .32443 L\n.95524 .32518 L\n.95714 .32592 L\n.95905 .32667 L\n.96095 .32741 L\n.96286 .32816 L\n.96476 .32891 L\n.96667 .32966 L\n.96857 .33041 L\n.97048 .33116 L\n.97238 .33191 L\n.97429 .33267 L\nMistroke\n.97619 .33342 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0119048 0.119048 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0214286 0.0721271 0.140476 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 .5 0 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .08095 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(R2) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(i) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n93.000 12.813 moveto\n(L) show\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\n% Start of sub-graphic\np\n0.0110024 0.159524 0.0721271 0.278571 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00374 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .21905 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(R1) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(i) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n93.000 12.813 moveto\n(L) show\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00703IfMT00`000000fMWI0=WI\nf@3o0=WIf@80fMWI000L0=WIf@030000003IfMT0fMWI0?l0fMWI0P3IfMT001`0fMWI00<000000=WI\nf@3IfMT0o`3IfMT20=WIf@00703IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000L0=WIf@030000\n003IfMT0fMWI07l0fMWI2P000?mh0=WIf@00703IfMT00`000000fMWI0=WIf@1l0=WIf@@0003o2@3I\nfMT30000ogD0fMWI000L0=WIf@030000003IfMT0fMWI07/0fMWI0P000?l?0=WIf@80003oL`3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0N@3IfMT20000oa<0fMWI0P000?ma0=WIf@00703IfMT00`000000\nfMWI0=WIf@1g0=WIf@80003o5`3IfMT20000ofl0fMWI000L0=WIf@030000003IfMT0fMWI07H0fMWI\n0P000?lI0=WIf@80003oKP3IfMT001`0fMWI00<000000=WIf@3IfMT0M@3IfMT20000oa`0fMWI00<0\n003o0=WIf@3IfMT0J`3IfMT001`0fMWI00<000000=WIf@3IfMT0M03IfMT00`000?l0fMWI0=WIf@0L\n0=WIf@80003oK03IfMT001`0fMWI00<000000=WIf@3IfMT0L`3IfMT00`000?l0fMWI0=WIf@0O0=WI\nf@030000o`3IfMT0fMWI06T0fMWI000>0=WIf@D000000P3IfMT2000000D0fMWI00<000000=WIf@3I\nfMT0L@3IfMT20000ob<0fMWI00<0003o0=WIf@3IfMT0J03IfMT00100fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0L@3IfMT00`000?l0\nfMWI0=WIf@0S0=WIf@030000o`3IfMT0fMWI06L0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@00\n00000P3IfMT00`000000fMWI0=WIf@020=WIf@800000L@3IfMT00`000?l0fMWI0=WIf@0U0=WIf@03\n0000o`3IfMT0fMWI06H0fMWI00080=WIf@@00000103IfMT01@000000fMWI0=WIf@3IfMT000000080\nfMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI02L0\nfMWI00<0003o0=WIf@3IfMT0I@3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@03\n0000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0KP3IfMT00`000?l0fMWI0=WIf@0X0=WIf@80\n003oIP3IfMT000l0fMWI0P0000040=WIf@8000001@3IfMT00`000000fMWI0=WIf@1]0=WIf@030000\no`3IfMT0fMWI02X0fMWI0P000?mU0=WIf@00703IfMT00`000000fMWI0=WIf@1/0=WIf@80003o;@3I\nfMT20000of@0fMWI000L0=WIf@030000003IfMT0fMWI06/0fMWI0P000?l_0=WIf@030000o`3IfMT0\nfMWI0680fMWI000L0=WIf@030000003IfMT0fMWI06/0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00`00\n0?l0fMWI0=WIf@1Q0=WIf@00703IfMT00`000000fMWI0=WIf@1Z0=WIf@80003o<P3IfMT00`000?l0\nfMWI0=WIf@1P0=WIf@00703IfMT00`000000fMWI0=WIf@1Y0=WIf@80003o=03IfMT00`000?l0fMWI\n0=WIf@1O0=WIf@00703IfMT00`000000fMWI0=WIf@1Y0=WIf@030000o`3IfMT0fMWI03<0fMWI00<0\n003o0=WIf@3IfMT0G`3IfMT001`0fMWI00<000000=WIf@3IfMT0J03IfMT00`000?l0fMWI0=WIf@0e\n0=WIf@030000o`3IfMT0fMWI05h0fMWI000L0=WIf@030000003IfMT0fMWI06L0fMWI00<0003o0=WI\nf@3IfMT0=P3IfMT20000oel0fMWI000L0=WIf@030000003IfMT0fMWI06H0fMWI0P000?li0=WIf@03\n0000o`3IfMT0fMWI05d0fMWI000L0=WIf@030000003IfMT0fMWI06H0fMWI00<0003o0=WIf@3IfMT0\n>@3IfMT00`000?l0fMWI0=WIf@1L0=WIf@00703IfMT00`000000fMWI0=WIf@1U0=WIf@030000o`3I\nfMT0fMWI03/0fMWI00<0003o0=WIf@3IfMT0F`3IfMT001`0fMWI00<000000=WIf@3IfMT0I@3IfMT0\n0`000?l0fMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI05/0fMWI000L0=WIf@030000003IfMT0fMWI\n06@0fMWI00<0003o0=WIf@3IfMT0?@3IfMT00`000?l0fMWI0=WIf@1J0=WIf@00703IfMT00`000000\nfMWI0=WIf@1S0=WIf@80003o@03IfMT00`000?l0fMWI0=WIf@1I0=WIf@00703IfMT00`000000fMWI\n0=WIf@1S0=WIf@030000o`3IfMT0fMWI03l0fMWI00<0003o0=WIf@3IfMT0F@3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0HP3IfMT00`000?l0fMWI0=WIf@100=WIf@80003oFP3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0H@3IfMT20000od<0fMWI00<0003o0=WIf@3IfMT0F03IfMT001`0fMWI00<000000=WI\nf@3IfMT0H@3IfMT00`000?l0fMWI0=WIf@130=WIf@030000o`3IfMT0fMWI05L0fMWI000L0=WIf@03\n0000003IfMT0fMWI0600fMWI00<0003o0=WIf@3IfMT0A03IfMT00`000?l0fMWI0=WIf@1G0=WIf@00\n703IfMT00`000000fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI04D0fMWI00<0003o0=WIf@3IfMT0\nEP3IfMT001`0fMWI00<000000=WIf@3IfMT0G`3IfMT00`000?l0fMWI0=WIf@170=WIf@030000o`3I\nfMT0fMWI05D0fMWI000L0=WIf@030000003IfMT0fMWI05l0fMWI00<0003o0=WIf@3IfMT0A`3IfMT0\n0`000?l0fMWI0=WIf@1E0=WIf@00703IfMT00`000000fMWI0=WIf@1N0=WIf@030000o`3IfMT0fMWI\n04T0fMWI00<0003o0=WIf@3IfMT0E03IfMT001`0fMWI00<000000=WIf@3IfMT0GP3IfMT00`000?l0\nfMWI0=WIf@190=WIf@030000o`3IfMT0fMWI05@0fMWI000L0=WIf@030000003IfMT0fMWI05d0fMWI\n00<0003o0=WIf@3IfMT0B`3IfMT00`000?l0fMWI0=WIf@1C0=WIf@00703IfMT00`000000fMWI0=WI\nf@1L0=WIf@030000o`3IfMT0fMWI04`0fMWI00<0003o0=WIf@3IfMT0D`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@1=0=WIf@030000o`3IfMT0fMWI0580fMWI000E0=WI\nf@8000001@3IfMT00`000000fMWI0=WIf@1K0=WIf@030000o`3IfMT0fMWI04h0fMWI00<0003o0=WI\nf@3IfMT0DP3IfMT001@0fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@1K0=WI\nf@030000o`3IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0D@3IfMT001L0fMWI00<000000=WIf@3I\nfMT00P3IfMT2000005/0fMWI00<0003o0=WIf@3IfMT0D03IfMT20000oe80fMWI000>0=WIf@@00000\n0`3IfMT2000000D0fMWI00<000000=WIf@3IfMT0F@3IfMT20000oe<0fMWI00<0003o0=WIf@3IfMT0\nD03IfMT001D0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@1I0=WIf@030000o`3I\nfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0C`3IfMT001D0fMWI0`0000040=WIf@030000003IfMT0\nfMWI05T0fMWI00<0003o0=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@1?0=WIf@00703IfMT00`00\n0000fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0CP3IfMT001`0\nfMWI00<000000=WIf@3IfMT0F03IfMT00`000?l0fMWI0=WIf@1E0=WIf@030000o`3IfMT0fMWI04h0\nfMWI000L0=WIf@030000003IfMT0fMWI05L0fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI\n0=WIf@1>0=WIf@00703IfMT00`000000fMWI0=WIf@1G0=WIf@030000o`3IfMT0fMWI05L0fMWI00<0\n003o0=WIf@3IfMT0C@3IfMT001`0fMWI00<000000=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@1H\n0=WIf@030000o`3IfMT0fMWI04d0fMWI000L0=WIf@030000003IfMT0fMWI05D0fMWI00<0003o0=WI\nf@3IfMT0FP3IfMT00`000?l0fMWI0=WIf@1<0=WIf@00703IfMT00`000000fMWI0=WIf@1E0=WIf@03\n0000o`3IfMT0fMWI05/0fMWI00<0003o0=WIf@3IfMT0B`3IfMT001`0fMWI00<000000=WIf@3IfMT0\nE03IfMT00`000?l0fMWI0=WIf@1L0=WIf@030000o`3IfMT0fMWI04/0fMWI000L0=WIf@030000003I\nfMT0fMWI05@0fMWI00<0003o0=WIf@3IfMT0G@3IfMT00`000?l0fMWI0=WIf@1:0=WIf@00703IfMT0\n0`000000fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI05d0fMWI00<0003o0=WIf@3IfMT0BP3IfMT0\n01`0fMWI00<000000=WIf@3IfMT0D`3IfMT00`000?l0fMWI0=WIf@1O0=WIf@030000o`3IfMT0fMWI\n04T0fMWI000L0=WIf@030000003IfMT0fMWI05<0fMWI00<0003o0=WIf@3IfMT0G`3IfMT00`000?l0\nfMWI0=WIf@190=WIf@00703IfMT00`000000fMWI0=WIf@1B0=WIf@030000o`3IfMT0fMWI0640fMWI\n00<0003o0=WIf@3IfMT0B03IfMT001`0fMWI00<000000=WIf@3IfMT0D@3IfMT20000of<0fMWI00<0\n003o0=WIf@3IfMT0B03IfMT001`0fMWI00<000000=WIf@3IfMT0D@3IfMT00`000?l0fMWI0=WIf@1C\n0=WIf@D007l02P3IfMT00`000?l0fMWI0=WIf@180=WIf@00703IfMT00`000000fMWI0=WIf@1@0=WI\nf@030000o`3IfMT0fMWI04T0fMWI3000O`040=WIf@`007l0B@3IfMT001`0fMWI00<000000=WIf@3I\nfMT0D03IfMT00`000?l0fMWI0=WIf@130=WIf@H007l06`3IfMT7001o04<0fMWI000L0=WIf@030000\n003IfMT0fMWI04l0fMWI00<0003o0=WIf@3IfMT0@03IfMT4001o0280fMWI00<0003o0=WIf@3IfMT0\n0P3IfMT5001o03l0fMWI000L0=WIf@030000003IfMT0fMWI02@0fMWI0P0000040=WIf@8000000`3I\nfMT4000001`0fMWI00<0003o0=WIf@3IfMT00P0000040=WIf@8000001@3IfMT3000001h0fMWI0P00\n00040=WIf@8000000`3IfMT2000000D007l0703IfMT2000000@0fMWI0P0000020=WIf@040000o`3I\nfMT00000000000H0fMWI1000O`0K0=WIf@D000006`3IfMT001`0fMWI00<000000=WIf@3IfMT08`3I\nfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI01`0fMWI00@0003o0=WIf@3IfMT0\n00000P3IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI01`0fMWI00@000000=WIf@3I\nfMT000001`3IfMT4001o00030000003IfMT0fMWI01`0fMWI00@000000=WIf@3IfMT00000203IfMT0\n10000?l0fMWI0=WIf@0000090=WIf@<007l06P3IfMT00`000000fMWI0=WIf@0K0=WIf@00703IfMT0\n0`000000fMWI0=WIf@0S0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WIf@3IfMT06`3I\nfMT010000?l0fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00H0fMWI1@00000M0=WIf@040000\n003IfMT0fMWI000000@0fMWI1000O`0010000000fMWI0=WIf@00000N0=WIf@040000003IfMT0fMWI\n000000P0fMWI00@0003o0=WIf@3IfMT00000303IfMT4001o01H0fMWI00<000000=WIf@3IfMT06`3I\nfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@00000:0=WIf@030000003I\nfMT0fMWI01X0fMWI00@0003o0=WIf@3IfMT000000P3IfMT00`000000fMWI0=WIf@060=WIf@040000\n003IfMT0fMWI000001h0fMWI00D000000=WIf@3IfMT000000=WIf@04001o00<0fMWI0`00000O0=WI\nf@040000003IfMT0fMWI000000T0fMWI00<0003o0000003IfMT03`3IfMT4001o01<0fMWI00<00000\n0=WIf@3IfMT06`3IfMT001`0fMWI00<000000=WIf@3IfMT08`3IfMT010000000fMWI0=WIf@000008\n0=WIf@040000003IfMT0fMWI000001X0fMWI00D0003o0=WIf@3IfMT0fMWI000000020=WIf@030000\n003IfMT0fMWI00L0fMWI00<000000=WIf@0000007P3IfMT00`000000fMWI001o0002001o00P0fMWI\n00<000000=WIf@3IfMT07P3IfMT010000000fMWI0=WIf@0000080=WIf@04000000000?l0fMWI0000\n0180fMWI1000O`0@0=WIf@030000003IfMT0fMWI01/0fMWI000L0=WIf@030000003IfMT0fMWI02@0\nfMWI0P00000:0=WIf@8000006`3IfMT00`000?l0fMWI0=WIf@020=WIf@8000002`3IfMT2000001d0\nfMWI1000O`0:0=WIf@<000007`3IfMT2000000X0fMWI00<000000000o`3IfMT05@3IfMT3001o00d0\nfMWI0P00000M0=WIf@00703IfMT00`000000fMWI0=WIf@1<0=WIf@030000o`3IfMT0fMWI02d0fMWI\n0`00O`0m0=WIf@030000o`3IfMT0fMWI01H0fMWI0`00O`0Y0=WIf@00703IfMT00`000000fMWI0=WI\nf@1;0=WIf@80003o;03IfMT3001o0400fMWI00<0003o0=WIf@3IfMT06@3IfMT3001o02H0fMWI000L\n0=WIf@030000003IfMT0fMWI04/0fMWI00<0003o0=WIf@3IfMT0:03IfMT3001o04<0fMWI00<0003o\n0=WIf@3IfMT06`3IfMT4001o02<0fMWI000L0=WIf@030000003IfMT0fMWI04X0fMWI00<0003o0=WI\nf@3IfMT09`3IfMT3001o04H0fMWI00<0003o0=WIf@3IfMT07@3IfMT3001o0180fMWI0P00000=0=WI\nf@00703IfMT00`000000fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI02@0fMWI0`00O`190=WIf@03\n0000o`3IfMT0fMWI01l0fMWI1000O`0>0=WIf@040000003IfMT0fMWI000000`0fMWI000F0=WIf@H0\n00000P00O`1:000000030000o`000000000002<000000`00O`1<000000030000o`00000000000240\n00000P00O`05000000P0fMWI00<000000=WIf@3IfMT03@3IfMT001`0fMWI00<0003o001o0000O`00\n0P00O`060=WIf@030000003IfMT0fMWI00T0fMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI\n0=WIf@090=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI\n0=WIf@040=WIf@050000o`3IfMT0fMWI0=WIf@0000002`3IfMT00`000000fMWI0=WIf@080=WIf@03\n0000003IfMT0fMWI00D0fMWI0`00O`000`3IfMT000000=WIf@090=WIf@030000003IfMT0fMWI00T0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00P0\nfMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0000000/0\nfMWI00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@090=WIf@030000003IfMT0fMWI00X0\nfMWI1@00000<0=WIf@00703IfMT010000?l0fMWI0=WIf@3IfMT3001o04@0fMWI00<0003o0=WIf@3I\nfMT07`3IfMT2001o05<0fMWI00<0003o0=WIf@3IfMT0;`3IfMT00`000000fMWI0=WIf@0=0=WIf@00\n703IfMT00`000?l0fMWI0=WIf@030=WIf@@007l0@@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@<007l0\nE@3IfMT00`000?l0fMWI0=WIf@0o0=WIf@00703IfMT00`000?l0fMWI0=WIf@060=WIf@<007l0?`3I\nfMT00`000?l0fMWI0=WIf@0I0=WIf@<007l0F@3IfMT00`000?l0fMWI0=WIf@0n0=WIf@00703IfMT0\n0`000000003o0=WIf@090=WIf@<007l0>`3IfMT00`000?l0fMWI0=WIf@0H0=WIf@<007l0F`3IfMT0\n0`000?l0fMWI0=WIf@0n0=WIf@00703IfMT00`000000003o0=WIf@0;0=WIf@@007l0>03IfMT00`00\n0?l0fMWI0=WIf@0E0=WIf@<007l0G`3IfMT00`000?l0fMWI0=WIf@0m0=WIf@00703IfMT00`000000\n003o0=WIf@0>0=WIf@@007l0=03IfMT00`000?l0fMWI0=WIf@0C0=WIf@<007l0HP3IfMT00`000?l0\nfMWI0=WIf@0m0=WIf@00703IfMT00`000000003o0=WIf@0A0=WIf@@007l0<03IfMT00`000?l0fMWI\n0=WIf@0A0=WIf@<007l0IP3IfMT00`000?l0fMWI0=WIf@0l0=WIf@00703IfMT00`000000fMWI0000\no`0D0=WIf@@007l0;@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@D007l0J03IfMT00`000?l0fMWI0=WI\nf@0l0=WIf@00703IfMT00`000000fMWI0000o`0H0=WIf@<007l0:@3IfMT00`000?l0fMWI0=WIf@0;\n0=WIf@@007l0K03IfMT00`000?l0fMWI0=WIf@0l0=WIf@00703IfMT00`000000fMWI0000o`0K0=WI\nf@D007l0903IfMT00`000?l0fMWI0=WIf@070=WIf@D007l0L03IfMT00`000?l0fMWI0=WIf@0k0=WI\nf@00703IfMT010000000fMWI0=WIf@000?lN0=WIf@D007l07`3IfMT00`000?l0fMWI0=WIf@030=WI\nf@H007l0M03IfMT00`000?l0fMWI0=WIf@0k0=WIf@00703IfMT010000000fMWI0=WIf@000?lS0=WI\nf@H007l06@3IfMT7001o07X0fMWI00<0003o0=WIf@3IfMT0>P3IfMT001`0fMWI00@000000=WIf@3I\nfMT0003o:@3IfMTJ001o0800fMWI00<0003o0=WIf@3IfMT0>P3IfMT001`0fMWI00D000000=WIf@3I\nfMT0fMWI0000o`100=WIf@030000o`3IfMT0fMWI0800fMWI00<0003o0=WIf@3IfMT0>@3IfMT001`0\nfMWI00D000000=WIf@3IfMT0fMWI0000o`0o0=WIf@030000o`3IfMT0fMWI0840fMWI00<0003o0=WI\nf@3IfMT0>@3IfMT001`0fMWI00D000000=WIf@3IfMT0fMWI0000o`0o0=WIf@030000o`3IfMT0fMWI\n0880fMWI00<0003o0=WIf@3IfMT0>03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@0k0=WIf@030000o`3IfMT0fMWI08<0fMWI0P000?li0=WIf@00703IfMT00`000000fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI03/0fMWI00<0003o0=WIf@3IfMT0Q03IfMT00`000?l0fMWI\n0=WIf@0g0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI03X0fMWI00<0\n003o0=WIf@3IfMT0Q@3IfMT00`000?l0fMWI0=WIf@0g0=WIf@00703IfMT00`000000fMWI0=WIf@03\n0=WIf@030000o`3IfMT0fMWI03P0fMWI0P000?n80=WIf@030000o`3IfMT0fMWI03H0fMWI000L0=WI\nf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0>03IfMT00`000?l0fMWI0=WIf@270=WI\nf@030000o`3IfMT0fMWI03H0fMWI000L0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0=`3IfMT00`000?l0fMWI0=WIf@290=WIf@030000o`3IfMT0fMWI03D0fMWI000L0=WIf@030000\n003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0=`3IfMT00`000?l0fMWI0=WIf@290=WIf@030000\no`3IfMT0fMWI03D0fMWI000L0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0=@3I\nfMT00`000?l0fMWI0=WIf@2;0=WIf@030000o`3IfMT0fMWI03@0fMWI000L0=WIf@030000003IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@2;0=WIf@030000o`3IfMT0\nfMWI03@0fMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0<`3IfMT00`00\n0?l0fMWI0=WIf@2=0=WIf@030000o`3IfMT0fMWI03<0fMWI000L0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0<`3IfMT00`000?l0fMWI0=WIf@2=0=WIf@030000o`3IfMT0fMWI03<0\nfMWI000L0=WIf@030000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00`000?l0fMWI\n0=WIf@2?0=WIf@030000o`3IfMT0fMWI0380fMWI000L0=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT0<03IfMT20000oi80fMWI00<0003o0=WIf@3IfMT0<@3IfMT001D0fMWI0P000005\n0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0<03IfMT00`000?l0fMWI0=WIf@2A\n0=WIf@030000o`3IfMT0fMWI0340fMWI000D0=WIf@040000003IfMT0fMWI000000@0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@030000o`3IfMT0fMWI0980fMWI00<0003o\n0=WIf@3IfMT0<@3IfMT001L0fMWI00<000000=WIf@3IfMT00P3IfMT2000000P0fMWI00<0003o0=WI\nf@3IfMT0;@3IfMT20000oiD0fMWI00<0003o0=WIf@3IfMT0<03IfMT001D0fMWI0P0000050=WIf@03\n0000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0;03IfMT00`000?l0fMWI0=WIf@2D0=WIf@03\n0000o`3IfMT0fMWI0300fMWI000E0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@0/0=WIf@030000o`3IfMT0fMWI09D0fMWI00<0003o0=WIf@3IfMT0\n;`3IfMT001D0fMWI0`0000040=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0:`3I\nfMT00`000?l0fMWI0=WIf@2F0=WIf@80003o<03IfMT001`0fMWI00<000000=WIf@3IfMT02@3IfMT0\n0`000?l0fMWI0=WIf@0Y0=WIf@030000o`3IfMT0fMWI09P0fMWI00<0003o0=WIf@3IfMT0;P3IfMT0\n01`0fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0X0=WIf@80003oV`3IfMT00`00\n0?l0fMWI0=WIf@0]0=WIf@00703IfMT00`000000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI02L0\nfMWI00<0003o0=WIf@3IfMT0VP3IfMT00`000?l0fMWI0=WIf@0]0=WIf@00703IfMT00`000000fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI02H0fMWI00<0003o0=WIf@3IfMT0W03IfMT00`000?l0fMWI\n0=WIf@0/0=WIf@00703IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI02@0fMWI00<0\n003o0=WIf@3IfMT0W@3IfMT20000obd0fMWI000L0=WIf@030000003IfMT0fMWI00/0fMWI0P000?lT\n0=WIf@80003oX03IfMT00`000?l0fMWI0=WIf@0[0=WIf@00703IfMT00`000000fMWI0=WIf@0<0=WI\nf@030000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT0W`3IfMT00`000?l0fMWI0=WIf@0[0=WI\nf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0200fMWI00<0003o0=WIf@3I\nfMT0X@3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@00703IfMT00`000000fMWI0=WIf@0=0=WIf@80003o\n803IfMT20000oj<0fMWI0P000?l[0=WIf@00703IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI01d0fMWI0P000?nU0=WIf@030000o`3IfMT0fMWI02T0fMWI000L0=WIf@030000003IfMT0\nfMWI00h0fMWI0P000?lM0=WIf@80003oY`3IfMT00`000?l0fMWI0=WIf@0X0=WIf@00703IfMT00`00\n0000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI01X0fMWI0P000?nX0=WIf@80003o:@3IfMT001`0\nfMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@0H0=WIf@80003oZP3IfMT00`000?l0\nfMWI0=WIf@0W0=WIf@00703IfMT00`000000fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI01L0fMWI\n00<0003o0=WIf@3IfMT0ZP3IfMT00`000?l0fMWI0=WIf@0V0=WIf@00703IfMT00`000000fMWI0=WI\nf@0B0=WIf@030000o`3IfMT0fMWI01@0fMWI0P000?n]0=WIf@80003o9`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@80003o[`3IfMT00`000?l0fMWI0=WIf@0U\n0=WIf@00703IfMT00`000000fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0100fMWI0P000?n`0=WI\nf@030000o`3IfMT0fMWI02D0fMWI000L0=WIf@030000003IfMT0fMWI01@0fMWI0P000?l?0=WIf@80\n003o/`3IfMT00`000?l0fMWI0=WIf@0T0=WIf@00703IfMT00`000000fMWI0=WIf@0F0=WIf@80003o\n303IfMT20000okD0fMWI00<0003o0=WIf@3IfMT08`3IfMT001`0fMWI00<000000=WIf@3IfMT0603I\nfMT30000o`H0fMWI0`000?ng0=WIf@80003o903IfMT001`0fMWI00<000000=WIf@3IfMT06P3IfMT7\n0000ok/0fMWI00<0003o0=WIf@3IfMT08P3IfMT001`0fMWI00<000000=WIf@3IfMT0g@3IfMT00`00\n0?l0fMWI0=WIf@0Q0=WIf@00703IfMT00`000000fMWI0=WIf@3N0=WIf@030000o`3IfMT0fMWI0200\nfMWI000L0=WIf@030000003IfMT0fMWI0=l0fMWI00<0003o0=WIf@3IfMT07`3IfMT001`0fMWI00<0\n00000=WIf@3IfMT0g`3IfMT00`000?l0fMWI0=WIf@0O0=WIf@00703IfMT00`000000fMWI0=WIf@3P\n0=WIf@030000o`3IfMT0fMWI01h0fMWI000L0=WIf@030000003IfMT0fMWI0>40fMWI00<0003o0=WI\nf@3IfMT07@3IfMT000h0fMWI1@0000020=WIf@8000001@3IfMT00`000000fMWI0=WIf@3R0=WIf@03\n0000o`3IfMT0fMWI01`0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI0>80fMWI0P000?lM0=WIf@00403IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00<000000=WIf@3IfMT00P3IfMT200000?l0fMWI0`3IfMT00100fMWI\n00D000000=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3I\nfMT0o`3IfMT20=WIf@00403IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@3o0=WIf@80fMWI000?0=WIf@800000103IfMT2000000D0fMWI\n00<000000=WIf@3IfMT0o`3IfMT20=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WI\nf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@009@3IfMT00`000000fMWI0=WIf@0H0=WIf@030000003I\nfMT0fMWI00D0fMWI0P0000080=WIf@800000c03IfMT002@0fMWI00<000000=WIf@3IfMT06P3IfMT0\n0`000000fMWI0=WIf@040=WIf@030000003IfMT0fMWI00P0fMWI00<000000=WIf@3IfMT0bP3IfMT0\n02<0fMWI00@000000=WIf@3IfMT0fMWI0`0000020=WIf@030000003IfMT0000000<000000`3IfMT2\n000000@0fMWI0`0000040=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2\n000000@0fMWI00<000000=WIf@3IfMT0bP3IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000003IfMT0fMWI00/0fMWI00<000000=WIf@3IfMT00`3IfMT0\n0`000000fMWI0=WIf@030=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT01@000000fMWI0=WI\nf@3IfMT000000<`0fMWI000F0=WIf@P007l01@3IfMT00`000000fMWI0=WIf@020=WIf@<00000103I\nfMT00`000000fMWI0=WIf@0:0=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00`3I\nfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0bP3IfMT002<0fMWI00<0\n00000=WIf@3IfMT00P3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0fMWI00P0fMWI\n0P0000050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT01@0000030=WIf@030000\n003IfMT0fMWI0<X0fMWI000T0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI\n0=WIf@0000020=WIf@030000003IfMT0fMWI00d0fMWI00<000000=WIf@3IfMT0103IfMT01@000000\nfMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0bP3IfMT002D0fMWI00<000000=WIf@00\n00000`0000040=WIf@8000002`3IfMT01@000000fMWI0=WIf@3IfMT0000000L0fMWI0P0000080=WI\nf@800000c03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT0\n0?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0603IfMT00`000000fMWI\n0=WIf@050=WIf@800000203IfMT200000<`0fMWI000T0=WIf@030000003IfMT0fMWI01X0fMWI00<0\n00000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0<X0fMWI000S\n0=WIf@040000003IfMT0fMWI0=WIf@<000000P3IfMT00`000000fMWI0000000400000080fMWI0P00\n00040=WIf@<00000103IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI0P00\n00040=WIf@030000003IfMT0fMWI0<X0fMWI000F0=WIf@P0003o1@3IfMT00`000000fMWI0=WIf@02\n0=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WI\nf@030=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@050000\n003IfMT0fMWI0=WIf@000000c03IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT3000000D0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00<0fMWI\n00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0<X0fMWI000S0=WIf@030000\n003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WIf@080=WIf@80\n00001@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3IfMT00`000000\nfMWI0=WIf@3:0=WIf@00903IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@3I\nfMT00P3IfMT00`000000fMWI0=WIf@0>0=WIf@030000003IfMT0fMWI00@0fMWI00D000000=WIf@3I\nfMT0fMWI000000060=WIf@030000003IfMT0fMWI0<X0fMWI000U0=WIf@030000003IfMT0000000<0\n0000103IfMT2000000/0fMWI00D000000=WIf@3IfMT0fMWI000000070=WIf@800000203IfMT20000\n0<`0fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.121768`, -14.4075`, 0.00434554`, 0.152161`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -10.3955`, 0.119891`, 0.0615577`]], Rule[List[List[22.125`, 30.4375`], List[43.0625`, 26.8125`]], List[-6.32337`, -42.9027`, 0.240604`, 0.240604`]], Rule[List[List[22.125`, 30.4375`], List[24.1875`, 7.9375`]], List[-6.32337`, -47.4441`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"], Cell["", "NumberedFigure"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[928, 889]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]