List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Restricted Classes", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The ", StyleBox["class", Rule[FontFamily, "Courier"]], " concept is fundamental to Modelica, almost anything in Modelica is a ", StyleBox["class", Rule[FontFamily, "Courier"]], ". Special keywords, replacing the word ", StyleBox["class", Rule[FontFamily, "Courier"]], ", are used for different purposes, not changing the syntax of the structure. The keywords ", StyleBox["model, connector, record, block", Rule[FontFamily, "Courier"]], " and ", StyleBox["type", Rule[FontFamily, "Courier"]], " have some restrictions compared to the class keyword and they can be used in specific cases."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Model", "Section"], Cell[TextData[List["This keyword is used for modeling purposes. The only restriction is that a", StyleBox[" model", Rule[FontFamily, "Courier"]], " may not be used in connections."]], "Text"], Cell[TextData[List[StyleBox["model", Rule[FontColor, RGBColor[0, 0, 1]]], " SimpleCar\n  Wheel w1, w2, w3, w4 \t\t\"Four wheels\";\n  Chassis chassis;\nend SimpleCar;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Record", "Section"], Cell[TextData[List["A ", StyleBox["record", Rule[FontFamily, "Courier"]], " is a class for specifying a record data structure. Equations are not allowed in a ", StyleBox["record", Rule[FontFamily, "Courier"]], " at all and a ", StyleBox["record", Rule[FontFamily, "Courier"]], " may not be used in a connection."]], "Text"], Cell[TextData[List[StyleBox["record", Rule[FontColor, RGBColor[0, 0, 1]]], " person\n  Real age;\n  String name;\nend person;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Type", "Section"], Cell[TextData[List["The restricted class ", StyleBox["type", Rule[FontFamily, "Courier"]], " is often used to introduce new type names. A ", StyleBox["type", Rule[FontFamily, "Courier"]], " may be an extension to either a predefined type (e.g. ", StyleBox["Real", Rule[FontFamily, "Courier"]], " or ", StyleBox["Integer", Rule[FontFamily, "Courier"]], "), a ", StyleBox["record", Rule[FontFamily, "Courier"]], " ", StyleBox["class", Rule[FontFamily, "Courier"]], " or some kind of array."]], "Text"], Cell[TextData[List[StyleBox["type", Rule[FontColor, RGBColor[0, 0, 1]]], " Matrix = Real[3, 3];"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Connector", "Section"], Cell[TextData[List[StyleBox["Connector", Rule[FontFamily, "Courier"]], " classes are used for communication between objects. No equations are allowed at all in a ", StyleBox["connector", Rule[FontFamily, "Courier"]], " class. Instances of connector classes form the interface of a component (how it connects to the outer world)."]], "Text"], Cell[TextData[List[StyleBox["connector", Rule[FontColor, RGBColor[0, 0, 1]]], " Pin\n  Voltage v;\n  flow Current i;\nend Pin;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Block", "Section"], Cell[TextData[List["A ", StyleBox["block", Rule[FontFamily, "Courier"]], " is class for which the data flow direction is known for each of its variables. All variables declared in a ", StyleBox["block", Rule[FontFamily, "Courier"]], " must have one of the prefixes ", StyleBox["input", Rule[FontFamily, "Courier"]], " or ", StyleBox["output", Rule[FontFamily, "Courier"]], ". A ", StyleBox["block", Rule[FontFamily, "Courier"]], " may not be used in connections. "]], "Text"], Cell[TextData[List[StyleBox["block", Rule[FontColor, RGBColor[0, 0, 1]]], " Multiply\n  input Real x;\n  input Real y(start=0);\n  output Real result;\nequation \n  result = x*y;\nend Multiply;  "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Function", "Section"], Cell[TextData[List["The ", StyleBox["function", Rule[FontFamily, "Courier"]], " concept in Modelica corresponds to mathematical functions without external side effects. These are the restrictions of a ", StyleBox["function", Rule[FontFamily, "Courier"]], ":"]], "Text"], Cell["Each formal parameter of the function must be prefixed by either input or output and be public and non-constant. ", "Itemize"], Cell["A function may not be used in connections, may have no equations, and can have at most one algorithm.", "Itemize"], Cell["For a function to be called, it must either have an algorithm or an external function interface as its body.", "Itemize"], Cell[TextData[List["A function cannot contain calls to the Modelica built-in operators, ", StyleBox["der, initial, terminal, sample, pre, edge, change, reinit, delay, cardinality, ", Rule[FontFamily, "Courier"]], "and is not allowed to contain when-statements."]], "Itemize"], Cell["A subtype of a function type needs to be equivalent to the function type itself.", "Itemize"], Cell["The size of each array result or array local variable of a function must either be given by the formal parameters, or given by constant or parameter expressions.", "Itemize"], Cell[CellGroupData[List[Cell["Multiply", "Subsection"], Cell[TextData[List[StyleBox["function", Rule[FontColor, RGBColor[0, 0, 1]]], " multiply\n  input Real x;\n  input Real y := 0;\n  output Real result;\nalgorithm\n  result := x*y;\nend multiply;    "]], "ModelicaInput"], Cell[TextData[List["\nThe function ", StyleBox["multiply", Rule[FontFamily, "Courier"]], " can be called:"]], "Text"], Cell["class MultCall\n  Real res;\nequation\n  res = multiply(3.5, 2.0);\t\t\t\t// Function call\nend MultCall;  ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["MakeAlive on multiply", "Subsection"], Cell["We use MakeAlive on functions to see the results. ", "Text"], Cell[BoxData[RowBox[List["MakeAlive", "[", "multiply", "]"]]], "Input"], Cell[BoxData[RowBox[List["multiply", "[", RowBox[List["2.0", ",", " ", "5.0"]], "]"]]], "Input"]], Closed]], Cell[CellGroupData[List[Cell["MultCall2", "Subsection"], Cell["The second argument can be left out, since the default value is available for this argument.", "Text"], Cell["class MultCall2\n  Real res;\nequation\n  res = multiply(x = 5);\nend MultCall2;  ", "ModelicaInput"]], Open]]], Open]], Cell[CellGroupData[List[Cell["Package", "Section", Rule[CellTags, "Package"]], Cell[CellGroupData[List[Cell["What is a Package?", "Subsection"], Cell["The definitions in a package should be related in some way, which is the main reason they are placed in a particular package. Parameters and variables cannot be declared in a package.", "Text"], Cell[TextData[List["A ", StyleBox["package", Rule[FontFamily, "Courier"]], " is a restricted and enhanced class that is primarily used to manage name spaces and organize Modelica code. A ", StyleBox["package", Rule[FontFamily, "Courier"]], " has the restrictions of only containing declarations of classes including all kinds of restricted classes and constants, i.e. no variable declarations. Also a ", StyleBox["package", Rule[FontFamily, "Courier"]], " has the enhancement of being allowed to import from. "]], "Text"], Cell[TextData[List[StyleBox["package", Rule[FontColor, RGBColor[0, 0, 1]]], " smallpack\n\n  constant Real mypi = 3.14159;\n  \n  connector Pin\n    Voltage v;\n    flow Current i;\n  end Pin;  \n\n  function multiply\n    input Real x;\n    input Real y = 0;\n    output Real result;\n  algorithm\n    result := x*y;\n  end multiply;    \n  \nend smallpack;"]], "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[868, 924]], Rule[WindowMargins, List[List[7, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]