List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Reuse of Modified Classes", "Title"], Cell["\nThe class concept is the key to reusing modeling knowledge in Modelica. Assume that we would like to connect two filter models in series. Instead of creating two separate filter classes it is better to define a common filter class and create two instances of this class, which are connected. \n", "Text"], Cell["model LowPassFilter\n  parameter Real T = 1;\n  Real u, y(start = 1);\nequation\n  T*der(y) + y = u;\nend LowPassFilter;", "ModelicaInput"], Cell[TextData[List["\nThe ", StyleBox["LowPassFilter", Rule[FontFamily, "Courier"]], " class can be used to create two separate instances of the filter and connect them by using the equation ", StyleBox["F2.u = F1.y", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell[TextData[List["model FiltersInSeries\n  ", StyleBox["LowPassFilter F1(T = 2),  F2(T = 3);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nequation\n  F1.u = sin(time);\n  ", StyleBox["F2.u = F1.y;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend FiltersInSeries;"]], "ModelicaInput"], Cell[TextData[List["\n", StyleBox["FiltersInSeries", Rule[FontFamily, "Courier"]], " can be used to declare variables at a higher hierarchical level."]], "Text"], Cell["model ModifiedFiltersInSeries\n  FiltersInSeries F12(F1(T = 6), F2.T = 11);\nend ModifiedFiltersInSeries;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simulation of FiltersInSeries and ModifiedFiltersInSeries", "Section"], Cell["simulate( FiltersInSeries );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(FiltersInSeries\\) : 2004-1-30 9:5:47.7708300 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\(F1 . T\\), HoldForm], \\*TagBox[\\(F1 . u\\), HoldForm], \\*TagBox[\\(F1 . y\\), HoldForm], \\*TagBox[\\(F2 . T\\), HoldForm], \\*TagBox[\\(F2 . u\\), HoldForm], \\*TagBox[\\(F2 . y\\), HoldForm], \\*TagBox[SuperscriptBox[\\((F1 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((F2 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["simulate( ModifiedFiltersInSeries );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(ModifiedFiltersInSeries\\) : 2004-1-30 9:6:10.5198108 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 8 variables>\\n\\!\\({\\*TagBox[\\(F12 . F1 . T\\), HoldForm], \\*TagBox[\\(F12 . F1 . u\\), HoldForm], \\*TagBox[\\(F12 . F1 . y\\), HoldForm], \\*TagBox[\\(F12 . F2 . T\\), HoldForm], \\*TagBox[\\(F12 . F2 . u\\), HoldForm], \\*TagBox[\\(F12 . F2 . y\\), HoldForm], \\*TagBox[SuperscriptBox[\\((F12 . F1 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((F12 . F2 . y)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[876, 924]], Rule[WindowMargins, List[List[5, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]