List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Short Classes", "Title"], Cell["\nThere is a short syntax for defining classes, commonly used to introduce more informative type names for existing classes.", "Text"], Cell[TextData[StyleBox["class Voltage = Real(Unit = \"V\");", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell[TextData[List["\nThe same thing can be written using the keyword ", StyleBox["type", Rule[FontFamily, "Courier"]], " instead:"]], "Text"], Cell[TextData[StyleBox["type Voltage = Real;", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell["\nThe short class definition is the only way to introduce a \"class\" name for an array type:", "Text"], Cell[TextData[StyleBox["type Matrix10 = Real [10, 10];", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell["\nA short class definition is in most cases just a shorter syntax for defining a class that could just as well be defined using the standard inheritance syntax:", "Text"], Cell[TextData[List["type Voltage\n", StyleBox["  extends Real(unit = \"V\", min = -220.0, max = 220.0);\n", Rule[FontColor, RGBColor[0, 0, 1]]], "end Voltage;"]], "ModelicaInput"], Cell["\nWhich is just the same as this:", "Text"], Cell[TextData[StyleBox["type Voltage = Real(unit = \"V\", min = -220.0, max = 220.0);", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"], Cell["\nWriting array types is done this short way:", "Text"], Cell[TextData[StyleBox["type Force3 = Real[3](unit={\"N\",\"N\",\"N\"});", Rule[FontColor, RGBColor[0, 0, 1]]]], "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[914, 924]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 2]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]