List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Cardinality Dependent Connection Equations", "Title"], Cell[CellGroupData[List[Cell["CardinalityResistor", "Section"], Cell[TextData[List["In certain cases there is a need to let the behavior of a model be dependent on the number of connections to certain connectors of the model. Below is an example class containing a conditional if-clause equation with a condition that is a parameter expression (the built-in function cardinality has parameter variability), i.e.the condition does not change during simulation. The function ", StyleBox["cardinality", Rule[FontFamily, "Courier"]], "(", StyleBox["c", Rule[FontSlant, "Italic"]], ") with formal parameter ", StyleBox["c", Rule[FontSlant, "Italic"]], " returns the total number of (internal and external) occurrences of the connector ", StyleBox["c", Rule[FontSlant, "Italic"]], " in ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statements in the total model.\n"]], "Text"], Cell[TextData[List["model CardinalityResistor\n  extends Modelica.Electrical.Analog.Interfaces.OnePort;\n  parameter Real R(unit = \"Ohm\")\t\t\"Resistance\";\nequation\n\n  // Handle cases if pins are not connected\n  ", StyleBox["if cardinality(p) == 0 and cardinality(n) == 0 then\n    p.v = 0;\n    n.v = 0;\n  elseif cardinality(p) == 0 then\n    p.i = 0;\n  elseif cardinality(n) == 0 then\n    n.i = 0; \n  end if;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  \n  // Resistor equation\n  v = R * i;\nend CardinalityResistor;"]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of CardinalityResistor ", "Section"], Cell["model circuit\n\tCardinalityResistor R1( R=100 );\n\tModelica.Electrical.Analog.Basic.Ground Gnd;\n\tModelica.Electrical.Analog.Sources.SineVoltage U1;\nequation\n\tconnect( R1.n, U1.n );\n\tconnect( R1.p, Gnd.p );\n\tconnect( U1.p, Gnd.p );\nend circuit;", "ModelicaInput"], Cell["", "Text"], Cell["simulate( circuit );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(circuit\\) : 2004-2-3 13:40:39.0074946 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 31 variables>\\n\\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(Gnd . p . i\\), HoldForm], \\*TagBox[\\(Gnd . p . v\\), HoldForm], \\*TagBox[\\(R1 . i\\), HoldForm], \\*TagBox[\\(R1 . n . i\\), HoldForm], \\*TagBox[\\(R1 . n . v\\), HoldForm], \\*TagBox[\\(R1 . p . i\\), HoldForm], \\*TagBox[\\(R1 . p . v\\), HoldForm], \\*TagBox[\\(R1 . R\\), HoldForm], \\*TagBox[\\(R1 . v\\), HoldForm], \\*TagBox[\\(U1 . freqHz\\), HoldForm], \\*TagBox[\\(U1 . i\\), HoldForm], \\*TagBox[\\(U1 . n . i\\), HoldForm], \\*TagBox[\\(U1 . n . v\\), HoldForm], \\*TagBox[\\(U1 . offset\\), HoldForm], \\*TagBox[\\(U1 . phase\\), HoldForm], \\*TagBox[\\(U1 . p . i\\), HoldForm], \\*TagBox[\\(U1 . p . v\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . amplitude\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . freqHz\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(U1 . signalSource . nout\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . offset\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(U1 . signalSource . outPort . n\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . outPort . signal\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . phase\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . startTime\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(U1 . signalSource . y\\)\\) \[LeftDoubleBracket] \\(\\(1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(U1 . startTime\\), HoldForm], \\*TagBox[\\(U1 . v\\), HoldForm], \\*TagBox[\\(U1 . V\\), HoldForm]}\\)\""], "Output"], Cell["plot( R1.v );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 0.952381 0.309017 0.294302 [\n[.21429 .29652 -9 -9 ]\n[.21429 .29652 9 0 ]\n[.40476 .29652 -9 -9 ]\n[.40476 .29652 9 0 ]\n[.59524 .29652 -9 -9 ]\n[.59524 .29652 9 0 ]\n[.78571 .29652 -9 -9 ]\n[.78571 .29652 9 0 ]\n[.97619 .29652 -3 -9 ]\n[.97619 .29652 3 0 ]\n[1.025 .30902 0 -6.28125 ]\n[1.025 .30902 10 6.28125 ]\n[.01131 .01472 -12 -4.5 ]\n[.01131 .01472 0 4.5 ]\n[.01131 .16187 -24 -4.5 ]\n[.01131 .16187 0 4.5 ]\n[.01131 .45617 -18 -4.5 ]\n[.01131 .45617 0 4.5 ]\n[.01131 .60332 -6 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30902 m\n.21429 .31527 L\ns\n[(0.2)] .21429 .29652 0 1 Mshowa\n.40476 .30902 m\n.40476 .31527 L\ns\n[(0.4)] .40476 .29652 0 1 Mshowa\n.59524 .30902 m\n.59524 .31527 L\ns\n[(0.6)] .59524 .29652 0 1 Mshowa\n.78571 .30902 m\n.78571 .31527 L\ns\n[(0.8)] .78571 .29652 0 1 Mshowa\n.97619 .30902 m\n.97619 .31527 L\ns\n[(1)] .97619 .29652 0 1 Mshowa\n.125 Mabswid\n.07143 .30902 m\n.07143 .31277 L\ns\n.11905 .30902 m\n.11905 .31277 L\ns\n.16667 .30902 m\n.16667 .31277 L\ns\n.2619 .30902 m\n.2619 .31277 L\ns\n.30952 .30902 m\n.30952 .31277 L\ns\n.35714 .30902 m\n.35714 .31277 L\ns\n.45238 .30902 m\n.45238 .31277 L\ns\n.5 .30902 m\n.5 .31277 L\ns\n.54762 .30902 m\n.54762 .31277 L\ns\n.64286 .30902 m\n.64286 .31277 L\ns\n.69048 .30902 m\n.69048 .31277 L\ns\n.7381 .30902 m\n.7381 .31277 L\ns\n.83333 .30902 m\n.83333 .31277 L\ns\n.88095 .30902 m\n.88095 .31277 L\ns\n.92857 .30902 m\n.92857 .31277 L\ns\n.25 Mabswid\n0 .30902 m\n1 .30902 L\ns\ngsave\n1.025 .30902 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01472 m\n.03006 .01472 L\ns\n[(-1)] .01131 .01472 1 0 Mshowa\n.02381 .16187 m\n.03006 .16187 L\ns\n[(-0.5)] .01131 .16187 1 0 Mshowa\n.02381 .45617 m\n.03006 .45617 L\ns\n[(0.5)] .01131 .45617 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(1)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04415 m\n.02756 .04415 L\ns\n.02381 .07358 m\n.02756 .07358 L\ns\n.02381 .10301 m\n.02756 .10301 L\ns\n.02381 .13244 m\n.02756 .13244 L\ns\n.02381 .1913 m\n.02756 .1913 L\ns\n.02381 .22073 m\n.02756 .22073 L\ns\n.02381 .25016 m\n.02756 .25016 L\ns\n.02381 .27959 m\n.02756 .27959 L\ns\n.02381 .33845 m\n.02756 .33845 L\ns\n.02381 .36788 m\n.02756 .36788 L\ns\n.02381 .39731 m\n.02756 .39731 L\ns\n.02381 .42674 m\n.02756 .42674 L\ns\n.02381 .4856 m\n.02756 .4856 L\ns\n.02381 .51503 m\n.02756 .51503 L\ns\n.02381 .54446 m\n.02756 .54446 L\ns\n.02381 .57389 m\n.02756 .57389 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .30902 m\n.02571 .31272 L\n.02762 .31641 L\n.02952 .32011 L\n.03143 .3238 L\n.03333 .3275 L\n.03524 .33119 L\n.03714 .33487 L\n.03905 .33855 L\n.04095 .34223 L\n.04286 .3459 L\n.04476 .34957 L\n.04667 .35323 L\n.04857 .35688 L\n.05048 .36053 L\n.05238 .36416 L\n.05429 .36779 L\n.05619 .37141 L\n.0581 .37502 L\n.06 .37862 L\n.0619 .38221 L\n.06381 .38578 L\n.06571 .38935 L\n.06762 .3929 L\n.06952 .39644 L\n.07143 .39996 L\n.07333 .40347 L\n.07524 .40697 L\n.07714 .41045 L\n.07905 .41391 L\n.08095 .41736 L\n.08286 .42079 L\n.08476 .4242 L\n.08667 .42759 L\n.08857 .43097 L\n.09048 .43432 L\n.09238 .43766 L\n.09429 .44098 L\n.09619 .44427 L\n.0981 .44755 L\n.1 .4508 L\n.1019 .45403 L\n.10381 .45723 L\n.10571 .46042 L\n.10762 .46358 L\n.10952 .46671 L\n.11143 .46982 L\n.11333 .47291 L\n.11524 .47597 L\n.11714 .479 L\nMistroke\n.11905 .482 L\n.12095 .48498 L\n.12286 .48793 L\n.12476 .49085 L\n.12667 .49375 L\n.12857 .49661 L\n.13048 .49945 L\n.13238 .50225 L\n.13429 .50503 L\n.13619 .50777 L\n.1381 .51048 L\n.14 .51316 L\n.1419 .51581 L\n.14381 .51842 L\n.14571 .52101 L\n.14762 .52355 L\n.14952 .52607 L\n.15143 .52855 L\n.15333 .53099 L\n.15524 .53341 L\n.15714 .53578 L\n.15905 .53812 L\n.16095 .54042 L\n.16286 .54269 L\n.16476 .54492 L\n.16667 .54711 L\n.16857 .54927 L\n.17048 .55138 L\n.17238 .55346 L\n.17429 .5555 L\n.17619 .5575 L\n.1781 .55947 L\n.18 .56139 L\n.1819 .56327 L\n.18381 .56511 L\n.18571 .56692 L\n.18762 .56868 L\n.18952 .5704 L\n.19143 .57208 L\n.19333 .57371 L\n.19524 .57531 L\n.19714 .57686 L\n.19905 .57837 L\n.20095 .57984 L\n.20286 .58127 L\n.20476 .58265 L\n.20667 .58399 L\n.20857 .58529 L\n.21048 .58654 L\n.21238 .58775 L\nMistroke\n.21429 .58891 L\n.21619 .59004 L\n.2181 .59111 L\n.22 .59214 L\n.2219 .59313 L\n.22381 .59407 L\n.22571 .59497 L\n.22762 .59582 L\n.22952 .59663 L\n.23143 .59739 L\n.23333 .59811 L\n.23524 .59878 L\n.23714 .5994 L\n.23905 .59998 L\n.24095 .60051 L\n.24286 .601 L\n.24476 .60144 L\n.24667 .60183 L\n.24857 .60218 L\n.25048 .60248 L\n.25238 .60274 L\n.25429 .60295 L\n.25619 .60311 L\n.2581 .60323 L\n.26 .6033 L\n.2619 .60332 L\n.26381 .6033 L\n.26571 .60323 L\n.26762 .60311 L\n.26952 .60295 L\n.27143 .60274 L\n.27333 .60248 L\n.27524 .60218 L\n.27714 .60183 L\n.27905 .60144 L\n.28095 .601 L\n.28286 .60051 L\n.28476 .59998 L\n.28667 .5994 L\n.28857 .59878 L\n.29048 .59811 L\n.29238 .59739 L\n.29429 .59663 L\n.29619 .59582 L\n.2981 .59497 L\n.3 .59407 L\n.3019 .59313 L\n.30381 .59214 L\n.30571 .59111 L\n.30762 .59004 L\nMistroke\n.30952 .58891 L\n.31143 .58775 L\n.31333 .58654 L\n.31524 .58529 L\n.31714 .58399 L\n.31905 .58265 L\n.32095 .58127 L\n.32286 .57984 L\n.32476 .57837 L\n.32667 .57686 L\n.32857 .57531 L\n.33048 .57371 L\n.33238 .57208 L\n.33429 .5704 L\n.33619 .56868 L\n.3381 .56692 L\n.34 .56511 L\n.3419 .56327 L\n.34381 .56139 L\n.34571 .55947 L\n.34762 .5575 L\n.34952 .5555 L\n.35143 .55346 L\n.35333 .55138 L\n.35524 .54927 L\n.35714 .54711 L\n.35905 .54492 L\n.36095 .54269 L\n.36286 .54042 L\n.36476 .53812 L\n.36667 .53578 L\n.36857 .53341 L\n.37048 .53099 L\n.37238 .52855 L\n.37429 .52607 L\n.37619 .52355 L\n.3781 .52101 L\n.38 .51842 L\n.3819 .51581 L\n.38381 .51316 L\n.38571 .51048 L\n.38762 .50777 L\n.38952 .50503 L\n.39143 .50225 L\n.39333 .49945 L\n.39524 .49661 L\n.39714 .49375 L\n.39905 .49085 L\n.40095 .48793 L\n.40286 .48498 L\nMistroke\n.40476 .482 L\n.40667 .479 L\n.40857 .47597 L\n.41048 .47291 L\n.41238 .46982 L\n.41429 .46671 L\n.41619 .46358 L\n.4181 .46042 L\n.42 .45723 L\n.4219 .45403 L\n.42381 .4508 L\n.42571 .44755 L\n.42762 .44427 L\n.42952 .44098 L\n.43143 .43766 L\n.43333 .43432 L\n.43524 .43097 L\n.43714 .42759 L\n.43905 .4242 L\n.44095 .42079 L\n.44286 .41736 L\n.44476 .41391 L\n.44667 .41045 L\n.44857 .40697 L\n.45048 .40347 L\n.45238 .39996 L\n.45429 .39644 L\n.45619 .3929 L\n.4581 .38935 L\n.46 .38578 L\n.4619 .38221 L\n.46381 .37862 L\n.46571 .37502 L\n.46762 .37141 L\n.46952 .36779 L\n.47143 .36416 L\n.47333 .36053 L\n.47524 .35688 L\n.47714 .35323 L\n.47905 .34957 L\n.48095 .3459 L\n.48286 .34223 L\n.48476 .33855 L\n.48667 .33487 L\n.48857 .33119 L\n.49048 .3275 L\n.49238 .3238 L\n.49429 .32011 L\n.49619 .31641 L\n.4981 .31272 L\nMistroke\n.5 .30902 L\n.5019 .30532 L\n.50381 .30162 L\n.50571 .29792 L\n.50762 .29423 L\n.50952 .29054 L\n.51143 .28685 L\n.51333 .28316 L\n.51524 .27948 L\n.51714 .2758 L\n.51905 .27213 L\n.52095 .26847 L\n.52286 .26481 L\n.52476 .26115 L\n.52667 .25751 L\n.52857 .25387 L\n.53048 .25024 L\n.53238 .24662 L\n.53429 .24301 L\n.53619 .23941 L\n.5381 .23583 L\n.54 .23225 L\n.5419 .22869 L\n.54381 .22514 L\n.54571 .2216 L\n.54762 .21807 L\n.54952 .21456 L\n.55143 .21107 L\n.55333 .20759 L\n.55524 .20412 L\n.55714 .20068 L\n.55905 .19725 L\n.56095 .19383 L\n.56286 .19044 L\n.56476 .18707 L\n.56667 .18371 L\n.56857 .18037 L\n.57048 .17706 L\n.57238 .17376 L\n.57429 .17049 L\n.57619 .16724 L\n.5781 .16401 L\n.58 .1608 L\n.5819 .15762 L\n.58381 .15446 L\n.58571 .15132 L\n.58762 .14821 L\n.58952 .14513 L\n.59143 .14207 L\n.59333 .13904 L\nMistroke\n.59524 .13603 L\n.59714 .13305 L\n.59905 .1301 L\n.60095 .12718 L\n.60286 .12429 L\n.60476 .12142 L\n.60667 .11859 L\n.60857 .11578 L\n.61048 .11301 L\n.61238 .11027 L\n.61429 .10755 L\n.61619 .10487 L\n.6181 .10223 L\n.62 .09961 L\n.6219 .09703 L\n.62381 .09448 L\n.62571 .09197 L\n.62762 .08949 L\n.62952 .08704 L\n.63143 .08463 L\n.63333 .08225 L\n.63524 .07991 L\n.63714 .07761 L\n.63905 .07534 L\n.64095 .07311 L\n.64286 .07092 L\n.64476 .06877 L\n.64667 .06665 L\n.64857 .06457 L\n.65048 .06253 L\n.65238 .06053 L\n.65429 .05857 L\n.65619 .05665 L\n.6581 .05476 L\n.66 .05292 L\n.6619 .05112 L\n.66381 .04936 L\n.66571 .04764 L\n.66762 .04596 L\n.66952 .04432 L\n.67143 .04272 L\n.67333 .04117 L\n.67524 .03966 L\n.67714 .03819 L\n.67905 .03677 L\n.68095 .03538 L\n.68286 .03404 L\n.68476 .03275 L\n.68667 .03149 L\n.68857 .03028 L\nMistroke\n.69048 .02912 L\n.69238 .028 L\n.69429 .02692 L\n.69619 .02589 L\n.6981 .0249 L\n.7 .02396 L\n.7019 .02306 L\n.70381 .02221 L\n.70571 .02141 L\n.70762 .02064 L\n.70952 .01993 L\n.71143 .01926 L\n.71333 .01863 L\n.71524 .01805 L\n.71714 .01752 L\n.71905 .01704 L\n.72095 .0166 L\n.72286 .0162 L\n.72476 .01585 L\n.72667 .01555 L\n.72857 .0153 L\n.73048 .01509 L\n.73238 .01492 L\n.73429 .01481 L\n.73619 .01474 L\n.7381 .01472 L\n.74 .01474 L\n.7419 .01481 L\n.74381 .01492 L\n.74571 .01509 L\n.74762 .0153 L\n.74952 .01555 L\n.75143 .01585 L\n.75333 .0162 L\n.75524 .0166 L\n.75714 .01704 L\n.75905 .01752 L\n.76095 .01805 L\n.76286 .01863 L\n.76476 .01926 L\n.76667 .01993 L\n.76857 .02064 L\n.77048 .02141 L\n.77238 .02221 L\n.77429 .02306 L\n.77619 .02396 L\n.7781 .0249 L\n.78 .02589 L\n.7819 .02692 L\n.78381 .028 L\nMistroke\n.78571 .02912 L\n.78762 .03028 L\n.78952 .03149 L\n.79143 .03275 L\n.79333 .03404 L\n.79524 .03538 L\n.79714 .03677 L\n.79905 .03819 L\n.80095 .03966 L\n.80286 .04117 L\n.80476 .04272 L\n.80667 .04432 L\n.80857 .04596 L\n.81048 .04764 L\n.81238 .04936 L\n.81429 .05112 L\n.81619 .05292 L\n.8181 .05476 L\n.82 .05665 L\n.8219 .05857 L\n.82381 .06053 L\n.82571 .06253 L\n.82762 .06457 L\n.82952 .06665 L\n.83143 .06877 L\n.83333 .07092 L\n.83524 .07311 L\n.83714 .07534 L\n.83905 .07761 L\n.84095 .07991 L\n.84286 .08225 L\n.84476 .08463 L\n.84667 .08704 L\n.84857 .08949 L\n.85048 .09197 L\n.85238 .09448 L\n.85429 .09703 L\n.85619 .09961 L\n.8581 .10223 L\n.86 .10487 L\n.8619 .10755 L\n.86381 .11027 L\n.86571 .11301 L\n.86762 .11578 L\n.86952 .11859 L\n.87143 .12142 L\n.87333 .12429 L\n.87524 .12718 L\n.87714 .1301 L\n.87905 .13305 L\nMistroke\n.88095 .13603 L\n.88286 .13904 L\n.88476 .14207 L\n.88667 .14513 L\n.88857 .14821 L\n.89048 .15132 L\n.89238 .15446 L\n.89429 .15762 L\n.89619 .1608 L\n.8981 .16401 L\n.9 .16724 L\n.9019 .17049 L\n.90381 .17376 L\n.90571 .17706 L\n.90762 .18037 L\n.90952 .18371 L\n.91143 .18707 L\n.91333 .19044 L\n.91524 .19383 L\n.91714 .19725 L\n.91905 .20068 L\n.92095 .20412 L\n.92286 .20759 L\n.92476 .21107 L\n.92667 .21456 L\n.92857 .21807 L\n.93048 .2216 L\n.93238 .22514 L\n.93429 .22869 L\n.93619 .23225 L\n.9381 .23583 L\n.94 .23941 L\n.9419 .24301 L\n.94381 .24662 L\n.94571 .25024 L\n.94762 .25387 L\n.94952 .25751 L\n.95143 .26115 L\n.95333 .26481 L\n.95524 .26847 L\n.95714 .27213 L\n.95905 .2758 L\n.96095 .27948 L\n.96286 .28316 L\n.96476 .28685 L\n.96667 .29054 L\n.96857 .29423 L\n.97048 .29792 L\n.97238 .30162 L\n.97429 .30532 L\nMistroke\n.97619 .30902 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(R1) show\n81.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n87.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(v) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n93.000 12.813 moveto\n(L) show\n99.000 12.813 moveto\n(@) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@006P3IfMT500000080fMWI\n00<000000=WIf@3IfMT0o03IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WI\nf@3l0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@<00000Y03IfMT50000oe<0fMWI000D0=WI\nf@@00000103IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0:00fMWI10000?l50=WI\nf@@0003oC`3IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@2M0=WIf@<0\n003o3@3IfMT20000odd0fMWI000K0=WIf@800000103IfMT00`000000fMWI0=WIf@2K0=WIf@<0003o\n4@3IfMT30000odX0fMWI000Q0=WIf@030000003IfMT0fMWI09X0fMWI0P000?lE0=WIf@80003oB@3I\nfMT00240fMWI00<000000=WIf@3IfMT0V03IfMT20000oaP0fMWI0P000?m80=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2G0=WIf@80003o6`3IfMT20000odH0fMWI000Q0=WIf@800000U`3IfMT20000oad0\nfMWI0P000?m50=WIf@008@3IfMT00`000000fMWI0=WIf@2E0=WIf@030000o`3IfMT0fMWI01h0fMWI\n0P000?m40=WIf@008@3IfMT00`000000fMWI0=WIf@2C0=WIf@80003o8P3IfMT20000od<0fMWI000Q\n0=WIf@030000003IfMT0fMWI09<0fMWI00<0003o0=WIf@3IfMT08`3IfMT00`000?l0fMWI0=WIf@10\n0=WIf@008@3IfMT00`000000fMWI0=WIf@2B0=WIf@030000o`3IfMT0fMWI02D0fMWI00<0003o0=WI\nf@3IfMT0?`3IfMT00240fMWI00<000000=WIf@3IfMT0T@3IfMT00`000?l0fMWI0=WIf@0V0=WIf@80\n003o@03IfMT00240fMWI00<000000=WIf@3IfMT0T03IfMT00`000?l0fMWI0=WIf@0X0=WIf@80003o\n?`3IfMT00240fMWI0P00002@0=WIf@030000o`3IfMT0fMWI02X0fMWI0P000?ln0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@2>0=WIf@030000o`3IfMT0fMWI02`0fMWI0P000?lm0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@2=0=WIf@80003o;`3IfMT20000oc`0fMWI000Q0=WIf@030000003IfMT0fMWI08`0\nfMWI0P000?la0=WIf@030000o`3IfMT0fMWI03X0fMWI000Q0=WIf@030000003IfMT0fMWI08`0fMWI\n00<0003o0=WIf@3IfMT0<@3IfMT00`000?l0fMWI0=WIf@0i0=WIf@008@3IfMT00`000000fMWI0=WI\nf@2;0=WIf@030000o`3IfMT0fMWI0380fMWI0P000?lj0=WIf@008@3IfMT00`000000fMWI0=WIf@2:\n0=WIf@030000o`3IfMT0fMWI03@0fMWI0P000?li0=WIf@008@3IfMT2000008/0fMWI00<0003o0=WI\nf@3IfMT0=@3IfMT00`000?l0fMWI0=WIf@0g0=WIf@008@3IfMT00`000000fMWI0=WIf@290=WIf@03\n0000o`3IfMT0fMWI03L0fMWI00<0003o0=WIf@3IfMT0=P3IfMT00240fMWI00<000000=WIf@3IfMT0\nR03IfMT00`000?l0fMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI03H0fMWI000Q0=WIf@030000003I\nfMT0fMWI08L0fMWI0P000?lk0=WIf@030000o`3IfMT0fMWI03D0fMWI000Q0=WIf@030000003IfMT0\nfMWI08H0fMWI0P000?lm0=WIf@030000o`3IfMT0fMWI03@0fMWI000Q0=WIf@030000003IfMT0fMWI\n08H0fMWI00<0003o0=WIf@3IfMT0?@3IfMT00`000?l0fMWI0=WIf@0c0=WIf@008@3IfMT00`000000\nfMWI0=WIf@250=WIf@030000o`3IfMT0fMWI03h0fMWI00<0003o0=WIf@3IfMT0<`3IfMT00240fMWI\n0P0000260=WIf@030000o`3IfMT0fMWI03l0fMWI00<0003o0=WIf@3IfMT0<P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0Q03IfMT00`000?l0fMWI0=WIf@100=WIf@030000o`3IfMT0fMWI0380fMWI000Q\n0=WIf@030000003IfMT0fMWI08<0fMWI0P000?m30=WIf@030000o`3IfMT0fMWI0340fMWI000Q0=WI\nf@030000003IfMT0fMWI08<0fMWI00<0003o0=WIf@3IfMT0@`3IfMT00`000?l0fMWI0=WIf@0`0=WI\nf@008@3IfMT00`000000fMWI0=WIf@220=WIf@030000o`3IfMT0fMWI04@0fMWI00<0003o0=WIf@3I\nfMT0<03IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0\nP@3IfMT20000odL0fMWI00<0003o0=WIf@3IfMT0;`3IfMT000h0fMWI00@000000=WIf@3IfMT00000\n203IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI0840fMWI00<0003o0=WIf@3I\nfMT0A`3IfMT00`000?l0fMWI0=WIf@0^0=WIf@003P3IfMT010000000fMWI0=WIf@00000;0=WIf@04\n0000003IfMT0fMWI0=WIf@<00000P@3IfMT00`000?l0fMWI0=WIf@170=WIf@030000o`3IfMT0fMWI\n02h0fMWI00080=WIf@@000000P3IfMT010000000fMWI0=WIf@0000090=WIf@800000103IfMT00`00\n0000fMWI0=WIf@200=WIf@030000o`3IfMT0fMWI04T0fMWI00<0003o0=WIf@3IfMT0;@3IfMT000h0\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI\n07l0fMWI00<0003o0=WIf@3IfMT0BP3IfMT00`000?l0fMWI0=WIf@0]0=WIf@003`3IfMT2000000X0\nfMWI0`0000030=WIf@030000003IfMT0fMWI07l0fMWI00<0003o0=WIf@3IfMT0B`3IfMT00`000?l0\nfMWI0=WIf@0/0=WIf@008@3IfMT00`000000fMWI0=WIf@1n0=WIf@030000o`3IfMT0fMWI04`0fMWI\n0P000?l]0=WIf@008@3IfMT00`000000fMWI0=WIf@1m0=WIf@030000o`3IfMT0fMWI04h0fMWI00<0\n003o0=WIf@3IfMT0:`3IfMT00240fMWI00<000000=WIf@3IfMT0O@3IfMT00`000?l0fMWI0=WIf@1?\n0=WIf@030000o`3IfMT0fMWI02X0fMWI000Q0=WIf@800000OP3IfMT00`000?l0fMWI0=WIf@1?0=WI\nf@030000o`3IfMT0fMWI02X0fMWI000Q0=WIf@030000003IfMT0fMWI07`0fMWI00<0003o0=WIf@3I\nfMT0D@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000fMWI0=WIf@1k0=WIf@030000\no`3IfMT0fMWI0580fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI00<000000=WIf@3IfMT0N`3I\nfMT00`000?l0fMWI0=WIf@1C0=WIf@030000o`3IfMT0fMWI02P0fMWI000Q0=WIf@030000003IfMT0\nfMWI07X0fMWI00<0003o0=WIf@3IfMT0E03IfMT00`000?l0fMWI0=WIf@0X0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@1i0=WIf@80003oE`3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3IfMT00`000000\nfMWI0=WIf@1i0=WIf@030000o`3IfMT0fMWI05L0fMWI00<0003o0=WIf@3IfMT09P3IfMT00240fMWI\n0P00001i0=WIf@030000o`3IfMT0fMWI05P0fMWI00<0003o0=WIf@3IfMT09P3IfMT00240fMWI00<0\n00000=WIf@3IfMT0N03IfMT00`000?l0fMWI0=WIf@1I0=WIf@030000o`3IfMT0fMWI02D0fMWI000Q\n0=WIf@030000003IfMT0fMWI07P0fMWI00<0003o0=WIf@3IfMT0F@3IfMT00`000?l0fMWI0=WIf@0U\n0=WIf@008@3IfMT00`000000fMWI0=WIf@1g0=WIf@030000o`3IfMT0fMWI05/0fMWI00<0003o0=WI\nf@3IfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0MP3IfMT00`000?l0fMWI0=WIf@1L0=WIf@03\n0000o`3IfMT0fMWI02@0fMWI000Q0=WIf@030000003IfMT0fMWI07H0fMWI00<0003o0=WIf@3IfMT0\nG@3IfMT00`000?l0fMWI0=WIf@0S0=WIf@008@3IfMT00`000000fMWI0=WIf@1e0=WIf@030000o`3I\nfMT0fMWI05h0fMWI00<0003o0=WIf@3IfMT08`3IfMT00240fMWI0P00001f0=WIf@030000o`3IfMT0\nfMWI05l0fMWI00<0003o0=WIf@3IfMT08P3IfMT00240fMWI00<000000=WIf@3IfMT0M03IfMT00`00\n0?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003IfMT0fMWI07@0\nfMWI00<0003o0=WIf@3IfMT0H@3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@008@3IfMT00`000000fMWI\n0=WIf@0S0=WIf@800000103IfMT2000000<0fMWI1000000N0=WIf@800000103IfMT2000000D0fMWI\n0`00000C0=WIf@030000o`3IfMT0fMWI00L0fMWI0P0000040=WIf@8000000`3IfMT3000001l0fMWI\n0P0000040=WIf@800000103IfMT200000240fMWI00<0003o0=WIf@3IfMT01@00000K0=WIf@008@3I\nfMT00`000000fMWI0=WIf@0R0=WIf@040000003IfMT0fMWI000000P0fMWI00<000000=WIf@3IfMT0\n7P3IfMT010000000fMWI0=WIf@00000;0=WIf@030000003IfMT0fMWI0180fMWI00<0003o0=WIf@3I\nfMT01P3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000001d0fMWI00@00000\n0=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000P0=WIf@030000o`3IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT08P3IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0fMWI01d0fMWI00@000000=WIf@3IfMT00000203IfMT500000180\nfMWI00<0003o0=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI\n000001d0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@00000P0=WIf@030000\no`3IfMT0fMWI0080fMWI00<000000=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT08P3I\nfMT010000000fMWI0=WIf@00000:0=WIf@030000003IfMT0fMWI01`0fMWI00@000000=WIf@3IfMT0\n0000203IfMT010000000fMWI0=WIf@00000C0=WIf@030000o`3IfMT0fMWI00L0fMWI00@000000=WI\nf@3IfMT00000203IfMT3000001h0fMWI00@000000=WIf@3IfMT000002@3IfMT200000280fMWI00D0\n003o0=WIf@3IfMT0fMWI0000000M0=WIf@008@3IfMT2000002<0fMWI00@000000=WIf@3IfMT00000\n203IfMT010000000fMWI0=WIf@00000M0=WIf@040000003IfMT0fMWI000000T0fMWI00<000000=WI\nf@0000004P3IfMT00`000?l0fMWI0=WIf@080=WIf@040000003IfMT0fMWI000000T0fMWI00<00000\n0=WIf@3IfMT07@3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI00000240fMWI\n00D0003o0=WIf@3IfMT0fMWI0000000M0=WIf@008@3IfMT00`000000fMWI0=WIf@0S0=WIf@800000\n2P3IfMT2000001l0fMWI0P00000;0=WIf@8000004@3IfMT20000o`/0fMWI0P00000:0=WIf@<00000\n7P3IfMT2000000X0fMWI0P00000S0=WIf@040000o`3IfMT00000000001d0fMWI000Q0=WIf@030000\n003IfMT0fMWI0700fMWI00<0003o0=WIf@3IfMT0J@3IfMT00`000?l0fMWI0=WIf@0M0=WIf@008@3I\nfMT00`000000fMWI0=WIf@1_0=WIf@030000o`3IfMT0fMWI06X0fMWI00<0003o0=WIf@3IfMT07@3I\nfMT00240fMWI00<000000=WIf@3IfMT0K`3IfMT00`000?l0fMWI0=WIf@1[0=WIf@030000o`3IfMT0\nfMWI01`0fMWI000Q0=WIf@030000003IfMT0fMWI06l0fMWI00<0003o0=WIf@3IfMT0J`3IfMT00`00\n0?l0fMWI0=WIf@0=0=WIf@8000003@3IfMT00240fMWI00<000000=WIf@3IfMT0KP3IfMT00`000?l0\nfMWI0=WIf@1/0=WIf@030000o`3IfMT0fMWI00`0fMWI00@000000=WIf@3IfMT00000303IfMT001`0\nfMWI1@0000000`000?l000000000001^000000030000o`000000000006d0000000<0003o00000000\n0000100000070=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@03000000000?l0fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<0003o0000003IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT02@3IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00P0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI00T0fMWI\n00<000000=WIf@3IfMT0203IfMT00`000000fMWI0=WIf@0:0=WIf@D00000303IfMT00240fMWI00<0\n00000=WIf@000?l0K03IfMT00`000?l0fMWI0=WIf@1m0=WIf@030000003IfMT0fMWI00d0fMWI000Q\n0=WIf@030000003IfMT0003o06`0fMWI00<0003o0=WIf@3IfMT0S@3IfMT00240fMWI00@000000=WI\nf@3IfMT0003oJP3IfMT00`000?l0fMWI0=WIf@2>0=WIf@008@3IfMT010000000fMWI0=WIf@000?mZ\n0=WIf@030000o`3IfMT0fMWI08h0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0J@3IfMT0\n0`000?l0fMWI0=WIf@2>0=WIf@008@3IfMT200000080fMWI00<0003o0=WIf@3IfMT0IP3IfMT00`00\n0?l0fMWI0=WIf@2?0=WIf@008@3IfMT010000000fMWI0=WIf@3IfMT20000ofH0fMWI0P000?nA0=WI\nf@008@3IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI06@0fMWI00<0003o0=WIf@3I\nfMT0T03IfMT00240fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@1R0=WIf@030000\no`3IfMT0fMWI0940fMWI000Q0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0HP3I\nfMT00`000?l0fMWI0=WIf@2A0=WIf@008@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0600fMWI00<0003o0=WIf@3IfMT0TP3IfMT00240fMWI00<000000=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@1P0=WIf@030000o`3IfMT0fMWI0980fMWI000Q0=WIf@8000001P3IfMT00`000?l0\nfMWI0=WIf@1N0=WIf@80003oU03IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI\n0=WIf@1M0=WIf@030000o`3IfMT0fMWI09<0fMWI000Q0=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT0G03IfMT00`000?l0fMWI0=WIf@2D0=WIf@008@3IfMT00`000000fMWI0=WIf@06\n0=WIf@030000o`3IfMT0fMWI05`0fMWI00<0003o0=WIf@3IfMT0U03IfMT00240fMWI00<000000=WI\nf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@1J0=WIf@030000o`3IfMT0fMWI09D0fMWI000Q0=WIf@03\n0000003IfMT0fMWI00L0fMWI0P000?mJ0=WIf@80003oU`3IfMT00240fMWI00<000000=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@1H0=WIf@030000o`3IfMT0fMWI09H0fMWI000Q0=WIf@8000002P3I\nfMT00`000?l0fMWI0=WIf@1F0=WIf@030000o`3IfMT0fMWI09L0fMWI000Q0=WIf@030000003IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT0EP3IfMT00`000?l0fMWI0=WIf@2G0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI05D0fMWI00<0003o0=WIf@3IfMT0U`3IfMT00240\nfMWI00<000000=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@1D0=WIf@030000o`3IfMT0fMWI09P0\nfMWI000Q0=WIf@030000003IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0DP3IfMT00`000?l0fMWI\n0=WIf@2I0=WIf@008@3IfMT00`000000fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI0580fMWI00<0\n003o0=WIf@3IfMT0V@3IfMT00240fMWI0P00000=0=WIf@030000o`3IfMT0fMWI0500fMWI00<0003o\n0=WIf@3IfMT0VP3IfMT00240fMWI00<000000=WIf@3IfMT0303IfMT20000oe00fMWI0P000?nL0=WI\nf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI04h0fMWI00<0003o0=WIf@3I\nfMT0V`3IfMT00240fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@1=0=WIf@030000\no`3IfMT0fMWI09/0fMWI000Q0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0C03I\nfMT00`000?l0fMWI0=WIf@2L0=WIf@003`3IfMT2000000@0fMWI0P0000040=WIf@800000103IfMT0\n0`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI04X0fMWI0P000?nN0=WIf@003P3IfMT01000\n0000fMWI0=WIf@0000080=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@1:0=WIf@030000o`3IfMT0fMWI09d0fMWI000>0=WIf@040000003IfMT0\nfMWI000000/0fMWI00@000000=WIf@3IfMT0fMWI0`00000@0=WIf@030000o`3IfMT0fMWI04P0fMWI\n00<0003o0=WIf@3IfMT0WP3IfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT2000000@0fMWI\n00<000000=WIf@3IfMT0403IfMT20000odP0fMWI0P000?nP0=WIf@003P3IfMT010000000fMWI0=WI\nf@0000090=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT04@3IfMT00`000?l0fMWI\n0=WIf@160=WIf@030000o`3IfMT0fMWI09l0fMWI000?0=WIf@8000002P3IfMT3000000<0fMWI00<0\n00000=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@140=WIf@030000o`3IfMT0fMWI0:00fMWI000Q\n0=WIf@030000003IfMT0fMWI0180fMWI0P000?m50=WIf@030000o`3IfMT0fMWI0:00fMWI000Q0=WI\nf@030000003IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0@P3IfMT00`000?l0fMWI0=WIf@2Q0=WI\nf@008@3IfMT00`000000fMWI0=WIf@0C0=WIf@80003o@P3IfMT20000oj<0fMWI000Q0=WIf@800000\n5@3IfMT00`000?l0fMWI0=WIf@100=WIf@030000o`3IfMT0fMWI0:80fMWI000Q0=WIf@030000003I\nfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT0?P3IfMT00`000?l0fMWI0=WIf@2S0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@0E0=WIf@80003o?P3IfMT20000ojD0fMWI000Q0=WIf@030000003IfMT0fMWI\n01H0fMWI00<0003o0=WIf@3IfMT0?03IfMT00`000?l0fMWI0=WIf@2T0=WIf@008@3IfMT00`000000\nfMWI0=WIf@0G0=WIf@030000o`3IfMT0fMWI03X0fMWI0P000?nV0=WIf@008@3IfMT00`000000fMWI\n0=WIf@0G0=WIf@030000o`3IfMT0fMWI03X0fMWI00<0003o0=WIf@3IfMT0Y@3IfMT00240fMWI00<0\n00000=WIf@3IfMT0603IfMT00`000?l0fMWI0=WIf@0h0=WIf@030000o`3IfMT0fMWI0:H0fMWI000Q\n0=WIf@8000006P3IfMT00`000?l0fMWI0=WIf@0f0=WIf@030000o`3IfMT0fMWI0:L0fMWI000Q0=WI\nf@030000003IfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT0=03IfMT00`000?l0fMWI0=WIf@2X0=WI\nf@008@3IfMT00`000000fMWI0=WIf@0J0=WIf@80003o=@3IfMT00`000?l0fMWI0=WIf@2X0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0K0=WIf@80003o<`3IfMT00`000?l0fMWI0=WIf@2Y0=WIf@008@3I\nfMT00`000000fMWI0=WIf@0L0=WIf@030000o`3IfMT0fMWI0300fMWI00<0003o0=WIf@3IfMT0ZP3I\nfMT00240fMWI00<000000=WIf@3IfMT0703IfMT20000oc00fMWI0P000?n/0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0M0=WIf@80003o;P3IfMT20000ojd0fMWI000Q0=WIf@8000007`3IfMT20000ob`0\nfMWI0P000?n^0=WIf@008@3IfMT00`000000fMWI0=WIf@0O0=WIf@80003o:`3IfMT00`000?l0fMWI\n0=WIf@2]0=WIf@008@3IfMT00`000000fMWI0=WIf@0P0=WIf@030000o`3IfMT0fMWI02P0fMWI00<0\n003o0=WIf@3IfMT0[P3IfMT00240fMWI00<000000=WIf@3IfMT08@3IfMT00`000?l0fMWI0=WIf@0V\n0=WIf@030000o`3IfMT0fMWI0:l0fMWI000Q0=WIf@030000003IfMT0fMWI0280fMWI00<0003o0=WI\nf@3IfMT0903IfMT00`000?l0fMWI0=WIf@2`0=WIf@008@3IfMT00`000000fMWI0=WIf@0S0=WIf@03\n0000o`3IfMT0fMWI0280fMWI00<0003o0=WIf@3IfMT0/@3IfMT00240fMWI00<000000=WIf@3IfMT0\n903IfMT20000ob40fMWI0P000?nc0=WIf@008@3IfMT2000002H0fMWI0P000?lN0=WIf@80003o]@3I\nfMT00240fMWI00<000000=WIf@3IfMT09P3IfMT20000oa`0fMWI0P000?nf0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0W0=WIf@80003o6P3IfMT20000okL0fMWI000Q0=WIf@030000003IfMT0fMWI02T0\nfMWI0P000?lF0=WIf@<0003o^03IfMT00240fMWI00<000000=WIf@3IfMT0:P3IfMT30000oa80fMWI\n0`000?nj0=WIf@006P3IfMT500000080fMWI00<000000=WIf@3IfMT0;03IfMT20000oa00fMWI0P00\n0?nl0=WIf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI02h0fMWI10000?l9\n0=WIf@<0003o_P3IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT300000340fMWI2P000?o10=WI\nf@00703IfMT00`000000fMWI0=WIf@020=WIf@030000003IfMT0fMWI0?`0fMWI000L0=WIf@030000\n003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT0o03IfMT001/0fMWI0P0000040=WIf@030000003I\nfMT0fMWI0?`0fMWI000Q0=WIf@030000003IfMT0fMWI0?`0fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40\nfMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI000U0=WIf@030000003IfMT0fMWI\n01P0fMWI00<000000=WIf@3IfMT01@3IfMT2000000P0fMWI0P00003<0=WIf@00903IfMT00`000000\nfMWI0=WIf@0J0=WIf@030000003IfMT0fMWI00@0fMWI00<000000=WIf@3IfMT0203IfMT00`000000\nfMWI0=WIf@3:0=WIf@008`3IfMT010000000fMWI0=WIf@3IfMT300000080fMWI00<000000=WIf@00\n0000100000020=WIf@800000103IfMT2000000D0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000\nfMWI0=WIf@020=WIf@800000103IfMT00`000000fMWI0=WIf@3:0=WIf@008`3IfMT00`000000fMWI\n0=WIf@020=WIf@040000003IfMT0fMWI000000@0fMWI00<000000=WIf@3IfMT0203IfMT2000000D0\nfMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00D000000=WI\nf@3IfMT0fMWI0000003<0=WIf@005P3IfMT80000o`D0fMWI00<000000=WIf@3IfMT00P3IfMT30000\n00D0fMWI00<000000=WIf@3IfMT01`3IfMT010000000fMWI0=WIf@0000040=WIf@030000003IfMT0\nfMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000060=WIf@030000003IfMT0fMWI0<X0fMWI000S\n0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT00000103IfMT00`000000fMWI0=WI\nf@060=WIf@8000000P3IfMT2000000<0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WI\nf@05000000<0fMWI00<000000=WIf@3IfMT0bP3IfMT002@0fMWI00D000000=WIf@3IfMT0fMWI0000\n00020=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WI\nf@040=WIf@050000003IfMT0fMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@3:0=WIf@009@3I\nfMT00`000000fMWI00000003000000@0fMWI0P00000?0=WIf@030000003IfMT0fMWI00D0fMWI0P00\n00080=WIf@800000c03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00001"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.151224`, -1.28973`, 0.00445466`, 0.0144156`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[BoxData[TagBox[RowBox[List[RowBox[List["\[SkeletonIndicator]", "Graphics"]], "\[SkeletonIndicator]"]], False, Rule[Editable, False]]], "Output"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[912, 924]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]