List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Connection Constraints regarding Arrays, Subscripts and Constants", "Title"], Cell[CellGroupData[List[Cell["Array Dimensionality Matching", "Section"], Cell["The rule that connected connectors must have equivalent type is less strict concerning arrays that are members of connectors. If matching arrays in connected connectors have the same number of elements but different dimensionality, the dimensionality of the array with the lowest number of dimensions is increased by adding one-sized dimensions to the left until both arrays have the same dimensionality.\n", "Text"], Cell["connector SOutPort\t\t\t\t\"Simplified OutPort connector\"\n  output Real signal;\nend SOutPort;", "ModelicaInput"], Cell["", "Text"], Cell["connector InPort\t\t\t\t\"InPort connector\"\n  parameter Integer n = 1;\n  input Real\tsignal[n];\nend InPort;", "ModelicaInput"], Cell[TextData[List["\nThe connectors ", StyleBox["ip", Rule[FontFamily, "Courier"]], " and ", StyleBox["op", Rule[FontFamily, "Courier"]], " do not have the same dimensionality, but the connect statement is still correct. This works since the dimensionality of ", StyleBox["op.signal", Rule[FontFamily, "Courier"]], " is increased by one to become", StyleBox[" op.signal[1]", Rule[FontFamily, "Courier"]], " before the connect statement is expanded to conventional equations. One-sized dimensions are added to the left in the list of dimensions, e.g. an ", StyleBox["array x[2,3]", Rule[FontFamily, "Courier"]], " could be converted to ", StyleBox["x[1,1,2,3]", Rule[FontFamily, "Courier"]], ".", StyleBox["\n", Rule[FontSize, 11]]]], "Text"], Cell[TextData[List["class ConnectArray\n  SOutPort\t\top;\n  InPort\t\tip;\nequation\n ", StyleBox[" connect(ip, op);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ConnectArray; "]], "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Constant Subscript Constraints", "Section"], Cell["In order to simplify the analysis of connections and making the generation of connection equations possible at compile time, the following constraint applies:\nSubscripts in a connector reference must be constant expressions. ", "Text"], Cell[TextData[List["class ConnectTest\n  Pin x[3];\n  Pin y[3];\n  Integer i = 2;\nequation\n  ", StyleBox["connect(x[2], y[2]);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Ok, constant subscripts.\n  ", StyleBox["connect(x[i], y[2]);", Rule[FontColor, RGBColor[1, 0, 0]]], "\t\t// Error, non-constant subscript.\nend ConnectTest;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[901, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]