List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Generation of Connection Equations", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["By generating connection equations we mean the conversion of connect statements to the two different forms of equations to be used for non-flow and flow variables respectively. The process of converting ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statements can be divided into two steps: Building ", StyleBox["connections sets", Rule[FontSlant, "Italic"]], " from ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statements and Generating ", StyleBox["connection equations", Rule[FontSlant, "Italic"]], " for the complete model. ", StyleBox["Connections sets are needed to generate the connection equations of a model.", Rule[FontSize, 11]]]], "Text"]], Open]], Cell[CellGroupData[List[Cell["ResistorCircuit", "Section"], Cell["A practical way to generate these sets is to first create a small connection set from each connect statement consisting of its two arguments. If any of these connector arguments are members of other connections sets, the corresponding connection sets are merged.\n", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003</0@0006`000000000000007h1001V0000\n00000000000d8`008@X00215CDH00040;3<004L100090000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0003@@000V4000AdA9@`4008000`009Z<MU@00000>4000\n0@0900031`P000X070000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P0000050000309U0U4870000?/2W?l00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4000D000020@40000500002@8000020`0001h01`0001H4I@9A2000\n000@00009PH?01H0ooooo`00oooooooooomD2000IP8000<0000N00D0000^0@00000500002P800000\n1@0000T2000000D000010_ooo`070000o0810000000000@0000]0@4020000?X21@010000000000@0\n000]0@80100000<1200700004PAU0VD2D@QC20D0000;0P0000050000309U0U<8500002H63`0N0?oo\nool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0000<0VD2D`PL0000n`8D00T000000;`2000000@2\n0R9CNG=dIFd0Md00001W1`X@_V;eMlMRmGL10000000`00@0000]0@<01@0000810@0001`0003k0Zgo\n00000000T040000014004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d110050000\n2@8000021@0000/2000000d0000b2P00ool100@0000005<8I@8PJBD01`000?`2003oool000040000\n;@4500P0003j0P001`00000000840000;@4600L0000K10l1fPHT0;<41`000?`2003oool000040000\n;@4700@0003`0@D020000?X200000000000000@0000]0@D010000?011P040000;@4100@0000]0@80\n1`0001/4g@0G1W00N`D40000;@4700@0000]0@D00`0001h01`0001H4g00G1W00N`D500000P410000\n70000?/2[Ol00000002@0@000004@00R@G9YHF`0mGM00000H0L:EKiRmGO7H_Eg0@000000<0040000\n;@4600h0000b2W80N`D200@0N`E`01H6g01B<S`0;P040000;@4400d0000b2W80i@D100@0N`E`01H6\ng00P<RH0100002L1ool70000o0800?ooo`0000@0000]0@P020000?X20007000000000P@0000]0@T0\n1`0001/43`6M0b@0KP440000;@4700@0003`0@P0100002d11@040000l04900@0000]0@40100002d1\n0P0700006`CR0<42H@150P@0000]0@L0100002d11@0300007P0700005PCQ0<02H@150PD000020@40\n00040000;@4600D000090P00008>0000<PYS04D20P0404D2H@2o0^40DS4l02h0100002d1100=0000\n<PYS0:l20@0404D2H@2o0^40834V00@0000W0Ooo1`000?`2003oool000040000;@4800P0003j0P00\n1`00000000840000;@4900L0000K1;`0S@5o0501100002d11`040000l04800@0000]0@D010000?01\n2@070000o0800<g=c@0000@0000]0@P020000?X20007000000000P@0000]0@T01`0001/4]`2k0gX0\nOP<40000;@4700@0003`0@P0100002d11@040000l04900L0003l0P00cLg=0000100002d120080000\nnP8000L000000002100002d12@0700006`Bl0<X4O`2E10@0000]0@L010000?0120040000;@4500@0\n003`0@T0400002H63`0F0?ooool00;H3002A0000VP@009/000080000nP8000L000000000100002d1\n20040000;@4100P0000U0`80^P>E09D4UP040000;@4500@0003`0@P0100002d11`0800009PH?00H0\nooooo`40400002H63`0F0?ooool00000002I0000E@400:8000080000nP8000L000000000100002d1\n20040000;@4100P0000U0`80D06M00@0W@040000;@4500@0003`0@P0100002d11`0800009PH?00H0\nooooo`401`000?`2003oool000040000;@4800P0003j0P001`00000000840000;@4900L0000K1642\ng@If0Jh4100002d11`040000l04800@0000]0@D010000?012@040000;@4100@0000]0@801`0001/4\n<`8=1[L1P0D40000;@4700@0000]0@D00`0001h01`0001H4<P8=1[L1P0D500000P410000100002d1\n1P0500002@8000023P00038:^@601@8010201KL130Hb0U8c?00^00@0000]0@@03@00038:^@7Z1@40\n10201KL130Hb0R0c9P0400009`7ooa00000V1Pl05P3ooooo000[1000c0400;h4003E0@0020000?X2\n00070000000000@0000]0@P0100002d10@0800009@<202l4d06i1=01100002d11@040000l04800@0\n000]0@L0200002H63`060?ooool10100000V1Pl05P3ooooo000[1000T@0003@4003E0@0020000?X2\n00060000000000@0000]0@P0100002d10@0800009@<202l4U@0_1=01100002d11@040000l04800@0\n000]0@L0200002H63`060?ooool100L0003l0P00cLg=0000100002d120080000nP8000L000000002\n100002d12@0700006`Cd0L/4]`6>10@0000]0@L010000?0120040000;@4500@0003`0@T0400002H6\n3`0F0?ooool00>l6002D0000A0P009d000080000nP8000L000000000100002d120040000;@4100P0\n000U0`80?`RH0?<6V0040000;@4500@0003`0@P0100002d11`0800009PH?00H0ooooo`401`000?`2\n003oool000040000;@4800P0003j0P001`00000000840000;@4900L0000K1;D0n@Ig0<<6100002d1\n1`040000l04800@0000]0@D010000?012@0@00009PH?01H0ooooo`00m0H00><100192000k04000P0\n003j0P001`00000000040000;@4800@0000]0@40200002D30P142>L1n0KW0@@0000]0@D010000?01\n20040000;@4700P0000V1Pl01P3ooooo0@070000o0800?ooo`0000@0000]0@P020000?X200070000\n00000P@0000]0@T01`0001/420;k1//1_PH40000;@4700@0003`0@P0100002d11@040000l04900L0\n003l0P00oooo0000100002d120040000;@4200@0000]0@P02@0001d68@3`07<0AP1`09`1100002d1\n20040000;@4700@0003`0@P0100002d11@0300007P0700005PCS0><1L02L0@D000020@40000L0000\nn`:eo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@P0\n1@0000T200000Pd0000b2W80W04100@0W05`0>81h`1^02H03@00038:LP320@40102L0G00hP7S0200\n8P0400009`7oo`L0003l0P00oooo0000100002d12@040000;@4200@0000]0@T02@0001d68@3`07<0\n<P1O04P3100002d12@040000;@4700@0003`0@T0100002d11@0300007P0700005PCA07X3GP170`D0\n00020@4000040000;@4800D000090P00008=0000<PYP04L30@0404L3GP1i0m40L00V00d0000b2V00\nK@<100@0A`=N07T3d@0P0280100002L1ool70000o0800?ooo`0000@0000]0@T0100002d10P040000\n;@4900T0000M1R40l01c04H0J@3M10@0000]0@T0100002d11`040000l04900@0000]0@D00`0001h0\n1`0001H4f`0S1FT0g0@500000P410000100002d1200500002@8000023@00038:J`3L1040103L16T0\n8PGK07009P0=0000<PY[00850@040=`4J@0R1M/0800R00@0000W0Ooo1`000?`2003oool000040000\n;@4900@0000]0@80100002d12@0900007@HQ0?00L`0]06H0TPH40000;@4900@0000]0@L010000?01\n2@040000;@4500<0000N00L0000F1=T0`0IV09861@0000810@0000@0000]0@P01@0000T200000Pd0\n000b2VP0TPH100@0TPIV0;l6f@1^02H03@00038:J02h1P40102B1VH0_`KI02008P0400009`7oo`L0\n003l0P00oooo0000100002d12@040000;@4200@0000]0@T02@0001d68@3`07<0=@2O0Ml4100002d1\n2@040000;@4700@0003`0@T0100002d11@0300007P0700005P@A0Q@5WP7O10D000020@4000040000\n;@4800D000090P00008=0000<PZP0Ml40@040=l4WP4C1A42L00V00d0000b2Z011@D100@0g`BN0A<5\n4@8P0280100002L1ool70000o0800?ooo`0000@0000]0@T0100002d10P040000;@4900T0000M1R40\nl01L02d0^06@1P@0000]0@T0100002d11`040000l04900@0000]0@D00`0001h01`0001H450:m1[L1\nT0H500000P410000100002d1200500002@8000023@00038:^@6@1P40102@1[L1_0HD0Vh09P0=0000\n<PZi0KH60@040906]`6l1Q@2800R00@0000W0Ooo100002d10`040000l04400@0003`0@H010000?01\n20070000o0800?ooo`0000@0000]0@@020000?X200000000000000@0000]0@H0100002L1ool80000\n9PH?00H0ooooo`40100002L1oolL0000n`8@00L000000;`2000000420R9CNG=dIFd000002P0000@0\n000000P000010000000`00@0000]0@P00`000000000A0000300000P0000;000040000841001X0000\n2@00010000210@00J00000X0000@0000000000000009000040000548001U0P00DP00070100010000\nW?ooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000\n000000000000000000000000000000000000000000000000008000004`38SaT0N04C00L4001@]_ag\n5[GlMbfeo7L00000P00005PB6@0001<0:0`C01h0003HGaL0W?<B0<27601h0A<0`8LH07P14`3ooooo\nJ?DB04064`0X31<000000000001>1b6=000000000?l0o`3o0@0000006030;aT0`0000?GHoom01Q<0\nL0aJ03Sd4P0?0000L3WhM`004`1H2A<0V0<C09P34`080000400009P34`0001<0`8LH07P14`1h0A<0\n^8LH052fo7LF]Oag;KGlM`00000000002@0005PB6@2Xm180k7LH0<;0m7L10000I7H02000000U0000\n30000040000B000030000040000H000030000000008Q0000200001h0000H000000000000001A2000\nI@800240000800005P0000`000000000N000010000000000000001P0000<0000000001T0000<0000\noooo02D0000<00001@00P2D0000<00002000P1l0000H0000D`P00548001U0P00I@8000X0000@0000\n0000000000090000400005<8001U0P002@000100001C2000I@800580001`0@000P0001@000090000\n00000000002l0P00000000@20R9C07T0L`1d06D0K@00000000000000000000000000000000000000\n00000000000000000000000000000000000C00004`30QaP0N04C07P14`2hQaP0D;KlMaJeo7L]]Oag\n0000000000090000F18I0:Sd4P3/MaP0`/3dM`40001TMP0800000<27601h0A<0ooooofSe4P101Q<0\n:0`C000000000000CPLQS@000000003o0?l0o`40000001P0`2lI0<00003ef?oo@0HC070<FP0hm180\n3`00070in7L001<0F0TC09P34`0@8_Aga?3mO`3PoGl100000000000000000000OP<00010001n0`A7\n0@0006Cd4P0U0000F18I00T0001H4QT0Z?@B02ai6032`?Ag0@0006Af00P000009@0000`000020000\n4P0000`000010000DP00070100030000[Oooo`0000000000000009010000000014004U@0J@1]06D0\nL`0P04h0I@1g0200DP1_06d0H@1^0000000000000000000000000000000000000000000000000000\n0000000000000000OP<00010001n0`A70@0006Cd4P0U0000F18I00T0001H4QT0Z?@B02ai6032`?Ag\n0@0006Af00P00000`8LH07P14`3oooooJ?DB04064`0X31<000000000001>1b6=000000000?l0o`3o\n0@0000006030;aT0`0000?GHoom01Q<0L0aJ03Sd4P0?0000L3WhM`004`1H2A<0V0<C010Rm7O4l?eo\n0>3mO`400000000000000000001n0`00040007h314L10000I?@B02D0001H4QT0R?@B0:h7001D`?Ag\n0@0001T0/06^1`XPI7H02000000U0000300000<0000H000030000000008:00004000000000000000\nE00005@000000000000000H0000?00000@000?5oQd3G^HM0ooooo`0000010000C00000@000000000\n000005<8001U0P00D000020000PU00009`0001P00004000000000?ooo`0000009@0000`000040000\n9P0001`000050000000000L00000000000000RD0000<00001@0002/0000H0000/`@002@0003D1P00\n2@4002L0000H00001P000000003oool0000002D0000<00001P0002P0000<0000100002H0000L0000\n100000000000000000000000000U0000300000@0000X0000300000D0000U0000300000D0080U0000\n300000P0080[0000600007/5001`00004PH00=L0000U0000300000H0000U0000300000@0000Q0000\n200001h0000H0000N`D00700000G1P00g0000180000<00000@000580001`0@001@000:goool00000\n00000000002@0@00000000A002910780J@1Q06`00000000000000000000000000000000000000000\n00000000000000000000000000000000000H0=3>60000000000007h30000@000OP<4A`40001Tm180\n9@0005PB6@28m180c?<B0000003U>?Qg000C042X5`000000Z?<B08P64`1Lm180UB_hM`004`040000\n0?@B042go7OX1Q<00JPG04RX5`1Xla800000033d4P000?Qg63KhMooooom0m180PW?XM`004`000000\nd<hH0;@7<7K@cQP0883gMiP34`0@8_Aga?3mO`3PoGl100000000000000000000OP<00010001n0`A9\n0@0006Cd4P3`<OAgOP<4BDh78Hen0`A9000000A90020m180T=;dMfAf00P000009@0000`000050000\nE00005P0003n00004`000141000R00000@000?5oQd3G^HM0N`D0078000020000C00000@0001k1@00\nL00001H6003L0000D0000580<P0l0000;P0002D0000<00000`0005@0001D00004@4001<0000G0@00\n8P000040003aOhM0ekV7@>D5001b00000@0004`000040000N`D00700000F1P00g0000500000P0000\n9P000280000<0000ooooobL0000H00001`000000003oool0000002D0000<00001`0002H0000L0000\n200000000007000000000000008U0000300000P0000[0000600006h1000T0000V0<000T1000U0000\n300000H0000X0000300000L0000U0000300000@0000X0000300000P0000U0000300000D0080U0000\n300000P0080[0000600004D2001Q0000^`800=`0000U0000300000H0000U0000300000@0000Q0000\n200001h0000H0000A@80064000300P00h@000180000<00000@0002D0000<00001@0001P0000<0000\n00000U@0001H0000J@000140001l000080000040003aOhM0ekV7@4D2001S00000P0004`000040000\nA@800640002o0P00h@000500001B0340?00002h0000U0000300000<0001D0000E00007`0000A0000\nOP00020000010000lGn7@=NiQd2_0P00H`000040001<0000100004D2001Q0000_`800>40001@0000\n800002H0000R000030000?oooolW0000600000P000000000oooo0000000U0000300000P0000V0000\n700000L0000000001`000000000000029@0000`000070000:`0001P0001@0@00O`0008P1002f0000\n9@0000`000060000:00000`0000800009@0000`000040000:00000`0000700009`0001P000070000\n00000<g=c@0000009@0000`0000700009P0001`000080000000000L00000000000000RD0000<0000\n200002/0000H0000OP<007X0002f0`00/@0002D0000<00001P0002P0000<00001`0002D0000<0000\n100002P0000<0000200002L0000H000020000000003=cLd0000002D0000<0000200002H0000L0000\n1`0000000007000000000000008U0000300000L0000[0000600009D4001o0000a0@00;H0000U0000\n300000H0000X0000300000P0000U0000300000@0000X0000300000L0000V0000700000L000000000\n1`000000000000009@0000`0000700009@0000`000050020E`0002@0002/00006@000=@0000I0000\n0P000;X3U@2E19H09@0000`000040000:00000`0000700009@0000`0000600009P0001`000070000\n000000L000000000000002D0000<00001`0002D0000<00001@00P5L0000T00000@0001/0000m0000\n6`000080001@0Id0102M02D0000<0000100002P0000<00001`0002D0000<00001P0002L0000H0000\n1`000000003oool0000002D0000<00001`0002H0000L0000200000000007000000000000008U0000\n300000P0000[000060000:h4001f0@00f0H005/2000U0000300000H0000X0000300000L0000U0000\n300000@0000X0000300000P0000U0000300000D0080U0000300000P0080[000060000805002g0@00\n20H002d2000U0000300000H0000U0000300000@0000Q0000200001h0000H0000P0D00;L1000=1P00\n<P800180000<00000@0002D0000<00001@0001P0000<000000000U@0001H0000oP0004/0000A0@00\nFP000040003aOhM0ekV7@805002i0@000P0004`000040000P0D00;L1000<1P00<P800500001B03<0\n?00002h0000U0000300000<0001D0000E0000181001;00005`4005X000010000lGn7@=NiQd3Z1@00\n^@400040001<000010000805002g0@0030H00382001@0000800P02H0000R000030000?oooolV0000\n700000P0000000001`000000000000009@0000`0000800009@0000`000050020E`0002@000320000\nC`000=X0001?00000P0002l4d06i1=019@0000`000040000:00000`0000800009@0000`000060000\n9P0001`000080000000000H000000000000002D0000<0000200002D0000<00001@00P5L0000T0000\n`P0001T000320000C`000080000_19D0;`C@0BD0000<0000100002P0000<0000200002D0000<0000\n1P0002L0000H000020000000003=cLd0000002D0000<0000200002H0000L00001`00000000070000\n00000000008U0000300000L0000[0000600008h4002g0@00aP@00>h1000U0000300000H0000X0000\n300000P0000U0000300000@0000X0000300000L0000V0000700000L0000000001`00000000000000\n9@0000`0000700009@0000`000050020E`0002@000110@006P0007d1000J00000P0003l8V03c1YP0\n9@0000`000040000:00000`0000700009@0000`0000600009`0001P00007000000000?ooo`000000\n9@0000`0000700009P0001`000080000000000L00000000000000RD0000<0000200002/0000H0000\n``H007L0003d1P00[`0002D0000<00001P0002P0000<00001`0002D0000<0000100002P0000<0000\n200002H0000L0000200000000007000000000000000U0000300000P0000U0000300000D0081G0000\n90000481001C0000OP4005<000020000A0SW0OP6i`4U0000300000@0000X0000300000P0000U0000\n300000H0000W0000600000P000000000oooo0000000U0000300000P0000V0000700000L000000000\n1`000000000000029@0000`000070000:`0001P0002n1P00b`400?H600020P009@0000`000060000\n:00000`0000800009@0000`000040000:00000`0000700009`0001P00007000000000?ooo`000000\n9@0000`0000700009@0000`0000800209@0000`000070000C00006@0001:00004`0005H0000V0000\nW040070000160000L`000240l000000000000000P3l0000000000000P3l000000000000000000000\n0000000000000000000002D0000<00001`0002D0000<00001P0002P0000<00001`0002D0000<0000\n10000240000800007P0001P0002L0@00L0000><1003S00004P0000`000010000DP00070100070000\n]Oooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000\n0000000000000000000000000000000000000000000001d0f?0M0000000000000000000000000040\n000004h78Hg`<OAgOP<4BDh78Hg<la8000000>Dhn7L001<008hG0000002Xla80R0HC05cd4P2E:oQg\n000C00@00000m180@;OlMaP74`01SQL00P0006Sc4P000000<?@B0000n7LH=_Qgoooood3d4P22LnQg\n000C0000003Hl1d0X`<@6mS`7@0PP?Mgf5lG010Rm7O4l?eo0>3mO`400000000000000000002E1`00\n040009D710T10000I?@B0?0am7NE1`@9CPLQSID710T0000010T0083d4P2@d_AgI7H02000000U0000\n300000L0000H000030000000009D0000E00004X0000C0000D000024000010000lGn7@=NiQd2L0@00\nLP000040001<0000100009`1001`0000hP400><0001@0000KP0002H0001D0000E0000540000C0000\nEP00024000010000lGn7@=NiQd320@00LP000040001<0000100009`1001`0000hP400><0001@0000\n800P0280000R000030000?oooolW0000600000P000000000oooo0000000U0000300000P0000U0000\n300000P0080U0000300000P0001<0000I00009P0000@0000X00002<000180`00G`000380001c0000\n8@3`0000000000000020?`00000000000020?`000000000000000000000000000000000000000000\n9@0000`0000800009@0000`000060000:00000`0000800009@0000`0000400008@0000P0000N0000\n600004L3001N0000NP<00=40000B000030000040000U0000300000L0000H000030000000009D0000\nE00009P0000@0000WP0001h000010000lGn7@=NiQd170`00H0000040001<0000100004L3001N0000\nN@<00=40001@0000L00002H0001D0000E00009h0000@0000X00001h000010000lGn7@=NiQd1]0`00\nH0000040001<0000100004L3001N0000N@<00=40001@000080000280000R000030000?oooolW0000\n600000P000000000oooo0000000U0000300000P0000U0000300000P0080U0000300000P0001<0000\nI0000>40000B0000k@0002@0003M1000J@0004H0001c00008@3`0000000000000020?`0000000000\n0020?`0000000000000000000000000000000000000000009@0000`0000800009@0000`000060000\n:00000`0000800009@0000`0000400008@0000P0000N000060000=`4001Y00008`D00=/0000B0000\n30000040000U0000300000L0000H000030000000009D0000E0000>40000B0000i`00020000010000\nlGn7@=NiQd3L1000J`000040001<000010000=`4001Y00008PD00=/0001@0000L00002H0001D0000\nE0000>P0000B0000k000020000010000lGn7@=NiQd021@00J`000040001<000010000=`4001Y0000\n8PD00=/0001@000080000280000R000030000?oooolW0000600000P000000000oooo0000000U0000\n300000P0000U0000300000P0080U0000300000P0001<0000I0000301000A0000=`4002@0002B1P00\nIP0002d0001c00008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000800009@0000`000060000:00000`0000800009@0000`000040000\n8@0000P0000N000060000986001V0000`0H00=T0000B000030000040000U0000300000L0000H0000\n30000000009D0000E0000301000B0000=P40020000010000lGn7@=NiQd2B1P00J0000040001<0000\n10000986001V0000_`H00=T0001@0000KP0002H0001D0000E00003L1000B0000=`40020000010000\nlGn7@=NiQd2h1P00J0000040001<000010000986001V0000_`H00=T0001@000080000280000R0000\n30000?oooolW0000600000P000000000oooo0000000U0000300000P0000U0000300000P0080U0000\n300000P0001<0000I0000>4000160000jP0005T0003O1000W`4003D0001c00008@3`000000000000\n0020?`00000000000020?`0000000000000000000000000000000000000000009@0000`000080000\n9@0000`000060000:00000`0000800009@0000`0000400008@0000P0000N000060000=l4002N0@00\n50D00142000B000030000040000U0000300000L0000H000030000000009D0000E0000>4000170000\ni`0005D000010000lGn7@=NiQd3O1000X0400040001<000010000=l4002N0@004`D00142001@0000\nL00002H0001D0000E0000>P000170000jP0005D000010000lGn7@=NiQd051@00X0400040001<0000\n10000=l4002N0@004`D00142001@000080000280000R000030000?oooolW0000600000P000000000\noooo0000000U0000300000P0000U0000300000P0080U0000300000P0001<0000I0000301001;0000\n=`4005T0002@1P00^04002d0001L00008@3`0000000000000020?`00000000000020?`0000000000\n000000000000000000000000000000009@0000`0000800009@0000`000060000:00000`000080000\n9@0000`0000400008@0000P0000N000060000906002g0@00_@H001@2000B000030000040000U0000\n300000L0000H000030000000009D0000E0000301001;0000=P4005T000010000lGn7@=NiQd2@1P00\n^@400040001<000010000906002g0@00_0H001@2001@0000KP0002H0001D0000E00003H1001;0000\n=`4005T000010000lGn7@=NiQd2f1P00^@400040001<000010000906002g0@00_0H001@2001@0000\n80000280000R000030000?oooolU000030000080000X0000300000<0000X0000300000D0000X0000\n300000L0000W0000600000L000000000oooo0000000U0000300000L0000V0000700000D000000000\n00000000000000009@0000`0000500008P0000`0003ooooo8P0000`0003oooooDP00070100030000\n400000L00000000000000;`2000000000@828U<0N@1c07@0I@1]0000000000000000000000000000\n0000000000000000000000000000000000000000000001d0f?0M0000000000000000000000000040\n000004h78Hg`<OAgU@L42Dh78Hg<la8000000>Dhn7L001<0@:PG0000002Xla80R0HC05cd4P2E:oQg\n000C00@00000m180@;OlMnP64`01Z1L0B:PG06Sc4P000000<?@B0000n7LH=_Qgoooood3d4P22LnQg\n000C0000003Hl1d0]0L:P=S`7@0PP?Mg15<0000Rm7L200000>3mO`cd4P000000`?DB05HHjWN`MNQg\n00000?ooo`000000f?0M0;g6m7M>1b6=L?@B0060001Pa_AgCPLQSG3d4P2`P?MgI7H02000000U0000\n300000<0000U0000300000L0080U000030000000080`0000300000l0080U0000300000d0081;0000\n4000000000050000:00000`000010000:00000`000020000:00000`000070000:00000`000040000\n:00000`000050000:00000`000060000:00000`0000300003P0001@000000000400001@0\n"], "Text", Rule[ImageSize, List[382, 102]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[StyleBox["ResistorCircuit", Rule[FontFamily, "Courier New"]]], "NumberedFigure", Rule[TextAlignment, Left]], Cell["", "Text"], Cell["model ResistorCircuit\n  Modelica.Electrical.Analog.Basic.Resistor R1, R2, R3;\nequation\n  connect(R1.p, R2.p);\n  connect(R2.p, R3.p);\nend ResistorCircuit;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["ECircuit", "Section"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@00042T0@0006`000000000000008X2001=0000\n00000000003=>`00`0L00215CDH00040Y4000:`1000;0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0001PE000<5@00AdA9@`4008000`00l:V5W@00003d5000\n0@090003NPX000`070000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030;E0B0>70000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4000D000020@40000500002@80000270000?/2W?l00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4100<0000N00L0000F1=D1\n80h00000400002H63`0F0?ooool00?oooooooooo90h00=H1000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01`000184e@7E0B0>8`h500002`8000001@0000`2e@4S3Q@0000V1Pl0\n7P3ooooo100D0000EfmbI0h0CFUSLVmcKfId85M_LV@5000030;E0B<>70000?/250090000002l0P00\n00040P8RDgUcM6E]07M00000SPL:O[iRmGO7H_Eg0@000000<0040000;@4400D000020@40000L0000\nn`:]o`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@D0\n1@0000T200000PD0000;0P00000=0000<PX100000@040000000S3]D186TU0100000V1Pl05P3ooooo\n002[0P00n00005`400000@0020000?X200040000000000@0000]0@H0100002d10P0800009@<20:h2\nn`1H1?`020000?X200000000000000@0000]0@L010000?011P070000o0800?ooo`0000@0000]0@H0\n200002H63`060?ooool100@0000]0@8020000?X20004000000000P@0000]0@P01`0001/4JP6D0Y80\nZ@040000;@4600@0000]0@L010000?0120040000;@4200@0000]0@<01`0001/4:P500MT0g@040000\n;@4600@0000]0@L00`0001h01`0001H4:@500MT0g@0500000P41000070000?/2_Ol00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4800d0000b2]/0g@0100@0\ng@3I03l1:@5`02803@00038:f`3o0040103M0=T0?`4Y0B1U7@0400009`7oo`@0000]0@80100002d1\n0`0700006`@U0GD2eP2@0@@0000]0@H0100002d11`0300007P0700005P@T0GD2eP2@0@D000020@40\n00040000;@4800D000090P00008L0000<P[F09012`040901eP1d0R@1820P820P820P86h04@0A0140\n400A0140400A0140400R00d0000b2]H0F@8100@0T07F07@2904PM1d0100002L1ool40000;@4200@0\n000]0@<01`0001/4k03P0ID0IP440000;@4600@0000]0@L00`0001h01`0001H4jP3P0ID0I`450000\n0P410000100002d11@0500002@8000023P00038:UP1W0@80101W0ID0g`7Z058a=`0Z00d0000b2YH0\nb04100@0I`6E0=l1jP0P<BD0100002L1ool40000;@4200P0003j0P001000000000840000;@4900L0\n000K16L1O`f@09@;100002d11P040000;@4700@0003`0@T0100002d10P040000;@4300L0000K12X1\n?@cF0;h;100002d11P040000;@4700<0000N00L0000F12T1?0cF0;h;1@0000810@0000@0000]0@P0\n1@0000T200000Pd0000b2]P0_P/100@0_P_F03/<:@5`02803@00038:f03P2`40102n2mH0>``Y0B00\n7@0400009`7oo`@0000]0@80100002d10`0700006`@S0F<=e02?30@0000]0@H0100002d11`030000\n7P0700005P@Q0F<=e02?30D000020@4000040000;@4800D000090P00008L0000<P[D08l<2`0408l<\ne01R3B41820P820P820P86h04@0A0140400A0140400A0140400R00d0000b2]@0F0d100@0S`cD068=\n8@4P01d0100002L1ool40000;@4200@0000]0@<01`0001/4j@3;39<0D@`40000;@4600@0000]0@L0\n0`0001h01`0001H4j03;39<0D@`500000P410000100002d11@0500002@8000023P00038:U01A3080\n101A39<0bPcX058d=`0Z00d0000b2Y@0/P`100@0D@bC0<X<j00P=2D0100002L1ool@00009PH?01H0\nooooo`00ePT00?H0001f2`00o@0000P0003j0P001000000000040000;@4900@0000]0@80200002D3\n0P3I2OT0LP_i00@0000]0@L010000?012@040000;@4600P0000V1Pl01P3ooooo0@040000;@4200P0\n003j0P001000000000840000;@4900L0000K16L1_`V@0=@7100002d11P040000;@4700@0003`0@T0\n100002d10P040000;@4300L0000K12l1/@SF0?h7100002d11P040000;@4700<0000N00L0000F12h1\n/@SF0?h71@0000810@0000@0000]0@P01@0000T200000Pd0000b2]P0oPL100@0oPOF0;08;P5`0280\n3@00038:f00P2040103n1mH0/0P^0B007@0400009`7oo`@0000]0@80100002d10`0700006`@S0J09\ne03=20@0000]0@H0100002d11`0300007P0700005P@Q0J09e03=20D000020@4000040000;@4800D0\n00090P00008L0000<P[D0<d82`040<d8e02O2B41820P820P820P86h04@0A0140400A0140400A0140\n400R00d0000b2]@0UPT100@0c@SD09l98@4P01d0100002L1ool40000;@4200@0000]0@<01`0001/4\nj@0;2I<0T@P40000;@4600@0000]0@L00`0001h01`0001H4j00;2I<0T@P500000P410000100002d1\n1@0500002@8000023P00038:U02A2080102A29<02PWX058c=`0Z00d0000b2Y@0lPP100@0T@RC00X9\nj00P<bD0100002L1ool40000;@4200P0003j0P001000000000840000;@4900L0000K16L1H0J@07D4\n100002d11P040000;@4700@0003`0@T0400002H63`0F0?ooool007D6003f0000/`L00?d000080000\nnP8000@000000000100002d12@040000;@4200P0000U0`80N0Ki0:l7n@040000;@4700@0003`0@T0\n100002d11P0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K12d1D`GF09l4100002d1\n1P040000;@4700<0000N00L0000F12/1DPGF0:041@0000810@0000@0000]0@P01@0000T200000Pd0\n000b2]P0X0@100@0X0CF0545:`5`02803@00038:f0321040102P1=H0D@D[0B007@0400009`7oo`@0\n000]0@80100002d10`0700006`@S0D86e01^1@@0000]0@H0100002d11`0300007P0700005P@Q0D86\ne01^1@D000020@4000040000;@4800D000090P00008L0000<P[D06h52`0406h5e0111R41820P820P\n820P86h04@0A0140400A0140400A0140400R00d0000b2]@0=`H100@0KPGD04468@4P01d0100002L1\nool40000;@4200@0000]0@<01`0001/4j@2]1I<0<`D40000;@4600@0000]0@L00`0001h01`0001H4\nj02/1I<0<`D500000P410000100002d11@0500002@8000023P00038:U00c1@80100c1I<0Z`GX058b\n=`0Z00d0000b2Y@0U0D100@0<`FC0:/5j00P<RD0100002L1ool40000;@4200P0003j0P0020000000\n00840000;@4900L0000K1<d1=0XX0?d3100002d11P040000;@4700@0003`0@T0100002d10P040000\n;@4300L0000K1=X0o0>904T3100002d11P040000;@4700<0000N00L0000F1=T0o0>904T31@000081\n0@0000@0000]0@P01@0000T200000QT0000b2X/0B@<900@0B@>90?/3f@0P820P820P87004@0A0140\n400A0140400A02803@00038:R`3a0`4010190hT0n`?I02007@0400009`7oo`@0000]0@80100002d1\n0`0700006`B`07T7?P3B1P@0000]0@H0100002d11`0300007P0700005PB^07P7?P3B1PD000020@40\n000L0000n`:Lo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0\n000]0@T01@0000T200000Ph0000b2Sh0dPH200@0dPHn07L7[P15<Cd0<P0=0000<PXn04470@040=86\n?P1g1jh0834]00@0000W0Ooo100002d10P040000;@4300L0000K1=d04P^>03l:100002d11P040000\n;@4700<0000N00L0000F1=/04P^>03l:1@0000810@0000@0000]0@P01@0000T200000Pd0000b2Xh0\n?`X100@0?`Z>014;f`1^<B803@00038:SP1Q2P40100o2Xh04@_K020a7@0400009`7oo`L0003l0P00\ncLg=0000100002d12P080000nP8000H000000002100002d12`0700006`@L0A/4g`3M0`@0000]0@H0\n10000?012P040000;@4700@0003`0@/01`000?`2003=cLd000040000;@4:00P0003j0P001P000000\n00840000;@4;00L0000K11L1/@_J07@;100002d11P040000l04:00@0000]0@L010000?012`070000\no0800<g=c@0000@0000]0@X020000?X20006000000000P@0000]0@/01`0001/4706C1=l0E@@40000\n;@4600@0003`0@X0100002d11`040000l04;00L0003l0P00cLg=0000100002d12P080000nP8000H0\n00000002100002d12`0700006`@I0O47g02d1`@0000]0@H010000?012P040000;@4700@0003`0@/0\n1`000?`2003=cLd000040000;@4:00P0003j0P001P00000000840000;@4;00L0000K11T1a03L08H0\n100002d11P040000l04:00@0000]0@L010000?012`070000o0800?ooo`0000@0000]0@X020000?X2\n0006000000000P@0000]0@/01`0001/4706c0]l0M@840000;@4600@0003`0@X0100002d11`040000\nl04;00L0003l0P00oooo0000100002d12P080000nP8000H000000002100002d12`0700006`@I0E4:\ng00C2P@0000]0@H010000?012P040000;@4700@0003`0@/01`000?`2003oool000040000;@4:00P0\n003j0P001P00000000840000;@4;00L0000K11T1f`WL09h9100002d11P040000l04:00@0000]0@L0\n10000?012`070000o0800?ooo`0000@0000]0@X020000?X20006000000000P@0000]0@/01`0001/4\n5`5m1]X0?`H40000;@4600@0003`0@X0100002d11`040000l04;0100000V1Pl05P3ooooo00020000\nmP0008P0003o000020000?X200060000000000@0000]0@X0100002d10P0800009@<200H0nP230?X0\n100002d11`040000l04:00@0000]0@H0200002H63`060?ooool10100000V1Pl05P3ooooo002B3@00\nl`0001P>003l000020000?X200060000000000@0000]0@X0100002d10P0800009@<209H=m`0C3_L0\n100002d11`040000l04:00@0000]0@H0200002H63`060?ooool100L0003l0P00oooo0000100002d1\n2P080000nP8000H000000002100002d12`0700006`@G0I/=fP1N3@@0000]0@H010000?012P040000\n;@4700@0003`0@/0100002d10P040000;@4300L0000K1540mP;ooi`2100002d11P040000;@4700<0\n000N00L0000F14l0m@;ooi`21@0000810@0000@0000]0@P01@0000T200000Pd0000b2P40W08100@0\nW0;ooo@2C`0P01h0100002L1ool40000;@4400@0003`0@D010000?0120040000l04900L0003l0P00\noooo0000100002d11@080000nP80000000000000100002d1200400009`7oo`P0000V1Pl01P3ooooo\n0@0400009`7oo`@0000]0@000`0000004@0000`0000800002`000100002=0P00C`0000T0000@0000\nS@8004l0000:000040000000000000002@000100000P3P00e@400580001`0@000@00010000070000\n00000000002l0P00000000420R9C07T0L`1d06D0K@00000000000000000000000000000000000000\n0000000000000000000000000000000000000002000001<0b8lI07P14`071000D;KlMaJeo7L]]Oag\n00000800001H4QT0000C02P<4`0N0000f5lG09cc4P3`CaP0N04C09D[n7Nh>OQgooooofSe4P101Q<0\n:0`C00000000000060PQhS1TB08T00001<Z6oY@ZS04001P0N04C00Cd4P000000@0HC070<FP2HfeT0\n`0000?gHooo`f?oom=Soo`00P3l40000lX;oo`00000P6`<0000C0?1?601h0A<0N04C0>Q?601@]_ag\n5[GlMbfeo7L00000000000T0001H4QT0Z?@B0=Al6032`?Ag0@0006Af00P000009@0000`000010000\n4P0000`000010000600000`000000002DP00070100020000W?ooo`00000000000000090100000000\n14004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000000000000000000000000000\n00000000000000<0000C0?1?601h0A<0N04C0>Q?601@]_ag5[GlMbfeo7L00000000000T0001H4QT0\nZ?@B0=Al6032`?Ag0@0006Af00P00000UB_hMkPin7OoooooJ?DB04064`0X31<000000000000H227R\n<6A80R@00004bXKnU2Z<0@00601h0A<01?@B000000101Q<0L0aJ09SKF@300000oMSooo3Hooodf?oo\n0020?`@0003bP_oo0000020K0`0001<0l4lH07P14`1h0A<0j4lH052fo7LF]Oag;KGlMbD0001H4QT0\nR?@B08h7001D`?Ag0@0001T0/06>1`YoI7H02000000U000030000080000Q0000200001h0000H0000\n00000000000P3P00e@400240000800005P0000`000000000N000010000000000000001P0000<0000\n000001T0000<0000oooo02D0000<00001@00P2D0000<00002000P1l0000H00008`h0020>003E0@00\ne@4000X0000@00000000000000090000400002<>003E0@002@000100000S3P00e@400580001`0@00\n0`0001@00009000000000000002l0P00000000@20R9C07T0L`1d06D0K@0000000000000000000000\n000000000000000000000000000000000000000000000000000300004`3`CaP0N04C07P14`3XCaP0\nD;KlMaJeo7L]]Oag9@0005PB6@28m180SPL005C0m7L100006@2`0Hh72WmTMP08000009D[n7Nh>OQg\nooooofSe4P101Q<0:0`C00000000000060PQhS1TB08T00001<Z6oY@ZS04001P0N04C00Cd4P000000\n@0HC070<FP2HfeT0`0000?gHooo`f?oom=Soo`00P3l@8_Aga?3mO`3PoGl100000000000000000000\nU@L00010002E1`AT0@0006Cd4P0U0000F18I00T0001H4QT0Z?@B05An6032`?Ag0@0006Af00P00000\n9@0000`0000300004P0000`000010000DP00070100040000[Oooo`00000000000000090100000000\n14004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000000000000000000000000000\n00000000000000000000000000000000U@L00010002E1`AT0@0006Cd4P0U0000F18I00T0001H4QT0\nZ?@B05An6032`?Ag0@0006Af00P00000UB_hMkPin7OoooooJ?DB04064`0X31<000000000000H227R\n<6A80R@00004bXKnU2Z<0@00601h0A<01?@B000000101Q<0L0aJ09SKF@300000oMSooo3Hooodf?oo\n0020?a0Rm7O4l?eo0>3mO`400000000000000000002E1`00040009D716@10000I?@B02D0001H4QT0\nR?@B0987001D`?Ag0@0001T0/06B1`X8I7H02000000U0000300000@0000H000030000000008:0000\n4000000000000000E00005@000000000000000H0000?00000@000==CQd0k`HI00000004000010000\nC00000@000000000000002<>003E0@00D0000200000U00009P0001`000050000000000@000000000\n000002D0000<00001@0002D0000<00001@00P5L0000T0000O00002X000390000:P000080002^0_/0\nF0Cl02H0000L00001P0000000000000000000000000U0000300000H0000X0000300000D0000W0000\n600000D000000000oooo0000000U0000300000D0000U0000300000D0080V0000700000L000000000\n10000000000000029@0000`000070000:`0001P0002Y0000TP0008h2001T0@009@0000`000050000\n9@0000`000060000:00000`0000700009@0000`0000500209@0000`000080020:`0001P0003M0000\nf@0003/1000T0@009@0000`0000500009@0000`0000600008@0000P0000N000060000=d0003I0000\n@04002T1000B000030000040001B0000L04000L0002moooo0000000000000000T04000000004@00B\nE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000000000000000000000000000\n000000005`20[aL000000000002E1`00040009D716@10000I?@B02D0001H4QT0R?@B0<cc4P000000\niCShM`004`2h[aL000000:Sc4P281Q<0G?@B09D[n7L001<01000003d4P10]oag60LC006_5`020000\nJ?<B0000000`m180003hMaPfn7Oooooo@?@B089cj7L001<00000082_5`1V1c0JP:lG0220mgL0080o\n42;dMlC`oGl0h?eo0@00000000000000000009D70000@000U@L4IP40001Tm180l37dMiD716HH227R\nU@L4IP000004IP00P?@B093Bm7MTMP08000002D0000<00001`0005@0001D0000:00002D0000^0000\n<@000040003CDhM0>l66@=d0003K00000@0004`000040000g@000=T0000o0@00:@400500001`0000\n8P0005@0001D0000;P0002D0000c0000<@000040003CDhM0>l66@?l0003K00000@0004`000040000\ng@000=T0000o0@00:@400500000P00007@000280000<0000ooooobD0000<00001@00P2D0000<0000\n2000P2/0000H0000T0400=H0001_0P007`4002D0000<00001@0002D0000<00001P00024000080000\n7P0001P0002@0@00eP0007D2000T0@004P0000`0000100009@0000`000070000600000`000000002\nE000090000180000900006`0000`00000@000==CQd0k`HI0T0400=H0000;0000C00000@0002@0@00\neP0007@2000T0@00I0000200800P0200800P0200800P0200KP000140000A00004@000100000A0000\n4@000100000A00004@000100000R0000E00005@0001/000090000700000`00000@000==CQd0k`HI0\nF@800=H000010000C00000@0002@0@00eP0007@2000T0@00D0000200000M00008P0000`0003ooooo\n9@0000`0000500209@0000`000080020:`0001P0001V0@00U@000=/1003V00009@0000`000050000\n9@0000`0000600008@0000P0000N0000600006L1002E0000h0400>X0000B000030000040000U0000\n300000@0000H000030000000009D0000F0000440000I0000DP0002H000010000de>7@3_1QT1W0@00\nUP000080001<0000100006L1002E0000g`400>X0001@0000DP0a03L0000Z0000E00005@0001B0000\n6@0005D0000V00000@000==CQd0k`HI0b04009H000010000C00000@0001W0@00U@000=l1003Z0000\nD0000200000U00008P0000`0003ooooo9@0000`0000500209P0001`000080000000000@000000000\n00000RD0000<0000200002/0000H0000U0/00900001j3@00H@4002D0000<00001@0002D0000<0000\n1P0002P0000<0000200002D0000<00001@00P2D0000<00002000P2/0000H0000_P/00=H0000g3000\n904002D0000<00001@0002D0000<00001P000240000800007P0001P0002n2`00eP0003`<000Y0@00\n4P0000`0000100009@0000`000070000600000`000000002E00005@0000N0P00900002@2000a0000\n0@000==CQd0k`HI0_P/00=P000010000C00000@0002n2`00eP0003/<000Y0@00D0000700000R0000\nE00005@0000U0P00900002X2000a00000@000==CQd0k`HI0h0/00=P000010000C00000@0002n2`00\neP0003/<000Y0@00D0000200000M00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P0002?3000e00005h=000M0@009@0000`0000500009@0000`0000600008@0000P0000N0000\n600008l<003D0000H`d00241000B000030000040000U0000300000L0000H000030000000009D0000\nT00004@2000T0000J080030000010000de>7@3_1QT2?3000e00000/0001<0000100008l<003D0000\nHPd00241001T0000800P0200800P0200800P0200801^00004@000140000A000040000140000A0000\n40000140000A000040000280001D0000E00006P2000T0000J@80030000010000de>7@3_1QT1H3@00\ne0000040001<0000100008l<003D0000HPd00241001@0000800001d0000R000030000?oooolU0000\n300000D0080U0000300000P0080[00006000054<002C0000aP`00><0000U0000300000D0000U0000\n300000H0000Q0000200001h0000H0000D@`009<0003;3000j0000180000<00000@0002D0000<0000\n100001P0000<000000000U@0001H0000>@8001T0001:0P009P000040003CDhM0>l66@54<002D0000\n0P0004`000040000D@`009<0003:3000j0000500001B03@0=`0002X0001D0000E00004X2000I0000\nCP8002H000010000de>7@3_1QT2b3000U0000040001<00001000054<002C0000bP`00>P0001@0000\n800002D0000R000030000?oooolV0000700000P00000000010000000000000009@0000`000080000\n9@0000`000050020E`0002@000370@00:P000142000Z00000P000=T9n@1b2oT09@0000`000060000\n:00000`0000800009@0000`0000500009@0000`0000500209P0001`000080000000000@000000000\n00000RD0000<0000200002/0000H0000e0L00900002i2@00H@4002D0000<00001@0002D0000<0000\n1P0002P0000<0000200002D0000<00001@00P2D0000<00002000P2/0000H0000oPL00=H0002/2000\n:@4002D0000<00001@0002D0000<00001P000240000800007P0001P0003n1`00eP000;48000^0@00\n4P0000`0000100009@0000`000070000600000`000000002E00005@0001a0@00900007L1000a0000\n0@000==CQd0k`HI0oPL00=P000010000C00000@0003n1`00eP000;08000^0@00D0000700000R0000\nE00005@0001g0@00900007`1000a00000@000==CQd0k`HI080P00=P000010000C00000@0003n1`00\neP000;08000^0@00D0000200000M00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P0003=2000e00009/9000M0@009@0000`0000500009@0000`0000600008@0000P0000N0000\n60000<d8003D0000X0T00241000B000030000040000U0000300000L0000H000030000000009D0000\nT00009L1000T0000^`40030000010000de>7@3_1QT3=2000e00000/0001<000010000<d8003D0000\nW`T00241001T0000800P0200800P0200800P0200801^00004@000140000A000040000140000A0000\n40000140000A000040000280001D0000E0000;/1000T0000^`40030000010000de>7@3_1QT2F2@00\ne0000040001<000010000<d8003D0000W`T00241001@0000800001d0000R000030000?oooolU0000\n300000D0080U0000300000P0080[000060000948002C00001@T00><0000U0000300000D0000U0000\n300000H0000Q0000200001h0000H0000T@P009<0000;2@00j0000180000<00000@0002D0000<0000\n100001P0000<000000000U@0001H0000S04001T0002M0@009P000040003CDhM0>l66@948002D0000\n0P0004`000040000T@P009<0000:2@00j0000500001B03<0=`0002X0001D0000E00009d1000I0000\nX@4002H000010000de>7@3_1QT3b2000U0000040001<000010000948002C00002PT00>P0001@0000\n800002D0000R000030000?oooolU0000300000D0080V0000700000P0000000001000000000000002\n9@0000`000080000:`0001P0001e1000T00005/6001Q0@009@0000`0000500009@0000`000060000\n:00000`0000800009P0001`000080000000000@000000000000002D0000<0000200002D0000<0000\n1@00P5L0000T0000:`4002X0001S0@00:P000080001h1_T0[`Oi02D0000<00001P0002P0000<0000\n200002D0000<00001@0002D0000<00001@00P2D0000<00002000P2/0000H0000W`@00=H0001=1@00\n9`4002D0000<00001@0002D0000<00001P000240000800007P0001P0002P1000eP000585000[0@00\n4P0000`0000100009@0000`000070000600000`000000002E00005@0003F000090000=`0000a0000\n0@000==CQd0k`HI0X0@00=P000010000C00000@0002P1000eP000545000[0@00D0000700000R0000\nE00005@0003L000090000>40000a00000@000==CQd0k`HI0`P@00=P000010000C00000@0002P1000\neP000545000[0@00D0000200000M00008P0000`0003ooooo9@0000`0000500209@0000`000080020\n:`0001P0001^1@00e00003`6000M0@009@0000`0000500009@0000`0000600008@0000P0000N0000\n600006h5003D0000@PH00241000B000030000040000U0000300000L0000H000030000000009D0000\nT0000?/0000T00007`40030000010000de>7@3_1QT1^1@00e00000/0001<0000100006h5003D0000\n@@H00241001T0000800P0200800P0200800P0200801^00004@000140000A000040000140000A0000\n40000140000A000040000280001D0000E00001l1000T00008040030000010000de>7@3_1QT0g1P00\ne0000040001<0000100006h5003D0000@@H00241001@0000800001d0000R000030000?oooolU0000\n300000D0080U0000300000P0080[0000600003<5002C0000Z0D00><0000U0000300000D0000U0000\n300000H0000Q0000200001h0000H0000<`D009<0002/1@00j0000180000<00000@0002D0000<0000\n100001P0000<000000000U@0001H0000l00001T000010@009P000040003CDhM0>l66@3<5002D0000\n0P0004`000040000<`D009<0002[1@00j0000500001B0380=`0002X0001D0000E0000081000I0000\n1@4002H000010000de>7@3_1QT2D1@00U0000040001<0000100003<5002C0000Z`D00>P0001@0000\n800002D0000R000030000?oooolU0000300000D0080V0000700000P0000000002000000000000002\n9@0000`000080000:`0001P0003m0`00:00002l:00370@009@0000`0000500009@0000`000060000\n:00000`0000800009@0000`0000500209@0000`000080020:`0001P000190`00R@000?L3003D0000\n9@0000`0000500009@0000`0000600008@0000P0000N0000600004T300290000o0<00=T0000B0000\n30000040000U0000300000L0000H000030000000009D0000Q00009P0000G0000]P0002@000010000\nde>7@3_1QT190`00R`0000T0001<0000100004T300290000n`<00=T0001P0000800P0200800P0200\n800P0700000A00004@000140000@00004@000140000@00004@000280001D0000E0000;H0000G0000\n]`0002@000010000de>7@3_1QT3a0`00R`000040001<0000100004T300290000n`<00=T0001@0000\n800001d0000R000030000?oooolU0000300000D0080U0000300000P0080[000060000=86000n0000\nM0L00:X0000U0000300000D0000U0000300000H0000Q0000200001h0000H0000dPH003h0001h1`00\n[P000180000<00000@000580001`0@00200009coool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n000P07005`1^0000000009D70000@000U@L4IP40001Tm180l37dMiD716HH227Rc?<B0000003U>?Qg\n000C07147P000000Z?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7OX1Q<0N4@N07Q47P28RQP0\nN4@N003PoGl0000000000000002E1`00040009D717H10000000C0?0am7NE1`Af60PQhP40000@8_Ag\na?3mO`3PoGl100000000000000000000U@L00010002E1`Ah0@0006Cd4P3`<OAgU@L4N1P88N:E1`Ah\n000000Ah0020m180T=;dMfAf00P000009@0000`000080000600000`000000002E00005P0000k0@00\n2P0004h1000L00000@000==CQd0k`HI0dPH003h000020000C00000@0003B1P00?P0007L7002^0000\nD00004D0<@0m0000<P0005@0001D0000C`4000X0001G0@0070000040003CDhM0>l66@447000n0000\n0@0004`000040000dPH003h0001g1`00[P000500000P0000;@000280000<0000ooooobD0000<0000\n1@00P2D0000<00002000P2/0000H0000?`X008h0000=2`00e`0002D0000<00001@0002D0000<0000\n1P000240000800007P0001P0000o2P00SP00018;003K00004P0000`0000100009@0000`000070000\n600000`000000002E00005@0003I0@0060000=l1000T00000@000==CQd0k`HI0?`X008h000010000\nC00000@0000o2P00SP00014;003K0000D00006h0000R0000E00005@0003O0@0060000>@1000T0000\n0@000==CQd0k`HI0H@X008h000010000C00000@0000o2P00SP00014;003K0000D0000200000M0000\n8P0000`0003ooooo9`0001P00009000000000<g=c@0000009@0000`0000900009P0001`0000:0000\n000000H00000000000000RD0000<00002P0002/0000H0000g@<00=l0000E10005P4002D0000<0000\n1@0002P0000<00002@0002D0000<00001P0002P0000<00002P0002L0000H00002P000000003=cLd0\n000002D0000<00002P0002H0000L00002@0000000006000000000000008U0000300000T0000[0000\n600007@;003J0000[0/00141000U0000300000D0000X0000300000X0000U0000300000H0000X0000\n300000T0000W0000600000T000000000cLg=0000000U0000300000T0000V0000700000X000000000\n1P000000000000029@0000`0000:0000:`0001P0001E1000g`0008h4000F0@009@0000`000050000\n:00000`0000900009@0000`000060000:00000`0000:00009`0001P0000:000000000<g=c@000000\n9@0000`0000:00009P0001`000090000000000H00000000000000RD0000<00002@0002/0000H0000\n]0L00=`0003[1`004`4002D0000<00001@0002P0000<00002P0002D0000<00001P0002P0000<0000\n2@0002L0000H00002@000000003=cLd0000002D0000<00002@0002H0000L00002P00000000060000\n00000000008U0000300000X0000[0000600008H0003L0000_`0001<1000U0000300000D0000X0000\n300000T0000U0000300000H0000X0000300000X0000W0000600000X000000000oooo0000000U0000\n300000X0000V0000700000T0000000001P000000000000029@0000`000090000:`0001P0001e0P00\ng`000:d2000F0@009@0000`000050000:00000`0000:00009@0000`000060000:00000`000090000\n9`0001P00009000000000?ooo`0000009@0000`0000900009P0001`0000:0000000000H000000000\n00000RD0000<00002P0002/0000H00004`X00=`0001<2P004`4002D0000<00001@0002P0000<0000\n2@0002D0000<00001P0002P0000<00002P0002L0000H00002P000000003oool0000002D0000<0000\n2P0002H0000L00002@0000000006000000000000008U0000300000T0000[0000600009h9003L0000\nePT001<1000U0000300000D0000X0000300000X0000U0000300000H0000X0000300000T0000W0000\n600000T000000000oooo0000000U0000300000T0000V0000700000X0000000001P00000000000002\n9@0000`0000:0000:`0001P0000o1P00fP0007L6000A0@009@0000`000050000:00000`000090000\n9@0000`000060000:00000`0000:00009P0001`0000:0000000000H000000000000002D0000<0000\n2P0002D0000<00001@00P5L0000T00000@0002X0000H0000:P00008000060?X0P`3j02D0000<0000\n1P0002P0000<00002P0002D0000<00001@0002H0000L00002P0000000006000000000000000U0000\n300000X0000U0000300000D0081G0000900007@2000Z0000RP8002X000020000UPgg01<>m`0U0000\n300000H0000X0000300000X0000U0000300000D0000W0000600000X000000000oooo0000000U0000\n300000X0000V0000700000T0000000001P000000000000029@0000`000090000:`0001P0001N3@00\nfP0009D=000A0@009@0000`000050000:00000`0000:00009@0000`000060000:00000`000090000\n9@0000`0000500209@0000`000080020:`0001P0002L0P00oooooo02001;00009@0000`000050000\n9@0000`0000600008@0000P0000N0000600009`2003ooooom@8004l0000B000030000040000U0000\n300000L0000H000030000000009D0000E00007T000000000OP0000`000010000de>7@3_1QT2L0P00\n0@000040001<0000100009`2003ooooom08004l0001@0000800001h0000R000030000?oooolU0000\n300000<0000X0000300000@0000X0000300000L0000X0000300000P0000W0000600000P000000000\noooo0000000U0000300000P0000V0000700000L00000000000000000000000009@0000`000070000\n8P0000`0003ooooo8P0000`0003ooooo9@0000`0000100009@0000`0000700209@0000`000000020\n<00000`0000?00209@0000`0000=0020B`000100000000001@0002P0000<00000@0002P0000<0000\n0P0002P0000<00000`0002P0000<0000200002P0000<00001@0002P0000<00001P0002P0000<0000\n1`0000h0000D000000000100000D0000\n"], "Text", Rule[ImageSize, List[650, 77]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[StyleBox["ECircuit", Rule[FontFamily, "Courier New"]]], "NumberedFigure", Rule[TextAlignment, Left]], Cell["\nThe situation is somewhat different regarding the ECircuit model below since it contains a structured component E1 that contains both inside and outside connectors.", "Text"], Cell["class E\n  Modelica.Electrical.Analog.Basic.Resistor R2, R3;\n  Modelica.Electrical.Analog.Basic.Pin p, n;\nequation\n  connect(p, R2.p);\n  connect(R2.n, R3.p);\n  connect(R3.n, n);\nend E;", "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["model ECircuit\n  Modelica.Electrical.Analog.Basic.Resistor R1, R4;\n  E E1;\nequation\n  ", StyleBox["connect(R1.n, E1.p);\n  connect(E1.n, R4.p);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ECircuit;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[936, 904]], Rule[WindowMargins, List[List[-3, Automatic], List[Automatic, -2]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]