List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Connections", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List[StyleBox["Connections", Rule[FontSlant, "Italic"]], " between components can be established between ", StyleBox["connectors", Rule[FontSlant, "Italic"]], " of ", StyleBox["equivalent type", Rule[FontSlant, "Italic"]], ". The names must be identical. And corresponding types of declared ", StyleBox["variable members", Rule[FontSlant, "Italic"]], " in the classes of the connectors must be equivalent, but the ordering between the member declarations in the connector classes need not be the same. It is important to note that connections can only be established between connectors (instances of ", StyleBox["connector", Rule[FontFamily, "Courier"]], " classes). Instances of the restricted classes ", StyleBox["record, block, model, function", Rule[FontFamily, "Courier"]], " and ", StyleBox["package", Rule[FontFamily, "Courier"]], " are not allowed in connections.\n\nIn connectors there are two kinds of variables, either non-flow variables that represents som kind of potential enegy level (ex. Voltage) or flow variables, with the prefix flow, that represents some kind of flow (ex. electric current). "]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Connect Statements", "Section"], Cell[TextData[List["Connections between connectors are realized as equations in Modelica. Note that ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statements are regarded as ", StyleBox["equations", Rule[FontSlant, "Italic"]], " despite the fact that the syntax is different from normal equations. The reason is that ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statements are eventually expanded into normal equations. The general form of a ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statement is as follows:"]], "Text"], Cell["\t\t\t\t\tconnect(connector1, connector2)", "Program", Rule[TextAlignment, Left]], Cell[TextData[List["The two arguments of a ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statement must be references to connectors, each of which either has to be declared within the same class where the ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statement occurs, or has to be a member of one of the declared variables in that class."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Electrical Connections", "Section"], Cell[TextData[List["Now we connect the two connectors ", StyleBox["Pin1", Rule[FontFamily, "Courier"]], " and ", StyleBox["Pin2", Rule[FontFamily, "Courier"]], " using a connect statement. The class ", StyleBox["ConnectedPins", Rule[FontFamily, "Courier"]], " connects the two pins so that they form one node. This produces two equations, namely: ", StyleBox["pin1.v = pin2.v and pin1.i + pin2.i = 0", Rule[FontFamily, "Courier"]], ". The first says that the voltages at the connected wire ends are the same (", StyleBox["equality coupling", Rule[FontSlant, "Italic"]], "). The second equation corresponds to Kirchhoff's current law saying that the currents ", StyleBox["sum to zero", Rule[FontSlant, "Italic"]], " at a node .\n"]], "Text"], Cell[TextData[List["class ConnectedPins\n  Modelica.Electrical.Analog.Interfaces.Pin pin1;\n  Modelica.Electrical.Analog.Interfaces.Pin pin2;\nequation\n  ", StyleBox["connect(pin1, pin2);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ConnectedPins;"]], "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0005a80@0006`0000100000P000?H1001F0000\n00000000000a;P005@P00215CDH00040B5`009L200050000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH00006000016000060P000`80015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D000020000100001Z00007D0001@0000800000@0006X0000Q@0L030000000000U@000\n400000@000000000;40002@0000H0000b^M_?P0008000020Km>O?JM6QT<b<l/o24001D`700101`00\n0A30f`8000040000<0L00040001/00000P0000@0003[0000B`00000000000000LaD009l7000PADe6\n00010307000@000010000000000000000000000400001@00l000040100000000000000000020Z@<0\n0>8404H0000/0000800004E=AR/1@0407000010000014<3K0@000600001P0000AP000>00003D0000\nADe6:c100P0@000010000000P3lO@0@030000000000N@04030000000000M@000500000P0002foooo\nE`0001e0000D000020000:WooomG000024000S`0000`00000A30f`00001>0000000000Se^3h20000\n0P000080000200000A30f`000000003o24010c@0000X00000A30f`<000000000f28P@UDE8T;U/li2\nEADR@^FccT:aY2A2004101E00@0@00001000000000160000=00002P00015CDH[2T00P2@0000H0000\noooo00400005ZnU2EED8@FMViT;nogm2AP000;00002T0000ADe6:`Q000980000?000004@`=/00000\nCP4000000036]hXo0P000080000200000P000080000000110020@04@`=/000000000o`Q00@=80000\n?000004@`=/50000000000F[jD:[2Y52]PQX@j/:TD:f26Q3EED8@@F[jD9EE@Q11J_Y@Z/:TD800@41\nP@0001E00@0@00001000000000160000^0000:`00015CDH[:T0002@0000H00009KoH@P0000000000\n<c?;@PF[jD9EE@Q124021S00000T00000A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000\n=T02P5@0001800000000o`40000100000`000500J@1^09IedShOg;Xn8;05?aoL^Sk;:Plo7mbj?P00\nP3l0000000000000P3l0000000000000AP000400000d0000ADe6:b]0000<0000000000Y0080T0000\n60000<30`?l10000K17@@ZXZm46/ZZY1002P@DH0002T0000V00004E=AR/8@002?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043B00003`000014<3K\n1@000000001/4M12EAE:@QNlnT9E5DY25kcj@ZXZm45/4M12ZR[d@F`Ad49E5DY200410H40000E@040\n400000@000000000AP0008P0001l0000ADe6:`Q0008l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/000000000o`Q00@</00008000004@`=/2000000000?Y4@T9E5G92\ndWNf@UDELT800@005D01010000040000000004H0002@0000Q00004E=AR/8@002?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`000000003V]Za2R2n2@]9g]T9E5G92i[J/@Y_;Gd800@405D01010000040000000004H0002T0000\nV00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2N]ZF`TZO=3h8@086<00002@000014<3K\nZjXZ?P0000000000000000D000110580B@1104`0000f@0:0@00003@00000003o0@00004000010000\nEP1P;3Ho5fa1?P00P3l0000000000000P3l0000000000000AP000800001d0000ADe6:b]0000<0000\n000002Y0000T0000600002Fof4800000000003<cbd9jfYK2BYld?SI00X100000=00000000?l10000\n0@000040000[05j]YSlGK44n0020?`00000000000020?`000000000000160000/0000:@00015CDH[\n:d0000`000000000:T0002@0000H00009KoH@P0000000000<c?;@P9SWl:O]51224021S00000T0000\n0A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P400000d00000000o`4000010000\n0@0006T0akf4?aM/@Ch0080o000000000000080o00000000000004H0000L0000400004E=AR/[@000\n3000000000160000700001000015CDH[0T0000`0000000003P0001@000000000400001@0000J@010\n;0000200003ooooo0P00000000000000001[@`00WT800000j0?X0b4000080000HP0000`000010000\n8@0000P0000Q0000200007<0000<0000000001`0000800009@0000`0000000209@0000`000070020\n9@0000`0000>0020<00000`0000?00206@0000`0003oool0600000`0000000004P0000`000020000\n4`0000`000010000500000`0000=00005@0000`0000100005P0000`0000000003@00010000000000\n000003X0000<00002P0007P0000@000000000000000K000040000000000000008`000200000bVGho\n00000000002RUW`o0826@`00040T0000900003:IOSl0000000000::FO3l0P8I30000@0@0001c0000\n30000000000=0000400000d100020000DP00070100010000400000L00000000000000;`200000000\n1`828U<0N@1c07@0I@1]000000000000000000000000000000000000000000000000000000000000\n0000000000000=Xo0@000=3W4P3bj180000000000000000000000000000005400`00000000000000\n00000040000005401@00001>Y3ELia80YigkM`4Vn7Oooooo[>HB01@FCf1dia80YigkMi0Vn7Oooooo\nQ>LB05`A07P0054000000000YCD00000h72U=K1=Y3FDia80^?l0N50b0gSoooooX>LB080h=fb`ia80\n^?l0N50b0gSooooo_>LB080h=f`00:DeCK02H>1`YCDnCZ@eaE3hM`00LC54lA800@000=3W4P0dla80\n[<m5H040002hg4Ta^=a9<I154`000000I7H02000000U00003000004000160000:00001`00017A4U3\n0P00000000000000jP0004h0000000008@0000P0001R000030000040000T000090000000P3d00000\n00000000P3d0000000000080001O0000>0000080000h0000000003P000000000000100H000000000\n0000000000000000000002D0000<00000P0002D0000<00001@00P5L0000X0000<`4002P0001e0@00\n;00000<000210XT2MPJ90WH6T`8U0000300000L0080U000030000000080T000090000000P4400000\n00000000P440000000000080000X000030000080000T000090000000P3d0000000000000P3d00000\n00000080001O0000>0000080000h0000000003P00000000001810100000000000000000000000000\n000002D0000<00000P0002L0000H00000`00000000000000000002D0000<00000`0001<0000<0000\n0P0003/0000800006`000100001F1`00VP0003H0000@0000EPL001@1001H0000=000000000000000\nooooooooool60000EPLH0E<7705>1a`1B@LL0DD760551a@1=P00010000151`00VP0005P0000d0000\n00000000003oooooooooo`H000151iD0B@NA04h7T@1C1i40EPNE05H7VP0m0000200001/0000@0000\nEPL006X1000f0000400005H7003T0@00F00003@00000000000000?oooooooooo1P0005H7j05C1n`1\nCPO/0DT7k0551nP1A@OT0CH0000@0000A@L006X1001H0000=000000000000000ooooooooool60000\nA@MU0DT7HP5>1f81D`MR0EH7I@5F1fX1?@0000P0000K0000400005H7000j0P00=P000100001F1`00\n]08005P0000d000000000000003oooooooooo`H0001F1kP2D`Nl0Th7_0991k`2A@Nh0TD7]08f0000\n400004D7000j0P00F00003@00000000000000?oooooooooo1P0004D7=P991c82CPLb0U<7<P9F1cH2\nEPLj0Sd0000800006`000100001F1`002P<003H0000@0000EPL008@3001H0000=000000000000000\nooooooooool60000EPN90e<7S0=>1h`3B@N<0dD7R@=51h@3=P00010000151`002P<005P0000d0000\n00000000003oooooooooo`H000151`H3B@L20dh70P=C1`83EPL60eH72P<m0000200001/0000@0000\nEPL00=X3000f0000400005H7001D1000F00003@00000000000000?oooooooooo1P0005H7F@AC1e`4\nCPML14T7G0A51eT4A@MD13H0000@0000A@L00=X3001H0000=000000000000000ooooooooool60000\nA@OF0dT7dP=>1m83D`OB0eH7eP=F1mX3?@0000P0000K00004000070700201000=P000100003Y1`00\nP0@005P0000d000000000000003oooooooooo`H0003^1h04lPN41?87R@Cb1hh4kPNA1>T7T@@f0000\n40000707002A1000F00003@00000000000000?oooooooooo1P0006/7T@AW1hh4I`N916L7Q0A[1h04\nL0N013d0000800006`00010000102000P0@003H0000@0000^@P00804001H0000=000000000000000\nooooooooool60000_PR01<88Q0C228T4`PR>1;h8T@Bi2944=P00010000102000T@@005P0000d0000\n00000000003oooooooooo`H0000k2944=`R>13L8R@@g28@4>`R01408P0@m0000200001/0000@0000\n40T00804000f0000400008T900201000F00003@00000000000000?oooooooooo1P0008h9P0BB2H@4\nTPV91989SPB>2I44R@VA13H0000@000040T00944001H0000=000000000000000ooooooooool60000\n2`VA10L9SP@72HT41`V410/9P0@@2H04?@0000P0000K000040000>0900201000=P000100001I2P00\nP0@005P0000d000000000000003oooooooooo`H0001N2X04HPZ4168:R@AR2Xh4GPZA15T:T@@f0000\n40000>09002A1000F00003@00000000000000?oooooooooo1P000=/9T@CG2Hh4e`V91=L9Q0CK2H04\nh0V013d0000800006`000100002`2P00P0@003H0000@0000:@/00804001H0000=000000000000000\nooooooooool60000;P^0138;Q0@b2hT4<P^>12h;T@@Y2i44=P000100002`2P00T@@005P0000d0000\n00000000003oooooooooo`H0002[2Y44Y`Z>1:L:R@BW2X@4Z`Z01;0:P0@m0000200001/0000@0000\nP0/00804000f000040000?T;00201000F00003@00000000000000?oooooooooo1P000?h;P0@238@4\n0Pb9108<SPCn2i44n@^A13H0000@0000P0/00944001H0000=000000000000000ooooooooool60000\nN`^A17L;SPAg2hT4M`^417/;P0B02h04?@0000P0000K00004000050<00201000=P00010000393000\nP0@005P0000d000000000000003oooooooooo`H0003>3804dPb41=8<R@CB38h4cPbA1<T<T@@f0000\n4000050<002A1000F00003@00000000000000?oooooooooo1P0004/<T@A738h4A`b914L<Q0A;3804\nD0b013d0000800006`000100000P3@00P0@003H0000@0000V@d00804001H0000=000000000000000\nooooooooool60000WPf01:8=Q0BR3HT4XPf>19h=T@BI3I44=P000100000P3@00T@@005P0000d0000\n00000000003oooooooooo`H0000K3I445`f>11L=R@@G3H@46`f0120=P0@m0000200001/0000@0000\nl0d00804000f0000400006X>00201000F00003@00000000000000?oooooooooo1P0006h>P0Ab3X@4\nLPj9178>SPA^3Y44JPjA13H0000@0000l0d00944001H0000=000000000000000ooooooooool60000\nj`fA1>L=SPCW3HT4i`f41>/=P0C`3H04?@0000P0000K0000400007P>001:1000=P000100001h3P00\nd0<005P0000d000000000000003oooooooooo`H0001h3//3O0k80h4>b0>63/P3RPk;0hX>d0<f0000\n400008X>001:1000F00003@00000000000000?oooooooooo1P0008X>CPB63U84P@iB17`>DPAh3Th4\nN0i:13d0000800006`000100001h3P00NP<003H0000@0000N0h00003001H0000=000000000000000\nooooooooool60000N0kk0W`>m`:13_L2QPkg0XX>n`::3P03=P000100002:3P00NP<005P0000d0000\n00000000003oooooooooo`H0002:3Wh3QPj20h4>PP=l3X83N0in0gP>NP<m0000200001/0000@0000\nN0h00:T2000f0000400007P>000`0P00F00003@00000000000000?oooooooooo1P0007P>:`9l3RL2\nP@hW0XH>9`::3R/2RPh`0SH0000@0000RPh00:T2001H0000=000000000000000ooooooooool60000\nRPj^0XH>/P:13[82O0jb0WP>[P9h3ZT2?@0000P0000K0000400007P>003I0@00=P000100001h3P00\nH04005P0000d000000000000003oooooooooo`H0001h3U/1O0iG0H4>E`663UL1RPiK0HX>H04f0000\n400008X>003I0@00F00003@00000000000000?oooooooooo1P0008X>gP663^81P@kR0G`>hP5h3]h1\nN0kI0Cd0000800006`000100001h3P002@4003H0000@0000N0h00900001H0000=000000000000000\nooooooooool60000N0j;07`>Q`213XL0QPj708X>R`2:3Y00=P000100002:3P002@4005P0000d0000\n00000000003oooooooooo`H0002:3Ph1QPhB0H4>4P5l3Q81N0h>0GP>2@4m0000200001/0000@0000\n<@h00940000f000040000;P=002A0000F00003@00000000000000?oooooooooo1P000;<=T@2_3Hh0\n[`f90:l=Q02c3H00^0f003H0000@0000<@h00800001H0000=000000000000000ooooooooool60000\n=Pj003X>Q00j3XT0>Pj>03H>T@0a3Y40?@0000P0000K00004000064=002A0000=P000100003X3000\nT@0005P0000d000000000000003oooooooooo`H0003S3940g`b>0=l<R@3O38@0h`b00>P<P00f0000\n4000064=00200000F00003@00000000000000?oooooooooo1P0006H=P01Z3H@0JPf906X=SP1V3I40\nH@fA03d0000800006`000100002A3000T@0003H0000@000060`00940001H0000=000000000000000\nooooooooool600004`bA00l<SP0?38T03`b401<<P00H3800=P000100002A3000P00005P0000d0000\n00000000003oooooooooo`H0002F3800VPb409X<R@2J38h0UPbA094<T@0m0000200001/0000@0000\n`@/00940000f0000400004P;002A0000F00003@00000000000000?oooooooooo1P0004<;T@0o2hh0\n?`^903l;Q0132h00B0^003H0000@0000`@/00800001H0000=000000000000000ooooooooool60000\naP^00<X;Q03:2hT0bP^>0<H;T@312i40?@0000P0000K000040000?4:002A0000=P000100001h2P00\nT@0005P0000d000000000000003oooooooooo`H0001c2Y40K`Z>06l:R@1_2X@0L`Z007P:P00f0000\n40000?4:00200000F00003@00000000000000?oooooooooo1P000?H:P03j2X@0nPZ90?X:SP3f2Y40\nl@ZA03d0000800006`000100000Q2P00T@0003H0000@0000Z0T00940001H0000=000000000000000\nooooooooool60000X`VA09l9SP2O2HT0W`V40:<9P02X2H00=P000100000Q2P00P00005P0000d0000\n00000000003oooooooooo`H0000V2X00:PZ402X:R@0Z2Xh09PZA024:T@0m0000200001/0000@0000\nD@T00940000f000040000=P8002A0000F00003@00000000000000?oooooooooo1P000=<8T@3?28h0\nc`R90<l8Q03C2800f0R003H0000@0000D@T00800001H0000=000000000000000ooooooooool60000\nEPV005X9Q01J2HT0FPV>05H9T@1A2I40?@0000P0000K000040000848002A0000=P00010000072000\nT@0005P0000d000000000000003oooooooooo`H000032940o`N>0?l7R@3o1h@00`R000L8P00f0000\n4000084800200000F00003@00000000000000?oooooooooo1P0008H8P02:28@0RPR908X8SP262940\nP@RA03d0000800006`000100002a1`00T@0003H0000@0000CPL00940001H0000=000000000000000\nooooooooool60000B@NA04D7SP151hT0A@N404T7P01>1h00=P000100002a1`00P00005P0000d0000\n00000000003oooooooooo`H0002f1h00^@N40;T7R@2i1hh0]PNA0;47T@0m0000200003`000080000\n?`0001P0001o0@0020000?H1001<00004`0000`0000100009@0000`0000000209@0000`000070020\n900002@00000081100000000000008110000000000020000:00000`0000200004P0000`000010000\n600000`0000000005P0000`0000H0000DP00070100020000koooo`00000000000000090100000000\n1`040440LP1Y0640K0000000C@1_06h0K`1d07T0L01U03X0@@1b06T0H@1/0200DP1U06L0M@1/0640\nLP0j05H0I@000180=P000<0Yn7L005daZ11M<CH00018F?0g0@000040000005daZ7oh=jD1003Hh180\n><GlMkRdo7O?]?ag40000:@1000<B_`gl9oe=`00001hR_Dg0000093O4P0W0000`2WhM`00GC7H3Eda\n@:Ge=hPCm3MXga80P1P000004P2WWO]g22[hMoooooldhA80_[7lMmP=GC4000000000000000010000\n:Ich=n1IGC70>Uda0P000;0knCL00000R`[f@UEE2470TOPg0038@PR@n3LPCoXgN9_h=n1IGC5PQoDg\n0P00023P4P0<0000`2WhM`00GC7825daI7H02000000U000030000080001D0000H0000:d1000P0000\na04003800002000000000000002Q0000;P0000<0001<00000000000000000000oooooooooomD0000\nD01Y06h0000<000010000000000U000030000040000X0000300000<0000T000090000000P3d00000\n00000000P3d0000000000080000W0000600000<000000000`<300000000U0000300000<0000U0000\n300000P0081<0000I00007D1000P0000R@4003<000211P00j@4005D100100@008@3`000000000000\n0020?`00000000000020?`0000000000000000000000000000000000000000009@0000`000070020\n9@0000`000000020900002@00000081100000000000008110000000000020000900002@00000080m\n000000000000080m0000000000020000G`0003P000040000>0000000000h0000000000000@0A0000\n000000000000000000000000000U0000300000@0000U0000300000D0081F0000<00007<1000N0000\nS04003H000050000P@HY0mH7:@?F1nT1P@KY0H46:@<U0000300000L0080U000030000000080T0000\n90000000P440000000000000P440000000000080000X0000300000@0000T000090000000P3d00000\n00000000P3d0000000000080001O0000>00000@0000h0000000003P0000000000001014000000000\n0000000000000000000002D0000<0000100002D0000<00001@00P5L0000T0000>`4003`0001Z0@00\n@0000080000:0lT3]0G90bD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000\n0020@@00000000000P0002P0000<0000100002@0000T00000020?@00000000000020?@0000000000\n0P0005l0000h0000100003P000000000>0000000000000404@000000000000000000000000000000\n9@0000`0000400009@0000`000050020E`0002P0001Q0@00=`0006X1001400000`0006H54PBd1LT3\nIPF00bD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000\n0P0002P0000<000010000180000<00000@0001P0000<0000000001H0000<0000600002D0000<0000\n0P0005@0001D00003`4000H0000H0@00600000800000000000000080000C00000@0004`000000000\n00000000003ooooooooooe00001F0000000002D0000<00000@000180000<00000@0001P0000<0000\n000001H0000<0000600002D0000<00000P0005@0001D0000C`4000H0001F0@006000008000000000\n00000480000C00000@0004`00000000000000000003ooooooooooe00000[0000000002D0000<0000\n0@000180000<00000@0001P0000<0000000001H0000<0000600002D0000<00000P0005@0001D0000\n;P4003T0000_0@00B`0000800000000000000240001700000@0004`00000000000000000003ooooo\noooooe00001Y0000000002D0000<00000@0004H0000D0000200004M4BD<300008P0000`0003ooooo\n8P0000`0003ooooo9@0000`0000=0020:00000`0000100008P0000`0003noooo:00000`000020000\nAP000<`700301`00ADe6:bI0000@000010000000000U@000400000@000000000;40002@0000H0000\nc>M__P0008000020Km>O?M[iJd<b<l/o24011D`700101`000A30f`8000040000<0L00040001/0000\n0P0000@0003[0000B`00000000000000LaD009l7000PADe600010307000@00001000000000000000\n0000000400001@00l000040100000000000000000020Z@<00>8404H0000/0000800004E=AR/1@040\n7000010000014<3K0@000600001P0000AP000>00003D0000ADe6:c100P0@000010000000P3lO@0@0\n30000000000N@04030000000000M@000500000P0002fooooE`0001e0000D000020000:WooomG0000\n24000S`0000`00000A30f`00001>0000000000Se^3h200000P000080000200000A30f`000000003o\n24010c@0000X00000A30f`<000000000f28P@UDE8T;U/li2EADR@^FccT:aY2A2004101E00@0@0000\n1000000000160000=00002P00015CDH[2T00P2@0000H0000oooo00400005ZnU2EED8@FMViT;nogm2\nAP000;00002T0000ADe6:`Q000980000?000004@`=/00000CP4000000036]hXo0P00008000020000\n0P000080000000110020@04@`=/000000000o`Q00@=80000?000004@`=/50000000000F[jD:[2Y52\n]PQX@j/:TD:f26Q3EED8@@F[jD9EE@Q11J_Y@Z/:TD800@41P@0001E00@0@00001000000000160000\n^0000:`00015CDH[:T0002@0000H00009KoH@P0000000000<c?;@PF[jD9EE@Q124021S00000T0000\n0A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P5@0001800000000o`4000010000\n0`000500J@1^09IedShOg;Xn8;05?aoL^Sk;:Plo7mbj?P00P3l0000000000000P3l0000000000000\nAP000400000d0000ADe6:b]0000<0000000000Y0080T000060000<30`?l10000K17@@ZXZm46/ZZY1\n002P@DH0002T0000V00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`8000020000\n0P00008000014<3K000000000?l8@043B00003`000014<3K1@000000001/4M12EAE:@QNlnT9E5DY2\n5kcj@ZXZm45/4M12ZR[d@F`Ad49E5DY200410H40000E@040400000@000000000AP0008P0001l0000\nADe6:`Q0008l0000<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/00000\n0000o`Q00@</00008000004@`=/2000000000?Y4@T9E5G92dWNf@UDELT800@005D01010000040000\n000004H0002@0000Q00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`8000020000\n0P00008000014<3K000000000?l8@043=00002P000014<3K0`000000003V]Za2R2n2@]9g]T9E5G92\ni[J/@Y_;Gd800@405D01010000040000000004H0002T0000V00004E=AR/Z@000900001P0000U_mQ2\n00000000000c<l]2N]ZF`TZO=3h8@086<00002@000014<3KZjXZ?P0000000000000000D000110580\nB@1104`0000f@0:0@00003@00000003o0@00004000010000EP1P;3Ho5fa1?P00P3l0000000000000\nP3l0000000000000AP000800001d0000ADe6:b]0000<0000000002Y0000T0000600002Fof4800000\n000003<cbd9jfYK2BYld?SI00X100000=00000000?l100000@000040000[05j]YSlGK44n0020?`00\n000000000020?`000000000000160000/0000:@00015CDH[:d0000`000000000:T0002@0000H0000\n9KoH@P0000000000<c?;@P9SWl:O]51224021S00000T00000A30fj^Z:Sh000000000000000050000\n@@1B04T0@@1<0000=T02P400000d00000000o`40000100000@0006T0akf4?aM/@Ch0080o00000000\n0000080o00000000000004H0000L0000400004E=AR/[@0003000000000160000700001000015CDH[\n0T0000`0000000003P0001@000000000400001@0000J@050;0000200003ooooo0P00000000000000\n001[@`00WT800000j0?X0b4000080000HP0000`0000100008@0000P0001R000030000040000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000\n000100H0000000000000000000000000000002D0000<00000P0002D0000<00001@00P5L0000X0000\nP`0002P000360000;00000<0000o3:82BPRR0TX8[08U0000300000L0080U000030000000080T0000\n90000000P440000000000000P440000000000080000X000030000080000X0000300000<0000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n01810100000000000000000000000000000002D0000<00000`0002L0000H00000P00000000000000\n000002D0000<00000P0001<0000<00000P0003/0000800006`000100001Z1`00/`0003H0000@0000\nJPL002d1001H0000=000000000000000ooooooooool60000JPLb0Fh7=@5b1cD1M`Le0G/7<P5k1bd1\n=P000100001k1`00/`0005P0000d000000000000003oooooooooo`H0001k1jl0M`N[0787Z`1^1j/0\nJPN_06X7/`0m0000200001/0000@0000JPL008<1000f0000400006X7003m0@00F00003@000000000\n00000?oooooooooo1P0006X70P9^1`D2LPL50WL71@9k1`82N`Om0CH0000@0000N`L008<1001H0000\n=000000000000000ooooooooool60000N`Mo0GL7N`5b1g/1KPMk0FX7O`5Z1h<1?@0000P0000K0000\n400006X7001C0P00=P000100001Z1`00c@8005P0000d000000000000003oooooooooo`H0001Z1m82\nKPOE0W87e@9g1mD2N`OB0W/7c@8f0000400007/7001C0P00F00003@00000000000000?oooooooooo\n1P0007/7C`9g1d/2LPM;0Vh7B`9Z1dl2JPMC0Sd0000800006`000100001Z1`008`<003H0000@0000\nJPL009d3001H0000=000000000000000ooooooooool60000JPNQ0fh7Y@=b1jD3M`NU0g/7X@=k1id3\n=P000100001k1`008`<005P0000d000000000000003oooooooooo`H0001k1al3M`LK0g876`=^1a/3\nJPLO0fX78`<m0000200001/0000@0000JPL00?<3000f0000400006X7001]1000F00003@000000000\n00000?oooooooooo1P0006X7L@A^1gD4LPMe17L7M@Ak1g44N`M]13H0000@0000N`L00?<3001H0000\n=000000000000000ooooooooool60000N`O_0gL7j`=b1n/3KPO[0fX7k`=Z1o<3?@0000P0000K0000\n40000547002I1000=P000100003G1P00V@@005P0000d000000000000003oooooooooo`H0003B1YT4\nc`JM1<l6XPC?1ZH4dPJZ1=L6ZP@f000040000547002Z1000F00003@00000000000000?oooooooooo\n1P0005D7ZPAI1jH4F@NR15T7W@AE1iT4D@NI13d0000800006`00010000211P00V@@003H0000@0000\n1`H009T4001H0000=000000000000000ooooooooool600000PJI1?h5W@Cn1J84oPFV1086ZP@71ZX4\n=P00010000211P00ZP@005P0000d000000000000003oooooooooo`H000251ZX4R@JV18T6XPB91Yd4\nQ@JI1846V@@m0000200001/0000@0000/0D009T4000f0000400003L5002I1000F00003@000000000\n00000?oooooooooo1P000385V@@^1Id4;PFR12h5YP@b1JX4=`FZ13H0000@0000/0D00:X4001H0000\n=000000000000000ooooooooool60000]@FZ1;T5YPBi1J84^@FM1;D5V@B`1IT4?@0000P0000K0000\n40000>04002I1000=P000100001W1000V@@005P0000d000000000000003oooooooooo`H0001R19T4\nGPBM15h4XPAN1:H4HPBZ16L4ZP@f000040000>04002Z1000F00003@00000000000000?oooooooooo\n1P000>D4ZPCY1:H4j@BR1>T4W@CU19T4h0BI13d0000800006`000100000@1000V@@003H0000@0000\nU`<009T4001H0000=000000000000000ooooooooool60000TP>I18h3W@B>0j84SP>V1983ZPBG0jX4\n=P000100000@1000ZP@005P0000d000000000000003oooooooooo`H0000E1:X46@BV11T4XP@I19d4\n5@BI1104V@@m0000200001/0000@0000@0<009T4000f000040000<L2002I1000F00003@000000000\n00000?oooooooooo1P000<82V@Bn0Yd4_P:R1;h2YPC20ZX4a`:Z13H0000@0000@0<00:X4001H0000\n=000000000000000ooooooooool60000A@>Z14T3YPA90j84B@>M14D3V@A00iT4?@0000P0000K0000\n40000702002I1000=P000100003g0@00V@@005P0000d000000000000003oooooooooo`H0003b0IT4\nkP6M1>h1XPC^0JH4lP6Z1?L1ZP@f000040000702002Z1000F00003@00000000000000?oooooooooo\n1P0007D2ZPAi0ZH4N@:R17T2W@Ae0YT4L0:I13d0000800006`000100002P0@00V@@003H0000@0000\n9P4009T4001H0000=000000000000000ooooooooool600008P6I11h1W@@N0J847P6V1281ZP@V0JX4\n=P000100002P0@00ZP@005P0000d000000000000003oooooooooo`H0002U0JX4Z06V1:P1XPBX0Id4\nY@6I1:01V@@m0000200001/0000@0000d00009T4000f0000400005H0002I1000F00003@000000000\n00000?oooooooooo1P000540V@A>09d4CP2R14h0YPAA0:X4EP2Z13H0000@0000d0000:X4001H0000\n=000000000000000ooooooooool60000e02Z1=P0YPCH0:84f02M1=@0V@C@09T4?@0000P0000K0000\n400004L0001R1000=P00010000170000j@<005P0000d000000000000003oooooooooo`H000170>@3\nA03P0cl0h0<j0>03=P3T0cH0j@<f0000400003H0001R1000F00003@00000000000000?oooooooooo\n1P0003H0I`@j06/4?`1[14@0J`A706L4A`1R13d0000800006`00010000170000TP<003H0000@0000\nA`0001T3001H0000=000000000000000ooooooooool60000A`0D0d@040<o0103>P0@0cH050<f01T3\n=P000100000f0000TP<005P0000d000000000000003oooooooooo`H0000f09L3>P2K0cl0V`=409/3\nA`2G0dL0TP<m0000200001/0000@0000A`000<82000f0000400004L000190P00F00003@000000000\n00000?oooooooooo1P0004L0A0940442?`110SX0@@8f04@2=P190SH0000@0000=P000<82001H0000\n=000000000000000ooooooooool60000=P370SX0b`8o0</2A03;0TL0a`970<82?@0000P0000K0000\n400004L0003c0@00=P00010000170000N@4005P0000d000000000000003oooooooooo`H0001707@1\nA01a0Cl0L@4j0741=P1d0CH0N@4f0000400003H0003c0@00F00003@00000000000000?oooooooooo\n1P0003H0m`4j0?/1?`3k0D@0n`570?L1A`3c0Cd0000800006`000100001700008`4003H0000@0000\nA`000:T0001H0000=000000000000000ooooooooool60000A`2T04@0X@0o0:40>P2Q03H0Y00f0:T0\n=P000100000f00008`4005P0000d000000000000003oooooooooo`H0000f02L1>P0[0Cl0:`5402/1\nA`0W0DL08`4m0000200001/0000@0000SP000:/0000f0000400000P1002[0000F00003@000000000\n00000?oooooooooo1P0000d1Z`0@0JL0406R0101W@0=0IT0206I03H0000@0000SP0009T0001H0000\n=000000000000000ooooooooool60000RP2I08H0W@260:80QP2W08X0Z`2>0:/0?@0000P0000K0000\n400005l1002[0000=P000100003H0@00Z`0005P0000d000000000000003oooooooooo`H0003M0J/0\nh@6W0>41XP3Q0Id0g@6I0=P1V@0f0000400005l1002I0000F00003@00000000000000?oooooooooo\n1P0005X1V@1F0Id0EP6R05H1Y`1J0J/0G`6[03d0000800006`000100000_0P00Z`0003H0000@0000\nZ0800:/0001H0000=000000000000000ooooooooool60000[@:[0;42Y`2a0Z80/@:M0:d2V@2X0YT0\n=P000100000_0P00V@0005P0000d000000000000003oooooooooo`H0000Z0YT09P:M02H2XP0V0ZL0\n:P:[02l2Z`0m0000200001/0000@0000o`800:/0000f0000400007P3002[0000F00003@000000000\n00000?oooooooooo1P0007d3Z`210jL0P@>R0843W@1m0iT0N0>I03H0000@0000o`8009T0001H0000\n=000000000000000ooooooooool60000nP:I0?H2W@3f0Z80mP:W0?X2Z`3o0Z/0?@0000P0000K0000\n40000<l3002[0000=P00010000181000Z`0005P0000d000000000000003oooooooooo`H0001=1:/0\nD@BW0544XP1A19d0C@BI04P4V@0f000040000<l3002I0000F00003@00000000000000?oooooooooo\n1P000<X3V@360id0aP>R0<H3Y`3:0j/0c`>[03d0000800006`000100002O1000Z`0003H0000@0000\n60D00:/0001H0000=000000000000000ooooooooool600007@F[0245Y`0Q1J808@FM01d5V@0H1IT0\n=P000100002O1000V@0005P0000d000000000000003oooooooooo`H0002J19T0UPBM09H4XP2F1:L0\nVPB[09l4Z`0m0000200001/0000@0000K`D00:/0000f000040000>T5002[0000F00003@000000000\n00000?oooooooooo1P000>d5Z`3a1JL0l@FR0?45W@3]1IT0j@FI03H0000@0000K`D009T0001H0000\n=000000000000000ooooooooool60000JPFI06H5W@1V1J80IPFW06X5Z`1_1J/0?@0000P0000K0000\n400003l6002[0000=P000100002i1P00Z`0005P0000d000000000000003oooooooooo`H0002m1Z/0\n`@JW0<46XP311Yd0_@JI0;T6V@0f0000400003l6002I0000F00003@00000000000000?oooooooooo\n1P0003X6V@0g1Yd0=`JR03L6Y`0j1Z/0?`J[03d0000800006`000100000?1`00Z`0003H0000@0000\nLPL00:/0001H0000=000000000000000ooooooooool60000M`N[07/7Y`1k1j80N`NM07L7V@1b1iT0\n=P000100000?1`00V@0005P0000d000000000000003oooooooooo`H0000;1iT01`NM00L7XP071jL0\n2`N[00l7Z`0m0000200003`000080000?`0001P000010000200007X0001=00004`0000`000010000\n9@0000`0000000209@0000`000070020900002@00000081100000000000008110000000000020000\n:00000`0000300004P0000`000010000600000`0000000005P0000`0000H0000DP00070100030000\n4@00000000081`0020L00901000000001`040440LP1Y0640K0000000C@1_06h0K`1d07T0L01U03X0\n@@1b06T0H@1/0200DP1U06L0M@1/0640LP0j05H0I@000180=P000<0Yn7L005daZ11M<CH00018F?0g\n0@000040000005daZ7oh=jD1003Hh180><GlMkRdo7O?]?ag40000:@1000LAO`gV;LQ0040002H]b40\nN04C00dC003b]Oag000C0<ndo7L8`0000@P009QZ801Xga80P1P000004P2WWO]g22[hMoooooldhA80\n_[7lMmP=GC5hCal0N04C04064`010000:Ich=n1IGC70>Uda0P000;0knCL00000O@[f@TmE2470TOPg\n0038@PR@n3LPCoXgN9_h=n1IGC5PQoDgV6XP023P4P0<0000`2WhM`00GC7825daI7H02000000U0000\n300000<0001D0000H0000480000/0000FP0003`000010000082k@@00b45;0000;`0000<0001<0000\n0000000000000000oooooooooomD0000D01Y06h0ooodooooo?ooo`00000U0000300000d0080X0000\n30000080000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000\n`<300000000U000030000080000U0000300000P0081<0000I00006l0000P0000P`0003<0003Z1P00\n0P8005D100100@008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@0A0000000000000000000000000000000U000030000040000U0000\n300000D0081F0000<00006d0000N0000QP0003H000050000?`Q20nX6@P?Z1P82?`P20Sl8@P<U0000\n300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000\n30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000\n000003P00000000000010140000000000000000000000000000002D0000<00000@0002D0000<0000\n1@00P5L0000T0000S`0003`0002m0000@0000080002g2n8330WR0bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@0002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040\n4@0000000000000000000000000000009@0000`0000100009@0000`000050020E`0002P0002?0000\n>00009P0001500000`0005X9:`@<2N83FPVI0bD0000<00001`00P2D0000<00000000P2@0000T0000\n0020@@00000000000020@@00000000000P0002P0000<00000@000180000<00000@0001P0000<0000\n000001H0000<0000600002D0000<00000`0005@0001D0000h@000180003Z00008P0000400000P;]1\n0038@NX0000E00000@0004`00000000000000000003ooooooooooe00001F0000000002D0000<0000\n3@00P180000<00000@0001P0000<0000000001H0000<0000600002D0000<00000`0005@0001D0000\nXP000180002Z00008P0000400000P;]10038@JX0000E00000@0004`00000000000000000003ooooo\noooooe00000[0000000002D0000<00003@00P180000<00000@0001P0000<0000000001H0000<0000\n600002D0000<00000`0005@0001D0000b@0004H0003;0000EP0000400000P;]10038@L/000190000\n0@0004`00000000000000000003ooooooooooe00001Y0940000002D0000<00003@00P280000<0000\nooooob80000<0000ooooobP0000<00000`0004H000140000>00004E=AR/V@000400000@000000000\n2T00P2@0000H0000ooooo`40000Q/491;EfQ@Ag6_D81ZbE2:00000`0000200008@0000P0001R0000\n30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000\noooo0000000U000030000080000U0000300000P0081<0000I00000`0000D0000JP0003d000330000\n@`400>h5002G0P008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000AP000:@0002H0000ADe6:`Q00P8l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/00000ooooo`Q00`=80000?000004@`=/500000000026`@T6IFGI2\n8acF@YUIMT8S7=I2;EfQ@B6`@T4]GJ518K12@IUIMT800@41P@0001E00`0@000010000080000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n0001014000000000oooo000000000000000002D0000<00000`0002D0000<00001@00P5H0000`0000\n2P000180001]0000@00000D000330=X3/@KJ0k46@`7304<1``3J0bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000`0004H000300000\n]00004E=AR/Z@000900001P0000U_mQ200000000000c<l]28K12@BeMXD48@0@6<00002@000014<3K\nZjXZ?P0000000000000000D000110580B@1104`0000f@0B0G00005000000003o0@00004000040000\nL01Y06h0<@3;NHln<oF1?R3__ShcmH4nMNCA?S?ePCkU[00o<oF1?P00P3l0000000000000P3l00000\n00000180000<00000@0001P0000<0000000001H0000<000060000580001`0@000`000>ooool00000\n00000000002@0@00000000L010110780J@1Q06`0000004d0K`1^06l0M01i0700I@0j0440LP1Y0640\nK00P0580I@1W07D0K01Q0780>P1F06D0003ooooo00000000JbD0H>b8JP5Xh6T1`=Y[0CHM061Xh6T1\n`=Y[0@PN0630fV/100000000000F@`1P`=Y[0FSPJ@4HfV/1`61>H>S^4P1Xh6T14480H00000010000\n00000<3_4P3/ka80`=Y[0@3_4P0W?01P6=Y[0Nc_4P0000000@0003S_4P33?01P6=Y[0Nc_4P000000\nV=M[0B0K06000000V=M[0@00002n6P1Pi>lB0<3_4P0000000000063_4P3Q?`1Pi>lB000000010000\n<O<B0<3_4P000000n3Cj=`00002Hka803`000<0Yn7L005daF0UM<FAf00P000009@0000`000030000\nE00006@0000[00007`0004P0000a00000@000020^d400<Q1:`0002h000040000C000000000000000\n00000?ooooooooooE0000700J@1^03402P0000@0000:0000000002D0000<00003@00P4H000100000\n=00004E=AR/[@00030000000000:@020900001P0003ooooo0@0002_0d4<c/nQ10020@_ooad4T0000\n90000000P3d0000000000000P3d0000000000080000U000030000080000U0000300000P0081<0000\nI0000:81000M0000h@4003D0000H6P00dP400004002@0@008@3`0000000000000020?`0000000000\n0020?`0000000000000000000000000000000000000000009@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000AP000:@0002H0000ADe6:`Q00P8l0000\n<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/00000ooooo`Q00`=80000\n?000004@`=/50000000002_0d4>IFEQ2:l3`@iUIF48[`?13<k?X@B_0d4<c/nQ1:l3@@iUIF4800@41\nP@0001E00`0@000010000080000T000090000000P3d0000000000000P3d0000000000080001O0000\n>0000040000h0000000003P0000000000001014000000000oooo000000000000000002D0000<0000\n0@0002D0000<00001@00P5H0000`0000X04001/0003S0@00>00000D0000H6V8361iR0aPNdP4H6]81\n61YR0bD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000\n0P0002P0000<00000@0004H000300000]00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2\n:l3@@c>cj448@0@6<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0B0\nG00005000000003o0@00004000040000L01Y06h0<P1T1`dn:bla?PobJch[;c4nGNj8?R/_<CjbHkPn\n:bla?P00P3l0000000000000P3l0000000000180000<00000@0001P0000<0000000001H0000<0000\n600002D0000<00000`0005@0001T0000/0400200003?0@00<P0000400000P;]10038@K01000_0000\n100004`00000000000000000003ooooooooooe@0001`06T0KP0b00X0000400002P000000000U0000\n300000d008160000@00003@00015CDH[:d0000`0000000002T00P2@0000H0000ooooo`40001iXT=3\nVEUV@_3^KT9jN;Q1900002@00000080m000000000000080m00000000000200009@0000`000020000\n9@0000`000080020C00006@000340000>P000?h0001@0000>``009X3002k0`00L@400240l0000000\n00000000P3l0000000000000P3l0000000000000000000000000000000000000000002D0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0004H0002T0000\nV00004E=AR/8@082?000030000014<3K000004h000000000a[N:?`80000200000P00008000014<3K\n00000?ooool8@0<3B00003`000014<3K1@000000001iXT=3jdZQ@SENOd?[BZ52=Eio@iUIIT9iXT=3\nVEUV@WVR@d?[BZ5200410H40000E@0<0400000@000020000900002@00000080m000000000000080m\n0000000000020000G`0003P000010000>0000000000h0000000000000@0A000000000?ooo`000000\n00000000000U000030000040000U0000300000D0081F0000<0000<80000h00000@4005<000050000\n>``;1OH?2`Gf3iX3>`bJ0c/<2`DU0000300000L0080U000030000000080T000090000000P4400000\n00000000P440000000000080000X00003000004000160000Y00009P00015CDH[:T0002@0000H0000\n9KoH@P0000000000<c?;@WVR@d>IFFI224041S00000T00000A30fj^Z:Sh000000000000000050000\n@@1B04T0@@1<0000=T04P400000d00000000o`40000100000@0006T0RYn3?^IV9ch0080o00000000\n0000080o0000000000000180000<00000@0001P0000<0000000001H0000<0000600002D0000<0000\n0`0005@0001D0000g`0003/0003P0000C@0000400000P;]10038@Ml0001:00000@0004`000000000\n00000000003ooooooooooe00001Y0940000002D0000<00003@00P4H000100000=00004E=AR/[@000\n30000000000:@020900001P0003ooooo0@0003EN?d<6FiI0RXR8@W0Lad4T000090000000P3d00000\n00000000P3d0000000000080000U000030000080000U0000300000P0081<0000I0000;l000050000\n0`4001d0003f2`00C00004D4002>0@008@3`0000000000000020?`00000000000020?`0000000000\n000000000000000000000000000000009@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000AP000:@0002H0000ADe6:`Q00P8l0000<000004@`=/00000\nCP0000000036]hXo0P000080000200000P00004@`=/00000ooooo`Q00`=80000?000004@`=/50000\n000003EN?d<c/na1?M61@c>ck44mdH531U^F@3EN?d<6FiI0=Eho@c>ck4400@41P@0001E00`0@0000\n10000080000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000\n000003P0000000000001014000000000oooo000000000000000002D0000<00000@0002D0000<0000\n1@00P5H0000`0000_@0000<000060@00800000D0003f2mX1>a3J0C/@C03f2d`0mP_J0BD0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0@0004H0002T0000V00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2=Eho@`IKUT08@0@6\n<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0B0@00003@00000003o\n0@00004000010000EP0`cH@ne9l`?P00P3l0000000000000P3l00000000000004P0000`000010000\n600000`0000000005P0000`0000H00009@0000`000030000E00005@0003K00001`000>@0000I0000\n0@000020^d400<Q1f`0001H000010000C00000000000000000000?ooooooooooD00005H0`=/00000\n9@0000`0000=0020AP0001`0000@0000ADe6:b]0000<0000000004`0001T00000P000080003f0@00\nDP00008000020000m@400540000Y0:X0000000000000080o000000000000080o0000000000000000\n000000000000000000000000000R000030000?oooom60000700001000015CDH[0T0000`000000000\n3P0001@000000000400001@0\n"], "Text", Rule[ImageSize, List[501, 84]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell["Connecting two electrical pins. The connected voltages are equal, and the sum of the corrents is zero.", "NumberedFigure"]], Open]], Cell[CellGroupData[List[Cell["Mechanical Connections", "Section"], Cell[TextData[List["The ", StyleBox["filled", Rule[FontSlant, "Italic"]], " and ", StyleBox["non-filled", Rule[FontSlant, "Italic"]], " squares of a component represent ", StyleBox["mechanical flanges", Rule[FontSlant, "Italic"]], ". We connect these flanges using a ", StyleBox["connect", Rule[FontFamily, "Courier"]], " statement so that they form one node:"]], "Text"], Cell["class ConnectedFlanges\nModelica.Mechanics.Translational.Interfaces.Flange_a flange1,flange2;\nequation\nconnect (flange1, flange2); \nend ConnectedFlanges;", "ModelicaInput"], Cell[" ", "Text"], Cell[TextData[List["\nWhich connects the two flanges so that they form one node. This produces two equations, namely: ", StyleBox["flange1.s = flange2.s", Rule[FontFamily, "Courier"]], " and ", StyleBox["flange1.f + flange2.f = 0", Rule[FontFamily, "Courier"]], ".\n "]], "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0006a00@0006`0000100000P000?H1001F0000\n00000000000a;P005@P00215CDH00040@6`00?h200050000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH00006000016000060P000`80015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D000020000100001Z00007D0001@0000800000@0006X0000Q@0L030000000000U@000\n400000@000000000;40002@0000H0000b^M_?P0008000020Km>O?JM6QT<b<l/o24001D`700101`00\n0A30f`8000040000<0L00040001/00000P0000@0003[0000B`00000000000000LaD009l7000PADe6\n00010307000@000010000000000000000000000400001@00l000040100000000000000000020Z@<0\n0>8404H0000/0000800004E=AR/1@0407000010000014<3K0@000600001P0000AP000>00003D0000\nADe6:c100P0@000010000000P3lO@0@030000000000N@04030000000000M@000500000P0002foooo\nE`0001e0000D000020000:WooomG000024000S`0000`00000A30f`00001>0000000000Se^3h20000\n0P000080000200000A30f`000000003o24010c@0000X00000A30f`<000000000f28P@UDE8T;U/li2\nEADR@^FccT:aY2A2004101E00@0@00001000000000160000=00002P00015CDH[2T00P2@0000H0000\noooo00400005ZnU2EED8@FMViT;nogm2AP000;00002T0000ADe6:`Q000980000?000004@`=/00000\nCP4000000036]hXo0P000080000200000P000080000000110020@04@`=/000000000o`Q00@=80000\n?000004@`=/50000000000F[jD:[2Y52]PQX@j/:TD:f26Q3EED8@@F[jD9EE@Q11J_Y@Z/:TD800@41\nP@0001E00@0@00001000000000160000^0000:`00015CDH[:T0002@0000H00009KoH@P0000000000\n<c?;@PF[jD9EE@Q124021S00000T00000A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000\n=T02P5@0001800000000o`40000100000`000500J@1^09IedShOg;Xn8;05?aoL^Sk;:Plo7mbj?P00\nP3l0000000000000P3l0000000000000AP000400000d0000ADe6:b]0000<0000000000Y0080T0000\n60000<30`?l10000K17@@ZXZm46/ZZY1002P@DH0002T0000V00004E=AR/8@002?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043B00003`000014<3K\n1@000000001/4M12EAE:@QNlnT9E5DY25kcj@ZXZm45/4M12ZR[d@F`Ad49E5DY200410H40000E@040\n400000@000000000AP0008P0001l0000ADe6:`Q0008l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/000000000o`Q00@</00008000004@`=/2000000000?Y4@T9E5G92\ndWNf@UDELT800@005D01010000040000000004H0002@0000Q00004E=AR/8@002?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`000000003V]Za2R2n2@]9g]T9E5G92i[J/@Y_;Gd800@405D01010000040000000004H0002T0000\nV00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2N]ZF`TZO=3h8@086<00002@000014<3K\nZjXZ?P0000000000000000D000110580B@1104`0000f@0:0@00003@00000003o0@00004000010000\nEP1P;3Ho5fa1?P00P3l0000000000000P3l0000000000000AP000800001d0000ADe6:b]0000<0000\n000002Y0000T0000600002Fof4800000000003<cbd9jfYK2BYld?SI00X100000=00000000?l10000\n0@000040000[05j]YSlGK44n0020?`00000000000020?`000000000000160000/0000:@00015CDH[\n:d0000`000000000:T0002@0000H00009KoH@P0000000000<c?;@P9SWl:O]51224021S00000T0000\n0A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P400000d00000000o`4000010000\n0@0006T0akf4?aM/@Ch0080o000000000000080o00000000000004H0000L0000400004E=AR/[@000\n3000000000160000700001000015CDH[0T0000`0000000003P0001@000000000400001@0000J@010\n;0000200003ooooo0P00000000000000001[@`00WT800000j0?X0b4000080000HP0000`000010000\n8@0000P0000Q0000200007<0000<0000000001`0000800009@0000`0000000209@0000`000070020\n9@0000`0000>0020<00000`0000?00206@0000`0003oool0600000`0000000004P0000`000020000\n4`0000`000010000500000`0000=00005@0000`0000100005P0000`0000000003@00010000000000\n000003X0000<00002P0007P0000@000000000000000K000040000000000000008`000200000bVGho\n00000000002RUW`o0826@`00040T0000900003:IOSl0000000000::FO3l0P8I30000@0@0001c0000\n30000000000=0000400000d100020000DP00070100010000400000L00000000000000;`200000000\n1`828U<0N@1c07@0I@1]000000000000000000000000000000000000000000000000000000000000\n0000000000000=To0@000=3W4P3bj180000000000000000000000000000005400`00000000000000\n00000040000005401@00000RXcELia80YigkM`4Vn7Oooooo[>HB01@FCf1dia80YigkMi0Vn7Oooooo\nQ>LB05`A07P0054000000000ZCD000002<RY=A1ZYCFDia80^?l0N50b0gSoooooX>LB080h=fb`ia80\n^?l0N50b0gSooooo_>LB080h=f`00:TeCK02H0S8ZCFNJZDeaE3hM`00LC54lA800@000=3W4P0dla80\n[<m5H?oooonhg4Ta^=a9<I154`3HJJDeI7H02000000U00003000004000160000:00001`00017A4U3\n0P00000000000000jP0004h0000000008@0000P0001R000030000040000T000090000000P3d00000\n00000000P3d0000000000080001O0000>0000080000h0000000003P000000000000100H000000000\n0000000000000000000002D0000<00000P0002D0000<00001@00P5L0000X0000<`4002P0001e0@00\n;00000<000210XT2MPJ90WH6T`8U0000300000L0080U000030000000080T000090000000P4400000\n00000000P440000000000080000X000030000080000T000090000000P3d0000000000000P3d00000\n00000080001O0000>0000080000h0000000003P00000000001810100000000000000000000000000\n000002D0000<00000P0002L0000H00000`00000000000000000002D0000<00000`0001<0000<0000\n0P0003/0000800006`000100001F1`00VP0003H0000@0000EPL001@1001H0000=000000000000000\nooooooooool60000EPLH0E<7705>1a`1B@LL0DD760551a@1=P00010000151`00VP0005P0000d0000\n00000000003oooooooooo`H000151iD0B@NA04h7T@1C1i40EPNE05H7VP0m0000200001/0000@0000\nEPL006X1000f0000400005H7003T0@00F00003@00000000000000?oooooooooo1P0005H7j05C1n`1\nCPO/0DT7k0551nP1A@OT0CH0000@0000A@L006X1001H0000=000000000000000ooooooooool60000\nA@MU0DT7HP5>1f81D`MR0EH7I@5F1fX1?@0000P0000K0000400005H7000j0P00=P000100001F1`00\n]08005P0000d000000000000003oooooooooo`H0001F1kP2D`Nl0Th7_0991k`2A@Nh0TD7]08f0000\n400004D7000j0P00F00003@00000000000000?oooooooooo1P0004D7=P991c82CPLb0U<7<P9F1cH2\nEPLj0Sd0000800006`000100001F1`002P<003H0000@0000EPL008@3001H0000=000000000000000\nooooooooool60000EPN90e<7S0=>1h`3B@N<0dD7R@=51h@3=P00010000151`002P<005P0000d0000\n00000000003oooooooooo`H000151`H3B@L20dh70P=C1`83EPL60eH72P<m0000200001/0000@0000\nEPL00=X3000f0000400005H7001D1000F00003@00000000000000?oooooooooo1P0005H7F@AC1e`4\nCPML14T7G0A51eT4A@MD13H0000@0000A@L00=X3001H0000=000000000000000ooooooooool60000\nA@OF0dT7dP=>1m83D`OB0eH7eP=F1mX3?@0000P0000K00004000070700201000=P000100003Y1`00\nP0@005P0000d000000000000003oooooooooo`H0003^1h04lPN41?87R@Cb1hh4kPNA1>T7T@@f0000\n40000707002A1000F00003@00000000000000?oooooooooo1P0006/7T@AW1hh4I`N916L7Q0A[1h04\nL0N013d0000800006`00010000102000P0@003H0000@0000^@P00804001H0000=000000000000000\nooooooooool60000_PR01<88Q0C228T4`PR>1;h8T@Bi2944=P00010000102000T@@005P0000d0000\n00000000003oooooooooo`H0000k2944=`R>13L8R@@g28@4>`R01408P0@m0000200001/0000@0000\n40T00804000f0000400008T900201000F00003@00000000000000?oooooooooo1P0008h9P0BB2H@4\nTPV91989SPB>2I44R@VA13H0000@000040T00944001H0000=000000000000000ooooooooool60000\n2`VA10L9SP@72HT41`V410/9P0@@2H04?@0000P0000K000040000>0900201000=P000100001I2P00\nP0@005P0000d000000000000003oooooooooo`H0001N2X04HPZ4168:R@AR2Xh4GPZA15T:T@@f0000\n40000>09002A1000F00003@00000000000000?oooooooooo1P000=/9T@CG2Hh4e`V91=L9Q0CK2H04\nh0V013d0000800006`000100002`2P00P0@003H0000@0000:@/00804001H0000=000000000000000\nooooooooool60000;P^0138;Q0@b2hT4<P^>12h;T@@Y2i44=P000100002`2P00T@@005P0000d0000\n00000000003oooooooooo`H0002[2Y44Y`Z>1:L:R@BW2X@4Z`Z01;0:P0@m0000200001/0000@0000\nP0/00804000f000040000?T;00201000F00003@00000000000000?oooooooooo1P000?h;P0@238@4\n0Pb9108<SPCn2i44n@^A13H0000@0000P0/00944001H0000=000000000000000ooooooooool60000\nN`^A17L;SPAg2hT4M`^417/;P0B02h04?@0000P0000K00004000050<00201000=P00010000393000\nP0@005P0000d000000000000003oooooooooo`H0003>3804dPb41=8<R@CB38h4cPbA1<T<T@@f0000\n4000050<002A1000F00003@00000000000000?oooooooooo1P0004/<T@A738h4A`b914L<Q0A;3804\nD0b013d0000800006`000100000P3@00P0@003H0000@0000V@d00804001H0000=000000000000000\nooooooooool60000WPf01:8=Q0BR3HT4XPf>19h=T@BI3I44=P000100000P3@00T@@005P0000d0000\n00000000003oooooooooo`H0000K3I445`f>11L=R@@G3H@46`f0120=P0@m0000200001/0000@0000\nl0d00804000f0000400006X>00201000F00003@00000000000000?oooooooooo1P0006h>P0Ab3X@4\nLPj9178>SPA^3Y44JPjA13H0000@0000l0d00944001H0000=000000000000000ooooooooool60000\nj`fA1>L=SPCW3HT4i`f41>/=P0C`3H04?@0000P0000K0000400007P>001:1000=P000100001h3P00\nd0<005P0000d000000000000003oooooooooo`H0001h3//3O0k80h4>b0>63/P3RPk;0hX>d0<f0000\n400008X>001:1000F00003@00000000000000?oooooooooo1P0008X>CPB63U84P@iB17`>DPAh3Th4\nN0i:13d0000800006`000100001h3P00NP<003H0000@0000N0h00003001H0000=000000000000000\nooooooooool60000N0kk0W`>m`:13_L2QPkg0XX>n`::3P03=P000100002:3P00NP<005P0000d0000\n00000000003oooooooooo`H0002:3Wh3QPj20h4>PP=l3X83N0in0gP>NP<m0000200001/0000@0000\nN0h00:T2000f0000400007P>000`0P00F00003@00000000000000?oooooooooo1P0007P>:`9l3RL2\nP@hW0XH>9`::3R/2RPh`0SH0000@0000RPh00:T2001H0000=000000000000000ooooooooool60000\nRPj^0XH>/P:13[82O0jb0WP>[P9h3ZT2?@0000P0000K0000400007P>003I0@00=P000100001h3P00\nH04005P0000d000000000000003oooooooooo`H0001h3U/1O0iG0H4>E`663UL1RPiK0HX>H04f0000\n400008X>003I0@00F00003@00000000000000?oooooooooo1P0008X>gP663^81P@kR0G`>hP5h3]h1\nN0kI0Cd0000800006`000100001h3P002@4003H0000@0000N0h00900001H0000=000000000000000\nooooooooool60000N0j;07`>Q`213XL0QPj708X>R`2:3Y00=P000100002:3P002@4005P0000d0000\n00000000003oooooooooo`H0002:3Ph1QPhB0H4>4P5l3Q81N0h>0GP>2@4m0000200001/0000@0000\n<@h00940000f000040000;P=002A0000F00003@00000000000000?oooooooooo1P000;<=T@2_3Hh0\n[`f90:l=Q02c3H00^0f003H0000@0000<@h00800001H0000=000000000000000ooooooooool60000\n=Pj003X>Q00j3XT0>Pj>03H>T@0a3Y40?@0000P0000K00004000064=002A0000=P000100003X3000\nT@0005P0000d000000000000003oooooooooo`H0003S3940g`b>0=l<R@3O38@0h`b00>P<P00f0000\n4000064=00200000F00003@00000000000000?oooooooooo1P0006H=P01Z3H@0JPf906X=SP1V3I40\nH@fA03d0000800006`000100002A3000T@0003H0000@000060`00940001H0000=000000000000000\nooooooooool600004`bA00l<SP0?38T03`b401<<P00H3800=P000100002A3000P00005P0000d0000\n00000000003oooooooooo`H0002F3800VPb409X<R@2J38h0UPbA094<T@0m0000200001/0000@0000\n`@/00940000f0000400004P;002A0000F00003@00000000000000?oooooooooo1P0004<;T@0o2hh0\n?`^903l;Q0132h00B0^003H0000@0000`@/00800001H0000=000000000000000ooooooooool60000\naP^00<X;Q03:2hT0bP^>0<H;T@312i40?@0000P0000K000040000?4:002A0000=P000100001h2P00\nT@0005P0000d000000000000003oooooooooo`H0001c2Y40K`Z>06l:R@1_2X@0L`Z007P:P00f0000\n40000?4:00200000F00003@00000000000000?oooooooooo1P000?H:P03j2X@0nPZ90?X:SP3f2Y40\nl@ZA03d0000800006`000100000Q2P00T@0003H0000@0000Z0T00940001H0000=000000000000000\nooooooooool60000X`VA09l9SP2O2HT0W`V40:<9P02X2H00=P000100000Q2P00P00005P0000d0000\n00000000003oooooooooo`H0000V2X00:PZ402X:R@0Z2Xh09PZA024:T@0m0000200001/0000@0000\nD@T00940000f000040000=P8002A0000F00003@00000000000000?oooooooooo1P000=<8T@3?28h0\nc`R90<l8Q03C2800f0R003H0000@0000D@T00800001H0000=000000000000000ooooooooool60000\nEPV005X9Q01J2HT0FPV>05H9T@1A2I40?@0000P0000K000040000848002A0000=P00010000072000\nT@0005P0000d000000000000003oooooooooo`H000032940o`N>0?l7R@3o1h@00`R000L8P00f0000\n4000084800200000F00003@00000000000000?oooooooooo1P0008H8P02:28@0RPR908X8SP262940\nP@RA03d0000800006`000100002a1`00T@0003H0000@0000CPL00940001H0000=000000000000000\nooooooooool60000B@NA04D7SP151hT0A@N404T7P01>1h00=P000100002a1`00P00005P0000d0000\n00000000003oooooooooo`H0002f1h00^@N40;T7R@2i1hh0]PNA0;47T@0m0000200003`000080000\n?`0001P0001o0@0020000?H1001<00004`0000`0000100009@0000`0000000209@0000`000070020\n900002@00000081100000000000008110000000000020000:00000`0000200004P0000`000010000\n600000`0000000005P0000`0000H0000DP00070100020000koooo`00000000000000090100000000\n1`040440LP1Y0640K0000000C@1_06h0K`1d07T0L01U03X0@@1b06T0H@1/0200DP1U06L0M@1/0640\nLP0j05H0I@000180=P000<0Yn7L005daZ11M<CH00018F?0g0@000040000005daZ7oh=jD1003Hh180\n><GlMkRdo7O?]?ag40000:@1003DB?`g:9ch=`00001hR_Dg0000093O4P0W0000`2WhM`00GC7H3Eda\n/3?i=hPCm3MXga8001P000004P2WWO]g22[hMoooooldhA80_[7lMmP=GC4000000000000000010000\nlIoe=n1IGC7`?OXg0P000;0knCL00000R`[f@UEE2470TOPg0038@PR@n3LPCoXgN9_h=n1IGC5PQoDg\n0P00023P4P0<0000`2WhM`00GC7825daI7H02000000U000030000080001D0000H0000:d1000P0000\na04003800002000000000000002Q0000;P0000<0001<00000000000000000000oooooooooomD0000\nD01Y06h0akd<000010000000000U000030000040000X0000300000<0000T000090000000P3d00000\n00000000P3d0000000000080000W0000600000<000000000`<300000000U0000300000<0000U0000\n300000P0081<0000I00007D1000P0000R@4003<000211P00j@4005D100100@008@3`000000000000\n0020?`00000000000020?`0000000000000000000000000000000000000000009@0000`000070020\n9@0000`000000020900002@00000081100000000000008110000000000020000900002@00000080m\n000000000000080m0000000000020000G`0003P000040000>0000000000h0000000000000@0A0000\n000000000000000000000000000U0000300000@0000U0000300000D0081F0000<00007<1000N0000\nS04003H000050000P@HY0mH7:@?F1nT1P@KY0H46:@<U0000300000L0080U000030000000080T0000\n90000000P440000000000000P440000000000080000X0000300000@0000T000090000000P3d00000\n00000000P3d0000000000080001O0000>00000@0000h0000000003P0000000000001014000000000\n0000000000000000000002D0000<0000100002D0000<00001@00P5L0000T0000>`4003`0001Z0@00\n@0000080000:0lT3]0G90bD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000\n0020@@00000000000P0002P0000<0000100002@0000T00000020?@00000000000020?@0000000000\n0P0005l0000h0000100003P000000000>0000000000000404@000000000000000000000000000000\n9@0000`0000400009@0000`000050020E`0002P0001Q0@00=`0006X1001400000`0006H54PBd1LT3\nIPF00bD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000\n0P0002P0000<000010000180000<00000@0001P0000<0000000001H0000<0000600002D0000<0000\n0P0005@0001D00003`4000H0000H0@00600000800000000000000080000C00000@0004`000000000\n00000000003ooooooooooe00001F0000000002D0000<00000@000180000<00000@0001P0000<0000\n000001H0000<0000600002D0000<00000P0005@0001D0000C`4000H0001F0@006000008000000000\n00000480000C00000@0004`00000000000000000003ooooooooooe00000[0000000002D0000<0000\n0@000180000<00000@0001P0000<0000000001H0000<0000600002D0000<00000P0005@0001D0000\n;P4003T0000_0@00B`0000800000000000000240001700000@0004`00000000000000000003ooooo\noooooe00001Y0000000002D0000<00000@0004H0000D0000200004M4BD<300008P0000`0003ooooo\n8P0000`0003ooooo9@0000`0000=0020:00000`0000100008P0000`0003noooo:00000`000020000\nAP000<`700301`00ADe6:bI0000@000010000000000U@000400000@000000000;40002@0000H0000\nc>M__P0008000020Km>O?M[iJd<b<l/o24011D`700101`000A30f`8000040000<0L00040001/0000\n0P0000@0003[0000B`00000000000000LaD009l7000PADe600010307000@00001000000000000000\n0000000400001@00l000040100000000000000000020Z@<00>8404H0000/0000800004E=AR/1@040\n7000010000014<3K0@000600001P0000AP000>00003D0000ADe6:c100P0@000010000000P3lO@0@0\n30000000000N@04030000000000M@000500000P0002fooooE`0001e0000D000020000:WooomG0000\n24000S`0000`00000A30f`00001>0000000000Se^3h200000P000080000200000A30f`000000003o\n24010c@0000X00000A30f`<000000000f28P@UDE8T;U/li2EADR@^FccT:aY2A2004101E00@0@0000\n1000000000160000=00002P00015CDH[2T00P2@0000H0000oooo00400005ZnU2EED8@FMViT;nogm2\nAP000;00002T0000ADe6:`Q000980000?000004@`=/00000CP4000000036]hXo0P00008000020000\n0P000080000000110020@04@`=/000000000o`Q00@=80000?000004@`=/50000000000F[jD:[2Y52\n]PQX@j/:TD:f26Q3EED8@@F[jD9EE@Q11J_Y@Z/:TD800@41P@0001E00@0@00001000000000160000\n^0000:`00015CDH[:T0002@0000H00009KoH@P0000000000<c?;@PF[jD9EE@Q124021S00000T0000\n0A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P5@0001800000000o`4000010000\n0`000500J@1^09IedShOg;Xn8;05?aoL^Sk;:Plo7mbj?P00P3l0000000000000P3l0000000000000\nAP000400000d0000ADe6:b]0000<0000000000Y0080T000060000<30`?l10000K17@@ZXZm46/ZZY1\n002P@DH0002T0000V00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`8000020000\n0P00008000014<3K000000000?l8@043B00003`000014<3K1@000000001/4M12EAE:@QNlnT9E5DY2\n5kcj@ZXZm45/4M12ZR[d@F`Ad49E5DY200410H40000E@040400000@000000000AP0008P0001l0000\nADe6:`Q0008l0000<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/00000\n0000o`Q00@</00008000004@`=/2000000000?Y4@T9E5G92dWNf@UDELT800@005D01010000040000\n000004H0002@0000Q00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`8000020000\n0P00008000014<3K000000000?l8@043=00002P000014<3K0`000000003V]Za2R2n2@]9g]T9E5G92\ni[J/@Y_;Gd800@405D01010000040000000004H0002T0000V00004E=AR/Z@000900001P0000U_mQ2\n00000000000c<l]2N]ZF`TZO=3h8@086<00002@000014<3KZjXZ?P0000000000000000D000110580\nB@1104`0000f@0:0@00003@00000003o0@00004000010000EP1P;3Ho5fa1?P00P3l0000000000000\nP3l0000000000000AP000800001d0000ADe6:b]0000<0000000002Y0000T0000600002Fof4800000\n000003<cbd9jfYK2BYld?SI00X100000=00000000?l100000@000040000[05j]YSlGK44n0020?`00\n000000000020?`000000000000160000/0000:@00015CDH[:d0000`000000000:T0002@0000H0000\n9KoH@P0000000000<c?;@P9SWl:O]51224021S00000T00000A30fj^Z:Sh000000000000000050000\n@@1B04T0@@1<0000=T02P400000d00000000o`40000100000@0006T0akf4?aM/@Ch0080o00000000\n0000080o00000000000004H0000L0000400004E=AR/[@0003000000000160000700001000015CDH[\n0T0000`0000000003P0001@000000000400001@0000J@050;0000200003ooooo0P00000000000000\n001[@`00WT800000j0?X0b4000080000HP0000`0000100008@0000P0001R000030000040000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>0000080000h0000000003P000000000\n000100H0000000000000000000000000000002D0000<00000P0002D0000<00001@00P5L0000X0000\nP`0002P000360000;00000<0000o3:82BPRR0TX8[08U0000300000L0080U000030000000080T0000\n90000000P440000000000000P440000000000080000X000030000080000X0000300000<0000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n01810100000000000000000000000000000002D0000<00000`0002L0000H00000P00000000000000\n000002D0000<00000P0001<0000<00000P0003/0000800006`000100001Z1`00/`0003H0000@0000\nJPL002d1001H0000=000000000000000ooooooooool60000JPLb0Fh7=@5b1cD1M`Le0G/7<P5k1bd1\n=P000100001k1`00/`0005P0000d000000000000003oooooooooo`H0001k1jl0M`N[0787Z`1^1j/0\nJPN_06X7/`0m0000200001/0000@0000JPL008<1000f0000400006X7003m0@00F00003@000000000\n00000?oooooooooo1P0006X70P9^1`D2LPL50WL71@9k1`82N`Om0CH0000@0000N`L008<1001H0000\n=000000000000000ooooooooool60000N`Mo0GL7N`5b1g/1KPMk0FX7O`5Z1h<1?@0000P0000K0000\n400006X7001C0P00=P000100001Z1`00c@8005P0000d000000000000003oooooooooo`H0001Z1m82\nKPOE0W87e@9g1mD2N`OB0W/7c@8f0000400007/7001C0P00F00003@00000000000000?oooooooooo\n1P0007/7C`9g1d/2LPM;0Vh7B`9Z1dl2JPMC0Sd0000800006`000100001Z1`008`<003H0000@0000\nJPL009d3001H0000=000000000000000ooooooooool60000JPNQ0fh7Y@=b1jD3M`NU0g/7X@=k1id3\n=P000100001k1`008`<005P0000d000000000000003oooooooooo`H0001k1al3M`LK0g876`=^1a/3\nJPLO0fX78`<m0000200001/0000@0000JPL00?<3000f0000400006X7001]1000F00003@000000000\n00000?oooooooooo1P0006X7L@A^1gD4LPMe17L7M@Ak1g44N`M]13H0000@0000N`L00?<3001H0000\n=000000000000000ooooooooool60000N`O_0gL7j`=b1n/3KPO[0fX7k`=Z1o<3?@0000P0000K0000\n40000547002I1000=P000100003G1P00V@@005P0000d000000000000003oooooooooo`H0003B1YT4\nc`JM1<l6XPC?1ZH4dPJZ1=L6ZP@f000040000547002Z1000F00003@00000000000000?oooooooooo\n1P0005D7ZPAI1jH4F@NR15T7W@AE1iT4D@NI13d0000800006`00010000211P00V@@003H0000@0000\n1`H009T4001H0000=000000000000000ooooooooool600000PJI1?h5W@Cn1J84oPFV1086ZP@71ZX4\n=P00010000211P00ZP@005P0000d000000000000003oooooooooo`H000251ZX4R@JV18T6XPB91Yd4\nQ@JI1846V@@m0000200001/0000@0000/0D009T4000f0000400003L5002I1000F00003@000000000\n00000?oooooooooo1P000385V@@^1Id4;PFR12h5YP@b1JX4=`FZ13H0000@0000/0D00:X4001H0000\n=000000000000000ooooooooool60000]@FZ1;T5YPBi1J84^@FM1;D5V@B`1IT4?@0000P0000K0000\n40000>04002I1000=P000100001W1000V@@005P0000d000000000000003oooooooooo`H0001R19T4\nGPBM15h4XPAN1:H4HPBZ16L4ZP@f000040000>04002Z1000F00003@00000000000000?oooooooooo\n1P000>D4ZPCY1:H4j@BR1>T4W@CU19T4h0BI13d0000800006`000100000@1000V@@003H0000@0000\nU`<009T4001H0000=000000000000000ooooooooool60000TP>I18h3W@B>0j84SP>V1983ZPBG0jX4\n=P000100000@1000ZP@005P0000d000000000000003oooooooooo`H0000E1:X46@BV11T4XP@I19d4\n5@BI1104V@@m0000200001/0000@0000@0<009T4000f000040000<L2002I1000F00003@000000000\n00000?oooooooooo1P000<82V@Bn0Yd4_P:R1;h2YPC20ZX4a`:Z13H0000@0000@0<00:X4001H0000\n=000000000000000ooooooooool60000A@>Z14T3YPA90j84B@>M14D3V@A00iT4?@0000P0000K0000\n40000702002I1000=P000100003g0@00V@@005P0000d000000000000003oooooooooo`H0003b0IT4\nkP6M1>h1XPC^0JH4lP6Z1?L1ZP@f000040000702002Z1000F00003@00000000000000?oooooooooo\n1P0007D2ZPAi0ZH4N@:R17T2W@Ae0YT4L0:I13d0000800006`000100002P0@00V@@003H0000@0000\n9P4009T4001H0000=000000000000000ooooooooool600008P6I11h1W@@N0J847P6V1281ZP@V0JX4\n=P000100002P0@00ZP@005P0000d000000000000003oooooooooo`H0002U0JX4Z06V1:P1XPBX0Id4\nY@6I1:01V@@m0000200001/0000@0000d00009T4000f0000400005H0002I1000F00003@000000000\n00000?oooooooooo1P000540V@A>09d4CP2R14h0YPAA0:X4EP2Z13H0000@0000d0000:X4001H0000\n=000000000000000ooooooooool60000e02Z1=P0YPCH0:84f02M1=@0V@C@09T4?@0000P0000K0000\n400004L0001R1000=P00010000170000j@<005P0000d000000000000003oooooooooo`H000170>@3\nA03P0cl0h0<j0>03=P3T0cH0j@<f0000400003H0001R1000F00003@00000000000000?oooooooooo\n1P0003H0I`@j06/4?`1[14@0J`A706L4A`1R13d0000800006`00010000170000TP<003H0000@0000\nA`0001T3001H0000=000000000000000ooooooooool60000A`0D0d@040<o0103>P0@0cH050<f01T3\n=P000100000f0000TP<005P0000d000000000000003oooooooooo`H0000f09L3>P2K0cl0V`=409/3\nA`2G0dL0TP<m0000200001/0000@0000A`000<82000f0000400004L000190P00F00003@000000000\n00000?oooooooooo1P0004L0A0940442?`110SX0@@8f04@2=P190SH0000@0000=P000<82001H0000\n=000000000000000ooooooooool60000=P370SX0b`8o0</2A03;0TL0a`970<82?@0000P0000K0000\n400004L0003c0@00=P00010000170000N@4005P0000d000000000000003oooooooooo`H0001707@1\nA01a0Cl0L@4j0741=P1d0CH0N@4f0000400003H0003c0@00F00003@00000000000000?oooooooooo\n1P0003H0m`4j0?/1?`3k0D@0n`570?L1A`3c0Cd0000800006`000100001700008`4003H0000@0000\nA`000:T0001H0000=000000000000000ooooooooool60000A`2T04@0X@0o0:40>P2Q03H0Y00f0:T0\n=P000100000f00008`4005P0000d000000000000003oooooooooo`H0000f02L1>P0[0Cl0:`5402/1\nA`0W0DL08`4m0000200001/0000@0000SP000:/0000f0000400000P1002[0000F00003@000000000\n00000?oooooooooo1P0000d1Z`0@0JL0406R0101W@0=0IT0206I03H0000@0000SP0009T0001H0000\n=000000000000000ooooooooool60000RP2I08H0W@260:80QP2W08X0Z`2>0:/0?@0000P0000K0000\n400005l1002[0000=P000100003H0@00Z`0005P0000d000000000000003oooooooooo`H0003M0J/0\nh@6W0>41XP3Q0Id0g@6I0=P1V@0f0000400005l1002I0000F00003@00000000000000?oooooooooo\n1P0005X1V@1F0Id0EP6R05H1Y`1J0J/0G`6[03d0000800006`000100000_0P00Z`0003H0000@0000\nZ0800:/0001H0000=000000000000000ooooooooool60000[@:[0;42Y`2a0Z80/@:M0:d2V@2X0YT0\n=P000100000_0P00V@0005P0000d000000000000003oooooooooo`H0000Z0YT09P:M02H2XP0V0ZL0\n:P:[02l2Z`0m0000200001/0000@0000o`800:/0000f0000400007P3002[0000F00003@000000000\n00000?oooooooooo1P0007d3Z`210jL0P@>R0843W@1m0iT0N0>I03H0000@0000o`8009T0001H0000\n=000000000000000ooooooooool60000nP:I0?H2W@3f0Z80mP:W0?X2Z`3o0Z/0?@0000P0000K0000\n40000<l3002[0000=P00010000181000Z`0005P0000d000000000000003oooooooooo`H0001=1:/0\nD@BW0544XP1A19d0C@BI04P4V@0f000040000<l3002I0000F00003@00000000000000?oooooooooo\n1P000<X3V@360id0aP>R0<H3Y`3:0j/0c`>[03d0000800006`000100002O1000Z`0003H0000@0000\n60D00:/0001H0000=000000000000000ooooooooool600007@F[0245Y`0Q1J808@FM01d5V@0H1IT0\n=P000100002O1000V@0005P0000d000000000000003oooooooooo`H0002J19T0UPBM09H4XP2F1:L0\nVPB[09l4Z`0m0000200001/0000@0000K`D00:/0000f000040000>T5002[0000F00003@000000000\n00000?oooooooooo1P000>d5Z`3a1JL0l@FR0?45W@3]1IT0j@FI03H0000@0000K`D009T0001H0000\n=000000000000000ooooooooool60000JPFI06H5W@1V1J80IPFW06X5Z`1_1J/0?@0000P0000K0000\n400003l6002[0000=P000100002i1P00Z`0005P0000d000000000000003oooooooooo`H0002m1Z/0\n`@JW0<46XP311Yd0_@JI0;T6V@0f0000400003l6002I0000F00003@00000000000000?oooooooooo\n1P0003X6V@0g1Yd0=`JR03L6Y`0j1Z/0?`J[03d0000800006`000100000?1`00Z`0003H0000@0000\nLPL00:/0001H0000=000000000000000ooooooooool60000M`N[07/7Y`1k1j80N`NM07L7V@1b1iT0\n=P000100000?1`00V@0005P0000d000000000000003oooooooooo`H0000;1iT01`NM00L7XP071jL0\n2`N[00l7Z`0m0000200003`000080000?`0001P000010000200007X0001=00004`0000`000010000\n9@0000`0000000209@0000`000070020900002@00000081100000000000008110000000000020000\n:00000`0000300004P0000`000010000600000`0000000005P0000`0000H0000DP00070100030000\n4@00000000081`0020L00901000000001`040440LP1Y0640K0000000C@1_06h0K`1d07T0L01U03X0\n@@1b06T0H@1/0200DP1U06L0M@1/0640LP0j05H0I@000180=P000<0Yn7L005daZ11M<CH00018F?0g\n0@000040000005daZ7oh=jD1003Hh180><GlMkRdo7O?]?ag40000:@100010000^=M/<`40002hef`c\nN04C00T3003b]Oag000C0<ndo7L8`0000@P003R=801Xga8001P000004P2WWO]g22[hMoooooldhA80\n_[7lMmP=GC6P5b40N04C0000Jc<10000lIoe=n1IGC7`?OXg0P000;0knCL00000O@[f@TmE2470TOPg\n0038@PR@n3LPCoXgN9_h=n1IGC5PQoDg0P00023P4P0<0000`2WhM`00GC7825daI7H02000000U0000\n300000<0001D0000H0000480000/0000FP0003`000010000082k@@00b45;0000;`0000<0001<0000\n0000000000000000oooooooooomD0000D01Y06h0003dooooo?ooo`00000U0000300000d0080X0000\n30000080000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000\n`<300000000U000030000080000U0000300000P0081<0000I00006l0000P0000P`0003<0003Z1P00\n0P8005D100100@008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@0A0000000000000000000000000000000U000030000040000U0000\n300000D0081F0000<00006d0000N0000QP0003H000050000?`Q20nX6@P?Z1P82?`P20Sl8@P<U0000\n300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000\n30000040000T000090000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000\n000003P00000000000010140000000000000000000000000000002D0000<00000@0002D0000<0000\n1@00P5L0000T0000S`0003`0002m0000@0000080002g2n8330WR0bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@0002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040\n4@0000000000000000000000000000009@0000`0000100009@0000`000050020E`0002P0002?0000\n>00009P0001500000`0005X9:`@<2N83FPVI0bD0000<00001`00P2D0000<00000000P2@0000T0000\n0020@@00000000000020@@00000000000P0002P0000<00000@000180000<00000@0001P0000<0000\n000001H0000<0000600002D0000<00000`0005@0001D0000h@000180003Z00008P0000400000P;]1\n0038@NX0000E00000@0004`00000000000000000003ooooooooooe00001F0811000002D0000<0000\n3@00P180000<00000@0001P0000<0000000001H0000<0000600002D0000<00000`0005@0001D0000\nXP000180002Z00008P0000400000P;]10038@JX0000E00000@0004`00000000000000000003ooooo\noooooe00000[0000000002D0000<00003@00P180000<00000@0001P0000<0000000001H0000<0000\n600002D0000<00000`0005@0001D0000b@0004H0003;0000EP0000400000P;]10038@L/000190000\n0@0004`00000000000000000003ooooooooooe00001Y0000000002D0000<00003@00P280000<0000\nooooob80000<0000ooooobP0000<00000`0004H000140000>00004E=AR/V@000400000@000000000\n2T00P2@0000H0000ooooo`40000Q/491;EfQ@Ag6_D81ZbE2:00000`0000200008@0000P0001R0000\n30000040000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000\noooo0000000U000030000080000U0000300000P0081<0000I00000`0000D0000JP0003d000330000\n@`400>h5002G0P008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000AP000:@0002H0000ADe6:`Q00P8l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/00000ooooo`Q00`=80000?000004@`=/500000000026`@T6IFGI2\n8acF@YUIMT8S7=I2;EfQ@B6`@T4]GJ518K12@IUIMT800@41P@0001E00`0@000010000080000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n0001014000000000oooo000000000000000002D0000<00000`0002D0000<00001@00P5H0000`0000\n2P000180001]0000@00000D000330=X3/@KJ0k46@`7304<1``3J0bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000`0004H0003P0000\ne00004E=AR/Z@000900001P0000U_mQ200000000000c<l]28K12@BeMXD48@0@6<00002@000014<3K\nZjXZ?P0000000000000000D000110580B@1104`0000f@0B0O00007000000003o0@00004000070000\nIP1/0640KP1W06D0<@2FDbPn<oF1?T2nEchcmH4njjQm?S?ePCk;BJhn<oF1?R2ogChcmH4n>iX6?c?e\nPCkUE1ho<oF1?P00P3l0000000000000P3l00000000000004P0000`000010000600000`000000000\n5P0000`0000H0000DP00070100030000koooo`000000000000000901000000001`040440LP1Y0640\nK0000000C@1_06h0K`1d07T0L01U03X0@@1b06T0H@1/0200DP1U06L0M@1/0640LP0j05H0I@000?oo\nool00000001[9@1P1<QX0C2dJ040@6X1=Qd0H32dJ040@6X121h0H010JP400000000001I30600@6X1\n<;AX0M0=J`70H4iPj>hB032dJ04@@P1P0000004000000000`>lB0>c_4P00@6X10>lB02Ll063@3F/1\nk>lB000000010000>>lB0<<l063@3F/1k>lB0000001X_FT181/0H000001X_FT100000;hJ063Tka80\n`>lB000000000000H>lB0>4o063Tka8000000040000ala80`>lB0000003h=?Xg000009S_4P0J0000\n`2WhM`00GC5X2edaI7H02000000U0000300000<0001D0000N00001h0000O0000E000034000010000\n082k@@00b44N0000;P0000L0001<00000000000000000000oooooooooomL0000IP1/0640KP1W06D0\n<@00o`D0000400002P0000X0000:00002P000000000U0000300000d008160000@00003@00015CDH[\n:d0000`0000000002T00P2@0000H0000ooooo`40003WNla3<k?X@IbIVD;oolM1900002@00000080m\n000000000000080m00000000000200009@0000`0000200009@0000`000080020C00006@0002I0@00\n7@000>D1000e0000T1T00=81003=1000T0400240l000000000000000P3l0000000000000P3l00000\n00000000000000000000000000000000000002D0000<00001`00P2D0000<00000000P2@0000T0000\n0020@@00000000000020@@00000000000P0004H0002T0000V00004E=AR/8@082?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K00000?ooool8@0<3B00003`000014<3K\n1@000000003WNla3VEUH@TkRlT>IFEQ2C^;b@c>cj47WNla3<k?X@NMkc4>IFEQ200410H40000E@0<0\n400000@000020000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@0A000000000?ooo`00000000000000000U000030000040000U0000\n300000D0081F0000<00009L1000K0000j04003P000050000T1UR0edNHP=M7]81T1WB0I0IHP<U0000\n300000L0080U000030000000080T000090000000P440000000000000P440000000000080000X0000\n3000004000160000h0000=@00015CDH[:T0002@0000H00009KoH@P0000000000<c?;@^Mkc4<c/nQ1\n24041S00000T00000A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T04P7`0001`0000\n0000o`40000100001`0006H0K01Q06h0I`1U0380[<2U?B/_<Ch1B`8n:bla?Z/e:3h[;c4n:i23?R/_\n<Cj01K<n:bla?]IjhSh[;c4n5_P8?b/_<Ch0080o000000000000080o0000000000000180000<0000\n0@0001P0000<0000000001H0000<0000600002D0000<00000`0005@0001h0000XP400200003J0@00\n<P0000400000P;]10038@J81000_00001`0004`00000000000000000003ooooooooooe`0001V06`0\nH@1^06L0I@0b00001@0000@0000:00002P0000X0000:0000000002D0000<00003@00P4H000100000\n=00004E=AR/[@00030000000000:@020900001P0003ooooo0@0007VR@d>IFFI2l>i^@WYh^44T0000\n90000000P3d0000000000000P3d0000000000080000U000030000080000U0000300000P0081<0000\nI0000<@0000j0000oP000500000k3000VP<00;/3001a0@008@3`0000000000000020?`0000000000\n0020?`0000000000000000000000000000000000000000009@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000AP000:@0002H0000ADe6:`Q00P8l0000\n<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/00000ooooo`Q00`=80000\n?000004@`=/50000000007VR@d?[BZ52=Eio@n]:XD8eGWm3VEUV@WVR@d>IFFI2NJ93@n]:XD800@41\nP@0001E00`0@000010000080000T000090000000P3d0000000000000P3d0000000000080001O0000\n>0000040000h0000000003P0000000000001014000000000oooo000000000000000002D0000<0000\n0@0002D0000<00001@00P5H0000`0000`P0003P000010@00D`0000D0000k30/5mPl;1OH?VP<k39X3\n>``;1BD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000\n0P0002P0000<00000@0004H0002T0000V00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2\nNJ93@iUIIT88@0@6<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0B0\n@00003@00000003o0@00004000010000IP2:?h4niVHW?P00P3l0000000000000P3l0000000000000\n4P0000`000010000600000`0000000005P0000`0000H00009@0000`000030000E00005@0003O0000\n>`000><0001=00000@000020^d400<Q1g`0004X000010000C00000000000000000000?oooooooooo\nD00006H0ool000009@0000`0000=0020AP000400000d0000ADe6:b]0000<0000000000Y0080T0000\n60000?ooool10000=Eho@lg</T2:R8Q2L1c7@B@0000T00000020?@00000000000020?@0000000000\n0P0002D0000<00000P0002D0000<00002000P4`0001T0000_`0000H000030@007P000?H;001J0000\nA@@008h1000Q0?00000000000000080o000000000000080o00000000000000000000000000000000\n00000000000U0000300000L0080U000030000000080T000090000000P440000000000000P4400000\n0000008000160000Y00009P00015CDH[24020S`0000`00000A30f`00001>000000000<JgRSl20000\n0P000080000200000A30f`00003ooooo24030dP0000l00000A30f`D000000000=Eho@jG?ld4mdH53\nYLoc@CgAPD?=c;90=Eho@lg</T0eGSm3YLoc@@010@6100005D030100000400000P0002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040\n4@000000003oool000000000000000009@0000`0000100009@0000`000050020EP000300002m0000\n100000H1000P00001@000?H;j04k4>P1>a1J0?H;FP3f2nP19@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000010000AP000:@0002H0000\nADe6:bY0000T0000600002Fof4800000000003<cbd8eGSm3cLbb@0Q010H`00009000004@`=^[ZRXn\n00000000000000001@000440DP190440C00003I018100000=00000000?l100000@000040001C033=\nQ3kDWc0n0020?`00000000000020?`0000000000000B000030000040000H000030000000000F0000\n300001P0000U0000300000<0001D0000E0000=/000080000i00001X000010000082k@@00b47K0000\n5`000040001<00000000000000000000oooooooooom@0000D`3oo`00000U0000300000d008160000\n@00003@00015CDH[:d0000`0000000002T00P2@0000H0000ooooo`40002/eGI3jI>T@8R8R49`7<M1\n900002@00000080m000000000000080m00000000000200009@0000`0000200009@0000`000080020\nC00006@0003g00001@0003X1000M0000KPl005<000141000SP400240l000000000000000P3l00000\n00000000P3l0000000000000000000000000000000000000000002D0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0004H0002T0000V00004E=AR/8@082\n?000030000014<3K000004h000000000a[N:?`80000200000P00008000014<3K00000?ooool8@0<3\nB00003`000014<3K1@000000002/eGI3K47`@OR<WD=/@O11n8bM@nVCY42/eGI3jI>T@:cEMT=/@O11\n00410H40000E@0<0400000@000020000900002@00000080m000000000000080m0000000000020000\nG`0003P000010000>0000000000h0000000000000@0A000000000?ooo`00000000000000000U0000\n30000040000U0000300000D0081F0000<0000?D000030000?@40020000050000KPoQ0K8Ch@6b4e<0\nKPmC06h?h@4U0000300000L0080U000030000000080T000090000000P440000000000000P4400000\n00000080000X00003000004000160000Y00009P00015CDH[:T0002@0000H00009KoH@P0000000000\n<c?;@ZcEMT?YTjA024041S00000T00000A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000\n=T04P400000d00000000o`40000100000@0005<0<<f4?]BO<3h0080o000000000000080o00000000\n00000180000<00000@0001P0000<0000000001H0000<0000600002D0000<00000`0005@0001D0000\n4`4000P0000L0@006P0000400000P;]10038@A<1000G00000@0004`00000000000000000003ooooo\noooooe00001C0?oo000002D0000<00003@00P4H000100000=00004E=AR/[@00030000000000:@020\n900001P0003ooooo0@00084EQT>IFFI2l>i^@VI2ZD4T000090000000P3d0000000000000P3d00000\n00000080000U000030000080000U0000300000P0081<0000I00000`1000j0000A`4004h000334000\nVP<00;`3001B0@008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000AP000:@0002H0000ADe6:`Q00P8l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/00000ooooo`Q00`=80000?000004@`=/500000000084EQT=VOIe2\nGo>S@fImWD9Olj=3VEUV@X4EQT>IFFI2PAF6@fImWD800@41P@0001E00`0@000010000080000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>0000040000h0000000003P000000000\n0001014000000000oooo000000000000000002D0000<00000@0002D0000<00001@00P5H0000`0000\n2P4003P0001:0@00D@0000D000334>`4OaC/17lDVP?349X3`a3/12D0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000@0004H0002T0000\nV00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2PAF6@iUIIT88@0@6<00002@000014<3K\nZjXZ?P0000000000000000D000110580B@1104`0000f@0B0@00003@00000003o0@00004000010000\nIP2:?h4nkm4M?P00P3l0000000000000P3l00000000000004P0000`000010000600000`000000000\n5P0000`0000H00009@0000`000030000E00005@0000X0@00>P0002`1001<00000@000020^d400<Q1\n:04004T000010000C00000000000000000000?ooooooooooD00006H0ool000009@0000`0000=0020\nAP000400000d0000ADe6:b]0000<0000000000Y0080T000060000?ooool10000_^H7@lg</T3<c4a2\no?oO@B@0000T00000020?@00000000000020?@00000000000P0002D0000<00000P0002D0000<0000\n2000P4`0001T0000R00000H0002j00008@0007l8001J0000<`<00<01000Q0?00000000000000080o\n000000000000080o0000000000000000000000000000000000000000000U0000300000L0080U0000\n30000000080T000090000000P440000000000000P44000000000008000160000Y00009P00015CDH[\n24020S`0000`00000A30f`00001>000000000<JgRSl200000P000080000200000A30f`00003ooooo\n24030dP0000l00000A30f`D000000000_^H7@iUI1T;a6C]3VET6@_4I>d?=c;90_^H7@lg</T2niPM3\nVET6@P010@6100005D030100000400000P0002@0000T00000020?@00000000000020?@0000000000\n0P0005l0000h00000@0003P000000000>0000000000000404@000000003oool00000000000000000\n9@0000`0000100009@0000`000050020EP0003000026000010000;d0000T00001@0007l86P:b2aX2\n/P]J07l8FP1o21X29@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000:00000`000010000AP0003@0000X0000ADe6:`Y0080T000060000?ooool10000\neVZK@lg<lT3@c4a2o_nO@B@0000T00000020?@00000000000020?@00000000000P0002D0000<0000\n0P0002D0000<00002000P4`0001T0000=`4000P0001Y0@006`0006hC001j0000<`<00401000Q0?00\n000000000000080o000000000000080o0000000000000000000000000000000000000000000U0000\n300000L0080U000030000000080T000090000000P440000000000000P44000000000008000160000\nY00009P00015CDH[24020S`0000`00000A30f`00001>000000000<JgRSl200000P00008000020000\n0A30f`00003ooooo24030dP0000l00000A30f`D000000000eVZK@c>cg45`1;E3<k?L@G04]D?=c?90\neVZK@lg<lT3FJY]3<k?L@@010@6100005D030100000400000P0002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000@0003P000000000>0000000000000404@000000003oool0\n00000000000000009@0000`0000100009@0000`000050020EP000300000e0@001P0006`1000N0000\n1@0006hC^P6Q5[X1XAIj06hCNP1^4kX19@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000:00000`000010000AP0003@0000X0000ADe6:`Y0080T0000\n60000?ooool10000aEVj@c>co46`ZZY1oonO@B@0000T00000020?@00000000000020?@0000000000\n0P0002D0000<00000P0002D0000<00002000P4`0001T0000M@40020000290@00<`0004`G003j0@00\nE@400401000Q0?00000000000000080o000000000000080o00000000000000000000000000000000\n00000000000U0000300000L0080U000030000000080T000090000000P440000000000000P4400000\n0000008000160000Y00009P00015CDH[24020S`0000`00000A30f`00001>000000000<JgRSl20000\n0P000080000200000A30f`000000003o24030dP0000l00000A30f`D000000000aEVj@iUICT9`1<E3\nVEU>@W04aD<c/oa1aEVj@c>co475FKY3VEU>@P010@6100005D030100000400000P0002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000@0003P000000000>000000000000040\n4@0000000000000000000000000000009@0000`0000100009@0000`000050020EP000300001c0@00\n7P0008`1000f00001@0004`G>P>Q63X3XASj0D`GnP5<5cX39@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000010000C00006@000020000\n0P000?H1001B00000P000080003e0@00D@0002T0ZP00000000000000P3l0000000000000P3l00000\n0000000000000000000000000000000000000280000<0000ooooodH0000L0000400004E=AR/2@000\n30000000000>000050000000000@00005000\n"], "Text", Rule[ImageSize, List[501, 84]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell["Connecting two mechanical flanges. The positions at the connection point are identical and the sum of the forces are zero.", "NumberedFigure"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[925, 891]], Rule[WindowMargins, List[List[9, Automatic], List[Automatic, 5]]], Rule[Magnification, 1], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]