List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Connectors and Connector Classes", "Title"], Cell[CellGroupData[List[Cell["Pin", "Section"], Cell[TextData[List["The by now well-known class ", StyleBox["Pin", Rule[FontFamily, "Courier"]], " is a connector class that can be used to specify the external interface for electrical components that have pins as interaction points."]], "Text"], Cell["connector Pin\n  Voltage \t\tv;\n  flow Current \ti;\nend Pin;\t\t\t\t// From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["class PinInst\n  Pin pin;\t\t\t\t// An instance of class Pin\nend PinInst;  ", "ModelicaInput"], Cell[TextData[List["\nAnother way to use the connector ", StyleBox["Pin", Rule[FontFamily, "Courier"]], " is to refer to it from the library using the full path. This method can be used to create instances of all classes that belongs to the Modelica library, instead of writing the whole classes every time."]], "Text"], Cell[TextData[List["class PinInst\n  ", StyleBox["Modelica.Electrical.Analog.Interfaces.Pin pin;", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend PinInst"]], "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0002:H0@0006`00002000010000>/0001;0000\n00000000001c5@00W`L00215CDH00040V280010100040000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH000060000160000h0000=@00015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D000020000;KooomG00007D0001@000080000ZOoooeL00008@002?000030000014<3K\n000004h0000000002?Fh?P80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`000000003H8R12EADR@^FccT9E5B92iK?>@[6T94800@405D010100000400000000024000080000\nHP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@060000000000000000000000000000000U000030000040000U0000\n300000D0081G0000:00002H0000W0000J@0002/000030000P@:90WH6R@9f1Y<29@0000`000070020\n9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000\nAP0003@0000X0000ADe6:`Y0080T000060000?ooo`0100001J_Y@UEE245WI^I2o_mo@TH0002`0000\nY00004E=AR/8@002B00003`000014<3K000004h100000000a[N:?`80000200000P00008000020000\n0000@@00P4014<3K000000000?l8@043B00003`000014<3K1@0000000005ZnU2Z`ZA@[H8J4>[2Y52\n]PQX@eEE2445ZnU2EED8@@F[jD:[2Y5200410H40000E@040400000@000000000900002@00000080m\n000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000\n000000000000000000000000000U000030000040000W0000600000800000000000000000000U0000\n30000080000C000030000080000k0000200001/0000@0000EPL009X0000f0000400005H7000D0@00\nF00003@00000000000000?oooooooooo1P0005H7605C1a`1CPLL0DT770551aP1A@LD0CH0000@0000\nA@L009X0001H0000=000000000000000ooooooooool60000A@NE04T7T@1>1i40D`NA05H7U@1F1iX0\n?@0000P0000K0000400005H7001Z0@00=P000100001F1`00i04005P0000d000000000000003ooooo\nooooo`H0001F1nP1D`O/0Dh7k0591n`1A@OX0DD7i04f0000400004D7001Z0@00F00003@000000000\n00000?oooooooooo1P0004D7I@591f81CPMR0E<7HP5F1fD1EPMZ0Cd0000800006`000100001F1`00\n>P8003H0000@0000EPL00;@2001H0000=000000000000000ooooooooool60000EPNh0U<7_09>1k`2\nB@Nl0TD7^0951k@2=P00010000151`00>P8005P0000d000000000000003oooooooooo`H000151cH2\nB@Lb0Th7<P9C1c82EPLf0UH7>P8m0000200001/0000@0000EPL000X3000f0000400005H700240`00\nF00003@00000000000000?oooooooooo1P0005H7R@=C1h`3CPN<0dT7S0=51hT3A@N40cH0000@0000\nA@L000X3001H0000=000000000000000ooooooooool60000A@L60dT70P=>1`83D`L20eH71P=F1`X3\n?@0000P0000K0000400005H7003J0`00=P000100001F1`00E0@005P0000d000000000000003ooooo\nooooo`H0001F1eT4D`ML14h7G0A91e`4A@MI14D7E0@f0000400004D7003J0`00F00003@000000000\n00000?oooooooooo1P0004D7eP=91m83CPOB0e<7dP=F1mH3EPOJ0cd0000800006`000100001`1`00\nP0@003H0000@0000j@L00804001H0000=000000000000000ooooooooool60000kPN01?87Q0Cb1hT4\nlPN>1>h7T@CY1i44=P000100001`1`00T@@005P0000d000000000000003oooooooooo`H0001[1i44\nI`N>16L7R@AW1h@4J`N01707P0@m0000200001/0000@0000@0P00804000f000040000;T800201000\nF00003@00000000000000?oooooooooo1P000;h8P0C228@4`PR91<88SPBn2944^@RA13H0000@0000\n@0P00944001H0000=000000000000000ooooooooool60000>`RA13L8SP@g28T4=`R413/8P0A02804\n?@0000P0000K00004000010900201000=P00010000292@00P0@005P0000d000000000000003ooooo\nooooo`H0002>2H04TPV41989R@BB2Hh4SPVA18T9T@@f000040000109002A1000F00003@000000000\n00000?oooooooooo1P0000/9T@@72Hh41`V910L9Q0@;2H0440V013d0000800006`000100003P2@00\nP0@003H0000@0000F@X00804001H0000=000000000000000ooooooooool60000GPZ0168:Q0AR2XT4\nHPZ>15h:T@AI2Y44=P000100003P2@00T@@005P0000d000000000000003oooooooooo`H0003K2I44\ne`V>1=L9R@CG2H@4f`V01>09P0@m0000200001/0000@0000/0X00804000f0000400002T;00201000\nF00003@00000000000000?oooooooooo1P0002h;P0@b2h@4<P^9138;SP@^2i44:@^A13H0000@0000\n/0X00944001H0000=000000000000000ooooooooool60000Z`ZA1:L:SPBW2XT4Y`Z41:/:P0B`2X04\n?@0000P0000K00004000080;00201000=P000100003i2`00P0@005P0000d000000000000003ooooo\nooooo`H0003n2h040Pb4108<R@@238h4oP^A1?T;T@@f00004000080;002A1000F00003@000000000\n00000?oooooooooo1P0007/;T@Ag2hh4M`^917L;Q0Ak2h04P0^013d0000800006`000100001@3000\nP0@003H0000@0000b@`00804001H0000=000000000000000ooooooooool60000cPb01=8<Q0CB38T4\ndPb>1<h<T@C93944=P000100001@3000T@@005P0000d000000000000003oooooooooo`H0001;3944\nA`b>14L<R@A738@4B`b0150<P0@m0000200001/0000@000080d00804000f0000400009T=00201000\nF00003@00000000000000?oooooooooo1P0009h=P0BR3H@4XPf91:8=SPBN3I44V@fA13H0000@0000\n80d00944001H0000=000000000000000ooooooooool600006`fA11L=SP@G3HT45`f411/=P0@P3H04\n?@0000P0000K000040000?0=00201000=P000100001Z3P00P0@005P0000d000000000000003ooooo\nooooo`H0001^3X04LPj4178>R@Ab3Xh4KPjA16X>T@@f000040000?0=002A1000F00003@000000000\n00000?oooooooooo1P000>/=T@CW3Hh4i`f91>L=Q0C[3H04l0f013d0000800006`000100001h3P00\nBP@003H0000@0000N0h00=03001H0000=000000000000000ooooooooool60000N0k;0g`>b0>13/P3\nQPk80hX>b`>:3]03=P000100002:3P00BP@005P0000d000000000000003oooooooooo`H0002:3Th4\nQPiB184>DPAl3U84N0i>17P>BP@m0000200001/0000@0000N0h007X3000f0000400007P>00000`00\nF00003@00000000000000?oooooooooo1P0007P>n`9l3_L2P@kg0XH>m`::3_/2RPh00cH0000@0000\nRPh007X3001H0000=000000000000000ooooooooool60000RPin0hH>PP>13X83O0j20gP>OP=h3WX3\n?@0000P0000K0000400007P>002Y0P00=P000100001h3P00<08005P0000d000000000000003ooooo\nooooo`H0001h3R/2O0hW0X4>9`:63RL2RPh[0XX><08f0000400008X>002Y0P00F00003@000000000\n00000?oooooooooo1P0008X>[P:63[82P@jb0W`>/P9h3Zh2N0jY0Sd0000800006`000100001h3P00\nf@4003H0000@0000N0h00601001H0000=000000000000000ooooooooool60000N0iK0G`>E`613UL1\nQPiG0HX>F`6:3V01=P000100002:3P00f@4005P0000d000000000000003oooooooooo`H0002:3]h1\nQPkR0H4>hP5l3^81N0kN0GP>f@4m0000200001/0000@0000N0h000T1000f0000400007P>002@0000\nF00003@00000000000000?oooooooooo1P0007P>R`1l3XL0P@j708H>Q`2:3X/0RPj@03H0000@0000\nRPh000T1001H0000=000000000000000ooooooooool60000RPh>0HH>4P613Q81O0hB0GP>3P5h3PT1\n?@0000P0000K00004000034>002A0000=P000100002h3@00T@0005P0000d000000000000003ooooo\nooooo`H0002c3I40[`f>0:l=R@2_3H@0/`f00;P=P00f00004000034>00200000F00003@000000000\n00000?oooooooooo1P0003H>P00j3X@0>Pj903X>SP0f3Y40<@jA03d0000800006`000100001Q3@00\nT@0003H0000@0000j0`00940001H0000=000000000000000ooooooooool60000h`bA0=l<SP3O38T0\ng`b40><<P03X3800=P000100001Q3@00P00005P0000d000000000000003oooooooooo`H0001V3H00\nJPf406X=R@1Z3Hh0IPfA064=T@0m0000200001/0000@0000T@`00940000f0000400001P<002A0000\nF00003@00000000000000?oooooooooo1P0001<<T@0?38h03`b900l<Q00C380060b003H0000@0000\nT@`00800001H0000=000000000000000ooooooooool60000UPb009X<Q02J38T0VPb>09H<T@2A3940\n?@0000P0000K000040000<4;002A0000=P00010000182`00T@0005P0000d000000000000003ooooo\nooooo`H000132i40?`^>03l;R@0o2h@0@`^004P;P00f000040000<4;00200000F00003@000000000\n00000?oooooooooo1P000<H;P03:2h@0bP^90<X;SP362i40`@^A03d0000800006`000100003a2P00\nT@0003H0000@0000N0X00940001H0000=000000000000000ooooooooool60000L`ZA06l:SP1_2XT0\nK`Z407<:P01h2X00=P000100003a2P00P00005P0000d000000000000003oooooooooo`H0003f2X00\nnPZ40?X:R@3j2Xh0mPZA0?4:T@0m0000200001/0000@00008@X00940000f000040000:P9002A0000\nF00003@00000000000000?oooooooooo1P000:<9T@2O2Hh0W`V909l9Q02S2H00Z0V003H0000@0000\n8@X00800001H0000=000000000000000ooooooooool600009PZ002X:Q00Z2XT0:PZ>02H:T@0Q2Y40\n?@0000P0000K000040000549002A0000=P000100003H2000T@0005P0000d000000000000003ooooo\nooooo`H0003C2940c`R>0<l8R@3?28@0d`R00=P8P00f00004000054900200000F00003@000000000\n00000?oooooooooo1P0005H9P01J2H@0FPV905X9SP1F2I40D@VA03d0000800006`00010000212000\nT@0003H0000@00001`P00940001H0000=000000000000000ooooooooool600000`RA0?l7SP3o1hT0\no`N400<8P0072800=P00010000212000P00005P0000d000000000000003oooooooooo`H000262800\nRPR408X8R@2:28h0QPRA0848T@0m0000200001/0000@0000/@L00940000f0000400004h7002A0000\nF00003@00000000000000?oooooooooo1P0004T7T@151hh0A@N904D7Q0191h00CPN003H0000@0000\n/@L00800001H0000=000000000000000ooooooooool60000]PN00;T7Q02i1hT0^@N>0;H7T@2a1i40\n?@0000P0000l0000200003l0000H0000LP0000H0003[0000B`0001<0000<00000@0002D0000<0000\n0000P2D0000<00001`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0@0004H0002h0000[00004E=AR/Z@000900001P0000U_mQ200000000000c<l]21J_Y@UEE2448@086\n<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0:0E00004P00000003o\n0@00004000030000D01Y06h0UWGB?QoL^ShP/0Do7mbj?//Z3clOg;Xn0020?`00000000000020?`00\n00000000000B000030000040000H000030000000000F0000300001P0001B0000L0400040003_oooo\n0000000000000000T0400000000700@0@@1b06T0H@1/0000001=06l0KP1_07@0N@1`06D0>P110780\nJ@1Q06`0801B06D0I`1e06`0H@1b03X0EP1U0000ooooo`00000006/U0634Y6T1J71Y0CQUJ04f7@1P\nJ71Y0CQUJ0487P1P>6EX0@00000000005T<0H3QUJ05XL6T1f<EY0L1PCV3XkQ80J71Y0A1206000000\n0@0000000030ka80k>lB03QUJ040ka809c`0H=S5J@7/ka8000000040000hka80`c`0H=S5J@7/ka80\n00000<PBJ@4P6`1P00000<PBJ@400000_QX0H>C_4P30ka8000000000001Pka80hCl0H>C_4P000000\n0@00037c4P30ka800000062flSL00000V>lB00`00030:OQg001M<LP8GC5TMP08000002D0000<0000\n0@0005@0001P0000X@0001l0002h0000<@0000400000P;]10038@J40000^00000`0004`000000000\n00000000003ooooooooooe@0001@06T0KP0000`000040000000002D0000<00003@00P4H000100000\n=00004E=AR/[@00030000000000:@020900001P00030`<3o0@0006`Ad4:Z:_A1[:ZZ@@00X44X0000\n30000080000T000090000000P3d0000000000000P3d0000000000080000W00006000008000000000\n`<300000000U000030000080000U0000300000P0081<0000I00006P0000O0000O000038000211P00\nj@4005D100100@008@3`0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000009@0000`0000700209@0000`000000020900002@0000008110000000000000811\n0000000000020000AP000:@0002H0000ADe6:`Q0008l0000<000004@`=/00000CP0000000036]hXo\n0P000080000200000P00004@`=/000000000o`Q00@=80000?000004@`=/50000000006`Ad49E5DY2\n5kcj@UDEBT8G_?Y2ZR[d@F`Ad4:Z:_A1K17@@UDEBT800@41P@0001E00@0@000010000000000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n00010140000000000000000000000000000002D0000<00000`0002D0000<00001@00P5H0000`0000\nIP0001d0001o0000=@0000D000211RT3ePLY0mH7j@611^T1P@HY0bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000`0004H000280000\nO00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`80000200000P00008000014<3K\n000000000?l8@043;000020000014<3K0P000000003jA492EAEb@]9g]T9E5G92004001E00@0@0000\n10000000000T000090000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000\n000003P00000000000010140000000000000000000000000000002D0000<00000`0002D0000<0000\n1@00P5L0000T0000;`0003/0001M0000?`000080000:0lT3]0G90bD0000<00001`00P2D0000<0000\n0000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<00000`0004H0002@0000\nQ00004E=AR/8@002?000030000014<3K000004h000000000a[N:?`80000200000P00008000014<3K\n000000000?l8@043=00002P000014<3K0`000000003V]Za2R2n2@]9g]T9E5G92i[J/@Y_;Gd800@40\n5D01010000040000000002@0000T00000020?@00000000000020?@00000000000P0005l0000h0000\n0`0003P000000000>0000000000000404@0000000000000000000000000000009@0000`000030000\n9@0000`000050020E`0002P0001D0000=P0005d0001300000`0006H54PBd1LT3IPF00bD0000<0000\n1`00P2D0000<00000000P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0`0004H0002T0000V00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2N]ZF`TZO=3h8@086\n<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0:0@00003@00000003o\n0@00004000010000EP1P;3Ho5fa1?P00P3l0000000000000P3l00000000000004P0000`000010000\n600000`0000000005P0000`0000H00009@0000`000010000E00005@000020000100000/0000F0000\n0@000020^d400<Q10P0001<000010000C00000000000000000000?ooooooooooD00005H000000000\n9@0000`0000=0020AP000800001d0000ADe6:b]0000<0000000002Y0000T0000600002Fof4800000\n000003<cbd9jfYK2BYld?SI00X100000=00000000?l100000@000040000[05j]YSlGK44n0020?`00\n000000000020?`0000000000000B000030000040000H000030000000000F0000300001P0000U0000\n30000040001D0000E000048000040000B@0001H000010000082k@@00b45200004`000040001<0000\n0000000000000000oooooooooom@0000:`000000000U0000300000d008160000/0000:@00015CDH[\n:d0000`000000000:T0002@0000H00009KoH@P0000000000<c?;@P9SWl:O]51224021S00000T0000\n0A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P400000d00000000o`4000010000\n0@0006T0akf4?aM/@Ch0080o000000000000080o0000000000000180000<00000@0001P0000<0000\n000001H0000<0000600002D0000<00000@0005@0001D00008@0003P0000R0000BP0000400000P;]1\n0038@B40001700000@0004`00000000000000000003ooooooooooe00001Y0000000002D0000<0000\n3@00P4H0000L0000400004E=AR/[@00030000000001<0000I000008000050000j@0004X000020000\n1@000>P000160000:@2Z0000000000000020?`00000000000020?`00000000000000000000000000\n00000000000000008P0000`0003oooooAP0001`0000@0000ADe6:`90000<0000000000h0000D0000\n00000100000D0000\n"], "Text", Rule[TextAlignment, Center], Rule[ImageSize, List[233, 70.9375`]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell["A component with an electrical pin connector.", "NumberedFigure"]], Open]], Cell[CellGroupData[List[Cell["Flange", "Section"], Cell[TextData[List["The ", StyleBox["Flange", Rule[FontFamily, "Courier"]], " connector class below, analogous to ", StyleBox["Pin", Rule[FontFamily, "Courier"]], ", is used to describe interfaces for one-dimensional interaction in the mechanical domain by specifying the position s and force f at a point of interaction."]], "Text"], Cell["connector Flange\n  Position  s;\n  flow Force f;\nend Flange;\t\t\t\t// From Modelica.Mechanical.Translational.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["class FlangeInst\n  Flange flange;\t\t// An instance of class Flange\nend FlangeInst;  ", "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@00026d0@0006`00000000010000>L0001;0000\n00000000000D5@00W`L00215CDH00040]24000T100040000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH000060000160000h0000=@00015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D000020000;;ooomG00007D0001@000080000YOoooeL00008@002?000030000014<3K\n000004h0000000002?Fh?P80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`0000000036gNloEADR@SFVaT9E5B92=JK6@[6T94800@405D010100000400000000024000080000\nHP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@060000000000000000000000000000000U000030000040000U0000\n300000D0081G0000:0000000000W0000I@0002/0000300007P290SH6R@8f1Y<29@0000`000070020\n9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000\nAP0003@0000X0000ADe6:`Y0080T000060000?ooo`010000EIgQ@UEE245UI^I2o_mo@TH0002`0000\nY00004E=AR/8@002B00003`000014<3K000004h100000000a[N:?`80000200000P00008000020000\n0000@@00P4014<3K000000000?l8@043B00003`000014<3K1@000000001EWN52Z`ZA@]d1I4>[2Y52\ng@5T@eEE245EWN52EED8@EFMhD:[2Y5200410H40000E@040400000@000000000900002@00000080m\n000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000\n000000000000000000000000000U000030000040000W0000600000800000000000000000000U0000\n30000080000C000030000080000k0000200001/0000@00005PL009X0000f0000400001H7000D0@00\nF00003@00000000000000?oooooooooo1P0001H7604B1a`13@LL0@T770451aP11@LD0CH0000@0000\n1@L009X0001H0000=000000000000000ooooooooool600001@NE00T7T@0=1i404PNA01H7U@0F1iX0\n?@0000P0000K0000400001H7001Z0@00=P000100000F1`00i04005P0000d000000000000003ooooo\nooooo`H0000F1nP14PO/0@d7k0491n`11@OX0@D7i04f0000400000D7001Z0@00F00003@000000000\n00000?oooooooooo1P0000D7I@491f813@MR0A87HP4F1fD15PMZ0Cd0000800006`000100000F1`00\n>P8003H0000@00005PL00;@2001H0000=000000000000000ooooooooool600005PNh0Q87_08=1k`2\n2@Nl0PD7^0851k@2=P00010000051`00>P8005P0000d000000000000003oooooooooo`H000051cH2\n2@Lb0Pd7<P8B1c825PLf0QH7>P8m0000200001/0000@00005PL000X3000f0000400001H700240`00\nF00003@00000000000000?oooooooooo1P0001H7R@<B1h`33@N<0`T7S0<51hT31@N40cH0000@0000\n1@L000X3001H0000=000000000000000ooooooooool600001@L60`T70P<=1`834PL20aH71P<F1`X3\n?@0000P0000K0000400001H7003J0`00=P000100000F1`00E0@005P0000d000000000000003ooooo\nooooo`H0000F1eT44PML10d7G0@91e`41@MI10D7E0@f0000400000D7003J0`00F00003@000000000\n00000?oooooooooo1P0000D7eP<91m833@OB0a87dP<F1mH35POJ0cd0000800006`000100000_1`00\nP0@003H0000@0000Z0L00804001H0000=000000000000000ooooooooool60000[@N01;47Q0Ba1hT4\n/@N>1:d7T@BX1i44=P000100000_1`00T@@005P0000d000000000000003oooooooooo`H0000Z1i44\n9PN>12H7R@@V1h@4:PN012l7P0@m0000200001/0000@0000o`L00804000f0000400007T800201000\nF00003@00000000000000?oooooooooo1P0007d8P0B128@4P@R91848SPAm2944N@RA13H0000@0000\no`L00944001H0000=000000000000000ooooooooool60000nPNA1?L7SPCg1hT4m`N41?X7P0Co1h04\n?@0000P0000K000040000<l800201000=P00010000192@00P0@005P0000d000000000000003ooooo\nooooo`H0001=2H04D@V41549R@AA2Hh4C@VA14T9T@@f000040000<l8002A1000F00003@000000000\n00000?oooooooooo1P000<X8T@C728h4a`R91<L8Q0C:2804c`R013d0000800006`000100002O2@00\nP0@003H0000@00006@X00804001H0000=000000000000000ooooooooool600007PZ0124:Q0@Q2XT4\n8@Z>11h:T@@I2Y44=P000100002O2@00T@@005P0000d000000000000003oooooooooo`H0002K2I44\nU`V>19L9R@BG2H@4V`V019l9P0@m0000200001/0000@0000K`X00804000f000040000>T:00201000\nF00003@00000000000000?oooooooooo1P000>h:P0Ca2X@4l@Z91?4:SPC^2Y44j@ZA13H0000@0000\nK`X00944001H0000=000000000000000ooooooooool60000J`ZA16L:SPAW2XT4I`Z416/:P0A_2X04\n?@0000P0000K0000400003l;00201000=P000100002i2`00P0@005P0000d000000000000003ooooo\nooooo`H0002n2h04`P^41<8;R@C22hh4_P^A1;T;T@@f0000400003l;002A1000F00003@000000000\n00000?oooooooooo1P0003/;T@@g2hh4=`^913L;Q0@k2h04?`^013d0000800006`000100000@3000\nP0@003H0000@0000R@`00804001H0000=000000000000000ooooooooool60000SPb0198<Q0BB38T4\nTPb>18h<T@B93944=P000100000@3000T@@005P0000d000000000000003oooooooooo`H0000;3944\n1`b>10L<R@@738@42`b0110<P0@m0000200001/0000@0000h0`00804000f0000400005T=00201000\nF00003@00000000000000?oooooooooo1P0005h=P0AR3H@4HPf9168=SPAN3I44F@fA13H0000@0000\nh0`00944001H0000=000000000000000ooooooooool60000f`bA1=L<SPCG38T4e`b41=/<P0CP3804\n?@0000P0000K000040000;0=00201000=P000100000Y3P00P0@005P0000d000000000000003ooooo\nooooo`H0000^3X04<Pj4138>R@@b3Xh4;PjA12T>T@@f000040000;0=002A1000F00003@000000000\n00000?oooooooooo1P000:/=T@BW3Hh4Y`f91:L=Q0B[3H04/0f013d0000800006`000100000h3P00\nBP@003H0000@0000>0h00=03001H0000=000000000000000ooooooooool60000>0k;0c`>b0=13/P3\nA@k80dT>b`=93]03=P00010000193P00BP@005P0000d000000000000003oooooooooo`H000193Th4\nA@iB144>DP@l3U84>0i>13P>BP@m0000200001/0000@0000>0h007X3000f0000400003P>00000`00\nF00003@00000000000000?oooooooooo1P0003P>n`8l3_L2@@kg0TD>m`993_/2B@h00cH0000@0000\nB@h007X3001H0000=000000000000000ooooooooool60000B@in0dD>PP=13X83?0j20cP>OP<h3WX3\n?@0000P0000K0000400003P>002Y0P00=P000100000h3P00<08005P0000d000000000000003ooooo\nooooo`H0000h3R/2?0hW0T4>9`953RL2B@h[0TT><08f0000400004T>002Y0P00F00003@000000000\n00000?oooooooooo1P0004T>[P953[82@@jb0S`>/P8h3Zh2>0jY0Sd0000800006`000100000h3P00\nf@4003H0000@0000>0h00601001H0000=000000000000000ooooooooool60000>0iK0C`>E`513UL1\nA@iG0DT>F`593V01=P00010000193P00f@4005P0000d000000000000003oooooooooo`H000193]h1\nA@kR0D4>hP4l3^81>0kN0CP>f@4m0000200001/0000@0000>0h000T1000f0000400003P>002@0000\nF00003@00000000000000?oooooooooo1P0003P>R`0l3XL0@@j704D>Q`193X/0B@j@03H0000@0000\nB@h000T1001H0000=000000000000000ooooooooool60000B@h>0DD>4P513Q81?0hB0CP>3P4h3PT1\n?@0000P0000K000040000?4=002A0000=P000100001h3@00T@0005P0000d000000000000003ooooo\nooooo`H0001c3I40K`f>06l=R@1_3H@0L`f007P=P00f000040000?4=00200000F00003@000000000\n00000?oooooooooo1P000?H=P03j3H@0nPf90?X=SP3f3I40l@fA03d0000800006`000100000Q3@00\nT@0003H0000@0000Z0`00940001H0000=000000000000000ooooooooool60000X`bA09l<SP2O38T0\nW`b40:<<P02X3800=P000100000Q3@00P00005P0000d000000000000003oooooooooo`H0000V3H00\n:Pf402X=R@0Z3Hh09PfA024=T@0m0000200001/0000@0000D@`00940000f000040000=L;002A0000\nF00003@00000000000000?oooooooooo1P000=<;T@3?2hh0c`^90<l;Q03C2h00e`^003H0000@0000\nD@`00800001H0000=000000000000000ooooooooool60000EPb005X<Q01J38T0FPb>05H<T@1A3940\n?@0000P0000K00004000084;002A0000=P00010000072`00T@0005P0000d000000000000003ooooo\nooooo`H000032i40o`Z>0?l:R@3o2X@00`^000L;P00f00004000084;00200000F00003@000000000\n00000?oooooooooo1P0008H;P0292h@0R@^908T;SP262i40P@^A03d0000800006`000100002a2P00\nT@0003H0000@0000=`X00940001H0000=000000000000000ooooooooool60000<`ZA02l:SP0_2XT0\n;`Z403<:P00g2X00=P000100002a2P00P00005P0000d000000000000003oooooooooo`H0002e2X00\n^@Z40;T:R@2i2Xh0]@ZA0;4:T@0m0000200001/0000@0000h@T00940000f0000400006L9002A0000\nF00003@00000000000000?oooooooooo1P000689T@1O2Hh0G`V905l9Q01R2H00I`V003H0000@0000\nh@T00800001H0000=000000000000000ooooooooool60000i@V00>T9Q03Y2HT0j@V>0>D9T@3Q2I40\n?@0000P0000K000040000149002A0000=P000100002G2000T@0005P0000d000000000000003ooooo\nooooo`H0002B2940SPR>08h8R@2>28@0TPR009L8P00f00004000014900200000F00003@000000000\n00000?oooooooooo1P0001D9P00I2H@06@V901T9SP0E2I404@VA03d0000800006`00010000102000\nT@0003H0000@0000a`L00940001H0000=000000000000000ooooooooool60000`PNA0;h7SP2n1hT0\n_PN40<87P0371h00=P00010000102000P00005P0000d000000000000003oooooooooo`H000152800\nB@R404T8R@1928h0A@RA0408T@0m0000200001/0000@0000L0L00940000f0000400000d7002A0000\nF00003@00000000000000?oooooooooo1P0000T7T@051hh01@N900D7Q0091h003@N003H0000@0000\nL0L00800001H0000=000000000000000ooooooooool60000M@N007T7Q01i1hT0N@N>07D7T@1`1i40\n?@0000P0000l0000200003l0000H0000KP0000H0003W0000B`0001<0000<00000@0002D0000<0000\n0000P2D0000<00001`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0@0004H0003D0000b00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2EIgQ@UEE2448@086\n<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0:0L00006@00000003o\n0@00004000060000AP1/0640KP1W06D0jjZ=?QoL^Sk[b/4n7mbj?T70e3hOg;XnbaX2?aoL^SifeATo\n7mbj?R2@<ClOg;Xn0020?`00000000000020?`00000000004P0000`000010000600000`000000000\n5P0000`0000H0000DP00070100010000koooo`000000000000000901000000001`040440LP1Y0640\nK0000000C@1_06h0K`1d07T0L01U03X0@@1b06T0H@1/0200DP1U06L0M@1/0640LP0j05H0I@000?oo\nool00000001[9@1P?:m[0L3UJP5h3VP1=Qd0H<3UJP5h3VP121h0H7P>J0400000000001I3061h3VP1\n`>EZ0L0kJ@70H4iPj>hB0<3UJP4@@P1P0000004000000000`>lB0>c_4P1h3VP10>lB02Ll0630>fT1\nk>lB000000010000>>lB0<<l0630>fT1k>lB0000000@AfT181/0H000000@AfT100000;hJ063Tka80\n`>lB000000000000H>lB0>4o063Tka8000000040000ala80`>lB0000001P]_8g000009S_4P0F0000\n`2WhM`00GC6X2UdaI7H02000000U000030000040001D0000L00008l0000O0000``00034000010000\n082k@@00b46?0000;P0000H0001<00000000000000000000oooooooooomH0000AP1/0640KP1W06D0\n2`0000@0000:00002P0000X0000000009@0000`0000=0020AP000400000d0000ADe6:b]0000<0000\n000000Y0080T000060000<30`?l10000^`?8@ZXZm46/ZZY1002P@BP0000<00000P0002@0000T0000\n0020?@00000000000020?@00000000000P0002L0000H00000P0000000030`<00000002D0000<0000\n0P0002D0000<00002000P4`0001T0000I00001l0001h0000<P000446003Y0@00E@400401000Q0?00\n000000000000080o000000000000080o0000000000000000000000000000000000000000000U0000\n300000L0080U000030000000080T000090000000P440000000000000P44000000000008000160000\nY00009P00015CDH[24000S`0000`00000A30f`00001>000000000<JgRSl200000P00008000020000\n0A30f`000000003o24010dP0000l00000A30f`D000000000^`?8@UDEBT9V[_92EAE:@VJ^lT:Z:_A1\n^`?8@ZXZm46k0lQ2EAE:@P010@6100005D01010000040000000002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000`0003P000000000>0000000000000404@00000000000000\n00000000000000009@0000`0000300009@0000`000050020EP000300001R00007@0007/0000e0000\n1@000446:@>F1bT3UPOY0D46j@511RT39@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000:00000`000030000AP0008P0001l0000ADe6:`Q0008l0000\n<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/000000000o`Q00@</0000\n8000004@`=/20000000009TY<T9E5G928VZ^@UDELT800@005D01010000040000000002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000>000000000000040\n4@0000000000000000000000000000009@0000`0000300009@0000`000050020E`0002@0000[0000\n>`0005T0000o00000P000<T2b@=d1LT39@0000`0000700209@0000`000000020900002@000000811\n00000000000008110000000000020000:00000`000030000AP00090000240000ADe6:`Q0008l0000\n<000004@`=/00000CP0000000036]hXo0P000080000200000P00004@`=/000000000o`Q00@<d0000\n:000004@`=/30000000003JYY4:8;h928VZ^@UDELT8fZJA2Vl]O@P010@0E@040400000@000000000\n900002@00000080m000000000000080m0000000000020000G`0003P000030000>0000000000h0000\n000000000@0A0000000000000000000000000000000U0000300000<0000U0000300000D0081G0000\n:0000500000f0000F@0004<0000300009PDB17@5b@<V1H039@0000`0000700209@0000`000000020\n900002@00000081100000000000008110000000000020000:00000`000030000AP000:@0002H0000\nADe6:bY0000T0000600002Fof4800000000003<cbd8[j9k2BYld?PQ00PH`00009000004@`=^[ZRXn\n00000000000000001@000440DP190440C00003I00X100000=00000000?l100000@000040001c0;FQ\n@SlGK44n0020?`00000000000020?`0000000000000B000030000040000H000030000000000F0000\n300001P0000U000030000040001D0000E00000<0000400002@0001H000010000082k@@00b4430000\n4`000040001<00000000000000000000oooooooooom@0000L`000000000U0000300000d008160000\n/0000:@00015CDH[:d0000`000000000:T0002@0000H00009KoH@P0000000000<c?;@[=`Yl:O]512\n24021S00000T00000A30fj^Z:Sh000000000000000050000@@1B04T0@@1<0000=T02P400000d0000\n0000o`40000100000@0006H0abF4?aM/@Ch0080o000000000000080o0000000000000180000<0000\n0@0001P0000<0000000001H0000<0000600002D0000<00000@0005@0001D0000700003P0000P0000\nBP0000400000P;]10038@A`0001700000@0004`00000000000000000003ooooooooooe00001V0000\n000002D0000<00003@00P4H0000L0000400004E=AR/[@00030000000001<0000I000004000050000\ni@0004X0000100001@000>D000160000:@2Z0000000000000020?`00000000000020?`0000000000\n000000000000000000000000000000008P0000`0003oooooAP0001`0000@0000ADe6:`90000<0000\n000000h0000D000000000100000D0000\n"], "Text", Rule[ImageSize, List[231, 71]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell["A component with a mechanical flange connector.", "NumberedFigure"]], Open]], Cell[CellGroupData[List[Cell["InPort", "Section"], Cell[TextData[List["The connector class ", StyleBox["InPort", Rule[FontFamily, "Courier"]], " when instantiated as ", StyleBox["inPort", Rule[FontFamily, "Courier"]], " is a signal ", StyleBox["input", Rule[FontFamily, "Courier"]], " port that can be connected to receive signals."]], "Text"], Cell["connector InPort\n  parameter Integer n = 1;\n  input Real signal[n];\nend InPort;\t\t\t\t\t\t// From Modelica.Blocks.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["class InPortInst\n  InPort inPort[n];\t\t\t\t// An instance inPort with one signal (n = 1)\nend InPortInst;  ", "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@00023l0@0006`00000000010000>/0001;0000\n00000000001h5@00B@L00215CDH00040o200004100040000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0002`0000P0000ADe6:`500@0L00004000004@`=/10000\nH000060000160000h0000=@00015CDH[<4020100000400000020?am0100<0000000001i00@0<0000\n000001e0000D000020000;[ooom:00007D0001@000080000[_ooodX00008@002?000030000014<3K\n000004h0000000002?Fh?P80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`0000000036gNloEADR@SFVaT9E5B92=JK6@[6T94800@405D010100000400000000024000080000\nHP0000`000010000900002@00000080m000000000000080m0000000000020000G`0003P000010000\n>0000000000h0000000000000@060000000000000000000000000000000U000030000040000U0000\n300000D0081G0000:0000000000W0000I@0002/0000300007P290SH6R@8f1Y<29@0000`000070020\n9@0000`000000020900002@00000081100000000000008110000000000020000:00000`000010000\nAP0003@0000X0000ADe6:`Y0080T000060000?ooo`010000gBGZ@UEE245WI^I2o_mo@TH0002`0000\nY00004E=AR/8@002B00003`000014<3K000004h100000000a[N:?`80000200000P00008000020000\n0000@@00P4014<3K000000000?l8@043B00003`000014<3K1@000000003M9NY2Z`ZA@R96J4>[2Y52\n8TIX@eEE247M9NY2EED8@MdUjT:[2Y5200410H40000E@040400000@000000000900002@00000080m\n000000000000080m0000000000020000G`0003P000010000>0000000000h00000000000B0@0@0000\n000000000000000000000000000U000030000040000W0000600000800000000000000000000U0000\n30000080000C000030000080000k0000200001/0000@0000FPL009X0000f0000400005X7000D0@00\nF00003@00000000000000?oooooooooo1P0005X7605F1a`1DPLL0Dd770591aP1B@LD0CH0000@0000\nB@L009X0001H0000=000000000000000ooooooooool60000B@NE04d7T@1B1i40EPNA05X7U@1J1iX0\n?@0000P0000K0000400005X7001Z0@00=P000100001J1`00i04005P0000d000000000000003ooooo\nooooo`H0001J1nP1EPO/0E87k05=1n`1B@OX0DT7i04f0000400004T7001Z0@00F00003@000000000\n00000?oooooooooo1P0004T7I@5=1f81DPMR0EH7HP5J1fD1FPMZ0Cd0000800006`000100001J1`00\n>P8003H0000@0000FPL00;@2001H0000=000000000000000ooooooooool60000FPNh0UH7_09B1k`2\nC@Nl0TT7^0991k@2=P00010000191`00>P8005P0000d000000000000003oooooooooo`H000191cH2\nC@Lb0U87<P9F1c82FPLf0UX7>P8m0000200001/0000@0000FPL000X3000f0000400005X700240`00\nF00003@00000000000000?oooooooooo1P0005X7R@=F1h`3DPN<0dd7S0=91hT3B@N40cH0000@0000\nB@L000X3001H0000=000000000000000ooooooooool60000B@L60dd70P=B1`83EPL20eX71P=J1`X3\n?@0000P0000K0000400005X7003J0`00=P000100001J1`00E0@005P0000d000000000000003ooooo\nooooo`H0001J1eT4EPML1587G0A=1e`4B@MI14T7E0@f0000400004T7003J0`00F00003@000000000\n00000?oooooooooo1P0004T7eP==1m83DPOB0eH7dP=J1mH3FPOJ0cd0000800006`000100001c1`00\nP0@003H0000@0000k@L00804001H0000=000000000000000ooooooooool60000lPN01?D7Q0Ce1hT4\nm@N>1?87T@C]1i44=P000100001c1`00T@@005P0000d000000000000003oooooooooo`H0001_1i44\nJ`N>16/7R@A[1h@4K`N017<7P0@m0000200001/0000@0000@`P00804000f000040000;d800201000\nF00003@00000000000000?oooooooooo1P000<88P0C628@4aPR91<H8SPC22944_@RA13H0000@0000\n@`P00944001H0000=000000000000000ooooooooool60000?`RA13/8SP@k28T4>`R413l8P0A32804\n?@0000P0000K0000400001@900201000=P000100002=2@00P0@005P0000d000000000000003ooooo\nooooo`H0002B2H04UPV419H9R@BF2Hh4TPVA18d9T@@f0000400001@9002A1000F00003@000000000\n00000?oooooooooo1P0000l9T@@;2Hh42`V910/9Q0@?2H0450V013d0000800006`000100003T2@00\nP0@003H0000@0000G@X00804001H0000=000000000000000ooooooooool60000HPZ016H:Q0AV2XT4\nIPZ>168:T@AM2Y44=P000100003T2@00T@@005P0000d000000000000003oooooooooo`H0003O2I44\nf`V>1=/9R@CK2H@4g`V01>@9P0@m0000200001/0000@0000]0X00804000f0000400002d;00201000\nF00003@00000000000000?oooooooooo1P00038;P0@f2h@4=P^913H;SP@b2i44;@^A13H0000@0000\n]0X00944001H0000=000000000000000ooooooooool60000[`ZA1:/:SPB[2XT4Z`Z41:l:P0Bd2X04\n?@0000P0000K0000400008@;00201000=P000100003m2`00P0@005P0000d000000000000003ooooo\nooooo`H0000238041Pb410H<R@@638h40PbA1?d;T@@f0000400008@;002A1000F00003@000000000\n00000?oooooooooo1P0007l;T@Ak2hh4N`^917/;Q0Ao2h04Q0^013d0000800006`000100001D3000\nP0@003H0000@0000c@`00804001H0000=000000000000000ooooooooool60000dPb01=H<Q0CF38T4\nePb>1=8<T@C=3944=P000100001D3000T@@005P0000d000000000000003oooooooooo`H0001?3944\nB`b>14/<R@A;38@4C`b015@<P0@m0000200001/0000@000090d00804000f0000400009d=00201000\nF00003@00000000000000?oooooooooo1P000:8=P0BV3H@4YPf91:H=SPBR3I44W@fA13H0000@0000\n90d00944001H0000=000000000000000ooooooooool600007`fA11/=SP@K3HT46`f411l=P0@T3H04\n?@0000P0000K000040000?@=00201000=P000100001]3P00P0@005P0000d000000000000003ooooo\nooooo`H0001b3X04MPj417H>R@Af3Xh4LPjA16d>T@@f000040000?@=002A1000F00003@000000000\n00000?oooooooooo1P000>l=T@C[3Hh4j`f91>/=Q0C_3H04m0f013d0000800006`000100001l3P00\nBP@003H0000@0000O0h00=03001H0000=000000000000000ooooooooool60000O0k;0h0>b0>53/P3\nRPk80hh>b`>>3]03=P000100002>3P00BP@005P0000d000000000000003oooooooooo`H0002>3Th4\nRPiB18D>DPB03U84O0i>17`>BP@m0000200001/0000@0000O0h007X3000f0000400007`>00000`00\nF00003@00000000000000?oooooooooo1P0007`>n`:03_L2Q@kg0XX>m`:>3_/2SPh00cH0000@0000\nSPh007X3001H0000=000000000000000ooooooooool60000SPin0hX>PP>53X83P0j20g`>OP=l3WX3\n?@0000P0000K0000400007`>002Y0P00=P000100001l3P00<08005P0000d000000000000003ooooo\nooooo`H0001l3R/2P0hW0XD>9`::3RL2SPh[0Xh><08f0000400008h>002Y0P00F00003@000000000\n00000?oooooooooo1P0008h>[P::3[82Q@jb0X0>/P9l3Zh2O0jY0Sd0000800006`000100001l3P00\nf@4003H0000@0000O0h00601001H0000=000000000000000ooooooooool60000O0iK0H0>E`653UL1\nRPiG0Hh>F`6>3V01=P000100002>3P00f@4005P0000d000000000000003oooooooooo`H0002>3]h1\nRPkR0HD>hP603^81O0kN0G`>f@4m0000200001/0000@0000O0h000T1000f0000400007`>002@0000\nF00003@00000000000000?oooooooooo1P0007`>R`203XL0Q@j708X>Q`2>3X/0SPj@03H0000@0000\nSPh000T1001H0000=000000000000000ooooooooool60000SPh>0HX>4P653Q81P0hB0G`>3P5l3PT1\n?@0000P0000K0000400003D>002A0000=P000100002l3@00T@0005P0000d000000000000003ooooo\nooooo`H0002g3I40/`f>0;<=R@2c3H@0]`f00;`=P00f0000400003D>00200000F00003@000000000\n00000?oooooooooo1P0003X>P00n3X@0?Pj903h>SP0j3Y40=@jA03d0000800006`000100001U3@00\nT@0003H0000@0000k0`00940001H0000=000000000000000ooooooooool60000i`bA0><<SP3S38T0\nh`b40>L<P03/3800=P000100001U3@00P00005P0000d000000000000003oooooooooo`H0001Z3H00\nKPf406h=R@1^3Hh0JPfA06D=T@0m0000200001/0000@0000U@`00940000f0000400001`<002A0000\nF00003@00000000000000?oooooooooo1P0001L<T@0C38h04`b901<<Q00G380070b003H0000@0000\nU@`00800001H0000=000000000000000ooooooooool60000VPb009h<Q02N38T0WPb>09X<T@2E3940\n?@0000P0000K000040000<D;002A0000=P000100001<2`00T@0005P0000d000000000000003ooooo\nooooo`H000172i40@`^>04<;R@132h@0A`^004`;P00f000040000<D;00200000F00003@000000000\n00000?oooooooooo1P000<X;P03>2h@0cP^90<h;SP3:2i40a@^A03d0000800006`000100003e2P00\nT@0003H0000@0000O0X00940001H0000=000000000000000ooooooooool60000M`ZA07<:SP1c2XT0\nL`Z407L:P01l2X00=P000100003e2P00P00005P0000d000000000000003oooooooooo`H0003j2X00\noPZ40?h:R@3n2Xh0nPZA0?D:T@0m0000200001/0000@00009@X00940000f000040000:/9002A0000\nF00003@00000000000000?oooooooooo1P000:L9T@2S2Hh0X`V90:<9Q02W2H00Z`V003H0000@0000\n9@X00800001H0000=000000000000000ooooooooool60000:PZ002h:Q00^2XT0;PZ>02X:T@0U2Y40\n?@0000P0000K0000400005D9002A0000=P000100003K2000T@0005P0000d000000000000003ooooo\nooooo`H0003G2940d`R>0=<8R@3C28@0e`R00=/8P00f0000400005D900200000F00003@000000000\n00000?oooooooooo1P0005X9P01M2H@0G@V905d9SP1J2I40E@VA03d0000800006`00010000252000\nT@0003H0000@00002`P00940001H0000=000000000000000ooooooooool600001`RA00<8SP0328T0\n0`R400L8P00;2800=P00010000252000P00005P0000d000000000000003oooooooooo`H0002:2800\nS@R408d8R@2=28h0RPRA08D8T@0m0000200001/0000@0000]@L00940000f000040000587002A0000\nF00003@00000000000000?oooooooooo1P0004d7T@191hh0B@N904T7Q01=1h00DPN003H0000@0000\n]@L00800001H0000=000000000000000ooooooooool60000^@N00;d7Q02m1hT0_@N>0;T7T@2e1i40\n?@0000P0000l0000200003l0000H0000L`0000H0003[0000B`0001<0000<00000@0002D0000<0000\n0000P2D0000<00001`00P2@0000T00000020@@00000000000020@@00000000000P0002P0000<0000\n0@0004H0003D0000b00004E=AR/Z@000900001P0000U_mQ200000000000c<l]2gBGZ@UEE2448@086\n<00002@000014<3KZjXZ?P0000000000000000D000110580B@1104`0000f@0:0L00006@00000003o\n0@00004000060000J@1^0500K`1b07@0jjZP?QoL^Si1X;<n7mbj?YHEhchOg;Xn800>?aoL^Sk;^RDo\n7mbj?R3`<clOg;Xn0020?`00000000000020?`00000000004P0000`000010000600000`000000000\n5P0000`0000H0000DP00070100010000koooo`000000000000000901000000001`040440LP1Y0640\nK0000000C@1_06h0K`1d07T0L01U03X0@@1b06T0H@1/0200DP1U06L0M@1/0640LP0j05H0I@000?oo\nool00000001[9@1PA91[0DR]JP6Hmf/1=Qd0H4R]JP6Hmf/121h0H9SgJ`400000000001I3062Hmf/1\nB:eZ0GSWC070H4iPj>hB04R]JP4@@P1P0000004000000000`>lB0>c_4P2Hmf/10>lB02Ll061hid`1\nk>lB000000010000>>lB0<<l061hid`1k>lB0000003HlF/181/0H000003HlF/100000;hJ063Tka80\n`>lB000000000000H>lB0>4o063Tka8000000040000ala80`>lB0000003HQ_0g000009S_4P0F0000\n`2WhM`00GC6X2UdaI7H02000000U000030000040001D0000L00009L0000O0000a000034000010000\n082k@@00b46G0000;P0000H0001<00000000000000000000oooooooooomH0000J@1^0500K`1b07@0\n100000X0000<00002P0000H0000000009@0000`0000=0020AP000001003d0000ADe6:b]0000<0000\n000002Y0000T0000600002Fof4800000000003<cbd:RGiK2BYld?PQ00PH`00009000004@`=^[ZRXn\n00000000000000001@000440DP190440C00003I00X2@0000Q00000000?l100000@0000T0001c06T0\nI`1^0640K01K06h0G@2>`cho5fa1?^@HE3lGK44nSY=M?aM/@ChiCWDo5fa1?W:4QSlGK44naf6B?aM/\n@ChL7iLo5fa1?W8<WClGK44nanVX?aM/@Ch0080o000000000000080o0000000000000180000<0000\n0@0001P0000<0000000001H0000<0000600002D0000<00000@0005@0002400001P0000@000170000\n5P0000400000P;]10038@@H0000C00002@0004`00000000000000000003oooooooooof00001c06T0\nI`1^0640K01K06h0G@010`T0000400002P0000X0000:0000100000D0000:0000000002D0000<0000\n3@00P4H0002D0000R00004E=AR/[@000300000000008@002?000030000014<3K000004h000000000\na[N:?`80000200000P00008000014<3K000000000?l8@043;000020000014<3K0P000000001m1<Y2\nZR[l@MdUjT9mTRi2004001E00@0@000010000000000T000090000000P3d0000000000000P3d00000\n00000080001O0000>00000<0000h0000000003P00000000000010140000000000000000000000000\n000002D0000<00000`0002D0000<00001@00P5L0000T0000H`0001h0001g0000;P000080001A1_T1\nDPNk0RD0000<00001`00P2D0000<00000000P2@0000T00000020@@00000000000020@@0000000000\n0P0002P0000<00000`0004H0002@0000Q00004E=AR/8@002?000030000014<3K000004h000000000\na[N:?`80000200000P00008000014<3K000000000?l8@043=00002P000014<3K0`000000001m1<Y2\nWkA@@TB<d4:O]512gBGZ@UDE8T800@405D01010000040000000002@0000T00000020?@0000000000\n0020?@00000000000P0005l0000h00000`0003P000000000>0000000000000404@00000000000000\n00000000000000009@0000`0000300009@0000`000050020E`0002P0001S00009`0007L0000f0000\n0`000546@`>51T<3DPN90RD0000<00001`00P2D0000<00000000P2@0000T00000020@@0000000000\n0020@@00000000000P0002P0000<00000`0004H0002@0000Q00004E=AR/8@002?000030000014<3K\n000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043=00002P000014<3K\n0`000000001dl^U2V?4k@]dUjT9E5B923e_L@_2d8D800@405D01010000040000000002@0000T0000\n0020?@00000000000020?@00000000000P0005l0000h00000`0003P000000000>000000000000040\n4@0000000000000000000000000000009@0000`0000300009@0000`000050020E`0002P0001/0000\n9P0007L0000a00000`000507l09B1hT2h`J70RD0000<00001`00P2D0000<00000000P2@0000T0000\n0020@@00000000000020@@00000000000P0002P0000<00000`0004H000280000O00004E=AR/8@002\n?000030000014<3K000004h000000000a[N:?`80000200000P00008000014<3K000000000?l8@043\n;000020000014<3K0P000000001m1<Y2ZR[l@Gd4bT9E5E92004001E00@0@000010000000000T0000\n90000000P3d0000000000000P3d0000000000080001O0000>00000<0000h0000000003P000000000\n00010140000000000000000000000000000002D0000<00000`0002D0000<00001@00P5L0000T0000\nH`0001h0001W0000=`000080001A1_T1D@I90bD0000<00001`00P2D0000<00000000P2@0000T0000\n0020@@00000000000020@@00000000000P0002P0000<00000`0004`0001T00000@0000D0003Y0000\nB@00004000050000j@0004D0000Y0:X0000000000000080o000000000000080o0000000000000000\n000000000000000000000000000R000030000?oooom60000700001000015CDH[0T0000`000000000\n3P0001@000000000400001@0\n"], "Text", Rule[ImageSize, List[235, 71]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell["A component with an inPort connector for signals.", "NumberedFigure"]], Open]], Cell[CellGroupData[List[Cell["Connector Classes", "Section"], Cell[TextData[List["Connector classes often use special types for standard physical quantities represented by ", StyleBox["Real", Rule[FontFamily, "Courier"]], " values, e.g. ", StyleBox["Voltage", Rule[FontFamily, "Courier"]], ". The types ", StyleBox["Voltage, Current, Position, Force", Rule[FontFamily, "Courier"]], " and ", StyleBox["Distance", Rule[FontFamily, "Courier"]], " shown below are just five of the classes available in the Modelica Standard library ", StyleBox["Modelica.SIunits", Rule[FontFamily, "Courier"]], ". \n"]], "Text"], Cell[TextData[List["type ", StyleBox["Voltage", Rule[FontColor, RGBColor[0, 0, 1]]], " = Real(final quantity = \"ElectricPotential\",\n\t\t\t\t\tfinal unit = \"V\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type ", StyleBox["Current", Rule[FontColor, RGBColor[0, 0, 1]]], " = Real(final quantity = \"ElectricCurrent\",\n\t\t\t\t\tfinal unit = \"A\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type ", StyleBox["Position", Rule[FontColor, RGBColor[0, 0, 1]]], " = Real(final quantity = \"Length\", final unit = \"m\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type ", StyleBox["Force", Rule[FontColor, RGBColor[0, 0, 1]]], " = Real(final quantity = \"Force\", final unit = \"N\");"]], "ModelicaInput"], Cell["", "Text"], Cell[TextData[List["type ", StyleBox["Distance", Rule[FontColor, RGBColor[0, 0, 1]]], " = Position(min = 0);"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[912, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]