List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Connection Restrictions on Input and Output Connectors", "Title"], Cell["", "Text"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["The introduction of structured components with inside and outside connectors introduces some additional complexity in the rules for connecting connectors with input or output causality, i.e. connectors declared with the ", StyleBox["input", Rule[FontFamily, "Courier"]], " or ", StyleBox["output", Rule[FontFamily, "Courier"]], " type prefix. Examples are instances of the connector classes ", StyleBox["InPort", Rule[FontFamily, "Courier"]], " and ", StyleBox["OutPort", Rule[FontFamily, "Courier"]], ". Normally the following rules apply:\n\[Bullet]\tTwo acausal connectors can be connected to each other.\n\[Bullet]\tAn input connector can be connected to an output connector or vice versa.\n\[Bullet]\tAn input or output connector can be connected to an acausal connector, i.e. a connector without input/output prefixes.\n"]], "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0006S/0@0006`000000000000006P2002E0000\n00000000002I>000b0h00215CDH00040k6P00:H200090000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP000>@U003H9@00AdA9@`4008000`009T>SP00000309@00\n0@090003h18000X070000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P0000050000309n0eh=70000?/2W?l00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iR\nmGO7H_Eg0@000000<0040000;@4000D000020@40000500002@8000020`0001h01`0001H4OP=N3@00\n000@00009PH?01H0ooooo`00oooooooooomX3@00O`<000<0000N00D0000^0@00000500002P800000\n1@0000T2000000D000010_ooo`070000o0810000000000@0000]0@4020000?X21@010000000000@0\n000]0@80100000<1200700004PAn0gh3GPeW3@D0000;0P0000050000309n0fL=500002H63`0N0?oo\nool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0000<0Wh3I`dL0000n`8D00T000000;`2000000@2\n0R9CNG=dIFd0Md00000I1`XK_V;eMlMRmGL10000000`00@0000]0@<01@0000810@0001`0003k0Zgo\n00000000T040000014004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d110050000\n2@8000021@0000/2000000d0000b2P40000100@0000006L=OP<PJBD0400002H63`0F0?ooool006`2\n001W0000e@<006l000080000nP8000@000000000100002d11@040000;@4100P0000U0`80K`9Z0=43\nJ`080000nP80000000000000100002d11P040000l04500L0003l0P00oooo0000100002d11@080000\n9PH?00H0ooooo`40400002H63`0F0?ooool000X000010000K@800=P000040000;@4100P0003j0P00\n1000000000840000;@4700L0000K1=T0<`8104P0100002d11@040000;@4600@0003`0@L0400002H6\n3`0F0?ooool002h2001:0000LP80094000080000nP8000H000000000100002d11`070000o0800?oo\no`0000@0000]0@P0300002@3100b0Th0K@9Y0382S00b0Th0100002d11P040000l04700@0000]0@D0\n10000?01200800009PH?00H0ooooo`40100002d10@040000;@4200L0000K1980305805T0100002d1\n1@040000;@4600<0000N00L0000F19002`5805P01@0000810@0001`0003k0[go00000000T0400000\n14004UAYKFEc84iUMb1BKfeQKP2nH_Egaf;eM`4000000300100002d11`0D0000<PY805P01P0405P0\nB00:0I00JFi@Kg9d4`0R02D08@0F01<03@00038:B03l0040101H04P02P6@02007@0400009`7oo`@0\n000]0@40100002d10P0700006`BD02d2A@1I0@@0000]0@D0100002d11P0300007P0700005PBC02d2\nA@1I0@D000020@4000040000;@4700D000090P00008F0000<PY505T11`0405T1A@0/0Y<0KgEdD6mb\nM00Q02804`0U02405P0C00d0000b2TD07P8100@0F@5502`2T`0P01d0100002L1ool@00009PH?01H0\nooooo`001P0004X0001:0000T@0000P0003j0P001P00000000040000;@4800L0003l0P00`<300000\n100002d12@0<000090<400X0CP1506T02P2<00X0CP040000;@4600@0003`0@P0100002d11@040000\nl04900P0000V1Pl01P3ooooo0@040000;@4100@0000]0@801`0001/4F`1o0@@01@440000;@4500@0\n000]0@H00`0001h01`0001H4F@1n0@@01@4500000P410000100002d1100500002@8000023P00038:\n1@050@8010050@@0O@5I04<a=`0Z00d0000b2PD0IP4100@01@4407d1F@0P<BD0100002L1ool@0000\n9PH?01H0ooooo`00m@X00?oooomH3@00e@0000@0000]0@4020000?X20004000000000P@0000]0@P0\n1`0001/4eP0N3Ooo<`/40000;@4500@0000]0@H010000?01200@00009PH?01H0ooooo`006@d004P0\n001M3@00S`0000P0003j0P001P00000000040000;@4800L0003l0P00oooo0000100002d12@0<0000\n90<401d=C01H3FH07@f:01d=C0040000;@4600@0003`0@P0100002d11@040000l04900P0000V1Pl0\n1P3ooooo0@040000;@4100@0000]0@801`0001/4S`3g2dD0A0/40000;@4500@0000]0@H00`0001h0\n1`0001H4SP3f2dD0A0/500000P410000100002d11`0500002@8000025000038:A@142`H010142dD0\nm@^>06U^D6mbM1<08P0U02405P0C00d0000b2TD0j0/100@0A0]50?D;SP0P01d0100002L1ool40000\n;@4100@0000]0@801`0001/4TP0H3D<0A0`40000;@4500@0000]0@H00`0001h01`0001H4T00H3D<0\nA0`500000P410000100002d11`0500002@8000025P00038:@`1430L0101434<05`f@06meM51_LW@0\n8@0R01<09@0Q01H04`0=0000<PY300T=0@0404@<@`0G3I00800M00@0000W0Ooo400002H63`0F0?oo\nool00?4:00180000=@/008l000080000nP8000H000000000100002d120070000o0800<30`00000@0\n000]0@T0300002@3103e2T`0<0]V0?D:RP3e2T`0100002d11P040000l04800@0000]0@D010000?01\n2@0800009PH?00H0ooooo`40100002d10@040000;@4200L0000K15P0JP`20?0;100002d11@040000\n;@4600<0000N00L0000F15L0J@`20?0;1@0000810@0000@0000]0@@01@0000T200000Ph0000b2P<0\nl0/200@0l0/206P<E`13=3L0:P0=0000<PX3054<0@040?0;0P1X35L083@U00@0000W0Ooo400002H6\n3`0F0?ooool008H9001U0000m0X006`000080000nP8000@000000000100002d120040000;@4100P0\n000U0`80R@UX0?0:J0040000;@4600@0003`0@P0100002d11@0800009PH?00H0ooooo`40400002H6\n3`0F0?ooool003D7003oooooV0T00=D000040000;@4100P0003j0P001000000000840000;@4800L0\n000K1=H0GPWoog<7100002d11@040000;@4600@0003`0@P0400002H63`0F0?ooool005T900180000\nW@T008l000080000nP8000H000000000100002d120070000o0800?ooo`0000@0000]0@T0300002@3\n101M2D`0V0UV05d9RP1M2D`0100002d11P040000l04800@0000]0@D010000?012@0800009PH?00H0\nooooo`40100002d10@040000;@4200L0000K18l0=`Q508@7100002d11@040000;@4600<0000N00L0\n000F18h0=PQ508@71@0000810@0000@0000]0@L01@0000T200000Q@0000b2TD0Q0L600@0Q0M503D8\nSP1YKU1_LW@C02809@0Q01H04`0=0000<PY502P80@0408@7A@0e28h0800M00@0000W0Ooo100002d1\n0@040000;@4200L0000K1980F0U308@8100002d11@040000;@4600<0000N00L0000F1900F0U308@8\n1@0000810@0000@0000]0@L01@0000T200000QH0000b2T<0Q0P700@0Q0Q305L9T01_MGA@Kg9d0240\n8P0C02D08@0F01<03@00038:@`192@40102424<0E`V@02007@0400009`7ooa00000V1Pl05P3ooooo\n000a1`00B00007D7002?000020000?X200060000000000@0000]0@P01`000?`20030`<0000040000\n;@4900`0000T0`@0=@M<0707IP0e1hX0=@M<00@0000]0@H010000?0120040000;@4500@0003`0@T0\n200002H63`060?ooool100@0000]0@40100002d10P0700006`AH0:X80P0`20@0000]0@D0100002d1\n1P0300007P0700005PAG0:T80P0`20D000020@4000040000;@4400D000090P00008>0000<PX30308\n0P0403080P2X25L0@c<g02X03@00038:0`2A2040100`2080Z0QG020c9@0400009`7ooa00000V1Pl0\n5P3ooooo003F0`00oooooc07003E0000100002d10@080000nP8000@000000002100002d120070000\n6`CF0?l5oolD10@0000]0@D0100002d11P040000l0480100000V1Pl05P3ooooo000X1P00I@0003@7\n001/000020000?X200040000000000@0000]0@P0100002d10@0800009@<202/6J00`1fP0100002d1\n1P040000l04800@0000]0@D0200002H63`060?ooool10100000V1Pl05P3ooooo003k1@00B00003l6\n002?000020000?X200060000000000@0000]0@P01`000?`2003oool000040000;@4900`0000T0`@0\no`E<03X6IP3o1HX0o`E<00@0000]0@H010000?0120040000;@4500@0003`0@T0200002H63`060?oo\nool100@0000]0@40100002d10P0700006`B?0=T4A@0U10@0000]0@D0100002d11P0300007P070000\n5PB>0=P4A@0U10D000020@4000040000;@4700D000090P00008D0000<PY502D41P0402D4A@3G18h0\nJFi@Kg9d4`0R02D08@0F01<03@00038:A@391040100U14D0e`B>02007@0400009`7oo`@0000]0@40\n100002d10P0700006`BB0?X5@`0V1@@0000]0@D0100002d11P0300007P0700005PB@0?T5@`0V1@D0\n00020@4000040000;@4700D000090P00008F0000<PY302H51`0402H5@`3h1I00KgEdD6mbM00Q0280\n4`0U02405P0C00d0000b2T<0j`D100@09PE30?P5T00P01d0100002L1ool@00009PH?01H0ooooo`00\ndP<004P0000F1000S`0000P0003j0P001P00000000040000;@4800L0003l0P00`<300000100002d1\n2@0<000090<40=H3C00A16H0eP>:0=H3C0040000;@4600@0003`0@P0100002d11@040000l04900P0\n000V1Pl01P3ooooo0@040000;@4100@0000]0@801`0001/4F01<1@80dP@40000;@4500@0000]0@H0\n0`0001h01`0001H4E`1;1@80dP@500000P410000100002d1100500002@8000023P00038:0`3B1080\n103B1080BPEG04<b=`0Z00d0000b2P<0<`D100@0dP@204X5E`0P<RD0100002L1ool@00009PH?01H0\nooooo`00JP800:42003C0`00Z@8000P0003j0P001000000000040000;@4800@0000]0@40200002D3\n0P1]0Z@2c`>U0P@0000]0@H010000?0120040000;@4500P0000V1Pl01P3ooooo0@0@00009PH?01H0\nooooo`001`0003/2001Z0P004P<000@0000]0@4020000?X20004000000000P@0000]0@P01`0001/4\n4`<`0S/2A@040000;@4500@0000]0@H010000?01200@00009PH?01H0ooooo`00;08008@2001`0P00\nb`8000P0003j0P001P00000000040000;@4800L0003l0P00oooo0000100002d12@0<000090<40302\nR09[0Z<2<0;60S02R0840000;@4600@0003`0@P0100002d11@040000l04900P0000V1Pl01P3ooooo\n0@040000;@4100@0000]0@801`0001/4c08:0H82EP040000;@4500@0000]0@H00`0001h01`0001H4\nbP890H82EP0500000P410000100002d11`0500002@8000025000038:PP9F00H0101F0882207:0VU^\nD6mbM1<08P0U02405P0C00d0000b2X82nP0100@0EP220PP1bP8P01d0100002L1ool40000;@4100@0\n000]0@801`0001/4cP8[0Wl2E`440000;@4500@0000]0@H00`0001h01`0001H4c@8Z0Wl2E`450000\n0P410000100002d11`0500002@8000025P00038:O`9G0@L0101G0Gl2:@;=0VmeM51_LW@08@0R01<0\n9@0Q01H04`0=0000<PYo0Q`20@0405L1O`8Y0/d2800M00@0000W0Ooo400002H63`0F0?ooool000<0\n00240P00A`000</200080000nP8000H000000000100002d120070000o0800<30`00000@0000]0@T0\n300002@3100708P2@P2S0PL0aP8708P2100002d11P040000l04800@0000]0@D010000?012@080000\n9PH?00H0ooooo`40100002d10@040000;@4200L0000K19D2O@4n0P<1100002d11@040000;@4600<0\n000N00L0000F19<2O04n0P<11@0000810@0000@0000]0@@01@0000T200000Ph0000b2Sl20`4200@0\n0`4n0W/1T`93<CL0:P0=0000<PXo0V@10@0400<1?P9k0I<2834U00@0000W0Ooo400002H63`0F0?oo\nool00?8:000i0P00E@d000l300040000;@4100P0003j0P001000000000840000;@4800L0000K1103\n6`di0S0;100002d11@040000;@4600@0003`0@P0400002H63`0F0?ooool001L=00220P00F`d00<T2\n00080000nP8000H000000000100002d120070000o0800?ooo`0000@0000]0@T0300002@3100K3HH2\nEPfP0Q/=a08K3HH2100002d11P040000l04800@0000]0@D010000?012@0800009PH?00H0ooooo`40\n100002d10@040000;@4200L0000K1<T2m@]o0T4;100002d11@040000;@4600<0000N00L0000F1<P2\nm0]o0T4;1@0000810@0000@0000]0@L01@0000T200000Q@0000b2Wl2@@/600@0@@]o0_<;b09YKU1_\nLW@C02809@0Q01H04`0=0000<PYo0^D;0@04044;O`;c2lP2800M00@0000W0Ooo100002d10@040000\n;@4200L0000K1<`25Pem0T8<100002d11@040000;@4600<0000N00L0000F1<X25@em0T8<1@000081\n0@0000@0000]0@L01@0000T200000QH0000b2Wd2@P`700@0@Pam0Q@=bP9_MGA@Kg9d02408P0C02D0\n8@0F01<03@00038:O@873@40101237d250g:0R007@0400009`7ooa00000V1Pl05P3ooooo003^2P00\nPP80038;00390P0020000?X200060000000000@0000]0@P01`000?`20030`<0000040000;@4900`0\n000T0`@0lPZ60Rd;X0;b2/@2lPZ60P@0000]0@H010000?0120040000;@4500@0003`0@T0200002H6\n3`060?ooool100@0000]0@40100002d10P0700006`BB0VP<?0;^2`@0000]0@D0100002d11P030000\n7P0700005PBA0VL<?0;]2`D000020@4000040000;@4400D000090P00008>0000<PXm0^d;0P040>d;\n?09V3942@c@g02X03@00038:?@9>3040103]2c`2IPbA0R0d9@0400009`7ooa00000V1Pl05P3ooooo\n00232@00W`800?4:002V0P0020000?X200040000000000@0000]0@P0100002d10@0800009@<208H9\nXP;]2Z82100002d11P040000l04800@0000]0@D0200002H63`060?ooool10100000V1Pl05P3ooooo\n000b1`00>@8009D9000?0`00100002d10@080000nP8000@000000002100002d1200700006`@@0e/9\n>@9`1`@0000]0@D0100002d11P040000l0480100000V1Pl05P3ooooo001G2@00PP8009/900390P00\n20000?X200060000000000@0000]0@P01`000?`2003oool000040000;@4900`0000T0`@0F`V60YH9\nX09K2L@2F`V60P@0000]0@H010000?0120040000;@4500@0003`0@T0200002H63`060?ooool100@0\n000]0@40100002d10P0700006`C90SD8O`:11`@0000]0@D0100002d11P0300007P0700005PC80S@8\nO`:11`D000020@4000040000;@4700D000090P00008D0000<PYo0X471P040847O`8c2<P2JFi@Kg9d\n4`0R02D08@0F01<03@00038:O`8U204010211gl2<`S80R007@0400009`7oo`@0000]0@40100002d1\n0P0700006`C<0UH9O@:220@0000]0@D0100002d11P0300007P0700005PC:0UD9O@:220D000020@40\n00040000;@4700D000090P00008F0000<PYm0X881`040888O@9D2LX2KgEdD6mbM00Q02804`0U0240\n5P0C00d0000b2Wd2A`T100@0PPQm0U@9bP8P01d0100002L1ool@00009PH?01H0ooooo`00;PL00882\n001b1`00b@8000P0003j0P001P00000000040000;@4800L0003l0P00`<300000100002d12@0<0000\n90<40387QP9]1j02<PO40S87QP840000;@4600@0003`0@P0100002d11@040000l04900P0000V1Pl0\n1P3ooooo0@040000;@4100@0000]0@801`0001/4TP:X23`2;PP40000;@4500@0000]0@H00`0001h0\n1`0001H4T@:W23`2;@P500000P410000100002d1100500002@8000023P00038:?@8]2080100]23`2\nYPRA0T<c=`0Z00d0000b2Sd2SPP100@0;@Pl0ZH8T@8P<bD0100002L1ool@00009PH?01H0ooooo`00\ne0<003T2000^1`003`<000@0000]0@4020000?X20004000000000P@0000]0@P01`0001/440?m1CT2\n4P@40000;@4500@0000]0@H010000?01200@00009PH?01H0ooooo`009@H009l2000b1`00YP8000P0\n003j0P001000000000040000;@4800@0000]0@40200002D30P0X1Z82;PNR0P@0000]0@H010000?01\n20040000;@4500P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00n0D00882000l1P00b@8000P0\n003j0P001P00000000040000;@4800L0003l0P00oooo0000100002d12@0<000090<40?`5QP8g1Z02\no0G40_`5QP840000;@4600@0003`0@P0100002d11@040000l04900P0000V1Pl01P3ooooo0@040000\n;@4100@0000]0@801`0001/4b@;F17l28`@40000;@4500@0000]0@H00`0001h01`0001H4b0;E17l2\n8`@500000P410000100002d11`0500002@8000025000038:O`8S10H0100S17l2e0C80VU^D6mbM1<0\n8P0U02405P0C00d0000b2Wl2a`@100@08`Ao0]@4b08P01d0100002L1ool40000;@4100@0000]0@80\n1`0001/4c0;g1Gd28`D40000;@4500@0000]0@H00`0001h01`0001H4bP;g1Gd28`D500000P410000\n100002d11`0500002@8000025P00038:O@8S1@L0100S1Gd2mPG:0VmeM51_LW@08@0R01<09@0Q01H0\n4`0=0000<PYm0^P50@0402<5O@;f1LX2800M00@0000W0Ooo400002H63`0F0?ooool00=0300220P00\n50@00<T200080000nP8000H000000000100002d120070000o0800<30`00000@0000]0@T0300002@3\n103D0hH23`BP0]@3a0;D0hH2100002d11P040000l04800@0000]0@D010000?012@0800009PH?00H0\nooooo`40100002d10@040000;@4200L0000K1982B@Dl0/l4100002d11@040000;@4600<0000N00L0\n000F1942B0Dl0/l41@0000810@0000@0000]0@@01@0000T200000Ph0000b2Sd2c`@200@0c`@l0TL5\nT@93<SL0:P0=0000<PXm0S050@040<l4?0971I42838U00@0000W0Ooo100002d10@080000nP8000P0\n00000002100002d1200700006`Af0m09d@6I0`@0000]0@D0100002d11P040000l0480100000V1Pl0\n5P3ooooo001J0`00Q08009h3003;0P0020000?X200060000000000@0000]0@P01`000?`20030`<00\n00040000;@4900`0000T0`@0GP>80YT3X`9N0lH2GP>80P@0000]0@H010000?0120040000;@4500@0\n003`0@T0200002H63`060?ooool10100000V1Pl05P3ooooo003<2@00O`80010:00360P0020000?X2\n00060000000000@0000]0@P01`000?`2003oool000040000;@4900`0000T0`@0d0V30P/:WP;@2L42\nd0V30P@0000]0@H010000?0120040000;@4500@0003`0@T0200002H63`060?ooool100@0000]0@40\n100002d10P0700006`An0YP3=0;U0P@0000]0@D0100002d11P0300007P0700005PAm0YP3=0;U0PD0\n00020@4000040000;@4700D000090P00008D0000<PXd0^D21P040>D2=0:G0gd2JFi@Kg9d4`0R02D0\n8@0F01<03@00038:=0:90`40103U0S@2U`=m0R007@0400009`7oo`@0000]0@40100002d10P070000\n6`AI0QD7i`5^1P@0000]0@D0100002d11P0300007P0700005PAG0Q@7i`5^1PD000020@40000L0000\nn`:Lo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0000]0@P0\n1@0000T200000Ph0000b2^L1KPH200@0KPKW0A<7E`9=<ET0<P0=0000<P[W0OT60@0406h6i`4C1eL2\n834]00@0000W0Ooo100002d10@040000;@4200L0000K17h2[PX_0]/9100002d11@040000;@4600<0\n000N00L0000F17d2[PX_0]/91@0000810@0000@0000]0@L01@0000T200000QH0000b2Rl2f`T700@0\nf`T_0Zd:O@9_MGA@Kg9d02408P0C02D08@0F01<03@00038:;`:P2P40103K2Bl2[@Ym0R0a7@040000\n9`7oo`@0000]0@<010000?0110040000l04700@0003`0@P01`000?`2003oool000040000;@4400P0\n003j0P000000000000040000;@4700@0000W0Ooo200002H63`060?ooool100@0000W0Ooo70000?/2\n40070000002l0P0000010P8RDgUcM6E]000000X000040000000800000@000000<0040000;@4800<0\n00000140000<0000200000/0000@0000JP8009L000090000400006X2002G00002P00010000000000\n000000T0000@0000GPd007h3001B0000L0400040002Loooo0000000000000000T04000000004@00B\nE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h00000000000000000000000000000000000000000\n0000000000000P00000C063U60011000:?DB0>>co7LF]Oag;KGlM`0000200000n98H00004`0X31<0\n7P000:Qk5`2Lla80J>DH07P14`2XCQT0N04C0?oooomXmA80@0HC02P<4`000000000005d78AOP;HT1\n900000C:Q_jD:X`1000H07P14`04m18000000:a^?09`35X0J>DH07P14`1XiAP0N04C063U603h0a<0\nn0<C00X000010000n0<C0000603XUAP0J>DH07P14`1PiAP0N04C07P14`3`TQP00000000000090000\nn98H0:Sd4P3T_aP0`/3dM`40001TMP08000002D0000<00000@000180000<00000@0001P0000<0000\n00000R40000800007P0001P000000000000005h=001n0`008@0000P0000F000030000000001h0000\n4000000000000000600000`0000000006@0000`0003oool09@0000`0000500209@0000`000080020\n7`0001P0001W3@00GPd007h3001n0`002P00010000000000000000T0000@0000I`d007h300090000\n400006L=001n0`00DP00070100020000500000T00000000000000;`20000000010828U<0N@1c07@0\nI@1]00000000000000000000000000000000000000000000000000000000000000000000000001<0\n000H0>RE601XiAP0N04C063U601h0A<0N04C0?2B60000000000000T0003hTQP0Z?@B0>Bo6032`?Ag\n0@0006Af00P00000Z4hI07P14`3oooooJ?DB04064`0X31<000000000001M1b4Gh2f90B@00004bXKn\nU2Z<0@00601h0A<01?@B0000002/KS`2L0aJ06SU601h0A<0J>DH07P14`1PiAP0n0<C010Rm7O4l?eo\n0>3mO`400000000000000000003o0P0004000?l21<h10000I?@B02D0003hTQP02@000?RB602Xm180\n9<4H0<;0m7L10000I7H02000000U000030000080000B000030000040001B0000L04000<0002]oooo\n0000000000000000T04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000\n00000000000000000000000000000000000000000000000000000000003o0P0004000?l21<h10000\nI?@B02D0003hTQP02@000?RB602Xm1809<4H0<;0m7L10000I7H02000002XCQT0N04C0?oooomXmA80\n@0HC02P<4`000000000005d78AOP;HT1900000C:Q_jD:X`1000H07P14`04m18000000:a^?09`35X0\nJ>DH07P14`1XiAP0N04C063U603h0a<042;dMlC`oGl0h?eo0@0000000000000000000?l20000@000\no`84cP40001Tm1809@000?RB6028m180H@L005C0m7L100006@2`0F472QYTMP08000002D0000<0000\n0`0001P0000<000000000PX0000@000000000000001D0000E0000000000000001P0000l000010000\nMdn7@7lOQd0000000@000040001<00001000000000000000I`d007h3001@0000800002D0000V0000\n700000@00000000010000000000000009@0000`0000400009@0000`000050020E`0002@0001`0000\n4P000;00000B00000P0006l2JP3A0f/09P0001`0000500000000000000000000000002D0000<0000\n1@0002P0000<0000100002L0000H000010000000003oool0000002D0000<0000100002D0000<0000\n1@00P2H0000L00001P0000000004000000000000008U0000300000H0000[0000600004P000010000\n;@800=<0000U0000300000@0000U0000300000D0000X0000300000H0000V0000700000H000000000\n1P000000000000009@0000`0000600009`0001P00007000000000?ooo`0000009@0000`000070000\nEP0002`0001U00003@000700000H000010000382CP1]0VT0<P:<0382CP0U0000300000D0000X0000\n300000H0000U0000300000@0000X0000300000L0000U0000300000D0080U0000300000P0080[0000\n600005T0001800001`4008`0000U0000300000@0000U0000300000D0000Q0000200001h0000H0000\nF00004P0000;0@00T0000180000<00000@000580001`0@001`000;goool0000000000000002@0@00\n000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640KP000000000000000000000000000000\n0000000000000000000H032h6000000000000?l20000@000o`84cP40001Tm1809@000?RB6028m180\nc?<B0000003U>?Qg000C06195P000000Z?<B08P64`1Lm180UB_hM`004`0400000?@B042go7Mh1a<0\n0DTF00@0001Xla800000033d4P000?Qg63KhMooooom0m180PW?XM`004`000000<;PH0<@44>8`^1P0\n883gMoP34`0@8_Aga?3mO`3PoGl100000000000000000000o`800010003o0PC@0@0006Cd4P3`<OAg\no`84d5d78AOo0PC@000000C@0020m180T=;dMfAf00P000009@0000`000070000E0000700000@0000\n300002d0000G00000@0007M?Qd1o7hM0F00004P000060000C00000@0001H0000B00000X1002@0000\nF00006T0KP1@06l0LP1d01<0000R00009@000240000F00004`0005@0001D0000;@0000`0000_0000\n5`000040001gChM0Oan7@?`0001800000@0004`000040000F00004P0000:0@00T0000500000P0000\n7@000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H0000F@4004D0000X0P00\nSP0002D0000<0000100002D0000<00001@000240000800007P0001P0001I0@00A@0002d2002C0000\n4P0000`0000100009@0000`000070000600000`000000002E00007P0000n000030000640000H0000\n0@0007M?Qd1o7hM0F@4004D000070000C00000@0001I0@00A@0002`2002C0000G00006l0M@1d0500\nK`1b07@0000Q00008P0001<0000U00008@0001H0000C0000E00005@0001R0000300006<0000H0000\n0@0007M?Qd1o7hM07P8004D000010000C00000@0001I0@00A@0002`2002C0000D0000200000M0000\n8P0000`0003ooooo9P0001`000060000000000H000000000000002D0000<00001P0002L0000H0000\n200000000030`<00000002D0000<0000200005H0000/00000P0000d0000<0000600000@0000:04h0\nA@1Y00X0S00:04h09@0000`000050000:00000`0000600009@0000`000040000:00000`000080000\n9@0000`0000500209@0000`000080020:`0001P000050@00100007X1001E00009@0000`000040000\n9@0000`0000500008@0000P0000N0000600000D100040000OP4005T0000B000030000040000U0000\n300000<0000H000030000000009D0000F00002l000010000@00000h000010000Mdn7@7lOQd050@00\n1@000080001<0000100000D100040000O@4005T0001@0000@`0a03L0000Z0000E00005@000110000\n0@0004@0000>00000@0007M?Qd1o7hM0IP4000D000010000C00000@000050@00100007d1001I0000\nD0000200000U00008P0000`0003ooooo9@0000`0000500209P0001`000080000000000@000000000\n00000RD0000<0000200002/0000H0000<`/00?oooolH3@00d00002D0000<0000100002D0000<0000\n1@0002P0000<0000200002H0000L0000200000000006000000000000000U0000300000P0000W0000\n600000H000000000oooo0000000U0000300000H0001F0000;00005h2000=0000J08001L000040000\n7@e<05P=IP0M3HX07@e<02D0000<00001@0002P0000<0000200002D0000<0000100002P0000<0000\n1P0002D0000<00001@00P2D0000<00002000P2/0000H0000A0/004D0003b2`00R@0002D0000<0000\n100002D0000<00001@000240000800007P0001P000142`00A@000?H;002>00004P0000`000010000\n9@0000`000070000600000`000000002E000070000080P00300002D2000G00000@0007M?Qd1o7hM0\nA0/004D000060000C00000@000142`00A@000?D;002>0000F00006T0KP1@06l0LP1d01<0000R0000\n9@000240000F00004`0005@0001D00009P8000`0000W0P005`000040001gChM0Oan7@>P;00150000\n0@0004`000040000A0/004D0003e2`00SP000500000P00007@000280000<0000ooooobD0000<0000\n1@00P2D0000<00002000P2/0000H0000A0`004<0000B3@00S00002D0000<0000100002D0000<0000\n1@000240000800007P0001P000143000@`0001P=002@00004P0000`0000100009@0000`000070000\n600000`000000002E00007P0000g0P002`0005X2000G00000@0007M?Qd1o7hM0A0`004<000070000\nC00000@000143000@`0001L=002@0000G00006l0M@1d0500K`1b07@0000Q00008P0001<0000U0000\n8@0001H0000C0000E00005@0001J0P002`0005`2000G00000@0007M?Qd1o7hM02@d004<000010000\nC00000@000143000@`0001L=002@0000D0000200000M00008P0000`0003ooooo9P0001`000060000\n000000H000000000000002D0000<00001P0002L0000H0000200000000030`<00000002D0000<0000\n200005H0000/0000nP4000d000050P005`0000@0003e2T`0<0]V0?D:RP3e2T`09@0000`000050000\n:00000`0000600009@0000`000040000:00000`0000800009@0000`0000500209@0000`000080020\n:`0001P0003`2`000P0006D<001B00009@0000`0000400009@0000`0000500008@0000P0000N0000\n60000?0;00020000J@`005L0000B000030000040000U0000300000<0000H000030000000009D0000\nF00002L200010000>08000h000010000Mdn7@7lOQd3`2`000`000080001<000010000?0;00020000\nJ0`005L0001@0000@`0d03L0000Z0000E00005@0000i0P000@0003`2000>00000@0007M?Qd1o7hM0\nD@`000<000010000C00000@0003`2`000P0006P<001G0000D0000200000U00008P0000`0003ooooo\n9P0001`000080000000000@000000000000002D0000<0000200002D0000<00001@00P5L0000T0000\n^0400180003i0@004P00008000292FP0l0YX02D0000<00001@0002P0000<0000200002D0000<0000\n100002D0000<00001@00P2H0000L0000200000000004000000000000008U0000300000P0000[0000\n600007<7003oooooF0T00=00000U0000300000@0000U0000300000D0000X0000300000P0000V0000\n700000P0000000001P000000000000009@0000`0000800009`0001P00006000000000?ooo`000000\n9@0000`000060000EP0002`0002`0@003@000;/1000G0000100005d9C02H2FH0G@V:05d9C00U0000\n300000D0000X0000300000P0000U0000300000@0000X0000300000H0000U0000300000D0080U0000\n300000P0080[0000600008@700150000<PP008T0000U0000300000@0000U0000300000D0000Q0000\n200001h0000H0000Q0L004D0000f2000SP000180000<00000@0002D0000<00001`0001P0000<0000\n00000U@0001`0000F`4000`0001h0@005`000040001gChM0Oan7@8@7001500001P0004`000040000\nQ0L004D0000e2000SP0005P0001Y06h0D01_0780M00C00008P0002D0000Q00005P0001<0001D0000\nE00007T1000<0000NP4001L000010000Mdn7@7lOQd0X2000A@000040001<0000100008@700150000\n=@P008h0001@0000800001d0000R000030000?oooolU0000300000D0080U0000300000P0080[0000\n600008@800130000D`T008`0000U0000300000@0000U0000300000D0000Q0000200001h0000H0000\nQ0P004<0001H2@00T0000180000<00000@0002D0000<00001`0001P0000<000000000U@0001h0000\nR@4000/0002/0@005`000040001gChM0Oan7@8@8001300001`0004`000040000Q0P004<0001G2@00\nT00005`0001_07D0M01@06l0LP1d00008@000280000C00009@000240000F00004`0005@0001D0000\n[@4000/0002^0@005`000040001gChM0Oan7@4T9001300000@0004`000040000Q0P004<0001G2@00\nT0000500000P00007@000280000<0000ooooobH0000L00001P0000000006000000000000000U0000\n300000H0000W0000600000P000000000`<300000000U0000300000P0001F0000;00004d1000=0000\nF04001L000040000=@M<0707IP0e1hX0=@M<02D0000<00001@0002P0000<00001P0002D0000<0000\n100002P0000<0000200002D0000<00001@00P2D0000<00002000P2/0000H0000<0P00080002U2000\nDP0002D0000<0000100002D0000<00001@000240000800007P0001P0000`20000P000:T8001G0000\n4P0000`0000100009@0000`000030000600000`000000002E00005P0001j0@000@0008/1000>0000\n0@0007M?Qd1o7hM0<0P000<000020000C00000@0000`20000P000:P8001G0000D00004<0<`0g0000\n:P0005@0001D0000S0400040002?0@003P000040001gChM0Oan7@948000300000@0004`000040000\n<0P00080002X2000E`000500000P00009@000280000<0000ooooobD0000<00001@00P2H0000L0000\n200000000004000000000000008U0000300000P0000[0000600001@4003ooooon@D00=00000U0000\n300000@0000U0000300000D0000X0000300000P0000V0000700000P0000000001000000000000000\n9@0000`0000800009@0000`000050020E`0002@0000M0@004P0004`1000B00000P0002/6J00`1fP0\n9@0000`000050000:00000`0000800009@0000`0000400009P0001`000080000000000H000000000\n000002D0000<0000200002L0000H00001P000000003oool0000002D0000<00001P0005H0000/0000\n5@4000d0000P0@005`0000@0003o1D`0>PIV0?l5RP3o1D`09@0000`000050000:00000`000080000\n9@0000`000040000:00000`0000600009@0000`0000500209@0000`000080020:`0001P0000U1000\nA@000=<4002900009@0000`0000400009@0000`0000500008@0000P0000N0000600002D400150000\nf0@008h0000B000030000040000U0000300000L0000H000030000000009D0000L0000;l0000<0000\ng00001L000010000Mdn7@7lOQd0U1000A@0000H0001<0000100002D400150000e`@008h0001H0000\nJ@1^0500K`1b07@04`000280000U00008@0001H0000C0000E00005@0003M000030000=l0000G0000\n0@0007M?Qd1o7hM0b@@004D000010000C00000@0000U1000A@000=L4002>0000D0000200000M0000\n8P0000`0003ooooo9@0000`0000500209@0000`000080020:`0001P0000V1@00@`000?D5002<0000\n9@0000`0000400009@0000`0000500008@0000P0000N0000600002H500130000n@D00900000B0000\n30000040000U0000300000L0000H000030000000009D0000N0000>h0000;00004@4001L000010000\nMdn7@7lOQd0V1@00@`0000L0001<0000100002H500130000n0D00900001L0000K`1e07@0D01_0780\nM0000240000R00004`0002D0000Q00005P0001<0001D0000E0000141000;00004`4001L000010000\nMdn7@7lOQd3[1@00@`000040001<0000100002H500130000n0D00900001@0000800001d0000R0000\n30000?oooolV0000700000H0000000001P000000000000009@0000`0000600009`0001P000080000\n00000<30`00000009@0000`000080000EP0002`0002a00003@000;`0000G000010000=H3C00A16H0\neP>:0=H3C00U0000300000D0000X0000300000H0000U0000300000@0000X0000300000P0000U0000\n300000D0080U0000300000P0080[000060000=8400020000APD00580000U0000300000@0000U0000\n300000D0000Q0000200001h0000H0000dP@00080001;1@00E`000180000<00000@0002D0000<0000\n0`0001P0000<000000000U@0001H0000g`000040003`00003P000040001gChM0Oan7@=8400030000\n0P0004`000040000dP@00080001:1@00E`00050000130380=`0002X0001D0000E0000?0000010000\nl`0000h000010000Mdn7@7lOQd0c1@000`000040001<000010000=8400020000BPD005L0001@0000\n800002D0000R000030000?oooolV0000700000P00000000010000000000000009@0000`000080000\n9@0000`000050020E`0002@0001`0000LP000;00001b00000P0006d2Y0;?0jD29@0000`000050000\n:00000`0000800009@0000`0000400009@0000`0000500209P0001`000080000000000@000000000\n00000RD0000<0000200002/0000H0000A@0003/2000[0P003@<002D0000<0000100002D0000<0000\n1@0002P0000<0000200002H0000L0000200000000006000000000000000U0000300000P0000W0000\n600000H000000000oooo0000000U0000300000H0001F0000;00006D0001]0000L00007P000040000\n<0:80V/2X`8`0/H2<0:80RD0000<00001@0002P0000<0000200002D0000<0000100002P0000<0000\n1P0002D0000<00001@00P2D0000<00002000P2/0000H0000EP00088200050@00aP8002D0000<0000\n100002D0000<00001@000240000800007P0001P0001F0000PP8000T1003:0P004P0000`000010000\n9@0000`000070000600000`000000002E0000700000@0000K00002d0001h00000@0007M?Qd1o7hM0\nEP00088200060000C00000@0001F0000PP8000P1003:0P00F00006T0KP1@06l0LP1d01<0000R0000\n9@000240000F00004`0005@0001D0000;@0006`0000_0000N0000040001gChM0Oan7@?X000220P00\n0@0004`000040000EP00088200080@00bP800500000P00007@000280000<0000ooooobD0000<0000\n1@00P2D0000<00002000P2/0000H0000E`4007l2000U0P00b08002D0000<0000100002D0000<0000\n1@000240000800007P0001P0001G0@00O`8002X2003=0P004P0000`0000100009@0000`000070000\n600000`000000002E00007P0000n0000K0000640001h00000@0007M?Qd1o7hM0E`4007l200070000\nC00000@0001G0@00O`8002T2003=0P00G00006l0M@1d0500K`1b07@0000Q00008P0001<0000U0000\n8@0001H0000C0000E00005@0001Q0000K00006<0001h00000@0007M?Qd1o7hM0708007l200010000\nC00000@0001G0@00O`8002T2003=0P00D0000200000M00008P0000`0003ooooo9P0001`000060000\n000000H000000000000002D0000<00001P0002L0000H0000200000000030`<00000002D0000<0000\n200005H0000/00000@0006d0000<0000N00000@0000708P2@P2S0PL0aP8708P29@0000`000050000\n:00000`0000600009@0000`000040000:00000`0000800009@0000`0000500209@0000`000080020\n:`0001P000030@00?P8007P1002?0P009@0000`0000400009@0000`0000500008@0000P0000N0000\n600000<1000n0P00O04009<2000B000030000040000U0000300000<0000H000030000000009D0000\nF00002l0001Q0000@00006h000010000Mdn7@7lOQd030@00?`800080001<0000100000<1000n0P00\nN`4009<2001@0000@`0a03L0000Z0000E00005@000100000H@0004<0001^00000@0007M?Qd1o7hM0\nI04003l200010000C00000@000030@00?P8007/1002C0P00D0000200000U00008P0000`0003ooooo\n9@0000`0000500209P0001`000080000000000@00000000000000RD0000<0000200002/0000H0000\n<0/003T2000F3@002P<002D0000<0000100002D0000<00001@0002P0000<0000200002H0000L0000\n200000000006000000000000000U0000300000P0000W0000600000H000000000oooo0000000U0000\n300000H0001F0000;00005d2001]0000J08007P0000400006`f60UH=X08K3L@26`f60RD0000<0000\n1@0002P0000<0000200002D0000<0000100002P0000<00001P0002D0000<00001@00P2D0000<0000\n2000P2/0000H0000@@/007l2003_2`00``8002D0000<0000100002D0000<00001@00024000080000\n7P0001P000112`00O`800?@;00380P004P0000`0000100009@0000`000070000600000`000000002\nE000070000080P00K00002D2001g00000@0007M?Qd1o7hM0@@/007l200060000C00000@000112`00\nO`800?<;00380P00F00006T0KP1@06l0LP1d01<0000R00009@000240000F00004`0005@0001D0000\n9@8006`0000W0P00M`000040001gChM0Oan7@>D;001o0P000@0004`000040000@@/007l2003c2`00\nb0800500000P00007@000280000<0000ooooobD0000<00001@00P2D0000<00002000P2/0000H0000\n@P`007d2000@3@00aP8002D0000<0000100002D0000<00001@000240000800007P0001P000123000\nO@8001D=003:0P004P0000`0000100009@0000`000070000600000`000000002E00007P0000f0P00\nK00005T2001h00000@0007M?Qd1o7hM0@P`007d200070000C00000@000123000O@8001@=003:0P00\nG00006l0M@1d0500K`1b07@0000Q00008P0001<0000U00008@0001H0000C0000E00005@0001J0P00\nK00005/2001h00000@0007M?Qd1o7hM01`d007d200010000C00000@000123000O@8001@=003:0P00\nD0000200000M00008P0000`0003ooooo9P0001`000060000000000H000000000000002D0000<0000\n1P0002L0000H0000200000000030`<00000002D0000<0000200005H0000/0000nP4006d000040P00\nN00000@0003b2XH2;@^P0_8:a0;b2XH29@0000`000050000:00000`0000600009@0000`000040000\n:00000`0000800009@0000`0000500209@0000`000080020:`0001P0003^2`00?080068<002<0P00\n9@0000`0000400009@0000`0000500008@0000P0000N000060000>d;000l0P00I``00942000B0000\n30000040000U0000300000<0000H000030000000009D0000F00002L2001Q0000>08006h000010000\nMdn7@7lOQd3]2`00?@800080001<000010000>d;000l0P00IP`00942001@0000@`0d03L0000Z0000\nE00005@0000h0P00H@0003`2001^00000@0007M?Qd1o7hM0CP`003d200010000C00000@0003]2`00\n?08006H<002A0P00D0000200000U00008P0000`0003ooooo9P0001`000080000000000@000000000\n000002D0000<0000200002D0000<00001@00P5L0000T0000^0400780003i0@00LP00008000262J82\nk@ZR0RD0000<00001@0002P0000<0000200002D0000<0000100002D0000<00001@00P2H0000L0000\n200000000004000000000000008U0000300000P0000[000060000707000i0P00E@T000X3000U0000\n300000@0000U0000300000D0000X0000300000P0000V0000700000P0000000001P00000000000000\n9@0000`0000800009`0001P00006000000000?ooo`0000009@0000`000060000EP0002`0002`0@00\nK@000;/1001h0000100005/9QP:F2J02F`W40U/9QP8U0000300000D0000X0000300000P0000U0000\n300000@0000X0000300000H0000U0000300000D0080U0000300000P0080[000060000847001o0P00\n<0P00<<2000U0000300000@0000U0000300000D0000Q0000200001h0000H0000P@L007l2000d2000\nb0800180000<00000@0002D0000<00001`0001P0000<000000000U@0001`0000F`4006`0001h0@00\nM`000040001gChM0Oan7@847001o0P001P0004`000040000P@L007l2000c2000b08005P0001Y06h0\nD01_0780M00C00008P0002D0000Q00005P0001<0001D0000E00007P1001/0000NP4007L000010000\nMdn7@7lOQd0U2000O`800040001<000010000847001o0P00<`P00<P2001@0000800001d0000R0000\n30000?oooolU0000300000D0080U0000300000P0080[000060000888001m0P00D0T00<H2000U0000\n300000@0000U0000300000D0000Q0000200001h0000H0000PPP007d2001E2@00bP800180000<0000\n0@0002D0000<00001`0001P0000<000000000U@0001h0000R@4006`0002/0@00N0000040001gChM0\nOan7@888001m0P001`0004`000040000PPP007d2001D2@00bP8005`0001_07D0M01@06l0LP1d0000\n8@000280000C00009@000240000F00004`0005@0001D0000[@4006`0002^0@00N0000040001gChM0\nOan7@4L9001m0P000@0004`000040000PPP007d2001D2@00bP800500000P00007@000280000<0000\nooooobH0000L00001P0000000006000000000000000U0000300000H0000W0000600000P000000000\n`<300000000U0000300000P0001F0000;00004`1001]0000E`4007P000040000<PN60Vd7X08b1l@2\n<PN60RD0000<00001@0002P0000<00001P0002D0000<0000100002P0000<0000200002D0000<0000\n1@00P2D0000<00002000P2/0000H0000;PP003`2002S2000S08002D0000<0000100002D0000<0000\n1@000240000800007P0001P0000]2000?0800:L8002A0P004P0000`0000100009@0000`000030000\n600000`000000002E00005P0001j0@00H@0008/1001^00000@0007M?Qd1o7hM0;@P003d200020000\nC00000@0000]2000?0800:H8002A0P00D00004<0<`0g0000:P0005@0001D0000R`400640002>0@00\nKP000040001gChM0Oan7@8h8000m0P000@0004`000040000;@P003`2002V2000T@800500000P0000\n9@000280000<0000ooooobD0000<00001@00P2H0000L0000200000000004000000000000008U0000\n300000P0000[000060000184000i0P00m`D000X3000U0000300000@0000U0000300000D0000X0000\n300000P0000V0000700000P00000000010000000000000009@0000`0000800009@0000`000050020\nE`0002@0000L0@00LP0004`1001b00000P0002P6XP8^1j829@0000`000050000:00000`000080000\n9@0000`0000400009P0001`000080000000000H000000000000002D0000<0000200002L0000H0000\n1P000000003oool0000002D0000<00001P0005H0000/0000504006d0000O0@00N00000@0003l1HH2\n=`JP0_`5a0;l1HH29@0000`000050000:00000`0000800009@0000`000040000:00000`000060000\n9@0000`0000500209@0000`000080020:`0001P0000S1000O`800=4400330P009@0000`000040000\n9@0000`0000500008@0000P0000N0000600002<4001o0P00e@@00<P2000B000030000040000U0000\n300000L0000H000030000000009D0000L0000;l0001/0000g00007L000010000Mdn7@7lOQd0S1000\nO`8000H0001<0000100002<4001o0P00e0@00<P2001H0000J@1^0500K`1b07@04`000280000U0000\n8@0001H0000C0000E00005@0003M0000K0000=h0001g00000@0007M?Qd1o7hM0a`@007l200010000\nC00000@0000S1000O`800=@400380P00D0000200000M00008P0000`0003ooooo9@0000`000050020\n9@0000`000080020:`0001P0000S1@00O@800?8500360P009@0000`0000400009@0000`000050000\n8@0000P0000N0000600002<5001m0P00m`D00<X2000B000030000040000U0000300000L0000H0000\n30000000009D0000N0000>d0001/0000404007P000010000Mdn7@7lOQd0S1@00O@8000L0001<0000\n100002<5001m0P00mPD00<X2001L0000K`1e07@0D01_0780M0000240000R00004`0002D0000Q0000\n5P0001<0001D0000E0000141001/00004P4007P000010000Mdn7@7lOQd3X1@00O@800040001<0000\n100002<5001m0P00mPD00<X2001@0000800001d0000R000030000?oooolV0000700000H000000000\n1P000000000000009@0000`0000600009`0001P00008000000000<30`00000009@0000`000080000\nEP0002`0002a0000K@000;/0001h000010000=@3QP8?1:02e0?40]@3QP8U0000300000D0000X0000\n300000H0000U0000300000@0000X0000300000P0000U0000300000D0080U0000300000P0080[0000\n60000<l4000l0P00A0D008`2000U0000300000@0000U0000300000D0000Q0000200001h0000H0000\nc`@003`200181@00T@800180000<00000@0002D0000<00000`0001P0000<000000000U@0001H0000\ngP000640003_0000KP000040001gChM0Oan7@<l4000m0P000P0004`000040000c`@003`200171@00\nT@80050000130380=`0002X0001D0000E0000?00001Q0000l`0006h000010000Mdn7@7lOQd0`1@00\n?@800040001<000010000<l4000l0P00A`D00942001@0000800002D0000R000030000?oooolU0000\n300000D0080V0000700000P00000000020000000000000029@0000`000080000:`0001P0002I0`00\nd@400<X9001`0`009@0000`0000400009@0000`000050000:00000`0000800009P0001`000080000\n000000H000000000000002D0000<0000200002L0000H00001P0000000030`<00000002D0000<0000\n1P0005H0000/0000W00006d0002V0000N00000@0001N0hP2V@>S0Uh3aP9N0hP29@0000`000050000\n:00000`0000800009@0000`000040000:00000`0000600009P0001`000060000000000H000000000\n000002D0000<00001P0002L0000H000020000000003oool0000002D0000<0000200005H0000/0000\na@4006d0003@0@00M`0000@0003@2H<22`ZN0]09`@;@2H<29@0000`000050000:00000`000060000\n9@0000`000040000:00000`0000800009@0000`0000500209@0000`000080020:`0001P0003U0P00\n=08009<3001h0P009@0000`0000400009@0000`0000500008@0000P0000N000060000>D2000d0P00\nV0<007d2000B000030000040000U0000300000L0000H000030000000009D0000L00008H0001O0000\nX`0006/000010000Mdn7@7lOQd3U0P00=08000H0001<000010000>D2000d0P00U`<007d2001H0000\nJ@1^0500K`1b07@04`000280000U00008@0001H0000C0000E00005@0002S0000G`000:D0001[0000\n0@0007M?Qd1o7hM0R@<003@200010000C00000@0003U0P00=08009L3001m0P00D0000200000M0000\n8P0000`0003ooooo9@0000`0000500209@0000`000080020:`0001P0001^1P00i`4000l7001C0P00\n9@0000`0000400009@0000`0000500008@0000P0000N0000600006h6003W0@0050L005L2000B0000\n30000040001B0000L04000P0002Loooo0000000000000000T04000000004@00BE01Y06d0I@1c0200\nCP1U07L0801B06l0K@1Q06h00000000000000000000000000000000000000000000000006010=1P0\n00000000003o0P0004000?l21=010000I?@B0?0am7Oo0PC@G@LQ5lcc4P000000iCShM`004`0PFQh0\n00000:Sc4P281Q<0G?@B09D[n7LP>OQgooooofcd4P10]oagj0HC02QJ7P0XFQh08^<H02QJ7P0`m180\n003hMaPfn7Oooooo@?@B089cj7L001<0000000004`1V0a0:@3@H0220mgL4<P0042;dMlC`oGl0h?eo\n0@0000000000000000000?l20000@000o`844P40001Tm180l37dMol2119M1b4Go`844P0000044P00\nP?@B093Bm7MTMP08000002D0000<0000200001P0000<000000000U@0001H0000:@40058000120@00\nI0000040001gChM0Oan7@6h6003W0@000P0004`000040000KPH00>L1000C1`00E`800500001=0340\nF@000380001D0000E0000481001B0000AP4006@000010000Mdn7@7lOQd3i1P00i`400040001<0000\n100006h6003W0@004`L005L2001@0000800002d0000R000030000?oooolU0000300000D0080U0000\n300000P0080[000060000=/9000_0P00Z0X007P2000U0000300000@0000U0000300000D0000Q0000\n200001h0000H0000f`T002l2002^2P00O@800180000<00000@0002D0000<00001`0001P0000<0000\n00000U@0001h0000a`4005h0003Z0@00J`000040001gChM0Oan7@=/9000_0P001`0004`000040000\nf`T002l2002]2P00O@8005`0001_07D0M01@06l0LP1d00008@000280000C00009@000240000F0000\n4`0005@0001D0000j`4005h0003/0@00J`000040001gChM0Oan7@:0:000_0P000@0004`000040000\nf`T002l2002]2P00O@800500000P00007@000280000<0000ooooobD0000<00000P0002P0000<0000\n0`0002P0000<00001`0002P0000<0000200002L0000H000020000000003oool0000002D0000<0000\n200002H0000L00001`0000000000000000000000000U0000300000L0000R000030000?oooolR0000\n30000?oooomB0000L04000<0000@00001`00000000000000_080000000010P8RD`1i07<0M01U06d0\n0000000000000000000000000000000000000000000000000000000000000000000000006010=1P0\n00000000003o0P0004000?l211810000I?@B0?0am7Oo0P@BG@LQ5lcc4P000000iCShM`004`0PFQh0\n00000:Sc4P281Q<0G?@B09D[n7L001<01000003d4P10]oagj0HC005J7P0XFQh0J?<B0000000`m180\n003hMaPfn7Oooooo@?@B089cj7L001<00000040d601F1`Xl@3@H0220mgL4<P0002;dM`800000h?eo\n3?@B00000030mA80EQSZMk1ej7L00000oooo00000010=1P0_LKdMed78AM`m1800H000636m7MM1b4G\nL?@B0;20mgMTMP08000002D0000<00000`0002D0000<00001`00P2D0000<00000000P300000<0000\n3`00P2D0000<00003@00P4/0000@0000000000D0000X000030000040000X000030000080000X0000\n300000P0000X0000300000@0000X0000300000D0000X0000300000L0000X0000300000<0000>0000\n50000000000@00005000\n"], "Text", Rule[ImageSize, List[616, 149]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[BoxData[RowBox[List["Two", " ", "essentially", " ", "equivalent", " ", "example", " ", "circuits", " ", "of", " ", "four", " ", "connected", " ", "components", " ", "with", " ", "connectors", " ", "of", " ", "input", " ", "or", " ", "output", " ", RowBox[List["causality", ".", " ", "Within"]], " ", "the", " ", "lower", " ", "circuit", " ", "two", " ", "components", " ", "have", " ", "been", " ", "embeded", " ", "in", " ", "the", " ", "structured", " ", "component", " ", RowBox[List["M1", ".", " "]]]]], "NumberedFigure", Rule[TextAlignment, Left]]], Open]], Cell[CellGroupData[List[Cell["Inside Connectors", "Section"], Cell["There are certain rules for how to connect connectors with input or output causality. It is not possible to connect two inputs or two outputs, unless outside connectors are involved. The following example illustrates the upper circuit above.", "Text"], Cell["class C\n  SInPort inPort;\t\t\t\t\t\t// Input connector\n  SOutPort outPort;\t\t\t\t\t\t// Output connector\nend C;", "ModelicaInput"], Cell["", "Text"], Cell["class CInst\n  C C1, C2, C3, C4;\t\t\t\t\t\t// Instances of C\nequation\n  connect(C1.outPort, C2.inPort);\n  connect(C2.outPort, C3.inPort);  \n  connect(C3.outPort, C4.inPort);\nend CInst;", "ModelicaInput"], Cell["", "Text"], Cell["connector SInPort \t\t\t\t\t\t\"Simplified InPort connector\"\n  input Real signal;\nend SInPort;", "ModelicaInput"], Cell["", "Text"], Cell["connector SOutPort \t\t\t\t\t\t\"Simplified OutPort connector\"\n  output Real signal;\nend SOutPort;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Outside Connectors", "Section"], Cell["The following example illustrates the lower circuit above.", "Text"], Cell["class M\t\t\t\t\t\t\t\t\t\"Structured class M\"  \n  SInPort inport;\t\t\t\t\t\t// Outside input connector\n  SOutPort outport;\t\t\t\t\t\t// Outside output connector\t\n  C C2;\n  C C3;\nend M;", "ModelicaInput"], Cell[TextData[List["\nThe classes ", StyleBox["CInst", Rule[FontFamily, "Courier"]], " and ", StyleBox["MInst", Rule[FontFamily, "Courier"]], " is equivalent."]], "Text"], Cell[TextData[List["class MInst\n  M M1;\t\t\t\t\t\t\t\t\t// Instance of M  \nequation\n  connect(C1.outPort, M1.inPort);\t\t// Normal connection of outPort to inPort\n  ", StyleBox["connect(M1.inPort, C2.inPort);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Outside inPort connected to inside inPort\n  connect(C2.outPort, C3.inPort);\t\t// Inside outPort connected to inside inPort\n  ", StyleBox["connect(C3.outPort, M1.outPort);", Rule[FontColor, RGBColor[0, 0, 1]]], "\t\t// Inside outPort connected to outside outPort\n  connect(M1.outPort, C4.inPort);\t\t// Normal connection of outPort to inPort  \nend MInst;"]], "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[936, 887]], Rule[WindowMargins, List[List[4, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]