List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Mechanical Translational Coordinate Systems and Components", "Title"], Cell[CellGroupData[List[Cell["General Description", "Section"], Cell[TextData[List["Each mechanical component has an associated coordinate system, called ", StyleBox["frame", Rule[FontSlant, "Italic"]], ". This is true also for components in a simple domain like the 1D mechanical translational domain. Even the flanges in the 1D mechanical translational domain have their own coordinate systems. The connector classes  ", StyleBox["Flange_a", Rule[FontFamily, "Courier"]], " and ", StyleBox["Flange_b", Rule[FontFamily, "Courier"]], " used for flanges in the 1D translational mechanical domain are identical but have slightly different roles, somewhat analogous to the roles of ", StyleBox["PositivePin", Rule[FontFamily, "Courier"]], " and ", StyleBox["NegativePin", Rule[FontFamily, "Courier"]], " in the electrical domain. \n\nA f", StyleBox["lange_a", Rule[FontFamily, "Courier"]], " connector is used at the \[OpenCurlyDoubleQuote]left\[CloseCurlyDoubleQuote] side of a component, whereas a f", StyleBox["lange_b", Rule[FontFamily, "Courier"]], " connector is used at the \[OpenCurlyDoubleQuote]right\[CloseCurlyDoubleQuote] side of the component, represented by the empty square. Each flange has an internal coordinate system characterized by the unit vector n from left to right."]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Connectors", "Section"], Cell[TextData[List["The connector classes ", StyleBox["PositivePin", Rule[FontFamily, "Courier"]], " and ", StyleBox["NegativePin", Rule[FontFamily, "Courier"]], " are identical to ", StyleBox["Pin", Rule[FontFamily, "Courier"]], " and can be used in electrical components to help distinguish positive and negative pins."]], "Text"], Cell["// Current p.i flowing into positive pin\nconnector PositivePin = Modelica.Electrical.Analog.Interfaces.Pin;\t\t\t", "ModelicaInput"], Cell["", "Text"], Cell["// Current n.i flowing into negativ pin\nconnector NegativePin = Modelica.Electrical.Analog.Interfaces.Pin;\t\t\t", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Electrical Components", "Section"], Cell["partial model TwoPin\t\t\t\t\"Component with two electrical pins p and n and current i from p to n\"\n  Voltage v\t\t\t\t\t\t\t\"Voltage drop between the two pins (= p.v - n.v)\";\n  Current i\t\t\t\t\t\t\t\"Current flowing from pin p to pin n\";\n  PositivePin p;\n  NegativePin n;\nequation\n  v = p.v - n.v;\n  0 = p.i + n.i;\n  i = p.i;\nend TwoPin;\t\t\t\t\t\t\t\t// Same as OnePort in Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell[TextData[List["\nIn the idealized ", StyleBox["Resistor", Rule[FontFamily, "Courier"]], " class below, the \"coordinate system\" (the direction of current flow in the resistor) is from ", StyleBox["p", Rule[FontFamily, "Courier"]], " to ", StyleBox["n", Rule[FontFamily, "Courier"]], " as inherited from ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], ". "]], "Text"], Cell["model Resistor \n  extends TwoPin;\n  parameter Real R(unit = \"Ohm\") \t\t\"Resistance\";\nequation\n  v = R * i;\t\t\t\t\t\t\t// Resistor equation\nend Resistor;    ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Mechanical Connectors", "Section"], Cell["// \"Left\" flange class\nconnector Flange_a = Modelica.Mechanics.Translational.Interfaces.Flange_a;\t\t\t", "ModelicaInput"], Cell["", "Text"], Cell["// \"right\" flange class\nconnector Flange_b = Modelica.Mechanics.Translational.Interfaces.Flange_b;\t\t\t", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Mechanical Components", "Section"], Cell[TextData[List["The partial base class ", StyleBox["Compliant", Rule[FontFamily, "Courier"]], " below is extended by classes for compliant flexible mechanical components with two flanges. ", "It can be regarded as a 1D mechanical analogue of the ", StyleBox["TwoPin", Rule[FontFamily, "Courier"]], " base class from the electrical domain.", StyleBox[" ", Rule[FontSize, 11]], "A ", StyleBox["flange_a ", Rule[FontFamily, "Courier"]], "connector is used at the \"left\" side of a component, where as a ", StyleBox["flange_b connector ", Rule[FontFamily, "Courier"]], "is used at the \"right\" side of the component. \n"]], "Text"], Cell["partial model Compliant\t\t\t\t\t\t\t\t\"Compliant coupling of 2 translational 1D flanges\"\n  Flange_a flange_a\t\t\t\t\t\t\t\t\t\"Driving flange\";  \t\n  Flange_b flange_b\t\t\t\t\t\t\t\t\t\"Driven flange\";\n  Modelica.SIunits.Distance s_rel\t\t\t\t\t\"Relative distance between flange_a and flange_b\";\n  flow Modelica.SIunits.Force f\t\t\t\t\t\t\"Force between flanges, positive in direction of N\";\nequation\n  s_rel = flange_b.s - flange_a.s;\n  0 \t= flange_b.f + flange_a.f;\n  f\t  \t= flange_b.f;\nend Compliant;\t\t\t\t\t\t\t\t\t\t// From Modelica.Mechanics.Interfaces    ", "ModelicaInput"], Cell[TextData[List["\nThe ", StyleBox["Spring", Rule[FontFamily, "Courier"]], " class ", "b", "elow iherits all equations apart from the constitutive spring equation from its base ", StyleBox["class Compliant", Rule[FontFamily, "Courier"]], "."]], "Text"], Cell["model Spring \t\t\t\t\t\t\t\t\t\t\"Linear 1D translational spring\"\n  extends Compliant;\n  parameter Modelica.SIunits.Distance s_rel0 = 0\t\"Unstretched spring length\";\n  parameter Real c(unit = \"N/m\") = 1\t\t\t\t\"Spring constant\";\nequation\n  f = c*(s_rel - s_rel0);\t\t\t\t\t\t\t// Spring equation\nend Spring;    ", "ModelicaInput"]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[923, 892]], Rule[WindowMargins, List[List[1, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]