List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Multiple Connections to a Single Connector", "Title"], Cell[TextData[List["\nIn almost all previous examples we only connected two connectors. In fact, there is in general no limitation to the number of connections that can be made to a single connector, apart from connector classes that very specifically limits the cardinality of the connections. In the class ", StyleBox["ResistorCircuit", Rule[FontFamily, "Courier"]], " three resistors are connected at one node.\n"]], "Text"], Cell[TextData[List["model ResistorCircuit\t\t\t\t\t\n  Modelica.Electrical.Analog.Basic.Resistor R1(R = 100);\n  Modelica.Electrical.Analog.Basic.Resistor R2(R = 200);\n  Modelica.Electrical.Analog.Basic.Resistor R3(R = 300);\nequation\n  ", StyleBox["connect(R1.p, R2.p);\n  connect(R1.p, R3.p);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend ResistorCircuit;"]], "ModelicaInput"], Cell[TextData[List["\nAs usual the special operator ", StyleBox["connect", Rule[FontSlant, "Italic"]], " produces equations by taking into account what kind of variables , ", StyleBox["flow", Rule[FontFamily, "Courier"]], " or ", StyleBox["non-flow", Rule[FontFamily, "Courier"]], ", that are involved. The generated equations, based on equal potential at a connection point and Kirchhoff's current law, are as follows for this particular example:"]], "Text"], Cell["\t\t\t\t\tR1.p.v = R2.p.v;\n\t\t\t\t\tR1.p.v = R3.p.v;\n\n\t\t\t\t\tR1.p.i + R2.p.i + R3.p.i = 0;", "Program"], Cell[TextData[List["\nThe model ", StyleBox["TripleSprings", Rule[FontFamily, "Courier"]], " has three connected springs."]], "Text"], Cell[TextData[List["model TripleSprings\n  Modelica.Mechanics.Rotational.Spring spring1(c = 1, s_rel0 = 0.1);\n  Modelica.Mechanics.Rotational.Spring spring2(c = 1, s_rel0 = 0.1);\n  Modelica.Mechanics.Rotational.Spring spring3(c = 1, s_rel0 = 0.1);\nequation\n  ", StyleBox["connect(spring1.flange_a, spring2.flange_a);  \n  connect(spring1.flange_a, spring3.flange_a);", Rule[FontColor, RGBColor[0, 0, 1]]], "\nend TripleSprings;  "]], "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[888, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]