List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["An Oscillating Mass Connected to a Spring", "Title"], Cell[CellGroupData[List[Cell["Components", "Section"], Cell["partial model Compliant\t\t\t\t\t\t\t\t\"Compliant coupling of 2 translational 1D flanges\"\n  Modelica.Mechanics.Translational.Interfaces.Flange_a flange_a\t\t\t\"Driving flange\";  \t\n  Modelica.Mechanics.Translational.Interfaces.Flange_b flange_b\t\t\t\"Driven flange\";\n  Modelica.SIunits.Distance s_rel \t\t\t\t\t\"Relative distance between flange_a and flange_b\";\n  flow Modelica.SIunits.Force f\t\t\t\t\t\t\"Force between flanges, positive in direction of N\";\nequation\n  s_rel = flange_b.s - flange_a.s;\n  0 \t= flange_b.f + flange_a.f;\n  f\t  \t= flange_b.f;\nend Compliant;", "ModelicaInput"], Cell["", "Text"], Cell["model Spring \t\t\t\t\t\t\t\t\t\t\"Linear 1D translational spring\"\n  extends Compliant;\n  parameter Modelica.SIunits.Distance s_rel0 = 0\t\"Unstretched spring length\";\n  parameter Real c(unit = \"N/m\") = 1\t\t\t\t\"Spring constant\";\nequation\n  f = c*(s_rel - s_rel0);\t\t\t\t\t\t\t// Spring equation\nend Spring;    ", "ModelicaInput"], Cell["", "Text"], Cell["model Mass \t\t\t\t\t\t\t\t\t\t\t\"Hanging mass object\"\n  extends Rigid;\n  parameter Real m = 1\t\t\t\t\t\t\t\t\"Mass of the hanging mass\";\n  constant Real  g = 9.81\t\t\t\t\t\t\t\"Gravitational acceleration\";\n  Real \t\t\t v\t\t\t\t\t\t\t\t\t\"Absolute velocity of component\";\n  Real \t\t\t a\t\t\t\t\t\t\t\t\t\"Absolute acceleration of component\";\nequation\n  v = der(s);\n  a = der(v);  \n  flange_b.f = m*a - m*g;\nend Mass;  ", "ModelicaInput"], Cell["", "Text"], Cell["partial model Rigid \t\t\t\t\t\t\t\t\"Rigid connection of two translational 1D flanges\"\n  Real s\t\t\t\t\t\t\t\t\t\t\t\n\t\t\t\t\t\t\t\t\t\t\t\t  \t\"Absolute position s of center of component\n  \t\t\t\t\t\t\t\t\t\t\t\t\t(s = flange_a.s + L/2 = flange_b.s - L/2)\";\n  parameter Real L = 0\t\t\t\t\t\t\t\t\"Length L of component from left to right flange\n  \t\t\t\t\t\t\t\t\t\t\t\t\t(L = flange_b.s - flange_a.s)\";\n  Modelica.Mechanics.Translational.Interfaces.Flange_a flange_a;\n  Modelica.Mechanics.Translational.Interfaces.Flange_b flange_b;\nequation\n  flange_a.s = s - L/2;\n  flange_b.s = s + L/2;    \t\t\t\t\t\t\t\nend Rigid;\t\t\t\t\t\t\t\t\t\t\t// From Modelica.Mechanics.Translational.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["model Fixed\t\t\t\t\t\t\t\t\t\t\t\"Fixed flange at a housing\"\n  parameter Real s0 = 0\t\t\t\t\t\t\t\t\"Fixed offset position of housing\"; \n  Modelica.Mechanics.Translational.Interfaces.Flange_b flange_b;\nequation\n  flange_b.s = s0;\nend Fixed;\t\t\t\t\t \t\t\t\t\t\t// From Modelica.Mechanics.Translational", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Oscillator", "Section"], Cell[TextData[List["The following model gives rise to some dynamic movement when simulated. A mass is connected to a spring which is connected to a fixed housing. ", "The mass ", StyleBox["mass1", Rule[FontFamily, "Courier"]], " is subject to the gravitational force ", StyleBox["-mg", Rule[FontFamily, "Courier"]], " and the force from the spring. It is given an initial position ", StyleBox["s", Rule[FontFamily, "Courier"]], "=", StyleBox["-0.5", Rule[FontFamily, "Courier"]], " which is offset from the equilibrium position and therefore starts an oscillating movement up-and-down.", "\n"]], "Text"], Cell["model Oscillator\n  Mass \t\tmass1(L = 1, s(start = -0.5));\n  Spring \tspring1(s_rel0 = 2, c = 10000);\n  Fixed \tfixed1(s0 = 1.0);\nequation\n  connect(spring1.flange_b, fixed1.flange_b);\n  connect(mass1.flange_b, spring1.flange_a);\nend Oscillator;   ", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of Oscillator", "Section"], Cell["simulate( Oscillator );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(Oscillator\\) : 2004-1-30 13:4:59.3570302 : \\!\\({0.`, 1.`}\\) : 502 data points : 1 events : 23 variables>\\n\\!\\({\\*TagBox[\\(fixed1 . flange\[UnderBracket]b . f\\), HoldForm], \\*TagBox[\\(fixed1 . flange\[UnderBracket]b . s\\), HoldForm], \\*TagBox[\\(fixed1 . s0\\), HoldForm], \\*TagBox[\\(mass1 . a\\), HoldForm], \\*TagBox[\\(mass1 . flange\[UnderBracket]a . f\\), HoldForm], \\*TagBox[\\(mass1 . flange\[UnderBracket]a . s\\), HoldForm], \\*TagBox[\\(mass1 . flange\[UnderBracket]b . f\\), HoldForm], \\*TagBox[\\(mass1 . flange\[UnderBracket]b . s\\), HoldForm], \\*TagBox[\\(mass1 . g\\), HoldForm], \\*TagBox[\\(mass1 . L\\), HoldForm], \\*TagBox[\\(mass1 . m\\), HoldForm], \\*TagBox[\\(mass1 . s\\), HoldForm], \\*TagBox[\\(mass1 . v\\), HoldForm], \\*TagBox[\\(spring1 . c\\), HoldForm], \\*TagBox[\\(spring1 . f\\), HoldForm], \\*TagBox[\\(spring1 . flange\[UnderBracket]a . f\\), HoldForm], \\*TagBox[\\(spring1 . flange\[UnderBracket]a . s\\), HoldForm], \\*TagBox[\\(spring1 . flange\[UnderBracket]b . f\\), HoldForm], \\*TagBox[\\(spring1 . flange\[UnderBracket]b . s\\), HoldForm], \\*TagBox[\\(spring1 . s\[UnderBracket]rel\\), HoldForm], \\*TagBox[\\(spring1 . s\[UnderBracket]rel0\\), HoldForm], \\*TagBox[SuperscriptBox[\\((mass1 . s)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm], \\*TagBox[SuperscriptBox[\\((mass1 . v)\\), \\\"\[Prime]\\\", Rule[MultilineFunction, None]], HoldForm]}\\)\""], "Output"], Cell["plot( mass1.s, xrange={0,0.5} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 1.90476 0.750664 0.29469 [\n[.21429 .14878 -9 -9 ]\n[.21429 .14878 9 0 ]\n[.40476 .14878 -9 -9 ]\n[.40476 .14878 9 0 ]\n[.59524 .14878 -9 -9 ]\n[.59524 .14878 9 0 ]\n[.78571 .14878 -9 -9 ]\n[.78571 .14878 9 0 ]\n[.97619 .14878 -9 -9 ]\n[.97619 .14878 9 0 ]\n[1.025 .16128 0 -6.28125 ]\n[1.025 .16128 10 6.28125 ]\n[.01131 .01394 -24 -4.5 ]\n[.01131 .01394 0 4.5 ]\n[.01131 .30863 -24 -4.5 ]\n[.01131 .30863 0 4.5 ]\n[.01131 .45597 -12 -4.5 ]\n[.01131 .45597 0 4.5 ]\n[.01131 .60332 -24 -4.5 ]\n[.01131 .60332 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .16128 m\n.21429 .16753 L\ns\n[(0.1)] .21429 .14878 0 1 Mshowa\n.40476 .16128 m\n.40476 .16753 L\ns\n[(0.2)] .40476 .14878 0 1 Mshowa\n.59524 .16128 m\n.59524 .16753 L\ns\n[(0.3)] .59524 .14878 0 1 Mshowa\n.78571 .16128 m\n.78571 .16753 L\ns\n[(0.4)] .78571 .14878 0 1 Mshowa\n.97619 .16128 m\n.97619 .16753 L\ns\n[(0.5)] .97619 .14878 0 1 Mshowa\n.125 Mabswid\n.0619 .16128 m\n.0619 .16503 L\ns\n.1 .16128 m\n.1 .16503 L\ns\n.1381 .16128 m\n.1381 .16503 L\ns\n.17619 .16128 m\n.17619 .16503 L\ns\n.25238 .16128 m\n.25238 .16503 L\ns\n.29048 .16128 m\n.29048 .16503 L\ns\n.32857 .16128 m\n.32857 .16503 L\ns\n.36667 .16128 m\n.36667 .16503 L\ns\n.44286 .16128 m\n.44286 .16503 L\ns\n.48095 .16128 m\n.48095 .16503 L\ns\n.51905 .16128 m\n.51905 .16503 L\ns\n.55714 .16128 m\n.55714 .16503 L\ns\n.63333 .16128 m\n.63333 .16503 L\ns\n.67143 .16128 m\n.67143 .16503 L\ns\n.70952 .16128 m\n.70952 .16503 L\ns\n.74762 .16128 m\n.74762 .16503 L\ns\n.82381 .16128 m\n.82381 .16503 L\ns\n.8619 .16128 m\n.8619 .16503 L\ns\n.9 .16128 m\n.9 .16503 L\ns\n.9381 .16128 m\n.9381 .16503 L\ns\n.25 Mabswid\n0 .16128 m\n1 .16128 L\ns\ngsave\n1.025 .16128 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01394 m\n.03006 .01394 L\ns\n[(-2.5)] .01131 .01394 1 0 Mshowa\n.02381 .30863 m\n.03006 .30863 L\ns\n[(-1.5)] .01131 .30863 1 0 Mshowa\n.02381 .45597 m\n.03006 .45597 L\ns\n[(-1)] .01131 .45597 1 0 Mshowa\n.02381 .60332 m\n.03006 .60332 L\ns\n[(-0.5)] .01131 .60332 1 0 Mshowa\n.125 Mabswid\n.02381 .04341 m\n.02756 .04341 L\ns\n.02381 .07288 m\n.02756 .07288 L\ns\n.02381 .10235 m\n.02756 .10235 L\ns\n.02381 .13182 m\n.02756 .13182 L\ns\n.02381 .19075 m\n.02756 .19075 L\ns\n.02381 .22022 m\n.02756 .22022 L\ns\n.02381 .24969 m\n.02756 .24969 L\ns\n.02381 .27916 m\n.02756 .27916 L\ns\n.02381 .3381 m\n.02756 .3381 L\ns\n.02381 .36757 m\n.02756 .36757 L\ns\n.02381 .39704 m\n.02756 .39704 L\ns\n.02381 .42651 m\n.02756 .42651 L\ns\n.02381 .48544 m\n.02756 .48544 L\ns\n.02381 .51491 m\n.02756 .51491 L\ns\n.02381 .54438 m\n.02756 .54438 L\ns\n.02381 .57385 m\n.02756 .57385 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .60332 m\n.02762 .59745 L\n.03143 .58009 L\n.03524 .55192 L\n.03905 .51405 L\n.04286 .468 L\n.04667 .4156 L\n.05048 .35895 L\n.05429 .3003 L\n.0581 .24199 L\n.0619 .18635 L\n.06571 .13561 L\n.06952 .09177 L\n.07333 .05659 L\n.07714 .03147 L\n.08095 .01742 L\n.08476 .01498 L\n.08857 .02426 L\n.09238 .04489 L\n.09619 .07605 L\n.1 .1165 L\n.10381 .16463 L\n.10762 .2185 L\n.11143 .27598 L\n.11524 .33476 L\n.11905 .3925 L\n.12286 .44691 L\n.12667 .49582 L\n.13048 .53727 L\n.13429 .56962 L\n.1381 .59157 L\n.1419 .60225 L\n.14571 .60124 L\n.14952 .58857 L\n.15333 .56476 L\n.15714 .53074 L\n.16095 .48788 L\n.16476 .43789 L\n.16857 .38275 L\n.17238 .32467 L\n.17619 .26596 L\n.18 .20897 L\n.18381 .15597 L\n.18762 .10907 L\n.19143 .07013 L\n.19524 .04072 L\n.19905 .022 L\n.20286 .01472 L\n.20667 .01916 L\n.21048 .03516 L\nMistroke\n.21429 .06207 L\n.2181 .09882 L\n.2219 .14395 L\n.22571 .19566 L\n.22952 .25188 L\n.23333 .31037 L\n.23714 .36881 L\n.24095 .42485 L\n.24476 .47628 L\n.24857 .52103 L\n.25238 .55733 L\n.25619 .58372 L\n.26 .59915 L\n.26381 .60302 L\n.26762 .59516 L\n.27143 .57588 L\n.27524 .54597 L\n.27905 .5066 L\n.28286 .45935 L\n.28667 .40611 L\n.29048 .34899 L\n.29429 .29028 L\n.2981 .2323 L\n.3019 .17739 L\n.30571 .12771 L\n.30952 .08526 L\n.31333 .05173 L\n.31714 .02846 L\n.32095 .01636 L\n.32476 .01593 L\n.32857 .02718 L\n.33238 .04966 L\n.33619 .08247 L\n.34 .12432 L\n.34381 .17352 L\n.34762 .22812 L\n.35143 .28595 L\n.35524 .34468 L\n.35905 .402 L\n.36286 .4556 L\n.36667 .50335 L\n.37048 .54335 L\n.37429 .574 L\n.3781 .59409 L\n.3819 .6028 L\n.38571 .5998 L\n.38952 .5852 L\n.39333 .55959 L\n.39714 .52398 L\n.40095 .4798 L\nMistroke\n.40476 .42881 L\n.40857 .37304 L\n.41238 .31471 L\n.41619 .25615 L\n.42 .1997 L\n.42381 .1476 L\n.42762 .10193 L\n.43143 .06452 L\n.43524 .03685 L\n.43905 .02002 L\n.44286 .01472 L\n.44667 .02114 L\n.45048 .03904 L\n.45429 .06769 L\n.4581 .10596 L\n.4619 .15233 L\n.46571 .20493 L\n.46952 .26169 L\n.47333 .32032 L\n.47714 .3785 L\n.48095 .4339 L\n.48476 .48433 L\n.48857 .52775 L\n.49238 .56246 L\n.49619 .58705 L\n.5 .60056 L\n.50381 .60244 L\n.50762 .59261 L\n.51143 .57148 L\n.51524 .53988 L\n.51905 .49907 L\n.52286 .45068 L\n.52667 .39664 L\n.53048 .3391 L\n.53429 .28036 L\n.5381 .22276 L\n.5419 .16859 L\n.54571 .12002 L\n.54952 .07898 L\n.55333 .04711 L\n.55714 .02568 L\n.56095 .01553 L\n.56476 .01709 L\n.56857 .03028 L\n.57238 .05458 L\n.57619 .08901 L\n.58 .13222 L\n.58381 .18247 L\n.58762 .23776 L\n.59143 .29588 L\nMistroke\n.59524 .35453 L\n.59905 .41136 L\n.60286 .4641 L\n.60667 .51065 L\n.61048 .54917 L\n.61429 .5781 L\n.6181 .5963 L\n.6219 .60304 L\n.62571 .59806 L\n.62952 .58155 L\n.63333 .55417 L\n.63714 .51702 L\n.64095 .47156 L\n.64476 .41963 L\n.64857 .36328 L\n.65238 .30476 L\n.65619 .24641 L\n.66 .19055 L\n.66381 .13941 L\n.66762 .09503 L\n.67143 .05918 L\n.67524 .03328 L\n.67905 .01838 L\n.68286 .01505 L\n.68667 .02345 L\n.69048 .04322 L\n.69429 .07359 L\n.6981 .11333 L\n.7019 .16088 L\n.70571 .21433 L\n.70952 .27154 L\n.71333 .33025 L\n.71714 .38811 L\n.72095 .44281 L\n.72476 .49217 L\n.72857 .53422 L\n.73238 .56729 L\n.73619 .59006 L\n.74 .60163 L\n.74381 .60152 L\n.74762 .58974 L\n.75143 .56677 L\n.75524 .53353 L\n.75905 .49132 L\n.76286 .44185 L\n.76667 .38707 L\n.77048 .32918 L\n.77429 .27049 L\n.7781 .21332 L\n.7819 .15997 L\nMistroke\n.78571 .11255 L\n.78952 .07297 L\n.79333 .04279 L\n.79714 .02322 L\n.80095 .01505 L\n.80476 .01858 L\n.80857 .0337 L\n.81238 .05978 L\n.81619 .0958 L\n.82 .14032 L\n.82381 .19155 L\n.82762 .24747 L\n.83143 .30583 L\n.83524 .36432 L\n.83905 .4206 L\n.84286 .47242 L\n.84667 .51773 L\n.85048 .55471 L\n.85429 .58189 L\n.8581 .59819 L\n.8619 .60295 L\n.86571 .596 L\n.86952 .57759 L\n.87333 .54848 L\n.87714 .50982 L\n.88095 .46315 L\n.88476 .41033 L\n.88857 .35346 L\n.89238 .29482 L\n.89619 .23674 L\n.9 .18154 L\n.90381 .13142 L\n.90762 .08838 L\n.91143 .05412 L\n.91524 .03003 L\n.91905 .01705 L\n.92286 .01571 L\n.92667 .02606 L\n.93048 .04769 L\n.93429 .07973 L\n.9381 .1209 L\n.9419 .16958 L\n.94571 .22381 L\n.94952 .28143 L\n.95333 .34014 L\n.95714 .39762 L\n.96095 .45155 L\n.96476 .4998 L\n.96857 .54044 L\n.97238 .57185 L\nMistroke\n.97619 .59278 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(mass1) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(s) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@003P3IfMT4000000<0fMWI\n0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@3l0=WIf@003P3IfMT00`000000fMWI0=WI\nf@090=WIf@040000003IfMT0fMWI000000<0fMWI00<000000=WIf@3IfMT0o03IfMT000l0fMWI00<0\n00000=WIf@3IfMT02`3IfMT010000000fMWI0=WIf@3IfMT3000002P0fMWI00<0003o0=WIf@3IfMT0\n=@3IfMT00`000?l0fMWI0=WIf@2I0=WIf@00203IfMT4000000@0fMWI00<000000=WIf@3IfMT0203I\nfMT2000000@0fMWI00<000000=WIf@3IfMT02`3IfMT20000oaX0fMWI00<0003o0=WIf@000?l06@3I\nfMT20000oaX0fMWI0P000?lK0=WIf@80003o6P3IfMT20000oa/0fMWI0P000?lI0=WIf@80003o:P3I\nfMT000h0fMWI00@000000=WIf@3IfMT000002@3IfMT00`000000fMWI0=WIf@030=WIf@030000003I\nfMT0fMWI00/0fMWI0P000?lJ0=WIf@030000o`3IfMT0003o01T0fMWI0P000?lJ0=WIf@030000o`3I\nfMT0003o01T0fMWI00<0003o0=WIf@000?l06P3IfMT00`000?l0fMWI0000o`0I0=WIf@030000o`3I\nfMT0003o01T0fMWI0P000?lZ0=WIf@003`3IfMT2000000X0fMWI0`0000030=WIf@030000003IfMT0\nfMWI00X0fMWI00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI0000o`0I0=WIf@030000o`3I\nfMT0003o01T0fMWI00<0003o0=WIf@000?l06@3IfMT010000?l0fMWI0=WIf@000?lH0=WIf@040000\no`3IfMT0fMWI0000oaT0fMWI00<0003o0=WIf@000?l06@3IfMT00`000?l0fMWI0000o`0Y0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0:0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI00<0003o0=WIf@00\n0?l06@3IfMT00`000?l0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI00@0003o0=WI\nf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lI0=WIf@030000o`3IfMT0003o01T0fMWI00<0\n003o0=WIf@000?l0:@3IfMT00240fMWI00<000000=WIf@3IfMT02P3IfMT010000?l0fMWI0=WIf@00\n0?lH0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI00<0003o0=WIf@000?l0603IfMT01@000?l0fMWI\n0=WIf@3IfMT0003o01P0fMWI00@0003o0=WIf@3IfMT0003o603IfMT01@000?l0fMWI0=WIf@3IfMT0\n003o01L0fMWI00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI0000o`0Y0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@0:0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT010000?l0fMWI0=WI\nf@000?lI0=WIf@030000o`3IfMT0003o01P0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@05\n0000o`3IfMT0fMWI0=WIf@000?l0603IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00@0003o\n0=WIf@3IfMT0003o6@3IfMT010000?l0fMWI0=WIf@000?lX0=WIf@008@3IfMT2000000X0fMWI00<0\n003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI\n00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT01@00\n0?l0fMWI0=WIf@3IfMT0003o01P0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@040000o`3I\nfMT0fMWI0000oaP0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0X0=WIf@008@3IfMT00`000000fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT010000?l0fMWI\n0=WIf@000?lH0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0\n003o01L0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT010000?l0fMWI0=WIf@000?lH0=WIf@050000o`3I\nfMT0fMWI0=WIf@000?l0:03IfMT00240fMWI00<000000=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WI\nf@020=WIf@030000o`3IfMT0fMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@050000\no`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00<0003o0=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WI\nf@3IfMT05@3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI0000\no`0X0=WIf@008@3IfMT00`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o\n0=WIf@3IfMT05@3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI\n0000o`0G0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0E0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o\n02P0fMWI000Q0=WIf@030000003IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT01@000?l0\nfMWI0=WIf@3IfMT0003o01L0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WI\nf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WI\nf@050000o`3IfMT0fMWI0=WIf@000?l0:03IfMT00240fMWI00<000000=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00\n0?l0fMWI0=WIf@0E0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT00`000?l0fMWI0=WIf@02\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@02\n0=WIf@030000o`3IfMT0fMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0X0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT0\n0`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI02D0fMWI000Q0=WIf@8000002P3IfMT00`00\n0?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`00\n0?l0fMWI0=WIf@0U0=WIf@008@3IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0\nfMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180\nfMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080\nfMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI02D0\nfMWI000Q0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT09@3IfMT00240fMWI00<0\n00000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0U0=WIf@008@3IfMT00`000000fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@03\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D\n0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@03\n0=WIf@030000o`3IfMT0fMWI02D0fMWI000Q0=WIf@030000003IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WI\nf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WI\nf@3IfMT09@3IfMT00240fMWI00<000000=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0U0=WIf@00\n8@3IfMT2000000T0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000\no`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000\no`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000\no`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0903IfMT00240fMWI00<000000=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3I\nfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@0T0=WIf@008@3IfMT00`000000fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0\nfMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0\nfMWI02@0fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@03000000000?l0fMWI00<0fMWI0P0000000`000?l0fMWI0=WIf@050000\n00d0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@050=WIf@800000103IfMT20000\n00<0fMWI0P0000000`000?l000000=WIf@040=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT00P3IfMT200000080fMWI00@0003o0=WIf@0000000000103IfMT2000000X0fMWI00<0003o\n0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0;0=WIf@800000103IfMT00`000000003o0=WIf@04\n0=WIf@03000000000?l0000001<0fMWI00<0003o0=WIf@3IfMT01@3IfMT010000?l0fMWI00000000\n00040=WIf@800000103IfMT2000001L0fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@040000003IfMT0003o000000D0fMWI00<0\n003o0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT0103IfMT010000000fMWI0=WIf@0000080=WIf@030000003IfMT0003o00H0fMWI\n00<0003o0=WIf@3IfMT04@3IfMT01@000?l0fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@00\n0?l01P3IfMT010000000fMWI0=WIf@0000080=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT010000000fMWI0=WIf@0000040=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@050000o`000000fMWI0=WIf@000000203I\nfMT010000000fMWI0=WIf@00000F0=WIf@008@3IfMT00`000000fMWI0=WIf@070=WIf@030000o`3I\nfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0403IfMT010000000fMWI0000o`0000060=WIf@050000\no`3IfMT0fMWI0=WIf@0000003`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00@0\nfMWI00@000000=WIf@3IfMT000002@3IfMT00`000000003o0=WIf@050=WIf@030000o`3IfMT0fMWI\n0140fMWI00D0003o0=WIf@3IfMT0fMWI000000020=WIf@030000003IfMT0003o00P0fMWI00<00000\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00@00000\n0=WIf@3IfMT00000103IfMT010000?l0fMWI0=WIf@3IfMT4000000030000o`3IfMT0fMWI0140fMWI\n00<0003o0=WIf@3IfMT01@3IfMT01@000?l000000=WIf@3IfMT0000000/0fMWI00<000000=WIf@3I\nfMT0503IfMT00240fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000\no`3IfMT0fMWI0100fMWI00@000000=WIf@000?l000001P3IfMT01@000?l0fMWI0=WIf@3IfMT00000\n00l0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@040=WIf@040000003IfMT0fMWI\n000000T0fMWI00<0003o0000003IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@050000o`3IfMT0\nfMWI0=WIf@0000000P3IfMT00`000000fMWI0000o`090=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@040000003IfMT0fMWI000000@0fMWI\n00D0003o0=WIf@3IfMT0fMWI000000020=WIf@03000000000?l0fMWI0180fMWI00<0003o0=WIf@3I\nfMT01@3IfMT01@000?l000000=WIf@3IfMT0000000T0fMWI0P00000G0=WIf@008@3IfMT2000000P0\nfMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@040000003IfMT0003o0000\n00H0fMWI00D0003o0=WIf@3IfMT0fMWI0000000?0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0103IfMT010000000fMWI0=WIf@0000080=WIf@04000000000?l0fMWI000000H0fMWI\n00<0003o0=WIf@3IfMT0403IfMT01@000?l0fMWI0=WIf@3IfMT000000080fMWI00<000000=WIf@00\n0?l01P3IfMT010000000fMWI0=WIf@0000080=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT010000000fMWI0=WIf@0000040=WIf@030000o`3IfMT0fMWI0080fMWI00@00000\n0=WIf@000000003o4`3IfMT00`000?l0fMWI0=WIf@050=WIf@050000o`000000fMWI0=WIf@000000\n2@3IfMT00`000000fMWI0=WIf@0F0=WIf@008@3IfMT00`000000fMWI0=WIf@070=WIf@030000o`3I\nfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l000000=WIf@060=WIf@030000o`3I\nfMT0fMWI008000003`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00D0fMWI0P00\n000:0=WIf@030000o`000000fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@020=WIf@8000000P3IfMT00`000?l0fMWI0=WIf@050=WIf@8000002@3IfMT00`000?l0fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI00/0fMWI0P0000040=WIf@030000o`3IfMT0fMWI00@0fMWI0P00\n00000`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00@0003o0=WIf@0000000000\n2P3IfMT3000001H0fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT01@3I\nfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3I\nfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403I\nfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0903I\nfMT00240fMWI00<000000=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0\nfMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0T0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WIf@030000003IfMT0fMWI00L0\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0503IfMT2000000d0fMWI000Q0=WIf@030000003IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI\n00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI\n00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI\n00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI\n00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT010000000fMWI0=WIf@00000<0=WIf@00703IfMT>000000030000\no`000000000000L0000000<0003o000000000000400000000`000?l0000000000006000000030000\no`00000000000100000000<0003o0000000000001`0000000`000?l000000000000@000000030000\no`000000000000H0000000<0003o000000000000400000000`000?l0000000000006000000030000\no`00000000000100000000<0003o0000000000001P0000000`000?l000000000000@000000030000\no`000000000000H0000000<0003o000000000000400000000`000?l0000000000007000000030000\no`000000000000`000001`3IfMT00`000000fMWI0=WIf@0=0=WIf@008@3IfMT00`000000fMWI0=WI\nf@060=WIf@030000o`3IfMT0fMWI00H0fMWI00<000000000o`3IfMT01P3IfMT00`000000fMWI0=WI\nf@060=WIf@030000003IfMT0003o00H0fMWI00<000000=WIf@000?l01P3IfMT00`000000fMWI0=WI\nf@060=WIf@040000003IfMT0fMWI0000o`D0fMWI00D000000=WIf@3IfMT0fMWI0000o`040=WIf@03\n0000003IfMT0fMWI00H0fMWI00<000000=WIf@3IfMT00P3IfMT01@000?l0fMWI0=WIf@3IfMT00000\n00@0fMWI00D0003o0=WIf@3IfMT0fMWI000000080=WIf@030000003IfMT0fMWI00<0fMWI00@0003o\n0=WIf@3IfMT000001@3IfMT010000?l0fMWI0=WIf@0000080=WIf@030000003IfMT0fMWI00<0fMWI\n00@0003o0=WIf@3IfMT000001P3IfMT00`000?l0fMWI000000080=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0000003IfMT01P3IfMT00`000?l000000=WIf@070=WIf@030000003IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000000003o0=WIf@060=WIf@030000003IfMT0fMWI00X0\nfMWI1@00000<0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI\n00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI\n00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI\n00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI\n00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<000000=WIf@3IfMT03@3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WI\nf@0S0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02<0fMWI000Q0=WI\nf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WI\nf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WI\nf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT08`3IfMT00240fMWI00<000000=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0S0=WIf@008@3IfMT2000000L0fMWI00<0003o0=WIf@3IfMT0\n1`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\n3`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0\n8`3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3I\nfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3I\nfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3I\nfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3I\nfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3I\nfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0S0=WIf@008@3IfMT0\n0`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT0\n0`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT0\n0`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT0\n0`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT0\n0`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT0\n0`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI\n00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI\n00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI\n00P0fMWI00<0003o0=WIf@3IfMT08P3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0\nfMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0\nfMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0\nfMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0\nfMWI0=WIf@0R0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00P0fMWI\n00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI\n00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI\n00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI\n00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI\n00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0280fMWI\n000Q0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WI\nf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WI\nf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT08P3IfMT00240fMWI0P000007\n0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003IfMT0fMWI00H0fMWI00<0003o0=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT08P3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@03\n0000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0R0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n3P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0\n203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI0280fMWI000Q0=WIf@030000003I\nfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3I\nfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT08P3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT0\n0`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT0\n0`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0203IfMT0\n0`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03@3IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT0\n0`000?l0fMWI0=WIf@0R0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n00P0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI\n0280fMWI000Q0=WIf@8000001`3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0R0=WIf@008@3IfMT00`000000fMWI\n0=WIf@060=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI0240fMWI000Q0=WIf@030000003IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT08@3IfMT00240fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0Q\n0=WIf@008@3IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WI\nf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI0240fMWI000Q0=WIf@03\n0000003IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@03\n0000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT08@3IfMT00240fMWI00<000000=WIf@3IfMT0\n1@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@008@3IfMT2000000H0fMWI00<0003o0=WIf@3IfMT02P3I\nfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3I\nfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303I\nfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT08@3I\nfMT00240fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0\nfMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0\nfMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0\nfMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0\nfMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0\nfMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0Q0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`00\n0?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`00\n0?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`00\n0?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00\n0?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`00\n0?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI0240fMWI000Q0=WIf@030000003IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0\nfMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0\nfMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0\nfMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0\nfMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0\nfMWI00<0003o0=WIf@3IfMT08@3IfMT00240fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI\n0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI\n0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI\n0=WIf@0Q0=WIf@003P3IfMT500000080fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WI\nf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0;0=WIf@030000o`3IfMT0fMWI0240fMWI000@0=WIf@030000003IfMT0fMWI00L0fMWI00@00000\n0=WIf@3IfMT000000`3IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0\n003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0\n003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI0240fMWI000@\n0=WIf@030000003IfMT0fMWI00X0fMWI00@000000=WIf@3IfMT0fMWI0`0000050=WIf@030000o`3I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI0240fMWI00080=WIf@@00000103IfMT00`000000fMWI0=WIf@080=WIf@800000103IfMT0\n0`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI0200fMWI000@0=WIf@030000003IfMT0fMWI\n00P0fMWI00<000000=WIf@3IfMT00`3IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n0200fMWI000?0=WIf@8000002P3IfMT3000000<0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l0\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0\nfMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI\n00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00/0fMWI\n00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI\n00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0200fMWI\n000Q0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WI\nf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WI\nf@0;0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WI\nf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<00000\n0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o\n0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o\n0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o\n0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o\n0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o\n0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT2000000D0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0P0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI0200fMWI000Q0=WIf@030000003I\nfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3I\nfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT0103IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT0\n0`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT0\n0`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT0\n0`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT0\n0`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI\n00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI\n00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI\n00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI\n0200fMWI000Q0=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI\n0P0000050=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI0200fMWI000Q0=WIf@030000003IfMT0fMWI00@0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0P\n0=WIf@008@3IfMT00`000000fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI0200fMWI000Q0=WIf@03\n0000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@080=WIf@03\n0000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT0\n0`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3@3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n3P3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3I\nfMT0fMWI0200fMWI000Q0=WIf@800000103IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI0200fMWI000Q0=WIf@030000003IfMT0fMWI00<0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI\n0=WIf@070=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@0P0=WIf@008@3IfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00h0fMWI00<0\n003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0\n003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0\n003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0\n003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0\n003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI0200fMWI000Q\n0=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@07\n0=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?\n0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@07\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0803IfMT00240fMWI00<000000=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WI\nf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WI\nf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WI\nf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@0P0=WIf@008@3IfMT2000000@0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT07`3IfMT00240fMWI00<000000=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000\no`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@0O0=WIf@008@3I\nfMT00`000000fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01P3I\nfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0fMWI000Q0=WIf@030000003IfMT0\nfMWI0080fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0100fMWI00<0003o0=WIf@3IfMT07`3IfMT001X0fMWI1@0000020=WIf@030000003IfMT0fMWI\n0080fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI\n00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI\n00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT07`3IfMT001`0fMWI00<000000=WIf@3IfMT00P3IfMT00`000000\nfMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0\nfMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0\nfMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0\nfMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0\nfMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0fMWI000L0=WIf@030000003IfMT0fMWI0080fMWI\n0`0000020=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI\n0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI\n0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0fMWI000D0=WIf@@00000103IfMT00`000000fMWI0=WI\nf@020=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WI\nf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT07`3IfMT001`0fMWI00<00000\n0=WIf@3IfMT00P3IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o\n0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o\n0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0fMWI000K0=WI\nf@800000103IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WI\nf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WI\nf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WI\nf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI01l0fMWI000Q0=WIf@03\n0000003IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@03\n0000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0?0=WIf@03\n0000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@03\n0000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@03\n0000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@03\n0000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT07`3IfMT00240fMWI00<000000=WIf@3IfMT0\n0P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0\n4@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0\n1P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0\n4@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0\n1@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@0O0=WIf@008@3IfMT00`000000fMWI0=WIf@020=WIf@030000o`3I\nfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3I\nfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3I\nfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3I\nfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3I\nfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3I\nfMT0fMWI01h0fMWI000Q0=WIf@8000000`3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0\nfMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0\nfMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI01h0fMWI000Q0=WIf@050000003IfMT0fMWI0=WI\nf@000?l0503IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT07P3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`0D0=WIf@030000o`3IfMT0fMWI\n00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00D0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI\n0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT01@000000\nfMWI0=WIf@3IfMT0003o01@0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WI\nf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@040=WI\nf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WI\nf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WI\nf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WI\nf@030000o`3IfMT0fMWI01h0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l0503IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT07P3IfMT00240\nfMWI00D000000=WIf@3IfMT0fMWI0000o`0D0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WI\nf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WI\nf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WI\nf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WI\nf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT200000080fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3I\nfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3I\nfMT07P3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`0D0=WIf@030000o`3IfMT0fMWI00@0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00@0\nfMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0\nfMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT01@000000fMWI\n0=WIf@3IfMT0003o01D0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@03\n0000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI01d0fMWI000Q0=WIf@050000003IfMT0fMWI0=WIf@000?l05@3IfMT00`000?l0\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0\nfMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI\n00D000000=WIf@3IfMT0fMWI0000o`0E0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@008@3IfMT010000000fMWI0=WIf@000?lF0=WIf@03\n0000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@03\n0000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@00\n8@3IfMT010000000fMWI0=WIf@000?lF0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@0M0=WIf@008@3IfMT2000000030=WIf@000?l0fMWI01D0fMWI\n00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01d0fMWI\n000Q0=WIf@040000003IfMT0fMWI0000oaH0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI\n0=WIf@0C0=WIf@030000o`3IfMT0fMWI01d0fMWI000Q0=WIf@040000003IfMT0fMWI0000oaH0fMWI\n00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI\n00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI\n00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI01d0fMWI\n000Q0=WIf@040000003IfMT0fMWI0000oaH0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@03\n0000o`3IfMT0fMWI01d0fMWI000Q0=WIf@040000003IfMT0fMWI0000oaH0fMWI00<0003o0=WIf@3I\nfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00D0003o0=WIf@3I\nfMT0fMWI0000o`0G0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`00\n0?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI01`0fMWI000Q0=WIf@040000003IfMT0fMWI0000\noaH0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n0080fMWI00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI\n01@0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05P3I\nfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3I\nfMT00`000?l0fMWI0=WIf@0E0=WIf@030000o`3IfMT0fMWI01`0fMWI000Q0=WIf@030000003IfMT0\n003o01L0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0\nfMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0\nfMWI01@0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaL0fMWI\n00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI\n00<0003o0=WIf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@0L0=WIf@008@3IfMT2000000030000o`3I\nfMT0fMWI01D0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@050000o`3I\nfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3I\nfMT0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaL0fMWI00<0003o0=WIf@3IfMT00P3IfMT0\n0`000?l0fMWI0=WIf@0E0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT00`000?l0fMWI0=WI\nf@0L0=WIf@008@3IfMT00`000000fMWI0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l0603I\nfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@04\n0000o`3IfMT0fMWI0000oaP0fMWI00@0003o0=WIf@3IfMT0003o5`3IfMT00`000?l0fMWI0=WIf@02\n0=WIf@030000o`3IfMT0fMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@030000o`3I\nfMT0fMWI01`0fMWI000Q0=WIf@030000003IfMT0003o01P0fMWI00@0003o0=WIf@3IfMT0003o603I\nfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@04\n0000o`3IfMT0fMWI0000oaP0fMWI00@0003o0=WIf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@00\n0?lH0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@008@3I\nfMT00`000000fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI00@0003o0=WIf@3IfMT0\n003o6@3IfMT010000?l0fMWI0=WIf@000?lH0=WIf@030000o`3IfMT0003o01T0fMWI00@0003o0=WI\nf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lH0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI\n00<0003o0=WIf@3IfMT06`3IfMT00240fMWI00<000000000o`3IfMT0603IfMT010000?l0fMWI0=WI\nf@000?lH0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI00@0003o0=WIf@3IfMT0003o603IfMT00`00\n0?l0fMWI0000o`0J0=WIf@80003o6@3IfMT010000?l0fMWI0=WIf@000?lH0=WIf@040000o`3IfMT0\nfMWI0000oaT0fMWI00<0003o0=WIf@3IfMT06`3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2\n000000@0fMWI00<000000000o`3IfMT0603IfMT010000?l0fMWI0=WIf@000?lI0=WIf@030000o`3I\nfMT0003o01T0fMWI00<0003o0=WIf@000?l06@3IfMT00`000?l0fMWI0000o`0J0=WIf@80003o6@3I\nfMT010000?l0fMWI0=WIf@000?lI0=WIf@030000o`3IfMT0003o01T0fMWI00<0003o0=WIf@3IfMT0\n6`3IfMT000h0fMWI00@000000=WIf@3IfMT00000203IfMT010000000fMWI0=WIf@0000030=WIf@03\n000000000?l0fMWI01T0fMWI0P000?lJ0=WIf@80003o6P3IfMT00`000?l0fMWI0000o`0J0=WIf@80\n003o6P3IfMT20000oaX0fMWI0P000?lJ0=WIf@80003o>03IfMT000h0fMWI00@000000=WIf@3IfMT0\n00002`3IfMT01@000000fMWI0=WIf@3IfMT0003o008000006@3IfMT20000oa/0fMWI00<0003o0=WI\nf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@0I0=WIf@80003o6P3IfMT00`000?l0fMWI0=WIf@0I0=WI\nf@80003o6`3IfMT00`000?l0fMWI0=WIf@0f0=WIf@00203IfMT400000080fMWI00@000000=WIf@3I\nfMT000002@3IfMT2000000@0fMWI00<000000=WIf@3IfMT0o03IfMT000h0fMWI00@000000=WIf@3I\nfMT000002@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0?`0fMWI000?0=WIf@80\n00002P3IfMT3000000<0fMWI00<000000=WIf@3IfMT0o03IfMT00240fMWI00<000000=WIf@3IfMT0\no03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI\n8@3IfMT002D0fMWI00<000000=WIf@3IfMT0:P3IfMT00`000000fMWI0=WIf@050=WIf@800000203I\nfMT200000;X0fMWI000T0=WIf@030000003IfMT0fMWI02`0fMWI00<000000=WIf@3IfMT0103IfMT0\n0`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI0;P0fMWI000S0=WIf@040000003IfMT0fMWI\n0=WIf@80000000D0fMWI0000003IfMT000000=WIf@05000000040=WIf@0000000000000000<0fMWI\n0`0000030=WIf@D000000P3IfMT2000000<0fMWI0`0000050=WIf@030000003IfMT0fMWI00<0fMWI\n00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00<0\n00000=WIf@3IfMT00P3IfMT01P000000fMWI0000003IfMT000000=WIf@@000001@3IfMT00`000000\nfMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI00<000000=WIf@3IfMT02P3IfMT00`000000\nfMWI0=WIf@020=WIf@030000003IfMT0fMWI00<0fMWI00D000000=WIf@3IfMT0fMWI000000020=WI\nf@050000003IfMT0fMWI0=WIf@000000^P3IfMT001H0fMWI20000?l50=WIf@030000003IfMT0fMWI\n0080fMWI00D000000=WIf@000000fMWI000000040=WIf@030000003IfMT0fMWI00<000000`3IfMT3\n000000D0fMWI00<000000=WIf@3IfMT01`3IfMT3000000D0fMWI00<000000=WIf@3IfMT00`3IfMT0\n1@000000fMWI0=WIf@3IfMT0000000H0fMWI00<000000=WIf@3IfMT0^03IfMT002<0fMWI00@00000\n0=WIf@3IfMT0fMWI0`0000000`3IfMT000000=WIf@020=WIf@<000000P3IfMT400000080fMWI1000\n00040=WIf@030000003IfMT0fMWI00L0fMWI100000040=WIf@030000003IfMT0fMWI00<0fMWI00<0\n00000=WIf@3IfMT01@0000030=WIf@030000003IfMT0fMWI0;P0fMWI000T0=WIf@030000003IfMT0\nfMWI01/0fMWI00<000000=WIf@3IfMT03P3IfMT00`000000fMWI0=WIf@040=WIf@050000003IfMT0\nfMWI0=WIf@0000001P3IfMT00`000000fMWI0=WIf@2h0=WIf@009@3IfMT00`000000fMWI0=WIf@0I\n0=WIf@8000003`3IfMT00`000000fMWI0=WIf@050=WIf@800000203IfMT200000;X0fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WIfB40fMWI003o0=WI\nfB40fMWI003o0=WIfB40fMWI0000"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0756122`, -2.78804`, 0.00222733`, 0.0143966`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[TextData[List[StyleBox["\t\t\tDiagram 1:", Rule[FontWeight, "Bold"]], " Plot of the absolute position mass1.s(t) of the center of the haning mass.\n\n"]], "Text"], Cell["plot( mass1.v, xrange={0,0.5} );", "ModelicaInput"], Cell[GraphicsData["PostScript", "%!\n%%Creator: Mathematica\n%%AspectRatio: .74402 \nMathPictureStart\n/Mabs {\nMgmatrix idtransform\nMtmatrix dtransform\n} bind def\n/Mabsadd { Mabs\n3 -1 roll add\n3 1 roll add\nexch } bind def\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.47619 0.312017 0.47619 [\n[ 0 0 0 0 ]\n[ 1 .74402 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n% Start of sub-graphic\np\n0.0238095 0.0177147 0.97619 0.606318 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.0238095 1.90476 0.309037 0.00294694 [\n[.21429 .29654 -9 -9 ]\n[.21429 .29654 9 0 ]\n[.40476 .29654 -9 -9 ]\n[.40476 .29654 9 0 ]\n[.59524 .29654 -9 -9 ]\n[.59524 .29654 9 0 ]\n[.78571 .29654 -9 -9 ]\n[.78571 .29654 9 0 ]\n[.97619 .29654 -9 -9 ]\n[.97619 .29654 9 0 ]\n[1.025 .30904 0 -6.28125 ]\n[1.025 .30904 10 6.28125 ]\n[.01131 .01434 -24 -4.5 ]\n[.01131 .01434 0 4.5 ]\n[.01131 .16169 -18 -4.5 ]\n[.01131 .16169 0 4.5 ]\n[.01131 .45638 -12 -4.5 ]\n[.01131 .45638 0 4.5 ]\n[.01131 .60373 -18 -4.5 ]\n[.01131 .60373 0 4.5 ]\n[ 0 0 0 0 ]\n[ 1 .61803 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 g\n.25 Mabswid\n[ ] 0 setdash\n.21429 .30904 m\n.21429 .31529 L\ns\n[(0.1)] .21429 .29654 0 1 Mshowa\n.40476 .30904 m\n.40476 .31529 L\ns\n[(0.2)] .40476 .29654 0 1 Mshowa\n.59524 .30904 m\n.59524 .31529 L\ns\n[(0.3)] .59524 .29654 0 1 Mshowa\n.78571 .30904 m\n.78571 .31529 L\ns\n[(0.4)] .78571 .29654 0 1 Mshowa\n.97619 .30904 m\n.97619 .31529 L\ns\n[(0.5)] .97619 .29654 0 1 Mshowa\n.125 Mabswid\n.0619 .30904 m\n.0619 .31279 L\ns\n.1 .30904 m\n.1 .31279 L\ns\n.1381 .30904 m\n.1381 .31279 L\ns\n.17619 .30904 m\n.17619 .31279 L\ns\n.25238 .30904 m\n.25238 .31279 L\ns\n.29048 .30904 m\n.29048 .31279 L\ns\n.32857 .30904 m\n.32857 .31279 L\ns\n.36667 .30904 m\n.36667 .31279 L\ns\n.44286 .30904 m\n.44286 .31279 L\ns\n.48095 .30904 m\n.48095 .31279 L\ns\n.51905 .30904 m\n.51905 .31279 L\ns\n.55714 .30904 m\n.55714 .31279 L\ns\n.63333 .30904 m\n.63333 .31279 L\ns\n.67143 .30904 m\n.67143 .31279 L\ns\n.70952 .30904 m\n.70952 .31279 L\ns\n.74762 .30904 m\n.74762 .31279 L\ns\n.82381 .30904 m\n.82381 .31279 L\ns\n.8619 .30904 m\n.8619 .31279 L\ns\n.9 .30904 m\n.9 .31279 L\ns\n.9381 .30904 m\n.9381 .31279 L\ns\n.25 Mabswid\n0 .30904 m\n1 .30904 L\ns\ngsave\n1.025 .30904 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n63.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n0.000 0.000 rmoveto\n1.000 setlinewidth\ngrestore\n.02381 .01434 m\n.03006 .01434 L\ns\n[(-100)] .01131 .01434 1 0 Mshowa\n.02381 .16169 m\n.03006 .16169 L\ns\n[(-50)] .01131 .16169 1 0 Mshowa\n.02381 .45638 m\n.03006 .45638 L\ns\n[(50)] .01131 .45638 1 0 Mshowa\n.02381 .60373 m\n.03006 .60373 L\ns\n[(100)] .01131 .60373 1 0 Mshowa\n.125 Mabswid\n.02381 .04381 m\n.02756 .04381 L\ns\n.02381 .07328 m\n.02756 .07328 L\ns\n.02381 .10275 m\n.02756 .10275 L\ns\n.02381 .13222 m\n.02756 .13222 L\ns\n.02381 .19116 m\n.02756 .19116 L\ns\n.02381 .22063 m\n.02756 .22063 L\ns\n.02381 .2501 m\n.02756 .2501 L\ns\n.02381 .27957 m\n.02756 .27957 L\ns\n.02381 .33851 m\n.02756 .33851 L\ns\n.02381 .36798 m\n.02756 .36798 L\ns\n.02381 .39745 m\n.02756 .39745 L\ns\n.02381 .42691 m\n.02756 .42691 L\ns\n.02381 .48585 m\n.02756 .48585 L\ns\n.02381 .51532 m\n.02756 .51532 L\ns\n.02381 .54479 m\n.02756 .54479 L\ns\n.02381 .57426 m\n.02756 .57426 L\ns\n.25 Mabswid\n.02381 0 m\n.02381 .61803 L\ns\n0 0 1 r\n.001 w\n.02381 .30904 m\n.02762 .25055 L\n.03143 .19439 L\n.03524 .14279 L\n.03905 .09783 L\n.04286 .06127 L\n.04667 .0346 L\n.05048 .01887 L\n.05429 .01472 L\n.0581 .02229 L\n.0619 .04131 L\n.06571 .071 L\n.06952 .11017 L\n.07333 .15728 L\n.07714 .21044 L\n.08095 .26752 L\n.08476 .32626 L\n.08857 .38432 L\n.09238 .43937 L\n.09619 .48923 L\n.1 .5319 L\n.10381 .56567 L\n.10762 .58922 L\n.11143 .60159 L\n.11524 .60229 L\n.11905 .5913 L\n.12286 .56907 L\n.12667 .53646 L\n.13048 .49479 L\n.13429 .44571 L\n.1381 .39118 L\n.1419 .33339 L\n.14571 .27463 L\n.14952 .21724 L\n.15333 .1635 L\n.15714 .11557 L\n.16095 .07536 L\n.16476 .04446 L\n.16857 .02411 L\n.17238 .01512 L\n.17619 .01785 L\n.18 .0322 L\n.18381 .05758 L\n.18762 .09299 L\n.19143 .13701 L\n.19524 .18788 L\n.19905 .24358 L\n.20286 .30189 L\n.20667 .36048 L\n.21048 .41703 L\nMistroke\n.21429 .46926 L\n.2181 .51511 L\n.2219 .55274 L\n.22571 .58066 L\n.22952 .59774 L\n.23333 .60332 L\n.23714 .59716 L\n.24095 .57952 L\n.24476 .55109 L\n.24857 .51302 L\n.25238 .46681 L\n.25619 .41431 L\n.26 .35762 L\n.26381 .29898 L\n.26762 .24075 L\n.27143 .18525 L\n.27524 .13468 L\n.27905 .09106 L\n.28286 .05613 L\n.28667 .03128 L\n.29048 .01751 L\n.29429 .01536 L\n.2981 .02492 L\n.3019 .04581 L\n.30571 .07719 L\n.30952 .11781 L\n.31333 .16606 L\n.31714 .22001 L\n.32095 .2775 L\n.32476 .33625 L\n.32857 .39392 L\n.33238 .4482 L\n.33619 .49694 L\n.34 .53818 L\n.34381 .57029 L\n.34762 .59198 L\n.35143 .60239 L\n.35524 .6011 L\n.35905 .58817 L\n.36286 .56412 L\n.36667 .52989 L\n.37048 .48686 L\n.37429 .43674 L\n.3781 .38153 L\n.3819 .32343 L\n.38571 .26475 L\n.38952 .20784 L\n.39333 .15497 L\n.39714 .10824 L\n.40095 .06952 L\nMistroke\n.40476 .04034 L\n.40857 .02188 L\n.41238 .01486 L\n.41619 .01958 L\n.42 .03583 L\n.42381 .06298 L\n.42762 .09994 L\n.43143 .14523 L\n.43524 .19705 L\n.43905 .25334 L\n.44286 .31184 L\n.44667 .37024 L\n.45048 .42619 L\n.45429 .47747 L\n.4581 .52204 L\n.4619 .55812 L\n.46571 .58426 L\n.46952 .59943 L\n.47333 .60303 L\n.47714 .5949 L\n.48095 .57538 L\n.48476 .54523 L\n.48857 .50568 L\n.49238 .45828 L\n.49619 .40493 L\n.5 .34776 L\n.50381 .28905 L\n.50762 .23113 L\n.51143 .17632 L\n.51524 .12681 L\n.51905 .08455 L\n.52286 .05125 L\n.52667 .02823 L\n.53048 .0164 L\n.53429 .01623 L\n.5381 .02775 L\n.5419 .05047 L\n.54571 .08351 L\n.54952 .12553 L\n.55333 .17487 L\n.55714 .22956 L\n.56095 .28742 L\n.56476 .34614 L\n.56857 .40338 L\n.57238 .45685 L\n.57619 .50444 L\n.58 .54423 L\n.58381 .57465 L\n.58762 .59448 L\n.59143 .60292 L\nMistroke\n.59524 .59965 L\n.59905 .5848 L\n.60286 .55895 L\n.60667 .52313 L\n.61048 .47878 L\n.61429 .42767 L\n.6181 .37182 L\n.6219 .31348 L\n.62571 .25495 L\n.62952 .19859 L\n.63333 .14662 L\n.63714 .10113 L\n.64095 .06394 L\n.64476 .03651 L\n.64857 .01995 L\n.65238 .01491 L\n.65619 .0216 L\n.66 .03975 L\n.66381 .06864 L\n.66762 .10711 L\n.67143 .15363 L\n.67524 .20634 L\n.67905 .26315 L\n.68286 .32179 L\n.68667 .37992 L\n.69048 .43522 L\n.69429 .48549 L\n.6981 .52873 L\n.7019 .56321 L\n.70571 .58755 L\n.70952 .60079 L\n.71333 .6024 L\n.71714 .59231 L\n.72095 .57093 L\n.72476 .53911 L\n.72857 .49811 L\n.73238 .44958 L\n.73619 .39545 L\n.74 .33787 L\n.74381 .27914 L\n.74762 .2216 L\n.75143 .16756 L\n.75524 .11915 L\n.75905 .07831 L\n.76286 .04667 L\n.76667 .02549 L\n.77048 .01562 L\n.77429 .01744 L\n.7781 .03089 L\n.7819 .05543 L\nMistroke\n.78571 .09008 L\n.78952 .13346 L\n.79333 .18384 L\n.79714 .2392 L\n.80095 .29736 L\n.80476 .35597 L\n.80857 .41272 L\n.81238 .46533 L\n.81619 .51171 L\n.82 .55001 L\n.82381 .57871 L\n.82762 .59665 L\n.83143 .60312 L\n.83524 .59787 L\n.83905 .58111 L\n.84286 .55349 L\n.84667 .51614 L\n.85048 .47052 L\n.85429 .41847 L\n.8581 .36206 L\n.8619 .30353 L\n.86571 .24522 L\n.86952 .18946 L\n.87333 .13846 L\n.87714 .09427 L\n.88095 .05864 L\n.88476 .03299 L\n.88857 .01834 L\n.89238 .01529 L\n.89619 .02394 L\n.9 .04396 L\n.90381 .07455 L\n.90762 .11449 L\n.91143 .16219 L\n.91524 .21574 L\n.91905 .273 L\n.92286 .33171 L\n.92667 .38951 L\n.93048 .4441 L\n.93429 .49331 L\n.9381 .53517 L\n.9419 .56802 L\n.94571 .59054 L\n.94952 .60184 L\n.95333 .60146 L\n.95714 .58943 L\n.96095 .56622 L\n.96476 .53275 L\n.96857 .49037 L\n.97238 .44075 L\nMistroke\n.97619 .38589 L\nMfstroke\n0 0 m\n1 0 L\n1 .61803 L\n0 .61803 L\nclosepath\nclip\nnewpath\nMathSubEnd\nP\n% End of sub-graphic\n% Start of sub-graphic\np\n0.0714286 0.583445 0.547619 0.726302 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.00611247 0.0611247 0.0220588 0.220588 [\n[ 0 0 0 0 ]\n[ 1 .3 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 .3 L\n0 .3 L\nclosepath\nclip\nnewpath\n% Start of sub-graphic\np\n0.0110024 0.0397059 0.0721271 0.260294 MathSubStart\n%% Graphics\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10  scalefont  setfont\n% Scaling calculations\n0.5 0.5 0.5 0.5 [\n[ 0 0 0 0 ]\n[ 1 1 0 0 ]\n] MathScale\n% Start of Graphics\n1 setlinecap\n1 setlinejoin\nnewpath\n0 0 m\n1 0 L\n1 1 L\n0 1 L\nclosepath\nclip\nnewpath\n0 0 1 r\n.00187 w\n[ ] 0 setdash\n0 .5 m\n1 .5 L\ns\nMathSubEnd\nP\n% End of sub-graphic\n0 g\ngsave\n.08007 .15 -61 -10.2813 Mabsadd m\n1 1 Mabs scale\ncurrentpoint translate\n0 20.5625 translate 1 -1 scale\n/g { setgray} bind def\n/k { setcmykcolor} bind def\n/p { gsave} bind def\n/r { setrgbcolor} bind def\n/w { setlinewidth} bind def\n/C { curveto} bind def\n/F { fill} bind def\n/L { lineto} bind def\n/rL { rlineto} bind def\n/P { grestore} bind def\n/s { stroke} bind def\n/S { show} bind def\n/N {currentpoint 3 -1 roll show moveto} bind def\n/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def\n/m { moveto} bind def\n/Mr { rmoveto} bind def\n/Mx {currentpoint exch pop moveto} bind def\n/My {currentpoint pop exch moveto} bind def\n/X {0 rmoveto} bind def\n/Y {0 exch rmoveto} bind def\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n63.000 12.813 moveto\n(H) show\n69.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(mass1) show\n99.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(.) show\n105.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(v) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n111.000 12.813 moveto\n(L) show\n117.000 12.813 moveto\n(@) show\n123.000 12.813 moveto\n%%IncludeResource: font Courier\n%%IncludeFont: Courier\n/Courier findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n(t) show\n%%IncludeResource: font Mathematica2Mono\n%%IncludeFont: Mathematica2Mono\n/Mathematica2Mono findfont 10.000 scalefont\n[1 0 0 -1 0 0 ] makefont setfont\n0.000 0.000 0.000 setrgbcolor\n129.000 12.813 moveto\n(D) show\n1.000 setlinewidth\ngrestore\nMathSubEnd\nP\n% End of sub-graphic\n0 0 m\n1 0 L\n1 .74402 L\n0 .74402 L\nclosepath\nclip\nnewpath\n% End of Graphics\nMathPictureEnd\n"], "Graphics", Rule[ImageSize, List[288, 214.25`]], Rule[ImageMargins, List[List[35, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]], Rule[ImageCache, GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000eR000`400?l00000o`00003oo`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ\n0=WIf@00o`3IfMTQ0=WIf@008@3IfMT00`000000fMWI0=WIf@3l0=WIf@003P3IfMT500000080fMWI\n0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@3l0=WIf@00403IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT00000\n0?h0fMWI000@0=WIf@050000003IfMT0fMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@000002\n0=WIf@040000003IfMT0fMWI0=WIf@<000001@3IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3I\nfMT0fMWI01X0fMWI00<0003o0=WIf@3IfMT06@3IfMT00`000?l0fMWI0=WIf@0f0=WIf@030000o`3I\nfMT0fMWI03D0fMWI00<0003o0=WIf@3IfMT0;`3IfMT000P0fMWI100000040=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003IfMT0fMWI0=WIf@00\n00001P3IfMT20000oaX0fMWI0P000?lJ0=WIf@80003o6P3IfMT00`000?l0fMWI0000o`0J0=WIf@80\n003o6P3IfMT20000oaX0fMWI0P000?lJ0=WIf@80003o<@3IfMT00100fMWI00D000000=WIf@3IfMT0\nfMWI000000020=WIf@040000003IfMT0fMWI00000080fMWI00D000000=WIf@3IfMT0fMWI00000006\n0=WIf@030000o`3IfMT0003o01T0fMWI0P000?lJ0=WIf@030000o`3IfMT0003o01T0fMWI00<0003o\n0=WIf@000?l06P3IfMT20000oaX0fMWI00<0003o0=WIf@000?l06@3IfMT20000oaX0fMWI00<0003o\n0=WIf@000?l0<03IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WI\nf@3IfMT00`3IfMT010000?l0fMWI0=WIf@000?lI0=WIf@030000o`3IfMT0003o01P0fMWI00@0003o\n0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI0000o`0I0=WIf@040000o`3IfMT0fMWI0000oaT0fMWI\n00<0003o0=WIf@000?l06@3IfMT00`000?l0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oc00\nfMWI000Q0=WIf@030000003IfMT0fMWI00<0fMWI00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0\nfMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H\n0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI\n0000o`0H0=WIf@040000o`3IfMT0fMWI0000oc00fMWI000Q0=WIf@030000003IfMT0fMWI00<0fMWI\n00@0003o0=WIf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lH0=WIf@040000o`3IfMT0fMWI\n0000oaP0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI\n00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI0000o`0H0=WIf@040000o`3IfMT0fMWI0000\noc00fMWI000Q0=WIf@030000003IfMT0fMWI00<0fMWI00@0003o0=WIf@3IfMT0003o603IfMT01000\n0?l0fMWI0=WIf@000?lH0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WI\nf@3IfMT0003o01P0fMWI00@0003o0=WIf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lH0=WI\nf@040000o`3IfMT0fMWI0000oaP0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0_0=WIf@008@3IfMT2\n000000@0fMWI00@0003o0=WIf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lH0=WIf@050000\no`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00<0003o0=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@040000o`3IfMT0fMWI0000oaP0fMWI00@0003o\n0=WIf@3IfMT0003o603IfMT01@000?l0fMWI0=WIf@3IfMT0003o02l0fMWI000Q0=WIf@030000003I\nfMT0fMWI0080fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@050000o`3IfMT0fMWI0=WIf@00\n0?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G\n0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT010000?l0fMWI0=WIf@00\n0?lH0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05P3IfMT00`000?l0fMWI0=WIf@020=WIf@030000\no`3IfMT0fMWI02d0fMWI000Q0=WIf@030000003IfMT0fMWI0080fMWI00D0003o0=WIf@3IfMT0fMWI\n0000o`0H0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o\n01L0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n0080fMWI00<0003o0=WIf@3IfMT0503IfMT01@000?l0fMWI0=WIf@3IfMT0003o01P0fMWI00D0003o\n0=WIf@3IfMT0fMWI0000o`0F0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0;@3I\nfMT00240fMWI00<000000=WIf@3IfMT00P3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01P0fMWI00D0\n003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05P3IfMT00`000?l0\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT01@000?l0\nfMWI0=WIf@3IfMT0003o01H0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0]0=WI\nf@008@3IfMT00`000000fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01D0fMWI00D0003o0=WIf@3I\nfMT0fMWI0000o`0F0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`00\n0?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`00\n0?l0fMWI0=WIf@0E0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05P3IfMT00`000?l0fMWI0=WIf@03\n0=WIf@030000o`3IfMT0fMWI02`0fMWI000Q0=WIf@030000003IfMT0fMWI0080fMWI00<0003o0=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WI\nf@3IfMT05@3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WI\nf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WI\nf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WI\nf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WI\nf@3IfMT0;03IfMT00240fMWI00<000000=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@020=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@03\n0000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WIf@03\n0000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@03\n0000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0/0=WIf@00\n8@3IfMT2000000<0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000\no`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000\no`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0;03IfMT00240fMWI00<000000=WIf@3IfMT00P3I\nfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0/0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o00D0fMWI00<0\n003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0\n003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0\n003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI02`0fMWI000Q\n0=WIf@050000003IfMT0fMWI0=WIf@000?l01@3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3I\nfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3I\nfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3I\nfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3I\nfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0;03IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000\no`050=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WI\nf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@0C0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@0/0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o00H0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI02`0fMWI000Q0=WIf@050000003IfMT0\nfMWI0=WIf@000?l01P3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI0180fMWI00<0\n003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0\n003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0\n003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0\n003o0=WIf@3IfMT0:`3IfMT00240fMWI0P0000020=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI02/0fMWI000Q0=WI\nf@050000003IfMT0fMWI0=WIf@000?l01P3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT0:`3IfMT00240fMWI00D000000=WIf@3IfMT0fMWI0000o`06\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C\n0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@05\n0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B\n0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0[\n0=WIf@008@3IfMT01@000000fMWI0=WIf@3IfMT0003o00H0fMWI00<0003o0=WIf@3IfMT04P3IfMT0\n0`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT0\n0`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT0\n0`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT0\n0`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04P3IfMT0\n0`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI02/0fMWI000Q0=WIf@050000003IfMT0fMWI\n0=WIf@000?l01P3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0:`3IfMT00240fMWI00@000000=WIf@3IfMT0003o1`3IfMT00`000?l0fMWI0=WIf@0B\n0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@05\n0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@\n0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@05\n0=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A\n0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0:`3IfMT00240fMWI00@000000=WI\nf@3IfMT0003o1`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o\n0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o\n0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o\n0=WIf@3IfMT0:`3IfMT00240fMWI0P0000000`3IfMT0003o0=WIf@060=WIf@030000o`3IfMT0fMWI\n0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0[0=WIf@008@3IfMT010000000\nfMWI0=WIf@000?l80=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0[0=WIf@008@3IfMT010000000fMWI0=WIf@000?l80=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@008@3IfMT010000000\nfMWI0=WIf@000?l80=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0Z0=WIf@008@3IfMT010000000fMWI0=WIf@000?l80=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@005@3IfMT2000000@0\nfMWI0P0000040=WIf@040000003IfMT0fMWI0000o`P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI02X0fMWI000D0=WIf@040000003IfMT0fMWI0000\n0080fMWI00@000000=WIf@3IfMT000000`3IfMT010000000fMWI0=WIf@000?l80=WIf@030000o`3I\nfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3I\nfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3I\nfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3I\nfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3I\nfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@005`3IfMT0\n10000000fMWI0=WIf@0000020=WIf@040000003IfMT0fMWI0=WIf@<0000000<0003o0=WIf@3IfMT0\n1P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\n1P3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0\n403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT0\n1`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0\n:P3IfMT000h0fMWI100000030=WIf@8000000`3IfMT010000000fMWI0=WIf@0000030=WIf@040000\n003IfMT0fMWI0000o`P0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@03\n0000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@03\n0000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@03\n0000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@03\n0000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@03\n0000o`3IfMT0fMWI02X0fMWI000E0=WIf@030000003IfMT0fMWI0080fMWI00@000000=WIf@3IfMT0\n00000`3IfMT00`000000fMWI0000o`090=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0Z0=WIf@005@3IfMT3000000<0fMWI0P0000040=WIf@030000\n003IfMT0003o00T0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI02X0fMWI000Q0=WIf@030000003IfMT0003o00T0fMWI00<0003o0=WIf@3IfMT0403I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02X0fMWI000Q0=WIf@030000003IfMT0\n003o00T0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI02X0fMWI000Q0=WIf@030000003IfMT0003o00X0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI02X0fMWI000Q0=WIf@80000000<0003o0=WIf@3I\nfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT0:@3IfMT00240fMWI00<000000=WIf@000?l02P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000\no`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000\no`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000\no`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI00<000000=WIf@000?l02P3I\nfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3I\nfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0:@3I\nfMT00240fMWI00<000000=WIf@000?l02P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00P0fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI00<000000=WIf@000?l02P3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240\nfMWI00<000000=WIf@000?l02P3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI00<000000=WIf@000?l02P3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0:@3IfMT00240fMWI0P00\n00000`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3I\nfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3I\nfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3I\nfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3I\nfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0:0=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0\nfMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`00\n0000003o0=WIf@0:0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0:0=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00d0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0;0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0;\n0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y\n0=WIf@008@3IfMT00`000000003o0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0;0=WIf@03\n0000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@00\n8@3IfMT00`000000003o0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n3@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0Y0=WIf@008@3IfMT00`000000003o0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT01P3IfMT200000080fMWI00@0003o0=WIf@0000000000\n0`3IfMT5000000@0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@800000\n00@0fMWI0000o`3IfMT0fMWI0P0000030=WIf@@0000000<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@030000o`000000000000@0fMWI0P0000040=WIf@80000000<0003o0=WIf@3I\nfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00800000103IfMT200000080\nfMWI00<0003o0=WIf@3IfMT00`00000:0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3I\nfMT0103IfMT2000000@0fMWI0P0000040=WIf@8000005`3IfMT00240fMWI00<000000000o`3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00D0fMWI00H000000=WIf@3IfMT0\n00000=WIf@000?l80=WIf@030000003IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@090=WIf@050000003IfMT0fMWI000000000?l01`3IfMT01@000000fMWI0=WIf@3I\nfMT0003o00l0fMWI00<0003o0=WIf@3IfMT02P3IfMT010000?l0fMWI0=WIf@0000080=WIf@040000\n003IfMT0fMWI0000o``0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI000000020=WIf@03\n0000003IfMT0fMWI00D0fMWI00D0003o0=WIf@3IfMT0fMWI0000000;0=WIf@030000o`3IfMT0fMWI\n00T0fMWI00<0003o0=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@0000080=WIf@040000003IfMT0\nfMWI000001H0fMWI000Q0=WIf@03000000000?l0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT0\n0`000?l0fMWI0=WIf@050=WIf@060000003IfMT0fMWI0000003IfMT0003o203IfMT00`000000fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT02@3IfMT01@000000fMWI\n0=WIf@000000003o00P0fMWI00@000000=WIf@3IfMT0003o3`3IfMT00`000?l0fMWI0=WIf@0:0=WI\nf@040000o`3IfMT0fMWI000000X0fMWI00<000000000o`3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<\n0=WIf@030000o`3IfMT000000080fMWI00<000000=WIf@3IfMT01P3IfMT00`000?l0000000000002\n000000X0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@030=WIf@040000003IfMT0\nfMWI000000/0fMWI00<000000=WIf@3IfMT0503IfMT00240fMWI00<000000000o`3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00D0fMWI00@000000=WIf@3IfMT000000P3I\nfMT00`000?l0fMWI0=WIf@050=WIf@030000003IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT02P3I\nfMT00`000?l0fMWI0=WIf@090=WIf@050000003IfMT0fMWI000000000?l02@3IfMT00`000000fMWI\n0000o`0?0=WIf@030000o`3IfMT0fMWI00X0fMWI00@0003o0=WIf@3IfMT000002`3IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@0000000P3IfMT00`000000\nfMWI0=WIf@060=WIf@040000o`3IfMT0fMWI000000X0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00\n0?l0fMWI0=WIf@030=WIf@040000003IfMT0fMWI000000T0fMWI0P00000G0=WIf@008@3IfMT00`00\n0?l000000=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT01@3IfMT01000\n0000fMWI0=WIf@0000020=WIf@030000o`3IfMT0fMWI00D0fMWI00<000000=WIf@3IfMT00`3IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00T0fMWI00D000000=WIf@3IfMT000000000\no`070=WIf@050000003IfMT0fMWI000000000?l03`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@040000\no`3IfMT0fMWI000000P0fMWI00@000000=WIf@3IfMT0003o303IfMT00`000?l0fMWI0=WIf@0<0=WI\nf@030000o`3IfMT000000080fMWI00<000000=WIf@3IfMT01P3IfMT010000?l000000=WIf@00000:\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT00`3IfMT010000000fMWI0=WIf@00\n00090=WIf@030000003IfMT0fMWI01H0fMWI000Q0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o\n0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@060=WIf@8000000`3IfMT00`000?l0fMWI0=WIf@04\n0=WIf@8000001@3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00X0fMWI0P000000\n0`3IfMT0003o0=WIf@070=WIf@8000000P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0\nfMWI00X0fMWI00<0003o0000000000002P3IfMT00`000000003o0=WIf@0<0=WIf@030000o`3IfMT0\nfMWI00`0fMWI00<0003o0=WIf@3IfMT00P0000090=WIf@040000o`3IfMT00000000000X0fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@040=WIf@8000002P3IfMT3000001H0fMWI000Q\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<\n0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI02T0fMWI000Q0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WI\nf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WI\nf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI02T0fMWI000Q0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@03\n0000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000o`3IfMT0fMWI02T0fMWI000Q0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI01X0fMWI0P00000=0=WIf@008@3I\nfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3I\nfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3I\nfMT00`000?l0fMWI0=WIf@0H0=WIf@040000003IfMT0fMWI000000`0fMWI000L0=WIf@D0000000<0\n003o000000000000300000000`000?l000000000000:000000030000o`000000000000`0000000<0\n003o0000000000002`0000000`000?l000000000000;000000030000o`000000000000/0000000<0\n003o0000000000002`0000000`000?l000000000000<000000030000o`000000000000X0000000<0\n003o0000000000002`0000000`000?l000000000000<000000030000o`000000000000X0000000<0\n003o000000000000300000000`000?l000000000000;000000030000o`000000000000/0000000<0\n003o0000000000004@0000070=WIf@030000003IfMT0fMWI00d0fMWI000Q0=WIf@030000003IfMT0\nfMWI00H0fMWI00<000000=WIf@3IfMT00`3IfMT010000?l0fMWI0=WIf@0000080=WIf@0300000000\n0?l0fMWI00H0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI000000080=WIf@040000003I\nfMT0fMWI0000o`D0fMWI00<000000=WIf@3IfMT01@3IfMT00`000?l000000=WIf@070=WIf@050000\n003IfMT0fMWI0=WIf@000?l0103IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<000000=WIf@3IfMT00`3IfMT010000?l0fMWI0=WIf@0000080=WIf@03000000000?l0fMWI\n00H0fMWI00<000000=WIf@3IfMT00`3IfMT010000?l0fMWI0=WIf@0000080=WIf@040000003IfMT0\nfMWI0000o`D0fMWI00<000000=WIf@3IfMT0103IfMT00`000?l0fMWI000000080=WIf@050000003I\nfMT0fMWI0=WIf@000?l0103IfMT00`000000fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00H0fMWI\n00<000000=WIf@3IfMT00P3IfMT01@000?l0fMWI0=WIf@3IfMT0000000P0fMWI00<000000=WIf@3I\nfMT02P3IfMT5000000`0fMWI000Q0=WIf@030000003IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI01P0fMWI00<000000=WIf@3IfMT0\n3@3IfMT00240fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3I\nfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3I\nfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0:03IfMT00240fMWI00<000000=WIf@3IfMT0303IfMT0\n0`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT0\n0`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT0\n0`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT0\n0`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0:03IfMT0\n0240fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI\n00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI\n00`0fMWI00<0003o0=WIf@3IfMT0:03IfMT00240fMWI00<000000=WIf@3IfMT0303IfMT00`000?l0\nfMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0\nfMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0\nfMWI0=WIf@0;0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0\nfMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0\nfMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0:03IfMT00240fMWI\n0P00000=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI\n0=WIf@0;0=WIf@030000o`3IfMT0fMWI00/0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI\n0=WIf@0X0=WIf@008@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0\n003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0\n003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0X0=WIf@008@3IfMT00`000000fMWI0=WIf@0<\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02`3IfMT00`000?l0fMWI0=WIf@0<\n0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:\n0=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0X\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WI\nf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0X0=WIf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@03\n0000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@03\n0000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@03\n0000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0X0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT0\n3P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT0\n2P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0\n2@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT0\n303IfMT00`000?l0fMWI0=WIf@0X0=WIf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3I\nfMT0fMWI00`0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT0303IfMT00`000?l0fMWI0=WIf@0:0=WIf@030000o`3I\nfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3I\nfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@0W0=WIf@008@3IfMT2\n000000h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0\nfMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`000?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0\nfMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0\nfMWI02L0fMWI000Q0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`00\n0?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02P3IfMT00`00\n0?l0fMWI0=WIf@0<0=WIf@030000o`3IfMT0fMWI00X0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`00\n0?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI02L0fMWI000Q0=WIf@030000003IfMT0fMWI00d0\nfMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0\nfMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI02L0\nfMWI000Q0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI\n0=WIf@0=0=WIf@030000o`3IfMT0fMWI02L0fMWI000Q0=WIf@030000003IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0\n003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0\n003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0\n003o0=WIf@3IfMT06`3IfMT00240fMWI00<000000=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>\n0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT03@3IfMT00`000?l0fMWI0=WIf@09\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=\n0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@08\n0=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K\n0=WIf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WI\nf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00d0fMWI00<0003o0=WI\nf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WI\nf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI01/0fMWI000Q0=WIf@80\n00003P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3I\nfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3I\nfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3I\nfMT02@3IfMT00`000?l0fMWI0=WIf@0=0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3I\nfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3I\nfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@008@3IfMT00`000000fMWI0=WIf@0=0=WIf@030000\no`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000\no`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000\no`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000\no`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000\no`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@090=WIf@030000\no`3IfMT0fMWI01/0fMWI000Q0=WIf@030000003IfMT0fMWI00d0fMWI00<0003o0=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3I\nfMT00`000?l0fMWI0=WIf@090=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203I\nfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00T0fMWI00<0003o0=WIf@3IfMT06`3I\nfMT00240fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0\nfMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00L0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0\nfMWI00h0fMWI00<0003o0=WIf@3IfMT02@3IfMT00`000?l0fMWI0=WIf@0K0=WIf@008@3IfMT00`00\n0000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`00\n0?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`00\n0?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03P3IfMT00`00\n0?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI01`0fMWI000Q0=WIf@030000003IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0\nfMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00P0\nfMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00h0\nfMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0\nfMWI00<0003o0=WIf@3IfMT0703IfMT00240fMWI00<000000=WIf@3IfMT03P3IfMT00`000?l0fMWI\n0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI\n0=WIf@0?0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI\n0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI\n0=WIf@0L0=WIf@008@3IfMT2000000l0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WI\nf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0>0=WIf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WI\nf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WI\nf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0703IfMT00240fMWI00<00000\n0=WIf@3IfMT03P3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT0203IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o\n0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o\n0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0L0=WIf@008@3IfMT00`000000fMWI0=WIf@0>0=WI\nf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@080=WI\nf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WI\nf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0?0=WI\nf@030000o`3IfMT0fMWI00P0fMWI00<0003o0=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@070=WI\nf@030000o`3IfMT0fMWI01`0fMWI000Q0=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT0703IfMT001D0fMWI0P0000040=WIf@800000103IfMT00`000000fMWI0=WIf@0>0=WIf@030000\no`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000\no`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000\no`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000\no`3IfMT0fMWI01`0fMWI000D0=WIf@040000003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT0\n00000`3IfMT00`000000fMWI0=WIf@0>0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT01`3IfMT00`000?l0fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI00l0fMWI00<0003o0=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI01`0fMWI000G0=WIf@040000\n003IfMT0fMWI00000080fMWI00@000000=WIf@3IfMT0fMWI0`00000>0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01`3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI\n01`0fMWI000E0=WIf@8000000`3IfMT010000000fMWI0=WIf@0000030=WIf@030000003IfMT0fMWI\n00h0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@070=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI\n0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI\n00L0fMWI00<0003o0=WIf@3IfMT0703IfMT001D0fMWI00<000000=WIf@3IfMT00P3IfMT010000000\nfMWI0=WIf@0000030=WIf@030000003IfMT0fMWI00h0fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`00\n0?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00L0fMWI00<0003o0=WIf@3IfMT0703IfMT001D0\nfMWI0`0000030=WIf@800000103IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100\nfMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0\nfMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI01d0\nfMWI000Q0=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI\n0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI\n0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI\n0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI\n0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI00<0\n00000=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0\n003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0100fMWI00<0\n003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0\n003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0\n003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0M0=WIf@008@3IfMT00`000000fMWI0=WIf@0?\n0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A\n0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@06\n0=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0@\n0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@05\n0=WIf@030000o`3IfMT0fMWI01d0fMWI000Q0=WIf@800000403IfMT00`000?l0fMWI0=WIf@050=WI\nf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WI\nf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@050=WI\nf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0@0=WI\nf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WI\nf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0M0=WI\nf@008@3IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3I\nfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3I\nfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0100fMWI00<0003o0=WIf@3I\nfMT01P3IfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3I\nfMT04@3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI01d0fMWI000Q0=WIf@030000\n003IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000\no`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000\no`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000\no`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@060=WIf@030000\no`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000\no`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT07@3IfMT00240fMWI00<000000=WIf@3IfMT03`3I\nfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT04@3I\nfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3I\nfMT00`000?l0fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI00H0fMWI00<0003o0=WIf@3IfMT04@3I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT01@3I\nfMT00`000?l0fMWI0=WIf@0M0=WIf@008@3IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0\nfMWI00D0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0180fMWI00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0\nfMWI0140fMWI00<0003o0=WIf@3IfMT01P3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0\nfMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0\nfMWI01d0fMWI000Q0=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT01@3IfMT00`00\n0?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`00\n0?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04@3IfMT00`00\n0?l0fMWI0=WIf@060=WIf@030000o`3IfMT0fMWI0140fMWI00<0003o0=WIf@3IfMT0103IfMT00`00\n0?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0fMWI00<0003o0=WIf@3IfMT07@3IfMT00240\nfMWI00<000000=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140\nfMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0\nfMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180\nfMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00D0\nfMWI00<0003o0=WIf@3IfMT04@3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180\nfMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT200000100fMWI\n00<0003o0=WIf@3IfMT01@3IfMT00`000?l0fMWI0=WIf@0A0=WIf@030000o`3IfMT0fMWI00@0fMWI\n00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI\n00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI\n00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@050=WIf@030000o`3IfMT0fMWI0140fMWI\n00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI\n00<0003o0=WIf@3IfMT07P3IfMT00240fMWI00<000000=WIf@3IfMT03`3IfMT00`000?l0fMWI0=WI\nf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WI\nf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WI\nf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WI\nf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WI\nf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WI\nf@0N0=WIf@008@3IfMT00`000000fMWI0=WIf@0?0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o\n0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o\n0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o\n0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01h0fMWI000Q0=WI\nf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0B0=WI\nf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WI\nf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0D0=WI\nf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04P3IfMT00`000?l0fMWI0=WIf@040=WI\nf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WI\nf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT07P3IfMT00240fMWI00<000000=WIf@3I\nfMT03`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI0180fMWI00<0003o0=WIf@3I\nfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0B0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3I\nfMT04P3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3I\nfMT00`3IfMT00`000?l0fMWI0=WIf@0N0=WIf@008@3IfMT00`000000fMWI0=WIf@0?0=WIf@030000\no`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000\no`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000\no`3IfMT0fMWI0180fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000\no`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@030=WIf@030000\no`3IfMT0fMWI01h0fMWI000Q0=WIf@030000003IfMT0fMWI00l0fMWI00<0003o0=WIf@3IfMT0103I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3I\nfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04P3I\nfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3I\nfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT07P3I\nfMT00240fMWI0P00000@0=WIf@030000o`3IfMT0fMWI00@0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT0103IfMT0\n0`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT0\n0`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01h0fMWI000Q0=WIf@030000003IfMT0fMWI\n00l0fMWI00<0003o0=WIf@3IfMT0103IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI\n01D0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI\n0080fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0fMWI0=WIf@040=WIf@030000o`3IfMT0fMWI\n01<0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0fMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI\n0080fMWI00<0003o0=WIf@3IfMT07`3IfMT00240fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0\nfMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT00`000?l0\nfMWI0=WIf@0C0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT05@3IfMT00`000?l0\nfMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3IfMT04`3IfMT00`000?l0\nfMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01<0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0\nfMWI0=WIf@0O0=WIf@008@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0080fMWI\n00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI\n00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3I\nfMT0503IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3I\nfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0fMWI00<0003o0=WIf@3I\nfMT0503IfMT01@000?l0fMWI0=WIf@3IfMT0003o0240fMWI000Q0=WIf@030000003IfMT0fMWI0100\nfMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0D0=WIf@030000o`3IfMT0fMWI00<0\nfMWI00<0003o0=WIf@3IfMT0503IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WI\nf@3IfMT0fMWI0000o`0G0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT0\n0`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o0=WIf@3IfMT00`3IfMT0\n0`000?l0fMWI0=WIf@0D0=WIf@050000o`3IfMT0fMWI0=WIf@000?l08@3IfMT00240fMWI00<00000\n0=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01@0fMWI00<0003o\n0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3I\nfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI\n0=WIf@0D0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0503IfMT00`000?l0fMWI\n0=WIf@030=WIf@030000o`3IfMT0fMWI01@0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0Q0=WIf@00\n8@3IfMT00`000000fMWI0=WIf@0@0=WIf@030000o`3IfMT0fMWI0080fMWI00<0003o0=WIf@3IfMT0\n5@3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01L0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WI\nf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0\nfMWI01@0fMWI00<0003o0=WIf@3IfMT00P3IfMT00`000?l0fMWI0=WIf@0E0=WIf@050000o`3IfMT0\nfMWI0=WIf@000?l05`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o0240fMWI000Q0=WIf@8000004@3I\nfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0fMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI\n0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l0603IfMT010000?l0fMWI0=WIf@000?lG0=WI\nf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3IfMT0\nfMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l0\n8@3IfMT00240fMWI00<000000=WIf@3IfMT0403IfMT00`000?l0fMWI0=WIf@020=WIf@030000o`3I\nfMT0fMWI01D0fMWI00D0003o0=WIf@3IfMT0fMWI0000o`0G0=WIf@040000o`3IfMT0fMWI0000oaT0\nfMWI00@0003o0=WIf@3IfMT0003o5`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01P0fMWI00D0003o\n0=WIf@3IfMT0fMWI0000o`0G0=WIf@050000o`3IfMT0fMWI0=WIf@000?l05`3IfMT010000?l0fMWI\n0=WIf@000?lR0=WIf@008@3IfMT00`000000fMWI0=WIf@0A0=WIf@040000o`3IfMT0fMWI0000oaP0\nfMWI00D0003o0=WIf@3IfMT0fMWI0000o`0H0=WIf@030000o`3IfMT0003o01T0fMWI00@0003o0=WI\nf@3IfMT0003o5`3IfMT01@000?l0fMWI0=WIf@3IfMT0003o01P0fMWI00@0003o0=WIf@3IfMT0003o\n603IfMT01@000?l0fMWI0=WIf@3IfMT0003o01P0fMWI00<0003o0=WIf@000?l08P3IfMT00240fMWI\n00<000000=WIf@3IfMT04@3IfMT010000?l0fMWI0=WIf@000?lH0=WIf@050000o`3IfMT0fMWI0=WI\nf@000?l0603IfMT00`000?l0fMWI0000o`0I0=WIf@030000o`3IfMT0003o01T0fMWI00@0003o0=WI\nf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lH0=WIf@050000o`3IfMT0fMWI0=WIf@000?l0\n603IfMT00`000?l0fMWI0000o`0R0=WIf@008@3IfMT00`000000fMWI0=WIf@0A0=WIf@040000o`3I\nfMT0fMWI0000oaP0fMWI00@0003o0=WIf@3IfMT0003o6@3IfMT00`000?l0fMWI0000o`0I0=WIf@03\n0000o`3IfMT0003o01T0fMWI00@0003o0=WIf@3IfMT0003o603IfMT010000?l0fMWI0=WIf@000?lI\n0=WIf@030000o`3IfMT0003o01T0fMWI00<0003o0=WIf@000?l08P3IfMT000h0fMWI1@0000020=WI\nf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT04@3IfMT010000?l0fMWI0=WIf@000?lI\n0=WIf@030000o`3IfMT0003o01T0fMWI00<0003o0=WIf@000?l06P3IfMT20000oaT0fMWI00<0003o\n0=WIf@000?l06P3IfMT00`000?l0fMWI0000o`0I0=WIf@030000o`3IfMT0003o01T0fMWI00<0003o\n0=WIf@000?l08P3IfMT00100fMWI00D000000=WIf@3IfMT0fMWI000000020=WIf@040000003IfMT0\nfMWI00000080fMWI00D000000=WIf@3IfMT0fMWI0000000D0=WIf@80003o6P3IfMT00`000?l0fMWI\n0000o`0J0=WIf@80003o6P3IfMT00`000?l0fMWI0=WIf@0H0=WIf@030000o`3IfMT0003o01X0fMWI\n0P000?lJ0=WIf@030000o`3IfMT0003o01X0fMWI0P000?lR0=WIf@00403IfMT01@000000fMWI0=WI\nf@3IfMT000000080fMWI00@000000=WIf@3IfMT000000P3IfMT010000000fMWI0=WIf@3IfMT30000\n0180fMWI0P000?lK0=WIf@030000o`3IfMT0fMWI01T0fMWI0P000?lJ0=WIf@030000o`3IfMT0fMWI\n01T0fMWI00<0003o0=WIf@3IfMT06P3IfMT00`000?l0fMWI0=WIf@0I0=WIf@030000o`3IfMT0fMWI\n01T0fMWI0P000?lR0=WIf@00403IfMT01@000000fMWI0=WIf@3IfMT000000080fMWI00@000000=WI\nf@3IfMT000000P3IfMT01@000000fMWI0=WIf@3IfMT000000?h0fMWI000@0=WIf@050000003IfMT0\nfMWI0=WIf@0000000P3IfMT010000000fMWI0=WIf@0000020=WIf@050000003IfMT0fMWI0=WIf@00\n0000oP3IfMT000l0fMWI0P0000040=WIf@800000103IfMT2000000@0fMWI00<000000=WIf@3IfMT0\no03IfMT00240fMWI00<000000=WIf@3IfMT0o03IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT00?l0\nfMWI8@3IfMT00?l0fMWI8@3IfMT00?l0fMWI8@3IfMT002D0fMWI00<000000=WIf@3IfMT0:P3IfMT0\n0`000000fMWI0=WIf@050=WIf@800000203IfMT200000;X0fMWI000T0=WIf@030000003IfMT0fMWI\n02`0fMWI00<000000=WIf@3IfMT0103IfMT00`000000fMWI0=WIf@080=WIf@030000003IfMT0fMWI\n0;P0fMWI000S0=WIf@040000003IfMT0fMWI0=WIf@80000000D0fMWI0000003IfMT000000=WIf@05\n000000040=WIf@0000000000000000<0fMWI0`0000030=WIf@D000000P3IfMT2000000@0fMWI0P00\n00050=WIf@030000003IfMT0fMWI00<0fMWI00<000000=WIf@3IfMT00P3IfMT2000000@0fMWI00<0\n00000=WIf@3IfMT0^03IfMT002<0fMWI00<000000=WIf@3IfMT00P3IfMT01P000000fMWI0000003I\nfMT000000=WIf@@000001@3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI0080fMWI\n00<000000=WIf@3IfMT0203IfMT2000000D0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI\n0=WIf@3IfMT000000080fMWI00D000000=WIf@3IfMT0fMWI0000002j0=WIf@005P3IfMT80000o`D0\nfMWI00<000000=WIf@3IfMT00P3IfMT01@000000fMWI0000003IfMT0000000@0fMWI00<000000=WI\nf@3IfMT00`0000030=WIf@<000001@3IfMT00`000000fMWI0=WIf@070=WIf@040000003IfMT0fMWI\n000000@0fMWI00<000000=WIf@3IfMT00`3IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<0\n00000=WIf@3IfMT0^03IfMT002<0fMWI00@000000=WIf@3IfMT0fMWI0`0000000`3IfMT000000=WI\nf@020=WIf@<000000P3IfMT400000080fMWI100000040=WIf@030000003IfMT0fMWI00H0fMWI0P00\n00020=WIf@8000000`3IfMT00`000000fMWI0=WIf@030=WIf@030000003IfMT0fMWI00D000000`3I\nfMT00`000000fMWI0=WIf@2h0=WIf@00903IfMT00`000000fMWI0=WIf@0K0=WIf@030000003IfMT0\nfMWI00h0fMWI00<000000=WIf@3IfMT0103IfMT01@000000fMWI0=WIf@3IfMT0000000H0fMWI00<0\n00000=WIf@3IfMT0^03IfMT002D0fMWI00<000000=WIf@3IfMT06@3IfMT2000000l0fMWI00<00000\n0=WIf@3IfMT01@3IfMT2000000P0fMWI0P00002j0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\no`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00o`3IfMTQ0=WIf@00\n"]], Rule[ImageRangeCache, List[Rule[List[List[0, 287], List[213.25`, 0]], List[-1.05141`, -0.655244`, 0.00732689`, 0.00732689`]], Rule[List[List[7, 279.938`], List[208.125`, 39.4375`]], List[-0.0756122`, -128.803`, 0.00222733`, 1.43964`]], Rule[List[List[20.625`, 157.125`], List[46, 5.0625`]], List[-2.57534`, -5.65634`, 0.119891`, 0.0332217`]], Rule[List[List[22.125`, 30.4375`], List[40.5625`, 10.4375`]], List[-6.32337`, -45.1734`, 0.240604`, 0.240604`]]]]], Cell[TextData[List[StyleBox["\t\t\tDiagram 2:", Rule[FontWeight, "Bold"]], " Plot of the absolute velocity mass1.v(t) of the center of the haning mass."]], "Text"]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[874, 924]], Rule[WindowMargins, List[List[0, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]