List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Signal Based Connector Classes", "Title"], Cell[TextData[List["Signal based connector classes are very simple. All that is needed is a vector of input signals or output signals. Most application models where signal connectors are needed can be satisfied with the connector classes ", StyleBox["InPort", Rule[FontFamily, "Courier"]], " and ", StyleBox["OutPort", Rule[FontFamily, "Courier"]], " below, both from the library ", StyleBox["Modelica.Blocks.Interfaces.\n", Rule[FontFamily, "Courier"]]]], "Text"], Cell["connector InPort\t\t\t\t\"Connector with input signals of type Real\"\n  parameter Integer n = 1\t\t\"Dimension of signal vector\";\n  input Real \t\tsignal[n]\t\"Real input signals\";\nend InPort;", "ModelicaInput"], Cell["", "Text"], Cell["connector OutPort\t\t\t\t\"Connector with output signals of type Real\"\n  parameter Integer n = 1\t\t\"Dimension of signal vector\";\n  output Real \t\tsignal[n]\t\"Real output signals\";\nend OutPort;", "ModelicaInput"], Cell[TextData[List["\nThe ", StyleBox["InPort", Rule[FontFamily, "Courier"]], " and ", StyleBox["OutPort", Rule[FontFamily, "Courier"]], " connector classes can be specialized to different numbers of signals when instantiated,as in the class ", StyleBox["MISO", Rule[FontFamily, "Courier"]], " below"]], "Text"], Cell["partial block MISO\t\t\t\t\t\t\"Multiple Input Signal Output continuous control block\"\n  parameter Integer nin = 1\t\t\t\t\"Number of inputs\";\n  InPort \t\t\tinPort(n = nin)\t\t\"Connector of Real input signals\";\n  OutPort \t\t\toutPort(n = 1)\t\t\"Connector of Real output signal\";\nprotected\n  Real u[:] = inPort.signal\t\t\t\t\"Input signals\";\n  Real y = outPort.signal[1]\t\t\t\"Output signal\";\nend MISO;\t\t\t\t\t\t\t\t// From Modelica.Blocks.Interfaces", "ModelicaInput"]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[848, 857]], Rule[WindowMargins, List[List[-12, Automatic], List[Automatic, 3]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]