List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["A Coupled Pipelined DEVS Model (p. 400)", "Title"], Cell[CellGroupData[List[Cell["The Random Package", "Section"], Cell["package Random", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["import Modelica.Math;", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["constant Real NV_MAGICCONST=4*exp(-0.5)/sqrt(2.0);", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["type Seed=Integer[3];", "ModelicaInput", Rule[InitializationCell, True]], Cell["\nDymolaBUG: for some strange  reason Dymola crashes when the following statement is initialized\ntype Seed=Integer[3](min=zeros(3),max=ones(3)*255);\nthis will also cause MathModelica to loop forever in the evaluation of the model.\nThe follwing statement should be used instead\ntype Seed;\n", "Text"], Cell["function random \"input random number generator with external storage of the seed\"\n  input Seed si \"input random seed\";\n  output Real x \"uniform random variate between 0 and 1\";\n  output Seed so \"output random seed\";\nalgorithm\n  so[1] := rem((171 * si[1]),30269);\n  so[2] := rem((172 * si[2]),30307);\n  so[3] := rem((170 * si[3]),30323);\n  // zero is a poor Seed, therfore substitute 1;\n  if so[1] == 0 then\n    so[1] := 1;\n  end if;\n  if so[2] == 0 then\n    so[2] := 1;\n  end if;\n  if so[3] == 0 then\n    so[3] := 1;\n  end if;\n  x := rem((so[1]/30269.0 +so[2]/30307.0 + so[3]/30323.0),1.0);\nend random;", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["function normalvariate \"normally distributed random variable\"\n  input Real mu \"mean value\";\n  input Real sigma \"standard deviation\";\n  input Seed si \"input random seed\";\n  output Real x \"gaussian random variate\";\n  output Seed so \"output random seed\";\nprotected\n  Seed s1, s2;\n  Real z, zz, u1, u2;\n  Boolean break=false;\nalgorithm\n  s1 := si;\n  u2 := 1;\n  while not break loop\n    (u1,s2) := random(s1);\n    (u2,s1) := random(s2);\n    z := NV_MAGICCONST*(u1-0.5)/u2;\n    zz := z*z/4.0;\n    break := zz <= (- Math.log(u2));\n  end while;\n  x := mu + z*sigma;\n  so := s1; \nend normalvariate;\n", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["connector discreteConnector\n   discrete Boolean dcon;\nend discreteConnector;", "ModelicaInput", Rule[InitializationCell, True]], Cell["", "Text"], Cell["end Random;", "ModelicaInput", Rule[InitializationCell, True]]], Open]], Cell[CellGroupData[List[Cell["SimpleDEVSServer", "Section"], Cell["connector EventPort\n\tBoolean signal;\nend EventPort;", "ModelicaInput"], Cell["", "Text"], Cell["model SimpleDEVSServer\n  import Modelica.Constants.inf; // ?? check if import specified constant\n  extends BasicDEVSTwoPort;\n  Boolean   internalEvent;\n  Boolean   externalEvent;\n  parameter Real  mean  = 2.0  \"mean of job service time\";\n  parameter Real  stdev = 0.5;\n  discrete  Real  servTime;  // time needed to service current job\n discrete  Random.Seed randomSeed(start={23,87,187});\n \nequation\n  internalEvent = pre(tNextEvent)<=time;\n  externalEvent = inp.signal;\n  //outp.signal   = internalEvent; \n  when {externalEvent,internalEvent} then\n    (servTime,randomSeed) = Random.normalvariate(mean,stdev, pre(randomSeed));\n    if edge(externalEvent) and not pre(DEVSactive) then    \t\t\t\n    \tDEVSactive = true;\n    \ttNextEvent  = time + abs(servTime); \n    elseif edge(externalEvent) and pre(DEVSactive) then\n      DEVSactive = true;\n      tNextEvent  = pre(tNextEvent); \n    else\n      DEVSactive = false;\n      tNextEvent = pre(tNextEvent); \n    end if;\n  end when;\n  \n  outp.signal = if pre(DEVSactive) and edge(internalEvent) then true else false;\nend SimpleDEVSServer;", "ModelicaInput"], Cell["", "Text"], Cell["model SignalView  \"Increase width of sample trigger signals\" // ?? update\n\tEventPort    inp;\n\tEventPort    outp;\n\tparameter Real width=0.001;\n\tdiscrete  Real T0;\nequation\n\twhen inp.signal then\n    T0=time;\n\tend when;\n\toutp.signal=(time>=T0) and (time<T0+width);\nend TriggerSignalView;", "ModelicaInput"], Cell["", "Text"], Cell["class Conn1\nequation\n  connect(simpleDEVSServer.outp, viewSignal2.inp);\nend Conn1;", "ModelicaInput"], Cell["", "Text"], Cell["class Conn2\nequation\n  connect(generateJobEvents.outp, viewSignal1.inp);\nend Conn2;", "ModelicaInput"], Cell["", "Text"]], Open]], Cell[CellGroupData[List[Cell["ThreeServerPipeline Model", "Section"], Cell[TextData[List["Several basic DEVS model components can be connected together to form a coupled model, which itself is a DEVS model. This is illustrated by the Modelica realization of a simple DEVS coupled model by placing three simple servers in series to form a three server pipeline, see Figure ?? In the further down the job generator has been attached to the three server pipeline.  The generator outputs events that are considered to be jobs that need some time to be processed by the server.Inside the basic server model only the time needed to complete a job is represented,not the detailed manner in which the processing is done.When a server receives a job it goes into busy mode (", StyleBox["DEVSactive = true", Rule[FontFamily, "Courier"]], "). Since the server has no buffering capabilities,if it is already busy,it ignores incoming jobs.When a server has finished processing a job, a job completed event is emitted and the server returns to passive mode (", StyleBox["DEVSactive = false", Rule[FontFamily, "Courier"]], ")."]], "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@0003n@0@0006`00000000000000;P100290000\n00000000001O:000L0d00215CDH00040T3l00801000=0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP0009PD002:5000AdA9@`4008000`00LE8ULP00001b5000\n0@090003>@X000h0;P000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:208L170000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4001`0003k0_3o00000000T040000014004UAYKFEc84iUMb1BKfeQ\nKP2nH_Egaf;eM`4000000300100002d10@0500000P4100001@0000T200000P<0000N00L0000F1880\nQ`400000400002H63`0F0?ooool00?ooooooooooR04008<0000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01@0000/2000000D0000<0Rd3S0TD00009PH?01h0ooooo`@0500005M_\nLV@>04eYHg9_LfmVM21GKg9T1@0000`2;@><2A`0003k0Q@02@000000_080000010828U=iLgAUK@1g\n@00002092PjnH_Egaf;eM`4000000300100002d1100500000P41000070000?/2[Ol00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4500D000090P0000850000\n2`8000003@00038:0@00004010000000S0T]0b009@040000;@4200@0000]0@<01`0001/4K`3[22T0\n[0P70000o0800?ooo`0000@0000]0@H020000?X200000000000000@0000]0@L00`0001h01`0001H4\nK@3Z22T0[0P500000P41000070000?/2[Ol00000002@0@000004@00R@G9YHF`0mGM00000<PP:=KiR\nmGO7H_Eg0@000000<0040000;@480100000b2R80[0P300@0[0PY0>T8K@0P82015`0G01P070000?/2\n]Ol00000002@0@000004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4900d0\n000b2RX0lPP100@0[0PY0>T8K@0P0240100002L1ool40000;@4200@0000]0@<01`0001/4:`=00>H2\n0P040000;@4600@0000]0@L00`0001h01`0001H4:P=00>H20P0500000P410000100002d120050000\n2@8000024000038:g`8200<010020>H2?`0Z0b0P800G01L060040000;@4900d0000b2^L2B00100@0\n0P3V0Sl0:P<P0240100002L1ool@00009PH?01H0ooooo`00f`000801002F0@00/`4000P0003j0P00\n1P00000000040000;@4:00@0000]0@80200002D30P3O09T1J@6I0@@0000]0@<010000?012P070000\no0800000000000@0000]0@X02P0002@30`1W0Jl1TP6J0FL1Q0440000;@4700@0000]0@H010000?01\n2P0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K14@0R`Wood`9100002d11P040000\n;@4700<0000N00L0000F14<0RPWood`91@0000810@0000@0000]0@P01@0000T200000Q00000b2_So\nC0T300@0C0WoohT9@`0P82005`0G01P0100002d12@0=0000<PX009890@0404`9oon92D<0800Q00@0\n000W0Ooo100002d10P040000;@4300L0000K1?D0P0J=01H3100002d11P040000;@4700<0000N00L0\n000F1?@0P0J=01L31@0000810@0000@0000]0@P01@0000T200000RP0000b2Xl0C`<C00@05`>=07l6\nm01DJ79UIE=ULWIULU1YL6E/JFiU03<0;P0L02h0;P0h02h0700Z02h0700g01<0;P0^01<04P0_02h0\n100002d11@0=0000<PZ@04H60@0401L3S@1o1_@0800V00@0000W0Ooo100002d10P080000nP8000H0\n00000002100002d12P0700006`C10]48LP3100@0000]0@H0100002d11`040000l04:0100000V1Pl0\n5P3ooooo00181P00:`400>@700070P001`000?`2003oool000040000;@4:00P0003j0P001P000000\n00840000;@4;00L0000K10P2b0L[0FL6100002d11P040000l04:00@0000]0@L010000?012`040000\n;@4200@0000]0@<01`0001/4b`5k1fP1^`H40000;@4600@0000]0@L00`0001h01`0001H4b@5j1fP1\n^PH500000P41000070000?/2]Ol00000002@0@000004@00R@G9YHF`0mGM000007`T:IKiRmGO7H_Eg\n0@000000<0040000;@4:00D000090P00008>0000<PYY0N/60P040;X6J05i1lT1Dc<b02X0100002d1\n2@0=0000<PYY0DL70@040;X6J05i1lT183<R00@0000W0Ooo1`000?`2003oool000040000;@4;00P0\n003j0P001P00000000840000;@4<00L0000K1;L1Q@Ik0DT6100002d11P040000l04;00@0000]0@L0\n10000?0130070000o0800?ooo`0000@0000]0@/020000?X20006000000000P@0000]0@`01`0001/4\n]`7V1g/1Z@L40000;@4600@0003`0@/0100002d11`040000l04<00L0003l0P00oooo0000100002d1\n2`080000nP8000H000000002100002d1300700006`Bh0N`8N`6_20@0000]0@H010000?012`040000\n;@4700@0003`0@`01`000?`2003oool000040000;@4;00P0003j0P001P00000000840000;@4<00L0\n000K1;P1h01k0J<0100002d11P040000l04;00@0000]0@L010000?01300@00009PH?01H0ooooo`00\nUP4002/1000b0`001`8000L0003l0P00oooo0000100002d12`080000nP8000H000000002100002d1\n300700006`@80QH3:`6d0@@0000]0@H010000?012`040000;@4700@0003`0@`0100002d10P040000\n;@4300L0000K1</1b09X0@P2100002d11P040000;@4700<0000N00L0000F1<T1b09X0@P21@000081\n0@0000@0000]0@X01@0000T200000Ph0000b2VT1>@8200@0209X0LL2b@5C<C80:P040000;@4900d0\n000b2VT1U@8100@0209X0LL2b@4P<B80100002L1ool70000o0800?ooo`0000@0000]0@/020000?X2\n0006000000000P@0000]0@`01`0001/4]`7C0G/1UP440000;@4600@0003`0@/0100002d11`040000\nl04<00L0003l0P00oooo0000100002d12`080000nP8000H000000002100002d1300700006`Bg0C<3\nN`7g0P@0000]0@H010000?012`040000;@4700@0003`0@`0400002H63`0F0?ooool00>l3000[0@00\nR`D000L200070000o0800?ooo`0000@0000]0@/020000?X20006000000000P@0000]0@`01`0001/4\n209_1B/13P@40000;@4600@0003`0@/0100002d11`040000l04<00@0000]0@80100002d10`070000\n6`C;0B85J05Q10@0000]0@H0100002d11`0300007P0700005PC90B45J05Q10D000020@4000040000\n;@4:00D000090P00008>0000<PYY0I840P040644J04P1LT1Dc8b02X0100002d12@0=0000<PYY0Nh4\n0@040644J04P1LT1838R00@0000W0Ooo1`000?`2003oool000040000;@4;00P0003j0P001P000000\n00840000;@4<00L0000K1;L1;0Ak0O03100002d11P040000l04;00@0000]0@L010000?0130070000\no0800?ooo`0000@0000]0@/020000?X20006000000000P@0000]0@`01`0001/4]`6=1G/1D0D40000\n;@4600@0003`0@/0100002d11`040000l04<0100000V1Pl05P3ooooo003/2000P04008h9002c0@00\n20000?X200060000000000@0000]0@/0100002d10P0800009@<20?08VP5Q2IT1100002d10`040000\nl04;00L0003l0P0000000000100002d12`0:000090<305l9[`6:2IP1GPV40@@0000]0@L0100002d1\n1P040000l04;00P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00QPD007l100161P00/P4000P0\n003j0P001P00000000040000;@4;00@0000]0@80200002D30P2:1IX16@JH0@@0000]0@<010000?01\n2`070000o0800000000000@0000]0@/02P0002@30`0G1Zh1@PJH0AH6P`440000;@4700@0000]0@H0\n10000?012`0800009PH?00H0ooooo`40400002H63`0F0?ooool002h3001o0@00l`<00;8100080000\nnP8000H000000000100002d12`040000;@4200P0000U0`80<P>J0LH3V0440000;@4300@0003`0@/0\n1`000?`20000000000040000;@4;00X0000T0`<0a0>^0Nh3V0730h<1100002d11`040000;@4600@0\n003`0@/0200002H63`060?ooool10100000V1Pl05P3ooooo003oooooP0400:40002c0@0020000?X2\n00060000000000@0000]0@/0100002d10P0800009@<200<0VP5d09T1100002d10`040000l04;00L0\n003l0P0000000000100002d12`0:000090<30780[`6L09P1L@240@@0000]0@L0100002d11P040000\nl04;00P0000V1Pl01P3ooooo0@0@00009PH?01H0ooooo`00h@L007l1002]2000/P4000P0003j0P00\n1P00000000040000;@4;00@0000]0@80200002D30P3U1iX1P0RH0@@0000]0@<010000?012`070000\no0800000000000@0000]0@/02P0002@30`1n2:h1Z0RH0Gd8P`440000;@4700@0000]0@H010000?01\n2`0800009PH?00H0ooooo`40100002d10P040000;@4300L0000K1:<2G`@k0TP1100002d11P040000\n;@4700<0000N00L0000F1:82G`@k0TP11@0000810@0001`0003k0[go00000000T040000014008T5b\nJF5/0?Eg@00001d92[FnH_Egaf;eM`4000000300100002d12`0500002@800002;P00038:?09]0AL0\n10180C/2GPBR0V=_KViUHg@XDc4^KgEdL2aC<RiYKW0Y02809@0U02D09@0R01<05@0]02D04`0U02@0\n4`0U01<0;@0T01<03`0U02D05P0L0000n`:mo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0\n_V;eMlMRmGL10000000`00@0000]0@`03@00038:?08i104010180C/2GPBR0R1[7@0400009`7oo`@0\n000]0@80100002d10`0700006`BS0T`8>`8e1@@0000]0@H0100002d11`0300007P0700005PBR0T`8\n>`8e1@D000020@4000040000;@4;00D000090P00008^0000<PXl0UX55`0403D5>`9;2:82Hfm^KVES\nM2QC<Ri_MGA`;5<c;VU^L2T08P0U02D09@0U02804`0E02d09@0C02D0900C02D04`0]02@04`0?02D0\n9@0F00@0000]0@`03@00038:?08V2040100e1C/2B`RR0R1[7@0400009`7ooa00000V1Pl05P3ooooo\n000^0`00Y04009/3000i0P0020000?X200060000000000@0000]0@d0100002d10P0800009@<209H3\nZ04b0c@2100002d11`040000l04=00@0000]0@H0200002H63`060?ooool10100000V1Pl05P3ooooo\n003?1@00XP4003@6000_0P0020000?X200060000000000@0000]0@d0100002d10P0800009@<20=<5\nYP4_1RX2100002d11`040000l04=00@0000]0@H0200002H63`060?ooool100@0000]0@@010000?01\n1@040000l04800@0003`0@T010000?012P040000l04;00@0003`0@`01`000?`2003oool000040000\n;@4500P0003j0P000000000000040000;@4800@0000W0Ooo200002H63`060?ooool100@0000W0Ooo\n100002d10003000000000140000<0000200000/0000@0000^@4008X00009000040000;T1002:0000\n2P00010000000000000000T0000@0000Q`400880001B0000L0400040000@00001`00000000000000\n_080000000010P8RD`1i07<0M01U06d0000000000000000000000000000000000000000000000000\n00000000000000000000000000000P00000C0;0=601h0A<0BP@0052fo7LF]Oag;KGlM`0000200000\n^:XG00004`0X31<07P000:P55P2Lla80N04C07P14`1h0A<0N04C0?oooomXmA80@0HC02P<4`000000\n000001l98FK0:HT190000?CMQ_jT5X`1000C07P14`04m180000004064`1`35X0V=]I0<00003mf?oo\nl=SoooCHool0080o10000?:2ool0000081/300004`1h0A<0N04C07P14`232@00D;KlMaJeo7L]]Oag\n0000000000090000^:XG0:Sd4P1lUQL0`/3dM`40001TMP08000002D0000<00000@000580001`0@00\n0P000?3oool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640\nKP0000000000000000000000000000000000000000000000000300004`1h0A<0N04C07P14`232@00\nD;KlMaJeo7L]]Oag0000000000090000^:XG0:Sd4P1lUQL0`/3dM`40001TMP08000007P14`1h0A<0\nooooofSe4P101Q<0:0`C0000000000007`TQI/0YR@4T0000m=f6oZ@FS04001<0N04C00Cd4P000000\n@0HC070<FP2HfeT0`0000?gHooo`f?oom=Soo`00P3l40000lX;oo`00000P6`<0000C07P14`1h0A<0\nN04C08<9001@]_ag5[GlMbfeo7LU0000^:XG08Sd4P0^2@00E<3dM`40000I0;01;PT:I6Af00P00000\n9@0000`0000200004P0000`000010000600000`0000000028@0000P0000N00006000000000000000\nQ`400880000Q0000200001H0000<0000000007P0000@000000000000000H000030000000000I0000\n30000?ooo`0U0000300000D0080U0000300000P0080:000040000000000000002@000100002<2@00\n;@<000T0000@0000S0T002d3001B0000L04000<0000D00002@00000000000000_080000000040P8R\nD`1i07<0M01U06d00000000000000000000000000000000000000000000000000000000000000000\n000000000`0001<0N04C07P14`1h0A<0P`T0052fo7LF]Oag;KGlMbD0002hZQL0R?@B02h9001D`?Ag\n0@0001T0/04^2@YTI7H02000001h0A<0N04C0?oooomXmA80@0HC02P<4`000000000001l98FK0:HT1\n90000?CMQ_jT5X`1000C07P14`04m180000004064`1`35X0V=]I0<00003mf?ool=SoooCHool0080o\n42;dMlC`oGl0h?eo0@00000000000000000009T80000@000V@P41P40001Tm1809@000;RZ5`090000\n^:XG0:Sd4P3^UaL0`/3dM`40001TMP08000002D0000<00000`000180000<00000@000580001`0@00\n10000:goool0000000000000002@0@00000000A0019D06T0K@1U07<0801>06D0M`0P0580K`1]0640\nKP00000000000000000000000000000000000000000000000000000000000000000009T80000@000\nV@P41P40001Tm1809@000;RZ5`090000^:XG0:Sd4P3^UaL0`/3dM`40001TMP08000007P14`1h0A<0\nooooofSe4P101Q<0:0`C0000000000007`TQI/0YR@4T0000m=f6oZ@FS04001<0N04C00Cd4P000000\n@0HC070<FP2HfeT0`0000?gHooo`f?oom=Soo`00P3l@8_Aga?3mO`3PoGl100000000000000000000\nV@P00010002I20@60@0006Cd4P0U0000^:XG08Sd4P3E2000E<3dM`40000I0;01e@P:IFAf00P00000\n9@0000`000040000600000`0000000022P00010000000000000005@0001D00000000000000060000\n3`000040003HE8M06L^7@000000100000@0004`00004000000000000002<2@00;@<00500000P0000\n9@0002D0000<00001@00P2D0000<00002000P2/0000H0000[0P002T0003U2000J@0002L0000H0000\n1@000000003oool0000002D0000<00001@0002H0000L00001P0000000000000000000000000U0000\n300000H0000Q0000200001h0000H0000[0P002T0003Z2000K@000180000<00000@000580001`0@00\n1`000:goool0000000000000002@0@00000000A002910780J@1Q06`0000000000000000000000000\n0000000000000000000000000000000000000000000000000000000000000000000009T80000@000\nV@P41P40001Tm1809@000;RZ5`28m180c?<B0000003U>?Qg000C0?1K5`000000Z?<B08P64`1Lm180\nUB_hMb0in7OoooooK?@B042go7OX1Q<042;dMlC`oGl0h?eo0@00000000000000V@P00010002I20@7\n0@0001cd4P3`<OAgV@P41mC95`010000V@P41`@7000@8_Aga?3mO`3PoGl100000000000000000000\nV@P00010002I20@80@0006Cd4P3`<OAgV@P421l98FJI20@8000000@80020m180T=;dMfAf00P00000\n9@0000`000070000E0000600002A0@001`0009/1000B00000@000=QDQd0IbhM0[0P0028000030000\nC00000@0002/2000:@000>T8001]0000E0000200800P00005`0001L0000H0000DP00070100080000\n]Oooo`0000000000000009010000000014004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^0000\n0000000000000000000000000000000000000000000000000000000000000000V@P00010002I20@8\n0@0006Cd4P3`<OAgV@P421l98FK<la8000000>Dhn7L001<0:5`N0000002Xla80R0HC05cd4P2E:oQg\n83WhMooooom/m180@;OlMaP74`0`G1h0<5`N07BI5`0`G1h000000000002I2000040009T810L10000\n7?@B0?0am7L001<0e<TG0040000XG1h010L0000Rm7L300000>3mO`000000000000000000000001<0\n0`00001L7P0H0000I?@B004000030000g?<B0600002Tm180UB_hMaPfn7OoooooI7H02000000U0000\n300000P0001D0000E000000000000000ooooooooool10000f5B7@1W;Qd3b2000:P000040001<0000\n10000:`8000Y0000j@P006d0001@000080000240000R000030000?oooolU0000300000D0080U0000\n300000P0080[000060000080003V0P00>`0002D3000U0000300000D0000U0000300000H0000Q0000\n200001h0000H00000P000>H200100000:P<00180000<00000@0002D0000<00001`0001P0000<0000\n00000U@0001P0000000007h0000:0000R@000040003HE8M06L^7@080003O0P000`0004`000040000\n0P000>H2000o0000:P<005@0000P0200800001L0000G0000600002D0000<0000200005@0001D0000\n00000000003oooooooooo`40003HE8M06L^7@4P0003W0P000@0004`0000400000P000>H2000o0000\n:P<00500000P00008@000280000<0000ooooobH0000L00002@0000000006000000000000000U0000\n300000T0000U0000300000D0081G0000900002P000150000@@0004D000020000g`2I0FT1V@4U0000\n300000P0080X0000300000T0000W0000600000T00000000000000000000U0000300000T0001F0000\n:000044000120000B@0004T000030000I`6_0I81VP5W0H@19@0000`0000600009@0000`000050000\n:00000`0000900009@0000`0000500209@0000`000080020:`0001P0001<2@00ooooohD9000n0000\n9@0000`0000500009@0000`0000600008@0000P0000N0000600004`9003oooooRPT004<0000B0000\n30000040000U0000300000L0000H000030000000009D0000H0000:d100000000]`4000X000010000\nf5B7@1W;Qd1<2@00n?ooo`<0001<0000100004`9003oooooR@T004<0001D0000800P0200000G0000\n5`0001P0000U0000300000P0001D0000E000000000000000ooooooooool10000f5B7@1W;Qd2B2@00\n00000040001<0000100004`9003oooooR@T004<0001@000080000240000R000030000?oooolU0000\n300000D0080U0000300000P0080[0000600001H3002=0000NPH00>l0000U0000300000D0000U0000\n300000H0000Q0000200001h0000H00005`<008d000201P00m0000180000<00000@0002D0000<0000\n1`0001P0000<000000000U@000300000V@0001P0000Q0@009`000040003HE8M06L^7@4l3002?0000\n4`0004`0000400005`<008d0001o1P00m00007@0001D06P0LP1U06D0D`1U0780MP1U0780D01Y0700\nI@1/06T0KP1U0000<`0002h0000L0000;P0002h0000h0000;P0001`0000Z0000;P0001`0000g0000\n4`0002h0000^00004`000180000_0000;P0002D0000<0000100005@0001D00008P4001P0000X0@00\n9`000040003HE8M06L^7@4H6002@00000@0004`0000400005`<008d0001o1P00m0000500000P0000\n9P000280000<0000ooooobD0000<00001@00P2H0000L00002@0000000006000000000000008U0000\n300000T0000[000060000<40001b0000b`P00;/2000U0000300000D0000U0000300000H0000X0000\n300000T0000W0000600000T000000000oooo0000000U0000300000T0000V0000700000X000000000\n1P000000000000029@0000`0000:0000:`0001P0001W1P00:`400<8700020P009@0000`000050000\n:00000`0000900009@0000`000060000:00000`0000:00009@0000`0000500209@0000`000080020\n:`0001P0002k1P00J04007H700350@009@0000`0000500009@0000`0000600008@0000P0000N0000\n60000;X6001X0@00NPL00<T1000B000030000040001B0000L04000X0002eoooo0000000000000000\nT04000000004@00R@@1b06T0H@1/0000000000000000000000000000000000000000000000000000\n000000000000000000000000601H3QP0LP1@06T0L01U06`0J@1^06D07P0H0000I?@B004000030000\ng?<B0<cc4P000000iCShM`004`3`FaL000000:Sc4P281Q<0G?@B09D[n7L001<01000003d4P10]oag\nj0HC005K5`0@8_Ag42;dMlC`oGl0h?eo0000000000000000W0P00010002L20B^0@0002Cd4P3`<OAg\nW0P4[Ql98FH1000042;dMlC`oGl0h?eo0@00000000000000000009T80000@000V@P44P40001Tm180\nl37dMiT8118O2B5VV@P44P0000044P00P?@B093Bm7MTMP08000002D0000<00002P0001P0000<0000\n00000U@0001H0000@04003d0001@0@00C0000040003HE8M06L^7@>/6001Y0@000P0004`000040000\n^PH006P1001i1`00b@400500001C03<0<P0002X0000U0000300000P0001D0000E0000501000m0000\nEP4004/000010000f5B7@1W;Qd171`00J@400040001<000010000;X6001X0@00N@L00<T1001@0000\n80000280000R000030000?oooolW0000600000T000000000oooo0000000U0000300000T0000V0000\n700000/0000000001P000000000000029@0000`0000;0000:`0001P000191P00N`400806002a0@00\n9@0000`000050000:00000`0000900009@0000`000060000:00000`0000;00009`0001P0000;0000\n00000?ooo`0000009@0000`0000;00009P0001`000090000000000H00000000000000RD0000<0000\n2@0002/0000H0000Z@L007/1003Q1`00/@4002D0000<00001@0002P0000<00002`0002D0000<0000\n1P0002P0000<00002@0002L0000H00002@000000003oool0000002D0000<00002@0002H0000L0000\n2`0000000006000000000000008U0000300000/0000[000060000:l8001k0@00iPP00;81000U0000\n300000D0000X0000300000T0000U0000300000H0000X0000300000/0000W0000600000/000000000\noooo0000000U0000300000/0000V0000700000T0000000001P000000000000029@0000`000090000\n:`0001P0002S0000N`400=/0002b0@009@0000`000050000:00000`0000;00009@0000`000060000\n:00000`0000900009`0001P00009000000000?ooo`0000009@0000`0000900009P0001`0000;0000\n000000H00000000000000RD0000<00002`0002/0000H0000]04002/1000A0`000P8002D0000<0000\n1@0002P0000<00002@0002D0000<00001P0002P0000<00002`0002D0000<00001@00P2D0000<0000\n2000P2/0000H0000208006P100330P00a@4002D0000<00001@0002D0000<00001P00024000080000\n7P0001P000080P00J0400<P200390@004P0000`0000100009@0000`0000:0000600000`000000002\nE00005P0001W0000?@0007L0001<00000@000=QDQd0IbhM0>@8006T100020000C00000@000080P00\nJ0400<L200390@00D00005<0<@0b0000:P0002D0000<0000200005@0001D0000M`0003d0001m0000\nB`000040003HE8M06L^7@9D2001Y0@000@0004`000040000208006P100370P00b@400500000P0000\n8P000280000<0000ooooobL0000H00002`000000003oool0000002D0000<00002`0002H0000L0000\n2@0000000006000000000000008U0000300000T0000[0000600009H1001k0@00c@400;41000U0000\n300000D0000X0000300000/0000U0000300000H0000X0000300000T0000W0000600000T000000000\noooo0000000U0000300000T0000V0000700000/0000000001P000000000000029@0000`0000;0000\n:`0001P0003g0P00N`4002h3002a0@009@0000`000050000:00000`0000900009@0000`000060000\n:00000`0000;00009`0001P0000;000000000?ooo`0000009@0000`0000;00009P0001`000090000\n000000H00000000000000RD0000<00002@0002/0000H00003P@002/1001Y1@000P8002D0000<0000\n1@0002P0000<00002`0002D0000<00001P0002P0000<00002@0002D0000<00001@00P2D0000<0000\n2000P2/0000H0000H@@006P1000M1@00a@4002D0000<00001@0002D0000<00001P00024000080000\n7P0001P0001Q1000J040024500390@004P0000`0000100009@0000`0000:0000600000`000000002\nE00005P0003C0000?@000><0001<00000@000=QDQd0IbhM0TP@006T100020000C00000@0001Q1000\nJ040020500390@00D00005<0<P0b0000:P0002D0000<0000200005@0001D0000i00003d0003Z0000\nB`000040003HE8M06L^7@>h4001Y0@000@0004`000040000H@@006P1000P1@00b@400500000P0000\n8P000280000<0000ooooobL0000H00002@000000003oool0000002D0000<00002@0002H0000L0000\n2`0000000006000000000000008U0000300000/0000[000060000?03001k0@009P@00;41000U0000\n300000D0000X0000300000T0000U0000300000H0000X0000300000/0000W0000600000/000000000\noooo0000000U0000300000/0000V0000700000T0000000001P000000000000029@0000`000090000\n:`0001P0001@1@00N`4008P5002a0@009@0000`000050000:00000`0000;00009@0000`000060000\n:00000`0000900009P0001`000090000000000H000000000000002D0000<00002@0002D0000<0000\n1@00P5L0000T0000W@4004D0002a0@00AP000080003`29X1H@VI0BD0000<00002000P2P0000<0000\n2@0002L0000H00002@00000000000000000002D0000<00002@0005H0000X0000/@400480002h0@00\nB@0000<0001O2Jl1RPVH0Eh9Q04U0000300000H0000U0000300000D0000X0000300000T0000V0000\n700000T0000000001P000000000000009@0000`0000900009@0000`000050020E`0002@000000@00\nA@0001X1001600000P0008X5VP4I1YP19@0000`000080020:00000`0000900009`0001P000090000\n00000000000000009@0000`000090000EP0002P0000I0@00@P000241001900000`0001L6[P521YP1\n5PJ30BD0000<00001P0002D0000<00001@0002P0000<00002@0002H0000L00002@00000000060000\n00000000000U0000300000T0000U0000300000D0081G0000900009@000150000[P0004H000020000\n<P>J0LH3V04U0000300000P0080X0000300000T0000W0000600000T00000000000000000000U0000\n300000T0001F0000:0000:h000120000]P0004T000030000a0>^0Nh3V0730h<19@0000`000060000\n9@0000`000050000:00000`0000900009P0001`000090000000000H000000000000002D0000<0000\n2@0002D0000<00001@00P5L0000T00000@0004D0000E0000AP000080000309X1M02I0BD0000<0000\n2000P2P0000<00002@0002L0000H00002@00000000000000000002D0000<00002@0005H0000X0000\n50000480000L0000B@0000<0001b0:l1W02H0G40Q04U0000300000H0000U0000300000D0000X0000\n300000T0000V0000700000T0000000001P000000000000009@0000`0000900009@0000`000050020\nE`0002@0001]0@00A@0008T1001600000P000>D7VP6029P19@0000`000080020:00000`000090000\n9`0001P00009000000000000000000009@0000`000090000EP0002P000280@00@P00090100190000\n0`0007h8[P6X29P1O@R30BD0000<00001P0002D0000<00001@0002P0000<00002@0002D0000<0000\n1@00P2D0000<00002000P2/0000H0000B04003/2001J1000W@8002D0000<00001@0002D0000<0000\n1P000240000800007P0001P000180@00>`8005l4002R0P004P0000`000010000DP00070100090000\n_Oooo`0000000000000009010000000014008T40LP1Y0640K0000000000000000000000000000000\n0000000000000000000000000000000000000000000001P0>0hH000000000000V@P00010002I20@B\n0@0006Cd4P3`<OAgV@P44Ql98FK<la8000000>Dhn7L001<0b0hH0000002Xla80R0HC05cd4P2E:oQg\n000C00@00000m180@;OlMdP74`013QP00`0006Sc4P000000<?@B0000n7LH=_Qgoooood3d4P22LnQg\n000C0000000h3QP0o@P@63P>600PP?Mg11L0010Rm7O4l?eo0>3mO`400000000000000000002L2000\n040009`81;D10000I?@B0?0am7NL20Be7`TQIY`81;D000001;D0083d4P2@d_AgI7H02000000U0000\n300000T0000H000030000000009D0000f0000480001Q0000``0006h000010000f5B7@1W;Qd1]0@00\n?08001L0001<0000100004P1000k0P00GP@00:82001l0000H`1_06h0KP1U06<0M00X05<0<@0^06l0\nM@1d0700;01C0380;P1Y06h0L00Y00008P0002D0000U00009@0002D0000R00004`0001D0000]0000\n9@0001<0000U0000900001<0000U00004`0002d0000T00004`0000l0000U00009@0001H0001B0000\nL04000/0002moooo0000000000000000T04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0\nK@1Q06h0000000000000000000000000000000000000000000000000:01C0340;P1_07D0M01`02`0\nD`0b02h0J@1^0700:@0B0?0am7NL20Be7`TQI/cc4P000000iCShM`004`20XAH000000:Sc4P281Q<0\nG?@B09D[n7LP>OQgooooofcd4P10]oagn0PC08RQ5P28XAH0/ZLG08RQ5P0`m180003hMaPfn7Oooooo\n@?@B089cj7L001<0000000004`3m210H>0hH0220mgL45`0002;dM`d00000h?eo0@00000000000000\n000000004`0=00000:4F06P0001Tm1800@0001L0003Lla80f0000:Cd4P2E:oQg63KhMooooomTMP08\n000002D0000<00002`0005@0001D0000``00064000380000KP000040003HE8M06L^7@3T4000l0P00\n0@0004`000040000B04003/2001N1000XP800500000P00007@000280000<0000ooooobD0000<0000\n1@00P2D0000<00002000P2/0000H0000=@D003/200162000W@8002D0000<00001@0002D0000<0000\n1P000240000800007P0001P0000e1@00>`8004`8002R0P004P0000`0000100009@0000`000090000\n600000`000000002E0000=P0003g0000H@0007P1001^00000@000=QDQd0IbhM0FPD003`2000G0000\nC00000@0000e1@00>`8004/8002R0P00O00006<0K`1^06h0I@1S07@0:01C0380;P1_07D0M01`02`0\nD`0c02h0J@1^0700:@000280000U00009@0002D0000U00008P0001<0000E0000;@0002D0000C0000\n9@0002@0000C00009@0001<0000]0000900001<0000?00009@0002D0000F00009@0000`0000;0000\nE00005@0001h0@00H@0007d1001^00000@000=QDQd0IbhM09PP003`200010000C00000@0000e1@00\n>`8004/8002R0P00D0000200000M00008P0000`0003ooooo9P0001`0000<0000000000H000000000\n000002D0000<0000300002D0000<00001@00P5L0000T0000U00004P0002V0000H0000080002F0jP1\n<P<d0RD0000<00001P0002P0000<0000300002D0000<00001@0002H0000L00003000000000060000\n00000000000U0000300000`0000U0000300000D0081G0000900000d1001800007P4005h000020000\nd`FV0Bl6:P8U0000300000H0000X0000300000`0000U0000300000D0000U0000300000<0000X0000\n300000@0000X0000300000L0000X0000300000P0000X0000300000X0000X0000300000T0000X0000\n300000/0000W0000600000/000000000oooo0000000U0000300000/0000V0000700000T000000000\n00000000000000009@0000`0000900008P0000`0003ooooo8P0000`0003ooooo9@0000`000010000\n9@0000`0000700209@0000`000000020<00000`0000?00209@0000`0000=0020B`00010000000000\n1@0002P0000<00000@0002P0000<00000P0002P0000<00000`0002P0000<00002`0002P0000<0000\n1@0002P0000<00001P0002P0000<00002@0000h0000D000000000100000D0000\n"], "Graphics", Rule[ImageSize, List[440, 137]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[List[StyleBox["Figure ??:", Rule[FontFamily, "Courier New"], Rule[FontWeight, "Bold"]], StyleBox[" Coupled model consisting of three servers S1, S2, and S3, connected in a pipeline.", Rule[FontFamily, "Courier New"]]]], "Text"], Cell["The coupled pipelined DEVS model class represented in Modelica can be described as follows:", "Text"], Cell["model ThreeServerPipeline\n  input  EventPort   extInSignal;\n  output EventPort   outSignal;\n  SimpleDEVSServer   S1(mean=2.0);\n  SimpleDEVSServer   S2(mean=2.5);\n  SimpleDEVSServer   S3(mean=1.5);\nequation\n   connect(extInSignal, S1.inp);\n   connect(S1.outp, S2.inp);\n   connect(S2.outp, S3.inp);\n   connect(S3.outp, outSignal);\nend ThreeServerPipeline;", "ModelicaInput"], Cell["", "Text"], Cell["model testPipeline\n   ThreeServerPipeline  pipeLine;\n   GenerateJobEvents    jobgenerator(period=4);\nequation\n  connect(jobgenerator.outp, pipeLine.extInput);\nend testPipeline;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Simuleras????????", "Subsection"], Cell[TextData[List[StyleBox["Diagram ??:", Rule[FontFamily, "Courier"], Rule[FontWeight, "Bold"]], StyleBox[" Signals for the testPipeline model including a ThreeServerPipeline containing the servers S1, S2, and S3.", Rule[FontFamily, "Courier"]]]], "Text"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 941]]], Rule[AutoGeneratedPackage, None], Rule[WindowSize, List[875, 907]], Rule[WindowMargins, List[List[27, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]