List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Expressing Event Behavior in Modelica", "Title"], Cell[CellGroupData[List[Cell["Expressing Event Behavior in Modelica", "Section"], Cell[TextData[List["The conditional equations associated with an event become active when the ", StyleBox["condition", Rule[FontSlant, "Italic"]], " of the equations switches from the value false and true. There are basically two groups of conditional equation constructs in Modelica: ", ButtonBox["if-equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Equations"], "IfEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], " and ", ButtonBox["when-equations", RuleDelayed[ButtonData, List[FrontEnd`FileName[List[ParentDirectory[], "Equations"], "WhenEq.nb", Rule[CharacterEncoding, "WindowsANSI"]], None]], Rule[ButtonStyle, "Hyperlink"]], ". In the Diode example below different equations are specified."]], "Text"], Cell[CellGroupData[List[Cell["Electrical Units", "Subsection"], Cell["type Voltage = Real(unit = \"V\");", "ModelicaInput"], Cell["", "Text"], Cell["type Current = Real(unit = \"A\");", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Electrical Connectors", "Subsection"], Cell["connector Pin \t\t\t\t\t\"Pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend Pin;  \t\t\t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["connector PositivePin \t\t\t\"Positive pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend PositivePin;  \t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"], Cell["", "Text"], Cell["connector NegativePin \t\t\t\"Negative pin of an electrical component\"\n   Voltage v \t\t\t\t\t\"Potential at the pin\";\n   flow Current i \t\t\t\t\"Current flowing into the pin\";\nend NegativePin;  \t\t\t\t//From Modelica.Electrical.Analog.Interfaces", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Electrical Components", "Subsection"], Cell["partial model TwoPin\t\t\t\t\t// Same as OnePort in Modelica.Electrical.Analog.Interfaces\n\t\t\t\t\t\t\t\t\t\t\"Component with two electrical pins p and n and current i from p to n\"\n  Voltage v\t\t\t\t\t\t\t\t\"Voltage drop between the two pins (= p.v - n.v)\";\n  Current i\t\t\t\t\t\t\t\t\"Current flowing from pin p to pin n\";\n  PositivePin p;\n  NegativePin n;\nequation\n  v = p.v - n.v;\n  0 = p.i + n.i;\n  i = p.i;\nend TwoPin;\t", "ModelicaInput"]], Closed]], Cell[CellGroupData[List[Cell["Diode", "Subsection"], Cell[TextData[List["The ", StyleBox["if", Rule[FontFamily, "Courier"]], "-equation in the ideal ", StyleBox["diode", Rule[FontFamily, "Courier"]], " example below, specifies different equations for the variable ", StyleBox["v", Rule[FontFamily, "Courier"]], " in two different operating regions: the", StyleBox[" v = s", Rule[FontFamily, "Courier"]], " in the region ", StyleBox["s < 0", Rule[FontFamily, "Courier"]], " and the equation ", StyleBox["v = 0", Rule[FontFamily, "Courier"]], " in the region ", StyleBox["s >= 0", Rule[FontFamily, "Courier"]], ".\n"]], "Text"], Cell["model Diode \t\t\t\t\t\"Ideal diode\"\n  extends TwoPin;\n  Real s;\n  Boolean off;\nequation \n  off = s < 0;\n  if off then                 \t// conditional if-equation\n    v = s; \n  else\n    v = 0;\n    end if;\n    i = if off then 0 else s;   // equation with conditional expression\nend Diode;", "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[913, 924]], Rule[WindowMargins, List[List[3, Automatic], List[Automatic, 0]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]