List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Using Event Priority to Avoid Erroneous Multiple Definitions", "Title"], Cell[CellGroupData[List[Cell["Priority in When-Statements", "Section"], Cell[TextData[List["Two separate ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equations or ", StyleBox["when-", Rule[FontFamily, "Courier"]], "statements in different algorithm sections may not define the same variable. Without this rule a conflict between the equations will occur if both conditions would become true at the same time instant. This would happen for the erroneous model ", StyleBox["WhenConflictX", Rule[FontFamily, "Courier"]], " below if we would have the same condition, e.g. ", StyleBox["time >= 1", Rule[FontFamily, "Courier"]], ", in both ", StyleBox["when", Rule[FontFamily, "Courier"]], "-equations since there are two equations:  x = pre(x) + 1.5 and x = pre(x) + 1 that define the same variable x.\n"]], "Text"], Cell[TextData[List["model WhenConflictX   \t// ", StyleBox["Erroneous model: two equations define x", Rule[FontColor, RGBColor[1, 0, 0]]], "\n   discrete Real x;\nequation\n  when time >= 2 then   // When A: Increase x by 1.5 at time >= 2\n    x = pre(x) + 1.5;\n  end when;\n  when time >= 1 then   // When B: Increase x by 1 at time >= 1\n    x = pre(x) + 1;\n  end when;\nend WhenConflictX;"]], "ModelicaInput"], Cell[CellGroupData[List[Cell["Eliminating the double definition", "Subsection"], Cell[TextData[List["The multiple assignment conflict in the above example can be avoided by giving a higher priority to one of the defining equations through the ", StyleBox["elsewhen", Rule[FontFamily, "Courier"]], " construct, as in the same example in converted form below. We have put both equations within the same ", StyleBox["when-", Rule[FontFamily, "Courier"]], "equation and ordered the conditions in ", StyleBox["decreasing", Rule[FontSlant, "Italic"]], " priority.\n"]], "Text"], Cell[TextData[List["model WhenPriorityX\n   discrete Real x;\nequation\n  when time >= 2 then       // ", StyleBox["Higher priority", Rule[FontColor, RGBColor[0, 0, 1]]], "\n    x = pre(x) + 1.5;\n  elsewhen time >= 1 then   // ", StyleBox["Lower priority", Rule[FontColor, RGBColor[0, 0, 1]]], "\n    x = pre(x) + 1;\n  end when;\nend WhenPriorityX;"]], "ModelicaInput"], Cell["", "Text"], Cell[GraphicsData["Metafile", "CF5dJ6E]HGAYHf4PEfU^I6mgLb15CDHPAVmbKF5d0@00047P0@0006`0000:00007`0004h1002h0000\n00000000001b8@005Q800215CDH00040h44003P1000>0000000000000000000000@00005003`0000\n@0400000000000000000082Y0`00hP@0AP000=`E003@5@00AdA9@`4008000`00==IV/000002h5@00\n0@090003g0X000l070000000500002H63`0N0?ooool401@0001GKg9T3P1=JF=bKg=_IW@PEfmbI0D0\n000;0P000005000030:_04@170000?/240070000002l0P0000010P8RDgUcM6E]000000X000040000\n003ooooo0@000000<0040000;@4001`0003k0_3o00000000T040000014004UAYKFEc84iUMb1BKfeQ\nKP2nH_Egaf;eM`4000000300100002d10@0500000P4100001@0000T200000P<0000N00L0000F1:l0\nA0400000400002H63`0F0?ooool00?ooooooooooA@400;00000300007P050000;P4000001@0000X2\n000000D000090P00000500000@;oool01`000?`20@00000000040000;@4200P0003j0PD00@000000\n00040000;@4300@000030@P01@0000/2000000D0000<0TH4j@LD00009PH?01h0ooooo`@0500005M_\nLV@>04eYHg9_LfmVM21GKg9T1@0000`2APCY1a`0003k0Q@02@000000_080000010828U=iLgAUK@1g\n@0000;@42W^nH_Egaf;eM`4000000300100002d1100500000P41000070000?/2Y?l00000002@0@00\n0004@00BE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4500D000090P0000850000\n2`8000003@00038:L0@0004010000000j@M6121U:@040000;@4200@0000]0@<01`0001/4<`Af0>d3\n=`070000o0800?ooo`0000@0000]0@H020000?X200000000000000@0000]0@L00`0001h01`0001H4\n<@Ae0>d3=`0L0000n`:]o`0000000901000000A00291LVUQK03eMd00002:10Z3_V;eMlMRmGL10000\n000`00@0000]0@P01@0000810@0000@0000]0@P04000038:i`<g00<0100g0>d3M00a120P804G01L0\n5`0L0000n`:eo`0000000901000000A0019DJFeULb1>IGLPDVm]HFh0_V;eMlMRmGL10000000`00@0\n000]0@T03@00038:kP=l0040100g0>d3M00a12028P0400009`7oo`@0000]0@80100002d10`070000\n6`@M0J@1``1O0@@0000]0@H0100002d11`0300007P0700005P@K0J<1``1O0@D000020@40000L0000\nn`:eo`0000000901000000A00291LVUQK03eMd00002c10XF_V;eMlMRmGL10000000`00@0000]0@X0\n1@0000T200000Pd0000b2/@0G`4100@0G`730:816`5h02D0100002d12@0=0000<P[408@10@0405l1\n``2R0A/1800S00@0000W0Ooo400002H63`0F0?ooool000`1002[0`00@@L00?H300080000nP8000H0\n00000000100002d12`040000;@4200P0000U0`80407@0od6d0<40000;@4300@0003`0@/01`000?`2\n0000000000040000;@4;00X0000T0`<0n`Ka0c`7d0?k1[03100002d11`040000;@4600@0003`0@/0\n200002H63`060?ooool100@0000]0@80100002d10`0700006`A81307k`>51P@0000]0@H0100002d1\n1`0300007P0700005PA712l7k`>51PD000020@4000040000;@4:00D000090P00008A0000<P[`0hD6\n100408D6k`<^1dL4M6U]IAD04@0o02X0100002d12@0=0000<P[`0a@70@0408D6k`<^1dL4800Q00@0\n000W0Ooo400002H63`0F0?ooool00<l200060P00e0800:T300040000;@4300L0003l0P0000000000\n100002d12`0500001P420000500002@3203@0ZH3d@:W0m42Y`?B0ZH3dP:N0m42W@?A0Yd3d0:N0a@0\n000T0`P0d0:H0m42V@?A0YT3dP:H0m82T0?A0Xl3d@:?0m02T0<D000090<80=02RP?A0X/3d@:;0m82\nRP?B0X83d@:10m42P@?@0X83500002@3203@0W`3d@9m0m42O@?B0W`3dP9d0m42L`?A0W<3d09d0a@0\n000T0`P0d09^0m42K`?A0Vl3dP9^0m82IP?A0VD3d@9U0m02IP<D000090<80=02H0?A0V43d@9Q0m82\nH0?B0UP3d@9G0m42E`?@0UP3500002@3203@0U83d@9C0m42D`?B0U83dP9:0m42B@?A0TT3d09:0a@0\n000T0`P0d0940m42A@?A0TD3dP940m82?0?A0S/3d@8k0m02?0<D000090<80=02=P?A0SL3d@8g0m82\n=P?B0Rh3d@8]0m42;@?@0Rh3500002@3203@0RP3d@8Y0m42:@?B0RP3dP8P0m427`?A0Ql3d08P0a@0\n000T0`P0d08J0m426`?A0Q/3dP8J0m824P?A0Q43d@8A0m024P<D000090<80=0230?A0Pd3d@8=0m82\n30?B0P@3d@830m420`?@0P@3500002@3203@0_h2d@;o0]42o`;B0_h2dP;f0]42m@;A0_D2d0;f0Q@0\n000T0`P0d0;`0]42l@;A0_42dP;`0]82j0;A0^L2d@;W0]02j08D000090<80=02hP;A0^<2d@;S0]82\nhP;B0]X2d@;I0]42f@;@0]X2500002@3203@0]@2d@;E0]42e@;B0]@2dP;<0]42b`;A0//2d0;<0Q@0\n000T0`P0d0;60]42a`;A0/L2dP;60]82_P;A0[d2d@:m0]02_P8D000090<80=02^0;A0[T2d@:i0]82\n^0;B0[02d@:_0]42[`;@0[02500002@3203@0ZX2d@:[0]42Z`;B0ZX2dP:R0]42X@;A0Z42d0:R0Q@0\n000T0`P0d0:L0]42W@;A0Yd2dP:L0]82U0;A0Y<2d@:C0]02U08D000090<80=02SP;A0Xl2d@:?0]82\nSP;B0XH2d@:50]42Q@;@0XH2500002@3203@0X02d@:10]42P@;B0X02dP9h0]42M`;A0WL2d09h0Q@0\n000T0`P0d09b0]42L`;A0W<2dP9b0]82JP;A0VT2d@9Y0]02JP8D000090<80=02I0;A0VD2d@9U0]82\nI0;B0U`2d@9K0]42F`;@0U`2500002@3203@0UH2d@9G0]42E`;B0UH2dP9>0]42C@;A0Td2d09>0Q@0\n000T0`P0d0980]42B@;A0TT2dP980]82@0;A0Sl2d@8o0]02@08D000090<80=02>P;A0S/2d@8k0]82\n>P;B0S82d@8a0]42<@;@0S82500002@3203@0R`2d@8]0]42;@;B0R`2dP8T0]428`;A0R<2d08T0Q@0\n000T0`P0d08N0]427`;A0Ql2dP8N0]825P;A0QD2d@8E0]025P8D000090<80=0240;A0Q42d@8A0]82\n40;B0PP2d@870]421`;@0PP21@0000H10@0000@0000]0@L0100002d11P040000l04;00P0000V1Pl0\n1P3ooooo0@0@00009PH?01H0ooooo`00c`8000P2002I10003@8000P0003j0P000P00000000040000\n;@4;00@0000]0@80200002D30P3A0PX2UP@:0P@0000]0@L010000?012`040000;@4600P0000V1Pl0\n1P3ooooo0@070000o0800000000000@0000]0@/020000?X20006000000000P@0000]0@`01`0001P4\n4`;K0P42b@840000;@4600@0003`0@/0100002d11`040000l04<00@0000]0@80100002d10`070000\n6`@n1?X2i@?20P@0000]0@H0100002d11`0300007P0700005P@m1?X2i@?20PD000020@40000L0000\nn`:mo`0000000901000000A00291LVUQK03eMd00003]20XM_V;eMlMRmGL10000000`00@0000]0@/0\n1@0000T200000Pd0000b2^H3`P8100@0`P;U0oT2?@@a02D070000?/2_Ol00000002@0@000004@00B\nE6U]IG<PCVEg859_KF5^0;iRmGO7H_Eg0@000000<0040000;@4<00d0000b2^H3i`8100@0`P;U0oT2\n?@@P01h0100002L1ool@00009PH?01H0ooooo`00U@@002L1002J10003@8000@0000]0@<01`000?`2\n0000000000040000;@4=00D000060@80000D000090<809H42P:G10/2U`@;0YP42P:H1082U`@10YL4\n0@:F1082500002@3202F1?`1U`Cm0IL4o@6H1?`1V0Cd0IL4l`6G1?<1UPCd0A@0000T0`P0UPC^0IL4\nk`6G1>l1V0C^0IP4iP6G1>D1U`CU0IH4iP4D000090<809H4h06G1>41U`CQ0IP4h06H1=P1U`CG0IL4\ne`6F1=P1500002@3202F1=81U`CC0IL4d`6H1=81V0C:0IL4b@6G1<T1UPC:0A@0000T0`P0UPC40IL4\na@6G1<D1V0C40IP4_06G1;/1U`Bk0IH4_04D000090<809H4]P6G1;L1U`Bg0IP4]P6H1:h1U`B]0IL4\n[@6F1:h1500002@3202F1:P1U`BY0IL4Z@6H1:P1V0BP0IL4W`6G19l1UPBP0A@0000T0`P0UPBJ0IL4\nV`6G19/1V0BJ0IP4TP6G1941U`BA0IH4TP4D000090<809H4S06G18d1U`B=0IP4S06H18@1U`B30IL4\nP`6F18@1500002@3202F17h1U`Ao0IL4O`6H17h1V0Af0IL4M@6G17D1UPAf0A@0000T0`P0UPA`0IL4\nL@6G1741V0A`0IP4J06G16L1U`AW0IH4J04D000090<809H4HP6G16<1U`AS0IP4HP6H15X1U`AI0IL4\nF@6F15X1500002@3202F15@1U`AE0IL4E@6H15@1V0A<0IL4B`6G14/1UPA<0A@0000T0`P0UPA60IL4\nA`6G14L1V0A60IP4?P6G13d1U`@m0IH4?P4D000090<809H4>06G13T1U`@i0IP4>06H1301U`@_0IL4\n;`6F1301500002@3202F12X1U`@[0IL4:`6H12X1V0@Y0IL4:06G12P1UP@Y0@D000060@4000040000\n;@4700@0000]0@H010000?013@0800009PH?00H0ooooo`40400002H63`0F0?ooool009D4000U0@00\n80H002X100080000nP80008000000000100002d13@040000;@4200P0000U0`80U`@W0Ad69`440000\n;@4700@0003`0@d0100002d11P0800009PH?00H0ooooo`401`000?`20000000000040000;@4=00P0\n003j0P001P00000000840000;@4>00L0000H12l1X@@M0Hl4100002d11P040000l04=00@0000]0@L0\n10000?013P0@00009PH?01H0ooooo`00c@800:@3003F0P00d`<000P0003j0P001P00000000040000\n;@4=00@0000]0@80200002D30P3A0ZP3d@;>0`@0000]0@L010000?013@040000;@4600P0000V1Pl0\n1P3ooooo0@0@00009PH?01H0ooooo`00T@@00:@3002J1000d`<000P0003j0P001P00000000040000\n;@4=00@0000]0@80200002D30P2E1:P3U@C>0`@0000]0@L010000?013@040000;@4600P0000V1Pl0\n1P3ooooo0@040000;@4200@0000]0@<01`0001/4?PC>1>D3R@@40000;@4600@0000]0@L00`0001h0\n1`0001H4?@C=1>D3R@@500000P410000100002d12`0500002@8000023@00038:iP>9104010291>D3\nc0@m13809@040000;@4<00d0000b2^H3[P@100@0R@CU0l`4?@@P01h0100002L1ool40000;@4200@0\n000]0@<01`0001/4>@;`0=l1R0040000;@4600@0000]0@L00`0001h01`0001H4=`;_0=l1R0050000\n0P410000100002d12`0500002@8000024000038:h06800<010280=l1kP0g0S4^<6DU01<09@040000\n;@4<00d0000b2^01i@0100@0R03O0Nh0=`8P01h0100002L1ool40000;@4200@0000]0@<01`0001/4\nE@7`0?`0R`040000;@4600@0000]0@L00`0001h01`0001H4E07_0?`0R`0500000P410000100002d1\n2`0500002@8000024000038:o@2;00<0102;0?`0kP1D0C4^=FDU01<09@040000;@4<00d0000b2_d0\nj00100@0R`3l0>h0E04P01h0100002L1ool40000;@4200@0000]0@<01`0001/46P?`0<02R0040000\n;@4600@0000]0@L00`0001h01`0001H460?_0<02R00500000P410000100002d12`0500002@800002\n4000038:`@:800<010280<02kP0H0c0^=FDU01<09@040000;@4<00d0000b2/42i@0100@0R0300^h0\n60<P01h0100002L1ool@00009PH?01H0ooooo`00j0000;<0000c0@0040@000P0003j0P001P000000\n00040000;@4=00@0000]0@80200002D30P0=0@/43@7f00@0000]0@<010000?013@070000o0800000\n000000@0000]0@d02P0002@30`0^0OT03P6h0>d0n@040000;@4700@0000]0@H010000?013@080000\n9PH?00H0ooooo`40100002d110040000l04500@0003`0@P010000?012@040000l04:00@0003`0@/0\n10000?0130070000o0800?ooo`0000@0000]0@D020000?X200000000000000@0000]0@P0100002L1\nool800009PH?00H0ooooo`40100002L1ool40000;@4000<000000140000<0000200000/0000@0000\nK@400;T000090000400006d1002i00002P00010000000000000000T0000@0000A0400:l0001B0000\nL0400040000@00001`00000000000000_080000000010P8RD`1i07<0M01U06d00000000000000000\n000000000000000000000000000000000000000000000000000000004P000P00000C080G6P1h0A<0\n40D0052fo7LF]Oag;KGlM`0000200000b6HG00004`0X31<07P00073M5@2Lla80008005Se4P08eQH0\nN04C0?oooomXmA80@0HC02P<4`00000000000;<48AN`Vd/2o?<B01000010NI@1000G07Rg6@000000\n0020?`40000@00002=HF07P14`08eQH0N04C003F5P0`>00000P0041iU05`0`00:P8400004`08eQH0\nN04C07P14`00eQH0N;LI07P14`1`]aT0V04C0;0L5`090000b6HG0:Sd4P2<`1H0`/3dM`40001TMP08\n000002D0000<00000@000580001`0@000P000?3oool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n000400004`08eQH0N04C07P14`00eQH0N;LI07P14`1`]aT0V04C0;0L5`090000b6HG0:Sd4P2<`1H0\n`/3dM`40001TMP08000000SF5P1h0A<0ooooofSe4P101Q<0:0`C000000000000/`@Q5k2KB`;lla80\n4000041iU04001L0N;LI00000000080o0@0001000008eQH0N04C00SF5P1h0A<00=HF030h00002000\n@7VD0G03000Z0P@0000C00SF5P1h0A<0N04C003F5P1h]aT0N04C072g6@0U0000b6HG08Sd4P2K1000\nE<3dM`40000I0;01V`@:?VAf00P000009@0000`0000200004P0000`000010000600000`000000002\n8@0000P0000N00006000000000000000A0400:l0000Q0000200001H0000<0000000007P0000@0000\n00000000000H000030000000000I000030000?ooo`0U0000300000D0080U0000300000P0080:0000\n40000000000000002@000100003Y1`00AP@000T0000@0000j@L004H4001B0000L04000<0000D0000\n2@00000000000000_080000000040P8RD`1i07<0M01U06d000000000000000000000000000000000\n0000000000000000000000000000000000000000100001<02=HF07P14`1h0A<00=HF07Rg6@1h0A<0\nL;LI02D00038IQL0R?@B09/4001D`?Ag0@0001T0/06K10XnI7H020000008eQH0N04C0?oooomXmA80\n@0HC02P<4`00000000000;<48AN`Vd/2o?<B01000010NI@1000G07Rg6@0000000020?`40000@0000\n2=HF07P14`08eQH0N04C003F5P0`>00042;dMlC`oGl0h?eo0@00000000000000000006470000@000\nH@L4O`40001Tm1809@000<QV5`090000b6HG0:Sd4P3n`AH0`/3dM`40001TMP08000002D0000<0000\n0`000180000<00000@000580001`0@0010000:Coool0000000000000002@0@00000000A0019D06T0\nK@1U07<0801>06D0M`0P0580K`1]0640KP0000000000000000000000000000000000000000000000\n0000000000000000000006470000@000H@L4O`40001Tm1809@000<QV5`090000b6HG0:Sd4P3n`AH0\n`/3dM`40001TMP08000000SF5P1h0A<0ooooofSe4P101Q<0:0`C000000000000/`@Q5k2KB`;lla80\n4000041iU04001L0N;LI00000000080o0@0001000008eQH0N04C00SF5P1h0A<00=HF030h000@8_Ag\na?3mO`3PoGl100000000000000000000H@L00010001Q1`Ao0@0006Cd4P0U0000b6HG08Sd4P2d2@00\nE<3dM`40000I0;01]0T:66Af00P000009@0000`000040000600000`0000000022P00010000000000\n000005@0001D000000000000003oooooooooo`40001Y;hM0RTR7@000001`10000@0004`000040000\n00000000003Y1`00AP@00500000P0000:@0002D0000<00001@00P2D0000<00002000P2/0000H0000\n=`000>d3001`0000;@@002L0000H00001@000000003oool0000002D0000<00001@0002H0000L0000\n1P0000000000000000000000000U0000300000H0000Q0000200001h0000H0000=`000>d3001e0000\n<@@00580001`0@001`000:goool0000000000000002@0@00000000A002910780J@1Q06`000000000\n00000000000000000000000000000000000000000000000000000000000000000000000000000000\n000006470000@000H@L4O`40001Tm1809@000<QV5`28m180c?<B0000003U>?Qg000C0>1R7P000000\nZ?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7OX1Q<0j68N0>QR7P2n`QH0j68N041iU04001L0\nN;LI00000000080o0@0001000008eQH0000C00SF5P1h0A<00=HF030h000@8_Aga?3mO`3PoGl10000\n0000000000000000H@L00010001Q1`B00@0006Cd4P3`<OAgH@L4P;<48AMQ1`B0000000B00020m180\nT=;dMfAf00P000009@0000`0000700004P0000`0000100009@0000`000070000E0000600000:0000\nZP0001@0002d00000@0006T_Qd2:B8M0=`000>L300030000C00000@0000g0000k@<007@0000a1000\nE0000200800P00005`0001L0000G0000DP00070100080000]Oooo`00000000000000090100000000\n14004U@0J@1]06D0L`0P04h0I@1g0200DP1_06d0H@1^000000000000000000000000000000000000\n00000000000000000000000000000000H@L00010001Q1`B00@0006Cd4P3`<OAgH@L4P;<48AO<la80\n00000>Dhn7L001<0D>PG0000002Xla80R0HC05cd4P2E:oQg83WhMooooom/m180@;OlMaP74`1Hj1L0\nF>PG08c35P1Hj1L0@7VD0@005`1h]aT000000000P3l10000400000SF5P0001<02=HF07P14`1@j1L0\n<3P0000Rm7L300000>3mO`000000000000000000000001<00`00003X5`0H0000I?@B004000030000\ng?<B0600002Tm180UB_hMaPfn7OoooooI7H02000000U0000300000P0001D0000E000000000000000\nooooooooool10000JBn7@8Y8Qd1l0000kP<00040001<0000100003L0003]0`00M0000344001@0000\n80000280000R000030000?oooolU0000300000D0080U0000300000P0080[0000600005l100330000\nWP4001L1000U0000300000D0000U0000300000H0000Q0000200001h0000H0000G`400<<0002S0@00\n6`400180000<00000@000580001`0@002@000;Goool0000000000000002@0@00000000A002910780\nJ@1Q06`0000000000000000000000000000000000000000000000000000000000000000000000000\n0000000000000000000000004`0300000>PG01P0001Tm1800@0000<0003Lla80c?<B0000003U>?Qg\n000C0>1R7P000000Z?<B08P64`1Lm180UB_hMb0in7OoooooK?@B042go7OX1Q<0j68N0>QR7P3Z`aH0\nj68N041iU04001L0N;LI00000000080o0@0001000008eQH0000C00SF5P1h0A<0D>PG030h000@8_Ag\na?3mO`3PoGl100000000000000000000H@L00010001Q1`B20@0006Cd4P3`<OAgH@L4P[<48AMQ1`B2\n000000B20020m180T=;dMfAf00P000009@0000`000090000600000`000000002E00005@0000o0000\n8@0004D0000_00000@0006T_Qd2:B8M0G`400<@000010000C00000@0001O0@00``000:81000K0@00\nD00007P0800U00009@0000`000080000E00005@0001600008@0004X0000_00000@0006T_Qd2:B8M0\nQ0400<@000010000C00000@0001O0@00``000:81000K0@00D0000200000S00008P0000`0003ooooo\n9P0001`0000:0000000000H000000000000002D0000<00002P0002D0000<00001@00P5L0000T0000\n<@000:D000120@00Y@000080000@0M03o@K@0bD0000<00002000P2P0000<00002P0002L0000H0000\n2P00000000000000000002D0000<00002P0005H0000X0000@P400:00001>0@00Z`0000<0003k1_43\n?0O@0o/6/0<U0000300000H0000U0000300000D0000X0000300000X0000U0000300000D0080U0000\n300000P0080[0000600008D6003_0`00:PL00484000U0000300000D0000U0000300000H0000Q0000\n200001h0000H0000Q@H00>l3000_1`00A`@00180000<00000@0002D0000<00002@0001P0000<0000\n00000U@0001T0000;@400:X000160@00^0000040001Y;hM0RTR7@8D6003`0`00100004`000040000\nQ@H00>l3000^1`00A`@005@0001d06T0K@1U01D0000A0000?`0002X0000U0000300000P0001D0000\nE00004L1002Z0000BP400;P000010000JBn7@8Y8Qd0D1`00l0<00040001<0000100008D6003_0`00\n;PL004L4001@000080000240000R000030000?oooolU0000300000P0080W0000600000X000000000\n00000000000U0000300000X0000C000030000080001F0000?0000880002L0000PP0009h000080000\nd0:V0m42Y`?A0ZL3dP:V0m82WP?A0Yd3d@:M0m02WP=F0000?0000880002J0000PP0009`000080000\nd0:H0m42V@?A0YT3dP:H0m82T0?A0Xl3d@:?0m02T0=F0000?0000880002H0000PP0009T000080000\nd0::0m42R`?A0X/3dP::0m82PP?A0X43d@:10m02PP=F0000?0000880002E0000PP0009L000080000\nd09l0m42O@?A0Wd3dP9l0m82M0?A0W<3d@9c0m02M0=F0000?0000880002C0000PP0009D000080000\nd09^0m42K`?A0Vl3dP9^0m82IP?A0VD3d@9U0m02IP=F0000?0000880002A0000PP00098000080000\nd09P0m42H@?A0V43dP9P0m82F0?A0UL3d@9G0m02F0=F0000?0000880002>0000PP00090000080000\nd09B0m42D`?A0U<3dP9B0m82BP?A0TT3d@990m02BP=F0000?0000880002<0000PP0008h000080000\nd0940m42A@?A0TD3dP940m82?0?A0S/3d@8k0m02?0=F0000?0000880002:0000PP0008/000080000\nd08f0m42=`?A0SL3dP8f0m82;P?A0Rd3d@8]0m02;P=F0000?000088000270000PP0008T000080000\nd08X0m42:@?A0RT3dP8X0m8280?A0Ql3d@8O0m0280=F0000?000088000250000PP0008H000080000\nd08J0m426`?A0Q/3dP8J0m824P?A0Q43d@8A0m024P=F0000?000088000220000PP0008@000080000\nd08<0m423@?A0Pd3dP8<0m8210?A0P<3d@830m0210=F0000?000088000200000PP00088000080000\nd0;n0]42o`;A0_l2dP;n0]82mP;A0_D2d@;e0]02mP9F0000?0000880001n0000PP0007l000080000\nd0;`0]42l@;A0_42dP;`0]82j0;A0^L2d@;W0]02j09F0000?0000880001k0000PP0007d000080000\nd0;R0]42h`;A0^<2dP;R0]82fP;A0]T2d@;I0]02fP9F0000?0000880001i0000PP0007/000080000\nd0;D0]42e@;A0]D2dP;D0]82c0;A0//2d@;;0]02c09F0000?0000880001g0000PP0007P000080000\nd0;60]42a`;A0/L2dP;60]82_P;A0[d2d@:m0]02_P9F0000?0000880001d0000PP0007H000080000\nd0:h0]42^@;A0[T2dP:h0]82/0;A0Zl2d@:_0]02/09F0000?0000880001b0000PP0007@000080000\nd0:Z0]42Z`;A0Z/2dP:Z0]82XP;A0Z42d@:Q0]02XP9F0000?0000880001_0000PP00074000080000\nd0:L0]42W@;A0Yd2dP:L0]82U0;A0Y<2d@:C0]02U09F0000?0000880001]0000PP0006l000080000\nd0:>0]42S`;A0Xl2dP:>0]82QP;A0XD2d@:50]02QP9F0000?0000880001[0000PP0006`000080000\nd0:00]42P@;A0X42dP:00]82N0;A0WL2d@9g0]02N09F0000?0000880001X0000PP0006X000080000\nd09b0]42L`;A0W<2dP9b0]82JP;A0VT2d@9Y0]02JP9F0000?0000880001V0000PP0006P000080000\nd09T0]42I@;A0VD2dP9T0]82G0;A0U/2d@9K0]02G09F0000?0000880001T0000PP0006D000080000\nd09F0]42E`;A0UL2dP9F0]82CP;A0Td2d@9=0]02CP9F0000?0000880001Q0000PP0006<000080000\nd0980]42B@;A0TT2dP980]82@0;A0Sl2d@8o0]02@09F0000?0000880001O0000PP00064000080000\nd08j0]42>`;A0S/2dP8j0]82<P;A0S42d@8a0]02<P9F0000?0000880001M0000PP0005h000080000\nd08/0]42;@;A0Rd2dP8/0]8290;A0R<2d@8S0]02909F0000?0000880001J0000PP0005`000080000\nd08N0]427`;A0Ql2dP8N0]825P;A0QD2d@8E0]025P9F0000?0000880001H0000PP0005T000080000\nd08@0]424@;A0Q42dP8@0]8220;A0PL2d@870]02208C000030000040000U0000300000H0000U0000\n300000D0000X0000300000X0000V0000700000X0000000000P000000000000009@0000`0000:0000\n9@0000`000050020E`0002@000220000F0000=@0001H00000P000=422P:F10X29@0000`000060000\n:00000`0000:00009@0000`0000500009`0001P0000:000000000000000000009@0000`0000:0000\n9P0001`0000;0000000000H00000000000000RD0000<00002`0002X0000H0000b@800042003E0P00\n3@8002D0000<00001@0002P0000<00002P0002D0000<00001P0002P0000<00002`0002D0000<0000\n1@00P2D0000<00002000P2/0000H0000`P800>D3003e0P00>0@002D0000<00001@0002D0000<0000\n1P000240000800007P0001P000320P00i@<00?X2000m10004P0000`000010000DP000701000;0000\n_Oooo`0000000000000009010000000014008T40LP1Y0640K0000000000000000000000000000000\n0000000000000000000000000000000000000000000001P0`1DH000000000000H@L00010001Q1`B2\n0@0006Cd4P3`<OAgH@L4P[<48AO<la8000000>Dhn7L001<0D>PG0000002Xla80R0HC05cd4P2E:oQg\n000C00@00000m180@;OlMaP74`01j1L00P0006Sc4P000000<?@B0000n7LH=_Qgoooood3d4P22LnQg\n000C000000305AP0gPP`Jl0E600PP?Mg0@00010Rm7O4l?eo0>3mO`400000000000000000001Q1`00\n0400064718P10000I?@B0?0am7MQ1`B8/`@Q5f4718P0000018P0083d4P2@d_AgI7H02000000U0000\n300000/0000H000030000000009D0000E00007l0002Y0000Q@000;H000010000JBn7@8Y8Qd320P00\niP<00040001<000010000<82003U0`00n@8003d4001@0000<@0002D0001B0000L04000X0002moooo\n0000000000000000T04000000004@00BE01Y06d0I@1c0200CP1U07L0801B06l0K@1Q06h000000000\n00000000000000000000000000000000000000000000000000000000001Q1`000400064718P10000\nI?@B0?0am7MQ1`B8/`@Q5lcc4P000000iCShM`004`3PHQh000000:Sc4P281Q<0G?@B09D[n7LP>OQg\nooooofcd4P10]oagj0HC0>QR7P3XHQh0e/`F0>QR7P0`m180003hMaPfn7Oooooo@?@B089cj7L001<0\n000000004`3N231[`1DH0220mgL1000002;dM`800000h?eo0@00000000000000000000004`020000\n068N0100001Tm1800@000040003Lla80E0000:Cd4P2E:oQg63KhMooooomTMP08000002D0000<0000\n2P0005@0001D0000QP000:T000280000]P000040001Y;hM0RTR7@>L2003V0`000@0004`000040000\n`P800>D3003i0P00?@@00500000P00007P000280000<0000ooooobD0000<00002000P2L0000H0000\n3000000000000000000002D0000<0000300001<0000<00000P0005H0000l0000e00005L0003D0000\nF00000P0002F10X2U`@;0YL42`:H10X2V0@20YL40@:G1042UP@20UH0000l0000e00005@0003D0000\nEP0000P0002F1?`1U`Cm0IL4o@6H1?`1V0Cd0IL4l`6G1?<1UPCd0EH0000l0000e0000580003D0000\nE00000P0002F1>h1U`C_0IL4k`6H1>h1V0CV0IL4i@6G1>D1UPCV0EH0000l0000e0000500003D0000\nD@0000P0002F1>01U`CQ0IL4h@6H1>01V0CH0IL4e`6G1=L1UPCH0EH0000l0000e00004d0003D0000\nC`0000P0002F1=81U`CC0IL4d`6H1=81V0C:0IL4b@6G1<T1UPC:0EH0000l0000e00004/0003D0000\nC@0000P0002F1<@1U`C50IL4a@6H1<@1V0Bl0IL4^`6G1;/1UPBl0EH0000l0000e00004T0003D0000\nBP0000P0002F1;H1U`Bg0IL4]`6H1;H1V0B^0IL4[@6G1:d1UPB^0EH0000l0000e00004H0003D0000\nB00000P0002F1:P1U`BY0IL4Z@6H1:P1V0BP0IL4W`6G19l1UPBP0EH0000l0000e00004@0003D0000\nAP0000P0002F19X1U`BK0IL4V`6H19X1V0BB0IL4T@6G1941UPBB0EH0000l0000e0000440003D0000\n@`0000P0002F18`1U`B=0IL4S@6H18`1V0B40IL4P`6G18<1UPB40EH0000l0000e00003l0003D0000\n@@0000P0002F17h1U`Ao0IL4O`6H17h1V0Af0IL4M@6G17D1UPAf0EH0000l0000e00003d0003D0000\n?P0000P0002F1701U`Aa0IL4L@6H1701V0AX0IL4I`6G16L1UPAX0EH0000l0000e00003X0003D0000\n?00000P0002F1681U`AS0IL4H`6H1681V0AJ0IL4F@6G15T1UPAJ0EH0000l0000e00003P0003D0000\n>P0000P0002F15@1U`AE0IL4E@6H15@1V0A<0IL4B`6G14/1UPA<0EH0000l0000e00003H0003D0000\n=`0000P0002F14H1U`A70IL4A`6H14H1V0@n0IL4?@6G13d1UP@n0EH0000l0000e00003<0003D0000\n=@0000P0002F13P1U`@i0IL4>@6H13P1V0@`0IL4;`6G12l1UP@`0EH0000l0000e0000380003D0000\n<`0000P0002F12X1U`@[0IL4:`6H12X1V0@Y0IL4:06G12P1UP@Y0A<0000<00000@0002D0000<0000\n1P0002D0000<00001@0002P0000<0000300002H0000L0000300000000002000000000000000U0000\n300000`0000U0000300000D0081G000090000=@0000b00006P40038000020000U`@W0Ad69`4U0000\n300000H0000X0000300000`0000U0000300000D0000W0000600000`00000000000000000000U0000\n300000`0000V0000700000d0000000001P000000000000029@0000`0000=0000:P0001P0002?1000\n7@4009/4000Y0@009@0000`000050000:00000`0000<00009@0000`000060000:00000`0000=0000\n9P0001`0000=0000000000H000000000000002D0000<00003@0002D0000<00001@00P5L0000T0000\nPP0009h000220000Y@000080003A0ZP3d@;>0bD0000<00001P0002P0000<00003@0002D0000<0000\n1@0002H0000L00003@0000000006000000000000000U0000300000d0000U0000300000D0081G0000\n90000=<0002N0000d`000:D000020000U@BX0iD4cP<U0000300000H0000X0000300000d0000U0000\n300000D0000U0000300000D0080U0000300000P0080[0000600008T4003U0`00b0@003P4000U0000\n300000D0000U0000300000H0000Q0000200001h0000H0000R@@00>D3003=1000?@@00180000<0000\n0@0002D0000<00002`0001P0000<000000000U@0001D0000d@000:T0003G0000]P000040001Y;hM0\nRTR7@8T4003V0`000@0004`000040000R@@00>D3003<1000?@@00500000b02009@0002D0000<0000\n2P0005@0001D0000f0000:T0003L0000]P000040001Y;hM0RTR7@:h4003V0`000@0004`000040000\nR@@00>D3003<1000?@@00500000P00007P000280000<0000ooooobD0000<00001@00P2D0000<0000\n2000P2/0000H0000R0000=l1003Z0000<`8002D0000<00001@0002D0000<00001P00024000080000\n7P0001P000280000g`400>l0000g0P004P0000`0000100009@0000`0000;0000600000`000000002\nE0000600000I0000D@0002T0001N00000@0006T_Qd2:B8M0R0000>0100030000C00000@000280000\ng`400>h0000g0P00E0000340;P0`00009@0001<0000U00009@0000`0000:0000E00005@0000Y0000\nD@0002X0001N00000@0006T_Qd2:B8M0i@000>0100010000C00000@000280000g`400>h0000g0P00\nD0000200000N00008P0000`0003ooooo9@0000`0000500209@0000`000080020:`0001P0002;0000\no0000>X0001?0@009@0000`0000500009@0000`0000600008@0000P0000N0000600008/0003l0000\nk`0005@1000B000030000040000U0000300000/0000H000030000000009D0000H00001T0000[0000\n:@0003P000010000JBn7@8Y8Qd2;0000o@0000<0001<0000100008/0003l0000kP0005@1001D0000\n<@0^03D0000U00004`0002D0000U0000300000X0001D0000E00002X0000[0000:P0003P000010000\nJBn7@8Y8Qd3X0000o@000040001<0000100008/0003l0000kP0005@1001@0000800P01h0000R0000\n30000?oooolU0000300000D0080U0000300000P0080[0000600008P000300P00jP0001@3000U0000\n300000D0000U0000300000H0000Q0000200001h0000H0000R0000<02003_000060<00180000<0000\n0@0002D0000<00002`0001P0000<000000000U@0001P00006@0007L0000Y0000Q0000040001Y;hM0\nRTR7@8P000310P000`0004`000040000R0000<02003^000060<005@0000`02h0=@0002D0000C0000\n9@0002D0000<00002P0005@0001D0000:@0007L0000Z0000Q0000040001Y;hM0RTR7@>D000310P00\n0@0004`000040000R0000<02003^000060<00500000P00007P000280000<0000ooooobH0000L0000\n3@0000000006000000000000000U0000300000d0000U0000300000D0081G000090000340000Z0000\n<@000:l0000200003@4;10d1mP0U0000300000P0080X0000300000d0000W0000600000d000000000\n00000000000U0000300000d0001F0000:00002/0000O0000=P0002X000030000;P7i00h1^03]0?T0\n9@0000`0000600009@0000`000050000:00000`0000=00009@0000`000030000:00000`000040000\n:00000`000070000:00000`000080000:00000`000090000:00000`0000;0000:00000`0000:0000\n9`0001P0000:000000000?ooo`0000009@0000`0000:00009P0001`0000;00000000000000000000\n000002D0000<00002`000280000<0000ooooob80000<0000ooooobD0000<00000@0002D0000<0000\n1`00P2D0000<00000000P300000<00003`00P2D0000<00003@00P4/0000@0000000000D0000X0000\n30000040000X000030000080000X0000300000<0000X0000300000X0000X0000300000D0000X0000\n300000H0000X0000300000/0000>000050000000000@00005000\n"], "Text", Rule[ImageSize, List[324, 153]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[TextData[List[StyleBox["\nEliminating the double definition conflict between equations in different when-equations in the WhenPriority model by giving the event at time = 2 higher priority than the event at \ntime = 1 through the use of elsewhen in the WhenPriorityX model.", Rule[FontFamily, "Courier New"]], "\n"]], "NumberedFigure"], Cell[TextData[List["However, note that multiple assignments to the same variable within an algorithm section are allowed since only ", StyleBox["the last assignment to the same variable in an algorithm section is counted", Rule[FontSlant, "Italic"]], ".\n"]], "Text"], Cell[TextData[List["class MultipleWhen\n  discrete Real x;\nalgorithm\n  when time >= 2 then   \n", StyleBox["    x := pre(x) + 0.75;    // multiple assignments within the same \n    x := x + 0.75;         // when-statement or algorithm section is allowed", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  elsewhen time >= 1 then  \n    ", StyleBox["x := pre(x) + 1;", Rule[FontColor, RGBColor[0, 0, 1]]], "\n  end when;\nend MultipleWhen;"]], "ModelicaInput"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "4.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[803, 895]], Rule[WindowMargins, List[List[2, Automatic], List[Automatic, 4]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]