List[Null, Null, Null, Null, Null, Null, Null, Notebook[List[Cell[CellGroupData[List[Cell["Game of Life", "Title"], Cell[CellGroupData[List[Cell["Introduction", "Section"], Cell[TextData[List[StyleBox["Rules for the Game of Life:", Rule[FontWeight, "Bold"]], "\n\nLife is played on a grid of square cells--like a chess board but extending infinitely in every direction. A cell can be live or dead. A live cell is shown by putting a marker on its square. A dead cell is shown by leaving the square empty. Each cell in the grid has a neighborhood consisting of the eight cells in every direction including diagonals. To apply one step of the rules, we count the number of live neighbors for each cell. What happens next depends on this number.\nTo apply one step of the rules, we count the number of live neighbors for each cell. What happens next depends on this number.\n- A dead cell with exactly three live neighbors becomes a live cell (birth). \n\n", Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool00300oooo000`0?ooo`00<03oool00300oooo000`\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00300oooo00060?ooo`@0\n003h303oool40?Sl00`0oooo10000?P60?ooo`00103oool80000n0P0oooo\n203ho0080?ooo`P0003h103oool000<0oooo2P000?P60?ooo`X0n?`01P3o\nool:0000n0<0oooo00020?ooo``0003h103oool<0?Sl00@0oooo30000?P2\n0?ooo`000P3oool<0000n0@0oooo103ho0040000n0@0n?`0103oool<0000\nn080oooo00000`3oool0003h0000n00<0000n080oooo103ho0060000n0@0\nn?`00P3oool>0000n040oooo00000`3oool0003h0000n00<0000n080oooo\n103ho0060000n0@0n?`00P3oool>0000n040oooo00000`3oool0003h0000\nn00<0000n080oooo103ho0060000n0@0n?`00P3oool>0000n040oooo0000\n0`3oool0003h0000n00<0000n080oooo103ho0060000n0@0n?`00P3oool>\n0000n040oooo00020?ooo``0003h103oool40?Sl00@0003h103ho0040?oo\no``0003h0P3oool00080oooo30000?P40?ooo``0n?`0103oool<0000n080\noooo00030?ooo`X0003h1P3oool:0?Sl00H0oooo2P000?P30?ooo`00103o\nool80000n0P0oooo203ho0080?ooo`P0003h103oool000H0oooo10000?P<\n0?ooo`@0n?`0303oool40000n0H0oooo000`0?ooo`00<03oool000H0oooo\n10000?PV0?ooo`00103oool80000n2@0oooo00030?ooo`X0003h8`3oool0\n0080oooo30000?PR0?ooo`000P3oool<0000n280oooo00000`3oool0003h\n0000n00<0000n240oooo00000`3oool0003h0000n00<0000n240oooo0000\n0`3oool0003h0000n00<0000n240oooo00000`3oool0003h0000n00<0000\nn240oooo00020?ooo``0003h8P3oool00080oooo30000?PR0?ooo`000`3o\nool:0000n2<0oooo00040?ooo`P0003h903oool000H0oooo10000?PV0?oo\no`00<03oool00001"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool000H0oooo10000?PV0?ooo`00103oool80000n2@0\noooo00030?ooo`X0003h8`3oool00080oooo30000?PR0?ooo`000P3oool<\n0000n280oooo00000`3oool0003h0000n00<0000n240oooo00000`3oool0\n003h0000n00<0000n240oooo00000`3oool0003h0000n00<0000n240oooo\n00000`3oool0003h0000n00<0000n240oooo00020?ooo``0003h8P3oool0\n0080oooo30000?PR0?ooo`000`3oool:0000n2<0oooo00040?ooo`P0003h\n903oool000H0oooo10000?PV0?ooo`00<03oool00300oooo00060?ooo`@0\n003h303oool40?Sl01H0oooo00040?ooo`P0003h203oool80?Sl01@0oooo\n00030?ooo`X0003h1P3oool:0?Sl01<0oooo00020?ooo``0003h103oool<\n0?Sl0180oooo00020?ooo``0003h103oool40?Sl00@0003h103ho00B0?oo\no`0000<0oooo0000n0000?P030000?P20?ooo`@0n?`01P000?P40?Sl0140\noooo00000`3oool0003h0000n00<0000n080oooo103ho0060000n0@0n?`0\n4@3oool000030?ooo`000?P0003h00`0003h0P3oool40?Sl00H0003h103h\no00A0?ooo`0000<0oooo0000n0000?P030000?P20?ooo`@0n?`01P000?P4\n0?Sl0140oooo00020?ooo``0003h103oool40?Sl00@0003h103ho00B0?oo\no`000P3oool<0000n0@0oooo303ho00B0?ooo`000`3oool:0000n0H0oooo\n2P3ho00C0?ooo`00103oool80000n0P0oooo203ho00D0?ooo`001P3oool4\n0000n0`0oooo103ho00F0?ooo`00<03oool00300oooo00060?ooo`@0003h\n9P3oool000@0oooo20000?PT0?ooo`000`3oool:0000n2<0oooo00020?oo\no``0003h8P3oool00080oooo30000?PR0?ooo`0000<0oooo0000n0000?P0\n30000?PQ0?ooo`0000<0oooo0000n0000?P030000?PQ0?ooo`0000<0oooo\n0000n0000?P030000?PQ0?ooo`0000<0oooo0000n0000?P030000?PQ0?oo\no`000P3oool<0000n280oooo00020?ooo``0003h8P3oool000<0oooo2P00\n0?PS0?ooo`00103oool80000n2@0oooo00060?ooo`@0003h9P3oool00300\noooo0000"], "Graphics", Rule[GeneratedCell, False], Rule[CellAutoOverwrite, False], Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], "\n\nA live cell with two or three live neighbors stays alive (survival). \n\n", Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool00300oooo000`0?ooo`00<03oool00300oooo000`\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00300oooo00060?ooo`@0\n003h303oool40000n0`0oooo10000?P60?ooo`00103oool80000n0P0oooo\n20000?P80?ooo`P0003h103oool000<0oooo2P000?P60?ooo`X0003h1P3o\nool:0000n0<0oooo00020?ooo``0003h103oool<0000n0@0oooo30000?P2\n0?ooo`000P3oool<0000n0@0oooo30000?P40?ooo``0003h0P3oool00003\n0?ooo`000?P0003h00`0003h0P3oool>0000n080oooo3P000?P10?ooo`00\n00<0oooo0000n0000?P030000?P20?ooo`h0003h0P3oool>0000n040oooo\n00000`3oool0003h0000n00<0000n080oooo3P000?P20?ooo`h0003h0@3o\nool000030?ooo`000?P0003h00`0003h0P3oool>0000n080oooo3P000?P1\n0?ooo`000P3oool<0000n0@0oooo30000?P40?ooo``0003h0P3oool00080\noooo30000?P40?ooo``0003h103oool<0000n080oooo00030?ooo`X0003h\n1P3oool:0000n0H0oooo2P000?P30?ooo`00103oool80000n0P0oooo2000\n0?P80?ooo`P0003h103oool000H0oooo10000?P<0?ooo`@0003h303oool4\n0000n0H0oooo000`0?ooo`00<03oool00300oooo000`0?ooo`00<03oool0\n0300oooo000`0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300\noooo000`0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00001"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool000H0oooo10000?PV0?ooo`00103oool80000n2@0\noooo00030?ooo`X0003h8`3oool00080oooo30000?PR0?ooo`000P3oool<\n0000n280oooo00000`3oool0003h0000n00<0000n240oooo00000`3oool0\n003h0000n00<0000n240oooo00000`3oool0003h0000n00<0000n240oooo\n00000`3oool0003h0000n00<0000n240oooo00020?ooo``0003h8P3oool0\n0080oooo30000?PR0?ooo`000`3oool:0000n2<0oooo00040?ooo`P0003h\n903oool000H0oooo10000?PV0?ooo`00<03oool00300oooo00060?ooo`@0\n003h303oool40000n1H0oooo00040?ooo`P0003h203oool80000n1@0oooo\n00030?ooo`X0003h1P3oool:0000n1<0oooo00020?ooo``0003h103oool<\n0000n180oooo00020?ooo``0003h103oool<0000n180oooo00000`3oool0\n003h0000n00<0000n080oooo3P000?PA0?ooo`0000<0oooo0000n0000?P0\n30000?P20?ooo`h0003h4@3oool000030?ooo`000?P0003h00`0003h0P3o\nool>0000n140oooo00000`3oool0003h0000n00<0000n080oooo3P000?PA\n0?ooo`000P3oool<0000n0@0oooo30000?PB0?ooo`000P3oool<0000n0@0\noooo30000?PB0?ooo`000`3oool:0000n0H0oooo2P000?PC0?ooo`00103o\nool80000n0P0oooo20000?PD0?ooo`001P3oool40000n0`0oooo10000?PF\n0?ooo`00<03oool00300oooo00060?ooo`@0003h9P3oool000@0oooo2000\n0?PT0?ooo`000`3oool:0000n2<0oooo00020?ooo``0003h8P3oool00080\noooo30000?PR0?ooo`0000<0oooo0000n0000?P030000?PQ0?ooo`0000<0\noooo0000n0000?P030000?PQ0?ooo`0000<0oooo0000n0000?P030000?PQ\n0?ooo`0000<0oooo0000n0000?P030000?PQ0?ooo`000P3oool<0000n280\noooo00020?ooo``0003h8P3oool000<0oooo2P000?PS0?ooo`00103oool8\n0000n2@0oooo00060?ooo`@0003h9P3oool00300oooo0000"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool001H0oooo10000?P<0?ooo`@0003h1P3oool001@0\noooo20000?P80?ooo`P0003h103oool001<0oooo2P000?P60?ooo`X0003h\n0`3oool00180oooo30000?P40?ooo``0003h0P3oool00180oooo30000?P4\n0?ooo``0003h0P3oool00140oooo3P000?P20?ooo`h0003h0@3oool00140\noooo3P000?P20?ooo`h0003h0@3oool00140oooo3P000?P20?ooo`h0003h\n0@3oool00140oooo3P000?P20?ooo`h0003h0@3oool00180oooo30000?P4\n0?ooo``0003h0P3oool00180oooo30000?P40?ooo``0003h0P3oool001<0\noooo2P000?P60?ooo`X0003h0`3oool001@0oooo20000?P80?ooo`P0003h\n103oool001H0oooo10000?P<0?ooo`@0003h1P3oool00300oooo000`0?oo\no`005P3oool40000n0`0oooo10000?P60?ooo`00503oool80000n0P0oooo\n20000?P40?ooo`004`3oool:0000n0H0oooo2P000?P30?ooo`004P3oool<\n0000n0@0oooo30000?P20?ooo`004P3oool<0000n0@0oooo30000?P20?oo\no`004@3oool>0000n080oooo3P000?P10?ooo`004@3oool>0000n080oooo\n3P000?P10?ooo`004@3oool>0000n080oooo3P000?P10?ooo`004@3oool>\n0000n080oooo3P000?P10?ooo`004P3oool<0000n0@0oooo30000?P20?oo\no`004P3oool<0000n0@0oooo30000?P20?ooo`004`3oool:0000n0H0oooo\n2P000?P30?ooo`00503oool80000n0P0oooo20000?P40?ooo`005P3oool4\n0000n0`0oooo10000?P60?ooo`00<03oool00300oooo000`0?ooo`00<03o\nool00300oooo000`0?ooo`00<03oool00300oooo000`0?ooo`00<03oool0\n0300oooo000`0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300\noooo0000"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], "\n\nIn all other cases, a cell dies or remains dead (overcrowding or loneliness). \n\n", Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool00300oooo000`0?ooo`00<03oool00300oooo000`\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00100oooo0P3h000=0?oo\no`030?P0003oool0oooo00h0oooo000@0?ooo`<0n0000`3oool40000n0<0\noooo0`3h000@0?ooo`004@3oool30?P000P0003h0`3h000A0?ooo`004P3o\nool30?P000H0003h0`3h000B0?ooo`004P3oool010000?P0n0000?P0003h\n00040000n0<0n00000<0003h0?ooo`3oool0403oool00180oooo0P000?P3\n0?P00080003h0`3h00020000n180oooo000A0?ooo`@0003h1P3h00040000\nn140oooo000A0?ooo`D0003h103h00050000n140oooo000A0?ooo`D0003h\n103h00050000n140oooo000A0?ooo`@0003h1P3h00040000n140oooo000B\n0?ooo`80003h0`3h00020000n0<0n0000P000?PB0?ooo`004P3oool01000\n0?P0n0000?P0003h00040000n0<0n00000<0003h0?ooo`3oool0403oool0\n0180oooo0`3h00060000n0<0n0004P3oool00140oooo0`3h00080000n0<0\nn0004@3oool00100oooo0`3h00030?ooo`@0003h0`3oool30?P00100oooo\n000@0?ooo`80n000303oool20?P00100oooo000`0?ooo`009P3oool40000\nn0H0oooo000T0?ooo`P0003h103oool002<0oooo2P000?P30?ooo`008P3o\nool<0000n080oooo000R0?ooo``0003h0P3oool00240oooo3P000?P10?oo\no`008@3oool>0000n040oooo000Q0?ooo`h0003h0@3oool00240oooo3P00\n0?P10?ooo`008P3oool<0000n080oooo000R0?ooo``0003h0P3oool002<0\noooo2P000?P30?ooo`00903oool80000n0@0oooo000V0?ooo`@0003h1P3o\nool00300oooo0000"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool00300oooo000`0?ooo`00<03oool00300oooo000`\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00100oooo0P3h000=0?oo\no`030?P0003oool0oooo00h0oooo00060?ooo`@0003h1P3oool30?P000<0\noooo10000?P30?ooo`<0n000403oool000@0oooo20000?P50?ooo`<0n000\n20000?P30?P00140oooo00030?ooo`X0003h1@3oool30?P000H0003h0`3h\n000B0?ooo`000P3oool<0000n0@0oooo00@0003h0?P0003h0000n0001000\n0?P30?P000030000n03oool0oooo0100oooo00020?ooo``0003h103oool2\n0000n0<0n0000P000?P30?P00080003h4P3oool000030?ooo`000?P0003h\n00`0003h0P3oool40000n0H0n00010000?PA0?ooo`0000<0oooo0000n000\n0?P030000?P20?ooo`D0003h103h00050000n140oooo00000`3oool0003h\n0000n00<0000n080oooo1@000?P40?P000D0003h4@3oool000030?ooo`00\n0?P0003h00`0003h0P3oool40000n0H0n00010000?PA0?ooo`000P3oool<\n0000n0@0oooo0P000?P30?P00080003h0`3h00020000n180oooo00020?oo\no``0003h103oool010000?P0n0000?P0003h00040000n0<0n00000<0003h\n0?ooo`3oool0403oool000<0oooo2P000?P50?ooo`<0n0001P000?P30?P0\n0180oooo00040?ooo`P0003h1@3oool30?P000P0003h0`3h000A0?ooo`00\n1P3oool40000n0H0oooo0`3h00030?ooo`@0003h0`3oool30?P00100oooo\n000@0?ooo`80n000303oool20?P00100oooo000`0?ooo`001P3oool40000\nn0`0oooo10000?P<0?ooo`@0003h1P3oool000@0oooo20000?P80?ooo`P0\n003h203oool80000n0@0oooo00030?ooo`X0003h1P3oool:0000n0H0oooo\n2P000?P30?ooo`000P3oool<0000n0@0oooo30000?P40?ooo``0003h0P3o\nool00080oooo30000?P40?ooo``0003h103oool<0000n080oooo00000`3o\nool0003h0000n00<0000n080oooo3P000?P20?ooo`h0003h0@3oool00003\n0?ooo`000?P0003h00`0003h0P3oool>0000n080oooo3P000?P10?ooo`00\n00<0oooo0000n0000?P030000?P20?ooo`h0003h0P3oool>0000n040oooo\n00000`3oool0003h0000n00<0000n080oooo3P000?P20?ooo`h0003h0@3o\nool00080oooo30000?P40?ooo``0003h103oool<0000n080oooo00020?oo\no``0003h103oool<0000n0@0oooo30000?P20?ooo`000`3oool:0000n0H0\noooo2P000?P60?ooo`X0003h0`3oool000@0oooo20000?P80?ooo`P0003h\n203oool80000n0@0oooo00060?ooo`@0003h303oool40000n0`0oooo1000\n0?P60?ooo`00<03oool00001"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool00300oooo000`0?ooo`00<03oool00300oooo000`\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00300oooo00060?ooo`@0\n003h703oool40000n0H0oooo00040?ooo`P0003h603oool80000n0@0oooo\n00030?ooo`X0003h5P3oool:0000n0<0oooo00020?ooo``0003h503oool<\n0000n080oooo00020?ooo``0003h503oool<0000n080oooo00000`3oool0\n003h0000n00<0000n180oooo3P000?P10?ooo`0000<0oooo0000n0000?P0\n30000?PB0?ooo`h0003h0@3oool000030?ooo`000?P0003h00`0003h4P3o\nool>0000n040oooo00000`3oool0003h0000n00<0000n180oooo3P000?P1\n0?ooo`000P3oool<0000n1@0oooo30000?P20?ooo`000P3oool<0000n1@0\noooo30000?P20?ooo`000`3oool:0000n1H0oooo2P000?P30?ooo`00103o\nool80000n1P0oooo20000?P40?ooo`001P3oool40000n1`0oooo10000?P6\n0?ooo`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?oo\no`00<03oool00300oooo000`0?ooo`00<03oool00300oooo000`0?ooo`00\n<03oool00300oooo000`0?ooo`00<03oool00300oooo0000"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], Cell[GraphicsData["Bitmap", "CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40000`0000<2000`400?l0\n0000o`00003o<03oool002H0oooo10000?P60?ooo`00903oool80000n0@0\noooo000S0?ooo`X0003h0`3oool00280oooo30000?P20?ooo`008P3oool<\n0000n080oooo000Q0?ooo`h0003h0@3oool00240oooo3P000?P10?ooo`00\n8@3oool>0000n040oooo000Q0?ooo`h0003h0@3oool00280oooo30000?P2\n0?ooo`008P3oool<0000n080oooo000S0?ooo`X0003h0`3oool002@0oooo\n20000?P40?ooo`009P3oool40000n0H0oooo000`0?ooo`00<03oool000H0\noooo10000?PV0?ooo`00103oool80000n2@0oooo00030?ooo`X0003h8`3o\nool00080oooo30000?PR0?ooo`000P3oool<0000n280oooo00000`3oool0\n003h0000n00<0000n240oooo00000`3oool0003h0000n00<0000n240oooo\n00000`3oool0003h0000n00<0000n240oooo00000`3oool0003h0000n00<\n0000n240oooo00020?ooo``0003h8P3oool00080oooo30000?PR0?ooo`00\n0`3oool:0000n2<0oooo00040?ooo`P0003h903oool000H0oooo10000?PV\n0?ooo`00<03oool00300oooo00060?ooo`@0003h703oool40000n0H0oooo\n00040?ooo`P0003h603oool80000n0@0oooo00030?ooo`X0003h5P3oool:\n0000n0<0oooo00020?ooo``0003h503oool<0000n080oooo00020?ooo``0\n003h503oool<0000n080oooo00000`3oool0003h0000n00<0000n180oooo\n3P000?P10?ooo`0000<0oooo0000n0000?P030000?PB0?ooo`h0003h0@3o\nool000030?ooo`000?P0003h00`0003h4P3oool>0000n040oooo00000`3o\nool0003h0000n00<0000n180oooo3P000?P10?ooo`000P3oool<0000n1@0\noooo30000?P20?ooo`000P3oool<0000n1@0oooo30000?P20?ooo`000`3o\nool:0000n1H0oooo2P000?P30?ooo`00103oool80000n1P0oooo20000?P4\n0?ooo`001P3oool40000n1`0oooo10000?P60?ooo`00<03oool00001"], "Graphics", Rule[ImageSize, List[48, 48]], Rule[ImageMargins, List[List[0, 0], List[0, 0]]], Rule[ImageRegion, List[List[0, 1], List[0, 1]]]], "\n\n", StyleBox["Note:", Rule[FontWeight, "Bold"]], " The number of live neighbors is always based on the cells ", StyleBox["before", Rule[FontWeight, "Bold"], Rule[FontSlant, "Italic"], Rule[FontColor, RGBColor[0, 0, 0.996109`]]], " the rule was applied. In other words, we must first find all of the cells that change before changing any of them. Sounds like a job for a computer!", StyleBox[" ", Rule[FontSize, 14]], "\n"]], "Text"]], Open]], Cell[CellGroupData[List[Cell["Game of Life", "Section"], Cell["model GameOfLife\n  parameter Integer n = 10;\n  parameter Integer initialAlive[:,2] = {{2,2},{2,1},{1,2},{3,3},{3,2}};\n  discrete Integer lifeHistory[n,n](start=zeros(n,n));\n  Boolean init = initial();\nequation\n when {init, sample(0.1,0.1)} then\n   if edge(init) then \n      lifeHistory = firstGeneration(pre(lifeHistory), initialAlive);\n   else\n     lifeHistory = nextGeneration(pre(lifeHistory));\n   end if;\n end when;\nend GameOfLife;", "ModelicaInput"], Cell["", "Text"], Cell["function firstGeneration\n  input Integer M[:,:];\n  input Integer I[:,2];\n  output Integer G[size(M,1), size(M,1)] := M; \nalgorithm\n for i in 1:size(I,1) loop\n      G[I[i,1], I[i,2]] := 1;\n end for;\nend firstGeneration;", "ModelicaInput"], Cell["", "Text"], Cell["function nextGeneration\n  input Integer M[:,:];\n  output Integer G[size(M,1), size(M,1)]; \n  protected\n  Integer iW, iE, jN, jS, borderSum;\n  parameter Integer n = size(M,1);\nalgorithm\n  for i in 1:n loop\n    for j in 1:n loop\n      iW := mod(i-2+n, n) + 1; \n      iE := mod(i+n, n) + 1;\n      jN := mod(j+n, n) + 1; \n      jS := mod(j-2+n, n) + 1;\n      borderSum := M[iW,j] + M[iE,j] + M[iW,jS] + M[i,jS] + M[iE,jS] + M[iW,jN] + M[i,jN] + M[iE,jN];\n      if borderSum == 3 then\n        G[i,j] := 1;\n      elseif borderSum == 2 then\n        G[i,j] := M[i,j];\n      else G[i,j] := 0;\n      end if;\n    end for;\n  end for;\nend nextGeneration;", "ModelicaInput"], Cell[CellGroupData[List[Cell["Animation of GameOfLife", "Subsection"], Cell[BoxData[RowBox[List[RowBox[List["PlotGameOfLife", "[", "table_", "]"]], ":=", RowBox[List["For", "[", RowBox[List[RowBox[List["z", "=", "0"]], ",", RowBox[List["z", "<", "1"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["s", "=", RowBox[List["{", "}"]]]], ";", "\[IndentingNewLine]", RowBox[List["For", "[", RowBox[List[RowBox[List["i", "=", "1"]], ",", RowBox[List["i", "<=", "10"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["s1", "=", RowBox[List["{", "}"]]]], ";", "\[IndentingNewLine]", RowBox[List["For", "[", RowBox[List[RowBox[List["j", "=", "1"]], ",", RowBox[List["j", "<=", "10"]], ",", "\[IndentingNewLine]", RowBox[List[RowBox[List["s1", "=", RowBox[List["Append", "[", RowBox[List["s1", ",", RowBox[List[RowBox[List["table", "\[LeftDoubleBracket]", RowBox[List["j", ",", "i"]], "\[RightDoubleBracket]"]], "[", "z", "]"]]]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["j", "++"]]]]]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["s", "=", RowBox[List["Append", "[", RowBox[List["s", ",", "s1"]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["i", "++"]]]]]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["s", "=", RowBox[List["Reverse", "[", RowBox[List["ReplaceAll", "[", RowBox[List["s", ",", RowBox[List["{", RowBox[List[RowBox[List["0.", "\[Rule]", "1."]], ",", RowBox[List["1.", "\[Rule]", "0."]]]], "}"]]]], "]"]], "]"]]]], ";", "\[IndentingNewLine]", RowBox[List["ListDensityPlot", "[", RowBox[List["s", ",", RowBox[List["Frame", "\[Rule]", "False"]], ",", RowBox[List["AspectRatio", "\[Rule]", "Automatic"]]]], "]"]], ";", "\[IndentingNewLine]", RowBox[List["z", "=", RowBox[List["z", "+", "0.1"]]]]]]]], "]"]]]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Simulation of GameOfLife", "Subsection"], Cell["simulate( GameOfLife );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(GameOfLife\\) : 2004-1-30 16:14:1.3926057 : \\!\\({0.`, 1.`}\\) : 511 data points : 10 events : 114 variables>\\nVariables of range 100 and depth Infinity listed: \\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\\"init\\\", HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(initialAlive \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(10, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(1, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(2, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(3, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(4, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(5, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(6, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(7, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(lifeHistory \[LeftDoubleBracket] \\(\\(8, 6\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["", "Text"], Cell[BoxData[RowBox[List["PlotGameOfLife", "[", "lifeHistory", "]"]]], "Input"]], Open]], Cell[CellGroupData[List[Cell["Test of GameOfLife", "Subsection"], Cell["model test1\n  GameOfLife g(initialAlive = {{1,1},{2,2},{3,3},{4,4},{5,5},{6,6},{7,7},{8,8},{9,9},{10,10},\n  {1,10},{2,9},{3,8},{4,7},{5,6},{6,5},{7,4},{8,3},{9,2},{10,1}});\nend test1;", "ModelicaInput"]], Open]], Cell[CellGroupData[List[Cell["Simulation of test1", "Subsection"], Cell["simulate( test1 );", "ModelicaInput"], Cell[BoxData["\"<SimulationData: \\!\\(test1\\) : 2004-1-30 16:14:10.1269248 : \\!\\({0.`, 1.`}\\) : 505 data points : 4 events : 144 variables>\\nVariables of range 100 and depth Infinity listed: \\!\\({\\*TagBox[\\\"\[UnderBracket]derdummy\\\", HoldForm], \\*TagBox[\\\"\[UnderBracket]dummy\\\", HoldForm], \\*TagBox[\\(g . init\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(11, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(11, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(12, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(12, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(13, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(13, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(14, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(14, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(15, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(15, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(16, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(16, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(17, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(17, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(18, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(18, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(19, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(19, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(20, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(20, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(6, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(6, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(7, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(7, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(8, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(8, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(9, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . initialAlive\\)\\) \[LeftDoubleBracket] \\(\\(9, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(10, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(1, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(2, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(3, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 6\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 7\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 8\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(4, 9\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 1\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 10\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 2\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 3\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 4\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 5\\)\\) \[RightDoubleBracket]\\), HoldForm], \\*TagBox[\\(\\(\\(g . lifeHistory\\)\\) \[LeftDoubleBracket] \\(\\(5, 6\\)\\) \[RightDoubleBracket]\\), HoldForm]}\\)\""], "Output"], Cell["", "Text"], Cell[BoxData[RowBox[List["PlotGameOfLife", "[", RowBox[List["g", ".", "lifeHistory"]], "]"]]], "Input"]], Open]]], Open]]], Open]]], Rule[FrontEndVersion, "5.1 for Microsoft Windows"], Rule[ScreenRectangle, List[List[0, 1280], List[0, 951]]], Rule[WindowSize, List[790, 907]], Rule[WindowMargins, List[List[34, Automatic], List[Automatic, -37]]], Rule[StyleDefinitions, "MathModelica.nb"]], Null, Null, Null, Null, Null]